/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.ToDoubleFunction;
import org.openstreetmap.josm.cli.CLIModule;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.LatLonParser;
import org.openstreetmap.josm.data.projection.CustomProjection;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OptionParser;

public class ProjectionCLI
implements CLIModule {
    public static final ProjectionCLI INSTANCE = new ProjectionCLI();
    private boolean argInverse;
    private boolean argSwitchInput;
    private boolean argSwitchOutput;

    @Override
    public String getActionKeyword() {
        return "project";
    }

    @Override
    public void processArguments(String[] argArray) {
        List<String> positionalArguments = new OptionParser("JOSM projection").addFlagParameter("help", ProjectionCLI::showHelp).addShortAlias("help", "h").addFlagParameter("inverse", () -> {
            this.argInverse = true;
        }).addShortAlias("inverse", "I").addFlagParameter("switch-input", () -> {
            this.argSwitchInput = true;
        }).addShortAlias("switch-input", "r").addFlagParameter("switch-output", () -> {
            this.argSwitchOutput = true;
        }).addShortAlias("switch-output", "s").parseOptionsOrExit(Arrays.asList(argArray));
        ArrayList projParamFrom = new ArrayList();
        ArrayList<String> projParamTo = new ArrayList<String>();
        ArrayList<String> otherPositional = new ArrayList<String>();
        boolean toTokenSeen = false;
        for (String arg : positionalArguments) {
            if (arg.isEmpty()) {
                throw new IllegalArgumentException("non-empty argument expected");
            }
            if (arg.startsWith("+")) {
                if ("+to".equals(arg)) {
                    toTokenSeen = true;
                    continue;
                }
                (toTokenSeen ? projParamTo : projParamFrom).add(arg);
                continue;
            }
            otherPositional.add(arg);
        }
        String fromStr = String.join((CharSequence)" ", projParamFrom);
        String toStr = String.join((CharSequence)" ", projParamTo);
        try {
            this.run(fromStr, toStr, otherPositional);
        }
        catch (IOException | IllegalArgumentException | ProjectionConfigurationException ex) {
            System.err.println(I18n.tr("Error: {0}", ex.getMessage()));
            System.exit(1);
        }
        System.exit(0);
    }

    private static void showHelp() {
        System.out.println(ProjectionCLI.getHelp());
        System.exit(0);
    }

    private static String getHelp() {
        return I18n.tr("JOSM projection command line interface", new Object[0]) + "\n\n" + I18n.tr("Usage", new Object[0]) + ":\n\tjava -jar josm.jar project <options> <crs> +to <crs> [file]\n\n" + I18n.tr("Description", new Object[0]) + ":\n" + I18n.tr("Converts coordinates from one coordinate reference system to another.", new Object[0]) + "\n\n" + I18n.tr("Options", new Object[0]) + ":\n\t--help|-h         " + I18n.tr("Show this help", new Object[0]) + "\n\t-I                " + I18n.tr("Switch input and output crs", new Object[0]) + "\n\t-r                " + I18n.tr("Switch order of input coordinates (east/north, lon/lat)", new Object[0]) + "\n\t-s                " + I18n.tr("Switch order of output coordinates (east/north, lon/lat)", new Object[0]) + "\n\n" + I18n.tr("<crs>", new Object[0]) + ":\n" + I18n.tr("The format for input and output coordinate reference system is similar to that of the PROJ.4 software.", new Object[0]) + "\n\n" + I18n.tr("[file]", new Object[0]) + ":\n" + I18n.tr("Reads input data from one or more files listed as positional arguments. When no files are given, or the filename is \"-\", data is read from standard input.", new Object[0]) + "\n\n" + I18n.tr("Examples", new Object[0]) + ":\n    java -jar josm.jar project +init=epsg:4326 +to +init=epsg:3857 <<<\"11.232274 50.5685716\"\n       => 1250371.1334500168 6545331.055189664\n\n    java -jar josm.jar project +proj=lonlat +datum=WGS84 +to +proj=merc +a=6378137 +b=6378137 +nadgrids=@null <<EOF\n    11d13'56.19\"E 50d34'6.86\"N\n    118d39'30.42\"W 37d20'18.76\"N\n    EOF\n       => 1250371.1334500168 6545331.055189664\n          -1.3208998232319113E7 4486401.160664663\n";
    }

    private void run(String fromStr, String toStr, List<String> files) throws ProjectionConfigurationException, IOException {
        CustomProjection fromProj = ProjectionCLI.createProjection(fromStr);
        CustomProjection toProj = ProjectionCLI.createProjection(toStr);
        if (this.argInverse) {
            CustomProjection tmp = fromProj;
            fromProj = toProj;
            toProj = tmp;
        }
        if (files.isEmpty() || "-".equals(files.get(0))) {
            this.processInput(fromProj, toProj, new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset())));
        } else {
            for (String file : files) {
                BufferedReader br = Files.newBufferedReader(Paths.get(file, new String[0]), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    this.processInput(fromProj, toProj, br);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (br == null) continue;
                    if (throwable != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    br.close();
                }
            }
        }
    }

    private void processInput(CustomProjection fromProj, CustomProjection toProj, BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            EastNorth enIn = fromProj.isGeographic() ? this.parseEastNorth(line, LatLonParser::parseCoordinate) : this.parseEastNorth(line, ProjectionCLI::parseDouble);
            LatLon ll = fromProj.eastNorth2latlon(enIn);
            EastNorth enOut = toProj.latlon2eastNorth(ll);
            double cOut1 = this.argSwitchOutput ? enOut.north() : enOut.east();
            double cOut2 = this.argSwitchOutput ? enOut.east() : enOut.north();
            System.out.println(Double.toString(cOut1) + " " + Double.toString(cOut2));
            System.out.flush();
        }
    }

    private static CustomProjection createProjection(String params) throws ProjectionConfigurationException {
        CustomProjection proj = new CustomProjection();
        proj.update(params);
        return proj;
    }

    private EastNorth parseEastNorth(String s, ToDoubleFunction<String> parser) {
        String[] en = s.split("[;, ]+", -1);
        if (en.length != 2) {
            throw new IllegalArgumentException(I18n.tr("Expected two coordinates, separated by white space, found {0} in ''{1}''", en.length, s));
        }
        double east = parser.applyAsDouble(en[0]);
        double north = parser.applyAsDouble(en[1]);
        if (this.argSwitchInput) {
            return new EastNorth(north, east);
        }
        return new EastNorth(east, north);
    }

    private static double parseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(I18n.tr("Unable to parse number ''{0}''", s), nfe);
        }
    }

    public static void main(String[] args) {
        INSTANCE.processArguments(args);
    }
}

