/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import ch.poole.openinghoursparser.I18n;
import ch.poole.openinghoursparser.OpeningHoursParser;
import ch.poole.openinghoursparser.ParseException;
import ch.poole.openinghoursparser.Rule;
import ch.poole.openinghoursparser.Util;
import java.awt.Component;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.GBC;

public class OpeningHourTest
extends Test.TagTest {
    private static final Collection<String> KEYS_TO_CHECK = Arrays.asList("opening_hours", "collection_times", "service_times");
    private static final BooleanProperty PREF_STRICT_MODE = new BooleanProperty("validator." + OpeningHourTest.class.getSimpleName() + ".strict", false);
    private final JCheckBox checkboxStrictMode = new JCheckBox(org.openstreetmap.josm.tools.I18n.tr("Enable strict mode.", new Object[0]));

    public OpeningHourTest() {
        super(org.openstreetmap.josm.tools.I18n.tr("Opening hours syntax", new Object[0]), org.openstreetmap.josm.tools.I18n.tr("This test checks the correct usage of the opening hours syntax.", new Object[0]));
    }

    private TestError createTestError(Severity severity, String message, String key, String value, String prettifiedValue, OsmPrimitive p) {
        OsmPrimitive[] osmPrimitiveArray;
        TestError.Builder builder = TestError.builder(this, severity, 2901).message(org.openstreetmap.josm.tools.I18n.tr("Opening hours syntax", new Object[0]), message, new Object[0]);
        if (p != null) {
            OsmPrimitive[] osmPrimitiveArray2 = new OsmPrimitive[1];
            osmPrimitiveArray = osmPrimitiveArray2;
            osmPrimitiveArray2[0] = p;
        } else {
            osmPrimitiveArray = new OsmPrimitive[]{};
        }
        TestError.Builder error = builder.primitives(osmPrimitiveArray);
        if (p == null || prettifiedValue == null || prettifiedValue.equals(value)) {
            return error.build();
        }
        return error.fix(() -> new ChangePropertyCommand(p, key, prettifiedValue)).build();
    }

    public List<TestError> checkOpeningHourSyntax(String key, String value) {
        return this.checkOpeningHourSyntax(key, value, null, Locale.getDefault());
    }

    List<TestError> checkOpeningHourSyntax(String key, String value, OsmPrimitive p, Locale locale) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        I18n.setLocale(locale);
        String prettifiedValue = null;
        try {
            boolean strict = PREF_STRICT_MODE.get();
            List<Rule> rules = new OpeningHoursParser(new StringReader(value)).rules(strict);
            prettifiedValue = Util.rulesToOpeningHoursString(rules);
            if (!Objects.equals(value, prettifiedValue) && !strict) {
                new OpeningHoursParser(new StringReader(value)).rules(true);
            }
        }
        catch (ParseException e) {
            return Collections.singletonList(this.createTestError(Severity.WARNING, e.getMessage(), key, value, prettifiedValue, p));
        }
        if (!this.includeOtherSeverityChecks() || Objects.equals(value, prettifiedValue)) {
            return Collections.emptyList();
        }
        String message = org.openstreetmap.josm.tools.I18n.tr("{0} value can be prettified", key);
        return Collections.singletonList(this.createTestError(Severity.OTHER, message, key, value, prettifiedValue, p));
    }

    @Override
    public void check(OsmPrimitive p) {
        if (p.isTagged()) {
            for (String key : KEYS_TO_CHECK) {
                this.errors.addAll(this.checkOpeningHourSyntax(key, p.get(key), p, Locale.getDefault()));
            }
            String keyCovid19 = "opening_hours:covid19";
            if (p.hasTag("opening_hours:covid19") && !p.hasTag("opening_hours:covid19", "same", "restricted", "open", "off")) {
                this.errors.addAll(this.checkOpeningHourSyntax("opening_hours:covid19", p.get("opening_hours:covid19"), p, Locale.getDefault()));
            }
        }
    }

    @Override
    public void addGui(JPanel testPanel) {
        super.addGui(testPanel);
        this.checkboxStrictMode.setSelected(PREF_STRICT_MODE.get());
        testPanel.add((Component)this.checkboxStrictMode, GBC.eol().insets(20, 0, 0, 0));
    }

    @Override
    public boolean ok() {
        super.ok();
        PREF_STRICT_MODE.put(this.checkboxStrictMode.isSelected());
        return false;
    }
}

