/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AddFromSelectionAction;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorActionAccess;
import org.openstreetmap.josm.gui.dialogs.relation.actions.IRelationEditorUpdateOn;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class AddSelectedAfterSelection
extends AddFromSelectionAction {
    private static final long serialVersionUID = 1L;

    public AddSelectedAfterSelection(IRelationEditorActionAccess editorAccess) {
        super(editorAccess, IRelationEditorUpdateOn.MEMBER_TABLE_SELECTION, IRelationEditorUpdateOn.SELECTION_TABLE_CHANGE);
        this.putValue("ShortDescription", I18n.tr("Add all objects selected in the current dataset after the last selected member", new Object[0]));
        new ImageProvider("dialogs/conflict", "copyaftercurrentright").getResource().attachImageIcon(this, true);
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getSelectionTableModel().getRowCount() > 0 && this.getMemberTableModel().getSelectionModel().getMinSelectionIndex() >= 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getMemberTableModel().addMembersAfterIdx(this.filterConfirmedPrimitives(this.getSelectionTableModel().getSelection()), this.getMemberTableModel().getSelectionModel().getMaxSelectionIndex());
        }
        catch (GenericRelationEditor.AddAbortException ex) {
            Logging.trace(ex);
        }
    }
}

