/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.markerlayer;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxLink;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.layer.markerlayer.ButtonMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;

public class WebMarker
extends ButtonMarker {
    private final URL webUrl;

    public WebMarker(LatLon ll, URL webUrl, MarkerLayer parentLayer, double time, double offset) {
        super(ll, "web", parentLayer, time, offset);
        CheckParameterUtil.ensureParameterNotNull(webUrl, "webUrl");
        this.webUrl = webUrl;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String error = OpenBrowser.displayUrl(this.webUrl.toString());
        if (error != null) {
            this.setErroneous(true);
            new Notification("<b>" + I18n.tr("There was an error while trying to display the URL for this marker", new Object[0]) + "</b><br>" + I18n.tr("(URL was: ", new Object[0]) + this.webUrl + ')' + "<br>" + error).setIcon(0).setDuration(Notification.TIME_LONG).show();
        } else {
            this.updateErroneous();
        }
    }

    @Override
    public WayPoint convertToWayPoint() {
        WayPoint wpt = super.convertToWayPoint();
        GpxLink link = new GpxLink(this.webUrl.toString());
        link.type = "web";
        wpt.put("meta.links", Collections.singleton(link));
        return wpt;
    }

    private void updateErroneous() {
        if ("file".equals(this.webUrl.getProtocol())) {
            String path = this.webUrl.getPath();
            try {
                this.setErroneous(path.isEmpty() || !new File(path).exists());
            }
            catch (SecurityException e) {
                Logging.warn(e);
                this.setErroneous(true);
            }
        } else {
            this.setErroneous(false);
        }
    }
}

