/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ChangesetQuery {
    public static final int MAX_CHANGESETS_NUMBER = 100;
    private Integer uid;
    private String userName;
    private Bounds bounds;
    private Date closedAfter;
    private Date createdBefore;
    private Boolean open;
    private Boolean closed;
    private Collection<Long> changesetIds;

    public static ChangesetQuery buildFromUrlQuery(String query) throws ChangesetQueryUrlException {
        return new ChangesetQueryUrlParser().parse(query);
    }

    public static ChangesetQuery forCurrentUser() {
        UserIdentityManager im = UserIdentityManager.getInstance();
        if (im.isAnonymous()) {
            throw new IllegalStateException("anonymous user");
        }
        ChangesetQuery query = new ChangesetQuery();
        if (im.isFullyIdentified()) {
            return query.forUser(im.getUserId());
        }
        return query.forUser(im.getUserName());
    }

    public ChangesetQuery forUser(int uid) {
        if (uid <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "uid", uid));
        }
        this.uid = uid;
        this.userName = null;
        return this;
    }

    public ChangesetQuery forUser(String userName) {
        CheckParameterUtil.ensureParameterNotNull(userName, "userName");
        this.userName = userName;
        this.uid = null;
        return this;
    }

    public boolean isRestrictedToPartiallyIdentifiedUser() {
        return this.userName != null;
    }

    public Boolean getRestrictionToOpen() {
        return this.open;
    }

    public Boolean getRestrictionToClosed() {
        return this.closed;
    }

    public Date getClosedAfter() {
        return DateUtils.cloneDate(this.closedAfter);
    }

    public Date getCreatedBefore() {
        return DateUtils.cloneDate(this.createdBefore);
    }

    public final Collection<Long> getAdditionalChangesetIds() {
        return this.changesetIds != null ? new ArrayList<Long>(this.changesetIds) : Collections.emptyList();
    }

    public final Bounds getBounds() {
        return this.bounds;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isRestrictedToFullyIdentifiedUser() {
        return this.uid > 0;
    }

    public ChangesetQuery inBbox(double minLon, double minLat, double maxLon, double maxLat) {
        if (!LatLon.isValidLon(minLon)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "minLon", minLon));
        }
        if (!LatLon.isValidLon(maxLon)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "maxLon", maxLon));
        }
        if (!LatLon.isValidLat(minLat)) {
            throw new IllegalArgumentException(I18n.tr("Illegal latitude value for parameter ''{0}'', got {1}", "minLat", minLat));
        }
        if (!LatLon.isValidLat(maxLat)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "maxLat", maxLat));
        }
        return this.inBbox(new LatLon(minLon, minLat), new LatLon(maxLon, maxLat));
    }

    public ChangesetQuery inBbox(LatLon min, LatLon max) {
        CheckParameterUtil.ensureParameterNotNull(min, "min");
        CheckParameterUtil.ensureParameterNotNull(max, "max");
        this.bounds = new Bounds(min, max);
        return this;
    }

    public ChangesetQuery inBbox(Bounds bbox) {
        CheckParameterUtil.ensureParameterNotNull(bbox, "bbox");
        this.bounds = bbox;
        return this;
    }

    public ChangesetQuery closedAfter(Date d) {
        CheckParameterUtil.ensureParameterNotNull(d, "d");
        this.closedAfter = DateUtils.cloneDate(d);
        return this;
    }

    public ChangesetQuery closedAfterAndCreatedBefore(Date closedAfter, Date createdBefore) {
        CheckParameterUtil.ensureParameterNotNull(closedAfter, "closedAfter");
        CheckParameterUtil.ensureParameterNotNull(createdBefore, "createdBefore");
        this.closedAfter = DateUtils.cloneDate(closedAfter);
        this.createdBefore = DateUtils.cloneDate(createdBefore);
        return this;
    }

    public ChangesetQuery beingOpen(boolean isOpen) {
        this.open = isOpen;
        return this;
    }

    public ChangesetQuery beingClosed(boolean isClosed) {
        this.closed = isClosed;
        return this;
    }

    public ChangesetQuery forChangesetIds(Collection<Long> changesetIds) {
        CheckParameterUtil.ensureParameterNotNull(changesetIds, "changesetIds");
        if (changesetIds.size() > 100) {
            Logging.warn("Changeset query built with more than 100 changeset ids (" + changesetIds.size() + ')');
        }
        this.changesetIds = changesetIds;
        return this;
    }

    public String getQueryString() {
        StringBuilder sb = new StringBuilder();
        if (this.uid != null) {
            sb.append("user=").append(this.uid);
        } else if (this.userName != null) {
            sb.append("display_name=").append(Utils.encodeUrl(this.userName));
        }
        if (this.bounds != null) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append("bbox=").append(this.bounds.encodeAsString(","));
        }
        if (this.closedAfter != null && this.createdBefore != null) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            SimpleDateFormat df = DateUtils.newIsoDateTimeFormat();
            sb.append("time=").append(df.format(this.closedAfter));
            sb.append(',').append(df.format(this.createdBefore));
        } else if (this.closedAfter != null) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            SimpleDateFormat df = DateUtils.newIsoDateTimeFormat();
            sb.append("time=").append(df.format(this.closedAfter));
        }
        if (this.open != null) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append("open=").append(Boolean.toString(this.open));
        } else if (this.closed != null) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append("closed=").append(Boolean.toString(this.closed));
        } else if (this.changesetIds != null) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append("changesets=").append(this.changesetIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        return sb.toString();
    }

    public String toString() {
        return this.getQueryString();
    }

    public static class ChangesetQueryUrlParser {
        protected int parseUid(String value) throws ChangesetQueryUrlException {
            int id;
            if (value == null || value.trim().isEmpty()) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", value));
            }
            try {
                id = Integer.parseInt(value);
                if (id <= 0) {
                    throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", value));
                }
            }
            catch (NumberFormatException e) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", value), e);
            }
            return id;
        }

        protected boolean parseBoolean(String value, String parameter) throws ChangesetQueryUrlException {
            if (value == null || value.trim().isEmpty()) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", parameter, value));
            }
            switch (value) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", parameter, value));
        }

        protected Date parseDate(String value, String parameter) throws ChangesetQueryUrlException {
            if (value == null || value.trim().isEmpty()) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", parameter, value));
            }
            SimpleDateFormat formatter = DateUtils.newIsoDateTimeFormat();
            try {
                return formatter.parse(value);
            }
            catch (ParseException e) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", parameter, value), e);
            }
        }

        protected Date[] parseTime(String value) throws ChangesetQueryUrlException {
            String[] dates = value.split(",", -1);
            if (dates.length == 0 || dates.length > 2) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "time", value));
            }
            if (dates.length == 1) {
                return new Date[]{this.parseDate(dates[0], "time")};
            }
            if (dates.length == 2) {
                return new Date[]{this.parseDate(dates[0], "time"), this.parseDate(dates[1], "time")};
            }
            return new Date[0];
        }

        protected Collection<Long> parseLongs(String value) {
            if (value == null || value.isEmpty()) {
                return Collections.emptySet();
            }
            return Stream.of(value.split(",", -1)).map(Long::valueOf).collect(Collectors.toSet());
        }

        protected ChangesetQuery createFromMap(Map<String, String> queryParams) throws ChangesetQueryUrlException {
            ChangesetQuery csQuery = new ChangesetQuery();
            block26: for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                String k;
                switch (k = entry.getKey()) {
                    case "uid": {
                        if (queryParams.containsKey("display_name")) {
                            throw new ChangesetQueryUrlException(I18n.tr("Cannot create a changeset query including both the query parameters ''uid'' and ''display_name''", new Object[0]));
                        }
                        csQuery.forUser(this.parseUid(queryParams.get("uid")));
                        continue block26;
                    }
                    case "display_name": {
                        if (queryParams.containsKey("uid")) {
                            throw new ChangesetQueryUrlException(I18n.tr("Cannot create a changeset query including both the query parameters ''uid'' and ''display_name''", new Object[0]));
                        }
                        csQuery.forUser(queryParams.get("display_name"));
                        continue block26;
                    }
                    case "open": {
                        csQuery.beingOpen(this.parseBoolean(entry.getValue(), "open"));
                        continue block26;
                    }
                    case "closed": {
                        csQuery.beingClosed(this.parseBoolean(entry.getValue(), "closed"));
                        continue block26;
                    }
                    case "time": {
                        Date[] dates = this.parseTime(entry.getValue());
                        switch (dates.length) {
                            case 1: {
                                csQuery.closedAfter(dates[0]);
                                continue block26;
                            }
                            case 2: {
                                csQuery.closedAfterAndCreatedBefore(dates[0], dates[1]);
                                continue block26;
                            }
                        }
                        Logging.warn("Unable to parse time: " + entry.getValue());
                        continue block26;
                    }
                    case "bbox": {
                        try {
                            csQuery.inBbox(new Bounds(entry.getValue(), ","));
                            continue block26;
                        }
                        catch (IllegalArgumentException e) {
                            throw new ChangesetQueryUrlException(e);
                        }
                    }
                    case "changesets": {
                        try {
                            csQuery.forChangesetIds(this.parseLongs(entry.getValue()));
                            continue block26;
                        }
                        catch (NumberFormatException e) {
                            throw new ChangesetQueryUrlException(e);
                        }
                    }
                }
                throw new ChangesetQueryUrlException(I18n.tr("Unsupported parameter ''{0}'' in changeset query string", k));
            }
            return csQuery;
        }

        protected Map<String, String> createMapFromQueryString(String query) {
            String[] keyValuePairs;
            HashMap<String, String> queryParams = new HashMap<String, String>();
            for (String keyValuePair : keyValuePairs = query.split("&", -1)) {
                String[] kv = keyValuePair.split("=", -1);
                queryParams.put(kv[0], kv.length > 1 ? kv[1] : "");
            }
            return queryParams;
        }

        public ChangesetQuery parse(String query) throws ChangesetQueryUrlException {
            if (query == null) {
                return new ChangesetQuery();
            }
            String apiQuery = query.trim();
            if (apiQuery.isEmpty()) {
                return new ChangesetQuery();
            }
            return this.createFromMap(this.createMapFromQueryString(apiQuery));
        }
    }

    public static class ChangesetQueryUrlException
    extends Exception {
        public ChangesetQueryUrlException(String message) {
            super(message);
        }

        public ChangesetQueryUrlException(String message, Throwable cause) {
            super(message, cause);
        }

        public ChangesetQueryUrlException(Throwable cause) {
            super(cause);
        }
    }
}

