/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.MaxFragmentLength;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public abstract class DTLSProtocol {
    protected DTLSProtocol() {
    }

    protected void processFinished(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray3 = TlsUtils.readFully(byArray2.length, (InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!Arrays.constantTimeAreEqual((byte[])byArray2, (byte[])byArray3)) {
            throw new TlsFatalAlert(40);
        }
    }

    protected static void applyMaxFragmentLengthExtension(DTLSRecordLayer dTLSRecordLayer, short s) throws IOException {
        if (s >= 0) {
            if (!MaxFragmentLength.isValid(s)) {
                throw new TlsFatalAlert(80);
            }
            int n = 1 << 8 + s;
            dTLSRecordLayer.setPlaintextLimit(n);
        }
    }

    protected static short evaluateMaxFragmentLengthExtension(boolean bl, Hashtable hashtable, Hashtable hashtable2, short s) throws IOException {
        short s2 = TlsExtensionsUtils.getMaxFragmentLengthExtension(hashtable2);
        if (s2 >= 0 && (!MaxFragmentLength.isValid(s2) || !bl && s2 != TlsExtensionsUtils.getMaxFragmentLengthExtension(hashtable))) {
            throw new TlsFatalAlert(s);
        }
        return s2;
    }

    protected static byte[] generateCertificate(TlsContext tlsContext, Certificate certificate, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificate.encode(tlsContext, byteArrayOutputStream, outputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected static byte[] generateSupplementalData(Vector vector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsProtocol.writeSupplementalData(byteArrayOutputStream, vector);
        return byteArrayOutputStream.toByteArray();
    }

    protected static byte[] createVerifyData(TlsContext tlsContext, DTLSReliableHandshake dTLSReliableHandshake, boolean bl) {
        return TlsUtils.calculateVerifyData(tlsContext, dTLSReliableHandshake.getHandshakeHash(), bl);
    }

    protected static void sendCertificateMessage(TlsContext tlsContext, DTLSReliableHandshake dTLSReliableHandshake, Certificate certificate, OutputStream outputStream) throws IOException {
        SecurityParameters securityParameters = tlsContext.getSecurityParametersHandshake();
        if (null != securityParameters.getLocalCertificate()) {
            throw new TlsFatalAlert(80);
        }
        if (null == certificate) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        byte[] byArray = DTLSProtocol.generateCertificate(tlsContext, certificate, outputStream);
        dTLSReliableHandshake.sendMessage((short)11, byArray);
        securityParameters.localCertificate = certificate;
    }

    protected static int validateSelectedCipherSuite(int n, short s) throws IOException {
        switch (TlsUtils.getEncryptionAlgorithm(n)) {
            case -1: 
            case 1: 
            case 2: {
                throw new TlsFatalAlert(s);
            }
        }
        return n;
    }
}

