/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.IrInlineReferenceLocator;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainerKt;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u0010*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u0010*\u00020\u00042\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InlineCallableReferenceToLambdaPhase;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "inlinableReferences", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "expandInlineFieldReferenceToLambda", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "expandInlineFunctionReferenceToLambda", "referencedFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "backend.jvm"})
public final class InlineCallableReferenceToLambdaPhase
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    private Set<IrCallableReference<?>> inlinableReferences;
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        this.inlinableReferences.addAll((Collection)IrInlineReferenceLocator.Companion.scan(this.context, irFile));
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        if (!this.inlinableReferences.contains(expression2) || IrUtilsKt.isLambda(expression2.getOrigin())) {
            return expression2;
        }
        return this.expandInlineFunctionReferenceToLambda(this.context, expression2, ((IrFunctionSymbol)expression2.getSymbol()).getOwner());
    }

    @Override
    @NotNull
    public IrExpression visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        if (!this.inlinableReferences.contains(expression2)) {
            return expression2;
        }
        IrFieldSymbol irFieldSymbol = expression2.getField();
        if ((irFieldSymbol != null ? (IrField)irFieldSymbol.getOwner() : null) == null) {
            IrCallableReference irCallableReference = expression2;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression2.getGetter();
            Intrinsics.checkNotNull(irSimpleFunctionSymbol);
            irExpression = this.expandInlineFunctionReferenceToLambda(this.context, irCallableReference, (IrFunction)irSimpleFunctionSymbol.getOwner());
        } else {
            IrFieldSymbol irFieldSymbol2 = expression2.getField();
            Intrinsics.checkNotNull(irFieldSymbol2);
            irExpression = this.expandInlineFieldReferenceToLambda(this.context, expression2, (IrField)irFieldSymbol2.getOwner());
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression expandInlineFieldReferenceToLambda(JvmBackendContext $this$expandInlineFieldReferenceToLambda, IrPropertyReference expression2, IrField field) {
        void $this$run;
        void startOffset$iv$iv;
        void $this$irBlock$iv$iv;
        void $this$irBlock$iv;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull(scopeWithIr);
        JvmIrBuilder irBuilder = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder($this$expandInlineFieldReferenceToLambda, scopeWithIr.getScope().getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        IrGeneratorWithScope irGeneratorWithScope = irBuilder;
        IrStatementOrigin origin$iv = IrStatementOrigin.LAMBDA.INSTANCE;
        IrType resultType$iv = ((IrExpression)expression2).getType();
        boolean $i$f$irBlock = false;
        void var9_9 = $this$irBlock$iv;
        int n = ((IrExpression)expression2).getStartOffset();
        int endOffset$iv$iv = ((IrExpression)expression2).getEndOffset();
        boolean $i$f$irBlock2 = false;
        IrBlockBuilder this_$iv$iv$iv = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        IrBlockBuilder $this$irBlock = this_$iv$iv$iv;
        boolean bl = false;
        IrFactory $this$buildFun$iv = $this$expandInlineFieldReferenceToLambda.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        Object $this$run$iv = irFunctionBuilder;
        boolean bl4 = false;
        IrFunctionBuilder $this$buildFun = $this$run$iv;
        boolean bl5 = false;
        IrElementBuilderKt.setSourceRange($this$buildFun, expression2);
        $this$buildFun.setOrigin(IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE);
        Name name = Name.identifier("stub_for_inline");
        Intrinsics.checkNotNullExpressionValue(name, "Name.identifier(\"stub_for_inline\")");
        $this$buildFun.setName(name);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "DescriptorVisibilities.LOCAL");
        $this$buildFun.setVisibility(descriptorVisibility);
        $this$buildFun.setReturnType(field.getType());
        $this$buildFun.setSuspend(false);
        IrElementBase irElementBase = DeclarationBuildersKt.buildFunction($this$buildFun$iv, (IrFunctionBuilder)$this$run$iv);
        boolean bl6 = false;
        boolean bl7 = false;
        IrSimpleFunction $this$apply = irElementBase;
        boolean bl8 = false;
        IrDeclarationParent irDeclarationParent = this.getCurrentDeclarationParent();
        if (irDeclarationParent == null) {
            $this$run$iv = "No current declaration parent at " + DumpIrTreeKt.dump$default(expression2, false, 1, null);
            bl4 = false;
            throw (Throwable)new IllegalStateException($this$run$iv.toString());
        }
        $this$apply.setParent(irDeclarationParent);
        IrExpression irExpression = expression2.getDispatchReceiver();
        if (irExpression == null) {
            irExpression = expression2.getExtensionReceiver();
        }
        IrExpression boundReceiver = irExpression;
        IrGetValueImpl receiver = field.isStatic() ? null : (boundReceiver != null ? ExpressionHelpersKt.irGet($this$irBlock, ExpressionHelpersKt.irTemporary$default($this$irBlock, boundReceiver, "receiver", null, null, 12, null)) : ExpressionHelpersKt.irGet($this$irBlock, DeclarationBuildersKt.addValueParameter$default($this$apply, "receiver", IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(field)), null, 4, null)));
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default($this$expandInlineFieldReferenceToLambda, $this$apply.getSymbol(), 0, 0, 6, null);
        boolean bl9 = false;
        boolean bl10 = false;
        DeclarationIrBuilder declarationIrBuilder2 = declarationIrBuilder;
        IrSimpleFunction irSimpleFunction = $this$apply;
        boolean bl11 = false;
        IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody((IrBuilderWithScope)$this$run, ExpressionHelpersKt.irGetField((IrBuilderWithScope)$this$run, receiver, field));
        irSimpleFunction.setBody(irExpressionBody);
        IrSimpleFunction function2 = irElementBase;
        $this$irBlock.unaryPlus(function2);
        irElementBase = new IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), field.getType(), function2.getSymbol(), 0, null, IrStatementOrigin.LAMBDA.INSTANCE);
        bl6 = false;
        bl7 = false;
        $this$apply = irElementBase;
        IrBlockBuilder irBlockBuilder = $this$irBlock;
        boolean bl12 = false;
        IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$apply, expression2);
        Unit unit = Unit.INSTANCE;
        irBlockBuilder.unaryPlus((IrStatement)((Object)irElementBase));
        return this_$iv$iv$iv.doBuild();
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression expandInlineFunctionReferenceToLambda(JvmBackendContext $this$expandInlineFunctionReferenceToLambda, IrCallableReference<?> expression2, IrFunction referencedFunction) {
        void $this$apply;
        void $this$run;
        Object $this$run$iv;
        boolean bl;
        Object object;
        boolean bl2;
        Object object2;
        Object object3;
        void $this$mapTo$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlock$iv$iv;
        void $this$irBlock$iv;
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        Intrinsics.checkNotNull(scopeWithIr);
        JvmIrBuilder irBuilder = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder($this$expandInlineFunctionReferenceToLambda, scopeWithIr.getScope().getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        IrGeneratorWithScope irGeneratorWithScope = irBuilder;
        IrStatementOrigin origin$iv = IrStatementOrigin.LAMBDA.INSTANCE;
        IrType resultType$iv = ((IrExpression)expression2).getType();
        boolean $i$f$irBlock = false;
        void var9_9 = $this$irBlock$iv;
        int n = ((IrExpression)expression2).getStartOffset();
        int endOffset$iv$iv = ((IrExpression)expression2).getEndOffset();
        boolean $i$f$irBlock2 = false;
        IrBlockBuilder this_$iv$iv$iv = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        IrBlockBuilder $this$irBlock = this_$iv$iv$iv;
        boolean bl3 = false;
        Pair<IrValueParameter, IrExpression> boundReceiver = CollectionsKt.singleOrNull(IrUtilsKt.getArgumentsWithIr((IrMemberAccessExpression)expression2));
        IrType irType = expression2.getType();
        if (irType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        }
        int nParams = ((IrSimpleType)irType).getArguments().size() - 1;
        int toDropAtStart = 0;
        if (boundReceiver != null) {
            ++toDropAtStart;
        }
        if (referencedFunction instanceof IrConstructor) {
            ++toDropAtStart;
        }
        Iterable $this$map$iv = CollectionsKt.take(CollectionsKt.drop((Iterable)org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.getAllParameters(referencedFunction), toDropAtStart), nParams);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<IrType> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void parameter;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl4 = false;
            Iterable iterable2 = CollectionsKt.getIndices((Collection)referencedFunction.getTypeParameters());
            List<IrTypeParameter> list2 = referencedFunction.getTypeParameters();
            object2 = parameter.getType();
            boolean $i$f$map2 = false;
            void var34_51 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                IrType irType2;
                void it;
                int item$iv$iv2;
                int n2 = item$iv$iv2 = ((IntIterator)iterator2).nextInt();
                collection = destination$iv$iv2;
                bl2 = false;
                Intrinsics.checkNotNull(expression2.getTypeArgument((int)it));
                collection.add(irType2);
            }
            collection = (List)destination$iv$iv2;
            object = IrTypeUtilsKt.substitute((IrType)object2, list2, (List<? extends IrType>)collection);
            object3.add(object);
        }
        List argumentTypes2 = (List)destination$iv$iv;
        IrFactory $this$buildFun$iv = $this$expandInlineFunctionReferenceToLambda.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        $i$f$mapTo = false;
        boolean bl5 = false;
        IrFunctionBuilder $this$run$iv22 = irFunctionBuilder;
        boolean bl6 = false;
        IrFunctionBuilder $this$buildFun = $this$run$iv22;
        boolean bl7 = false;
        IrElementBuilderKt.setSourceRange($this$buildFun, expression2);
        $this$buildFun.setOrigin(IrDeclarationOrigin.LOCAL_FUNCTION_FOR_LAMBDA.INSTANCE);
        Name name = Name.identifier("stub_for_inlining");
        Intrinsics.checkNotNullExpressionValue(name, "Name.identifier(\"stub_for_inlining\")");
        $this$buildFun.setName(name);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "DescriptorVisibilities.LOCAL");
        $this$buildFun.setVisibility(descriptorVisibility);
        $this$buildFun.setReturnType(referencedFunction.getReturnType());
        $this$buildFun.setSuspend(AdditionalIrUtilsKt.isSuspend(referencedFunction));
        IrElementBase irElementBase = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$run$iv22);
        boolean bl8 = false;
        boolean bl9 = false;
        IrSimpleFunction $this$apply2 = irElementBase;
        boolean bl10 = false;
        IrDeclarationParent irDeclarationParent = this.getCurrentDeclarationParent();
        Intrinsics.checkNotNull(irDeclarationParent);
        $this$apply2.setParent(irDeclarationParent);
        boolean $this$run$iv22 = false;
        for (IrType argumentType : (Iterable)argumentTypes2) {
            void index2;
            IrFunction $this$addValueParameter$iv = $this$apply2;
            boolean $i$f$addValueParameter = false;
            object2 = new IrValueParameterBuilder();
            bl = false;
            boolean bl11 = false;
            $this$run$iv = object2;
            boolean bl12 = false;
            Object $this$addValueParameter = $this$run$iv;
            boolean bl13 = false;
            Name name2 = Name.identifier("" + 'p' + (int)index2);
            Intrinsics.checkNotNullExpressionValue(name2, "Name.identifier(\"p$index\")");
            ((IrDeclarationBuilder)$this$addValueParameter).setName(name2);
            ((IrValueParameterBuilder)$this$addValueParameter).setType(argumentType);
            if (((IrValueParameterBuilder)$this$run$iv).getIndex() == -1) {
                ((IrValueParameterBuilder)$this$run$iv).setIndex($this$addValueParameter$iv.getValueParameters().size());
            }
            IrValueParameter it = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), (IrValueParameterBuilder)$this$run$iv, $this$addValueParameter$iv);
            boolean bl14 = false;
            bl2 = false;
            IrValueParameter valueParameter$iv = it;
            boolean bl15 = false;
            $this$addValueParameter$iv.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getValueParameters(), valueParameter$iv));
            ++index2;
        }
        JvmIrBuilder jvmIrBuilder = org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.createJvmIrBuilder(this.context, $this$apply2.getSymbol(), expression2.getStartOffset(), expression2.getEndOffset());
        boolean bl16 = false;
        boolean bl17 = false;
        JvmIrBuilder $this$addValueParameter$iv = jvmIrBuilder;
        IrSimpleFunction irSimpleFunction = $this$apply2;
        boolean bl18 = false;
        object2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$run, referencedFunction);
        bl = false;
        boolean bl19 = false;
        $this$run$iv = object2;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$run;
        boolean bl20 = false;
        Iterable $this$forEach$iv = IrUtilsKt.getAllTypeParameters(((IrFunctionSymbol)$this$apply.getSymbol()).getOwner());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrTypeParameter it = (IrTypeParameter)element$iv;
            boolean bl21 = false;
            $this$apply.putTypeArgument(it.getIndex(), expression2.getTypeArgument(it.getIndex()));
        }
        int unboundIndex = 0;
        for (IrValueParameter parameter : IrUtilsKt.getExplicitParameters(referencedFunction)) {
            Unit unit;
            IrExpression irExpression;
            Pair<IrValueParameter, IrExpression> pair = boundReceiver;
            if (Intrinsics.areEqual(pair != null ? pair.getFirst() : null, parameter)) {
                irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$run, ExpressionHelpersKt.irTemporary$default($this$irBlock, boundReceiver.getSecond(), null, null, null, 14, null));
            } else if (AdditionalIrUtilsKt.isVararg(parameter) && unboundIndex < argumentTypes2.size() && Intrinsics.areEqual(parameter.getType(), $this$apply2.getValueParameters().get(unboundIndex).getType())) {
                int element$iv = unboundIndex;
                unboundIndex = element$iv + 1;
                irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$run, $this$apply2.getValueParameters().get(element$iv));
            } else if (AdditionalIrUtilsKt.isVararg(parameter) && (unboundIndex < argumentTypes2.size() || !IrUtilsKt.hasDefaultValue(parameter))) {
                void $this$irArray$iv;
                void element$iv = $this$run;
                IrType arrayType$iv = parameter.getType();
                boolean $i$f$irArray = false;
                IrArrayBuilder irArrayBuilder = new IrArrayBuilder((JvmIrBuilder)$this$irArray$iv, arrayType$iv);
                boolean bl22 = false;
                boolean bl23 = false;
                IrArrayBuilder $this$apply$iv = irArrayBuilder;
                boolean bl24 = false;
                IrArrayBuilder $this$irArray = $this$apply$iv;
                boolean bl25 = false;
                Iterable $this$forEach$iv2 = RangesKt.until(unboundIndex, argumentTypes2.size());
                boolean $i$f$forEach2 = false;
                Iterator iterator3 = $this$forEach$iv2.iterator();
                while (iterator3.hasNext()) {
                    int element$iv2;
                    int it = element$iv2 = ((IntIterator)iterator3).nextInt();
                    boolean bl26 = false;
                    int n3 = unboundIndex;
                    unboundIndex = n3 + 1;
                    $this$irArray.unaryPlus(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$run, $this$apply2.getValueParameters().get(n3)));
                }
                irExpression = irArrayBuilder.build();
            } else if (unboundIndex >= argumentTypes2.size()) {
                irExpression = null;
            } else {
                int n4 = unboundIndex;
                unboundIndex = n4 + 1;
                irExpression = ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$run, $this$apply2.getValueParameters().get(n4));
            }
            if (irExpression != null) {
                IrExpression irExpression2 = irExpression;
                boolean bl27 = false;
                boolean bl28 = false;
                IrExpression it = irExpression2;
                boolean bl29 = false;
                IrMemberAccessExpressionKt.putArgument((IrMemberAccessExpression)$this$apply, referencedFunction, parameter, it);
                unit = Unit.INSTANCE;
                continue;
            }
            unit = null;
        }
        Unit unit = Unit.INSTANCE;
        IrExpressionBody irExpressionBody = ExpressionHelpersKt.irExprBody(irBuilderWithScope, (IrExpression)object2);
        irSimpleFunction.setBody(irExpressionBody);
        IrSimpleFunction function2 = irElementBase;
        $this$irBlock.unaryPlus(function2);
        irElementBase = new IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), function2.getReturnType(), function2.getSymbol(), function2.getTypeParameters().size(), null, IrStatementOrigin.LAMBDA.INSTANCE);
        bl8 = false;
        bl9 = false;
        $this$apply2 = irElementBase;
        object3 = $this$irBlock;
        boolean bl30 = false;
        IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$apply2, expression2);
        object = Unit.INSTANCE;
        ((IrStatementsBuilder)object3).unaryPlus((IrStatement)((Object)irElementBase));
        return this_$iv$iv$iv.doBuild();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public InlineCallableReferenceToLambdaPhase(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        boolean bl = false;
        this.inlinableReferences = new LinkedHashSet();
    }
}

