// Generated by CoffeeScript 1.10.0
(function() {
  var Api, CozyInstance, CozyUser, api, client, cozydb, setupModels;

  client = require('./utils/client');

  cozydb = require('./index');

  CozyInstance = null;

  CozyUser = null;

  module.exports.setupModels = setupModels = function() {
    module.exports.CozyInstance = CozyInstance = cozydb.getModel('CozyInstance', cozydb.NoSchema);
    module.exports.CozyUser = CozyUser = cozydb.getModel('User', cozydb.NoSchema);
  };

  setupModels();

  Api = (function() {
    function Api() {}

    Api.prototype.getCozyInstance = function(callback) {
      return CozyInstance.first(callback);
    };

    Api.prototype.getCozyUser = function(callback) {
      return CozyUser.first(callback);
    };

    Api.prototype.getCozyDomain = function(callback) {
      return api.getCozyInstance(function(err, instance) {
        var ref, url;
        if (err) {
          return callback(err);
        }
        url = instance != null ? (ref = instance.domain) != null ? ref.replace('http://', '').replace('https://', '') : void 0 : void 0;
        if (url) {
          return callback(null, "https://" + url + "/");
        } else {
          return callback(new Error('No instance domain set'));
        }
      });
    };

    Api.prototype.getCozyLocale = function(callback) {
      return api.getCozyInstance(function(err, instance) {
        return callback(err, (instance != null ? instance.locale : void 0) || 'en');
      });
    };

    Api.prototype.getCozyTimezone = function(callback) {
      return api.getCozyUser(function(err, user) {
        var tz;
        if (err) {
          return callback(err);
        }
        tz = user != null ? user.timezone : void 0;
        if (tz) {
          return callback(null, tz);
        } else {
          return callback(new Error('No user set'));
        }
      });
    };

    Api.prototype.getCozyOwnerEmail = function(callback) {
      return api.getCozyUser(function(err, user) {
        var email;
        if (err) {
          return callback(err);
        }
        email = user != null ? user.email : void 0;
        if (email) {
          return callback(null, email);
        } else {
          return callback(new Error('No user set'));
        }
      });
    };

    Api.prototype.getCozyTags = function(callback) {
      return client.get('tags', function(err, response, body) {
        return callback(err, body);
      });
    };

    Api.prototype.sendMail = function(data, callback) {
      return client.post("mail/", data, function(error, response, body) {
        if (body.error != null) {
          if ((body.error.code != null) && body.error.code === 'postfix_unavailable') {
            return callback(new Error("postfix-" + body.error.message));
          } else {
            return callback(body.error);
          }
        } else if (response.statusCode === 400) {
          return callback(new Error('Body has not all necessary attributes'));
        } else if (response.statusCode === 500) {
          return callback(new Error("Server error occured."));
        } else {
          return callback();
        }
      });
    };

    Api.prototype.sendMailToUser = function(data, callback) {
      return client.post("mail/to-user/", data, function(error, response, body) {
        if (body.error != null) {
          if ((body.error.code != null) && body.error.code === 'postfix_unavailable') {
            return callback(new Error("postfix-" + body.error.message));
          } else {
            return callback(body.error);
          }
        } else if (response.statusCode === 400) {
          return callback(new Error('Body has not all necessary attributes'));
        } else if (response.statusCode === 500) {
          return callback(new Error("Server error occured."));
        } else {
          return callback();
        }
      });
    };

    Api.prototype.sendMailFromUser = function(data, callback) {
      return client.post("mail/from-user/", data, function(error, response, body) {
        if (body.error != null) {
          if ((body.error.code != null) && body.error.code === 'postfix_unavailable') {
            return callback(new Error("postfix-" + body.error.message));
          } else {
            return callback(body.error);
          }
        } else if (response.statusCode === 400) {
          return callback(new Error('Body has not all necessary attributes'));
        } else if (response.statusCode === 500) {
          return callback(new Error("Server error occured."));
        } else {
          return callback();
        }
      });
    };

    Api.prototype.createSharing = function(data, callback) {
      return client.post("services/sharing/", data, function(err, res, body) {
        return callback(err, body);
      });
    };

    Api.prototype.answerSharing = function(data, callback) {
      return client.post("services/sharing/sendAnswer", data, function(err, res, body) {
        return callback(err, body);
      });
    };

    Api.prototype.revokeSharingFromSharer = function(id, callback) {
      var path;
      path = "services/sharing/sharer/" + id + "/";
      return client["delete"](path, {}, function(err, res, body) {
        return callback(err, body);
      });
    };

    Api.prototype.revokeSharingTargetFromSharer = function(id, target, callback) {
      var path;
      path = "services/sharing/sharer/" + id + "/" + target + "/";
      return client["delete"](path, {}, function(err, res, body) {
        return callback(err, body);
      });
    };

    Api.prototype.revokeSharingFromRecipient = function(id, callback) {
      var path;
      path = "services/sharing/target/" + id + "/";
      return client["delete"](path, {}, function(err, res, body) {
        return callback(err, body);
      });
    };

    return Api;

  })();

  module.exports = api = new Api();

  module.exports.setupModels = setupModels;

  module.exports.CozyInstance = CozyInstance;

  module.exports.CozyUser = CozyUser;

}).call(this);
