/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import writer2latex.api.Config;
import writer2latex.api.ContentEntry;
import writer2latex.api.ConverterFactory;
import writer2latex.api.OutputFile;
import writer2latex.base.ContentEntryImpl;
import writer2latex.base.ConverterBase;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.ExportNameCollection;
import writer2latex.util.Misc;
import writer2latex.xhtml.CssDocument;
import writer2latex.xhtml.DrawConverter;
import writer2latex.xhtml.LinkDescriptor;
import writer2latex.xhtml.MathConverter;
import writer2latex.xhtml.ResourceDocument;
import writer2latex.xhtml.StyleConverter;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.TableConverter;
import writer2latex.xhtml.TextConverter;
import writer2latex.xhtml.XhtmlConfig;
import writer2latex.xhtml.XhtmlDocument;
import writer2latex.xhtml.l10n.L10n;

public class Converter
extends ConverterBase {
    private static final String EPUB_STYLES_FOLDER = "styles/";
    private static final String EPUB_STYLESHEET = "styles/styles1.css";
    private static final String EPUB_CUSTOM_STYLESHEET = "styles/styles.css";
    private XhtmlConfig config;
    private L10n l10n;
    private StyleConverter styleCv;
    private TextConverter textCv;
    private TableConverter tableCv;
    private DrawConverter drawCv;
    private MathConverter mathCv;
    private XhtmlDocument template = null;
    private CssDocument styleSheet = null;
    private Set<ResourceDocument> resources = new HashSet<ResourceDocument>();
    protected int nType = 0;
    private boolean bOPS = false;
    Vector<XhtmlDocument> outFiles;
    private int nOutFileIndex;
    private XhtmlDocument htmlDoc;
    private Document htmlDOM;
    private boolean bNeedHeaderFooter = false;
    Hashtable<String, Integer> targets = new Hashtable();
    LinkedList<LinkDescriptor> links = new LinkedList();
    private ExportNameCollection targetNames = new ExportNameCollection(true);
    private Stack<String> contentWidth = new Stack();

    @Override
    public Config getConfig() {
        return this.config;
    }

    protected XhtmlConfig getXhtmlConfig() {
        return this.config;
    }

    public Converter(int nType) {
        this.config = new XhtmlConfig();
        this.nType = nType;
    }

    @Override
    public void readTemplate(InputStream is) throws IOException {
        this.template = new XhtmlDocument("Template", this.nType);
        this.template.read(is);
    }

    @Override
    public void readTemplate(File file) throws IOException {
        this.readTemplate(new FileInputStream(file));
    }

    @Override
    public void readStyleSheet(InputStream is) throws IOException {
        if (this.styleSheet == null) {
            this.styleSheet = new CssDocument(EPUB_CUSTOM_STYLESHEET);
        }
        this.styleSheet.read(is);
    }

    @Override
    public void readStyleSheet(File file) throws IOException {
        this.readStyleSheet(new FileInputStream(file));
    }

    @Override
    public void readResource(InputStream is, String sFileName, String sMediaType) throws IOException {
        if (sMediaType == null) {
            sMediaType = "";
            String sfilename = sFileName.toLowerCase();
            if (sfilename.endsWith(".png")) {
                sMediaType = "image/png";
            } else if (sfilename.endsWith(".jpg")) {
                sMediaType = "image/jpeg";
            } else if (sfilename.endsWith(".jpeg")) {
                sMediaType = "image/jpeg";
            } else if (sfilename.endsWith(".gif")) {
                sMediaType = "image/gif";
            } else if (sfilename.endsWith(".otf")) {
                sMediaType = "application/vnd.ms-opentype";
            } else if (sfilename.endsWith(".ttf")) {
                sMediaType = "application/x-font-ttf";
            }
        }
        ResourceDocument doc = new ResourceDocument(EPUB_STYLES_FOLDER + sFileName, sMediaType);
        doc.read(is);
        this.resources.add(doc);
    }

    @Override
    public void readResource(File file, String sFileName, String sMediaType) throws IOException {
        this.readResource(new FileInputStream(file), sFileName, sMediaType);
    }

    protected String getContentWidth() {
        return this.contentWidth.peek();
    }

    protected String pushContentWidth(String sWidth) {
        return this.contentWidth.push(sWidth);
    }

    protected void popContentWidth() {
        this.contentWidth.pop();
    }

    protected boolean isTopLevel() {
        return this.contentWidth.size() == 1;
    }

    protected StyleConverter getStyleCv() {
        return this.styleCv;
    }

    protected TextConverter getTextCv() {
        return this.textCv;
    }

    protected TableConverter getTableCv() {
        return this.tableCv;
    }

    protected DrawConverter getDrawCv() {
        return this.drawCv;
    }

    protected MathConverter getMathCv() {
        return this.mathCv;
    }

    protected int getType() {
        return this.nType;
    }

    public boolean isHTML5() {
        return this.nType >= 3;
    }

    protected int getOutFileIndex() {
        return this.nOutFileIndex;
    }

    protected void addContentEntry(String sTitle, int nLevel, String sTarget) {
        this.converterResult.addContentEntry(new ContentEntryImpl(sTitle, nLevel, this.htmlDoc, sTarget));
    }

    protected void setTocFile(String sTarget) {
        this.converterResult.setTocFile(new ContentEntryImpl(this.l10n.get(5), 1, this.htmlDoc, sTarget));
    }

    protected void setLofFile(String sTarget) {
        this.converterResult.setLofFile(new ContentEntryImpl("Figures", 1, this.htmlDoc, sTarget));
    }

    protected void setLotFile(String sTarget) {
        this.converterResult.setLotFile(new ContentEntryImpl("Tables", 1, this.htmlDoc, sTarget));
    }

    protected void setIndexFile(String sTarget) {
        this.converterResult.setIndexFile(new ContentEntryImpl(this.l10n.get(6), 1, this.htmlDoc, sTarget));
    }

    protected void setCoverFile(String sTarget) {
        this.converterResult.setCoverFile(new ContentEntryImpl("Cover", 0, this.htmlDoc, sTarget));
    }

    protected void setCoverImageFile(OutputFile file, String sTarget) {
        this.converterResult.setCoverImageFile(new ContentEntryImpl("Cover image", 0, file, sTarget));
    }

    protected Element createElement(String s) {
        return this.htmlDOM.createElement(s);
    }

    Element createAlternativeElement(String sHTML5, String sHTML) {
        if (!(!this.isHTML5() || this.isOPS() && this.config.avoidHtml5())) {
            return this.createElement(sHTML5);
        }
        return this.createElement(sHTML);
    }

    protected Text createTextNode(String s) {
        return this.htmlDOM.createTextNode(s);
    }

    protected Node importNode(Node node, boolean bDeep) {
        return this.htmlDOM.importNode(node, bDeep);
    }

    protected L10n getL10n() {
        return this.l10n;
    }

    public void setOPS(boolean b) {
        this.bOPS = true;
    }

    public boolean isOPS() {
        return this.bOPS;
    }

    @Override
    public void convertInner() throws IOException {
        Element header;
        int i;
        StyleWithProperties style;
        this.sTargetFileName = Misc.trimDocumentName(this.sTargetFileName, XhtmlDocument.getExtension(this.nType));
        this.outFiles = new Vector();
        this.nOutFileIndex = -1;
        this.bNeedHeaderFooter = !this.bOPS && (this.ofr.isSpreadsheet() || this.ofr.isPresentation() || this.config.getXhtmlSplitLevel() > 0 || this.config.pageBreakSplit() > 0 || this.config.getXhtmlUplink().length() > 0);
        this.l10n = new L10n();
        if (this.isOPS()) {
            this.imageConverter.setBaseFileName("image");
            this.imageConverter.setUseSubdir("images");
        } else {
            this.imageConverter.setBaseFileName(this.sTargetFileName + "-img");
            if (this.config.saveImagesInSubdir()) {
                this.imageConverter.setUseSubdir(this.sTargetFileName + "-img");
            }
        }
        this.imageConverter.setDefaultFormat("image/png");
        this.imageConverter.addAcceptedFormat("image/jpeg");
        this.imageConverter.addAcceptedFormat("image/gif");
        if (this.isHTML5()) {
            this.imageConverter.setDefaultVectorFormat("image/svg+xml");
        }
        this.styleCv = new StyleConverter(this.ofr, this.config, this, this.nType);
        this.textCv = new TextConverter(this.ofr, this.config, this);
        this.tableCv = new TableConverter(this.ofr, this.config, this);
        this.drawCv = new DrawConverter(this.ofr, this.config, this);
        this.mathCv = new MathConverter(this.ofr, this.config, this, this.nType != 0 && this.nType != 1);
        StyleWithProperties styleWithProperties = style = this.ofr.isSpreadsheet() ? this.ofr.getDefaultCellStyle() : this.ofr.getDefaultParStyle();
        if (style != null) {
            if ("fa".equals(style.getProperty("style:language-complex"))) {
                this.l10n.setLocale("fa", "IR");
            } else {
                this.l10n.setLocale(style.getProperty("fo:language"), style.getProperty("fo:country"));
            }
        }
        this.pushContentWidth(this.getStyleCv().getPageSc().getTextWidth());
        Element body = this.ofr.getContent();
        if (this.ofr.isSpreadsheet()) {
            this.tableCv.convertTableContent(body);
        } else if (this.ofr.isPresentation()) {
            this.drawCv.convertDrawContent(body);
        } else {
            this.textCv.convertTextContent(body);
        }
        if (this.converterResult.getContent().isEmpty()) {
            this.converterResult.setTextFile(new ContentEntryImpl("Text", 1, this.outFiles.get(0), null));
            this.converterResult.addContentEntry(new ContentEntryImpl("Text", 1, this.outFiles.get(0), null));
        } else {
            int nFirstPage;
            ContentEntry firstHeading = this.converterResult.getContent().get(0);
            int n = nFirstPage = this.converterResult.getCoverFile() != null ? 1 : 0;
            if (this.outFiles.get(nFirstPage) != firstHeading.getFile() || firstHeading.getTarget() != null) {
                this.converterResult.setTitlePageFile(new ContentEntryImpl("Title page", 1, this.outFiles.get(nFirstPage), null));
            }
            this.converterResult.setTextFile(new ContentEntryImpl("Text", 1, firstHeading.getFile(), firstHeading.getTarget()));
        }
        ListIterator iter = this.links.listIterator();
        while (iter.hasNext()) {
            LinkDescriptor ld = (LinkDescriptor)iter.next();
            Integer n = this.targets.get(ld.sId);
            if (n == null) continue;
            int nTargetIndex = n;
            if (nTargetIndex == ld.nIndex) {
                ld.element.setAttribute("href", "#" + this.targetNames.getExportName(ld.sId));
                continue;
            }
            ld.element.setAttribute("href", this.getOutFileName(nTargetIndex, true) + "#" + this.targetNames.getExportName(ld.sId));
        }
        if (this.bOPS && this.styleSheet != null) {
            this.converterResult.addDocument(this.styleSheet);
            for (ResourceDocument resourceDocument : this.resources) {
                this.converterResult.addDocument(resourceDocument);
            }
        }
        if (!this.isOPS() && !this.config.separateStylesheet()) {
            for (i = 0; i <= this.nOutFileIndex; ++i) {
                Node styles;
                Element element = this.outFiles.get(i).getHeadNode();
                if (element == null || (styles = this.styleCv.exportStyles(this.outFiles.get(i).getContentDOM())) == null) continue;
                element.appendChild(styles);
            }
        }
        if ((this.isHTML5() || this.nType == 2) && this.config.useMathJax()) {
            for (i = 0; i <= this.nOutFileIndex; ++i) {
                XhtmlDocument xhtmlDocument;
                Element head;
                if (!this.outFiles.get(i).hasMath() || (head = (xhtmlDocument = this.outFiles.get(i)).getHeadNode()) == null) continue;
                Element script = xhtmlDocument.getContentDOM().createElement("script");
                head.appendChild(script);
                script.setAttribute("type", "text/javascript");
                script.setAttribute("src", "https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.4/latest.js?config=TeX-MML-AM_CHTML");
                script.setAttribute("async", "async");
            }
        }
        if (this.ofr.isSpreadsheet()) {
            for (i = 0; i <= this.nOutFileIndex; ++i) {
                XhtmlDocument xhtmlDocument = this.outFiles.get(i);
                Document dom = xhtmlDocument.getContentDOM();
                header = xhtmlDocument.getHeaderNode();
                Element footer = xhtmlDocument.getFooterNode();
                Element headerPar = dom.createElement("p");
                Element footerPar = dom.createElement("p");
                footerPar.setAttribute("style", "clear:both");
                if (this.config.getXhtmlUplink().length() > 0) {
                    Element a = dom.createElement("a");
                    a.setAttribute("href", this.config.getXhtmlUplink());
                    a.appendChild(dom.createTextNode(this.l10n.get(0)));
                    headerPar.appendChild(a);
                    headerPar.appendChild(dom.createTextNode(" "));
                    a = dom.createElement("a");
                    a.setAttribute("href", this.config.getXhtmlUplink());
                    a.appendChild(dom.createTextNode(this.l10n.get(0)));
                    footerPar.appendChild(a);
                    footerPar.appendChild(dom.createTextNode(" "));
                }
                int nSheets = this.tableCv.sheetNames.size();
                for (int j = 0; j < nSheets; ++j) {
                    if (this.config.xhtmlCalcSplit()) {
                        this.addNavigationLink(dom, headerPar, this.tableCv.sheetNames.get(j), j);
                        this.addNavigationLink(dom, footerPar, this.tableCv.sheetNames.get(j), j);
                        continue;
                    }
                    this.addInternalNavigationLink(dom, headerPar, this.tableCv.sheetNames.get(j), "tableheading" + j);
                    this.addInternalNavigationLink(dom, footerPar, this.tableCv.sheetNames.get(j), "tableheading" + j);
                }
                if (header != null) {
                    header.appendChild(headerPar);
                }
                if (footer == null) continue;
                footer.appendChild(footerPar);
            }
        } else if (this.nOutFileIndex > 0) {
            for (i = 0; i <= this.nOutFileIndex; ++i) {
                Element footer;
                XhtmlDocument xhtmlDocument = this.outFiles.get(i);
                Document dom = xhtmlDocument.getContentDOM();
                header = xhtmlDocument.getHeaderNode();
                if (header != null) {
                    if (this.ofr.isPresentation()) {
                        header.setAttribute("style", "position:absolute;top:0;left:0");
                    }
                    if (this.config.getXhtmlUplink().length() > 0) {
                        Element a = dom.createElement("a");
                        a.setAttribute("href", this.config.getXhtmlUplink());
                        a.appendChild(dom.createTextNode(this.l10n.get(0)));
                        header.appendChild(a);
                        header.appendChild(dom.createTextNode(" "));
                    }
                    this.addNavigationLink(dom, header, this.l10n.get(1), 0);
                    this.addNavigationLink(dom, header, this.l10n.get(2), i - 1);
                    this.addNavigationLink(dom, header, this.l10n.get(3), i + 1);
                    this.addNavigationLink(dom, header, this.l10n.get(4), this.nOutFileIndex);
                    if (this.textCv.getTocIndex() >= 0) {
                        this.addNavigationLink(dom, header, this.l10n.get(5), this.textCv.getTocIndex());
                    }
                    if (this.textCv.getAlphabeticalIndex() >= 0) {
                        this.addNavigationLink(dom, header, this.l10n.get(6), this.textCv.getAlphabeticalIndex());
                    }
                }
                if ((footer = xhtmlDocument.getFooterNode()) == null || this.ofr.isPresentation()) continue;
                if (this.config.getXhtmlUplink().length() > 0) {
                    Element a = dom.createElement("a");
                    a.setAttribute("href", this.config.getXhtmlUplink());
                    a.appendChild(dom.createTextNode(this.l10n.get(0)));
                    footer.appendChild(a);
                    footer.appendChild(dom.createTextNode(" "));
                }
                this.addNavigationLink(dom, footer, this.l10n.get(1), 0);
                this.addNavigationLink(dom, footer, this.l10n.get(2), i - 1);
                this.addNavigationLink(dom, footer, this.l10n.get(3), i + 1);
                this.addNavigationLink(dom, footer, this.l10n.get(4), this.nOutFileIndex);
                if (this.textCv.getTocIndex() >= 0) {
                    this.addNavigationLink(dom, footer, this.l10n.get(5), this.textCv.getTocIndex());
                }
                if (this.textCv.getAlphabeticalIndex() < 0) continue;
                this.addNavigationLink(dom, footer, this.l10n.get(6), this.textCv.getAlphabeticalIndex());
            }
        } else if (this.config.getXhtmlUplink().length() > 0) {
            for (i = 0; i <= this.nOutFileIndex; ++i) {
                Element footer;
                XhtmlDocument xhtmlDocument = this.outFiles.get(i);
                Document dom = xhtmlDocument.getContentDOM();
                header = xhtmlDocument.getHeaderNode();
                if (header != null) {
                    Element a = dom.createElement("a");
                    a.setAttribute("href", this.config.getXhtmlUplink());
                    a.appendChild(dom.createTextNode(this.l10n.get(0)));
                    header.appendChild(a);
                    header.appendChild(dom.createTextNode(" "));
                }
                if ((footer = xhtmlDocument.getFooterNode()) == null) continue;
                Element a = dom.createElement("a");
                a.setAttribute("href", this.config.getXhtmlUplink());
                a.appendChild(dom.createTextNode(this.l10n.get(0)));
                footer.appendChild(a);
                footer.appendChild(dom.createTextNode(" "));
            }
        }
        if (this.config.xhtmlFormatting() > 1) {
            if (this.isOPS()) {
                CssDocument cssDoc = new CssDocument(EPUB_STYLESHEET);
                cssDoc.read(this.styleCv.exportStyles(false));
                this.converterResult.addDocument(cssDoc);
            } else if (this.config.separateStylesheet()) {
                CssDocument cssDoc = new CssDocument(this.sTargetFileName + "-styles.css");
                cssDoc.read(this.styleCv.exportStyles(false));
                this.converterResult.addDocument(cssDoc);
            }
        }
    }

    private void addNavigationLink(Document dom, Node node, String s, int nIndex) {
        if (nIndex >= 0 && nIndex <= this.nOutFileIndex) {
            Element a = dom.createElement("a");
            a.setAttribute("href", Misc.makeHref(this.getOutFileName(nIndex, true)));
            a.appendChild(dom.createTextNode(s));
            node.appendChild(a);
            node.appendChild(dom.createTextNode(" "));
        } else {
            Element span = dom.createElement("span");
            span.setAttribute("class", "nolink");
            node.appendChild(span);
            span.appendChild(dom.createTextNode(s));
            node.appendChild(dom.createTextNode(" "));
        }
    }

    private void addInternalNavigationLink(Document dom, Node node, String s, String sLink) {
        Element a = dom.createElement("a");
        a.setAttribute("href", "#" + sLink);
        a.appendChild(dom.createTextNode(s));
        node.appendChild(a);
        node.appendChild(dom.createTextNode(" "));
    }

    protected String getPlainInlineText(Node node) {
        StringBuilder buf = new StringBuilder();
        block4: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            short nodeType = child.getNodeType();
            switch (nodeType) {
                case 3: {
                    buf.append(child.getNodeValue());
                    continue block4;
                }
                case 1: {
                    String sName = child.getNodeName();
                    if (sName.equals("text:s")) {
                        buf.append(" ");
                        continue block4;
                    }
                    if (sName.equals("text:line-break") || sName.equals("text:tab-stop") || sName.equals("text:tab")) {
                        buf.append(" ");
                        continue block4;
                    }
                    if (OfficeReader.isNoteElement(child) || !OfficeReader.isTextElement(child)) continue block4;
                    buf.append(this.getPlainInlineText(child));
                    continue block4;
                }
            }
        }
        return buf.toString();
    }

    public void handleOfficeAnnotation(Node onode, Node hnode) {
        if (this.config.xhtmlNotes()) {
            StringBuilder buf = new StringBuilder();
            Element creator = null;
            Element date = null;
            for (Node child = onode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (Misc.isElement(child, "text:p")) {
                    if (buf.length() > 0) {
                        buf.append('\n');
                    }
                    buf.append(this.getPlainInlineText(child));
                    continue;
                }
                if (Misc.isElement(child, "dc:creator")) {
                    creator = (Element)child;
                    continue;
                }
                if (!Misc.isElement(child, "dc:date")) continue;
                date = (Element)child;
            }
            if (creator != null) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append(this.getPlainInlineText(creator));
            }
            if (date != null) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append(Misc.formatDate(OfficeReader.getTextContent(date), this.l10n.getLocale().getLanguage(), this.l10n.getLocale().getCountry()));
            }
            Comment commentNode = this.htmlDOM.createComment(buf.toString());
            hnode.appendChild(commentNode);
        }
    }

    public String getOutFileName(int nIndex, boolean bWithExt) {
        return this.sTargetFileName + (nIndex > 0 ? Integer.toString(nIndex) : "") + (bWithExt ? this.htmlDoc.getFileExtension() : "");
    }

    public boolean outFileHasContent() {
        return this.htmlDoc.getContentNode().hasChildNodes();
    }

    public void changeOutFile(int nIndex) {
        this.nOutFileIndex = nIndex;
        this.htmlDoc = this.outFiles.get(nIndex);
        this.htmlDOM = this.htmlDoc.getContentDOM();
    }

    public Element getPanelNode() {
        return this.htmlDoc.getPanelNode();
    }

    /*
     * WARNING - void declaration
     */
    public Element nextOutFile() {
        Element head;
        Element title;
        this.htmlDoc = new XhtmlDocument(this.getOutFileName(++this.nOutFileIndex, false), this.nType);
        this.htmlDoc.setConfig(this.config);
        if (this.template != null) {
            this.htmlDoc.readFromTemplate(this.template);
        } else if (this.bNeedHeaderFooter) {
            this.htmlDoc.createHeaderFooter();
        }
        this.outFiles.add(this.nOutFileIndex, this.htmlDoc);
        this.converterResult.addDocument(this.htmlDoc);
        this.htmlDOM = this.htmlDoc.getContentDOM();
        Element rootElement = this.htmlDOM.getDocumentElement();
        this.styleCv.applyDefaultLanguage(rootElement);
        this.addEpubNs(rootElement);
        rootElement.insertBefore(this.htmlDOM.createComment("This file was converted to xhtml by " + (this.ofr.isText() ? "Writer" : (this.ofr.isSpreadsheet() ? "Calc" : "Impress")) + "2xhtml ver. " + ConverterFactory.getVersion() + ". See http://writer2latex.sourceforge.net for more info."), rootElement.getFirstChild());
        if (!this.ofr.isPresentation()) {
            StyleInfo pageInfo = new StyleInfo();
            this.styleCv.getPageSc().applyDefaultWritingDirection(pageInfo);
            this.styleCv.getPageSc().applyStyle(pageInfo, this.htmlDoc.getContentNode());
        }
        if ((title = this.htmlDoc.getTitleNode()) != null) {
            String sTitle = this.metaData.getTitle();
            if (sTitle == null) {
                sTitle = this.htmlDoc.getFileName();
            }
            title.appendChild(this.htmlDOM.createTextNode(sTitle));
        }
        if ((head = this.htmlDoc.getHeadNode()) != null) {
            Element htmlStyle;
            Element meta;
            if (this.nType == 0) {
                meta = this.htmlDOM.createElement("meta");
                meta.setAttribute("http-equiv", "Content-Type");
                meta.setAttribute("content", "text/html; charset=" + this.htmlDoc.getEncoding().toLowerCase());
                head.appendChild(meta);
            } else if (this.isHTML5()) {
                meta = this.htmlDOM.createElement("meta");
                meta.setAttribute("charset", this.htmlDoc.getEncoding().toUpperCase());
                head.appendChild(meta);
            }
            if (!this.bOPS) {
                this.createMeta(head, "description", this.metaData.getDescription());
                this.createMeta(head, "keywords", this.metaData.getKeywords());
                if (this.config.xhtmlUseDublinCore()) {
                    void var5_11;
                    head.setAttribute("profile", "http://dublincore.org/documents/2008/08/04/dc-html/");
                    Element dclink = this.htmlDOM.createElement("link");
                    dclink.setAttribute("rel", "schema.DC");
                    dclink.setAttribute("href", "http://purl.org/dc/elements/1.1/");
                    head.appendChild(dclink);
                    this.createMeta(head, "DC.title", this.metaData.getTitle());
                    String string = "";
                    if (this.metaData.getSubject() != null && this.metaData.getSubject().length() > 0) {
                        String string2 = this.metaData.getSubject();
                    }
                    if (this.metaData.getKeywords() != null && this.metaData.getKeywords().length() > 0) {
                        void var5_9;
                        void var5_7;
                        if (var5_7.length() > 0) {
                            String string3 = (String)var5_7 + ", ";
                        }
                        String string4 = (String)var5_9 + this.metaData.getKeywords();
                    }
                    this.createMeta(head, "DC.subject", (String)var5_11);
                    this.createMeta(head, "DC.description", this.metaData.getDescription());
                    this.createMeta(head, "DC.creator", this.metaData.getCreator());
                    this.createMeta(head, "DC.date", this.metaData.getDate());
                    this.createMeta(head, "DC.language", this.metaData.getLanguage());
                }
            }
            if (!this.bOPS && this.config.xhtmlCustomStylesheet().length() > 0) {
                htmlStyle = this.htmlDOM.createElement("link");
                htmlStyle.setAttribute("rel", "stylesheet");
                htmlStyle.setAttribute("type", "text/css");
                htmlStyle.setAttribute("media", "all");
                htmlStyle.setAttribute("href", this.config.xhtmlCustomStylesheet());
                head.appendChild(htmlStyle);
            }
            if (!this.bOPS && this.config.separateStylesheet() && this.config.xhtmlFormatting() > 1) {
                htmlStyle = this.htmlDOM.createElement("link");
                htmlStyle.setAttribute("rel", "stylesheet");
                htmlStyle.setAttribute("type", "text/css");
                htmlStyle.setAttribute("media", "all");
                htmlStyle.setAttribute("href", this.sTargetFileName + "-styles.css");
                head.appendChild(htmlStyle);
            }
            if (this.bOPS && this.styleSheet != null) {
                Element sty = this.htmlDOM.createElement("link");
                sty.setAttribute("rel", "stylesheet");
                sty.setAttribute("type", "text/css");
                sty.setAttribute("href", EPUB_CUSTOM_STYLESHEET);
                head.appendChild(sty);
            }
            if (this.isOPS() && this.config.xhtmlFormatting() > 1) {
                htmlStyle = this.htmlDOM.createElement("link");
                htmlStyle.setAttribute("rel", "stylesheet");
                htmlStyle.setAttribute("type", "text/css");
                htmlStyle.setAttribute("href", EPUB_STYLESHEET);
                head.appendChild(htmlStyle);
            }
        }
        if (!this.textCv.sections.isEmpty()) {
            for (Element element : this.textCv.sections) {
                String sStyleName = Misc.getAttribute(element, "text:style-name");
                Element div = this.htmlDOM.createElement("div");
                this.htmlDoc.getContentNode().appendChild(div);
                this.htmlDoc.setContentNode(div);
                StyleInfo sectionInfo = new StyleInfo();
                this.styleCv.getSectionSc().applyStyle(sStyleName, sectionInfo);
                this.styleCv.getSectionSc().applyStyle(sectionInfo, div);
            }
        }
        return this.htmlDoc.getContentNode();
    }

    public void addEpubNs(Element elm) {
        if (this.bOPS && this.isHTML5()) {
            elm.setAttribute("xmlns:epub", "http://www.idpf.org/2007/ops");
        }
    }

    public void addEpubType(Element elm, String sType) {
        if (this.bOPS && this.isHTML5() && sType != null) {
            elm.setAttribute("epub:type", sType);
        }
    }

    public Element createTarget(String sId) {
        Element a = this.htmlDOM.createElement("a");
        a.setAttribute("id", this.targetNames.getExportName(sId));
        this.targets.put(sId, new Integer(this.nOutFileIndex));
        return a;
    }

    public void addTarget(Element node, String sId) {
        node.setAttribute("id", this.targetNames.getExportName(sId));
        this.targets.put(sId, new Integer(this.nOutFileIndex));
    }

    String getTarget(String sId) {
        return this.targetNames.getExportName(sId);
    }

    public Element createLink(String sId) {
        Element a = this.htmlDOM.createElement("a");
        LinkDescriptor ld = new LinkDescriptor();
        ld.element = a;
        ld.sId = sId;
        ld.nIndex = this.nOutFileIndex;
        this.links.add(ld);
        return a;
    }

    public Element createLink(Element onode) {
        Element anchor;
        String sHref = onode.getAttribute("xlink:href");
        if (sHref.startsWith("#")) {
            anchor = this.createLink(sHref.substring(1));
        } else {
            String sTarget;
            int n3F;
            anchor = this.htmlDOM.createElement("a");
            if ((sHref = this.ofr.fixRelativeLink(sHref)).indexOf("?") == -1 && (n3F = sHref.indexOf("%3F")) > 0) {
                sHref = sHref.substring(0, n3F) + "?" + sHref.substring(n3F + 3);
            }
            anchor.setAttribute("href", sHref);
            String sName = Misc.getAttribute(onode, "office:name");
            if (sName != null) {
                if (sName.indexOf(";") == -1 && sName.indexOf("=") == -1) {
                    anchor.setAttribute("name", sName);
                    anchor.setAttribute("title", sName);
                } else {
                    String[] sElements;
                    for (String sElement : sElements = sName.split(";")) {
                        String[] sNameVal = sElement.split("=");
                        if (sNameVal.length < 2) continue;
                        anchor.setAttribute(sNameVal[0].trim(), sNameVal[1].trim());
                    }
                }
            }
            if ((sTarget = Misc.getAttribute(onode, "office:target-frame-name")) != null) {
                anchor.setAttribute("target", sTarget);
            }
        }
        String sStyleName = onode.getAttribute("text:style-name");
        String sVisitedStyleName = onode.getAttribute("text:visited-style-name");
        StyleInfo anchorInfo = new StyleInfo();
        this.styleCv.getTextSc().applyAnchorStyle(sStyleName, sVisitedStyleName, anchorInfo);
        this.styleCv.getTextSc().applyStyle(anchorInfo, anchor);
        return anchor;
    }

    private void createMeta(Element head, String sName, String sValue) {
        if (sValue == null) {
            return;
        }
        Element meta = this.htmlDOM.createElement("meta");
        meta.setAttribute("name", sName);
        meta.setAttribute("content", sValue);
        head.appendChild(meta);
    }
}

