/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.util.Collection;
import org.w3c.dom.Element;
import writer2latex.base.BibliographyGenerator;
import writer2latex.bibtex.BibTeXDocument;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.i18n.ClassicI18n;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Misc;

class BibConverter
extends ConverterHelper {
    private BibTeXDocument bibDoc = null;
    private boolean bUseBibTeX;
    private String sBibTeXEncoding = null;
    private String sDocumentEncoding = null;

    BibConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
        if (!config.useBibtex() || config.externalBibtexFiles().length() <= 0) {
            this.bibDoc = new BibTeXDocument(palette.getOutFileName(), false, ofr);
        }
        if (config.externalBibtexFiles().length() > 0) {
            int nBibTeXEncoding = config.getBibtexEncoding();
            int nDocumentEncoding = config.getInputencoding();
            if (config.getBackend() != 4 && nBibTeXEncoding > -1 && nBibTeXEncoding != nDocumentEncoding) {
                this.sBibTeXEncoding = ClassicI18n.writeInputenc(nBibTeXEncoding);
                this.sDocumentEncoding = ClassicI18n.writeInputenc(nDocumentEncoding);
            }
        }
        this.bUseBibTeX = config.useBibtex();
    }

    @Override
    void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
    }

    void handleBibliography(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (!this.config.noIndex()) {
            if (this.config.useBibtex()) {
                this.handleBibliographyAsBibTeX(ldp);
            } else {
                ThebibliographyGenerator bibCv = new ThebibliographyGenerator(this.ofr);
                Element source = Misc.getChildByTagName(node, "text:bibliography-source");
                bibCv.handleBibliography(source, ldp, oc);
            }
        }
    }

    private void handleBibliographyAsBibTeX(LaTeXDocumentPortion ldp) {
        ldp.append("\\bibliographystyle{").append(this.config.bibtexStyle()).append("}").nl();
        if (this.config.externalBibtexFiles().length() > 0) {
            if (this.sBibTeXEncoding != null) {
                ldp.append("\\inputencoding{").append(this.sBibTeXEncoding).append("}").nl();
            }
            ldp.append("\\bibliography{").append(this.config.externalBibtexFiles()).append("}").nl();
            if (this.sBibTeXEncoding != null) {
                ldp.append("\\inputencoding{").append(this.sDocumentEncoding).append("}").nl();
            }
        } else {
            ldp.append("\\bibliography{").append(this.bibDoc.getName()).append("}").nl();
        }
    }

    void handleBibliographyMark(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sIdentifier = node.getAttribute("text:identifier");
        if (sIdentifier != null) {
            ldp.append("\\cite{").append(this.config.externalBibtexFiles().length() == 0 ? this.bibDoc.getExportName(sIdentifier) : sIdentifier).append("}");
        }
    }

    BibTeXDocument getBibTeXDocument() {
        if (this.bUseBibTeX && this.bibDoc != null && !this.bibDoc.isEmpty()) {
            return this.bibDoc;
        }
        return null;
    }

    private class ThebibliographyGenerator
    extends BibliographyGenerator {
        private LaTeXDocumentPortion ldp;
        private Context context;
        private BeforeAfter itemBa;
        private Context itemContext;

        ThebibliographyGenerator(OfficeReader ofr) {
            super(ofr, true);
            this.itemBa = null;
            this.itemContext = null;
        }

        void handleBibliography(Element bibliography, LaTeXDocumentPortion ldp, Context context) {
            this.ldp = ldp;
            this.context = context;
            String sWidestLabel = "";
            Collection<String> labels = this.getLabels();
            for (String sLabel : labels) {
                if (sLabel.length() < sWidestLabel.length()) continue;
                sWidestLabel = sLabel;
            }
            ldp.append("\\begin{thebibliography}{").append(sWidestLabel).append("}\n");
            this.generateBibliography(bibliography);
            this.endBibliographyItem();
            ldp.append("\\end{thebibliography}\n");
        }

        @Override
        protected void insertBibliographyItem(String sStyleName, String sKey) {
            this.endBibliographyItem();
            this.itemBa = new BeforeAfter();
            this.itemContext = (Context)this.context.clone();
            StyleWithProperties style = BibConverter.this.ofr.getParStyle(sStyleName);
            if (style != null) {
                BibConverter.this.palette.getI18n().applyLanguage(style, true, true, this.itemBa);
                BibConverter.this.palette.getCharSc().applyFont(style, true, true, this.itemBa, this.itemContext);
                if (this.itemBa.getBefore().length() > 0) {
                    this.itemBa.add(" ", "");
                    this.itemBa.enclose("{", "}");
                }
            }
            this.ldp.append(this.itemBa.getBefore());
            BibConverter.this.palette.getI18n().pushSpecialTable(BibConverter.this.palette.getCharSc().getFontName(style));
            this.ldp.append("\\bibitem");
            if (!this.isNumberedEntries()) {
                this.ldp.append("[").append(BibConverter.this.bibDoc.getExportName(sKey)).append("]");
            }
            this.ldp.append("{").append(BibConverter.this.bibDoc.getExportName(sKey)).append("} ");
        }

        private void endBibliographyItem() {
            if (this.itemBa != null) {
                BibConverter.this.palette.getI18n().popSpecialTable();
                this.ldp.append(this.itemBa.getAfter()).append("\n");
                this.itemBa = null;
            }
        }

        @Override
        protected void insertBibliographyItemElement(String sStyleName, String sText) {
            BeforeAfter ba = new BeforeAfter();
            Context elementContext = (Context)this.itemContext.clone();
            StyleWithProperties style = BibConverter.this.ofr.getTextStyle(sStyleName);
            BibConverter.this.palette.getCharSc().applyTextStyle(sStyleName, ba, elementContext);
            this.ldp.append(ba.getBefore());
            BibConverter.this.palette.getI18n().pushSpecialTable(BibConverter.this.palette.getCharSc().getFontName(style));
            this.ldp.append(BibConverter.this.palette.getI18n().convert(sText, false, elementContext.getLang()));
            BibConverter.this.palette.getI18n().popSpecialTable();
            this.ldp.append(ba.getAfter());
        }
    }
}

