/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.tex.tokenizer;

import org.openoffice.da.comp.w2lcommon.tex.tokenizer.TokenType;

public class Token
implements Cloneable {
    private TokenType type = TokenType.ENDINPUT;
    private char[] tokenChars = new char[25];
    private int nTokenLen = 0;
    private int nCapacity = 25;

    protected void setType(TokenType type) {
        this.type = type;
    }

    protected void setChar(char c) {
        this.tokenChars[0] = c;
        this.nTokenLen = 1;
    }

    protected void set(char c, TokenType type) {
        this.setType(type);
        this.setChar(c);
    }

    protected void clearChars() {
        this.nTokenLen = 0;
    }

    protected void addChar(char c) {
        if (this.nTokenLen == this.nCapacity) {
            char[] temp = this.tokenChars;
            this.nCapacity += 25;
            this.tokenChars = new char[this.nCapacity];
            System.arraycopy(temp, 0, this.tokenChars, 0, temp.length);
        }
        this.tokenChars[this.nTokenLen++] = c;
    }

    public boolean is(char c, TokenType type) {
        return this.type == type && type != TokenType.COMMAND_SEQUENCE && type != TokenType.ENDINPUT && this.nTokenLen == 1 && this.tokenChars[0] == c;
    }

    public boolean isCS(String sName) {
        if (this.type == TokenType.COMMAND_SEQUENCE && sName.length() == this.nTokenLen) {
            for (int i = 0; i < this.nTokenLen; ++i) {
                if (sName.charAt(i) == this.tokenChars[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public TokenType getType() {
        return this.type;
    }

    public char getChar() {
        return this.nTokenLen > 0 ? this.tokenChars[0] : (char)'\uffff';
    }

    public String getString() {
        return new String(this.tokenChars, 0, this.nTokenLen);
    }

    public String toString() {
        switch (this.type) {
            case COMMAND_SEQUENCE: {
                return "\\" + this.getString();
            }
            case ENDINPUT: {
                return "<EOF>";
            }
        }
        return Character.toString(this.getChar());
    }

    public Object clone() {
        Token newToken = new Token();
        newToken.type = this.type;
        newToken.nTokenLen = this.nTokenLen;
        newToken.nCapacity = this.nCapacity;
        newToken.tokenChars = new char[newToken.nCapacity];
        System.arraycopy(this.tokenChars, 0, newToken.tokenChars, 0, newToken.nCapacity);
        return newToken;
    }
}

