/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.writer2latex;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XNamed;
import com.sun.star.document.XDocumentInsertable;
import com.sun.star.document.XFilter;
import com.sun.star.document.XImporter;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.openoffice.da.comp.writer2latex.ExternalApps;

public class TeXImportFilter
extends WeakBase
implements XInitialization,
XNamed,
XImporter,
XFilter,
XServiceInfo {
    public static final String __implementationName = TeXImportFilter.class.getName();
    public static final String __serviceName = "com.sun.star.document.ImportFilter";
    private static final String[] m_serviceNames = new String[]{"com.sun.star.document.ImportFilter"};
    public static final int FILTERPROC_RUNNING = 0;
    public static final int FILTERPROC_BREAKING = 1;
    public static final int FILTERPROC_STOPPED = 2;
    private final XComponentContext m_xContext;
    private String m_sFilterName;
    private XTextDocument m_xTargetDoc;
    private int m_nState;

    public TeXImportFilter(XComponentContext xContext) {
        this.m_xContext = xContext;
        this.m_sFilterName = "";
        this.m_xTargetDoc = null;
        this.m_nState = 2;
    }

    public String getImplementationName() {
        return __implementationName;
    }

    public boolean supportsService(String sService) {
        int len = m_serviceNames.length;
        for (int i = 0; i < len; ++i) {
            if (!sService.equals(m_serviceNames[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedServiceNames() {
        return m_serviceNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object[] arguments) throws Exception {
        if (arguments.length > 0) {
            PropertyValue[] config = (PropertyValue[])arguments[0];
            int nLen = config.length;
            for (int i = 0; i < nLen; ++i) {
                if (!config[i].Name.equals("Name")) continue;
                TeXImportFilter teXImportFilter = this;
                synchronized (teXImportFilter) {
                    try {
                        this.m_sFilterName = AnyConverter.toString((Object)config[i].Value);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        TeXImportFilter teXImportFilter = this;
        synchronized (teXImportFilter) {
            return this.m_sFilterName;
        }
    }

    public void setName(String sName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetDocument(XComponent xDocument) throws IllegalArgumentException {
        if (xDocument == null) {
            throw new IllegalArgumentException("Null pointer");
        }
        XServiceInfo xInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xDocument);
        if (!xInfo.supportsService("com.sun.star.text.TextDocument")) {
            throw new IllegalArgumentException("Wrong document type");
        }
        TeXImportFilter teXImportFilter = this;
        synchronized (teXImportFilter) {
            this.m_xTargetDoc = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filter(PropertyValue[] mediaDescriptor) {
        String sURL = null;
        XStatusIndicator xStatusIndicator = null;
        int nLength = mediaDescriptor.length;
        for (int i = 0; i < nLength; ++i) {
            try {
                if (mediaDescriptor[i].Name.equals("URL")) {
                    sURL = AnyConverter.toString((Object)mediaDescriptor[i].Value);
                    continue;
                }
                if (mediaDescriptor[i].Name.equals("InputStream") || !mediaDescriptor[i].Name.equals("StatusIndicator")) continue;
                xStatusIndicator = (XStatusIndicator)AnyConverter.toObject(XStatusIndicator.class, (Object)mediaDescriptor[i].Value);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (sURL == null) {
            return false;
        }
        XTextDocument xText = null;
        TeXImportFilter teXImportFilter = this;
        synchronized (teXImportFilter) {
            if (this.m_nState != 2) {
                return false;
            }
            xText = this.m_xTargetDoc;
            this.m_nState = 0;
        }
        boolean bResult = this.importTeX(xText, sURL, xStatusIndicator);
        this.m_nState = 2;
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TeXImportFilter teXImportFilter = this;
        synchronized (teXImportFilter) {
            if (this.m_nState == 0) {
                this.m_nState = 1;
            }
        }
        while (true) {
            teXImportFilter = this;
            synchronized (teXImportFilter) {
                if (this.m_nState == 2) {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importTeX(XTextDocument xText, String sURL, XStatusIndicator xStatus) {
        String sODTURL;
        String sBaseName;
        int nStep = 0;
        if (xStatus != null) {
            xStatus.start("Writer2LaTeX", 10);
            xStatus.setValue(++nStep);
        }
        File file = null;
        try {
            file = new File(new URI(sURL));
        }
        catch (URISyntaxException e) {
            if (xStatus != null) {
                xStatus.end();
            }
            return false;
        }
        if (xStatus != null) {
            xStatus.setValue(++nStep);
        }
        if ((sBaseName = file.getName()).endsWith(".tex")) {
            sBaseName = sBaseName.substring(0, sBaseName.length() - 4);
        }
        File odtFile = new File(file.getParentFile(), sBaseName + ".odt");
        File tempFile = null;
        if (odtFile.exists()) {
            try {
                tempFile = File.createTempFile("w2l", ".tmp", file.getParentFile());
            }
            catch (IOException e) {
                if (xStatus != null) {
                    xStatus.end();
                }
                return false;
            }
            odtFile.renameTo(tempFile);
        }
        if (xStatus != null) {
            xStatus.setValue(++nStep);
        }
        ExternalApps externalApps = new ExternalApps(this.m_xContext);
        externalApps.load();
        if (xStatus != null) {
            xStatus.setValue(++nStep);
        }
        String sCommand = "oolatex";
        if ("org.openoffice.da.writer2latex.xelatex".equals(this.m_sFilterName)) {
            sCommand = "ooxelatex";
        }
        externalApps.execute("Mk4ht", sCommand, file.getName(), file.getParentFile(), null, true);
        if (xStatus != null) {
            xStatus.setValue(nStep += 5);
        }
        if ((sODTURL = sURL).endsWith(".tex")) {
            sODTURL = sODTURL.substring(0, sODTURL.length() - 4);
        }
        sODTURL = sODTURL + ".odt";
        boolean bSuccess = true;
        TeXImportFilter teXImportFilter = this;
        synchronized (teXImportFilter) {
            if (this.m_nState == 1) {
                bSuccess = false;
            }
        }
        if (xStatus != null) {
            xStatus.end();
        }
        if (bSuccess) {
            XTextCursor xTextCursor = xText.getText().createTextCursor();
            XDocumentInsertable xDocInsert = (XDocumentInsertable)UnoRuntime.queryInterface(XDocumentInsertable.class, (Object)xTextCursor);
            try {
                PropertyValue[] props = new PropertyValue[]{};
                xDocInsert.insertDocumentFromURL(sODTURL, props);
            }
            catch (IllegalArgumentException e) {
                bSuccess = false;
            }
            catch (com.sun.star.io.IOException e) {
                bSuccess = false;
            }
        }
        odtFile.delete();
        if (tempFile != null) {
            tempFile.renameTo(odtFile);
        }
        return bSuccess;
    }
}

