/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.objectbank.TokenizerFactory;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.process.WordSegmenter;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordSegmentingTokenizer
extends AbstractTokenizer<Word> {
    private Iterator<Word> wordIter;
    private Tokenizer<Word> tok;
    private WordSegmenter wordSegmenter;

    @Override
    protected Word getNext() {
        while (this.wordIter == null || !this.wordIter.hasNext()) {
            if (!this.tok.hasNext()) {
                return null;
            }
            String s = this.tok.next().word();
            if (s == null) {
                return null;
            }
            ArrayList<Word> se = this.segmentWords(s);
            this.wordIter = se.iterator();
        }
        return this.wordIter.next();
    }

    public WordSegmentingTokenizer(WordSegmenter wordSegmenter, Reader r) {
        this.wordSegmenter = wordSegmenter;
        this.tok = WhitespaceTokenizer.newWordWhitespaceTokenizer(r);
    }

    public ArrayList<Word> segmentWords(String s) {
        return this.wordSegmenter.segmentWords(s);
    }

    public static TokenizerFactory<Word> factory(WordSegmenter wordSegmenter) {
        return new WordSegmentingTokenizerFactory(wordSegmenter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WordSegmentingTokenizerFactory
    implements TokenizerFactory<Word>,
    Serializable {
        WordSegmenter wordSegmenter;
        private static final long serialVersionUID = 1L;

        public WordSegmentingTokenizerFactory(WordSegmenter wordSegmenter) {
            this.wordSegmenter = wordSegmenter;
        }

        @Override
        public Iterator<Word> getIterator(Reader r) {
            return this.getTokenizer(r);
        }

        @Override
        public Tokenizer<Word> getTokenizer(Reader r) {
            return new WordSegmentingTokenizer(this.wordSegmenter, r);
        }

        @Override
        public void setOptions(String options) {
        }
    }
}

