/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;

public class CommandCreoleMonospaced
implements Command {
    private final Pattern2 pattern;
    private final String monospacedFamily;

    public static Command create(String monospacedFamily) {
        return new CommandCreoleMonospaced("^(?i)(\"\"(.*?)\"\")", monospacedFamily);
    }

    private CommandCreoleMonospaced(String p, String monospacedFamily) {
        this.pattern = MyPattern.cmpile(p);
        this.monospacedFamily = monospacedFamily;
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc1 = stripe.getActualFontConfiguration();
        FontConfiguration fc2 = fc1.changeFamily(this.monospacedFamily);
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m.group(2));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m.group(1).length());
    }
}

