/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.geom.InflateData;
import net.sourceforge.plantuml.geom.Pointable;

public class Point2DInt
extends Point2D
implements Pointable {
    private final int x;
    private final int y;

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public Point2DInt(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getXint() {
        return this.x;
    }

    public int getYint() {
        return this.y;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public void setLocation(double x, double y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Point2DInt getPosition() {
        return this;
    }

    public Point2DInt translate(int deltaX, int deltaY) {
        return new Point2DInt(this.x + deltaX, this.y + deltaY);
    }

    public Point2DInt inflateX(int xpos, int inflation) {
        if (inflation % 2 != 0) {
            throw new IllegalArgumentException();
        }
        if (this.x < xpos) {
            return this;
        }
        if (this.x == xpos) {
            return this.translate(inflation / 2, 0);
        }
        return this.translate(inflation, 0);
    }

    public Point2DInt inflateX(InflateData inflateData) {
        return this.inflateX(inflateData.getPos(), inflateData.getInflation());
    }

    public Point2DInt inflateY(InflateData inflateData) {
        return this.inflateY(inflateData.getPos(), inflateData.getInflation());
    }

    public Point2DInt inflateY(int ypos, int inflation) {
        if (inflation % 2 != 0) {
            throw new IllegalArgumentException();
        }
        if (this.y < ypos) {
            return this;
        }
        if (this.y == ypos) {
            return this.translate(0, inflation / 2);
        }
        return this.translate(0, inflation);
    }
}

