/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.navigator;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.components.Stainable;
import net.sf.sdedit.ui.components.navigator.TreeNavigatorNode;

public class TreeNavigatorNodeRenderer
extends JPanel
implements TreeCellRenderer {
    private static final long serialVersionUID = -8131576175100053862L;
    private boolean stained;
    private DefaultTreeCellRenderer renderer;
    private JLabel saveIconLabel;

    public TreeNavigatorNodeRenderer() {
        this.setLayout(new BoxLayout(this, 0));
        this.renderer = new DefaultTreeCellRenderer();
        this.setOpaque(false);
        this.saveIconLabel = new JLabel(Icons.getIcon("save"));
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.renderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        TreeNavigatorNode node = (TreeNavigatorNode)value;
        this.stained = false;
        if (Stainable.class.isInstance(node.getComponent()) && !((Stainable)Stainable.class.cast(node.getComponent())).isClean()) {
            this.stained = true;
        }
        this.removeAll();
        this.renderer.setText(node.getTitle());
        this.renderer.setIcon(node.getIcon());
        this.renderer.setOpaque(false);
        this.add(this.renderer);
        this.add(Box.createRigidArea(new Dimension(3, 1)));
        if (this.stained) {
            this.add(this.saveIconLabel);
        } else {
            this.add(Box.createRigidArea(this.saveIconLabel.getPreferredSize()));
        }
        return this;
    }
}

