/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class CollectionState {
    private Object[] state = new Object[0];
    private List<CollectionStateChangeListener> listeners = new LinkedList<CollectionStateChangeListener>();

    public void addListener(CollectionStateChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CollectionStateChangeListener listener) {
        this.listeners.remove(listener);
    }

    public Object[] getState() {
        return this.state;
    }

    public void update(Collection<?> newColl) {
        Object[] newState = newColl.toArray();
        int m = this.state.length;
        int n = newState.length;
        int t = Math.max(m, n);
        LinkedList<Integer> added = new LinkedList<Integer>();
        LinkedList<Integer> removed = new LinkedList<Integer>();
        LinkedList<Integer> changed = new LinkedList<Integer>();
        for (int i = 0; i < t; ++i) {
            if (i >= m) {
                added.add(i);
                continue;
            }
            if (i >= n) {
                removed.add(i);
                continue;
            }
            if (!this.state[i].equals(newState[i])) continue;
            changed.add(i);
        }
        int[] _added = CollectionState.toIntArray(added);
        int[] _removed = CollectionState.toIntArray(removed);
        int[] _changed = CollectionState.toIntArray(changed);
        for (CollectionStateChangeListener listener : this.listeners) {
            listener.itemsChanged(_changed);
            if (_removed.length > 0) {
                listener.itemsRemoved(_removed);
                continue;
            }
            if (_added.length <= 0) continue;
            listener.itemsAdded(_added);
        }
        this.state = newState;
    }

    private static int[] toIntArray(List<Integer> list) {
        int[] arr = new int[list.size()];
        int j = 0;
        for (Integer i : list) {
            arr[j] = i;
            ++j;
        }
        return arr;
    }

    public static interface CollectionStateChangeListener {
        public void itemsAdded(int[] var1);

        public void itemsRemoved(int[] var1);

        public void itemsChanged(int[] var1);
    }
}

