/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.sdedit.util.ObjectFactory;
import net.sf.sdedit.util.PWriter;
import net.sf.sdedit.util.Pair;
import net.sf.sdedit.util.Utilities;

public class LookupTable<T>
implements Serializable {
    private static final long serialVersionUID = 8407940305663509149L;
    private final Map<String, T> rows;
    private transient SortedMap<String, PropertyDescriptor> keys;
    private transient Map<String, PropertyDescriptor> values;
    private final Class<T> type;
    private T last;
    private Map<Object, T> hashMap;
    private boolean checkKeys;

    public LookupTable(Class<T> type) {
        this.type = type;
        this.rows = new LinkedHashMap<String, T>();
        this.keys = new TreeMap<String, PropertyDescriptor>();
        this.values = new HashMap<String, PropertyDescriptor>();
        this.checkKeys = true;
        try {
            this.initialize();
        }
        catch (IntrospectionException ie) {
            throw new IllegalArgumentException(ie);
        }
    }

    public T getLastAdded() {
        return this.last;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.keys = new TreeMap<String, PropertyDescriptor>();
        this.values = new HashMap<String, PropertyDescriptor>();
        try {
            this.initialize();
        }
        catch (IntrospectionException ie) {
            throw new IllegalArgumentException(ie);
        }
    }

    public void setUseHashing(boolean use) {
        this.hashMap = use ? new HashMap<Object, T>() : null;
    }

    public int getSize() {
        return this.rows.size();
    }

    public String toString() {
        PWriter pw = PWriter.create();
        for (T t : this.rows.values()) {
            pw.println(Utilities.toMap(t).toString());
        }
        return pw.toString();
    }

    private void initialize() throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(this.type);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor property = propertyDescriptors[i];
            Method method = property.getReadMethod();
            if (method == null || !method.isAnnotationPresent(Column.class)) continue;
            Column column = method.getAnnotation(Column.class);
            if (column.isKey()) {
                this.keys.put(property.getName(), property);
                continue;
            }
            this.values.put(property.getName(), property);
        }
    }

    private Map<String, Object> getKeys(T t) {
        LinkedHashMap<String, Object> k = new LinkedHashMap<String, Object>(this.keys.size());
        for (Map.Entry<String, PropertyDescriptor> entry : this.keys.entrySet()) {
            Object value = null;
            if (t != null) {
                try {
                    value = entry.getValue().getReadMethod().invoke(t, new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            k.put(entry.getKey(), value);
        }
        return k;
    }

    public T add(T t) {
        String keyString = this.getKeys(t).toString();
        T previous = this.rows.put(keyString, t);
        this.last = t;
        return previous;
    }

    public Map<String, Object> getKeyMap(Object o) {
        Map<String, Object> okeys = this.getKeys(null);
        for (Map.Entry<String, Object> entry : Utilities.toMap(o).entrySet()) {
            String key = entry.getKey();
            if (!okeys.containsKey(key)) continue;
            okeys.put(entry.getKey(), this.cast(((PropertyDescriptor)this.keys.get(key)).getPropertyType(), entry.getValue()));
        }
        return okeys;
    }

    public T getBestMatch(Object o) throws TooManyMatches {
        T match;
        if (this.hashMap != null && (match = this.hashMap.get(o)) != null) {
            return match;
        }
        Map<String, Object> okeys = this.getKeyMap(o);
        TreeMap<Integer, List<T>> matches = this.getMatches(okeys);
        if (matches.isEmpty()) {
            return null;
        }
        List<T> best = matches.firstEntry().getValue();
        if (best.size() == 1) {
            match = best.get(0);
            if (this.hashMap != null) {
                this.hashMap.put(o, match);
            }
            return match;
        }
        ArrayList<Object> obj = new ArrayList<Object>();
        obj.addAll(best);
        throw new TooManyMatches(o, obj);
    }

    private TreeMap<Integer, List<T>> getMatches(Map<String, Object> tkeys) {
        if (!tkeys.keySet().equals(this.keys.keySet())) {
            throw new IllegalArgumentException("map keys do not match: " + tkeys.keySet());
        }
        TreeMap<Integer, List<T>> matches = new TreeMap<Integer, List<T>>();
        block0: for (T row : this.rows.values()) {
            Map<String, Object> rkeys = this.getKeys(row);
            int nulls = 0;
            for (Pair<Object, Object> pair : Utilities.pairs(tkeys.values(), rkeys.values())) {
                if (pair.getSecond() == null) {
                    ++nulls;
                    continue;
                }
                if (pair.getFirst() != null && pair.getFirst().equals(pair.getSecond())) continue;
                continue block0;
            }
            List<T> list = matches.get(nulls);
            if (list == null) {
                list = new ArrayList<T>();
                matches.put(nulls, list);
            }
            list.add(row);
        }
        return matches;
    }

    private Object cast(Class<?> type, Object value) {
        if (value == null || type.isInstance(value)) {
            return value;
        }
        return ObjectFactory.createFromString(type, value.toString());
    }

    public T add(String ... keyVal) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < keyVal.length; i += 2) {
            map.put(keyVal[i], keyVal[i + 1]);
        }
        return this.add((Map<String, Object>)map);
    }

    public T add(Map<String, Object> map) {
        Object value;
        T row;
        try {
            row = this.type.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (PropertyDescriptor desc : this.keys.values()) {
            value = map.remove(desc.getName());
            value = this.cast(desc.getPropertyType(), value);
            if (value == null) continue;
            try {
                desc.getWriteMethod().invoke(row, value);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        for (PropertyDescriptor desc : this.values.values()) {
            value = map.remove(desc.getName());
            if (value == null) continue;
            value = this.cast(desc.getPropertyType(), value);
            try {
                desc.getWriteMethod().invoke(row, value);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (this.checkKeys && !map.isEmpty()) {
            throw new IllegalArgumentException("some keys could not be found: " + map.keySet());
        }
        return this.add(row);
    }

    public boolean isCheckKeys() {
        return this.checkKeys;
    }

    public void setCheckKeys(boolean checkKeys) {
        this.checkKeys = checkKeys;
    }

    public static class TooManyMatches
    extends Exception {
        private static final long serialVersionUID = 6220615962525615889L;
        private String message;

        public TooManyMatches(Object fact, List<Object> ts) {
            PWriter p = PWriter.create();
            p.println("Could not find unique best match for " + Utilities.toMap(fact));
            p.println("There are " + ts.size() + " matches:");
            for (Object t : ts) {
                p.println(Utilities.toMap(t));
            }
            this.message = p.toString();
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Column {
        public boolean isKey();
    }
}

