/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;

public class EMFHeader
implements EMFConstants {
    public static final Dimension screenMM = new Dimension(320, 240);
    private Rectangle bounds;
    private Rectangle frame;
    private String signature;
    private int versionMajor;
    private int versionMinor;
    private int bytes;
    private int records;
    private int handles;
    private String description;
    private int palEntries;
    private Dimension device;
    private Dimension millimeters;
    private Dimension micrometers;
    private boolean openGL;

    public EMFHeader(Rectangle bounds, int versionMajor, int versionMinor, int bytes, int records, int handles, String application, String name, Dimension device) {
        this.bounds = bounds;
        double pixelWidth = (double)EMFHeader.screenMM.width / (double)device.width;
        double pixelHeight = (double)EMFHeader.screenMM.height / (double)device.height;
        this.frame = new Rectangle((int)((double)(bounds.x * 100) * pixelWidth), (int)((double)(bounds.y * 100) * pixelHeight), (int)((double)(bounds.width * 100) * pixelWidth), (int)((double)(bounds.height * 100) * pixelHeight));
        this.signature = " EMF";
        this.versionMajor = versionMajor;
        this.versionMinor = versionMinor;
        this.bytes = bytes;
        this.records = records;
        this.handles = handles;
        this.description = application.trim() + "\u0000" + name.trim() + "\u0000\u0000";
        this.palEntries = 0;
        this.device = device;
        this.millimeters = screenMM;
        this.openGL = false;
        this.micrometers = new Dimension(EMFHeader.screenMM.width * 1000, EMFHeader.screenMM.height * 1000);
    }

    EMFHeader(EMFInputStream emf) throws IOException {
        emf.readUnsignedInt();
        int length = emf.readDWORD();
        this.bounds = emf.readRECTL();
        this.frame = emf.readRECTL();
        this.signature = new String(emf.readBYTE(4));
        int version = emf.readDWORD();
        this.versionMajor = version >> 16;
        this.versionMinor = version & 0xFFFF;
        this.bytes = emf.readDWORD();
        this.records = emf.readDWORD();
        this.handles = emf.readWORD();
        emf.readWORD();
        int dLen = emf.readDWORD();
        int dOffset = emf.readDWORD();
        this.palEntries = emf.readDWORD();
        this.device = emf.readSIZEL();
        this.millimeters = emf.readSIZEL();
        int bytesRead = 88;
        if (dOffset > 88) {
            emf.readDWORD();
            emf.readDWORD();
            this.openGL = emf.readDWORD() != 0;
            bytesRead += 12;
            if (dOffset > 100) {
                this.micrometers = emf.readSIZEL();
                bytesRead += 8;
            }
        }
        if (bytesRead < dOffset) {
            emf.skipBytes(dOffset - bytesRead);
            bytesRead = dOffset;
        }
        this.description = emf.readWCHAR(dLen);
        if ((bytesRead += dLen * 2) < length) {
            emf.skipBytes(length - bytesRead);
        }
    }

    public void write(EMFOutputStream emf) throws IOException {
        int align = emf.getTagAlignment();
        int padding = (align - this.size() % align) % align;
        int alignedSize = this.size() + padding;
        emf.writeDWORD(1);
        emf.writeDWORD(alignedSize);
        emf.writeRECTL(this.bounds);
        emf.writeRECTL(this.frame);
        emf.writeBYTE(this.signature.getBytes());
        emf.writeDWORD(this.versionMajor << 16 | this.versionMinor);
        emf.writeDWORD(alignedSize + this.bytes);
        emf.writeDWORD(this.records);
        emf.writeWORD(this.handles);
        emf.writeWORD(0);
        emf.writeDWORD(this.description.length());
        emf.writeDWORD(108);
        emf.writeDWORD(this.palEntries);
        emf.writeSIZEL(this.device);
        emf.writeSIZEL(this.millimeters);
        emf.writeDWORD(0);
        emf.writeDWORD(0);
        emf.writeDWORD(this.openGL);
        emf.writeSIZEL(this.micrometers);
        emf.writeWCHAR(this.description);
        for (int i = 0; i < padding; ++i) {
            emf.write(0);
        }
    }

    public int size() {
        return 108 + 2 * this.description.length();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("EMF Header\n");
        s.append("  bounds: ").append(this.bounds).append("\n");
        s.append("  frame: ").append(this.frame).append("\n");
        s.append("  signature: ").append(this.signature).append("\n");
        s.append("  versionMajor: ").append(this.versionMajor).append("\n");
        s.append("  versionMinor: ").append(this.versionMinor).append("\n");
        s.append("  #bytes: ").append(this.bytes).append("\n");
        s.append("  #records: ").append(this.records).append("\n");
        s.append("  #handles: ").append(this.handles).append("\n");
        s.append("  description: ").append(this.description).append("\n");
        s.append("  #palEntries: ").append(this.palEntries).append("\n");
        s.append("  device: ").append(this.device).append("\n");
        s.append("  millimeters: ").append(this.millimeters).append("\n");
        s.append("  openGL: ").append(this.openGL).append("\n");
        s.append("  micrometers: ").append(this.micrometers);
        return s.toString();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public Rectangle getFrame() {
        return this.frame;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getDescription() {
        return this.description;
    }

    public Dimension getDevice() {
        return this.device;
    }

    public Dimension getMillimeters() {
        return this.millimeters;
    }

    public Dimension getMicrometers() {
        return this.micrometers;
    }

    public boolean isOpenGL() {
        return this.openGL;
    }
}

