/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SpatialQueryable;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SpatialOptions;
import org.apache.solr.search.SyntaxError;

public class SpatialFilterQParser
extends QParser {
    boolean bbox;

    public SpatialFilterQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req, boolean bbox) {
        super(qstr, localParams, params, req);
        this.bbox = bbox;
    }

    @Override
    public Query parse() throws SyntaxError {
        String pointStr;
        String[] fields = this.localParams.getParams("f");
        if (fields == null || fields.length == 0) {
            String field = this.getParam("sfield");
            if (field == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, " missing sfield for spatial request");
            }
            fields = new String[]{field};
        }
        if ((pointStr = this.getParam("pt")) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "pt missing.");
        }
        double dist = -1.0;
        String distS = this.getParam("d");
        if (distS != null) {
            dist = Double.parseDouble(distS);
        }
        if (dist < 0.0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "d must be >= 0");
        }
        String measStr = this.localParams.get("meas");
        Query result = null;
        if (fields.length == 1) {
            SchemaField sf = this.req.getSchema().getField(fields[0]);
            FieldType type = sf.getType();
            if (type instanceof SpatialQueryable) {
                SpatialQueryable queryable = (SpatialQueryable)((Object)type);
                double radius = this.localParams.getDouble("sphere_radius", queryable.getSphereRadius());
                SpatialOptions opts = new SpatialOptions(pointStr, dist, sf, measStr, radius);
                opts.bbox = this.bbox;
                result = queryable.createSpatialQuery(this, opts);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The field " + fields[0] + " does not support spatial filtering");
            }
        }
        return result;
    }
}

