/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request.json;

import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;

class JsonQueryConverter {
    private int numParams = 0;

    JsonQueryConverter() {
    }

    String toLocalParams(Object jsonQueryObject, Map<String, String[]> additionalParams) {
        if (jsonQueryObject instanceof String) {
            return jsonQueryObject.toString();
        }
        StringBuilder builder = new StringBuilder();
        this.buildLocalParams(builder, jsonQueryObject, true, additionalParams);
        return builder.toString();
    }

    private String putParam(String val, Map<String, String[]> additionalParams) {
        String name = "_tt" + this.numParams++;
        additionalParams.put(name, new String[]{val});
        return name;
    }

    private void buildLocalParams(StringBuilder builder, Object val, boolean isQParser, Map<String, String[]> additionalParams) {
        boolean useSubBuilder;
        if (!isQParser && !(val instanceof Map)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error when parsing json query, expect a json object here, but found : " + val);
        }
        boolean bl = useSubBuilder = builder.length() > 0;
        if (val instanceof String) {
            if (!useSubBuilder) {
                builder.append(val.toString());
            } else {
                builder.append('$').append(this.putParam(val.toString(), additionalParams));
            }
            return;
        }
        if (val instanceof Number) {
            builder.append(val);
            return;
        }
        if (!(val instanceof Map)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error when parsing json query, expect a json object here, but found : " + val);
        }
        Map map = (Map)val;
        if (isQParser) {
            if (map.size() != 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error when parsing json query, expect only one query parser here, but found : " + map.keySet());
            }
            String qtype = (String)map.keySet().iterator().next();
            String tagName = null;
            if (qtype.startsWith("#")) {
                Object taggedQueryObject = map.get(qtype);
                tagName = qtype.substring(1);
                if (taggedQueryObject instanceof String) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("{!tag=").append(tagName).append("}");
                    sb.append(taggedQueryObject.toString());
                    this.buildLocalParams(builder, sb.toString(), true, additionalParams);
                    return;
                }
                if (taggedQueryObject instanceof Map) {
                    map = (Map)taggedQueryObject;
                    qtype = (String)map.keySet().iterator().next();
                }
            } else if (qtype.equals("param")) {
                boolean toplevel = builder.length() == 0;
                if (toplevel) {
                    builder.append("{!v=");
                }
                builder.append("$").append(map.get("param"));
                if (toplevel) {
                    builder.append("}");
                }
                return;
            }
            StringBuilder subBuilder = useSubBuilder ? new StringBuilder() : builder;
            Object subVal = map.get(qtype);
            subBuilder = subBuilder.append("{!").append(qtype).append(' ');
            if (tagName != null) {
                subBuilder.append("tag=").append(tagName).append(' ');
            }
            this.buildLocalParams(subBuilder, subVal, false, additionalParams);
            subBuilder.append("}");
            if (useSubBuilder) {
                builder.append('$').append(this.putParam(subBuilder.toString(), additionalParams));
            }
        } else if (map.size() == 1 && ((String)map.keySet().iterator().next()).equals("param")) {
            builder.append("v").append("=$").append(map.get("param")).append(" ");
        } else {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                if (entry.getValue() instanceof List) {
                    if (key.equals("query")) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error when parsing json query, value of query field should not be a list, found : " + entry.getValue());
                    }
                    List l = (List)entry.getValue();
                    for (Object subVal : l) {
                        builder.append(key).append("=");
                        this.buildLocalParams(builder, subVal, true, additionalParams);
                        builder.append(" ");
                    }
                    continue;
                }
                if (key.equals("query")) {
                    key = "v";
                }
                builder.append(key).append("=");
                this.buildLocalParams(builder, entry.getValue(), true, additionalParams);
                builder.append(" ");
            }
        }
    }
}

