/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.network;

import com.tigervnc.network.Socket;
import com.tigervnc.network.SocketDescriptor;
import com.tigervnc.network.SocketException;
import com.tigervnc.rdr.Exception;
import com.tigervnc.rdr.FdInStream;
import com.tigervnc.rdr.FdOutStream;
import com.tigervnc.rfb.LogWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;

public class TcpSocket
extends Socket {
    public static boolean socketsInitialised = false;
    private boolean closeFd;
    static LogWriter vlog = new LogWriter("TcpSocket");

    public static void initSockets() {
        if (socketsInitialised) {
            return;
        }
        socketsInitialised = true;
    }

    public TcpSocket(SocketDescriptor socketDescriptor, boolean bl) {
        super(new FdInStream(socketDescriptor), new FdOutStream(socketDescriptor), true);
        this.closeFd = bl;
    }

    public TcpSocket(SocketDescriptor socketDescriptor) {
        this(socketDescriptor, true);
    }

    public TcpSocket(String string, int n) throws Exception {
        this.closeFd = true;
        SocketDescriptor socketDescriptor = null;
        InetAddress inetAddress = null;
        boolean bl = false;
        TcpSocket.initSockets();
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new Exception("unable to resolve host by name: " + unknownHostException.toString());
        }
        try {
            socketDescriptor = new SocketDescriptor();
        }
        catch (Exception exception) {
            throw new SocketException("unable to create socket: " + exception.toString());
        }
        try {
            bl = socketDescriptor.connect(new InetSocketAddress(inetAddress, n));
            Selector selector = Selector.open();
            SelectionKey selectionKey = socketDescriptor.socket().getChannel().register(selector, 8);
            while (selector.select(250L) > 0) {
                while (!bl) {
                    Set<SelectionKey> set = selector.selectedKeys();
                    Iterator<SelectionKey> iterator = set.iterator();
                    while (iterator.hasNext()) {
                        SelectionKey selectionKey2 = iterator.next();
                        iterator.remove();
                        if (!selectionKey2.isConnectable()) continue;
                        if (socketDescriptor.isConnectionPending()) {
                            socketDescriptor.finishConnect();
                        }
                        bl = true;
                    }
                }
            }
            if (!bl) {
                throw new SocketException("unable to connect to socket: Host is down");
            }
        }
        catch (IOException iOException) {
            throw new SocketException("unable to connect:" + iOException.getMessage());
        }
        TcpSocket.enableNagles(socketDescriptor, false);
        this.instream = new FdInStream(socketDescriptor);
        this.outstream = new FdOutStream(socketDescriptor);
        this.ownStreams = true;
    }

    protected void finalize() throws Exception {
        if (this.closeFd) {
            try {
                ((SocketDescriptor)this.getFd()).close();
            }
            catch (IOException iOException) {
                throw new Exception(iOException.getMessage());
            }
        }
    }

    @Override
    public int getMyPort() {
        return this.getSockPort();
    }

    @Override
    public String getPeerAddress() {
        InetAddress inetAddress = ((SocketDescriptor)this.getFd()).socket().getInetAddress();
        if (inetAddress != null) {
            return inetAddress.getHostAddress();
        }
        return "";
    }

    @Override
    public String getPeerName() {
        InetAddress inetAddress = ((SocketDescriptor)this.getFd()).socket().getInetAddress();
        if (inetAddress != null) {
            return inetAddress.getHostName();
        }
        return "";
    }

    @Override
    public int getPeerPort() {
        int n = ((SocketDescriptor)this.getFd()).socket().getPort();
        return n;
    }

    @Override
    public String getPeerEndpoint() {
        String string = this.getPeerAddress();
        int n = this.getPeerPort();
        return string + "::" + n;
    }

    @Override
    public boolean sameMachine() throws Exception {
        try {
            SocketAddress socketAddress = ((SocketDescriptor)this.getFd()).getRemoteAddress();
            SocketAddress socketAddress2 = ((SocketDescriptor)this.getFd()).getLocalAddress();
            return socketAddress2.equals(socketAddress);
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        try {
            ((SocketDescriptor)this.getFd()).shutdown();
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        ((SocketDescriptor)this.getFd()).close();
    }

    public static boolean enableNagles(SocketDescriptor socketDescriptor, boolean bl) {
        try {
            socketDescriptor.channel.socket().setTcpNoDelay(!bl);
        }
        catch (java.net.SocketException socketException) {
            vlog.error("unable to setsockopt TCP_NODELAY: " + socketException.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    public static boolean isSocket(java.net.Socket socket) {
        return socket.getClass().toString().equals("com.tigervnc.net.Socket");
    }

    public boolean isConnected() {
        return ((SocketDescriptor)this.getFd()).isConnected();
    }

    public int getSockPort() {
        return ((SocketDescriptor)this.getFd()).socket().getLocalPort();
    }

    public static int findFreeTcpPort() {
        int n;
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            n = serverSocket.getLocalPort();
            serverSocket.close();
        }
        catch (IOException iOException) {
            throw new SocketException("unable to create socket: " + iOException.toString());
        }
        return n;
    }
}

