// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from STM32F303.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/STMicro

// +build stm32,stm32f303

// STM32F303
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32F303"
)

// Interrupt numbers.
const (
	IRQ_WWDG               = 0  // Window watchdog
	IRQ_PVD                = 1  // Power control
	IRQ_TAMP_STAMP         = 2  // External interrupt/event controller
	IRQ_RTC_WKUP           = 3  // Real-time clock
	IRQ_FLASH              = 4  // Flash
	IRQ_RCC                = 5  // Reset and clock control
	IRQ_EXTI0              = 6  // External interrupt/event controller
	IRQ_EXTI1              = 7  // External interrupt/event controller
	IRQ_EXTI2_TSC          = 8  // Touch sensing controller // External interrupt/event controller
	IRQ_EXTI3              = 9  // External interrupt/event controller
	IRQ_EXTI4              = 10 // External interrupt/event controller
	IRQ_DMA1_CH1           = 11 // DMA controller 1
	IRQ_DMA1_CH2           = 12 // DMA controller 1
	IRQ_DMA1_CH3           = 13 // DMA controller 1
	IRQ_DMA1_CH4           = 14 // DMA controller 1
	IRQ_DMA1_CH5           = 15 // DMA controller 1
	IRQ_DMA1_CH6           = 16 // DMA controller 1
	IRQ_DMA1_CH7           = 17 // DMA controller 1
	IRQ_ADC1_2             = 18 // Analog-to-Digital Converter //
	IRQ_USB_HP_CAN_TX      = 19 // Controller area network
	IRQ_USB_LP_CAN_RX0     = 20 // Controller area network
	IRQ_CAN_RX1            = 21 // Controller area network
	IRQ_CAN_SCE            = 22 // Controller area network
	IRQ_EXTI9_5            = 23 // External interrupt/event controller
	IRQ_TIM1_BRK_TIM15     = 24 // General purpose timers
	IRQ_TIM1_UP_TIM16      = 25 // General-purpose-timers
	IRQ_TIM1_TRG_COM_TIM17 = 26 // General purpose timer
	IRQ_TIM1_CC            = 27 // Advanced timer //
	IRQ_TIM2               = 28 // General purpose timer
	IRQ_TIM3               = 29 //
	IRQ_TIM4               = 30 //
	IRQ_I2C1_EV_EXTI23     = 31 // External interrupt/event controller // Inter-integrated circuit
	IRQ_I2C1_ER            = 32 // Inter-integrated circuit
	IRQ_I2C2_EV_EXTI24     = 33 //
	IRQ_I2C2_ER            = 34 //
	IRQ_SPI1               = 35 // Serial peripheral interface/Inter-IC sound
	IRQ_SPI2               = 36 //
	IRQ_USART1_EXTI25      = 37 // Universal synchronous asynchronous receiver transmitter // External interrupt/event controller
	IRQ_USART2_EXTI26      = 38 // External interrupt/event controller //
	IRQ_USART3_EXTI28      = 39 // External interrupt/event controller //
	IRQ_EXTI15_10          = 40 // External interrupt/event controller
	IRQ_RTCAlarm           = 41 // Real-time clock
	IRQ_USB_WKUP           = 42 // Universal serial bus full-speed device interface
	IRQ_TIM8_BRK           = 43 // Advanced-timers
	IRQ_TIM8_UP            = 44 // Advanced-timers
	IRQ_TIM8_TRG_COM       = 45 // Advanced-timers
	IRQ_TIM8_CC            = 46 // Advanced-timers
	IRQ_ADC3               = 47 //
	IRQ_FMC                = 48 // Flexible memory controller
	IRQ_SPI3               = 51 //
	IRQ_UART4_EXTI34       = 52 // External interrupt/event controller //
	IRQ_UART5_EXTI35       = 53 // External interrupt/event controller //
	IRQ_TIM6_DACUNDER      = 54 // Basic timers // Digital-to-analog converter
	IRQ_TIM7               = 55 //
	IRQ_DMA2_CH1           = 56 //
	IRQ_DMA2_CH2           = 57 //
	IRQ_DMA2_CH3           = 58 //
	IRQ_DMA2_CH4           = 59 //
	IRQ_DMA2_CH5           = 60 //
	IRQ_ADC4               = 61 //
	IRQ_COMP123            = 64 // System configuration controller _Comparator and Operational amplifier
	IRQ_COMP456            = 65 // System configuration controller _Comparator and Operational amplifier
	IRQ_COMP7              = 66 // System configuration controller _Comparator and Operational amplifier
	IRQ_I2C3_EV            = 72 //
	IRQ_I2C3_ER            = 73 //
	IRQ_USB_HP             = 74 // Universal serial bus full-speed device interface
	IRQ_USB_LP             = 75 // Universal serial bus full-speed device interface
	IRQ_USB_WKUP_EXTI      = 76 // External interrupt/event controller
	IRQ_TIM20_BRK          = 77 //
	IRQ_TIM20_UP           = 78 //
	IRQ_TIM20_TRG_COM      = 79 //
	IRQ_TIM20_CC           = 80 //
	IRQ_FPU                = 81 // Floting point unit
	IRQ_SPI4               = 84 //
	IRQ_max                = 84 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG, "WWDG_IRQHandler")
	_ = interrupt.Register(IRQ_PVD, "PVD_IRQHandler")
	_ = interrupt.Register(IRQ_TAMP_STAMP, "TAMP_STAMP_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_WKUP, "RTC_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH, "FLASH_IRQHandler")
	_ = interrupt.Register(IRQ_RCC, "RCC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0, "EXTI0_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI1, "EXTI1_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2_TSC, "EXTI2_TSC_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI3, "EXTI3_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4, "EXTI4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH1, "DMA1_CH1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH2, "DMA1_CH2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH3, "DMA1_CH3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH4, "DMA1_CH4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH5, "DMA1_CH5_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH6, "DMA1_CH6_IRQHandler")
	_ = interrupt.Register(IRQ_DMA1_CH7, "DMA1_CH7_IRQHandler")
	_ = interrupt.Register(IRQ_ADC1_2, "ADC1_2_IRQHandler")
	_ = interrupt.Register(IRQ_USB_HP_CAN_TX, "USB_HP_CAN_TX_IRQHandler")
	_ = interrupt.Register(IRQ_USB_LP_CAN_RX0, "USB_LP_CAN_RX0_IRQHandler")
	_ = interrupt.Register(IRQ_CAN_RX1, "CAN_RX1_IRQHandler")
	_ = interrupt.Register(IRQ_CAN_SCE, "CAN_SCE_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI9_5, "EXTI9_5_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_TIM15, "TIM1_BRK_TIM15_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_UP_TIM16, "TIM1_UP_TIM16_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_TRG_COM_TIM17, "TIM1_TRG_COM_TIM17_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC, "TIM1_CC_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2, "TIM2_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3, "TIM3_IRQHandler")
	_ = interrupt.Register(IRQ_TIM4, "TIM4_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_EV_EXTI23, "I2C1_EV_EXTI23_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_ER, "I2C1_ER_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_EV_EXTI24, "I2C2_EV_EXTI24_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_ER, "I2C2_ER_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1, "SPI1_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2, "SPI2_IRQHandler")
	_ = interrupt.Register(IRQ_USART1_EXTI25, "USART1_EXTI25_IRQHandler")
	_ = interrupt.Register(IRQ_USART2_EXTI26, "USART2_EXTI26_IRQHandler")
	_ = interrupt.Register(IRQ_USART3_EXTI28, "USART3_EXTI28_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI15_10, "EXTI15_10_IRQHandler")
	_ = interrupt.Register(IRQ_RTCAlarm, "RTCAlarm_IRQHandler")
	_ = interrupt.Register(IRQ_USB_WKUP, "USB_WKUP_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_BRK, "TIM8_BRK_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_UP, "TIM8_UP_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_TRG_COM, "TIM8_TRG_COM_IRQHandler")
	_ = interrupt.Register(IRQ_TIM8_CC, "TIM8_CC_IRQHandler")
	_ = interrupt.Register(IRQ_ADC3, "ADC3_IRQHandler")
	_ = interrupt.Register(IRQ_FMC, "FMC_IRQHandler")
	_ = interrupt.Register(IRQ_SPI3, "SPI3_IRQHandler")
	_ = interrupt.Register(IRQ_UART4_EXTI34, "UART4_EXTI34_IRQHandler")
	_ = interrupt.Register(IRQ_UART5_EXTI35, "UART5_EXTI35_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6_DACUNDER, "TIM6_DACUNDER_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7, "TIM7_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH1, "DMA2_CH1_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH2, "DMA2_CH2_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH3, "DMA2_CH3_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH4, "DMA2_CH4_IRQHandler")
	_ = interrupt.Register(IRQ_DMA2_CH5, "DMA2_CH5_IRQHandler")
	_ = interrupt.Register(IRQ_ADC4, "ADC4_IRQHandler")
	_ = interrupt.Register(IRQ_COMP123, "COMP123_IRQHandler")
	_ = interrupt.Register(IRQ_COMP456, "COMP456_IRQHandler")
	_ = interrupt.Register(IRQ_COMP7, "COMP7_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_EV, "I2C3_EV_IRQHandler")
	_ = interrupt.Register(IRQ_I2C3_ER, "I2C3_ER_IRQHandler")
	_ = interrupt.Register(IRQ_USB_HP, "USB_HP_IRQHandler")
	_ = interrupt.Register(IRQ_USB_LP, "USB_LP_IRQHandler")
	_ = interrupt.Register(IRQ_USB_WKUP_EXTI, "USB_WKUP_EXTI_IRQHandler")
	_ = interrupt.Register(IRQ_TIM20_BRK, "TIM20_BRK_IRQHandler")
	_ = interrupt.Register(IRQ_TIM20_UP, "TIM20_UP_IRQHandler")
	_ = interrupt.Register(IRQ_TIM20_TRG_COM, "TIM20_TRG_COM_IRQHandler")
	_ = interrupt.Register(IRQ_TIM20_CC, "TIM20_CC_IRQHandler")
	_ = interrupt.Register(IRQ_FPU, "FPU_IRQHandler")
	_ = interrupt.Register(IRQ_SPI4, "SPI4_IRQHandler")
)

// Peripherals.
var (
	GPIOA             = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000000)))              // General-purpose I/Os
	GPIOB             = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000400)))              // General-purpose I/Os
	TSC               = (*TSC_Type)(unsafe.Pointer(uintptr(0x40024000)))               // Touch sensing controller
	CRC               = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))               // cyclic redundancy check calculation unit
	Flash             = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))             // Flash
	RCC               = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))               // Reset and clock control
	DMA1              = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))               // DMA controller 1
	TIM2              = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40000000)))              // General purpose timer
	TIM15             = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40014000)))              // General purpose timers
	TIM16             = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40014400)))              // General-purpose-timers
	TIM17             = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40014800)))              // General purpose timer
	USART1            = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))             // Universal synchronous asynchronous receiver transmitter
	SPI1              = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))               // Serial peripheral interface/Inter-IC sound
	EXTI              = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))              // External interrupt/event controller
	PWR               = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))               // Power control
	CAN               = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))               // Controller area network
	USB_FS            = (*USB_FS_Type)(unsafe.Pointer(uintptr(0x40005c00)))            // Universal serial bus full-speed device interface
	I2C1              = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))               // Inter-integrated circuit
	IWDG              = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))              // Independent watchdog
	WWDG              = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))              // Window watchdog
	RTC               = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))               // Real-time clock
	TIM6              = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40001000)))              // Basic timers
	DAC               = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))               // Digital-to-analog converter
	DBGMCU            = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0xe0042000)))            // Debug support
	TIM1              = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40012c00)))              // Advanced timer
	TIM8              = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40013400)))              // Advanced-timers
	ADC1              = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000000)))               // Analog-to-Digital Converter
	ADC1_2            = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000300)))               // Analog-to-Digital Converter
	SYSCFG_COMP_OPAMP = (*SYSCFG_COMP_OPAMP_Type)(unsafe.Pointer(uintptr(0x40010000))) // System configuration controller _Comparator and Operational amplifier
	FMC               = (*FMC_Type)(unsafe.Pointer(uintptr(0xa0000400)))               // Flexible memory controller
	NVIC              = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))              // Nested Vectored Interrupt Controller
	FPU               = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))               // Floting point unit
	MPU               = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))               // Memory protection unit
	STK               = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))               // SysTick timer
	SCB               = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))               // System control block
	NVIC_STIR         = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))              // Nested vectored interrupt controller
	FPU_CPACR         = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))               // Floating point unit CPACR
	SCB_ACTRL         = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))               // System control block ACTLR
	GPIOC             = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000800)))              // General-purpose I/Os
	GPIOD             = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000c00)))              // General-purpose I/Os
	GPIOE             = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001000)))              // General-purpose I/Os
	GPIOF             = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001400)))              // General-purpose I/Os
	GPIOG             = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001800)))              // General-purpose I/Os
	GPIOH             = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001c00)))              // General-purpose I/Os
	DMA2              = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))               // DMA controller 1
	TIM3              = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40000400)))              // General purpose timer
	TIM4              = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40000800)))              // General purpose timer
	USART2            = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))             // Universal synchronous asynchronous receiver transmitter
	USART3            = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))             // Universal synchronous asynchronous receiver transmitter
	UART4             = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))             // Universal synchronous asynchronous receiver transmitter
	UART5             = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))             // Universal synchronous asynchronous receiver transmitter
	SPI2              = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))               // Serial peripheral interface/Inter-IC sound
	SPI3              = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))               // Serial peripheral interface/Inter-IC sound
	I2S2ext           = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003400)))               // Serial peripheral interface/Inter-IC sound
	I2S3ext           = (*SPI_Type)(unsafe.Pointer(uintptr(0x40004000)))               // Serial peripheral interface/Inter-IC sound
	SPI4              = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013c00)))               // Serial peripheral interface/Inter-IC sound
	I2C2              = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))               // Inter-integrated circuit
	I2C3              = (*I2C_Type)(unsafe.Pointer(uintptr(0x40007800)))               // Inter-integrated circuit
	TIM7              = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40001400)))              // Basic timers
	TIM20             = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40015000)))              // Advanced timer
	ADC2              = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000100)))               // Analog-to-Digital Converter
	ADC3              = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000400)))               // Analog-to-Digital Converter
	ADC4              = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000500)))               // Analog-to-Digital Converter
	ADC3_4            = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000700)))               // Analog-to-Digital Converter
)

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// Touch sensing controller
type TSC_Type struct {
	CR     volatile.Register32 // 0x0
	IER    volatile.Register32 // 0x4
	ICR    volatile.Register32 // 0x8
	ISR    volatile.Register32 // 0xC
	IOHCR  volatile.Register32 // 0x10
	_      [4]byte
	IOASCR volatile.Register32 // 0x18
	_      [4]byte
	IOSCR  volatile.Register32 // 0x20
	_      [4]byte
	IOCCR  volatile.Register32 // 0x28
	_      [4]byte
	IOGCSR volatile.Register32 // 0x30
	IOG1CR volatile.Register32 // 0x34
	IOG2CR volatile.Register32 // 0x38
	IOG3CR volatile.Register32 // 0x3C
	IOG4CR volatile.Register32 // 0x40
	IOG5CR volatile.Register32 // 0x44
	IOG6CR volatile.Register32 // 0x48
	IOG7CR volatile.Register32 // 0x4C
	IOG8CR volatile.Register32 // 0x50
}

// cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// Flash
type Flash_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	AR      volatile.Register32 // 0x14
	_       [4]byte
	OBR     volatile.Register32 // 0x1C
	WRPR    volatile.Register32 // 0x20
}

// Reset and clock control
type RCC_Type struct {
	CR       volatile.Register32 // 0x0
	CFGR     volatile.Register32 // 0x4
	CIR      volatile.Register32 // 0x8
	APB2RSTR volatile.Register32 // 0xC
	APB1RSTR volatile.Register32 // 0x10
	AHBENR   volatile.Register32 // 0x14
	APB2ENR  volatile.Register32 // 0x18
	APB1ENR  volatile.Register32 // 0x1C
	BDCR     volatile.Register32 // 0x20
	CSR      volatile.Register32 // 0x24
	AHBRSTR  volatile.Register32 // 0x28
	CFGR2    volatile.Register32 // 0x2C
	CFGR3    volatile.Register32 // 0x30
}

// DMA controller 1
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
}

// General purpose timer
type TIMs_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	_            [4]byte
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	_            [4]byte
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR1   volatile.Register32 // 0x0
	EMR1   volatile.Register32 // 0x4
	RTSR1  volatile.Register32 // 0x8
	FTSR1  volatile.Register32 // 0xC
	SWIER1 volatile.Register32 // 0x10
	PR1    volatile.Register32 // 0x14
	IMR2   volatile.Register32 // 0x18
	EMR2   volatile.Register32 // 0x1C
	RTSR2  volatile.Register32 // 0x20
	FTSR2  volatile.Register32 // 0x24
	SWIER2 volatile.Register32 // 0x28
	PR2    volatile.Register32 // 0x2C
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// Controller area network
type CAN_Type struct {
	MCR   volatile.Register32 // 0x0
	MSR   volatile.Register32 // 0x4
	TSR   volatile.Register32 // 0x8
	RF0R  volatile.Register32 // 0xC
	RF1R  volatile.Register32 // 0x10
	IER   volatile.Register32 // 0x14
	ESR   volatile.Register32 // 0x18
	BTR   volatile.Register32 // 0x1C
	_     [352]byte
	TI0R  volatile.Register32 // 0x180
	TDT0R volatile.Register32 // 0x184
	TDL0R volatile.Register32 // 0x188
	TDH0R volatile.Register32 // 0x18C
	TI1R  volatile.Register32 // 0x190
	TDT1R volatile.Register32 // 0x194
	TDL1R volatile.Register32 // 0x198
	TDH1R volatile.Register32 // 0x19C
	TI2R  volatile.Register32 // 0x1A0
	TDT2R volatile.Register32 // 0x1A4
	TDL2R volatile.Register32 // 0x1A8
	TDH2R volatile.Register32 // 0x1AC
	RI0R  volatile.Register32 // 0x1B0
	RDT0R volatile.Register32 // 0x1B4
	RDL0R volatile.Register32 // 0x1B8
	RDH0R volatile.Register32 // 0x1BC
	RI1R  volatile.Register32 // 0x1C0
	RDT1R volatile.Register32 // 0x1C4
	RDL1R volatile.Register32 // 0x1C8
	RDH1R volatile.Register32 // 0x1CC
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	F0R1  volatile.Register32 // 0x240
	F0R2  volatile.Register32 // 0x244
	F1R1  volatile.Register32 // 0x248
	F1R2  volatile.Register32 // 0x24C
	F2R1  volatile.Register32 // 0x250
	F2R2  volatile.Register32 // 0x254
	F3R1  volatile.Register32 // 0x258
	F3R2  volatile.Register32 // 0x25C
	F4R1  volatile.Register32 // 0x260
	F4R2  volatile.Register32 // 0x264
	F5R1  volatile.Register32 // 0x268
	F5R2  volatile.Register32 // 0x26C
	F6R1  volatile.Register32 // 0x270
	F6R2  volatile.Register32 // 0x274
	F7R1  volatile.Register32 // 0x278
	F7R2  volatile.Register32 // 0x27C
	F8R1  volatile.Register32 // 0x280
	F8R2  volatile.Register32 // 0x284
	F9R1  volatile.Register32 // 0x288
	F9R2  volatile.Register32 // 0x28C
	F10R1 volatile.Register32 // 0x290
	F10R2 volatile.Register32 // 0x294
	F11R1 volatile.Register32 // 0x298
	F11R2 volatile.Register32 // 0x29C
	F12R1 volatile.Register32 // 0x2A0
	F12R2 volatile.Register32 // 0x2A4
	F13R1 volatile.Register32 // 0x2A8
	F13R2 volatile.Register32 // 0x2AC
	F14R1 volatile.Register32 // 0x2B0
	F14R2 volatile.Register32 // 0x2B4
	F15R1 volatile.Register32 // 0x2B8
	F15R2 volatile.Register32 // 0x2BC
	F16R1 volatile.Register32 // 0x2C0
	F16R2 volatile.Register32 // 0x2C4
	F17R1 volatile.Register32 // 0x2C8
	F17R2 volatile.Register32 // 0x2CC
	F18R1 volatile.Register32 // 0x2D0
	F18R2 volatile.Register32 // 0x2D4
	F19R1 volatile.Register32 // 0x2D8
	F19R2 volatile.Register32 // 0x2DC
	F20R1 volatile.Register32 // 0x2E0
	F20R2 volatile.Register32 // 0x2E4
	F21R1 volatile.Register32 // 0x2E8
	F21R2 volatile.Register32 // 0x2EC
	F22R1 volatile.Register32 // 0x2F0
	F22R2 volatile.Register32 // 0x2F4
	F23R1 volatile.Register32 // 0x2F8
	F23R2 volatile.Register32 // 0x2FC
	F24R1 volatile.Register32 // 0x300
	F24R2 volatile.Register32 // 0x304
	F25R1 volatile.Register32 // 0x308
	F25R2 volatile.Register32 // 0x30C
	F26R1 volatile.Register32 // 0x310
	F26R2 volatile.Register32 // 0x314
	F27R1 volatile.Register32 // 0x318
	F27R2 volatile.Register32 // 0x31C
}

// Universal serial bus full-speed device interface
type USB_FS_Type struct {
	USB_EP0R volatile.Register32 // 0x0
	USB_EP1R volatile.Register32 // 0x4
	USB_EP2R volatile.Register32 // 0x8
	USB_EP3R volatile.Register32 // 0xC
	USB_EP4R volatile.Register32 // 0x10
	USB_EP5R volatile.Register32 // 0x14
	USB_EP6R volatile.Register32 // 0x18
	USB_EP7R volatile.Register32 // 0x1C
	_        [32]byte
	USB_CNTR volatile.Register32 // 0x40
	ISTR     volatile.Register32 // 0x44
	FNR      volatile.Register32 // 0x48
	DADDR    volatile.Register32 // 0x4C
	BTABLE   volatile.Register32 // 0x50
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAFCR    volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	_        [4]byte
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// Debug support
type DBGMCU_Type struct {
	IDCODE volatile.Register32 // 0x0
	CR     volatile.Register32 // 0x4
	APB1FZ volatile.Register32 // 0x8
	APB2FZ volatile.Register32 // 0xC
}

// Analog-to-Digital Converter
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR    volatile.Register32 // 0xC
	_       [4]byte
	SMPR1   volatile.Register32 // 0x14
	SMPR2   volatile.Register32 // 0x18
	_       [4]byte
	TR1     volatile.Register32 // 0x20
	TR2     volatile.Register32 // 0x24
	TR3     volatile.Register32 // 0x28
	_       [4]byte
	SQR1    volatile.Register32 // 0x30
	SQR2    volatile.Register32 // 0x34
	SQR3    volatile.Register32 // 0x38
	SQR4    volatile.Register32 // 0x3C
	DR      volatile.Register32 // 0x40
	_       [8]byte
	JSQR    volatile.Register32 // 0x4C
	_       [16]byte
	OFR1    volatile.Register32 // 0x60
	OFR2    volatile.Register32 // 0x64
	OFR3    volatile.Register32 // 0x68
	OFR4    volatile.Register32 // 0x6C
	_       [16]byte
	JDR1    volatile.Register32 // 0x80
	JDR2    volatile.Register32 // 0x84
	JDR3    volatile.Register32 // 0x88
	JDR4    volatile.Register32 // 0x8C
	_       [16]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [8]byte
	DIFSEL  volatile.Register32 // 0xB0
	CALFACT volatile.Register32 // 0xB4
}

// System configuration controller _Comparator and Operational amplifier
type SYSCFG_COMP_OPAMP_Type struct {
	SYSCFG_CFGR1   volatile.Register32 // 0x0
	SYSCFG_RCR     volatile.Register32 // 0x4
	SYSCFG_EXTICR1 volatile.Register32 // 0x8
	SYSCFG_EXTICR2 volatile.Register32 // 0xC
	SYSCFG_EXTICR3 volatile.Register32 // 0x10
	SYSCFG_EXTICR4 volatile.Register32 // 0x14
	SYSCFG_CFGR2   volatile.Register32 // 0x18
	COMP1_CSR      volatile.Register32 // 0x1C
	COMP2_CSR      volatile.Register32 // 0x20
	COMP3_CSR      volatile.Register32 // 0x24
	COMP4_CSR      volatile.Register32 // 0x28
	COMP5_CSR      volatile.Register32 // 0x2C
	COMP6_CSR      volatile.Register32 // 0x30
	COMP7_CSR      volatile.Register32 // 0x34
	OPAMP1_CSR     volatile.Register32 // 0x38
	OPAMP2_CSR     volatile.Register32 // 0x3C
	OPAMP3_CSR     volatile.Register32 // 0x40
	OPAMP4_CSR     volatile.Register32 // 0x44
}

// Flexible memory controller
type FMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [64]byte
	PCR2  volatile.Register32 // 0x60
	SR2   volatile.Register32 // 0x64
	PMEM2 volatile.Register32 // 0x68
	PATT2 volatile.Register32 // 0x6C
	_     [4]byte
	ECCR2 volatile.Register32 // 0x74
	_     [8]byte
	PCR3  volatile.Register32 // 0x80
	SR3   volatile.Register32 // 0x84
	PMEM3 volatile.Register32 // 0x88
	PATT3 volatile.Register32 // 0x8C
	_     [4]byte
	ECCR3 volatile.Register32 // 0x94
	_     [8]byte
	PCR4  volatile.Register32 // 0xA0
	SR4   volatile.Register32 // 0xA4
	PMEM4 volatile.Register32 // 0xA8
	PATT4 volatile.Register32 // 0xAC
	PIO4  volatile.Register32 // 0xB0
	_     [80]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// Memory protection unit
type MPU_Type struct {
	MPU_TYPER volatile.Register32 // 0x0
	MPU_CTRL  volatile.Register32 // 0x4
	MPU_RNR   volatile.Register32 // 0x8
	MPU_RBAR  volatile.Register32 // 0xC
	MPU_RASR  volatile.Register32 // 0x10
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCRS                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// Bitfields for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	GPIO_MODER_MODER15_Pos = 0x1e       // Position of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000 // Bit mask of MODER15 field.
	GPIO_MODER_MODER14_Pos = 0x1c       // Position of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000 // Bit mask of MODER14 field.
	GPIO_MODER_MODER13_Pos = 0x1a       // Position of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000  // Bit mask of MODER13 field.
	GPIO_MODER_MODER12_Pos = 0x18       // Position of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000  // Bit mask of MODER12 field.
	GPIO_MODER_MODER11_Pos = 0x16       // Position of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000   // Bit mask of MODER11 field.
	GPIO_MODER_MODER10_Pos = 0x14       // Position of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000   // Bit mask of MODER10 field.
	GPIO_MODER_MODER9_Pos  = 0x12       // Position of MODER9 field.
	GPIO_MODER_MODER9_Msk  = 0xc0000    // Bit mask of MODER9 field.
	GPIO_MODER_MODER8_Pos  = 0x10       // Position of MODER8 field.
	GPIO_MODER_MODER8_Msk  = 0x30000    // Bit mask of MODER8 field.
	GPIO_MODER_MODER7_Pos  = 0xe        // Position of MODER7 field.
	GPIO_MODER_MODER7_Msk  = 0xc000     // Bit mask of MODER7 field.
	GPIO_MODER_MODER6_Pos  = 0xc        // Position of MODER6 field.
	GPIO_MODER_MODER6_Msk  = 0x3000     // Bit mask of MODER6 field.
	GPIO_MODER_MODER5_Pos  = 0xa        // Position of MODER5 field.
	GPIO_MODER_MODER5_Msk  = 0xc00      // Bit mask of MODER5 field.
	GPIO_MODER_MODER4_Pos  = 0x8        // Position of MODER4 field.
	GPIO_MODER_MODER4_Msk  = 0x300      // Bit mask of MODER4 field.
	GPIO_MODER_MODER3_Pos  = 0x6        // Position of MODER3 field.
	GPIO_MODER_MODER3_Msk  = 0xc0       // Bit mask of MODER3 field.
	GPIO_MODER_MODER2_Pos  = 0x4        // Position of MODER2 field.
	GPIO_MODER_MODER2_Msk  = 0x30       // Bit mask of MODER2 field.
	GPIO_MODER_MODER1_Pos  = 0x2        // Position of MODER1 field.
	GPIO_MODER_MODER1_Msk  = 0xc        // Bit mask of MODER1 field.
	GPIO_MODER_MODER0_Pos  = 0x0        // Position of MODER0 field.
	GPIO_MODER_MODER0_Msk  = 0x3        // Bit mask of MODER0 field.

	// OTYPER: GPIO port output type register
	GPIO_OTYPER_OT15_Pos = 0xf    // Position of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000 // Bit mask of OT15 field.
	GPIO_OTYPER_OT15     = 0x8000 // Bit OT15.
	GPIO_OTYPER_OT14_Pos = 0xe    // Position of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000 // Bit mask of OT14 field.
	GPIO_OTYPER_OT14     = 0x4000 // Bit OT14.
	GPIO_OTYPER_OT13_Pos = 0xd    // Position of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000 // Bit mask of OT13 field.
	GPIO_OTYPER_OT13     = 0x2000 // Bit OT13.
	GPIO_OTYPER_OT12_Pos = 0xc    // Position of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000 // Bit mask of OT12 field.
	GPIO_OTYPER_OT12     = 0x1000 // Bit OT12.
	GPIO_OTYPER_OT11_Pos = 0xb    // Position of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800  // Bit mask of OT11 field.
	GPIO_OTYPER_OT11     = 0x800  // Bit OT11.
	GPIO_OTYPER_OT10_Pos = 0xa    // Position of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400  // Bit mask of OT10 field.
	GPIO_OTYPER_OT10     = 0x400  // Bit OT10.
	GPIO_OTYPER_OT9_Pos  = 0x9    // Position of OT9 field.
	GPIO_OTYPER_OT9_Msk  = 0x200  // Bit mask of OT9 field.
	GPIO_OTYPER_OT9      = 0x200  // Bit OT9.
	GPIO_OTYPER_OT8_Pos  = 0x8    // Position of OT8 field.
	GPIO_OTYPER_OT8_Msk  = 0x100  // Bit mask of OT8 field.
	GPIO_OTYPER_OT8      = 0x100  // Bit OT8.
	GPIO_OTYPER_OT7_Pos  = 0x7    // Position of OT7 field.
	GPIO_OTYPER_OT7_Msk  = 0x80   // Bit mask of OT7 field.
	GPIO_OTYPER_OT7      = 0x80   // Bit OT7.
	GPIO_OTYPER_OT6_Pos  = 0x6    // Position of OT6 field.
	GPIO_OTYPER_OT6_Msk  = 0x40   // Bit mask of OT6 field.
	GPIO_OTYPER_OT6      = 0x40   // Bit OT6.
	GPIO_OTYPER_OT5_Pos  = 0x5    // Position of OT5 field.
	GPIO_OTYPER_OT5_Msk  = 0x20   // Bit mask of OT5 field.
	GPIO_OTYPER_OT5      = 0x20   // Bit OT5.
	GPIO_OTYPER_OT4_Pos  = 0x4    // Position of OT4 field.
	GPIO_OTYPER_OT4_Msk  = 0x10   // Bit mask of OT4 field.
	GPIO_OTYPER_OT4      = 0x10   // Bit OT4.
	GPIO_OTYPER_OT3_Pos  = 0x3    // Position of OT3 field.
	GPIO_OTYPER_OT3_Msk  = 0x8    // Bit mask of OT3 field.
	GPIO_OTYPER_OT3      = 0x8    // Bit OT3.
	GPIO_OTYPER_OT2_Pos  = 0x2    // Position of OT2 field.
	GPIO_OTYPER_OT2_Msk  = 0x4    // Bit mask of OT2 field.
	GPIO_OTYPER_OT2      = 0x4    // Bit OT2.
	GPIO_OTYPER_OT1_Pos  = 0x1    // Position of OT1 field.
	GPIO_OTYPER_OT1_Msk  = 0x2    // Bit mask of OT1 field.
	GPIO_OTYPER_OT1      = 0x2    // Bit OT1.
	GPIO_OTYPER_OT0_Pos  = 0x0    // Position of OT0 field.
	GPIO_OTYPER_OT0_Msk  = 0x1    // Bit mask of OT0 field.
	GPIO_OTYPER_OT0      = 0x1    // Bit OT0.

	// OSPEEDR: GPIO port output speed           register
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e       // Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000 // Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c       // Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000 // Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a       // Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000  // Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18       // Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000  // Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16       // Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000   // Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14       // Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000   // Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos  = 0x12       // Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk  = 0xc0000    // Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos  = 0x10       // Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk  = 0x30000    // Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos  = 0xe        // Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk  = 0xc000     // Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos  = 0xc        // Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk  = 0x3000     // Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos  = 0xa        // Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk  = 0xc00      // Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos  = 0x8        // Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk  = 0x300      // Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos  = 0x6        // Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk  = 0xc0       // Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos  = 0x4        // Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk  = 0x30       // Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos  = 0x2        // Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk  = 0xc        // Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos  = 0x0        // Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk  = 0x3        // Bit mask of OSPEEDR0 field.

	// PUPDR: GPIO port pull-up/pull-down           register
	GPIO_PUPDR_PUPDR15_Pos = 0x1e       // Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000 // Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c       // Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000 // Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a       // Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000  // Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18       // Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000  // Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16       // Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000   // Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14       // Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000   // Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR9_Pos  = 0x12       // Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk  = 0xc0000    // Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR8_Pos  = 0x10       // Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk  = 0x30000    // Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR7_Pos  = 0xe        // Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk  = 0xc000     // Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR6_Pos  = 0xc        // Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk  = 0x3000     // Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR5_Pos  = 0xa        // Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk  = 0xc00      // Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR4_Pos  = 0x8        // Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk  = 0x300      // Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR3_Pos  = 0x6        // Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk  = 0xc0       // Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR2_Pos  = 0x4        // Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk  = 0x30       // Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR1_Pos  = 0x2        // Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk  = 0xc        // Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR0_Pos  = 0x0        // Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk  = 0x3        // Bit mask of PUPDR0 field.

	// IDR: GPIO port input data register
	GPIO_IDR_IDR15_Pos = 0xf    // Position of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000 // Bit mask of IDR15 field.
	GPIO_IDR_IDR15     = 0x8000 // Bit IDR15.
	GPIO_IDR_IDR14_Pos = 0xe    // Position of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000 // Bit mask of IDR14 field.
	GPIO_IDR_IDR14     = 0x4000 // Bit IDR14.
	GPIO_IDR_IDR13_Pos = 0xd    // Position of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000 // Bit mask of IDR13 field.
	GPIO_IDR_IDR13     = 0x2000 // Bit IDR13.
	GPIO_IDR_IDR12_Pos = 0xc    // Position of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000 // Bit mask of IDR12 field.
	GPIO_IDR_IDR12     = 0x1000 // Bit IDR12.
	GPIO_IDR_IDR11_Pos = 0xb    // Position of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800  // Bit mask of IDR11 field.
	GPIO_IDR_IDR11     = 0x800  // Bit IDR11.
	GPIO_IDR_IDR10_Pos = 0xa    // Position of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400  // Bit mask of IDR10 field.
	GPIO_IDR_IDR10     = 0x400  // Bit IDR10.
	GPIO_IDR_IDR9_Pos  = 0x9    // Position of IDR9 field.
	GPIO_IDR_IDR9_Msk  = 0x200  // Bit mask of IDR9 field.
	GPIO_IDR_IDR9      = 0x200  // Bit IDR9.
	GPIO_IDR_IDR8_Pos  = 0x8    // Position of IDR8 field.
	GPIO_IDR_IDR8_Msk  = 0x100  // Bit mask of IDR8 field.
	GPIO_IDR_IDR8      = 0x100  // Bit IDR8.
	GPIO_IDR_IDR7_Pos  = 0x7    // Position of IDR7 field.
	GPIO_IDR_IDR7_Msk  = 0x80   // Bit mask of IDR7 field.
	GPIO_IDR_IDR7      = 0x80   // Bit IDR7.
	GPIO_IDR_IDR6_Pos  = 0x6    // Position of IDR6 field.
	GPIO_IDR_IDR6_Msk  = 0x40   // Bit mask of IDR6 field.
	GPIO_IDR_IDR6      = 0x40   // Bit IDR6.
	GPIO_IDR_IDR5_Pos  = 0x5    // Position of IDR5 field.
	GPIO_IDR_IDR5_Msk  = 0x20   // Bit mask of IDR5 field.
	GPIO_IDR_IDR5      = 0x20   // Bit IDR5.
	GPIO_IDR_IDR4_Pos  = 0x4    // Position of IDR4 field.
	GPIO_IDR_IDR4_Msk  = 0x10   // Bit mask of IDR4 field.
	GPIO_IDR_IDR4      = 0x10   // Bit IDR4.
	GPIO_IDR_IDR3_Pos  = 0x3    // Position of IDR3 field.
	GPIO_IDR_IDR3_Msk  = 0x8    // Bit mask of IDR3 field.
	GPIO_IDR_IDR3      = 0x8    // Bit IDR3.
	GPIO_IDR_IDR2_Pos  = 0x2    // Position of IDR2 field.
	GPIO_IDR_IDR2_Msk  = 0x4    // Bit mask of IDR2 field.
	GPIO_IDR_IDR2      = 0x4    // Bit IDR2.
	GPIO_IDR_IDR1_Pos  = 0x1    // Position of IDR1 field.
	GPIO_IDR_IDR1_Msk  = 0x2    // Bit mask of IDR1 field.
	GPIO_IDR_IDR1      = 0x2    // Bit IDR1.
	GPIO_IDR_IDR0_Pos  = 0x0    // Position of IDR0 field.
	GPIO_IDR_IDR0_Msk  = 0x1    // Bit mask of IDR0 field.
	GPIO_IDR_IDR0      = 0x1    // Bit IDR0.

	// ODR: GPIO port output data register
	GPIO_ODR_ODR15_Pos = 0xf    // Position of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000 // Bit mask of ODR15 field.
	GPIO_ODR_ODR15     = 0x8000 // Bit ODR15.
	GPIO_ODR_ODR14_Pos = 0xe    // Position of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000 // Bit mask of ODR14 field.
	GPIO_ODR_ODR14     = 0x4000 // Bit ODR14.
	GPIO_ODR_ODR13_Pos = 0xd    // Position of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000 // Bit mask of ODR13 field.
	GPIO_ODR_ODR13     = 0x2000 // Bit ODR13.
	GPIO_ODR_ODR12_Pos = 0xc    // Position of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000 // Bit mask of ODR12 field.
	GPIO_ODR_ODR12     = 0x1000 // Bit ODR12.
	GPIO_ODR_ODR11_Pos = 0xb    // Position of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800  // Bit mask of ODR11 field.
	GPIO_ODR_ODR11     = 0x800  // Bit ODR11.
	GPIO_ODR_ODR10_Pos = 0xa    // Position of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400  // Bit mask of ODR10 field.
	GPIO_ODR_ODR10     = 0x400  // Bit ODR10.
	GPIO_ODR_ODR9_Pos  = 0x9    // Position of ODR9 field.
	GPIO_ODR_ODR9_Msk  = 0x200  // Bit mask of ODR9 field.
	GPIO_ODR_ODR9      = 0x200  // Bit ODR9.
	GPIO_ODR_ODR8_Pos  = 0x8    // Position of ODR8 field.
	GPIO_ODR_ODR8_Msk  = 0x100  // Bit mask of ODR8 field.
	GPIO_ODR_ODR8      = 0x100  // Bit ODR8.
	GPIO_ODR_ODR7_Pos  = 0x7    // Position of ODR7 field.
	GPIO_ODR_ODR7_Msk  = 0x80   // Bit mask of ODR7 field.
	GPIO_ODR_ODR7      = 0x80   // Bit ODR7.
	GPIO_ODR_ODR6_Pos  = 0x6    // Position of ODR6 field.
	GPIO_ODR_ODR6_Msk  = 0x40   // Bit mask of ODR6 field.
	GPIO_ODR_ODR6      = 0x40   // Bit ODR6.
	GPIO_ODR_ODR5_Pos  = 0x5    // Position of ODR5 field.
	GPIO_ODR_ODR5_Msk  = 0x20   // Bit mask of ODR5 field.
	GPIO_ODR_ODR5      = 0x20   // Bit ODR5.
	GPIO_ODR_ODR4_Pos  = 0x4    // Position of ODR4 field.
	GPIO_ODR_ODR4_Msk  = 0x10   // Bit mask of ODR4 field.
	GPIO_ODR_ODR4      = 0x10   // Bit ODR4.
	GPIO_ODR_ODR3_Pos  = 0x3    // Position of ODR3 field.
	GPIO_ODR_ODR3_Msk  = 0x8    // Bit mask of ODR3 field.
	GPIO_ODR_ODR3      = 0x8    // Bit ODR3.
	GPIO_ODR_ODR2_Pos  = 0x2    // Position of ODR2 field.
	GPIO_ODR_ODR2_Msk  = 0x4    // Bit mask of ODR2 field.
	GPIO_ODR_ODR2      = 0x4    // Bit ODR2.
	GPIO_ODR_ODR1_Pos  = 0x1    // Position of ODR1 field.
	GPIO_ODR_ODR1_Msk  = 0x2    // Bit mask of ODR1 field.
	GPIO_ODR_ODR1      = 0x2    // Bit ODR1.
	GPIO_ODR_ODR0_Pos  = 0x0    // Position of ODR0 field.
	GPIO_ODR_ODR0_Msk  = 0x1    // Bit mask of ODR0 field.
	GPIO_ODR_ODR0      = 0x1    // Bit ODR0.

	// BSRR: GPIO port bit set/reset           register
	GPIO_BSRR_BR15_Pos = 0x1f       // Position of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000 // Bit mask of BR15 field.
	GPIO_BSRR_BR15     = 0x80000000 // Bit BR15.
	GPIO_BSRR_BR14_Pos = 0x1e       // Position of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000 // Bit mask of BR14 field.
	GPIO_BSRR_BR14     = 0x40000000 // Bit BR14.
	GPIO_BSRR_BR13_Pos = 0x1d       // Position of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000 // Bit mask of BR13 field.
	GPIO_BSRR_BR13     = 0x20000000 // Bit BR13.
	GPIO_BSRR_BR12_Pos = 0x1c       // Position of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000 // Bit mask of BR12 field.
	GPIO_BSRR_BR12     = 0x10000000 // Bit BR12.
	GPIO_BSRR_BR11_Pos = 0x1b       // Position of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000  // Bit mask of BR11 field.
	GPIO_BSRR_BR11     = 0x8000000  // Bit BR11.
	GPIO_BSRR_BR10_Pos = 0x1a       // Position of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000  // Bit mask of BR10 field.
	GPIO_BSRR_BR10     = 0x4000000  // Bit BR10.
	GPIO_BSRR_BR9_Pos  = 0x19       // Position of BR9 field.
	GPIO_BSRR_BR9_Msk  = 0x2000000  // Bit mask of BR9 field.
	GPIO_BSRR_BR9      = 0x2000000  // Bit BR9.
	GPIO_BSRR_BR8_Pos  = 0x18       // Position of BR8 field.
	GPIO_BSRR_BR8_Msk  = 0x1000000  // Bit mask of BR8 field.
	GPIO_BSRR_BR8      = 0x1000000  // Bit BR8.
	GPIO_BSRR_BR7_Pos  = 0x17       // Position of BR7 field.
	GPIO_BSRR_BR7_Msk  = 0x800000   // Bit mask of BR7 field.
	GPIO_BSRR_BR7      = 0x800000   // Bit BR7.
	GPIO_BSRR_BR6_Pos  = 0x16       // Position of BR6 field.
	GPIO_BSRR_BR6_Msk  = 0x400000   // Bit mask of BR6 field.
	GPIO_BSRR_BR6      = 0x400000   // Bit BR6.
	GPIO_BSRR_BR5_Pos  = 0x15       // Position of BR5 field.
	GPIO_BSRR_BR5_Msk  = 0x200000   // Bit mask of BR5 field.
	GPIO_BSRR_BR5      = 0x200000   // Bit BR5.
	GPIO_BSRR_BR4_Pos  = 0x14       // Position of BR4 field.
	GPIO_BSRR_BR4_Msk  = 0x100000   // Bit mask of BR4 field.
	GPIO_BSRR_BR4      = 0x100000   // Bit BR4.
	GPIO_BSRR_BR3_Pos  = 0x13       // Position of BR3 field.
	GPIO_BSRR_BR3_Msk  = 0x80000    // Bit mask of BR3 field.
	GPIO_BSRR_BR3      = 0x80000    // Bit BR3.
	GPIO_BSRR_BR2_Pos  = 0x12       // Position of BR2 field.
	GPIO_BSRR_BR2_Msk  = 0x40000    // Bit mask of BR2 field.
	GPIO_BSRR_BR2      = 0x40000    // Bit BR2.
	GPIO_BSRR_BR1_Pos  = 0x11       // Position of BR1 field.
	GPIO_BSRR_BR1_Msk  = 0x20000    // Bit mask of BR1 field.
	GPIO_BSRR_BR1      = 0x20000    // Bit BR1.
	GPIO_BSRR_BR0_Pos  = 0x10       // Position of BR0 field.
	GPIO_BSRR_BR0_Msk  = 0x10000    // Bit mask of BR0 field.
	GPIO_BSRR_BR0      = 0x10000    // Bit BR0.
	GPIO_BSRR_BS15_Pos = 0xf        // Position of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000     // Bit mask of BS15 field.
	GPIO_BSRR_BS15     = 0x8000     // Bit BS15.
	GPIO_BSRR_BS14_Pos = 0xe        // Position of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000     // Bit mask of BS14 field.
	GPIO_BSRR_BS14     = 0x4000     // Bit BS14.
	GPIO_BSRR_BS13_Pos = 0xd        // Position of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000     // Bit mask of BS13 field.
	GPIO_BSRR_BS13     = 0x2000     // Bit BS13.
	GPIO_BSRR_BS12_Pos = 0xc        // Position of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000     // Bit mask of BS12 field.
	GPIO_BSRR_BS12     = 0x1000     // Bit BS12.
	GPIO_BSRR_BS11_Pos = 0xb        // Position of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800      // Bit mask of BS11 field.
	GPIO_BSRR_BS11     = 0x800      // Bit BS11.
	GPIO_BSRR_BS10_Pos = 0xa        // Position of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400      // Bit mask of BS10 field.
	GPIO_BSRR_BS10     = 0x400      // Bit BS10.
	GPIO_BSRR_BS9_Pos  = 0x9        // Position of BS9 field.
	GPIO_BSRR_BS9_Msk  = 0x200      // Bit mask of BS9 field.
	GPIO_BSRR_BS9      = 0x200      // Bit BS9.
	GPIO_BSRR_BS8_Pos  = 0x8        // Position of BS8 field.
	GPIO_BSRR_BS8_Msk  = 0x100      // Bit mask of BS8 field.
	GPIO_BSRR_BS8      = 0x100      // Bit BS8.
	GPIO_BSRR_BS7_Pos  = 0x7        // Position of BS7 field.
	GPIO_BSRR_BS7_Msk  = 0x80       // Bit mask of BS7 field.
	GPIO_BSRR_BS7      = 0x80       // Bit BS7.
	GPIO_BSRR_BS6_Pos  = 0x6        // Position of BS6 field.
	GPIO_BSRR_BS6_Msk  = 0x40       // Bit mask of BS6 field.
	GPIO_BSRR_BS6      = 0x40       // Bit BS6.
	GPIO_BSRR_BS5_Pos  = 0x5        // Position of BS5 field.
	GPIO_BSRR_BS5_Msk  = 0x20       // Bit mask of BS5 field.
	GPIO_BSRR_BS5      = 0x20       // Bit BS5.
	GPIO_BSRR_BS4_Pos  = 0x4        // Position of BS4 field.
	GPIO_BSRR_BS4_Msk  = 0x10       // Bit mask of BS4 field.
	GPIO_BSRR_BS4      = 0x10       // Bit BS4.
	GPIO_BSRR_BS3_Pos  = 0x3        // Position of BS3 field.
	GPIO_BSRR_BS3_Msk  = 0x8        // Bit mask of BS3 field.
	GPIO_BSRR_BS3      = 0x8        // Bit BS3.
	GPIO_BSRR_BS2_Pos  = 0x2        // Position of BS2 field.
	GPIO_BSRR_BS2_Msk  = 0x4        // Bit mask of BS2 field.
	GPIO_BSRR_BS2      = 0x4        // Bit BS2.
	GPIO_BSRR_BS1_Pos  = 0x1        // Position of BS1 field.
	GPIO_BSRR_BS1_Msk  = 0x2        // Bit mask of BS1 field.
	GPIO_BSRR_BS1      = 0x2        // Bit BS1.
	GPIO_BSRR_BS0_Pos  = 0x0        // Position of BS0 field.
	GPIO_BSRR_BS0_Msk  = 0x1        // Bit mask of BS0 field.
	GPIO_BSRR_BS0      = 0x1        // Bit BS0.

	// LCKR: GPIO port configuration lock           register
	GPIO_LCKR_LCKK_Pos  = 0x10    // Position of LCKK field.
	GPIO_LCKR_LCKK_Msk  = 0x10000 // Bit mask of LCKK field.
	GPIO_LCKR_LCKK      = 0x10000 // Bit LCKK.
	GPIO_LCKR_LCK15_Pos = 0xf     // Position of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000  // Bit mask of LCK15 field.
	GPIO_LCKR_LCK15     = 0x8000  // Bit LCK15.
	GPIO_LCKR_LCK14_Pos = 0xe     // Position of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000  // Bit mask of LCK14 field.
	GPIO_LCKR_LCK14     = 0x4000  // Bit LCK14.
	GPIO_LCKR_LCK13_Pos = 0xd     // Position of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000  // Bit mask of LCK13 field.
	GPIO_LCKR_LCK13     = 0x2000  // Bit LCK13.
	GPIO_LCKR_LCK12_Pos = 0xc     // Position of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000  // Bit mask of LCK12 field.
	GPIO_LCKR_LCK12     = 0x1000  // Bit LCK12.
	GPIO_LCKR_LCK11_Pos = 0xb     // Position of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800   // Bit mask of LCK11 field.
	GPIO_LCKR_LCK11     = 0x800   // Bit LCK11.
	GPIO_LCKR_LCK10_Pos = 0xa     // Position of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400   // Bit mask of LCK10 field.
	GPIO_LCKR_LCK10     = 0x400   // Bit LCK10.
	GPIO_LCKR_LCK9_Pos  = 0x9     // Position of LCK9 field.
	GPIO_LCKR_LCK9_Msk  = 0x200   // Bit mask of LCK9 field.
	GPIO_LCKR_LCK9      = 0x200   // Bit LCK9.
	GPIO_LCKR_LCK8_Pos  = 0x8     // Position of LCK8 field.
	GPIO_LCKR_LCK8_Msk  = 0x100   // Bit mask of LCK8 field.
	GPIO_LCKR_LCK8      = 0x100   // Bit LCK8.
	GPIO_LCKR_LCK7_Pos  = 0x7     // Position of LCK7 field.
	GPIO_LCKR_LCK7_Msk  = 0x80    // Bit mask of LCK7 field.
	GPIO_LCKR_LCK7      = 0x80    // Bit LCK7.
	GPIO_LCKR_LCK6_Pos  = 0x6     // Position of LCK6 field.
	GPIO_LCKR_LCK6_Msk  = 0x40    // Bit mask of LCK6 field.
	GPIO_LCKR_LCK6      = 0x40    // Bit LCK6.
	GPIO_LCKR_LCK5_Pos  = 0x5     // Position of LCK5 field.
	GPIO_LCKR_LCK5_Msk  = 0x20    // Bit mask of LCK5 field.
	GPIO_LCKR_LCK5      = 0x20    // Bit LCK5.
	GPIO_LCKR_LCK4_Pos  = 0x4     // Position of LCK4 field.
	GPIO_LCKR_LCK4_Msk  = 0x10    // Bit mask of LCK4 field.
	GPIO_LCKR_LCK4      = 0x10    // Bit LCK4.
	GPIO_LCKR_LCK3_Pos  = 0x3     // Position of LCK3 field.
	GPIO_LCKR_LCK3_Msk  = 0x8     // Bit mask of LCK3 field.
	GPIO_LCKR_LCK3      = 0x8     // Bit LCK3.
	GPIO_LCKR_LCK2_Pos  = 0x2     // Position of LCK2 field.
	GPIO_LCKR_LCK2_Msk  = 0x4     // Bit mask of LCK2 field.
	GPIO_LCKR_LCK2      = 0x4     // Bit LCK2.
	GPIO_LCKR_LCK1_Pos  = 0x1     // Position of LCK1 field.
	GPIO_LCKR_LCK1_Msk  = 0x2     // Bit mask of LCK1 field.
	GPIO_LCKR_LCK1      = 0x2     // Bit LCK1.
	GPIO_LCKR_LCK0_Pos  = 0x0     // Position of LCK0 field.
	GPIO_LCKR_LCK0_Msk  = 0x1     // Bit mask of LCK0 field.
	GPIO_LCKR_LCK0      = 0x1     // Bit LCK0.

	// AFRL: GPIO alternate function low           register
	GPIO_AFRL_AFRL7_Pos = 0x1c       // Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000 // Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL6_Pos = 0x18       // Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000  // Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL5_Pos = 0x14       // Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000   // Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL4_Pos = 0x10       // Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000    // Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL3_Pos = 0xc        // Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000     // Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL2_Pos = 0x8        // Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00      // Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL1_Pos = 0x4        // Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0       // Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL0_Pos = 0x0        // Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf        // Bit mask of AFRL0 field.

	// AFRH: GPIO alternate function high           register
	GPIO_AFRH_AFRH15_Pos = 0x1c       // Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000 // Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH14_Pos = 0x18       // Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000  // Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH13_Pos = 0x14       // Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000   // Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH12_Pos = 0x10       // Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000    // Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH11_Pos = 0xc        // Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000     // Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH10_Pos = 0x8        // Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00      // Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH9_Pos  = 0x4        // Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk  = 0xf0       // Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH8_Pos  = 0x0        // Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk  = 0xf        // Bit mask of AFRH8 field.

	// BRR: Port bit reset register
	GPIO_BRR_BR0_Pos  = 0x0    // Position of BR0 field.
	GPIO_BRR_BR0_Msk  = 0x1    // Bit mask of BR0 field.
	GPIO_BRR_BR0      = 0x1    // Bit BR0.
	GPIO_BRR_BR1_Pos  = 0x1    // Position of BR1 field.
	GPIO_BRR_BR1_Msk  = 0x2    // Bit mask of BR1 field.
	GPIO_BRR_BR1      = 0x2    // Bit BR1.
	GPIO_BRR_BR2_Pos  = 0x2    // Position of BR2 field.
	GPIO_BRR_BR2_Msk  = 0x4    // Bit mask of BR2 field.
	GPIO_BRR_BR2      = 0x4    // Bit BR2.
	GPIO_BRR_BR3_Pos  = 0x3    // Position of BR3 field.
	GPIO_BRR_BR3_Msk  = 0x8    // Bit mask of BR3 field.
	GPIO_BRR_BR3      = 0x8    // Bit BR3.
	GPIO_BRR_BR4_Pos  = 0x4    // Position of BR4 field.
	GPIO_BRR_BR4_Msk  = 0x10   // Bit mask of BR4 field.
	GPIO_BRR_BR4      = 0x10   // Bit BR4.
	GPIO_BRR_BR5_Pos  = 0x5    // Position of BR5 field.
	GPIO_BRR_BR5_Msk  = 0x20   // Bit mask of BR5 field.
	GPIO_BRR_BR5      = 0x20   // Bit BR5.
	GPIO_BRR_BR6_Pos  = 0x6    // Position of BR6 field.
	GPIO_BRR_BR6_Msk  = 0x40   // Bit mask of BR6 field.
	GPIO_BRR_BR6      = 0x40   // Bit BR6.
	GPIO_BRR_BR7_Pos  = 0x7    // Position of BR7 field.
	GPIO_BRR_BR7_Msk  = 0x80   // Bit mask of BR7 field.
	GPIO_BRR_BR7      = 0x80   // Bit BR7.
	GPIO_BRR_BR8_Pos  = 0x8    // Position of BR8 field.
	GPIO_BRR_BR8_Msk  = 0x100  // Bit mask of BR8 field.
	GPIO_BRR_BR8      = 0x100  // Bit BR8.
	GPIO_BRR_BR9_Pos  = 0x9    // Position of BR9 field.
	GPIO_BRR_BR9_Msk  = 0x200  // Bit mask of BR9 field.
	GPIO_BRR_BR9      = 0x200  // Bit BR9.
	GPIO_BRR_BR10_Pos = 0xa    // Position of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400  // Bit mask of BR10 field.
	GPIO_BRR_BR10     = 0x400  // Bit BR10.
	GPIO_BRR_BR11_Pos = 0xb    // Position of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800  // Bit mask of BR11 field.
	GPIO_BRR_BR11     = 0x800  // Bit BR11.
	GPIO_BRR_BR12_Pos = 0xc    // Position of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000 // Bit mask of BR12 field.
	GPIO_BRR_BR12     = 0x1000 // Bit BR12.
	GPIO_BRR_BR13_Pos = 0xd    // Position of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000 // Bit mask of BR13 field.
	GPIO_BRR_BR13     = 0x2000 // Bit BR13.
	GPIO_BRR_BR14_Pos = 0xe    // Position of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000 // Bit mask of BR14 field.
	GPIO_BRR_BR14     = 0x4000 // Bit BR14.
	GPIO_BRR_BR15_Pos = 0xf    // Position of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000 // Bit mask of BR15 field.
	GPIO_BRR_BR15     = 0x8000 // Bit BR15.
)

// Bitfields for TSC: Touch sensing controller
const (
	// CR: control register
	TSC_CR_CTPH_Pos    = 0x1c       // Position of CTPH field.
	TSC_CR_CTPH_Msk    = 0xf0000000 // Bit mask of CTPH field.
	TSC_CR_CTPL_Pos    = 0x18       // Position of CTPL field.
	TSC_CR_CTPL_Msk    = 0xf000000  // Bit mask of CTPL field.
	TSC_CR_SSD_Pos     = 0x11       // Position of SSD field.
	TSC_CR_SSD_Msk     = 0xfe0000   // Bit mask of SSD field.
	TSC_CR_SSE_Pos     = 0x10       // Position of SSE field.
	TSC_CR_SSE_Msk     = 0x10000    // Bit mask of SSE field.
	TSC_CR_SSE         = 0x10000    // Bit SSE.
	TSC_CR_SSPSC_Pos   = 0xf        // Position of SSPSC field.
	TSC_CR_SSPSC_Msk   = 0x8000     // Bit mask of SSPSC field.
	TSC_CR_SSPSC       = 0x8000     // Bit SSPSC.
	TSC_CR_PGPSC_Pos   = 0xc        // Position of PGPSC field.
	TSC_CR_PGPSC_Msk   = 0x7000     // Bit mask of PGPSC field.
	TSC_CR_MCV_Pos     = 0x5        // Position of MCV field.
	TSC_CR_MCV_Msk     = 0xe0       // Bit mask of MCV field.
	TSC_CR_IODEF_Pos   = 0x4        // Position of IODEF field.
	TSC_CR_IODEF_Msk   = 0x10       // Bit mask of IODEF field.
	TSC_CR_IODEF       = 0x10       // Bit IODEF.
	TSC_CR_SYNCPOL_Pos = 0x3        // Position of SYNCPOL field.
	TSC_CR_SYNCPOL_Msk = 0x8        // Bit mask of SYNCPOL field.
	TSC_CR_SYNCPOL     = 0x8        // Bit SYNCPOL.
	TSC_CR_AM_Pos      = 0x2        // Position of AM field.
	TSC_CR_AM_Msk      = 0x4        // Bit mask of AM field.
	TSC_CR_AM          = 0x4        // Bit AM.
	TSC_CR_START_Pos   = 0x1        // Position of START field.
	TSC_CR_START_Msk   = 0x2        // Bit mask of START field.
	TSC_CR_START       = 0x2        // Bit START.
	TSC_CR_TSCE_Pos    = 0x0        // Position of TSCE field.
	TSC_CR_TSCE_Msk    = 0x1        // Bit mask of TSCE field.
	TSC_CR_TSCE        = 0x1        // Bit TSCE.

	// IER: interrupt enable register
	TSC_IER_MCEIE_Pos = 0x1 // Position of MCEIE field.
	TSC_IER_MCEIE_Msk = 0x2 // Bit mask of MCEIE field.
	TSC_IER_MCEIE     = 0x2 // Bit MCEIE.
	TSC_IER_EOAIE_Pos = 0x0 // Position of EOAIE field.
	TSC_IER_EOAIE_Msk = 0x1 // Bit mask of EOAIE field.
	TSC_IER_EOAIE     = 0x1 // Bit EOAIE.

	// ICR: interrupt clear register
	TSC_ICR_MCEIC_Pos = 0x1 // Position of MCEIC field.
	TSC_ICR_MCEIC_Msk = 0x2 // Bit mask of MCEIC field.
	TSC_ICR_MCEIC     = 0x2 // Bit MCEIC.
	TSC_ICR_EOAIC_Pos = 0x0 // Position of EOAIC field.
	TSC_ICR_EOAIC_Msk = 0x1 // Bit mask of EOAIC field.
	TSC_ICR_EOAIC     = 0x1 // Bit EOAIC.

	// ISR: interrupt status register
	TSC_ISR_MCEF_Pos = 0x1 // Position of MCEF field.
	TSC_ISR_MCEF_Msk = 0x2 // Bit mask of MCEF field.
	TSC_ISR_MCEF     = 0x2 // Bit MCEF.
	TSC_ISR_EOAF_Pos = 0x0 // Position of EOAF field.
	TSC_ISR_EOAF_Msk = 0x1 // Bit mask of EOAF field.
	TSC_ISR_EOAF     = 0x1 // Bit EOAF.

	// IOHCR: I/O hysteresis control           register
	TSC_IOHCR_G1_IO1_Pos = 0x0        // Position of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Msk = 0x1        // Bit mask of G1_IO1 field.
	TSC_IOHCR_G1_IO1     = 0x1        // Bit G1_IO1.
	TSC_IOHCR_G1_IO2_Pos = 0x1        // Position of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Msk = 0x2        // Bit mask of G1_IO2 field.
	TSC_IOHCR_G1_IO2     = 0x2        // Bit G1_IO2.
	TSC_IOHCR_G1_IO3_Pos = 0x2        // Position of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Msk = 0x4        // Bit mask of G1_IO3 field.
	TSC_IOHCR_G1_IO3     = 0x4        // Bit G1_IO3.
	TSC_IOHCR_G1_IO4_Pos = 0x3        // Position of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Msk = 0x8        // Bit mask of G1_IO4 field.
	TSC_IOHCR_G1_IO4     = 0x8        // Bit G1_IO4.
	TSC_IOHCR_G2_IO1_Pos = 0x4        // Position of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Msk = 0x10       // Bit mask of G2_IO1 field.
	TSC_IOHCR_G2_IO1     = 0x10       // Bit G2_IO1.
	TSC_IOHCR_G2_IO2_Pos = 0x5        // Position of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Msk = 0x20       // Bit mask of G2_IO2 field.
	TSC_IOHCR_G2_IO2     = 0x20       // Bit G2_IO2.
	TSC_IOHCR_G2_IO3_Pos = 0x6        // Position of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Msk = 0x40       // Bit mask of G2_IO3 field.
	TSC_IOHCR_G2_IO3     = 0x40       // Bit G2_IO3.
	TSC_IOHCR_G2_IO4_Pos = 0x7        // Position of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Msk = 0x80       // Bit mask of G2_IO4 field.
	TSC_IOHCR_G2_IO4     = 0x80       // Bit G2_IO4.
	TSC_IOHCR_G3_IO1_Pos = 0x8        // Position of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Msk = 0x100      // Bit mask of G3_IO1 field.
	TSC_IOHCR_G3_IO1     = 0x100      // Bit G3_IO1.
	TSC_IOHCR_G3_IO2_Pos = 0x9        // Position of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Msk = 0x200      // Bit mask of G3_IO2 field.
	TSC_IOHCR_G3_IO2     = 0x200      // Bit G3_IO2.
	TSC_IOHCR_G3_IO3_Pos = 0xa        // Position of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Msk = 0x400      // Bit mask of G3_IO3 field.
	TSC_IOHCR_G3_IO3     = 0x400      // Bit G3_IO3.
	TSC_IOHCR_G3_IO4_Pos = 0xb        // Position of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Msk = 0x800      // Bit mask of G3_IO4 field.
	TSC_IOHCR_G3_IO4     = 0x800      // Bit G3_IO4.
	TSC_IOHCR_G4_IO1_Pos = 0xc        // Position of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Msk = 0x1000     // Bit mask of G4_IO1 field.
	TSC_IOHCR_G4_IO1     = 0x1000     // Bit G4_IO1.
	TSC_IOHCR_G4_IO2_Pos = 0xd        // Position of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Msk = 0x2000     // Bit mask of G4_IO2 field.
	TSC_IOHCR_G4_IO2     = 0x2000     // Bit G4_IO2.
	TSC_IOHCR_G4_IO3_Pos = 0xe        // Position of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Msk = 0x4000     // Bit mask of G4_IO3 field.
	TSC_IOHCR_G4_IO3     = 0x4000     // Bit G4_IO3.
	TSC_IOHCR_G4_IO4_Pos = 0xf        // Position of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Msk = 0x8000     // Bit mask of G4_IO4 field.
	TSC_IOHCR_G4_IO4     = 0x8000     // Bit G4_IO4.
	TSC_IOHCR_G5_IO1_Pos = 0x10       // Position of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Msk = 0x10000    // Bit mask of G5_IO1 field.
	TSC_IOHCR_G5_IO1     = 0x10000    // Bit G5_IO1.
	TSC_IOHCR_G5_IO2_Pos = 0x11       // Position of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Msk = 0x20000    // Bit mask of G5_IO2 field.
	TSC_IOHCR_G5_IO2     = 0x20000    // Bit G5_IO2.
	TSC_IOHCR_G5_IO3_Pos = 0x12       // Position of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Msk = 0x40000    // Bit mask of G5_IO3 field.
	TSC_IOHCR_G5_IO3     = 0x40000    // Bit G5_IO3.
	TSC_IOHCR_G5_IO4_Pos = 0x13       // Position of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Msk = 0x80000    // Bit mask of G5_IO4 field.
	TSC_IOHCR_G5_IO4     = 0x80000    // Bit G5_IO4.
	TSC_IOHCR_G6_IO1_Pos = 0x14       // Position of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Msk = 0x100000   // Bit mask of G6_IO1 field.
	TSC_IOHCR_G6_IO1     = 0x100000   // Bit G6_IO1.
	TSC_IOHCR_G6_IO2_Pos = 0x15       // Position of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Msk = 0x200000   // Bit mask of G6_IO2 field.
	TSC_IOHCR_G6_IO2     = 0x200000   // Bit G6_IO2.
	TSC_IOHCR_G6_IO3_Pos = 0x16       // Position of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Msk = 0x400000   // Bit mask of G6_IO3 field.
	TSC_IOHCR_G6_IO3     = 0x400000   // Bit G6_IO3.
	TSC_IOHCR_G6_IO4_Pos = 0x17       // Position of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Msk = 0x800000   // Bit mask of G6_IO4 field.
	TSC_IOHCR_G6_IO4     = 0x800000   // Bit G6_IO4.
	TSC_IOHCR_G7_IO1_Pos = 0x18       // Position of G7_IO1 field.
	TSC_IOHCR_G7_IO1_Msk = 0x1000000  // Bit mask of G7_IO1 field.
	TSC_IOHCR_G7_IO1     = 0x1000000  // Bit G7_IO1.
	TSC_IOHCR_G7_IO2_Pos = 0x19       // Position of G7_IO2 field.
	TSC_IOHCR_G7_IO2_Msk = 0x2000000  // Bit mask of G7_IO2 field.
	TSC_IOHCR_G7_IO2     = 0x2000000  // Bit G7_IO2.
	TSC_IOHCR_G7_IO3_Pos = 0x1a       // Position of G7_IO3 field.
	TSC_IOHCR_G7_IO3_Msk = 0x4000000  // Bit mask of G7_IO3 field.
	TSC_IOHCR_G7_IO3     = 0x4000000  // Bit G7_IO3.
	TSC_IOHCR_G7_IO4_Pos = 0x1b       // Position of G7_IO4 field.
	TSC_IOHCR_G7_IO4_Msk = 0x8000000  // Bit mask of G7_IO4 field.
	TSC_IOHCR_G7_IO4     = 0x8000000  // Bit G7_IO4.
	TSC_IOHCR_G8_IO1_Pos = 0x1c       // Position of G8_IO1 field.
	TSC_IOHCR_G8_IO1_Msk = 0x10000000 // Bit mask of G8_IO1 field.
	TSC_IOHCR_G8_IO1     = 0x10000000 // Bit G8_IO1.
	TSC_IOHCR_G8_IO2_Pos = 0x1d       // Position of G8_IO2 field.
	TSC_IOHCR_G8_IO2_Msk = 0x20000000 // Bit mask of G8_IO2 field.
	TSC_IOHCR_G8_IO2     = 0x20000000 // Bit G8_IO2.
	TSC_IOHCR_G8_IO3_Pos = 0x1e       // Position of G8_IO3 field.
	TSC_IOHCR_G8_IO3_Msk = 0x40000000 // Bit mask of G8_IO3 field.
	TSC_IOHCR_G8_IO3     = 0x40000000 // Bit G8_IO3.
	TSC_IOHCR_G8_IO4_Pos = 0x1f       // Position of G8_IO4 field.
	TSC_IOHCR_G8_IO4_Msk = 0x80000000 // Bit mask of G8_IO4 field.
	TSC_IOHCR_G8_IO4     = 0x80000000 // Bit G8_IO4.

	// IOASCR: I/O analog switch control           register
	TSC_IOASCR_G1_IO1_Pos = 0x0        // Position of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Msk = 0x1        // Bit mask of G1_IO1 field.
	TSC_IOASCR_G1_IO1     = 0x1        // Bit G1_IO1.
	TSC_IOASCR_G1_IO2_Pos = 0x1        // Position of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Msk = 0x2        // Bit mask of G1_IO2 field.
	TSC_IOASCR_G1_IO2     = 0x2        // Bit G1_IO2.
	TSC_IOASCR_G1_IO3_Pos = 0x2        // Position of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Msk = 0x4        // Bit mask of G1_IO3 field.
	TSC_IOASCR_G1_IO3     = 0x4        // Bit G1_IO3.
	TSC_IOASCR_G1_IO4_Pos = 0x3        // Position of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Msk = 0x8        // Bit mask of G1_IO4 field.
	TSC_IOASCR_G1_IO4     = 0x8        // Bit G1_IO4.
	TSC_IOASCR_G2_IO1_Pos = 0x4        // Position of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Msk = 0x10       // Bit mask of G2_IO1 field.
	TSC_IOASCR_G2_IO1     = 0x10       // Bit G2_IO1.
	TSC_IOASCR_G2_IO2_Pos = 0x5        // Position of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Msk = 0x20       // Bit mask of G2_IO2 field.
	TSC_IOASCR_G2_IO2     = 0x20       // Bit G2_IO2.
	TSC_IOASCR_G2_IO3_Pos = 0x6        // Position of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Msk = 0x40       // Bit mask of G2_IO3 field.
	TSC_IOASCR_G2_IO3     = 0x40       // Bit G2_IO3.
	TSC_IOASCR_G2_IO4_Pos = 0x7        // Position of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Msk = 0x80       // Bit mask of G2_IO4 field.
	TSC_IOASCR_G2_IO4     = 0x80       // Bit G2_IO4.
	TSC_IOASCR_G3_IO1_Pos = 0x8        // Position of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Msk = 0x100      // Bit mask of G3_IO1 field.
	TSC_IOASCR_G3_IO1     = 0x100      // Bit G3_IO1.
	TSC_IOASCR_G3_IO2_Pos = 0x9        // Position of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Msk = 0x200      // Bit mask of G3_IO2 field.
	TSC_IOASCR_G3_IO2     = 0x200      // Bit G3_IO2.
	TSC_IOASCR_G3_IO3_Pos = 0xa        // Position of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Msk = 0x400      // Bit mask of G3_IO3 field.
	TSC_IOASCR_G3_IO3     = 0x400      // Bit G3_IO3.
	TSC_IOASCR_G3_IO4_Pos = 0xb        // Position of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Msk = 0x800      // Bit mask of G3_IO4 field.
	TSC_IOASCR_G3_IO4     = 0x800      // Bit G3_IO4.
	TSC_IOASCR_G4_IO1_Pos = 0xc        // Position of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Msk = 0x1000     // Bit mask of G4_IO1 field.
	TSC_IOASCR_G4_IO1     = 0x1000     // Bit G4_IO1.
	TSC_IOASCR_G4_IO2_Pos = 0xd        // Position of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Msk = 0x2000     // Bit mask of G4_IO2 field.
	TSC_IOASCR_G4_IO2     = 0x2000     // Bit G4_IO2.
	TSC_IOASCR_G4_IO3_Pos = 0xe        // Position of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Msk = 0x4000     // Bit mask of G4_IO3 field.
	TSC_IOASCR_G4_IO3     = 0x4000     // Bit G4_IO3.
	TSC_IOASCR_G4_IO4_Pos = 0xf        // Position of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Msk = 0x8000     // Bit mask of G4_IO4 field.
	TSC_IOASCR_G4_IO4     = 0x8000     // Bit G4_IO4.
	TSC_IOASCR_G5_IO1_Pos = 0x10       // Position of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Msk = 0x10000    // Bit mask of G5_IO1 field.
	TSC_IOASCR_G5_IO1     = 0x10000    // Bit G5_IO1.
	TSC_IOASCR_G5_IO2_Pos = 0x11       // Position of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Msk = 0x20000    // Bit mask of G5_IO2 field.
	TSC_IOASCR_G5_IO2     = 0x20000    // Bit G5_IO2.
	TSC_IOASCR_G5_IO3_Pos = 0x12       // Position of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Msk = 0x40000    // Bit mask of G5_IO3 field.
	TSC_IOASCR_G5_IO3     = 0x40000    // Bit G5_IO3.
	TSC_IOASCR_G5_IO4_Pos = 0x13       // Position of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Msk = 0x80000    // Bit mask of G5_IO4 field.
	TSC_IOASCR_G5_IO4     = 0x80000    // Bit G5_IO4.
	TSC_IOASCR_G6_IO1_Pos = 0x14       // Position of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Msk = 0x100000   // Bit mask of G6_IO1 field.
	TSC_IOASCR_G6_IO1     = 0x100000   // Bit G6_IO1.
	TSC_IOASCR_G6_IO2_Pos = 0x15       // Position of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Msk = 0x200000   // Bit mask of G6_IO2 field.
	TSC_IOASCR_G6_IO2     = 0x200000   // Bit G6_IO2.
	TSC_IOASCR_G6_IO3_Pos = 0x16       // Position of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Msk = 0x400000   // Bit mask of G6_IO3 field.
	TSC_IOASCR_G6_IO3     = 0x400000   // Bit G6_IO3.
	TSC_IOASCR_G6_IO4_Pos = 0x17       // Position of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Msk = 0x800000   // Bit mask of G6_IO4 field.
	TSC_IOASCR_G6_IO4     = 0x800000   // Bit G6_IO4.
	TSC_IOASCR_G7_IO1_Pos = 0x18       // Position of G7_IO1 field.
	TSC_IOASCR_G7_IO1_Msk = 0x1000000  // Bit mask of G7_IO1 field.
	TSC_IOASCR_G7_IO1     = 0x1000000  // Bit G7_IO1.
	TSC_IOASCR_G7_IO2_Pos = 0x19       // Position of G7_IO2 field.
	TSC_IOASCR_G7_IO2_Msk = 0x2000000  // Bit mask of G7_IO2 field.
	TSC_IOASCR_G7_IO2     = 0x2000000  // Bit G7_IO2.
	TSC_IOASCR_G7_IO3_Pos = 0x1a       // Position of G7_IO3 field.
	TSC_IOASCR_G7_IO3_Msk = 0x4000000  // Bit mask of G7_IO3 field.
	TSC_IOASCR_G7_IO3     = 0x4000000  // Bit G7_IO3.
	TSC_IOASCR_G7_IO4_Pos = 0x1b       // Position of G7_IO4 field.
	TSC_IOASCR_G7_IO4_Msk = 0x8000000  // Bit mask of G7_IO4 field.
	TSC_IOASCR_G7_IO4     = 0x8000000  // Bit G7_IO4.
	TSC_IOASCR_G8_IO1_Pos = 0x1c       // Position of G8_IO1 field.
	TSC_IOASCR_G8_IO1_Msk = 0x10000000 // Bit mask of G8_IO1 field.
	TSC_IOASCR_G8_IO1     = 0x10000000 // Bit G8_IO1.
	TSC_IOASCR_G8_IO2_Pos = 0x1d       // Position of G8_IO2 field.
	TSC_IOASCR_G8_IO2_Msk = 0x20000000 // Bit mask of G8_IO2 field.
	TSC_IOASCR_G8_IO2     = 0x20000000 // Bit G8_IO2.
	TSC_IOASCR_G8_IO3_Pos = 0x1e       // Position of G8_IO3 field.
	TSC_IOASCR_G8_IO3_Msk = 0x40000000 // Bit mask of G8_IO3 field.
	TSC_IOASCR_G8_IO3     = 0x40000000 // Bit G8_IO3.
	TSC_IOASCR_G8_IO4_Pos = 0x1f       // Position of G8_IO4 field.
	TSC_IOASCR_G8_IO4_Msk = 0x80000000 // Bit mask of G8_IO4 field.
	TSC_IOASCR_G8_IO4     = 0x80000000 // Bit G8_IO4.

	// IOSCR: I/O sampling control register
	TSC_IOSCR_G1_IO1_Pos = 0x0        // Position of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Msk = 0x1        // Bit mask of G1_IO1 field.
	TSC_IOSCR_G1_IO1     = 0x1        // Bit G1_IO1.
	TSC_IOSCR_G1_IO2_Pos = 0x1        // Position of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Msk = 0x2        // Bit mask of G1_IO2 field.
	TSC_IOSCR_G1_IO2     = 0x2        // Bit G1_IO2.
	TSC_IOSCR_G1_IO3_Pos = 0x2        // Position of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Msk = 0x4        // Bit mask of G1_IO3 field.
	TSC_IOSCR_G1_IO3     = 0x4        // Bit G1_IO3.
	TSC_IOSCR_G1_IO4_Pos = 0x3        // Position of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Msk = 0x8        // Bit mask of G1_IO4 field.
	TSC_IOSCR_G1_IO4     = 0x8        // Bit G1_IO4.
	TSC_IOSCR_G2_IO1_Pos = 0x4        // Position of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Msk = 0x10       // Bit mask of G2_IO1 field.
	TSC_IOSCR_G2_IO1     = 0x10       // Bit G2_IO1.
	TSC_IOSCR_G2_IO2_Pos = 0x5        // Position of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Msk = 0x20       // Bit mask of G2_IO2 field.
	TSC_IOSCR_G2_IO2     = 0x20       // Bit G2_IO2.
	TSC_IOSCR_G2_IO3_Pos = 0x6        // Position of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Msk = 0x40       // Bit mask of G2_IO3 field.
	TSC_IOSCR_G2_IO3     = 0x40       // Bit G2_IO3.
	TSC_IOSCR_G2_IO4_Pos = 0x7        // Position of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Msk = 0x80       // Bit mask of G2_IO4 field.
	TSC_IOSCR_G2_IO4     = 0x80       // Bit G2_IO4.
	TSC_IOSCR_G3_IO1_Pos = 0x8        // Position of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Msk = 0x100      // Bit mask of G3_IO1 field.
	TSC_IOSCR_G3_IO1     = 0x100      // Bit G3_IO1.
	TSC_IOSCR_G3_IO2_Pos = 0x9        // Position of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Msk = 0x200      // Bit mask of G3_IO2 field.
	TSC_IOSCR_G3_IO2     = 0x200      // Bit G3_IO2.
	TSC_IOSCR_G3_IO3_Pos = 0xa        // Position of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Msk = 0x400      // Bit mask of G3_IO3 field.
	TSC_IOSCR_G3_IO3     = 0x400      // Bit G3_IO3.
	TSC_IOSCR_G3_IO4_Pos = 0xb        // Position of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Msk = 0x800      // Bit mask of G3_IO4 field.
	TSC_IOSCR_G3_IO4     = 0x800      // Bit G3_IO4.
	TSC_IOSCR_G4_IO1_Pos = 0xc        // Position of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Msk = 0x1000     // Bit mask of G4_IO1 field.
	TSC_IOSCR_G4_IO1     = 0x1000     // Bit G4_IO1.
	TSC_IOSCR_G4_IO2_Pos = 0xd        // Position of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Msk = 0x2000     // Bit mask of G4_IO2 field.
	TSC_IOSCR_G4_IO2     = 0x2000     // Bit G4_IO2.
	TSC_IOSCR_G4_IO3_Pos = 0xe        // Position of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Msk = 0x4000     // Bit mask of G4_IO3 field.
	TSC_IOSCR_G4_IO3     = 0x4000     // Bit G4_IO3.
	TSC_IOSCR_G4_IO4_Pos = 0xf        // Position of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Msk = 0x8000     // Bit mask of G4_IO4 field.
	TSC_IOSCR_G4_IO4     = 0x8000     // Bit G4_IO4.
	TSC_IOSCR_G5_IO1_Pos = 0x10       // Position of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Msk = 0x10000    // Bit mask of G5_IO1 field.
	TSC_IOSCR_G5_IO1     = 0x10000    // Bit G5_IO1.
	TSC_IOSCR_G5_IO2_Pos = 0x11       // Position of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Msk = 0x20000    // Bit mask of G5_IO2 field.
	TSC_IOSCR_G5_IO2     = 0x20000    // Bit G5_IO2.
	TSC_IOSCR_G5_IO3_Pos = 0x12       // Position of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Msk = 0x40000    // Bit mask of G5_IO3 field.
	TSC_IOSCR_G5_IO3     = 0x40000    // Bit G5_IO3.
	TSC_IOSCR_G5_IO4_Pos = 0x13       // Position of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Msk = 0x80000    // Bit mask of G5_IO4 field.
	TSC_IOSCR_G5_IO4     = 0x80000    // Bit G5_IO4.
	TSC_IOSCR_G6_IO1_Pos = 0x14       // Position of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Msk = 0x100000   // Bit mask of G6_IO1 field.
	TSC_IOSCR_G6_IO1     = 0x100000   // Bit G6_IO1.
	TSC_IOSCR_G6_IO2_Pos = 0x15       // Position of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Msk = 0x200000   // Bit mask of G6_IO2 field.
	TSC_IOSCR_G6_IO2     = 0x200000   // Bit G6_IO2.
	TSC_IOSCR_G6_IO3_Pos = 0x16       // Position of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Msk = 0x400000   // Bit mask of G6_IO3 field.
	TSC_IOSCR_G6_IO3     = 0x400000   // Bit G6_IO3.
	TSC_IOSCR_G6_IO4_Pos = 0x17       // Position of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Msk = 0x800000   // Bit mask of G6_IO4 field.
	TSC_IOSCR_G6_IO4     = 0x800000   // Bit G6_IO4.
	TSC_IOSCR_G7_IO1_Pos = 0x18       // Position of G7_IO1 field.
	TSC_IOSCR_G7_IO1_Msk = 0x1000000  // Bit mask of G7_IO1 field.
	TSC_IOSCR_G7_IO1     = 0x1000000  // Bit G7_IO1.
	TSC_IOSCR_G7_IO2_Pos = 0x19       // Position of G7_IO2 field.
	TSC_IOSCR_G7_IO2_Msk = 0x2000000  // Bit mask of G7_IO2 field.
	TSC_IOSCR_G7_IO2     = 0x2000000  // Bit G7_IO2.
	TSC_IOSCR_G7_IO3_Pos = 0x1a       // Position of G7_IO3 field.
	TSC_IOSCR_G7_IO3_Msk = 0x4000000  // Bit mask of G7_IO3 field.
	TSC_IOSCR_G7_IO3     = 0x4000000  // Bit G7_IO3.
	TSC_IOSCR_G7_IO4_Pos = 0x1b       // Position of G7_IO4 field.
	TSC_IOSCR_G7_IO4_Msk = 0x8000000  // Bit mask of G7_IO4 field.
	TSC_IOSCR_G7_IO4     = 0x8000000  // Bit G7_IO4.
	TSC_IOSCR_G8_IO1_Pos = 0x1c       // Position of G8_IO1 field.
	TSC_IOSCR_G8_IO1_Msk = 0x10000000 // Bit mask of G8_IO1 field.
	TSC_IOSCR_G8_IO1     = 0x10000000 // Bit G8_IO1.
	TSC_IOSCR_G8_IO2_Pos = 0x1d       // Position of G8_IO2 field.
	TSC_IOSCR_G8_IO2_Msk = 0x20000000 // Bit mask of G8_IO2 field.
	TSC_IOSCR_G8_IO2     = 0x20000000 // Bit G8_IO2.
	TSC_IOSCR_G8_IO3_Pos = 0x1e       // Position of G8_IO3 field.
	TSC_IOSCR_G8_IO3_Msk = 0x40000000 // Bit mask of G8_IO3 field.
	TSC_IOSCR_G8_IO3     = 0x40000000 // Bit G8_IO3.
	TSC_IOSCR_G8_IO4_Pos = 0x1f       // Position of G8_IO4 field.
	TSC_IOSCR_G8_IO4_Msk = 0x80000000 // Bit mask of G8_IO4 field.
	TSC_IOSCR_G8_IO4     = 0x80000000 // Bit G8_IO4.

	// IOCCR: I/O channel control register
	TSC_IOCCR_G1_IO1_Pos = 0x0        // Position of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Msk = 0x1        // Bit mask of G1_IO1 field.
	TSC_IOCCR_G1_IO1     = 0x1        // Bit G1_IO1.
	TSC_IOCCR_G1_IO2_Pos = 0x1        // Position of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Msk = 0x2        // Bit mask of G1_IO2 field.
	TSC_IOCCR_G1_IO2     = 0x2        // Bit G1_IO2.
	TSC_IOCCR_G1_IO3_Pos = 0x2        // Position of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Msk = 0x4        // Bit mask of G1_IO3 field.
	TSC_IOCCR_G1_IO3     = 0x4        // Bit G1_IO3.
	TSC_IOCCR_G1_IO4_Pos = 0x3        // Position of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Msk = 0x8        // Bit mask of G1_IO4 field.
	TSC_IOCCR_G1_IO4     = 0x8        // Bit G1_IO4.
	TSC_IOCCR_G2_IO1_Pos = 0x4        // Position of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Msk = 0x10       // Bit mask of G2_IO1 field.
	TSC_IOCCR_G2_IO1     = 0x10       // Bit G2_IO1.
	TSC_IOCCR_G2_IO2_Pos = 0x5        // Position of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Msk = 0x20       // Bit mask of G2_IO2 field.
	TSC_IOCCR_G2_IO2     = 0x20       // Bit G2_IO2.
	TSC_IOCCR_G2_IO3_Pos = 0x6        // Position of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Msk = 0x40       // Bit mask of G2_IO3 field.
	TSC_IOCCR_G2_IO3     = 0x40       // Bit G2_IO3.
	TSC_IOCCR_G2_IO4_Pos = 0x7        // Position of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Msk = 0x80       // Bit mask of G2_IO4 field.
	TSC_IOCCR_G2_IO4     = 0x80       // Bit G2_IO4.
	TSC_IOCCR_G3_IO1_Pos = 0x8        // Position of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Msk = 0x100      // Bit mask of G3_IO1 field.
	TSC_IOCCR_G3_IO1     = 0x100      // Bit G3_IO1.
	TSC_IOCCR_G3_IO2_Pos = 0x9        // Position of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Msk = 0x200      // Bit mask of G3_IO2 field.
	TSC_IOCCR_G3_IO2     = 0x200      // Bit G3_IO2.
	TSC_IOCCR_G3_IO3_Pos = 0xa        // Position of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Msk = 0x400      // Bit mask of G3_IO3 field.
	TSC_IOCCR_G3_IO3     = 0x400      // Bit G3_IO3.
	TSC_IOCCR_G3_IO4_Pos = 0xb        // Position of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Msk = 0x800      // Bit mask of G3_IO4 field.
	TSC_IOCCR_G3_IO4     = 0x800      // Bit G3_IO4.
	TSC_IOCCR_G4_IO1_Pos = 0xc        // Position of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Msk = 0x1000     // Bit mask of G4_IO1 field.
	TSC_IOCCR_G4_IO1     = 0x1000     // Bit G4_IO1.
	TSC_IOCCR_G4_IO2_Pos = 0xd        // Position of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Msk = 0x2000     // Bit mask of G4_IO2 field.
	TSC_IOCCR_G4_IO2     = 0x2000     // Bit G4_IO2.
	TSC_IOCCR_G4_IO3_Pos = 0xe        // Position of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Msk = 0x4000     // Bit mask of G4_IO3 field.
	TSC_IOCCR_G4_IO3     = 0x4000     // Bit G4_IO3.
	TSC_IOCCR_G4_IO4_Pos = 0xf        // Position of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Msk = 0x8000     // Bit mask of G4_IO4 field.
	TSC_IOCCR_G4_IO4     = 0x8000     // Bit G4_IO4.
	TSC_IOCCR_G5_IO1_Pos = 0x10       // Position of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Msk = 0x10000    // Bit mask of G5_IO1 field.
	TSC_IOCCR_G5_IO1     = 0x10000    // Bit G5_IO1.
	TSC_IOCCR_G5_IO2_Pos = 0x11       // Position of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Msk = 0x20000    // Bit mask of G5_IO2 field.
	TSC_IOCCR_G5_IO2     = 0x20000    // Bit G5_IO2.
	TSC_IOCCR_G5_IO3_Pos = 0x12       // Position of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Msk = 0x40000    // Bit mask of G5_IO3 field.
	TSC_IOCCR_G5_IO3     = 0x40000    // Bit G5_IO3.
	TSC_IOCCR_G5_IO4_Pos = 0x13       // Position of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Msk = 0x80000    // Bit mask of G5_IO4 field.
	TSC_IOCCR_G5_IO4     = 0x80000    // Bit G5_IO4.
	TSC_IOCCR_G6_IO1_Pos = 0x14       // Position of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Msk = 0x100000   // Bit mask of G6_IO1 field.
	TSC_IOCCR_G6_IO1     = 0x100000   // Bit G6_IO1.
	TSC_IOCCR_G6_IO2_Pos = 0x15       // Position of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Msk = 0x200000   // Bit mask of G6_IO2 field.
	TSC_IOCCR_G6_IO2     = 0x200000   // Bit G6_IO2.
	TSC_IOCCR_G6_IO3_Pos = 0x16       // Position of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Msk = 0x400000   // Bit mask of G6_IO3 field.
	TSC_IOCCR_G6_IO3     = 0x400000   // Bit G6_IO3.
	TSC_IOCCR_G6_IO4_Pos = 0x17       // Position of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Msk = 0x800000   // Bit mask of G6_IO4 field.
	TSC_IOCCR_G6_IO4     = 0x800000   // Bit G6_IO4.
	TSC_IOCCR_G7_IO1_Pos = 0x18       // Position of G7_IO1 field.
	TSC_IOCCR_G7_IO1_Msk = 0x1000000  // Bit mask of G7_IO1 field.
	TSC_IOCCR_G7_IO1     = 0x1000000  // Bit G7_IO1.
	TSC_IOCCR_G7_IO2_Pos = 0x19       // Position of G7_IO2 field.
	TSC_IOCCR_G7_IO2_Msk = 0x2000000  // Bit mask of G7_IO2 field.
	TSC_IOCCR_G7_IO2     = 0x2000000  // Bit G7_IO2.
	TSC_IOCCR_G7_IO3_Pos = 0x1a       // Position of G7_IO3 field.
	TSC_IOCCR_G7_IO3_Msk = 0x4000000  // Bit mask of G7_IO3 field.
	TSC_IOCCR_G7_IO3     = 0x4000000  // Bit G7_IO3.
	TSC_IOCCR_G7_IO4_Pos = 0x1b       // Position of G7_IO4 field.
	TSC_IOCCR_G7_IO4_Msk = 0x8000000  // Bit mask of G7_IO4 field.
	TSC_IOCCR_G7_IO4     = 0x8000000  // Bit G7_IO4.
	TSC_IOCCR_G8_IO1_Pos = 0x1c       // Position of G8_IO1 field.
	TSC_IOCCR_G8_IO1_Msk = 0x10000000 // Bit mask of G8_IO1 field.
	TSC_IOCCR_G8_IO1     = 0x10000000 // Bit G8_IO1.
	TSC_IOCCR_G8_IO2_Pos = 0x1d       // Position of G8_IO2 field.
	TSC_IOCCR_G8_IO2_Msk = 0x20000000 // Bit mask of G8_IO2 field.
	TSC_IOCCR_G8_IO2     = 0x20000000 // Bit G8_IO2.
	TSC_IOCCR_G8_IO3_Pos = 0x1e       // Position of G8_IO3 field.
	TSC_IOCCR_G8_IO3_Msk = 0x40000000 // Bit mask of G8_IO3 field.
	TSC_IOCCR_G8_IO3     = 0x40000000 // Bit G8_IO3.
	TSC_IOCCR_G8_IO4_Pos = 0x1f       // Position of G8_IO4 field.
	TSC_IOCCR_G8_IO4_Msk = 0x80000000 // Bit mask of G8_IO4 field.
	TSC_IOCCR_G8_IO4     = 0x80000000 // Bit G8_IO4.

	// IOGCSR: I/O group control status           register
	TSC_IOGCSR_G8S_Pos = 0x17     // Position of G8S field.
	TSC_IOGCSR_G8S_Msk = 0x800000 // Bit mask of G8S field.
	TSC_IOGCSR_G8S     = 0x800000 // Bit G8S.
	TSC_IOGCSR_G7S_Pos = 0x16     // Position of G7S field.
	TSC_IOGCSR_G7S_Msk = 0x400000 // Bit mask of G7S field.
	TSC_IOGCSR_G7S     = 0x400000 // Bit G7S.
	TSC_IOGCSR_G6S_Pos = 0x15     // Position of G6S field.
	TSC_IOGCSR_G6S_Msk = 0x200000 // Bit mask of G6S field.
	TSC_IOGCSR_G6S     = 0x200000 // Bit G6S.
	TSC_IOGCSR_G5S_Pos = 0x14     // Position of G5S field.
	TSC_IOGCSR_G5S_Msk = 0x100000 // Bit mask of G5S field.
	TSC_IOGCSR_G5S     = 0x100000 // Bit G5S.
	TSC_IOGCSR_G4S_Pos = 0x13     // Position of G4S field.
	TSC_IOGCSR_G4S_Msk = 0x80000  // Bit mask of G4S field.
	TSC_IOGCSR_G4S     = 0x80000  // Bit G4S.
	TSC_IOGCSR_G3S_Pos = 0x12     // Position of G3S field.
	TSC_IOGCSR_G3S_Msk = 0x40000  // Bit mask of G3S field.
	TSC_IOGCSR_G3S     = 0x40000  // Bit G3S.
	TSC_IOGCSR_G2S_Pos = 0x11     // Position of G2S field.
	TSC_IOGCSR_G2S_Msk = 0x20000  // Bit mask of G2S field.
	TSC_IOGCSR_G2S     = 0x20000  // Bit G2S.
	TSC_IOGCSR_G1S_Pos = 0x10     // Position of G1S field.
	TSC_IOGCSR_G1S_Msk = 0x10000  // Bit mask of G1S field.
	TSC_IOGCSR_G1S     = 0x10000  // Bit G1S.
	TSC_IOGCSR_G8E_Pos = 0x7      // Position of G8E field.
	TSC_IOGCSR_G8E_Msk = 0x80     // Bit mask of G8E field.
	TSC_IOGCSR_G8E     = 0x80     // Bit G8E.
	TSC_IOGCSR_G7E_Pos = 0x6      // Position of G7E field.
	TSC_IOGCSR_G7E_Msk = 0x40     // Bit mask of G7E field.
	TSC_IOGCSR_G7E     = 0x40     // Bit G7E.
	TSC_IOGCSR_G6E_Pos = 0x5      // Position of G6E field.
	TSC_IOGCSR_G6E_Msk = 0x20     // Bit mask of G6E field.
	TSC_IOGCSR_G6E     = 0x20     // Bit G6E.
	TSC_IOGCSR_G5E_Pos = 0x4      // Position of G5E field.
	TSC_IOGCSR_G5E_Msk = 0x10     // Bit mask of G5E field.
	TSC_IOGCSR_G5E     = 0x10     // Bit G5E.
	TSC_IOGCSR_G4E_Pos = 0x3      // Position of G4E field.
	TSC_IOGCSR_G4E_Msk = 0x8      // Bit mask of G4E field.
	TSC_IOGCSR_G4E     = 0x8      // Bit G4E.
	TSC_IOGCSR_G3E_Pos = 0x2      // Position of G3E field.
	TSC_IOGCSR_G3E_Msk = 0x4      // Bit mask of G3E field.
	TSC_IOGCSR_G3E     = 0x4      // Bit G3E.
	TSC_IOGCSR_G2E_Pos = 0x1      // Position of G2E field.
	TSC_IOGCSR_G2E_Msk = 0x2      // Bit mask of G2E field.
	TSC_IOGCSR_G2E     = 0x2      // Bit G2E.
	TSC_IOGCSR_G1E_Pos = 0x0      // Position of G1E field.
	TSC_IOGCSR_G1E_Msk = 0x1      // Bit mask of G1E field.
	TSC_IOGCSR_G1E     = 0x1      // Bit G1E.

	// IOG1CR: I/O group x counter register
	TSC_IOG1CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG1CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG2CR: I/O group x counter register
	TSC_IOG2CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG2CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG3CR: I/O group x counter register
	TSC_IOG3CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG3CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG4CR: I/O group x counter register
	TSC_IOG4CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG4CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG5CR: I/O group x counter register
	TSC_IOG5CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG5CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG6CR: I/O group x counter register
	TSC_IOG6CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG6CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG7CR: I/O group x counter register
	TSC_IOG7CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG7CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG8CR: I/O group x counter register
	TSC_IOG8CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG8CR_CNT_Msk = 0x3fff // Bit mask of CNT field.
)

// Bitfields for CRC: cyclic redundancy check calculation unit
const (
	// DR: Data register
	CRC_DR_DR_Pos = 0x0        // Position of DR field.
	CRC_DR_DR_Msk = 0xffffffff // Bit mask of DR field.

	// IDR: Independent data register
	CRC_IDR_IDR_Pos = 0x0  // Position of IDR field.
	CRC_IDR_IDR_Msk = 0xff // Bit mask of IDR field.

	// CR: Control register
	CRC_CR_RESET_Pos    = 0x0  // Position of RESET field.
	CRC_CR_RESET_Msk    = 0x1  // Bit mask of RESET field.
	CRC_CR_RESET        = 0x1  // Bit RESET.
	CRC_CR_POLYSIZE_Pos = 0x3  // Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18 // Bit mask of POLYSIZE field.
	CRC_CR_REV_IN_Pos   = 0x5  // Position of REV_IN field.
	CRC_CR_REV_IN_Msk   = 0x60 // Bit mask of REV_IN field.
	CRC_CR_REV_OUT_Pos  = 0x7  // Position of REV_OUT field.
	CRC_CR_REV_OUT_Msk  = 0x80 // Bit mask of REV_OUT field.
	CRC_CR_REV_OUT      = 0x80 // Bit REV_OUT.

	// INIT: Initial CRC value
	CRC_INIT_INIT_Pos = 0x0        // Position of INIT field.
	CRC_INIT_INIT_Msk = 0xffffffff // Bit mask of INIT field.

	// POL: CRC polynomial
	CRC_POL_POL_Pos = 0x0        // Position of POL field.
	CRC_POL_POL_Msk = 0xffffffff // Bit mask of POL field.
)

// Bitfields for Flash: Flash
const (
	// ACR: Flash access control register
	Flash_ACR_LATENCY_Pos = 0x0  // Position of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0x7  // Bit mask of LATENCY field.
	Flash_ACR_PRFTBE_Pos  = 0x4  // Position of PRFTBE field.
	Flash_ACR_PRFTBE_Msk  = 0x10 // Bit mask of PRFTBE field.
	Flash_ACR_PRFTBE      = 0x10 // Bit PRFTBE.
	Flash_ACR_PRFTBS_Pos  = 0x5  // Position of PRFTBS field.
	Flash_ACR_PRFTBS_Msk  = 0x20 // Bit mask of PRFTBS field.
	Flash_ACR_PRFTBS      = 0x20 // Bit PRFTBS.

	// KEYR: Flash key register
	Flash_KEYR_FKEYR_Pos = 0x0        // Position of FKEYR field.
	Flash_KEYR_FKEYR_Msk = 0xffffffff // Bit mask of FKEYR field.

	// OPTKEYR: Flash option key register
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0        // Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff // Bit mask of OPTKEYR field.

	// SR: Flash status register
	Flash_SR_EOP_Pos   = 0x5  // Position of EOP field.
	Flash_SR_EOP_Msk   = 0x20 // Bit mask of EOP field.
	Flash_SR_EOP       = 0x20 // Bit EOP.
	Flash_SR_WRPRT_Pos = 0x4  // Position of WRPRT field.
	Flash_SR_WRPRT_Msk = 0x10 // Bit mask of WRPRT field.
	Flash_SR_WRPRT     = 0x10 // Bit WRPRT.
	Flash_SR_PGERR_Pos = 0x2  // Position of PGERR field.
	Flash_SR_PGERR_Msk = 0x4  // Bit mask of PGERR field.
	Flash_SR_PGERR     = 0x4  // Bit PGERR.
	Flash_SR_BSY_Pos   = 0x0  // Position of BSY field.
	Flash_SR_BSY_Msk   = 0x1  // Bit mask of BSY field.
	Flash_SR_BSY       = 0x1  // Bit BSY.

	// CR: Flash control register
	Flash_CR_FORCE_OPTLOAD_Pos = 0xd    // Position of FORCE_OPTLOAD field.
	Flash_CR_FORCE_OPTLOAD_Msk = 0x2000 // Bit mask of FORCE_OPTLOAD field.
	Flash_CR_FORCE_OPTLOAD     = 0x2000 // Bit FORCE_OPTLOAD.
	Flash_CR_EOPIE_Pos         = 0xc    // Position of EOPIE field.
	Flash_CR_EOPIE_Msk         = 0x1000 // Bit mask of EOPIE field.
	Flash_CR_EOPIE             = 0x1000 // Bit EOPIE.
	Flash_CR_ERRIE_Pos         = 0xa    // Position of ERRIE field.
	Flash_CR_ERRIE_Msk         = 0x400  // Bit mask of ERRIE field.
	Flash_CR_ERRIE             = 0x400  // Bit ERRIE.
	Flash_CR_OPTWRE_Pos        = 0x9    // Position of OPTWRE field.
	Flash_CR_OPTWRE_Msk        = 0x200  // Bit mask of OPTWRE field.
	Flash_CR_OPTWRE            = 0x200  // Bit OPTWRE.
	Flash_CR_LOCK_Pos          = 0x7    // Position of LOCK field.
	Flash_CR_LOCK_Msk          = 0x80   // Bit mask of LOCK field.
	Flash_CR_LOCK              = 0x80   // Bit LOCK.
	Flash_CR_STRT_Pos          = 0x6    // Position of STRT field.
	Flash_CR_STRT_Msk          = 0x40   // Bit mask of STRT field.
	Flash_CR_STRT              = 0x40   // Bit STRT.
	Flash_CR_OPTER_Pos         = 0x5    // Position of OPTER field.
	Flash_CR_OPTER_Msk         = 0x20   // Bit mask of OPTER field.
	Flash_CR_OPTER             = 0x20   // Bit OPTER.
	Flash_CR_OPTPG_Pos         = 0x4    // Position of OPTPG field.
	Flash_CR_OPTPG_Msk         = 0x10   // Bit mask of OPTPG field.
	Flash_CR_OPTPG             = 0x10   // Bit OPTPG.
	Flash_CR_MER_Pos           = 0x2    // Position of MER field.
	Flash_CR_MER_Msk           = 0x4    // Bit mask of MER field.
	Flash_CR_MER               = 0x4    // Bit MER.
	Flash_CR_PER_Pos           = 0x1    // Position of PER field.
	Flash_CR_PER_Msk           = 0x2    // Bit mask of PER field.
	Flash_CR_PER               = 0x2    // Bit PER.
	Flash_CR_PG_Pos            = 0x0    // Position of PG field.
	Flash_CR_PG_Msk            = 0x1    // Bit mask of PG field.
	Flash_CR_PG                = 0x1    // Bit PG.

	// AR: Flash address register
	Flash_AR_FAR_Pos = 0x0        // Position of FAR field.
	Flash_AR_FAR_Msk = 0xffffffff // Bit mask of FAR field.

	// OBR: Option byte register
	Flash_OBR_OPTERR_Pos            = 0x0        // Position of OPTERR field.
	Flash_OBR_OPTERR_Msk            = 0x1        // Bit mask of OPTERR field.
	Flash_OBR_OPTERR                = 0x1        // Bit OPTERR.
	Flash_OBR_LEVEL1_PROT_Pos       = 0x1        // Position of LEVEL1_PROT field.
	Flash_OBR_LEVEL1_PROT_Msk       = 0x2        // Bit mask of LEVEL1_PROT field.
	Flash_OBR_LEVEL1_PROT           = 0x2        // Bit LEVEL1_PROT.
	Flash_OBR_LEVEL2_PROT_Pos       = 0x2        // Position of LEVEL2_PROT field.
	Flash_OBR_LEVEL2_PROT_Msk       = 0x4        // Bit mask of LEVEL2_PROT field.
	Flash_OBR_LEVEL2_PROT           = 0x4        // Bit LEVEL2_PROT.
	Flash_OBR_WDG_SW_Pos            = 0x8        // Position of WDG_SW field.
	Flash_OBR_WDG_SW_Msk            = 0x100      // Bit mask of WDG_SW field.
	Flash_OBR_WDG_SW                = 0x100      // Bit WDG_SW.
	Flash_OBR_NRST_STOP_Pos         = 0x9        // Position of NRST_STOP field.
	Flash_OBR_NRST_STOP_Msk         = 0x200      // Bit mask of NRST_STOP field.
	Flash_OBR_NRST_STOP             = 0x200      // Bit NRST_STOP.
	Flash_OBR_NRST_STDBY_Pos        = 0xa        // Position of NRST_STDBY field.
	Flash_OBR_NRST_STDBY_Msk        = 0x400      // Bit mask of NRST_STDBY field.
	Flash_OBR_NRST_STDBY            = 0x400      // Bit NRST_STDBY.
	Flash_OBR_BOOT1_Pos             = 0xc        // Position of BOOT1 field.
	Flash_OBR_BOOT1_Msk             = 0x1000     // Bit mask of BOOT1 field.
	Flash_OBR_BOOT1                 = 0x1000     // Bit BOOT1.
	Flash_OBR_VDDA_MONITOR_Pos      = 0xd        // Position of VDDA_MONITOR field.
	Flash_OBR_VDDA_MONITOR_Msk      = 0x2000     // Bit mask of VDDA_MONITOR field.
	Flash_OBR_VDDA_MONITOR          = 0x2000     // Bit VDDA_MONITOR.
	Flash_OBR_SRAM_PARITY_CHECK_Pos = 0xe        // Position of SRAM_PARITY_CHECK field.
	Flash_OBR_SRAM_PARITY_CHECK_Msk = 0x4000     // Bit mask of SRAM_PARITY_CHECK field.
	Flash_OBR_SRAM_PARITY_CHECK     = 0x4000     // Bit SRAM_PARITY_CHECK.
	Flash_OBR_Data0_Pos             = 0x10       // Position of Data0 field.
	Flash_OBR_Data0_Msk             = 0xff0000   // Bit mask of Data0 field.
	Flash_OBR_Data1_Pos             = 0x18       // Position of Data1 field.
	Flash_OBR_Data1_Msk             = 0xff000000 // Bit mask of Data1 field.

	// WRPR: Write protection register
	Flash_WRPR_WRP_Pos = 0x0        // Position of WRP field.
	Flash_WRPR_WRP_Msk = 0xffffffff // Bit mask of WRP field.
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	RCC_CR_HSION_Pos   = 0x0       // Position of HSION field.
	RCC_CR_HSION_Msk   = 0x1       // Bit mask of HSION field.
	RCC_CR_HSION       = 0x1       // Bit HSION.
	RCC_CR_HSIRDY_Pos  = 0x1       // Position of HSIRDY field.
	RCC_CR_HSIRDY_Msk  = 0x2       // Bit mask of HSIRDY field.
	RCC_CR_HSIRDY      = 0x2       // Bit HSIRDY.
	RCC_CR_HSITRIM_Pos = 0x3       // Position of HSITRIM field.
	RCC_CR_HSITRIM_Msk = 0xf8      // Bit mask of HSITRIM field.
	RCC_CR_HSICAL_Pos  = 0x8       // Position of HSICAL field.
	RCC_CR_HSICAL_Msk  = 0xff00    // Bit mask of HSICAL field.
	RCC_CR_HSEON_Pos   = 0x10      // Position of HSEON field.
	RCC_CR_HSEON_Msk   = 0x10000   // Bit mask of HSEON field.
	RCC_CR_HSEON       = 0x10000   // Bit HSEON.
	RCC_CR_HSERDY_Pos  = 0x11      // Position of HSERDY field.
	RCC_CR_HSERDY_Msk  = 0x20000   // Bit mask of HSERDY field.
	RCC_CR_HSERDY      = 0x20000   // Bit HSERDY.
	RCC_CR_HSEBYP_Pos  = 0x12      // Position of HSEBYP field.
	RCC_CR_HSEBYP_Msk  = 0x40000   // Bit mask of HSEBYP field.
	RCC_CR_HSEBYP      = 0x40000   // Bit HSEBYP.
	RCC_CR_CSSON_Pos   = 0x13      // Position of CSSON field.
	RCC_CR_CSSON_Msk   = 0x80000   // Bit mask of CSSON field.
	RCC_CR_CSSON       = 0x80000   // Bit CSSON.
	RCC_CR_PLLON_Pos   = 0x18      // Position of PLLON field.
	RCC_CR_PLLON_Msk   = 0x1000000 // Bit mask of PLLON field.
	RCC_CR_PLLON       = 0x1000000 // Bit PLLON.
	RCC_CR_PLLRDY_Pos  = 0x19      // Position of PLLRDY field.
	RCC_CR_PLLRDY_Msk  = 0x2000000 // Bit mask of PLLRDY field.
	RCC_CR_PLLRDY      = 0x2000000 // Bit PLLRDY.

	// CFGR: Clock configuration register           (RCC_CFGR)
	RCC_CFGR_SW_Pos       = 0x0        // Position of SW field.
	RCC_CFGR_SW_Msk       = 0x3        // Bit mask of SW field.
	RCC_CFGR_SWS_Pos      = 0x2        // Position of SWS field.
	RCC_CFGR_SWS_Msk      = 0xc        // Bit mask of SWS field.
	RCC_CFGR_HPRE_Pos     = 0x4        // Position of HPRE field.
	RCC_CFGR_HPRE_Msk     = 0xf0       // Bit mask of HPRE field.
	RCC_CFGR_PPRE1_Pos    = 0x8        // Position of PPRE1 field.
	RCC_CFGR_PPRE1_Msk    = 0x700      // Bit mask of PPRE1 field.
	RCC_CFGR_PPRE2_Pos    = 0xb        // Position of PPRE2 field.
	RCC_CFGR_PPRE2_Msk    = 0x3800     // Bit mask of PPRE2 field.
	RCC_CFGR_PLLSRC_Pos   = 0xf        // Position of PLLSRC field.
	RCC_CFGR_PLLSRC_Msk   = 0x18000    // Bit mask of PLLSRC field.
	RCC_CFGR_PLLXTPRE_Pos = 0x11       // Position of PLLXTPRE field.
	RCC_CFGR_PLLXTPRE_Msk = 0x20000    // Bit mask of PLLXTPRE field.
	RCC_CFGR_PLLXTPRE     = 0x20000    // Bit PLLXTPRE.
	RCC_CFGR_PLLMUL_Pos   = 0x12       // Position of PLLMUL field.
	RCC_CFGR_PLLMUL_Msk   = 0x3c0000   // Bit mask of PLLMUL field.
	RCC_CFGR_USBPRES_Pos  = 0x16       // Position of USBPRES field.
	RCC_CFGR_USBPRES_Msk  = 0x400000   // Bit mask of USBPRES field.
	RCC_CFGR_USBPRES      = 0x400000   // Bit USBPRES.
	RCC_CFGR_MCO_Pos      = 0x18       // Position of MCO field.
	RCC_CFGR_MCO_Msk      = 0x7000000  // Bit mask of MCO field.
	RCC_CFGR_MCOF_Pos     = 0x1c       // Position of MCOF field.
	RCC_CFGR_MCOF_Msk     = 0x10000000 // Bit mask of MCOF field.
	RCC_CFGR_MCOF         = 0x10000000 // Bit MCOF.
	RCC_CFGR_I2SSRC_Pos   = 0x17       // Position of I2SSRC field.
	RCC_CFGR_I2SSRC_Msk   = 0x800000   // Bit mask of I2SSRC field.
	RCC_CFGR_I2SSRC       = 0x800000   // Bit I2SSRC.

	// CIR: Clock interrupt register           (RCC_CIR)
	RCC_CIR_LSIRDYF_Pos  = 0x0      // Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk  = 0x1      // Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF      = 0x1      // Bit LSIRDYF.
	RCC_CIR_LSERDYF_Pos  = 0x1      // Position of LSERDYF field.
	RCC_CIR_LSERDYF_Msk  = 0x2      // Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF      = 0x2      // Bit LSERDYF.
	RCC_CIR_HSIRDYF_Pos  = 0x2      // Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk  = 0x4      // Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF      = 0x4      // Bit HSIRDYF.
	RCC_CIR_HSERDYF_Pos  = 0x3      // Position of HSERDYF field.
	RCC_CIR_HSERDYF_Msk  = 0x8      // Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF      = 0x8      // Bit HSERDYF.
	RCC_CIR_PLLRDYF_Pos  = 0x4      // Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk  = 0x10     // Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF      = 0x10     // Bit PLLRDYF.
	RCC_CIR_CSSF_Pos     = 0x7      // Position of CSSF field.
	RCC_CIR_CSSF_Msk     = 0x80     // Bit mask of CSSF field.
	RCC_CIR_CSSF         = 0x80     // Bit CSSF.
	RCC_CIR_LSIRDYIE_Pos = 0x8      // Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk = 0x100    // Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE     = 0x100    // Bit LSIRDYIE.
	RCC_CIR_LSERDYIE_Pos = 0x9      // Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk = 0x200    // Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE     = 0x200    // Bit LSERDYIE.
	RCC_CIR_HSIRDYIE_Pos = 0xa      // Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk = 0x400    // Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE     = 0x400    // Bit HSIRDYIE.
	RCC_CIR_HSERDYIE_Pos = 0xb      // Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk = 0x800    // Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE     = 0x800    // Bit HSERDYIE.
	RCC_CIR_PLLRDYIE_Pos = 0xc      // Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk = 0x1000   // Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE     = 0x1000   // Bit PLLRDYIE.
	RCC_CIR_LSIRDYC_Pos  = 0x10     // Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk  = 0x10000  // Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC      = 0x10000  // Bit LSIRDYC.
	RCC_CIR_LSERDYC_Pos  = 0x11     // Position of LSERDYC field.
	RCC_CIR_LSERDYC_Msk  = 0x20000  // Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC      = 0x20000  // Bit LSERDYC.
	RCC_CIR_HSIRDYC_Pos  = 0x12     // Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk  = 0x40000  // Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC      = 0x40000  // Bit HSIRDYC.
	RCC_CIR_HSERDYC_Pos  = 0x13     // Position of HSERDYC field.
	RCC_CIR_HSERDYC_Msk  = 0x80000  // Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC      = 0x80000  // Bit HSERDYC.
	RCC_CIR_PLLRDYC_Pos  = 0x14     // Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk  = 0x100000 // Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC      = 0x100000 // Bit PLLRDYC.
	RCC_CIR_CSSC_Pos     = 0x17     // Position of CSSC field.
	RCC_CIR_CSSC_Msk     = 0x800000 // Bit mask of CSSC field.
	RCC_CIR_CSSC         = 0x800000 // Bit CSSC.

	// APB2RSTR: APB2 peripheral reset register           (RCC_APB2RSTR)
	RCC_APB2RSTR_SYSCFGRST_Pos = 0x0     // Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x1     // Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST     = 0x1     // Bit SYSCFGRST.
	RCC_APB2RSTR_TIM1RST_Pos   = 0xb     // Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk   = 0x800   // Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST       = 0x800   // Bit TIM1RST.
	RCC_APB2RSTR_SPI1RST_Pos   = 0xc     // Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk   = 0x1000  // Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST       = 0x1000  // Bit SPI1RST.
	RCC_APB2RSTR_TIM8RST_Pos   = 0xd     // Position of TIM8RST field.
	RCC_APB2RSTR_TIM8RST_Msk   = 0x2000  // Bit mask of TIM8RST field.
	RCC_APB2RSTR_TIM8RST       = 0x2000  // Bit TIM8RST.
	RCC_APB2RSTR_USART1RST_Pos = 0xe     // Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000  // Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST     = 0x4000  // Bit USART1RST.
	RCC_APB2RSTR_TIM15RST_Pos  = 0x10    // Position of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Msk  = 0x10000 // Bit mask of TIM15RST field.
	RCC_APB2RSTR_TIM15RST      = 0x10000 // Bit TIM15RST.
	RCC_APB2RSTR_TIM16RST_Pos  = 0x11    // Position of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Msk  = 0x20000 // Bit mask of TIM16RST field.
	RCC_APB2RSTR_TIM16RST      = 0x20000 // Bit TIM16RST.
	RCC_APB2RSTR_TIM17RST_Pos  = 0x12    // Position of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Msk  = 0x40000 // Bit mask of TIM17RST field.
	RCC_APB2RSTR_TIM17RST      = 0x40000 // Bit TIM17RST.

	// APB1RSTR: APB1 peripheral reset register           (RCC_APB1RSTR)
	RCC_APB1RSTR_TIM2RST_Pos   = 0x0        // Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk   = 0x1        // Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST       = 0x1        // Bit TIM2RST.
	RCC_APB1RSTR_TIM3RST_Pos   = 0x1        // Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk   = 0x2        // Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST       = 0x2        // Bit TIM3RST.
	RCC_APB1RSTR_TIM4RST_Pos   = 0x2        // Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk   = 0x4        // Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST       = 0x4        // Bit TIM4RST.
	RCC_APB1RSTR_TIM6RST_Pos   = 0x4        // Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk   = 0x10       // Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST       = 0x10       // Bit TIM6RST.
	RCC_APB1RSTR_TIM7RST_Pos   = 0x5        // Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk   = 0x20       // Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST       = 0x20       // Bit TIM7RST.
	RCC_APB1RSTR_WWDGRST_Pos   = 0xb        // Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk   = 0x800      // Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST       = 0x800      // Bit WWDGRST.
	RCC_APB1RSTR_SPI2RST_Pos   = 0xe        // Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk   = 0x4000     // Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST       = 0x4000     // Bit SPI2RST.
	RCC_APB1RSTR_SPI3RST_Pos   = 0xf        // Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk   = 0x8000     // Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST       = 0x8000     // Bit SPI3RST.
	RCC_APB1RSTR_USART2RST_Pos = 0x11       // Position of USART2RST field.
	RCC_APB1RSTR_USART2RST_Msk = 0x20000    // Bit mask of USART2RST field.
	RCC_APB1RSTR_USART2RST     = 0x20000    // Bit USART2RST.
	RCC_APB1RSTR_USART3RST_Pos = 0x12       // Position of USART3RST field.
	RCC_APB1RSTR_USART3RST_Msk = 0x40000    // Bit mask of USART3RST field.
	RCC_APB1RSTR_USART3RST     = 0x40000    // Bit USART3RST.
	RCC_APB1RSTR_UART4RST_Pos  = 0x13       // Position of UART4RST field.
	RCC_APB1RSTR_UART4RST_Msk  = 0x80000    // Bit mask of UART4RST field.
	RCC_APB1RSTR_UART4RST      = 0x80000    // Bit UART4RST.
	RCC_APB1RSTR_UART5RST_Pos  = 0x14       // Position of UART5RST field.
	RCC_APB1RSTR_UART5RST_Msk  = 0x100000   // Bit mask of UART5RST field.
	RCC_APB1RSTR_UART5RST      = 0x100000   // Bit UART5RST.
	RCC_APB1RSTR_I2C1RST_Pos   = 0x15       // Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk   = 0x200000   // Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST       = 0x200000   // Bit I2C1RST.
	RCC_APB1RSTR_I2C2RST_Pos   = 0x16       // Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk   = 0x400000   // Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST       = 0x400000   // Bit I2C2RST.
	RCC_APB1RSTR_USBRST_Pos    = 0x17       // Position of USBRST field.
	RCC_APB1RSTR_USBRST_Msk    = 0x800000   // Bit mask of USBRST field.
	RCC_APB1RSTR_USBRST        = 0x800000   // Bit USBRST.
	RCC_APB1RSTR_CANRST_Pos    = 0x19       // Position of CANRST field.
	RCC_APB1RSTR_CANRST_Msk    = 0x2000000  // Bit mask of CANRST field.
	RCC_APB1RSTR_CANRST        = 0x2000000  // Bit CANRST.
	RCC_APB1RSTR_PWRRST_Pos    = 0x1c       // Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk    = 0x10000000 // Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST        = 0x10000000 // Bit PWRRST.
	RCC_APB1RSTR_DACRST_Pos    = 0x1d       // Position of DACRST field.
	RCC_APB1RSTR_DACRST_Msk    = 0x20000000 // Bit mask of DACRST field.
	RCC_APB1RSTR_DACRST        = 0x20000000 // Bit DACRST.
	RCC_APB1RSTR_I2C3RST_Pos   = 0x1e       // Position of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Msk   = 0x40000000 // Bit mask of I2C3RST field.
	RCC_APB1RSTR_I2C3RST       = 0x40000000 // Bit I2C3RST.

	// AHBENR: AHB Peripheral Clock enable register           (RCC_AHBENR)
	RCC_AHBENR_DMAEN_Pos   = 0x0        // Position of DMAEN field.
	RCC_AHBENR_DMAEN_Msk   = 0x1        // Bit mask of DMAEN field.
	RCC_AHBENR_DMAEN       = 0x1        // Bit DMAEN.
	RCC_AHBENR_DMA2EN_Pos  = 0x1        // Position of DMA2EN field.
	RCC_AHBENR_DMA2EN_Msk  = 0x2        // Bit mask of DMA2EN field.
	RCC_AHBENR_DMA2EN      = 0x2        // Bit DMA2EN.
	RCC_AHBENR_SRAMEN_Pos  = 0x2        // Position of SRAMEN field.
	RCC_AHBENR_SRAMEN_Msk  = 0x4        // Bit mask of SRAMEN field.
	RCC_AHBENR_SRAMEN      = 0x4        // Bit SRAMEN.
	RCC_AHBENR_FLITFEN_Pos = 0x4        // Position of FLITFEN field.
	RCC_AHBENR_FLITFEN_Msk = 0x10       // Bit mask of FLITFEN field.
	RCC_AHBENR_FLITFEN     = 0x10       // Bit FLITFEN.
	RCC_AHBENR_FMCEN_Pos   = 0x5        // Position of FMCEN field.
	RCC_AHBENR_FMCEN_Msk   = 0x20       // Bit mask of FMCEN field.
	RCC_AHBENR_FMCEN       = 0x20       // Bit FMCEN.
	RCC_AHBENR_CRCEN_Pos   = 0x6        // Position of CRCEN field.
	RCC_AHBENR_CRCEN_Msk   = 0x40       // Bit mask of CRCEN field.
	RCC_AHBENR_CRCEN       = 0x40       // Bit CRCEN.
	RCC_AHBENR_IOPHEN_Pos  = 0x10       // Position of IOPHEN field.
	RCC_AHBENR_IOPHEN_Msk  = 0x10000    // Bit mask of IOPHEN field.
	RCC_AHBENR_IOPHEN      = 0x10000    // Bit IOPHEN.
	RCC_AHBENR_IOPAEN_Pos  = 0x11       // Position of IOPAEN field.
	RCC_AHBENR_IOPAEN_Msk  = 0x20000    // Bit mask of IOPAEN field.
	RCC_AHBENR_IOPAEN      = 0x20000    // Bit IOPAEN.
	RCC_AHBENR_IOPBEN_Pos  = 0x12       // Position of IOPBEN field.
	RCC_AHBENR_IOPBEN_Msk  = 0x40000    // Bit mask of IOPBEN field.
	RCC_AHBENR_IOPBEN      = 0x40000    // Bit IOPBEN.
	RCC_AHBENR_IOPCEN_Pos  = 0x13       // Position of IOPCEN field.
	RCC_AHBENR_IOPCEN_Msk  = 0x80000    // Bit mask of IOPCEN field.
	RCC_AHBENR_IOPCEN      = 0x80000    // Bit IOPCEN.
	RCC_AHBENR_IOPDEN_Pos  = 0x14       // Position of IOPDEN field.
	RCC_AHBENR_IOPDEN_Msk  = 0x100000   // Bit mask of IOPDEN field.
	RCC_AHBENR_IOPDEN      = 0x100000   // Bit IOPDEN.
	RCC_AHBENR_IOPEEN_Pos  = 0x15       // Position of IOPEEN field.
	RCC_AHBENR_IOPEEN_Msk  = 0x200000   // Bit mask of IOPEEN field.
	RCC_AHBENR_IOPEEN      = 0x200000   // Bit IOPEEN.
	RCC_AHBENR_IOPFEN_Pos  = 0x16       // Position of IOPFEN field.
	RCC_AHBENR_IOPFEN_Msk  = 0x400000   // Bit mask of IOPFEN field.
	RCC_AHBENR_IOPFEN      = 0x400000   // Bit IOPFEN.
	RCC_AHBENR_IOPGEN_Pos  = 0x17       // Position of IOPGEN field.
	RCC_AHBENR_IOPGEN_Msk  = 0x800000   // Bit mask of IOPGEN field.
	RCC_AHBENR_IOPGEN      = 0x800000   // Bit IOPGEN.
	RCC_AHBENR_TSCEN_Pos   = 0x18       // Position of TSCEN field.
	RCC_AHBENR_TSCEN_Msk   = 0x1000000  // Bit mask of TSCEN field.
	RCC_AHBENR_TSCEN       = 0x1000000  // Bit TSCEN.
	RCC_AHBENR_ADC12EN_Pos = 0x1c       // Position of ADC12EN field.
	RCC_AHBENR_ADC12EN_Msk = 0x10000000 // Bit mask of ADC12EN field.
	RCC_AHBENR_ADC12EN     = 0x10000000 // Bit ADC12EN.
	RCC_AHBENR_ADC34EN_Pos = 0x1d       // Position of ADC34EN field.
	RCC_AHBENR_ADC34EN_Msk = 0x20000000 // Bit mask of ADC34EN field.
	RCC_AHBENR_ADC34EN     = 0x20000000 // Bit ADC34EN.

	// APB2ENR: APB2 peripheral clock enable register           (RCC_APB2ENR)
	RCC_APB2ENR_SYSCFGEN_Pos = 0x0     // Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x1     // Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN     = 0x1     // Bit SYSCFGEN.
	RCC_APB2ENR_TIM1EN_Pos   = 0xb     // Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk   = 0x800   // Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN       = 0x800   // Bit TIM1EN.
	RCC_APB2ENR_SPI1EN_Pos   = 0xc     // Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk   = 0x1000  // Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN       = 0x1000  // Bit SPI1EN.
	RCC_APB2ENR_TIM8EN_Pos   = 0xd     // Position of TIM8EN field.
	RCC_APB2ENR_TIM8EN_Msk   = 0x2000  // Bit mask of TIM8EN field.
	RCC_APB2ENR_TIM8EN       = 0x2000  // Bit TIM8EN.
	RCC_APB2ENR_USART1EN_Pos = 0xe     // Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000  // Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN     = 0x4000  // Bit USART1EN.
	RCC_APB2ENR_TIM15EN_Pos  = 0x10    // Position of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Msk  = 0x10000 // Bit mask of TIM15EN field.
	RCC_APB2ENR_TIM15EN      = 0x10000 // Bit TIM15EN.
	RCC_APB2ENR_TIM16EN_Pos  = 0x11    // Position of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Msk  = 0x20000 // Bit mask of TIM16EN field.
	RCC_APB2ENR_TIM16EN      = 0x20000 // Bit TIM16EN.
	RCC_APB2ENR_TIM17EN_Pos  = 0x12    // Position of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Msk  = 0x40000 // Bit mask of TIM17EN field.
	RCC_APB2ENR_TIM17EN      = 0x40000 // Bit TIM17EN.

	// APB1ENR: APB1 peripheral clock enable register           (RCC_APB1ENR)
	RCC_APB1ENR_TIM2EN_Pos   = 0x0        // Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk   = 0x1        // Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN       = 0x1        // Bit TIM2EN.
	RCC_APB1ENR_TIM3EN_Pos   = 0x1        // Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk   = 0x2        // Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN       = 0x2        // Bit TIM3EN.
	RCC_APB1ENR_TIM4EN_Pos   = 0x2        // Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk   = 0x4        // Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN       = 0x4        // Bit TIM4EN.
	RCC_APB1ENR_TIM6EN_Pos   = 0x4        // Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk   = 0x10       // Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN       = 0x10       // Bit TIM6EN.
	RCC_APB1ENR_TIM7EN_Pos   = 0x5        // Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk   = 0x20       // Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN       = 0x20       // Bit TIM7EN.
	RCC_APB1ENR_WWDGEN_Pos   = 0xb        // Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk   = 0x800      // Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN       = 0x800      // Bit WWDGEN.
	RCC_APB1ENR_SPI2EN_Pos   = 0xe        // Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk   = 0x4000     // Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN       = 0x4000     // Bit SPI2EN.
	RCC_APB1ENR_SPI3EN_Pos   = 0xf        // Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk   = 0x8000     // Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN       = 0x8000     // Bit SPI3EN.
	RCC_APB1ENR_USART2EN_Pos = 0x11       // Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000    // Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN     = 0x20000    // Bit USART2EN.
	RCC_APB1ENR_USART3EN_Pos = 0x12       // Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk = 0x40000    // Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN     = 0x40000    // Bit USART3EN.
	RCC_APB1ENR_USART4EN_Pos = 0x13       // Position of USART4EN field.
	RCC_APB1ENR_USART4EN_Msk = 0x80000    // Bit mask of USART4EN field.
	RCC_APB1ENR_USART4EN     = 0x80000    // Bit USART4EN.
	RCC_APB1ENR_USART5EN_Pos = 0x14       // Position of USART5EN field.
	RCC_APB1ENR_USART5EN_Msk = 0x100000   // Bit mask of USART5EN field.
	RCC_APB1ENR_USART5EN     = 0x100000   // Bit USART5EN.
	RCC_APB1ENR_I2C1EN_Pos   = 0x15       // Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk   = 0x200000   // Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN       = 0x200000   // Bit I2C1EN.
	RCC_APB1ENR_I2C2EN_Pos   = 0x16       // Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk   = 0x400000   // Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN       = 0x400000   // Bit I2C2EN.
	RCC_APB1ENR_USBEN_Pos    = 0x17       // Position of USBEN field.
	RCC_APB1ENR_USBEN_Msk    = 0x800000   // Bit mask of USBEN field.
	RCC_APB1ENR_USBEN        = 0x800000   // Bit USBEN.
	RCC_APB1ENR_CANEN_Pos    = 0x19       // Position of CANEN field.
	RCC_APB1ENR_CANEN_Msk    = 0x2000000  // Bit mask of CANEN field.
	RCC_APB1ENR_CANEN        = 0x2000000  // Bit CANEN.
	RCC_APB1ENR_DAC2EN_Pos   = 0x1a       // Position of DAC2EN field.
	RCC_APB1ENR_DAC2EN_Msk   = 0x4000000  // Bit mask of DAC2EN field.
	RCC_APB1ENR_DAC2EN       = 0x4000000  // Bit DAC2EN.
	RCC_APB1ENR_PWREN_Pos    = 0x1c       // Position of PWREN field.
	RCC_APB1ENR_PWREN_Msk    = 0x10000000 // Bit mask of PWREN field.
	RCC_APB1ENR_PWREN        = 0x10000000 // Bit PWREN.
	RCC_APB1ENR_DACEN_Pos    = 0x1d       // Position of DACEN field.
	RCC_APB1ENR_DACEN_Msk    = 0x20000000 // Bit mask of DACEN field.
	RCC_APB1ENR_DACEN        = 0x20000000 // Bit DACEN.
	RCC_APB1ENR_I2C3EN_Pos   = 0x1e       // Position of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Msk   = 0x40000000 // Bit mask of I2C3EN field.
	RCC_APB1ENR_I2C3EN       = 0x40000000 // Bit I2C3EN.

	// BDCR: Backup domain control register           (RCC_BDCR)
	RCC_BDCR_LSEON_Pos  = 0x0     // Position of LSEON field.
	RCC_BDCR_LSEON_Msk  = 0x1     // Bit mask of LSEON field.
	RCC_BDCR_LSEON      = 0x1     // Bit LSEON.
	RCC_BDCR_LSERDY_Pos = 0x1     // Position of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2     // Bit mask of LSERDY field.
	RCC_BDCR_LSERDY     = 0x2     // Bit LSERDY.
	RCC_BDCR_LSEBYP_Pos = 0x2     // Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4     // Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP     = 0x4     // Bit LSEBYP.
	RCC_BDCR_LSEDRV_Pos = 0x3     // Position of LSEDRV field.
	RCC_BDCR_LSEDRV_Msk = 0x18    // Bit mask of LSEDRV field.
	RCC_BDCR_RTCSEL_Pos = 0x8     // Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300   // Bit mask of RTCSEL field.
	RCC_BDCR_RTCEN_Pos  = 0xf     // Position of RTCEN field.
	RCC_BDCR_RTCEN_Msk  = 0x8000  // Bit mask of RTCEN field.
	RCC_BDCR_RTCEN      = 0x8000  // Bit RTCEN.
	RCC_BDCR_BDRST_Pos  = 0x10    // Position of BDRST field.
	RCC_BDCR_BDRST_Msk  = 0x10000 // Bit mask of BDRST field.
	RCC_BDCR_BDRST      = 0x10000 // Bit BDRST.

	// CSR: Control/status register           (RCC_CSR)
	RCC_CSR_LSION_Pos    = 0x0        // Position of LSION field.
	RCC_CSR_LSION_Msk    = 0x1        // Bit mask of LSION field.
	RCC_CSR_LSION        = 0x1        // Bit LSION.
	RCC_CSR_LSIRDY_Pos   = 0x1        // Position of LSIRDY field.
	RCC_CSR_LSIRDY_Msk   = 0x2        // Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY       = 0x2        // Bit LSIRDY.
	RCC_CSR_RMVF_Pos     = 0x18       // Position of RMVF field.
	RCC_CSR_RMVF_Msk     = 0x1000000  // Bit mask of RMVF field.
	RCC_CSR_RMVF         = 0x1000000  // Bit RMVF.
	RCC_CSR_OBLRSTF_Pos  = 0x19       // Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk  = 0x2000000  // Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF      = 0x2000000  // Bit OBLRSTF.
	RCC_CSR_PINRSTF_Pos  = 0x1a       // Position of PINRSTF field.
	RCC_CSR_PINRSTF_Msk  = 0x4000000  // Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF      = 0x4000000  // Bit PINRSTF.
	RCC_CSR_PORRSTF_Pos  = 0x1b       // Position of PORRSTF field.
	RCC_CSR_PORRSTF_Msk  = 0x8000000  // Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF      = 0x8000000  // Bit PORRSTF.
	RCC_CSR_SFTRSTF_Pos  = 0x1c       // Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk  = 0x10000000 // Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF      = 0x10000000 // Bit SFTRSTF.
	RCC_CSR_IWDGRSTF_Pos = 0x1d       // Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000 // Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF     = 0x20000000 // Bit IWDGRSTF.
	RCC_CSR_WWDGRSTF_Pos = 0x1e       // Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000 // Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF     = 0x40000000 // Bit WWDGRSTF.
	RCC_CSR_LPWRRSTF_Pos = 0x1f       // Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000 // Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF     = 0x80000000 // Bit LPWRRSTF.

	// AHBRSTR: AHB peripheral reset register
	RCC_AHBRSTR_FMCRST_Pos   = 0x5        // Position of FMCRST field.
	RCC_AHBRSTR_FMCRST_Msk   = 0x20       // Bit mask of FMCRST field.
	RCC_AHBRSTR_FMCRST       = 0x20       // Bit FMCRST.
	RCC_AHBRSTR_IOPHRST_Pos  = 0x10       // Position of IOPHRST field.
	RCC_AHBRSTR_IOPHRST_Msk  = 0x10000    // Bit mask of IOPHRST field.
	RCC_AHBRSTR_IOPHRST      = 0x10000    // Bit IOPHRST.
	RCC_AHBRSTR_IOPARST_Pos  = 0x11       // Position of IOPARST field.
	RCC_AHBRSTR_IOPARST_Msk  = 0x20000    // Bit mask of IOPARST field.
	RCC_AHBRSTR_IOPARST      = 0x20000    // Bit IOPARST.
	RCC_AHBRSTR_IOPBRST_Pos  = 0x12       // Position of IOPBRST field.
	RCC_AHBRSTR_IOPBRST_Msk  = 0x40000    // Bit mask of IOPBRST field.
	RCC_AHBRSTR_IOPBRST      = 0x40000    // Bit IOPBRST.
	RCC_AHBRSTR_IOPCRST_Pos  = 0x13       // Position of IOPCRST field.
	RCC_AHBRSTR_IOPCRST_Msk  = 0x80000    // Bit mask of IOPCRST field.
	RCC_AHBRSTR_IOPCRST      = 0x80000    // Bit IOPCRST.
	RCC_AHBRSTR_IOPDRST_Pos  = 0x14       // Position of IOPDRST field.
	RCC_AHBRSTR_IOPDRST_Msk  = 0x100000   // Bit mask of IOPDRST field.
	RCC_AHBRSTR_IOPDRST      = 0x100000   // Bit IOPDRST.
	RCC_AHBRSTR_IOPERST_Pos  = 0x15       // Position of IOPERST field.
	RCC_AHBRSTR_IOPERST_Msk  = 0x200000   // Bit mask of IOPERST field.
	RCC_AHBRSTR_IOPERST      = 0x200000   // Bit IOPERST.
	RCC_AHBRSTR_IOPFRST_Pos  = 0x16       // Position of IOPFRST field.
	RCC_AHBRSTR_IOPFRST_Msk  = 0x400000   // Bit mask of IOPFRST field.
	RCC_AHBRSTR_IOPFRST      = 0x400000   // Bit IOPFRST.
	RCC_AHBRSTR_IOPGRST_Pos  = 0x17       // Position of IOPGRST field.
	RCC_AHBRSTR_IOPGRST_Msk  = 0x800000   // Bit mask of IOPGRST field.
	RCC_AHBRSTR_IOPGRST      = 0x800000   // Bit IOPGRST.
	RCC_AHBRSTR_TSCRST_Pos   = 0x18       // Position of TSCRST field.
	RCC_AHBRSTR_TSCRST_Msk   = 0x1000000  // Bit mask of TSCRST field.
	RCC_AHBRSTR_TSCRST       = 0x1000000  // Bit TSCRST.
	RCC_AHBRSTR_ADC12RST_Pos = 0x1c       // Position of ADC12RST field.
	RCC_AHBRSTR_ADC12RST_Msk = 0x10000000 // Bit mask of ADC12RST field.
	RCC_AHBRSTR_ADC12RST     = 0x10000000 // Bit ADC12RST.
	RCC_AHBRSTR_ADC34RST_Pos = 0x1d       // Position of ADC34RST field.
	RCC_AHBRSTR_ADC34RST_Msk = 0x20000000 // Bit mask of ADC34RST field.
	RCC_AHBRSTR_ADC34RST     = 0x20000000 // Bit ADC34RST.

	// CFGR2: Clock configuration register 2
	RCC_CFGR2_PREDIV_Pos    = 0x0    // Position of PREDIV field.
	RCC_CFGR2_PREDIV_Msk    = 0xf    // Bit mask of PREDIV field.
	RCC_CFGR2_ADC12PRES_Pos = 0x4    // Position of ADC12PRES field.
	RCC_CFGR2_ADC12PRES_Msk = 0x1f0  // Bit mask of ADC12PRES field.
	RCC_CFGR2_ADC34PRES_Pos = 0x9    // Position of ADC34PRES field.
	RCC_CFGR2_ADC34PRES_Msk = 0x3e00 // Bit mask of ADC34PRES field.

	// CFGR3: Clock configuration register 3
	RCC_CFGR3_USART1SW_Pos = 0x0      // Position of USART1SW field.
	RCC_CFGR3_USART1SW_Msk = 0x3      // Bit mask of USART1SW field.
	RCC_CFGR3_I2C1SW_Pos   = 0x4      // Position of I2C1SW field.
	RCC_CFGR3_I2C1SW_Msk   = 0x10     // Bit mask of I2C1SW field.
	RCC_CFGR3_I2C1SW       = 0x10     // Bit I2C1SW.
	RCC_CFGR3_I2C2SW_Pos   = 0x5      // Position of I2C2SW field.
	RCC_CFGR3_I2C2SW_Msk   = 0x20     // Bit mask of I2C2SW field.
	RCC_CFGR3_I2C2SW       = 0x20     // Bit I2C2SW.
	RCC_CFGR3_I2C3SW_Pos   = 0x6      // Position of I2C3SW field.
	RCC_CFGR3_I2C3SW_Msk   = 0x40     // Bit mask of I2C3SW field.
	RCC_CFGR3_I2C3SW       = 0x40     // Bit I2C3SW.
	RCC_CFGR3_USART2SW_Pos = 0x10     // Position of USART2SW field.
	RCC_CFGR3_USART2SW_Msk = 0x30000  // Bit mask of USART2SW field.
	RCC_CFGR3_USART3SW_Pos = 0x12     // Position of USART3SW field.
	RCC_CFGR3_USART3SW_Msk = 0xc0000  // Bit mask of USART3SW field.
	RCC_CFGR3_TIM1SW_Pos   = 0x8      // Position of TIM1SW field.
	RCC_CFGR3_TIM1SW_Msk   = 0x100    // Bit mask of TIM1SW field.
	RCC_CFGR3_TIM1SW       = 0x100    // Bit TIM1SW.
	RCC_CFGR3_TIM8SW_Pos   = 0x9      // Position of TIM8SW field.
	RCC_CFGR3_TIM8SW_Msk   = 0x200    // Bit mask of TIM8SW field.
	RCC_CFGR3_TIM8SW       = 0x200    // Bit TIM8SW.
	RCC_CFGR3_UART4SW_Pos  = 0x14     // Position of UART4SW field.
	RCC_CFGR3_UART4SW_Msk  = 0x300000 // Bit mask of UART4SW field.
	RCC_CFGR3_UART5SW_Pos  = 0x16     // Position of UART5SW field.
	RCC_CFGR3_UART5SW_Msk  = 0xc00000 // Bit mask of UART5SW field.
)

// Bitfields for DMA1: DMA controller 1
const (
	// ISR: DMA interrupt status register           (DMA_ISR)
	DMA_ISR_GIF1_Pos  = 0x0       // Position of GIF1 field.
	DMA_ISR_GIF1_Msk  = 0x1       // Bit mask of GIF1 field.
	DMA_ISR_GIF1      = 0x1       // Bit GIF1.
	DMA_ISR_TCIF1_Pos = 0x1       // Position of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2       // Bit mask of TCIF1 field.
	DMA_ISR_TCIF1     = 0x2       // Bit TCIF1.
	DMA_ISR_HTIF1_Pos = 0x2       // Position of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4       // Bit mask of HTIF1 field.
	DMA_ISR_HTIF1     = 0x4       // Bit HTIF1.
	DMA_ISR_TEIF1_Pos = 0x3       // Position of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8       // Bit mask of TEIF1 field.
	DMA_ISR_TEIF1     = 0x8       // Bit TEIF1.
	DMA_ISR_GIF2_Pos  = 0x4       // Position of GIF2 field.
	DMA_ISR_GIF2_Msk  = 0x10      // Bit mask of GIF2 field.
	DMA_ISR_GIF2      = 0x10      // Bit GIF2.
	DMA_ISR_TCIF2_Pos = 0x5       // Position of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20      // Bit mask of TCIF2 field.
	DMA_ISR_TCIF2     = 0x20      // Bit TCIF2.
	DMA_ISR_HTIF2_Pos = 0x6       // Position of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40      // Bit mask of HTIF2 field.
	DMA_ISR_HTIF2     = 0x40      // Bit HTIF2.
	DMA_ISR_TEIF2_Pos = 0x7       // Position of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80      // Bit mask of TEIF2 field.
	DMA_ISR_TEIF2     = 0x80      // Bit TEIF2.
	DMA_ISR_GIF3_Pos  = 0x8       // Position of GIF3 field.
	DMA_ISR_GIF3_Msk  = 0x100     // Bit mask of GIF3 field.
	DMA_ISR_GIF3      = 0x100     // Bit GIF3.
	DMA_ISR_TCIF3_Pos = 0x9       // Position of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200     // Bit mask of TCIF3 field.
	DMA_ISR_TCIF3     = 0x200     // Bit TCIF3.
	DMA_ISR_HTIF3_Pos = 0xa       // Position of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400     // Bit mask of HTIF3 field.
	DMA_ISR_HTIF3     = 0x400     // Bit HTIF3.
	DMA_ISR_TEIF3_Pos = 0xb       // Position of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800     // Bit mask of TEIF3 field.
	DMA_ISR_TEIF3     = 0x800     // Bit TEIF3.
	DMA_ISR_GIF4_Pos  = 0xc       // Position of GIF4 field.
	DMA_ISR_GIF4_Msk  = 0x1000    // Bit mask of GIF4 field.
	DMA_ISR_GIF4      = 0x1000    // Bit GIF4.
	DMA_ISR_TCIF4_Pos = 0xd       // Position of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000    // Bit mask of TCIF4 field.
	DMA_ISR_TCIF4     = 0x2000    // Bit TCIF4.
	DMA_ISR_HTIF4_Pos = 0xe       // Position of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000    // Bit mask of HTIF4 field.
	DMA_ISR_HTIF4     = 0x4000    // Bit HTIF4.
	DMA_ISR_TEIF4_Pos = 0xf       // Position of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000    // Bit mask of TEIF4 field.
	DMA_ISR_TEIF4     = 0x8000    // Bit TEIF4.
	DMA_ISR_GIF5_Pos  = 0x10      // Position of GIF5 field.
	DMA_ISR_GIF5_Msk  = 0x10000   // Bit mask of GIF5 field.
	DMA_ISR_GIF5      = 0x10000   // Bit GIF5.
	DMA_ISR_TCIF5_Pos = 0x11      // Position of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000   // Bit mask of TCIF5 field.
	DMA_ISR_TCIF5     = 0x20000   // Bit TCIF5.
	DMA_ISR_HTIF5_Pos = 0x12      // Position of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000   // Bit mask of HTIF5 field.
	DMA_ISR_HTIF5     = 0x40000   // Bit HTIF5.
	DMA_ISR_TEIF5_Pos = 0x13      // Position of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000   // Bit mask of TEIF5 field.
	DMA_ISR_TEIF5     = 0x80000   // Bit TEIF5.
	DMA_ISR_GIF6_Pos  = 0x14      // Position of GIF6 field.
	DMA_ISR_GIF6_Msk  = 0x100000  // Bit mask of GIF6 field.
	DMA_ISR_GIF6      = 0x100000  // Bit GIF6.
	DMA_ISR_TCIF6_Pos = 0x15      // Position of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000  // Bit mask of TCIF6 field.
	DMA_ISR_TCIF6     = 0x200000  // Bit TCIF6.
	DMA_ISR_HTIF6_Pos = 0x16      // Position of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000  // Bit mask of HTIF6 field.
	DMA_ISR_HTIF6     = 0x400000  // Bit HTIF6.
	DMA_ISR_TEIF6_Pos = 0x17      // Position of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000  // Bit mask of TEIF6 field.
	DMA_ISR_TEIF6     = 0x800000  // Bit TEIF6.
	DMA_ISR_GIF7_Pos  = 0x18      // Position of GIF7 field.
	DMA_ISR_GIF7_Msk  = 0x1000000 // Bit mask of GIF7 field.
	DMA_ISR_GIF7      = 0x1000000 // Bit GIF7.
	DMA_ISR_TCIF7_Pos = 0x19      // Position of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000 // Bit mask of TCIF7 field.
	DMA_ISR_TCIF7     = 0x2000000 // Bit TCIF7.
	DMA_ISR_HTIF7_Pos = 0x1a      // Position of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000 // Bit mask of HTIF7 field.
	DMA_ISR_HTIF7     = 0x4000000 // Bit HTIF7.
	DMA_ISR_TEIF7_Pos = 0x1b      // Position of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000 // Bit mask of TEIF7 field.
	DMA_ISR_TEIF7     = 0x8000000 // Bit TEIF7.

	// IFCR: DMA interrupt flag clear register           (DMA_IFCR)
	DMA_IFCR_CGIF1_Pos  = 0x0       // Position of CGIF1 field.
	DMA_IFCR_CGIF1_Msk  = 0x1       // Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1      = 0x1       // Bit CGIF1.
	DMA_IFCR_CTCIF1_Pos = 0x1       // Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2       // Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1     = 0x2       // Bit CTCIF1.
	DMA_IFCR_CHTIF1_Pos = 0x2       // Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4       // Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1     = 0x4       // Bit CHTIF1.
	DMA_IFCR_CTEIF1_Pos = 0x3       // Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8       // Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1     = 0x8       // Bit CTEIF1.
	DMA_IFCR_CGIF2_Pos  = 0x4       // Position of CGIF2 field.
	DMA_IFCR_CGIF2_Msk  = 0x10      // Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2      = 0x10      // Bit CGIF2.
	DMA_IFCR_CTCIF2_Pos = 0x5       // Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20      // Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2     = 0x20      // Bit CTCIF2.
	DMA_IFCR_CHTIF2_Pos = 0x6       // Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40      // Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2     = 0x40      // Bit CHTIF2.
	DMA_IFCR_CTEIF2_Pos = 0x7       // Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80      // Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2     = 0x80      // Bit CTEIF2.
	DMA_IFCR_CGIF3_Pos  = 0x8       // Position of CGIF3 field.
	DMA_IFCR_CGIF3_Msk  = 0x100     // Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3      = 0x100     // Bit CGIF3.
	DMA_IFCR_CTCIF3_Pos = 0x9       // Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200     // Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3     = 0x200     // Bit CTCIF3.
	DMA_IFCR_CHTIF3_Pos = 0xa       // Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400     // Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3     = 0x400     // Bit CHTIF3.
	DMA_IFCR_CTEIF3_Pos = 0xb       // Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800     // Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3     = 0x800     // Bit CTEIF3.
	DMA_IFCR_CGIF4_Pos  = 0xc       // Position of CGIF4 field.
	DMA_IFCR_CGIF4_Msk  = 0x1000    // Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4      = 0x1000    // Bit CGIF4.
	DMA_IFCR_CTCIF4_Pos = 0xd       // Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000    // Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4     = 0x2000    // Bit CTCIF4.
	DMA_IFCR_CHTIF4_Pos = 0xe       // Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000    // Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4     = 0x4000    // Bit CHTIF4.
	DMA_IFCR_CTEIF4_Pos = 0xf       // Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000    // Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4     = 0x8000    // Bit CTEIF4.
	DMA_IFCR_CGIF5_Pos  = 0x10      // Position of CGIF5 field.
	DMA_IFCR_CGIF5_Msk  = 0x10000   // Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5      = 0x10000   // Bit CGIF5.
	DMA_IFCR_CTCIF5_Pos = 0x11      // Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000   // Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5     = 0x20000   // Bit CTCIF5.
	DMA_IFCR_CHTIF5_Pos = 0x12      // Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000   // Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5     = 0x40000   // Bit CHTIF5.
	DMA_IFCR_CTEIF5_Pos = 0x13      // Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000   // Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5     = 0x80000   // Bit CTEIF5.
	DMA_IFCR_CGIF6_Pos  = 0x14      // Position of CGIF6 field.
	DMA_IFCR_CGIF6_Msk  = 0x100000  // Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6      = 0x100000  // Bit CGIF6.
	DMA_IFCR_CTCIF6_Pos = 0x15      // Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000  // Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6     = 0x200000  // Bit CTCIF6.
	DMA_IFCR_CHTIF6_Pos = 0x16      // Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000  // Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6     = 0x400000  // Bit CHTIF6.
	DMA_IFCR_CTEIF6_Pos = 0x17      // Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000  // Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6     = 0x800000  // Bit CTEIF6.
	DMA_IFCR_CGIF7_Pos  = 0x18      // Position of CGIF7 field.
	DMA_IFCR_CGIF7_Msk  = 0x1000000 // Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7      = 0x1000000 // Bit CGIF7.
	DMA_IFCR_CTCIF7_Pos = 0x19      // Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000 // Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7     = 0x2000000 // Bit CTCIF7.
	DMA_IFCR_CHTIF7_Pos = 0x1a      // Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000 // Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7     = 0x4000000 // Bit CHTIF7.
	DMA_IFCR_CTEIF7_Pos = 0x1b      // Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000 // Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7     = 0x8000000 // Bit CTEIF7.

	// CCR1: DMA channel configuration register           (DMA_CCR)
	DMA_CCR1_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR1_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR1_EN          = 0x1    // Bit EN.
	DMA_CCR1_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR1_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR1_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR1_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR1_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR1_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR1_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR1_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR1_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR1_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR1_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR1_DIR         = 0x10   // Bit DIR.
	DMA_CCR1_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR1_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR1_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR1_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR1_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR1_PINC        = 0x40   // Bit PINC.
	DMA_CCR1_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR1_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR1_MINC        = 0x80   // Bit MINC.
	DMA_CCR1_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR1_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR1_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR1_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR1_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR1_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR1_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR1: DMA channel 1 number of data           register
	DMA_CNDTR1_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR1_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR1: DMA channel 1 peripheral address           register
	DMA_CPAR1_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR1: DMA channel 1 memory address           register
	DMA_CMAR1_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR2: DMA channel configuration register           (DMA_CCR)
	DMA_CCR2_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR2_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR2_EN          = 0x1    // Bit EN.
	DMA_CCR2_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR2_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR2_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR2_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR2_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR2_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR2_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR2_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR2_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR2_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR2_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR2_DIR         = 0x10   // Bit DIR.
	DMA_CCR2_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR2_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR2_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR2_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR2_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR2_PINC        = 0x40   // Bit PINC.
	DMA_CCR2_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR2_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR2_MINC        = 0x80   // Bit MINC.
	DMA_CCR2_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR2_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR2_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR2_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR2_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR2_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR2_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR2: DMA channel 2 number of data           register
	DMA_CNDTR2_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR2_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR2: DMA channel 2 peripheral address           register
	DMA_CPAR2_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR2: DMA channel 2 memory address           register
	DMA_CMAR2_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR3: DMA channel configuration register           (DMA_CCR)
	DMA_CCR3_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR3_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR3_EN          = 0x1    // Bit EN.
	DMA_CCR3_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR3_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR3_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR3_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR3_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR3_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR3_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR3_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR3_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR3_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR3_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR3_DIR         = 0x10   // Bit DIR.
	DMA_CCR3_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR3_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR3_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR3_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR3_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR3_PINC        = 0x40   // Bit PINC.
	DMA_CCR3_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR3_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR3_MINC        = 0x80   // Bit MINC.
	DMA_CCR3_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR3_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR3_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR3_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR3_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR3_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR3_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR3: DMA channel 3 number of data           register
	DMA_CNDTR3_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR3_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR3: DMA channel 3 peripheral address           register
	DMA_CPAR3_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR3: DMA channel 3 memory address           register
	DMA_CMAR3_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR4: DMA channel configuration register           (DMA_CCR)
	DMA_CCR4_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR4_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR4_EN          = 0x1    // Bit EN.
	DMA_CCR4_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR4_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR4_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR4_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR4_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR4_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR4_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR4_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR4_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR4_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR4_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR4_DIR         = 0x10   // Bit DIR.
	DMA_CCR4_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR4_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR4_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR4_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR4_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR4_PINC        = 0x40   // Bit PINC.
	DMA_CCR4_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR4_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR4_MINC        = 0x80   // Bit MINC.
	DMA_CCR4_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR4_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR4_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR4_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR4_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR4_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR4_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR4: DMA channel 4 number of data           register
	DMA_CNDTR4_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR4_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR4: DMA channel 4 peripheral address           register
	DMA_CPAR4_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR4: DMA channel 4 memory address           register
	DMA_CMAR4_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR5: DMA channel configuration register           (DMA_CCR)
	DMA_CCR5_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR5_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR5_EN          = 0x1    // Bit EN.
	DMA_CCR5_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR5_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR5_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR5_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR5_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR5_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR5_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR5_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR5_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR5_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR5_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR5_DIR         = 0x10   // Bit DIR.
	DMA_CCR5_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR5_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR5_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR5_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR5_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR5_PINC        = 0x40   // Bit PINC.
	DMA_CCR5_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR5_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR5_MINC        = 0x80   // Bit MINC.
	DMA_CCR5_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR5_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR5_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR5_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR5_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR5_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR5_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR5: DMA channel 5 number of data           register
	DMA_CNDTR5_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR5_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR5: DMA channel 5 peripheral address           register
	DMA_CPAR5_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR5: DMA channel 5 memory address           register
	DMA_CMAR5_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR6: DMA channel configuration register           (DMA_CCR)
	DMA_CCR6_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR6_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR6_EN          = 0x1    // Bit EN.
	DMA_CCR6_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR6_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR6_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR6_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR6_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR6_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR6_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR6_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR6_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR6_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR6_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR6_DIR         = 0x10   // Bit DIR.
	DMA_CCR6_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR6_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR6_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR6_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR6_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR6_PINC        = 0x40   // Bit PINC.
	DMA_CCR6_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR6_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR6_MINC        = 0x80   // Bit MINC.
	DMA_CCR6_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR6_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR6_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR6_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR6_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR6_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR6_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR6: DMA channel 6 number of data           register
	DMA_CNDTR6_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR6_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR6: DMA channel 6 peripheral address           register
	DMA_CPAR6_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR6: DMA channel 6 memory address           register
	DMA_CMAR6_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR7: DMA channel configuration register           (DMA_CCR)
	DMA_CCR7_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR7_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR7_EN          = 0x1    // Bit EN.
	DMA_CCR7_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR7_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR7_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR7_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR7_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR7_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR7_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR7_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR7_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR7_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR7_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR7_DIR         = 0x10   // Bit DIR.
	DMA_CCR7_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR7_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR7_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR7_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR7_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR7_PINC        = 0x40   // Bit PINC.
	DMA_CCR7_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR7_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR7_MINC        = 0x80   // Bit MINC.
	DMA_CCR7_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR7_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR7_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR7_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR7_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR7_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR7_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR7: DMA channel 7 number of data           register
	DMA_CNDTR7_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR7_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR7: DMA channel 7 peripheral address           register
	DMA_CPAR7_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR7: DMA channel 7 memory address           register
	DMA_CMAR7_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff // Bit mask of MA field.
)

// Bitfields for TIM2: General purpose timer
const (
	// CR1: control register 1
	TIMs_CR1_CEN_Pos      = 0x0   // Position of CEN field.
	TIMs_CR1_CEN_Msk      = 0x1   // Bit mask of CEN field.
	TIMs_CR1_CEN          = 0x1   // Bit CEN.
	TIMs_CR1_UDIS_Pos     = 0x1   // Position of UDIS field.
	TIMs_CR1_UDIS_Msk     = 0x2   // Bit mask of UDIS field.
	TIMs_CR1_UDIS         = 0x2   // Bit UDIS.
	TIMs_CR1_URS_Pos      = 0x2   // Position of URS field.
	TIMs_CR1_URS_Msk      = 0x4   // Bit mask of URS field.
	TIMs_CR1_URS          = 0x4   // Bit URS.
	TIMs_CR1_OPM_Pos      = 0x3   // Position of OPM field.
	TIMs_CR1_OPM_Msk      = 0x8   // Bit mask of OPM field.
	TIMs_CR1_OPM          = 0x8   // Bit OPM.
	TIMs_CR1_DIR_Pos      = 0x4   // Position of DIR field.
	TIMs_CR1_DIR_Msk      = 0x10  // Bit mask of DIR field.
	TIMs_CR1_DIR          = 0x10  // Bit DIR.
	TIMs_CR1_CMS_Pos      = 0x5   // Position of CMS field.
	TIMs_CR1_CMS_Msk      = 0x60  // Bit mask of CMS field.
	TIMs_CR1_ARPE_Pos     = 0x7   // Position of ARPE field.
	TIMs_CR1_ARPE_Msk     = 0x80  // Bit mask of ARPE field.
	TIMs_CR1_ARPE         = 0x80  // Bit ARPE.
	TIMs_CR1_CKD_Pos      = 0x8   // Position of CKD field.
	TIMs_CR1_CKD_Msk      = 0x300 // Bit mask of CKD field.
	TIMs_CR1_UIFREMAP_Pos = 0xb   // Position of UIFREMAP field.
	TIMs_CR1_UIFREMAP_Msk = 0x800 // Bit mask of UIFREMAP field.
	TIMs_CR1_UIFREMAP     = 0x800 // Bit UIFREMAP.

	// CR2: control register 2
	TIMs_CR2_TI1S_Pos = 0x7  // Position of TI1S field.
	TIMs_CR2_TI1S_Msk = 0x80 // Bit mask of TI1S field.
	TIMs_CR2_TI1S     = 0x80 // Bit TI1S.
	TIMs_CR2_MMS_Pos  = 0x4  // Position of MMS field.
	TIMs_CR2_MMS_Msk  = 0x70 // Bit mask of MMS field.
	TIMs_CR2_CCDS_Pos = 0x3  // Position of CCDS field.
	TIMs_CR2_CCDS_Msk = 0x8  // Bit mask of CCDS field.
	TIMs_CR2_CCDS     = 0x8  // Bit CCDS.

	// SMCR: slave mode control register
	TIMs_SMCR_SMS_Pos   = 0x0     // Position of SMS field.
	TIMs_SMCR_SMS_Msk   = 0x7     // Bit mask of SMS field.
	TIMs_SMCR_OCCS_Pos  = 0x3     // Position of OCCS field.
	TIMs_SMCR_OCCS_Msk  = 0x8     // Bit mask of OCCS field.
	TIMs_SMCR_OCCS      = 0x8     // Bit OCCS.
	TIMs_SMCR_TS_Pos    = 0x4     // Position of TS field.
	TIMs_SMCR_TS_Msk    = 0x70    // Bit mask of TS field.
	TIMs_SMCR_MSM_Pos   = 0x7     // Position of MSM field.
	TIMs_SMCR_MSM_Msk   = 0x80    // Bit mask of MSM field.
	TIMs_SMCR_MSM       = 0x80    // Bit MSM.
	TIMs_SMCR_ETF_Pos   = 0x8     // Position of ETF field.
	TIMs_SMCR_ETF_Msk   = 0xf00   // Bit mask of ETF field.
	TIMs_SMCR_ETPS_Pos  = 0xc     // Position of ETPS field.
	TIMs_SMCR_ETPS_Msk  = 0x3000  // Bit mask of ETPS field.
	TIMs_SMCR_ECE_Pos   = 0xe     // Position of ECE field.
	TIMs_SMCR_ECE_Msk   = 0x4000  // Bit mask of ECE field.
	TIMs_SMCR_ECE       = 0x4000  // Bit ECE.
	TIMs_SMCR_ETP_Pos   = 0xf     // Position of ETP field.
	TIMs_SMCR_ETP_Msk   = 0x8000  // Bit mask of ETP field.
	TIMs_SMCR_ETP       = 0x8000  // Bit ETP.
	TIMs_SMCR_SMS_3_Pos = 0x10    // Position of SMS_3 field.
	TIMs_SMCR_SMS_3_Msk = 0x10000 // Bit mask of SMS_3 field.
	TIMs_SMCR_SMS_3     = 0x10000 // Bit SMS_3.

	// DIER: DMA/Interrupt enable register
	TIMs_DIER_TDE_Pos   = 0xe    // Position of TDE field.
	TIMs_DIER_TDE_Msk   = 0x4000 // Bit mask of TDE field.
	TIMs_DIER_TDE       = 0x4000 // Bit TDE.
	TIMs_DIER_CC4DE_Pos = 0xc    // Position of CC4DE field.
	TIMs_DIER_CC4DE_Msk = 0x1000 // Bit mask of CC4DE field.
	TIMs_DIER_CC4DE     = 0x1000 // Bit CC4DE.
	TIMs_DIER_CC3DE_Pos = 0xb    // Position of CC3DE field.
	TIMs_DIER_CC3DE_Msk = 0x800  // Bit mask of CC3DE field.
	TIMs_DIER_CC3DE     = 0x800  // Bit CC3DE.
	TIMs_DIER_CC2DE_Pos = 0xa    // Position of CC2DE field.
	TIMs_DIER_CC2DE_Msk = 0x400  // Bit mask of CC2DE field.
	TIMs_DIER_CC2DE     = 0x400  // Bit CC2DE.
	TIMs_DIER_CC1DE_Pos = 0x9    // Position of CC1DE field.
	TIMs_DIER_CC1DE_Msk = 0x200  // Bit mask of CC1DE field.
	TIMs_DIER_CC1DE     = 0x200  // Bit CC1DE.
	TIMs_DIER_UDE_Pos   = 0x8    // Position of UDE field.
	TIMs_DIER_UDE_Msk   = 0x100  // Bit mask of UDE field.
	TIMs_DIER_UDE       = 0x100  // Bit UDE.
	TIMs_DIER_TIE_Pos   = 0x6    // Position of TIE field.
	TIMs_DIER_TIE_Msk   = 0x40   // Bit mask of TIE field.
	TIMs_DIER_TIE       = 0x40   // Bit TIE.
	TIMs_DIER_CC4IE_Pos = 0x4    // Position of CC4IE field.
	TIMs_DIER_CC4IE_Msk = 0x10   // Bit mask of CC4IE field.
	TIMs_DIER_CC4IE     = 0x10   // Bit CC4IE.
	TIMs_DIER_CC3IE_Pos = 0x3    // Position of CC3IE field.
	TIMs_DIER_CC3IE_Msk = 0x8    // Bit mask of CC3IE field.
	TIMs_DIER_CC3IE     = 0x8    // Bit CC3IE.
	TIMs_DIER_CC2IE_Pos = 0x2    // Position of CC2IE field.
	TIMs_DIER_CC2IE_Msk = 0x4    // Bit mask of CC2IE field.
	TIMs_DIER_CC2IE     = 0x4    // Bit CC2IE.
	TIMs_DIER_CC1IE_Pos = 0x1    // Position of CC1IE field.
	TIMs_DIER_CC1IE_Msk = 0x2    // Bit mask of CC1IE field.
	TIMs_DIER_CC1IE     = 0x2    // Bit CC1IE.
	TIMs_DIER_UIE_Pos   = 0x0    // Position of UIE field.
	TIMs_DIER_UIE_Msk   = 0x1    // Bit mask of UIE field.
	TIMs_DIER_UIE       = 0x1    // Bit UIE.

	// SR: status register
	TIMs_SR_CC4OF_Pos = 0xc    // Position of CC4OF field.
	TIMs_SR_CC4OF_Msk = 0x1000 // Bit mask of CC4OF field.
	TIMs_SR_CC4OF     = 0x1000 // Bit CC4OF.
	TIMs_SR_CC3OF_Pos = 0xb    // Position of CC3OF field.
	TIMs_SR_CC3OF_Msk = 0x800  // Bit mask of CC3OF field.
	TIMs_SR_CC3OF     = 0x800  // Bit CC3OF.
	TIMs_SR_CC2OF_Pos = 0xa    // Position of CC2OF field.
	TIMs_SR_CC2OF_Msk = 0x400  // Bit mask of CC2OF field.
	TIMs_SR_CC2OF     = 0x400  // Bit CC2OF.
	TIMs_SR_CC1OF_Pos = 0x9    // Position of CC1OF field.
	TIMs_SR_CC1OF_Msk = 0x200  // Bit mask of CC1OF field.
	TIMs_SR_CC1OF     = 0x200  // Bit CC1OF.
	TIMs_SR_TIF_Pos   = 0x6    // Position of TIF field.
	TIMs_SR_TIF_Msk   = 0x40   // Bit mask of TIF field.
	TIMs_SR_TIF       = 0x40   // Bit TIF.
	TIMs_SR_CC4IF_Pos = 0x4    // Position of CC4IF field.
	TIMs_SR_CC4IF_Msk = 0x10   // Bit mask of CC4IF field.
	TIMs_SR_CC4IF     = 0x10   // Bit CC4IF.
	TIMs_SR_CC3IF_Pos = 0x3    // Position of CC3IF field.
	TIMs_SR_CC3IF_Msk = 0x8    // Bit mask of CC3IF field.
	TIMs_SR_CC3IF     = 0x8    // Bit CC3IF.
	TIMs_SR_CC2IF_Pos = 0x2    // Position of CC2IF field.
	TIMs_SR_CC2IF_Msk = 0x4    // Bit mask of CC2IF field.
	TIMs_SR_CC2IF     = 0x4    // Bit CC2IF.
	TIMs_SR_CC1IF_Pos = 0x1    // Position of CC1IF field.
	TIMs_SR_CC1IF_Msk = 0x2    // Bit mask of CC1IF field.
	TIMs_SR_CC1IF     = 0x2    // Bit CC1IF.
	TIMs_SR_UIF_Pos   = 0x0    // Position of UIF field.
	TIMs_SR_UIF_Msk   = 0x1    // Bit mask of UIF field.
	TIMs_SR_UIF       = 0x1    // Bit UIF.

	// EGR: event generation register
	TIMs_EGR_TG_Pos   = 0x6  // Position of TG field.
	TIMs_EGR_TG_Msk   = 0x40 // Bit mask of TG field.
	TIMs_EGR_TG       = 0x40 // Bit TG.
	TIMs_EGR_CC4G_Pos = 0x4  // Position of CC4G field.
	TIMs_EGR_CC4G_Msk = 0x10 // Bit mask of CC4G field.
	TIMs_EGR_CC4G     = 0x10 // Bit CC4G.
	TIMs_EGR_CC3G_Pos = 0x3  // Position of CC3G field.
	TIMs_EGR_CC3G_Msk = 0x8  // Bit mask of CC3G field.
	TIMs_EGR_CC3G     = 0x8  // Bit CC3G.
	TIMs_EGR_CC2G_Pos = 0x2  // Position of CC2G field.
	TIMs_EGR_CC2G_Msk = 0x4  // Bit mask of CC2G field.
	TIMs_EGR_CC2G     = 0x4  // Bit CC2G.
	TIMs_EGR_CC1G_Pos = 0x1  // Position of CC1G field.
	TIMs_EGR_CC1G_Msk = 0x2  // Bit mask of CC1G field.
	TIMs_EGR_CC1G     = 0x2  // Bit CC1G.
	TIMs_EGR_UG_Pos   = 0x0  // Position of UG field.
	TIMs_EGR_UG_Msk   = 0x1  // Bit mask of UG field.
	TIMs_EGR_UG       = 0x1  // Bit UG.

	// CCMR1_Output: capture/compare mode register 1 (output           mode)
	TIMs_CCMR1_Output_CC1S_Pos   = 0x0       // Position of CC1S field.
	TIMs_CCMR1_Output_CC1S_Msk   = 0x3       // Bit mask of CC1S field.
	TIMs_CCMR1_Output_OC1FE_Pos  = 0x2       // Position of OC1FE field.
	TIMs_CCMR1_Output_OC1FE_Msk  = 0x4       // Bit mask of OC1FE field.
	TIMs_CCMR1_Output_OC1FE      = 0x4       // Bit OC1FE.
	TIMs_CCMR1_Output_OC1PE_Pos  = 0x3       // Position of OC1PE field.
	TIMs_CCMR1_Output_OC1PE_Msk  = 0x8       // Bit mask of OC1PE field.
	TIMs_CCMR1_Output_OC1PE      = 0x8       // Bit OC1PE.
	TIMs_CCMR1_Output_OC1M_Pos   = 0x4       // Position of OC1M field.
	TIMs_CCMR1_Output_OC1M_Msk   = 0x70      // Bit mask of OC1M field.
	TIMs_CCMR1_Output_OC1CE_Pos  = 0x7       // Position of OC1CE field.
	TIMs_CCMR1_Output_OC1CE_Msk  = 0x80      // Bit mask of OC1CE field.
	TIMs_CCMR1_Output_OC1CE      = 0x80      // Bit OC1CE.
	TIMs_CCMR1_Output_CC2S_Pos   = 0x8       // Position of CC2S field.
	TIMs_CCMR1_Output_CC2S_Msk   = 0x300     // Bit mask of CC2S field.
	TIMs_CCMR1_Output_OC2FE_Pos  = 0xa       // Position of OC2FE field.
	TIMs_CCMR1_Output_OC2FE_Msk  = 0x400     // Bit mask of OC2FE field.
	TIMs_CCMR1_Output_OC2FE      = 0x400     // Bit OC2FE.
	TIMs_CCMR1_Output_OC2PE_Pos  = 0xb       // Position of OC2PE field.
	TIMs_CCMR1_Output_OC2PE_Msk  = 0x800     // Bit mask of OC2PE field.
	TIMs_CCMR1_Output_OC2PE      = 0x800     // Bit OC2PE.
	TIMs_CCMR1_Output_OC2M_Pos   = 0xc       // Position of OC2M field.
	TIMs_CCMR1_Output_OC2M_Msk   = 0x7000    // Bit mask of OC2M field.
	TIMs_CCMR1_Output_OC2CE_Pos  = 0xf       // Position of OC2CE field.
	TIMs_CCMR1_Output_OC2CE_Msk  = 0x8000    // Bit mask of OC2CE field.
	TIMs_CCMR1_Output_OC2CE      = 0x8000    // Bit OC2CE.
	TIMs_CCMR1_Output_OC1M_3_Pos = 0x10      // Position of OC1M_3 field.
	TIMs_CCMR1_Output_OC1M_3_Msk = 0x10000   // Bit mask of OC1M_3 field.
	TIMs_CCMR1_Output_OC1M_3     = 0x10000   // Bit OC1M_3.
	TIMs_CCMR1_Output_OC2M_3_Pos = 0x18      // Position of OC2M_3 field.
	TIMs_CCMR1_Output_OC2M_3_Msk = 0x1000000 // Bit mask of OC2M_3 field.
	TIMs_CCMR1_Output_OC2M_3     = 0x1000000 // Bit OC2M_3.

	// CCMR1_Input: capture/compare mode register 1 (input           mode)
	TIMs_CCMR1_Input_IC2F_Pos   = 0xc    // Position of IC2F field.
	TIMs_CCMR1_Input_IC2F_Msk   = 0xf000 // Bit mask of IC2F field.
	TIMs_CCMR1_Input_IC2PSC_Pos = 0xa    // Position of IC2PSC field.
	TIMs_CCMR1_Input_IC2PSC_Msk = 0xc00  // Bit mask of IC2PSC field.
	TIMs_CCMR1_Input_CC2S_Pos   = 0x8    // Position of CC2S field.
	TIMs_CCMR1_Input_CC2S_Msk   = 0x300  // Bit mask of CC2S field.
	TIMs_CCMR1_Input_IC1F_Pos   = 0x4    // Position of IC1F field.
	TIMs_CCMR1_Input_IC1F_Msk   = 0xf0   // Bit mask of IC1F field.
	TIMs_CCMR1_Input_IC1PSC_Pos = 0x2    // Position of IC1PSC field.
	TIMs_CCMR1_Input_IC1PSC_Msk = 0xc    // Bit mask of IC1PSC field.
	TIMs_CCMR1_Input_CC1S_Pos   = 0x0    // Position of CC1S field.
	TIMs_CCMR1_Input_CC1S_Msk   = 0x3    // Bit mask of CC1S field.

	// CCMR2_Output: capture/compare mode register 2 (output           mode)
	TIMs_CCMR2_Output_CC3S_Pos   = 0x0       // Position of CC3S field.
	TIMs_CCMR2_Output_CC3S_Msk   = 0x3       // Bit mask of CC3S field.
	TIMs_CCMR2_Output_OC3FE_Pos  = 0x2       // Position of OC3FE field.
	TIMs_CCMR2_Output_OC3FE_Msk  = 0x4       // Bit mask of OC3FE field.
	TIMs_CCMR2_Output_OC3FE      = 0x4       // Bit OC3FE.
	TIMs_CCMR2_Output_OC3PE_Pos  = 0x3       // Position of OC3PE field.
	TIMs_CCMR2_Output_OC3PE_Msk  = 0x8       // Bit mask of OC3PE field.
	TIMs_CCMR2_Output_OC3PE      = 0x8       // Bit OC3PE.
	TIMs_CCMR2_Output_OC3M_Pos   = 0x4       // Position of OC3M field.
	TIMs_CCMR2_Output_OC3M_Msk   = 0x70      // Bit mask of OC3M field.
	TIMs_CCMR2_Output_OC3CE_Pos  = 0x7       // Position of OC3CE field.
	TIMs_CCMR2_Output_OC3CE_Msk  = 0x80      // Bit mask of OC3CE field.
	TIMs_CCMR2_Output_OC3CE      = 0x80      // Bit OC3CE.
	TIMs_CCMR2_Output_CC4S_Pos   = 0x8       // Position of CC4S field.
	TIMs_CCMR2_Output_CC4S_Msk   = 0x300     // Bit mask of CC4S field.
	TIMs_CCMR2_Output_OC4FE_Pos  = 0xa       // Position of OC4FE field.
	TIMs_CCMR2_Output_OC4FE_Msk  = 0x400     // Bit mask of OC4FE field.
	TIMs_CCMR2_Output_OC4FE      = 0x400     // Bit OC4FE.
	TIMs_CCMR2_Output_OC4PE_Pos  = 0xb       // Position of OC4PE field.
	TIMs_CCMR2_Output_OC4PE_Msk  = 0x800     // Bit mask of OC4PE field.
	TIMs_CCMR2_Output_OC4PE      = 0x800     // Bit OC4PE.
	TIMs_CCMR2_Output_OC4M_Pos   = 0xc       // Position of OC4M field.
	TIMs_CCMR2_Output_OC4M_Msk   = 0x7000    // Bit mask of OC4M field.
	TIMs_CCMR2_Output_O24CE_Pos  = 0xf       // Position of O24CE field.
	TIMs_CCMR2_Output_O24CE_Msk  = 0x8000    // Bit mask of O24CE field.
	TIMs_CCMR2_Output_O24CE      = 0x8000    // Bit O24CE.
	TIMs_CCMR2_Output_OC3M_3_Pos = 0x10      // Position of OC3M_3 field.
	TIMs_CCMR2_Output_OC3M_3_Msk = 0x10000   // Bit mask of OC3M_3 field.
	TIMs_CCMR2_Output_OC3M_3     = 0x10000   // Bit OC3M_3.
	TIMs_CCMR2_Output_OC4M_3_Pos = 0x18      // Position of OC4M_3 field.
	TIMs_CCMR2_Output_OC4M_3_Msk = 0x1000000 // Bit mask of OC4M_3 field.
	TIMs_CCMR2_Output_OC4M_3     = 0x1000000 // Bit OC4M_3.

	// CCMR2_Input: capture/compare mode register 2 (input           mode)
	TIMs_CCMR2_Input_IC4F_Pos   = 0xc    // Position of IC4F field.
	TIMs_CCMR2_Input_IC4F_Msk   = 0xf000 // Bit mask of IC4F field.
	TIMs_CCMR2_Input_IC4PSC_Pos = 0xa    // Position of IC4PSC field.
	TIMs_CCMR2_Input_IC4PSC_Msk = 0xc00  // Bit mask of IC4PSC field.
	TIMs_CCMR2_Input_CC4S_Pos   = 0x8    // Position of CC4S field.
	TIMs_CCMR2_Input_CC4S_Msk   = 0x300  // Bit mask of CC4S field.
	TIMs_CCMR2_Input_IC3F_Pos   = 0x4    // Position of IC3F field.
	TIMs_CCMR2_Input_IC3F_Msk   = 0xf0   // Bit mask of IC3F field.
	TIMs_CCMR2_Input_IC3PSC_Pos = 0x2    // Position of IC3PSC field.
	TIMs_CCMR2_Input_IC3PSC_Msk = 0xc    // Bit mask of IC3PSC field.
	TIMs_CCMR2_Input_CC3S_Pos   = 0x0    // Position of CC3S field.
	TIMs_CCMR2_Input_CC3S_Msk   = 0x3    // Bit mask of CC3S field.

	// CCER: capture/compare enable           register
	TIMs_CCER_CC1E_Pos  = 0x0    // Position of CC1E field.
	TIMs_CCER_CC1E_Msk  = 0x1    // Bit mask of CC1E field.
	TIMs_CCER_CC1E      = 0x1    // Bit CC1E.
	TIMs_CCER_CC1P_Pos  = 0x1    // Position of CC1P field.
	TIMs_CCER_CC1P_Msk  = 0x2    // Bit mask of CC1P field.
	TIMs_CCER_CC1P      = 0x2    // Bit CC1P.
	TIMs_CCER_CC1NP_Pos = 0x3    // Position of CC1NP field.
	TIMs_CCER_CC1NP_Msk = 0x8    // Bit mask of CC1NP field.
	TIMs_CCER_CC1NP     = 0x8    // Bit CC1NP.
	TIMs_CCER_CC2E_Pos  = 0x4    // Position of CC2E field.
	TIMs_CCER_CC2E_Msk  = 0x10   // Bit mask of CC2E field.
	TIMs_CCER_CC2E      = 0x10   // Bit CC2E.
	TIMs_CCER_CC2P_Pos  = 0x5    // Position of CC2P field.
	TIMs_CCER_CC2P_Msk  = 0x20   // Bit mask of CC2P field.
	TIMs_CCER_CC2P      = 0x20   // Bit CC2P.
	TIMs_CCER_CC2NP_Pos = 0x7    // Position of CC2NP field.
	TIMs_CCER_CC2NP_Msk = 0x80   // Bit mask of CC2NP field.
	TIMs_CCER_CC2NP     = 0x80   // Bit CC2NP.
	TIMs_CCER_CC3E_Pos  = 0x8    // Position of CC3E field.
	TIMs_CCER_CC3E_Msk  = 0x100  // Bit mask of CC3E field.
	TIMs_CCER_CC3E      = 0x100  // Bit CC3E.
	TIMs_CCER_CC3P_Pos  = 0x9    // Position of CC3P field.
	TIMs_CCER_CC3P_Msk  = 0x200  // Bit mask of CC3P field.
	TIMs_CCER_CC3P      = 0x200  // Bit CC3P.
	TIMs_CCER_CC3NP_Pos = 0xb    // Position of CC3NP field.
	TIMs_CCER_CC3NP_Msk = 0x800  // Bit mask of CC3NP field.
	TIMs_CCER_CC3NP     = 0x800  // Bit CC3NP.
	TIMs_CCER_CC4E_Pos  = 0xc    // Position of CC4E field.
	TIMs_CCER_CC4E_Msk  = 0x1000 // Bit mask of CC4E field.
	TIMs_CCER_CC4E      = 0x1000 // Bit CC4E.
	TIMs_CCER_CC4P_Pos  = 0xd    // Position of CC4P field.
	TIMs_CCER_CC4P_Msk  = 0x2000 // Bit mask of CC4P field.
	TIMs_CCER_CC4P      = 0x2000 // Bit CC4P.
	TIMs_CCER_CC4NP_Pos = 0xf    // Position of CC4NP field.
	TIMs_CCER_CC4NP_Msk = 0x8000 // Bit mask of CC4NP field.
	TIMs_CCER_CC4NP     = 0x8000 // Bit CC4NP.

	// CNT: counter
	TIMs_CNT_CNTL_Pos          = 0x0        // Position of CNTL field.
	TIMs_CNT_CNTL_Msk          = 0xffff     // Bit mask of CNTL field.
	TIMs_CNT_CNTH_Pos          = 0x10       // Position of CNTH field.
	TIMs_CNT_CNTH_Msk          = 0x7fff0000 // Bit mask of CNTH field.
	TIMs_CNT_CNT_or_UIFCPY_Pos = 0x1f       // Position of CNT_or_UIFCPY field.
	TIMs_CNT_CNT_or_UIFCPY_Msk = 0x80000000 // Bit mask of CNT_or_UIFCPY field.
	TIMs_CNT_CNT_or_UIFCPY     = 0x80000000 // Bit CNT_or_UIFCPY.

	// PSC: prescaler
	TIMs_PSC_PSC_Pos = 0x0    // Position of PSC field.
	TIMs_PSC_PSC_Msk = 0xffff // Bit mask of PSC field.

	// ARR: auto-reload register
	TIMs_ARR_ARRL_Pos = 0x0        // Position of ARRL field.
	TIMs_ARR_ARRL_Msk = 0xffff     // Bit mask of ARRL field.
	TIMs_ARR_ARRH_Pos = 0x10       // Position of ARRH field.
	TIMs_ARR_ARRH_Msk = 0xffff0000 // Bit mask of ARRH field.

	// CCR1: capture/compare register 1
	TIMs_CCR1_CCR1L_Pos = 0x0        // Position of CCR1L field.
	TIMs_CCR1_CCR1L_Msk = 0xffff     // Bit mask of CCR1L field.
	TIMs_CCR1_CCR1H_Pos = 0x10       // Position of CCR1H field.
	TIMs_CCR1_CCR1H_Msk = 0xffff0000 // Bit mask of CCR1H field.

	// CCR2: capture/compare register 2
	TIMs_CCR2_CCR2L_Pos = 0x0        // Position of CCR2L field.
	TIMs_CCR2_CCR2L_Msk = 0xffff     // Bit mask of CCR2L field.
	TIMs_CCR2_CCR2H_Pos = 0x10       // Position of CCR2H field.
	TIMs_CCR2_CCR2H_Msk = 0xffff0000 // Bit mask of CCR2H field.

	// CCR3: capture/compare register 3
	TIMs_CCR3_CCR3L_Pos = 0x0        // Position of CCR3L field.
	TIMs_CCR3_CCR3L_Msk = 0xffff     // Bit mask of CCR3L field.
	TIMs_CCR3_CCR3H_Pos = 0x10       // Position of CCR3H field.
	TIMs_CCR3_CCR3H_Msk = 0xffff0000 // Bit mask of CCR3H field.

	// CCR4: capture/compare register 4
	TIMs_CCR4_CCR4L_Pos = 0x0        // Position of CCR4L field.
	TIMs_CCR4_CCR4L_Msk = 0xffff     // Bit mask of CCR4L field.
	TIMs_CCR4_CCR4H_Pos = 0x10       // Position of CCR4H field.
	TIMs_CCR4_CCR4H_Msk = 0xffff0000 // Bit mask of CCR4H field.

	// DCR: DMA control register
	TIMs_DCR_DBL_Pos = 0x8    // Position of DBL field.
	TIMs_DCR_DBL_Msk = 0x1f00 // Bit mask of DBL field.
	TIMs_DCR_DBA_Pos = 0x0    // Position of DBA field.
	TIMs_DCR_DBA_Msk = 0x1f   // Bit mask of DBA field.

	// DMAR: DMA address for full transfer
	TIMs_DMAR_DMAB_Pos = 0x0    // Position of DMAB field.
	TIMs_DMAR_DMAB_Msk = 0xffff // Bit mask of DMAB field.
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	USART_CR1_EOBIE_Pos  = 0x1b      // Position of EOBIE field.
	USART_CR1_EOBIE_Msk  = 0x8000000 // Bit mask of EOBIE field.
	USART_CR1_EOBIE      = 0x8000000 // Bit EOBIE.
	USART_CR1_RTOIE_Pos  = 0x1a      // Position of RTOIE field.
	USART_CR1_RTOIE_Msk  = 0x4000000 // Bit mask of RTOIE field.
	USART_CR1_RTOIE      = 0x4000000 // Bit RTOIE.
	USART_CR1_DEAT_Pos   = 0x15      // Position of DEAT field.
	USART_CR1_DEAT_Msk   = 0x3e00000 // Bit mask of DEAT field.
	USART_CR1_DEDT_Pos   = 0x10      // Position of DEDT field.
	USART_CR1_DEDT_Msk   = 0x1f0000  // Bit mask of DEDT field.
	USART_CR1_OVER8_Pos  = 0xf       // Position of OVER8 field.
	USART_CR1_OVER8_Msk  = 0x8000    // Bit mask of OVER8 field.
	USART_CR1_OVER8      = 0x8000    // Bit OVER8.
	USART_CR1_CMIE_Pos   = 0xe       // Position of CMIE field.
	USART_CR1_CMIE_Msk   = 0x4000    // Bit mask of CMIE field.
	USART_CR1_CMIE       = 0x4000    // Bit CMIE.
	USART_CR1_MME_Pos    = 0xd       // Position of MME field.
	USART_CR1_MME_Msk    = 0x2000    // Bit mask of MME field.
	USART_CR1_MME        = 0x2000    // Bit MME.
	USART_CR1_M_Pos      = 0xc       // Position of M field.
	USART_CR1_M_Msk      = 0x1000    // Bit mask of M field.
	USART_CR1_M          = 0x1000    // Bit M.
	USART_CR1_WAKE_Pos   = 0xb       // Position of WAKE field.
	USART_CR1_WAKE_Msk   = 0x800     // Bit mask of WAKE field.
	USART_CR1_WAKE       = 0x800     // Bit WAKE.
	USART_CR1_PCE_Pos    = 0xa       // Position of PCE field.
	USART_CR1_PCE_Msk    = 0x400     // Bit mask of PCE field.
	USART_CR1_PCE        = 0x400     // Bit PCE.
	USART_CR1_PS_Pos     = 0x9       // Position of PS field.
	USART_CR1_PS_Msk     = 0x200     // Bit mask of PS field.
	USART_CR1_PS         = 0x200     // Bit PS.
	USART_CR1_PEIE_Pos   = 0x8       // Position of PEIE field.
	USART_CR1_PEIE_Msk   = 0x100     // Bit mask of PEIE field.
	USART_CR1_PEIE       = 0x100     // Bit PEIE.
	USART_CR1_TXEIE_Pos  = 0x7       // Position of TXEIE field.
	USART_CR1_TXEIE_Msk  = 0x80      // Bit mask of TXEIE field.
	USART_CR1_TXEIE      = 0x80      // Bit TXEIE.
	USART_CR1_TCIE_Pos   = 0x6       // Position of TCIE field.
	USART_CR1_TCIE_Msk   = 0x40      // Bit mask of TCIE field.
	USART_CR1_TCIE       = 0x40      // Bit TCIE.
	USART_CR1_RXNEIE_Pos = 0x5       // Position of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20      // Bit mask of RXNEIE field.
	USART_CR1_RXNEIE     = 0x20      // Bit RXNEIE.
	USART_CR1_IDLEIE_Pos = 0x4       // Position of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10      // Bit mask of IDLEIE field.
	USART_CR1_IDLEIE     = 0x10      // Bit IDLEIE.
	USART_CR1_TE_Pos     = 0x3       // Position of TE field.
	USART_CR1_TE_Msk     = 0x8       // Bit mask of TE field.
	USART_CR1_TE         = 0x8       // Bit TE.
	USART_CR1_RE_Pos     = 0x2       // Position of RE field.
	USART_CR1_RE_Msk     = 0x4       // Bit mask of RE field.
	USART_CR1_RE         = 0x4       // Bit RE.
	USART_CR1_UESM_Pos   = 0x1       // Position of UESM field.
	USART_CR1_UESM_Msk   = 0x2       // Bit mask of UESM field.
	USART_CR1_UESM       = 0x2       // Bit UESM.
	USART_CR1_UE_Pos     = 0x0       // Position of UE field.
	USART_CR1_UE_Msk     = 0x1       // Bit mask of UE field.
	USART_CR1_UE         = 0x1       // Bit UE.

	// CR2: Control register 2
	USART_CR2_ADD4_Pos     = 0x1c       // Position of ADD4 field.
	USART_CR2_ADD4_Msk     = 0xf0000000 // Bit mask of ADD4 field.
	USART_CR2_ADD0_Pos     = 0x18       // Position of ADD0 field.
	USART_CR2_ADD0_Msk     = 0xf000000  // Bit mask of ADD0 field.
	USART_CR2_RTOEN_Pos    = 0x17       // Position of RTOEN field.
	USART_CR2_RTOEN_Msk    = 0x800000   // Bit mask of RTOEN field.
	USART_CR2_RTOEN        = 0x800000   // Bit RTOEN.
	USART_CR2_ABRMOD_Pos   = 0x15       // Position of ABRMOD field.
	USART_CR2_ABRMOD_Msk   = 0x600000   // Bit mask of ABRMOD field.
	USART_CR2_ABREN_Pos    = 0x14       // Position of ABREN field.
	USART_CR2_ABREN_Msk    = 0x100000   // Bit mask of ABREN field.
	USART_CR2_ABREN        = 0x100000   // Bit ABREN.
	USART_CR2_MSBFIRST_Pos = 0x13       // Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000    // Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST     = 0x80000    // Bit MSBFIRST.
	USART_CR2_DATAINV_Pos  = 0x12       // Position of DATAINV field.
	USART_CR2_DATAINV_Msk  = 0x40000    // Bit mask of DATAINV field.
	USART_CR2_DATAINV      = 0x40000    // Bit DATAINV.
	USART_CR2_TXINV_Pos    = 0x11       // Position of TXINV field.
	USART_CR2_TXINV_Msk    = 0x20000    // Bit mask of TXINV field.
	USART_CR2_TXINV        = 0x20000    // Bit TXINV.
	USART_CR2_RXINV_Pos    = 0x10       // Position of RXINV field.
	USART_CR2_RXINV_Msk    = 0x10000    // Bit mask of RXINV field.
	USART_CR2_RXINV        = 0x10000    // Bit RXINV.
	USART_CR2_SWAP_Pos     = 0xf        // Position of SWAP field.
	USART_CR2_SWAP_Msk     = 0x8000     // Bit mask of SWAP field.
	USART_CR2_SWAP         = 0x8000     // Bit SWAP.
	USART_CR2_LINEN_Pos    = 0xe        // Position of LINEN field.
	USART_CR2_LINEN_Msk    = 0x4000     // Bit mask of LINEN field.
	USART_CR2_LINEN        = 0x4000     // Bit LINEN.
	USART_CR2_STOP_Pos     = 0xc        // Position of STOP field.
	USART_CR2_STOP_Msk     = 0x3000     // Bit mask of STOP field.
	USART_CR2_CLKEN_Pos    = 0xb        // Position of CLKEN field.
	USART_CR2_CLKEN_Msk    = 0x800      // Bit mask of CLKEN field.
	USART_CR2_CLKEN        = 0x800      // Bit CLKEN.
	USART_CR2_CPOL_Pos     = 0xa        // Position of CPOL field.
	USART_CR2_CPOL_Msk     = 0x400      // Bit mask of CPOL field.
	USART_CR2_CPOL         = 0x400      // Bit CPOL.
	USART_CR2_CPHA_Pos     = 0x9        // Position of CPHA field.
	USART_CR2_CPHA_Msk     = 0x200      // Bit mask of CPHA field.
	USART_CR2_CPHA         = 0x200      // Bit CPHA.
	USART_CR2_LBCL_Pos     = 0x8        // Position of LBCL field.
	USART_CR2_LBCL_Msk     = 0x100      // Bit mask of LBCL field.
	USART_CR2_LBCL         = 0x100      // Bit LBCL.
	USART_CR2_LBDIE_Pos    = 0x6        // Position of LBDIE field.
	USART_CR2_LBDIE_Msk    = 0x40       // Bit mask of LBDIE field.
	USART_CR2_LBDIE        = 0x40       // Bit LBDIE.
	USART_CR2_LBDL_Pos     = 0x5        // Position of LBDL field.
	USART_CR2_LBDL_Msk     = 0x20       // Bit mask of LBDL field.
	USART_CR2_LBDL         = 0x20       // Bit LBDL.
	USART_CR2_ADDM7_Pos    = 0x4        // Position of ADDM7 field.
	USART_CR2_ADDM7_Msk    = 0x10       // Bit mask of ADDM7 field.
	USART_CR2_ADDM7        = 0x10       // Bit ADDM7.

	// CR3: Control register 3
	USART_CR3_WUFIE_Pos   = 0x16     // Position of WUFIE field.
	USART_CR3_WUFIE_Msk   = 0x400000 // Bit mask of WUFIE field.
	USART_CR3_WUFIE       = 0x400000 // Bit WUFIE.
	USART_CR3_WUS_Pos     = 0x14     // Position of WUS field.
	USART_CR3_WUS_Msk     = 0x300000 // Bit mask of WUS field.
	USART_CR3_SCARCNT_Pos = 0x11     // Position of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000  // Bit mask of SCARCNT field.
	USART_CR3_DEP_Pos     = 0xf      // Position of DEP field.
	USART_CR3_DEP_Msk     = 0x8000   // Bit mask of DEP field.
	USART_CR3_DEP         = 0x8000   // Bit DEP.
	USART_CR3_DEM_Pos     = 0xe      // Position of DEM field.
	USART_CR3_DEM_Msk     = 0x4000   // Bit mask of DEM field.
	USART_CR3_DEM         = 0x4000   // Bit DEM.
	USART_CR3_DDRE_Pos    = 0xd      // Position of DDRE field.
	USART_CR3_DDRE_Msk    = 0x2000   // Bit mask of DDRE field.
	USART_CR3_DDRE        = 0x2000   // Bit DDRE.
	USART_CR3_OVRDIS_Pos  = 0xc      // Position of OVRDIS field.
	USART_CR3_OVRDIS_Msk  = 0x1000   // Bit mask of OVRDIS field.
	USART_CR3_OVRDIS      = 0x1000   // Bit OVRDIS.
	USART_CR3_ONEBIT_Pos  = 0xb      // Position of ONEBIT field.
	USART_CR3_ONEBIT_Msk  = 0x800    // Bit mask of ONEBIT field.
	USART_CR3_ONEBIT      = 0x800    // Bit ONEBIT.
	USART_CR3_CTSIE_Pos   = 0xa      // Position of CTSIE field.
	USART_CR3_CTSIE_Msk   = 0x400    // Bit mask of CTSIE field.
	USART_CR3_CTSIE       = 0x400    // Bit CTSIE.
	USART_CR3_CTSE_Pos    = 0x9      // Position of CTSE field.
	USART_CR3_CTSE_Msk    = 0x200    // Bit mask of CTSE field.
	USART_CR3_CTSE        = 0x200    // Bit CTSE.
	USART_CR3_RTSE_Pos    = 0x8      // Position of RTSE field.
	USART_CR3_RTSE_Msk    = 0x100    // Bit mask of RTSE field.
	USART_CR3_RTSE        = 0x100    // Bit RTSE.
	USART_CR3_DMAT_Pos    = 0x7      // Position of DMAT field.
	USART_CR3_DMAT_Msk    = 0x80     // Bit mask of DMAT field.
	USART_CR3_DMAT        = 0x80     // Bit DMAT.
	USART_CR3_DMAR_Pos    = 0x6      // Position of DMAR field.
	USART_CR3_DMAR_Msk    = 0x40     // Bit mask of DMAR field.
	USART_CR3_DMAR        = 0x40     // Bit DMAR.
	USART_CR3_SCEN_Pos    = 0x5      // Position of SCEN field.
	USART_CR3_SCEN_Msk    = 0x20     // Bit mask of SCEN field.
	USART_CR3_SCEN        = 0x20     // Bit SCEN.
	USART_CR3_NACK_Pos    = 0x4      // Position of NACK field.
	USART_CR3_NACK_Msk    = 0x10     // Bit mask of NACK field.
	USART_CR3_NACK        = 0x10     // Bit NACK.
	USART_CR3_HDSEL_Pos   = 0x3      // Position of HDSEL field.
	USART_CR3_HDSEL_Msk   = 0x8      // Bit mask of HDSEL field.
	USART_CR3_HDSEL       = 0x8      // Bit HDSEL.
	USART_CR3_IRLP_Pos    = 0x2      // Position of IRLP field.
	USART_CR3_IRLP_Msk    = 0x4      // Bit mask of IRLP field.
	USART_CR3_IRLP        = 0x4      // Bit IRLP.
	USART_CR3_IREN_Pos    = 0x1      // Position of IREN field.
	USART_CR3_IREN_Msk    = 0x2      // Bit mask of IREN field.
	USART_CR3_IREN        = 0x2      // Bit IREN.
	USART_CR3_EIE_Pos     = 0x0      // Position of EIE field.
	USART_CR3_EIE_Msk     = 0x1      // Bit mask of EIE field.
	USART_CR3_EIE         = 0x1      // Bit EIE.

	// BRR: Baud rate register
	USART_BRR_DIV_Mantissa_Pos = 0x4    // Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0 // Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Fraction_Pos = 0x0    // Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf    // Bit mask of DIV_Fraction field.

	// GTPR: Guard time and prescaler           register
	USART_GTPR_GT_Pos  = 0x8    // Position of GT field.
	USART_GTPR_GT_Msk  = 0xff00 // Bit mask of GT field.
	USART_GTPR_PSC_Pos = 0x0    // Position of PSC field.
	USART_GTPR_PSC_Msk = 0xff   // Bit mask of PSC field.

	// RTOR: Receiver timeout register
	USART_RTOR_BLEN_Pos = 0x18       // Position of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000 // Bit mask of BLEN field.
	USART_RTOR_RTO_Pos  = 0x0        // Position of RTO field.
	USART_RTOR_RTO_Msk  = 0xffffff   // Bit mask of RTO field.

	// RQR: Request register
	USART_RQR_TXFRQ_Pos = 0x4  // Position of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10 // Bit mask of TXFRQ field.
	USART_RQR_TXFRQ     = 0x10 // Bit TXFRQ.
	USART_RQR_RXFRQ_Pos = 0x3  // Position of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8  // Bit mask of RXFRQ field.
	USART_RQR_RXFRQ     = 0x8  // Bit RXFRQ.
	USART_RQR_MMRQ_Pos  = 0x2  // Position of MMRQ field.
	USART_RQR_MMRQ_Msk  = 0x4  // Bit mask of MMRQ field.
	USART_RQR_MMRQ      = 0x4  // Bit MMRQ.
	USART_RQR_SBKRQ_Pos = 0x1  // Position of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2  // Bit mask of SBKRQ field.
	USART_RQR_SBKRQ     = 0x2  // Bit SBKRQ.
	USART_RQR_ABRRQ_Pos = 0x0  // Position of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1  // Bit mask of ABRRQ field.
	USART_RQR_ABRRQ     = 0x1  // Bit ABRRQ.

	// ISR: Interrupt & status           register
	USART_ISR_REACK_Pos = 0x16     // Position of REACK field.
	USART_ISR_REACK_Msk = 0x400000 // Bit mask of REACK field.
	USART_ISR_REACK     = 0x400000 // Bit REACK.
	USART_ISR_TEACK_Pos = 0x15     // Position of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000 // Bit mask of TEACK field.
	USART_ISR_TEACK     = 0x200000 // Bit TEACK.
	USART_ISR_WUF_Pos   = 0x14     // Position of WUF field.
	USART_ISR_WUF_Msk   = 0x100000 // Bit mask of WUF field.
	USART_ISR_WUF       = 0x100000 // Bit WUF.
	USART_ISR_RWU_Pos   = 0x13     // Position of RWU field.
	USART_ISR_RWU_Msk   = 0x80000  // Bit mask of RWU field.
	USART_ISR_RWU       = 0x80000  // Bit RWU.
	USART_ISR_SBKF_Pos  = 0x12     // Position of SBKF field.
	USART_ISR_SBKF_Msk  = 0x40000  // Bit mask of SBKF field.
	USART_ISR_SBKF      = 0x40000  // Bit SBKF.
	USART_ISR_CMF_Pos   = 0x11     // Position of CMF field.
	USART_ISR_CMF_Msk   = 0x20000  // Bit mask of CMF field.
	USART_ISR_CMF       = 0x20000  // Bit CMF.
	USART_ISR_BUSY_Pos  = 0x10     // Position of BUSY field.
	USART_ISR_BUSY_Msk  = 0x10000  // Bit mask of BUSY field.
	USART_ISR_BUSY      = 0x10000  // Bit BUSY.
	USART_ISR_ABRF_Pos  = 0xf      // Position of ABRF field.
	USART_ISR_ABRF_Msk  = 0x8000   // Bit mask of ABRF field.
	USART_ISR_ABRF      = 0x8000   // Bit ABRF.
	USART_ISR_ABRE_Pos  = 0xe      // Position of ABRE field.
	USART_ISR_ABRE_Msk  = 0x4000   // Bit mask of ABRE field.
	USART_ISR_ABRE      = 0x4000   // Bit ABRE.
	USART_ISR_EOBF_Pos  = 0xc      // Position of EOBF field.
	USART_ISR_EOBF_Msk  = 0x1000   // Bit mask of EOBF field.
	USART_ISR_EOBF      = 0x1000   // Bit EOBF.
	USART_ISR_RTOF_Pos  = 0xb      // Position of RTOF field.
	USART_ISR_RTOF_Msk  = 0x800    // Bit mask of RTOF field.
	USART_ISR_RTOF      = 0x800    // Bit RTOF.
	USART_ISR_CTS_Pos   = 0xa      // Position of CTS field.
	USART_ISR_CTS_Msk   = 0x400    // Bit mask of CTS field.
	USART_ISR_CTS       = 0x400    // Bit CTS.
	USART_ISR_CTSIF_Pos = 0x9      // Position of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200    // Bit mask of CTSIF field.
	USART_ISR_CTSIF     = 0x200    // Bit CTSIF.
	USART_ISR_LBDF_Pos  = 0x8      // Position of LBDF field.
	USART_ISR_LBDF_Msk  = 0x100    // Bit mask of LBDF field.
	USART_ISR_LBDF      = 0x100    // Bit LBDF.
	USART_ISR_TXE_Pos   = 0x7      // Position of TXE field.
	USART_ISR_TXE_Msk   = 0x80     // Bit mask of TXE field.
	USART_ISR_TXE       = 0x80     // Bit TXE.
	USART_ISR_TC_Pos    = 0x6      // Position of TC field.
	USART_ISR_TC_Msk    = 0x40     // Bit mask of TC field.
	USART_ISR_TC        = 0x40     // Bit TC.
	USART_ISR_RXNE_Pos  = 0x5      // Position of RXNE field.
	USART_ISR_RXNE_Msk  = 0x20     // Bit mask of RXNE field.
	USART_ISR_RXNE      = 0x20     // Bit RXNE.
	USART_ISR_IDLE_Pos  = 0x4      // Position of IDLE field.
	USART_ISR_IDLE_Msk  = 0x10     // Bit mask of IDLE field.
	USART_ISR_IDLE      = 0x10     // Bit IDLE.
	USART_ISR_ORE_Pos   = 0x3      // Position of ORE field.
	USART_ISR_ORE_Msk   = 0x8      // Bit mask of ORE field.
	USART_ISR_ORE       = 0x8      // Bit ORE.
	USART_ISR_NF_Pos    = 0x2      // Position of NF field.
	USART_ISR_NF_Msk    = 0x4      // Bit mask of NF field.
	USART_ISR_NF        = 0x4      // Bit NF.
	USART_ISR_FE_Pos    = 0x1      // Position of FE field.
	USART_ISR_FE_Msk    = 0x2      // Bit mask of FE field.
	USART_ISR_FE        = 0x2      // Bit FE.
	USART_ISR_PE_Pos    = 0x0      // Position of PE field.
	USART_ISR_PE_Msk    = 0x1      // Bit mask of PE field.
	USART_ISR_PE        = 0x1      // Bit PE.

	// ICR: Interrupt flag clear register
	USART_ICR_WUCF_Pos   = 0x14     // Position of WUCF field.
	USART_ICR_WUCF_Msk   = 0x100000 // Bit mask of WUCF field.
	USART_ICR_WUCF       = 0x100000 // Bit WUCF.
	USART_ICR_CMCF_Pos   = 0x11     // Position of CMCF field.
	USART_ICR_CMCF_Msk   = 0x20000  // Bit mask of CMCF field.
	USART_ICR_CMCF       = 0x20000  // Bit CMCF.
	USART_ICR_EOBCF_Pos  = 0xc      // Position of EOBCF field.
	USART_ICR_EOBCF_Msk  = 0x1000   // Bit mask of EOBCF field.
	USART_ICR_EOBCF      = 0x1000   // Bit EOBCF.
	USART_ICR_RTOCF_Pos  = 0xb      // Position of RTOCF field.
	USART_ICR_RTOCF_Msk  = 0x800    // Bit mask of RTOCF field.
	USART_ICR_RTOCF      = 0x800    // Bit RTOCF.
	USART_ICR_CTSCF_Pos  = 0x9      // Position of CTSCF field.
	USART_ICR_CTSCF_Msk  = 0x200    // Bit mask of CTSCF field.
	USART_ICR_CTSCF      = 0x200    // Bit CTSCF.
	USART_ICR_LBDCF_Pos  = 0x8      // Position of LBDCF field.
	USART_ICR_LBDCF_Msk  = 0x100    // Bit mask of LBDCF field.
	USART_ICR_LBDCF      = 0x100    // Bit LBDCF.
	USART_ICR_TCCF_Pos   = 0x6      // Position of TCCF field.
	USART_ICR_TCCF_Msk   = 0x40     // Bit mask of TCCF field.
	USART_ICR_TCCF       = 0x40     // Bit TCCF.
	USART_ICR_IDLECF_Pos = 0x4      // Position of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10     // Bit mask of IDLECF field.
	USART_ICR_IDLECF     = 0x10     // Bit IDLECF.
	USART_ICR_ORECF_Pos  = 0x3      // Position of ORECF field.
	USART_ICR_ORECF_Msk  = 0x8      // Bit mask of ORECF field.
	USART_ICR_ORECF      = 0x8      // Bit ORECF.
	USART_ICR_NCF_Pos    = 0x2      // Position of NCF field.
	USART_ICR_NCF_Msk    = 0x4      // Bit mask of NCF field.
	USART_ICR_NCF        = 0x4      // Bit NCF.
	USART_ICR_FECF_Pos   = 0x1      // Position of FECF field.
	USART_ICR_FECF_Msk   = 0x2      // Bit mask of FECF field.
	USART_ICR_FECF       = 0x2      // Bit FECF.
	USART_ICR_PECF_Pos   = 0x0      // Position of PECF field.
	USART_ICR_PECF_Msk   = 0x1      // Bit mask of PECF field.
	USART_ICR_PECF       = 0x1      // Bit PECF.

	// RDR: Receive data register
	USART_RDR_RDR_Pos = 0x0   // Position of RDR field.
	USART_RDR_RDR_Msk = 0x1ff // Bit mask of RDR field.

	// TDR: Transmit data register
	USART_TDR_TDR_Pos = 0x0   // Position of TDR field.
	USART_TDR_TDR_Msk = 0x1ff // Bit mask of TDR field.
)

// Bitfields for SPI1: Serial peripheral interface/Inter-IC sound
const (
	// CR1: control register 1
	SPI_CR1_BIDIMODE_Pos = 0xf    // Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000 // Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE     = 0x8000 // Bit BIDIMODE.
	SPI_CR1_BIDIOE_Pos   = 0xe    // Position of BIDIOE field.
	SPI_CR1_BIDIOE_Msk   = 0x4000 // Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE       = 0x4000 // Bit BIDIOE.
	SPI_CR1_CRCEN_Pos    = 0xd    // Position of CRCEN field.
	SPI_CR1_CRCEN_Msk    = 0x2000 // Bit mask of CRCEN field.
	SPI_CR1_CRCEN        = 0x2000 // Bit CRCEN.
	SPI_CR1_CRCNEXT_Pos  = 0xc    // Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk  = 0x1000 // Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT      = 0x1000 // Bit CRCNEXT.
	SPI_CR1_CRCL_Pos     = 0xb    // Position of CRCL field.
	SPI_CR1_CRCL_Msk     = 0x800  // Bit mask of CRCL field.
	SPI_CR1_CRCL         = 0x800  // Bit CRCL.
	SPI_CR1_RXONLY_Pos   = 0xa    // Position of RXONLY field.
	SPI_CR1_RXONLY_Msk   = 0x400  // Bit mask of RXONLY field.
	SPI_CR1_RXONLY       = 0x400  // Bit RXONLY.
	SPI_CR1_SSM_Pos      = 0x9    // Position of SSM field.
	SPI_CR1_SSM_Msk      = 0x200  // Bit mask of SSM field.
	SPI_CR1_SSM          = 0x200  // Bit SSM.
	SPI_CR1_SSI_Pos      = 0x8    // Position of SSI field.
	SPI_CR1_SSI_Msk      = 0x100  // Bit mask of SSI field.
	SPI_CR1_SSI          = 0x100  // Bit SSI.
	SPI_CR1_LSBFIRST_Pos = 0x7    // Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80   // Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST     = 0x80   // Bit LSBFIRST.
	SPI_CR1_SPE_Pos      = 0x6    // Position of SPE field.
	SPI_CR1_SPE_Msk      = 0x40   // Bit mask of SPE field.
	SPI_CR1_SPE          = 0x40   // Bit SPE.
	SPI_CR1_BR_Pos       = 0x3    // Position of BR field.
	SPI_CR1_BR_Msk       = 0x38   // Bit mask of BR field.
	SPI_CR1_MSTR_Pos     = 0x2    // Position of MSTR field.
	SPI_CR1_MSTR_Msk     = 0x4    // Bit mask of MSTR field.
	SPI_CR1_MSTR         = 0x4    // Bit MSTR.
	SPI_CR1_CPOL_Pos     = 0x1    // Position of CPOL field.
	SPI_CR1_CPOL_Msk     = 0x2    // Bit mask of CPOL field.
	SPI_CR1_CPOL         = 0x2    // Bit CPOL.
	SPI_CR1_CPHA_Pos     = 0x0    // Position of CPHA field.
	SPI_CR1_CPHA_Msk     = 0x1    // Bit mask of CPHA field.
	SPI_CR1_CPHA         = 0x1    // Bit CPHA.

	// CR2: control register 2
	SPI_CR2_RXDMAEN_Pos = 0x0    // Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1    // Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN     = 0x1    // Bit RXDMAEN.
	SPI_CR2_TXDMAEN_Pos = 0x1    // Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2    // Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN     = 0x2    // Bit TXDMAEN.
	SPI_CR2_SSOE_Pos    = 0x2    // Position of SSOE field.
	SPI_CR2_SSOE_Msk    = 0x4    // Bit mask of SSOE field.
	SPI_CR2_SSOE        = 0x4    // Bit SSOE.
	SPI_CR2_NSSP_Pos    = 0x3    // Position of NSSP field.
	SPI_CR2_NSSP_Msk    = 0x8    // Bit mask of NSSP field.
	SPI_CR2_NSSP        = 0x8    // Bit NSSP.
	SPI_CR2_FRF_Pos     = 0x4    // Position of FRF field.
	SPI_CR2_FRF_Msk     = 0x10   // Bit mask of FRF field.
	SPI_CR2_FRF         = 0x10   // Bit FRF.
	SPI_CR2_ERRIE_Pos   = 0x5    // Position of ERRIE field.
	SPI_CR2_ERRIE_Msk   = 0x20   // Bit mask of ERRIE field.
	SPI_CR2_ERRIE       = 0x20   // Bit ERRIE.
	SPI_CR2_RXNEIE_Pos  = 0x6    // Position of RXNEIE field.
	SPI_CR2_RXNEIE_Msk  = 0x40   // Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE      = 0x40   // Bit RXNEIE.
	SPI_CR2_TXEIE_Pos   = 0x7    // Position of TXEIE field.
	SPI_CR2_TXEIE_Msk   = 0x80   // Bit mask of TXEIE field.
	SPI_CR2_TXEIE       = 0x80   // Bit TXEIE.
	SPI_CR2_DS_Pos      = 0x8    // Position of DS field.
	SPI_CR2_DS_Msk      = 0xf00  // Bit mask of DS field.
	SPI_CR2_FRXTH_Pos   = 0xc    // Position of FRXTH field.
	SPI_CR2_FRXTH_Msk   = 0x1000 // Bit mask of FRXTH field.
	SPI_CR2_FRXTH       = 0x1000 // Bit FRXTH.
	SPI_CR2_LDMA_RX_Pos = 0xd    // Position of LDMA_RX field.
	SPI_CR2_LDMA_RX_Msk = 0x2000 // Bit mask of LDMA_RX field.
	SPI_CR2_LDMA_RX     = 0x2000 // Bit LDMA_RX.
	SPI_CR2_LDMA_TX_Pos = 0xe    // Position of LDMA_TX field.
	SPI_CR2_LDMA_TX_Msk = 0x4000 // Bit mask of LDMA_TX field.
	SPI_CR2_LDMA_TX     = 0x4000 // Bit LDMA_TX.

	// SR: status register
	SPI_SR_RXNE_Pos   = 0x0    // Position of RXNE field.
	SPI_SR_RXNE_Msk   = 0x1    // Bit mask of RXNE field.
	SPI_SR_RXNE       = 0x1    // Bit RXNE.
	SPI_SR_TXE_Pos    = 0x1    // Position of TXE field.
	SPI_SR_TXE_Msk    = 0x2    // Bit mask of TXE field.
	SPI_SR_TXE        = 0x2    // Bit TXE.
	SPI_SR_CHSIDE_Pos = 0x2    // Position of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4    // Bit mask of CHSIDE field.
	SPI_SR_CHSIDE     = 0x4    // Bit CHSIDE.
	SPI_SR_UDR_Pos    = 0x3    // Position of UDR field.
	SPI_SR_UDR_Msk    = 0x8    // Bit mask of UDR field.
	SPI_SR_UDR        = 0x8    // Bit UDR.
	SPI_SR_CRCERR_Pos = 0x4    // Position of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10   // Bit mask of CRCERR field.
	SPI_SR_CRCERR     = 0x10   // Bit CRCERR.
	SPI_SR_MODF_Pos   = 0x5    // Position of MODF field.
	SPI_SR_MODF_Msk   = 0x20   // Bit mask of MODF field.
	SPI_SR_MODF       = 0x20   // Bit MODF.
	SPI_SR_OVR_Pos    = 0x6    // Position of OVR field.
	SPI_SR_OVR_Msk    = 0x40   // Bit mask of OVR field.
	SPI_SR_OVR        = 0x40   // Bit OVR.
	SPI_SR_BSY_Pos    = 0x7    // Position of BSY field.
	SPI_SR_BSY_Msk    = 0x80   // Bit mask of BSY field.
	SPI_SR_BSY        = 0x80   // Bit BSY.
	SPI_SR_TIFRFE_Pos = 0x8    // Position of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100  // Bit mask of TIFRFE field.
	SPI_SR_TIFRFE     = 0x100  // Bit TIFRFE.
	SPI_SR_FRLVL_Pos  = 0x9    // Position of FRLVL field.
	SPI_SR_FRLVL_Msk  = 0x600  // Bit mask of FRLVL field.
	SPI_SR_FTLVL_Pos  = 0xb    // Position of FTLVL field.
	SPI_SR_FTLVL_Msk  = 0x1800 // Bit mask of FTLVL field.

	// DR: data register
	SPI_DR_DR_Pos = 0x0    // Position of DR field.
	SPI_DR_DR_Msk = 0xffff // Bit mask of DR field.

	// CRCPR: CRC polynomial register
	SPI_CRCPR_CRCPOLY_Pos = 0x0    // Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff // Bit mask of CRCPOLY field.

	// RXCRCR: RX CRC register
	SPI_RXCRCR_RxCRC_Pos = 0x0    // Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff // Bit mask of RxCRC field.

	// TXCRCR: TX CRC register
	SPI_TXCRCR_TxCRC_Pos = 0x0    // Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff // Bit mask of TxCRC field.

	// I2SCFGR: I2S configuration register
	SPI_I2SCFGR_I2SMOD_Pos  = 0xb   // Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk  = 0x800 // Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD      = 0x800 // Bit I2SMOD.
	SPI_I2SCFGR_I2SE_Pos    = 0xa   // Position of I2SE field.
	SPI_I2SCFGR_I2SE_Msk    = 0x400 // Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE        = 0x400 // Bit I2SE.
	SPI_I2SCFGR_I2SCFG_Pos  = 0x8   // Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk  = 0x300 // Bit mask of I2SCFG field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7   // Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80  // Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC     = 0x80  // Bit PCMSYNC.
	SPI_I2SCFGR_I2SSTD_Pos  = 0x4   // Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk  = 0x30  // Bit mask of I2SSTD field.
	SPI_I2SCFGR_CKPOL_Pos   = 0x3   // Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk   = 0x8   // Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL       = 0x8   // Bit CKPOL.
	SPI_I2SCFGR_DATLEN_Pos  = 0x1   // Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk  = 0x6   // Bit mask of DATLEN field.
	SPI_I2SCFGR_CHLEN_Pos   = 0x0   // Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk   = 0x1   // Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN       = 0x1   // Bit CHLEN.

	// I2SPR: I2S prescaler register
	SPI_I2SPR_MCKOE_Pos  = 0x9   // Position of MCKOE field.
	SPI_I2SPR_MCKOE_Msk  = 0x200 // Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE      = 0x200 // Bit MCKOE.
	SPI_I2SPR_ODD_Pos    = 0x8   // Position of ODD field.
	SPI_I2SPR_ODD_Msk    = 0x100 // Bit mask of ODD field.
	SPI_I2SPR_ODD        = 0x100 // Bit ODD.
	SPI_I2SPR_I2SDIV_Pos = 0x0   // Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff  // Bit mask of I2SDIV field.
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR1: Interrupt mask register
	EXTI_IMR1_MR0_Pos  = 0x0        // Position of MR0 field.
	EXTI_IMR1_MR0_Msk  = 0x1        // Bit mask of MR0 field.
	EXTI_IMR1_MR0      = 0x1        // Bit MR0.
	EXTI_IMR1_MR1_Pos  = 0x1        // Position of MR1 field.
	EXTI_IMR1_MR1_Msk  = 0x2        // Bit mask of MR1 field.
	EXTI_IMR1_MR1      = 0x2        // Bit MR1.
	EXTI_IMR1_MR2_Pos  = 0x2        // Position of MR2 field.
	EXTI_IMR1_MR2_Msk  = 0x4        // Bit mask of MR2 field.
	EXTI_IMR1_MR2      = 0x4        // Bit MR2.
	EXTI_IMR1_MR3_Pos  = 0x3        // Position of MR3 field.
	EXTI_IMR1_MR3_Msk  = 0x8        // Bit mask of MR3 field.
	EXTI_IMR1_MR3      = 0x8        // Bit MR3.
	EXTI_IMR1_MR4_Pos  = 0x4        // Position of MR4 field.
	EXTI_IMR1_MR4_Msk  = 0x10       // Bit mask of MR4 field.
	EXTI_IMR1_MR4      = 0x10       // Bit MR4.
	EXTI_IMR1_MR5_Pos  = 0x5        // Position of MR5 field.
	EXTI_IMR1_MR5_Msk  = 0x20       // Bit mask of MR5 field.
	EXTI_IMR1_MR5      = 0x20       // Bit MR5.
	EXTI_IMR1_MR6_Pos  = 0x6        // Position of MR6 field.
	EXTI_IMR1_MR6_Msk  = 0x40       // Bit mask of MR6 field.
	EXTI_IMR1_MR6      = 0x40       // Bit MR6.
	EXTI_IMR1_MR7_Pos  = 0x7        // Position of MR7 field.
	EXTI_IMR1_MR7_Msk  = 0x80       // Bit mask of MR7 field.
	EXTI_IMR1_MR7      = 0x80       // Bit MR7.
	EXTI_IMR1_MR8_Pos  = 0x8        // Position of MR8 field.
	EXTI_IMR1_MR8_Msk  = 0x100      // Bit mask of MR8 field.
	EXTI_IMR1_MR8      = 0x100      // Bit MR8.
	EXTI_IMR1_MR9_Pos  = 0x9        // Position of MR9 field.
	EXTI_IMR1_MR9_Msk  = 0x200      // Bit mask of MR9 field.
	EXTI_IMR1_MR9      = 0x200      // Bit MR9.
	EXTI_IMR1_MR10_Pos = 0xa        // Position of MR10 field.
	EXTI_IMR1_MR10_Msk = 0x400      // Bit mask of MR10 field.
	EXTI_IMR1_MR10     = 0x400      // Bit MR10.
	EXTI_IMR1_MR11_Pos = 0xb        // Position of MR11 field.
	EXTI_IMR1_MR11_Msk = 0x800      // Bit mask of MR11 field.
	EXTI_IMR1_MR11     = 0x800      // Bit MR11.
	EXTI_IMR1_MR12_Pos = 0xc        // Position of MR12 field.
	EXTI_IMR1_MR12_Msk = 0x1000     // Bit mask of MR12 field.
	EXTI_IMR1_MR12     = 0x1000     // Bit MR12.
	EXTI_IMR1_MR13_Pos = 0xd        // Position of MR13 field.
	EXTI_IMR1_MR13_Msk = 0x2000     // Bit mask of MR13 field.
	EXTI_IMR1_MR13     = 0x2000     // Bit MR13.
	EXTI_IMR1_MR14_Pos = 0xe        // Position of MR14 field.
	EXTI_IMR1_MR14_Msk = 0x4000     // Bit mask of MR14 field.
	EXTI_IMR1_MR14     = 0x4000     // Bit MR14.
	EXTI_IMR1_MR15_Pos = 0xf        // Position of MR15 field.
	EXTI_IMR1_MR15_Msk = 0x8000     // Bit mask of MR15 field.
	EXTI_IMR1_MR15     = 0x8000     // Bit MR15.
	EXTI_IMR1_MR16_Pos = 0x10       // Position of MR16 field.
	EXTI_IMR1_MR16_Msk = 0x10000    // Bit mask of MR16 field.
	EXTI_IMR1_MR16     = 0x10000    // Bit MR16.
	EXTI_IMR1_MR17_Pos = 0x11       // Position of MR17 field.
	EXTI_IMR1_MR17_Msk = 0x20000    // Bit mask of MR17 field.
	EXTI_IMR1_MR17     = 0x20000    // Bit MR17.
	EXTI_IMR1_MR18_Pos = 0x12       // Position of MR18 field.
	EXTI_IMR1_MR18_Msk = 0x40000    // Bit mask of MR18 field.
	EXTI_IMR1_MR18     = 0x40000    // Bit MR18.
	EXTI_IMR1_MR19_Pos = 0x13       // Position of MR19 field.
	EXTI_IMR1_MR19_Msk = 0x80000    // Bit mask of MR19 field.
	EXTI_IMR1_MR19     = 0x80000    // Bit MR19.
	EXTI_IMR1_MR20_Pos = 0x14       // Position of MR20 field.
	EXTI_IMR1_MR20_Msk = 0x100000   // Bit mask of MR20 field.
	EXTI_IMR1_MR20     = 0x100000   // Bit MR20.
	EXTI_IMR1_MR21_Pos = 0x15       // Position of MR21 field.
	EXTI_IMR1_MR21_Msk = 0x200000   // Bit mask of MR21 field.
	EXTI_IMR1_MR21     = 0x200000   // Bit MR21.
	EXTI_IMR1_MR22_Pos = 0x16       // Position of MR22 field.
	EXTI_IMR1_MR22_Msk = 0x400000   // Bit mask of MR22 field.
	EXTI_IMR1_MR22     = 0x400000   // Bit MR22.
	EXTI_IMR1_MR23_Pos = 0x17       // Position of MR23 field.
	EXTI_IMR1_MR23_Msk = 0x800000   // Bit mask of MR23 field.
	EXTI_IMR1_MR23     = 0x800000   // Bit MR23.
	EXTI_IMR1_MR24_Pos = 0x18       // Position of MR24 field.
	EXTI_IMR1_MR24_Msk = 0x1000000  // Bit mask of MR24 field.
	EXTI_IMR1_MR24     = 0x1000000  // Bit MR24.
	EXTI_IMR1_MR25_Pos = 0x19       // Position of MR25 field.
	EXTI_IMR1_MR25_Msk = 0x2000000  // Bit mask of MR25 field.
	EXTI_IMR1_MR25     = 0x2000000  // Bit MR25.
	EXTI_IMR1_MR26_Pos = 0x1a       // Position of MR26 field.
	EXTI_IMR1_MR26_Msk = 0x4000000  // Bit mask of MR26 field.
	EXTI_IMR1_MR26     = 0x4000000  // Bit MR26.
	EXTI_IMR1_MR27_Pos = 0x1b       // Position of MR27 field.
	EXTI_IMR1_MR27_Msk = 0x8000000  // Bit mask of MR27 field.
	EXTI_IMR1_MR27     = 0x8000000  // Bit MR27.
	EXTI_IMR1_MR28_Pos = 0x1c       // Position of MR28 field.
	EXTI_IMR1_MR28_Msk = 0x10000000 // Bit mask of MR28 field.
	EXTI_IMR1_MR28     = 0x10000000 // Bit MR28.
	EXTI_IMR1_MR29_Pos = 0x1d       // Position of MR29 field.
	EXTI_IMR1_MR29_Msk = 0x20000000 // Bit mask of MR29 field.
	EXTI_IMR1_MR29     = 0x20000000 // Bit MR29.
	EXTI_IMR1_MR30_Pos = 0x1e       // Position of MR30 field.
	EXTI_IMR1_MR30_Msk = 0x40000000 // Bit mask of MR30 field.
	EXTI_IMR1_MR30     = 0x40000000 // Bit MR30.
	EXTI_IMR1_MR31_Pos = 0x1f       // Position of MR31 field.
	EXTI_IMR1_MR31_Msk = 0x80000000 // Bit mask of MR31 field.
	EXTI_IMR1_MR31     = 0x80000000 // Bit MR31.

	// EMR1: Event mask register
	EXTI_EMR1_MR0_Pos  = 0x0        // Position of MR0 field.
	EXTI_EMR1_MR0_Msk  = 0x1        // Bit mask of MR0 field.
	EXTI_EMR1_MR0      = 0x1        // Bit MR0.
	EXTI_EMR1_MR1_Pos  = 0x1        // Position of MR1 field.
	EXTI_EMR1_MR1_Msk  = 0x2        // Bit mask of MR1 field.
	EXTI_EMR1_MR1      = 0x2        // Bit MR1.
	EXTI_EMR1_MR2_Pos  = 0x2        // Position of MR2 field.
	EXTI_EMR1_MR2_Msk  = 0x4        // Bit mask of MR2 field.
	EXTI_EMR1_MR2      = 0x4        // Bit MR2.
	EXTI_EMR1_MR3_Pos  = 0x3        // Position of MR3 field.
	EXTI_EMR1_MR3_Msk  = 0x8        // Bit mask of MR3 field.
	EXTI_EMR1_MR3      = 0x8        // Bit MR3.
	EXTI_EMR1_MR4_Pos  = 0x4        // Position of MR4 field.
	EXTI_EMR1_MR4_Msk  = 0x10       // Bit mask of MR4 field.
	EXTI_EMR1_MR4      = 0x10       // Bit MR4.
	EXTI_EMR1_MR5_Pos  = 0x5        // Position of MR5 field.
	EXTI_EMR1_MR5_Msk  = 0x20       // Bit mask of MR5 field.
	EXTI_EMR1_MR5      = 0x20       // Bit MR5.
	EXTI_EMR1_MR6_Pos  = 0x6        // Position of MR6 field.
	EXTI_EMR1_MR6_Msk  = 0x40       // Bit mask of MR6 field.
	EXTI_EMR1_MR6      = 0x40       // Bit MR6.
	EXTI_EMR1_MR7_Pos  = 0x7        // Position of MR7 field.
	EXTI_EMR1_MR7_Msk  = 0x80       // Bit mask of MR7 field.
	EXTI_EMR1_MR7      = 0x80       // Bit MR7.
	EXTI_EMR1_MR8_Pos  = 0x8        // Position of MR8 field.
	EXTI_EMR1_MR8_Msk  = 0x100      // Bit mask of MR8 field.
	EXTI_EMR1_MR8      = 0x100      // Bit MR8.
	EXTI_EMR1_MR9_Pos  = 0x9        // Position of MR9 field.
	EXTI_EMR1_MR9_Msk  = 0x200      // Bit mask of MR9 field.
	EXTI_EMR1_MR9      = 0x200      // Bit MR9.
	EXTI_EMR1_MR10_Pos = 0xa        // Position of MR10 field.
	EXTI_EMR1_MR10_Msk = 0x400      // Bit mask of MR10 field.
	EXTI_EMR1_MR10     = 0x400      // Bit MR10.
	EXTI_EMR1_MR11_Pos = 0xb        // Position of MR11 field.
	EXTI_EMR1_MR11_Msk = 0x800      // Bit mask of MR11 field.
	EXTI_EMR1_MR11     = 0x800      // Bit MR11.
	EXTI_EMR1_MR12_Pos = 0xc        // Position of MR12 field.
	EXTI_EMR1_MR12_Msk = 0x1000     // Bit mask of MR12 field.
	EXTI_EMR1_MR12     = 0x1000     // Bit MR12.
	EXTI_EMR1_MR13_Pos = 0xd        // Position of MR13 field.
	EXTI_EMR1_MR13_Msk = 0x2000     // Bit mask of MR13 field.
	EXTI_EMR1_MR13     = 0x2000     // Bit MR13.
	EXTI_EMR1_MR14_Pos = 0xe        // Position of MR14 field.
	EXTI_EMR1_MR14_Msk = 0x4000     // Bit mask of MR14 field.
	EXTI_EMR1_MR14     = 0x4000     // Bit MR14.
	EXTI_EMR1_MR15_Pos = 0xf        // Position of MR15 field.
	EXTI_EMR1_MR15_Msk = 0x8000     // Bit mask of MR15 field.
	EXTI_EMR1_MR15     = 0x8000     // Bit MR15.
	EXTI_EMR1_MR16_Pos = 0x10       // Position of MR16 field.
	EXTI_EMR1_MR16_Msk = 0x10000    // Bit mask of MR16 field.
	EXTI_EMR1_MR16     = 0x10000    // Bit MR16.
	EXTI_EMR1_MR17_Pos = 0x11       // Position of MR17 field.
	EXTI_EMR1_MR17_Msk = 0x20000    // Bit mask of MR17 field.
	EXTI_EMR1_MR17     = 0x20000    // Bit MR17.
	EXTI_EMR1_MR18_Pos = 0x12       // Position of MR18 field.
	EXTI_EMR1_MR18_Msk = 0x40000    // Bit mask of MR18 field.
	EXTI_EMR1_MR18     = 0x40000    // Bit MR18.
	EXTI_EMR1_MR19_Pos = 0x13       // Position of MR19 field.
	EXTI_EMR1_MR19_Msk = 0x80000    // Bit mask of MR19 field.
	EXTI_EMR1_MR19     = 0x80000    // Bit MR19.
	EXTI_EMR1_MR20_Pos = 0x14       // Position of MR20 field.
	EXTI_EMR1_MR20_Msk = 0x100000   // Bit mask of MR20 field.
	EXTI_EMR1_MR20     = 0x100000   // Bit MR20.
	EXTI_EMR1_MR21_Pos = 0x15       // Position of MR21 field.
	EXTI_EMR1_MR21_Msk = 0x200000   // Bit mask of MR21 field.
	EXTI_EMR1_MR21     = 0x200000   // Bit MR21.
	EXTI_EMR1_MR22_Pos = 0x16       // Position of MR22 field.
	EXTI_EMR1_MR22_Msk = 0x400000   // Bit mask of MR22 field.
	EXTI_EMR1_MR22     = 0x400000   // Bit MR22.
	EXTI_EMR1_MR23_Pos = 0x17       // Position of MR23 field.
	EXTI_EMR1_MR23_Msk = 0x800000   // Bit mask of MR23 field.
	EXTI_EMR1_MR23     = 0x800000   // Bit MR23.
	EXTI_EMR1_MR24_Pos = 0x18       // Position of MR24 field.
	EXTI_EMR1_MR24_Msk = 0x1000000  // Bit mask of MR24 field.
	EXTI_EMR1_MR24     = 0x1000000  // Bit MR24.
	EXTI_EMR1_MR25_Pos = 0x19       // Position of MR25 field.
	EXTI_EMR1_MR25_Msk = 0x2000000  // Bit mask of MR25 field.
	EXTI_EMR1_MR25     = 0x2000000  // Bit MR25.
	EXTI_EMR1_MR26_Pos = 0x1a       // Position of MR26 field.
	EXTI_EMR1_MR26_Msk = 0x4000000  // Bit mask of MR26 field.
	EXTI_EMR1_MR26     = 0x4000000  // Bit MR26.
	EXTI_EMR1_MR27_Pos = 0x1b       // Position of MR27 field.
	EXTI_EMR1_MR27_Msk = 0x8000000  // Bit mask of MR27 field.
	EXTI_EMR1_MR27     = 0x8000000  // Bit MR27.
	EXTI_EMR1_MR28_Pos = 0x1c       // Position of MR28 field.
	EXTI_EMR1_MR28_Msk = 0x10000000 // Bit mask of MR28 field.
	EXTI_EMR1_MR28     = 0x10000000 // Bit MR28.
	EXTI_EMR1_MR29_Pos = 0x1d       // Position of MR29 field.
	EXTI_EMR1_MR29_Msk = 0x20000000 // Bit mask of MR29 field.
	EXTI_EMR1_MR29     = 0x20000000 // Bit MR29.
	EXTI_EMR1_MR30_Pos = 0x1e       // Position of MR30 field.
	EXTI_EMR1_MR30_Msk = 0x40000000 // Bit mask of MR30 field.
	EXTI_EMR1_MR30     = 0x40000000 // Bit MR30.
	EXTI_EMR1_MR31_Pos = 0x1f       // Position of MR31 field.
	EXTI_EMR1_MR31_Msk = 0x80000000 // Bit mask of MR31 field.
	EXTI_EMR1_MR31     = 0x80000000 // Bit MR31.

	// RTSR1: Rising Trigger selection           register
	EXTI_RTSR1_TR0_Pos  = 0x0        // Position of TR0 field.
	EXTI_RTSR1_TR0_Msk  = 0x1        // Bit mask of TR0 field.
	EXTI_RTSR1_TR0      = 0x1        // Bit TR0.
	EXTI_RTSR1_TR1_Pos  = 0x1        // Position of TR1 field.
	EXTI_RTSR1_TR1_Msk  = 0x2        // Bit mask of TR1 field.
	EXTI_RTSR1_TR1      = 0x2        // Bit TR1.
	EXTI_RTSR1_TR2_Pos  = 0x2        // Position of TR2 field.
	EXTI_RTSR1_TR2_Msk  = 0x4        // Bit mask of TR2 field.
	EXTI_RTSR1_TR2      = 0x4        // Bit TR2.
	EXTI_RTSR1_TR3_Pos  = 0x3        // Position of TR3 field.
	EXTI_RTSR1_TR3_Msk  = 0x8        // Bit mask of TR3 field.
	EXTI_RTSR1_TR3      = 0x8        // Bit TR3.
	EXTI_RTSR1_TR4_Pos  = 0x4        // Position of TR4 field.
	EXTI_RTSR1_TR4_Msk  = 0x10       // Bit mask of TR4 field.
	EXTI_RTSR1_TR4      = 0x10       // Bit TR4.
	EXTI_RTSR1_TR5_Pos  = 0x5        // Position of TR5 field.
	EXTI_RTSR1_TR5_Msk  = 0x20       // Bit mask of TR5 field.
	EXTI_RTSR1_TR5      = 0x20       // Bit TR5.
	EXTI_RTSR1_TR6_Pos  = 0x6        // Position of TR6 field.
	EXTI_RTSR1_TR6_Msk  = 0x40       // Bit mask of TR6 field.
	EXTI_RTSR1_TR6      = 0x40       // Bit TR6.
	EXTI_RTSR1_TR7_Pos  = 0x7        // Position of TR7 field.
	EXTI_RTSR1_TR7_Msk  = 0x80       // Bit mask of TR7 field.
	EXTI_RTSR1_TR7      = 0x80       // Bit TR7.
	EXTI_RTSR1_TR8_Pos  = 0x8        // Position of TR8 field.
	EXTI_RTSR1_TR8_Msk  = 0x100      // Bit mask of TR8 field.
	EXTI_RTSR1_TR8      = 0x100      // Bit TR8.
	EXTI_RTSR1_TR9_Pos  = 0x9        // Position of TR9 field.
	EXTI_RTSR1_TR9_Msk  = 0x200      // Bit mask of TR9 field.
	EXTI_RTSR1_TR9      = 0x200      // Bit TR9.
	EXTI_RTSR1_TR10_Pos = 0xa        // Position of TR10 field.
	EXTI_RTSR1_TR10_Msk = 0x400      // Bit mask of TR10 field.
	EXTI_RTSR1_TR10     = 0x400      // Bit TR10.
	EXTI_RTSR1_TR11_Pos = 0xb        // Position of TR11 field.
	EXTI_RTSR1_TR11_Msk = 0x800      // Bit mask of TR11 field.
	EXTI_RTSR1_TR11     = 0x800      // Bit TR11.
	EXTI_RTSR1_TR12_Pos = 0xc        // Position of TR12 field.
	EXTI_RTSR1_TR12_Msk = 0x1000     // Bit mask of TR12 field.
	EXTI_RTSR1_TR12     = 0x1000     // Bit TR12.
	EXTI_RTSR1_TR13_Pos = 0xd        // Position of TR13 field.
	EXTI_RTSR1_TR13_Msk = 0x2000     // Bit mask of TR13 field.
	EXTI_RTSR1_TR13     = 0x2000     // Bit TR13.
	EXTI_RTSR1_TR14_Pos = 0xe        // Position of TR14 field.
	EXTI_RTSR1_TR14_Msk = 0x4000     // Bit mask of TR14 field.
	EXTI_RTSR1_TR14     = 0x4000     // Bit TR14.
	EXTI_RTSR1_TR15_Pos = 0xf        // Position of TR15 field.
	EXTI_RTSR1_TR15_Msk = 0x8000     // Bit mask of TR15 field.
	EXTI_RTSR1_TR15     = 0x8000     // Bit TR15.
	EXTI_RTSR1_TR16_Pos = 0x10       // Position of TR16 field.
	EXTI_RTSR1_TR16_Msk = 0x10000    // Bit mask of TR16 field.
	EXTI_RTSR1_TR16     = 0x10000    // Bit TR16.
	EXTI_RTSR1_TR17_Pos = 0x11       // Position of TR17 field.
	EXTI_RTSR1_TR17_Msk = 0x20000    // Bit mask of TR17 field.
	EXTI_RTSR1_TR17     = 0x20000    // Bit TR17.
	EXTI_RTSR1_TR18_Pos = 0x12       // Position of TR18 field.
	EXTI_RTSR1_TR18_Msk = 0x40000    // Bit mask of TR18 field.
	EXTI_RTSR1_TR18     = 0x40000    // Bit TR18.
	EXTI_RTSR1_TR19_Pos = 0x13       // Position of TR19 field.
	EXTI_RTSR1_TR19_Msk = 0x80000    // Bit mask of TR19 field.
	EXTI_RTSR1_TR19     = 0x80000    // Bit TR19.
	EXTI_RTSR1_TR20_Pos = 0x14       // Position of TR20 field.
	EXTI_RTSR1_TR20_Msk = 0x100000   // Bit mask of TR20 field.
	EXTI_RTSR1_TR20     = 0x100000   // Bit TR20.
	EXTI_RTSR1_TR21_Pos = 0x15       // Position of TR21 field.
	EXTI_RTSR1_TR21_Msk = 0x200000   // Bit mask of TR21 field.
	EXTI_RTSR1_TR21     = 0x200000   // Bit TR21.
	EXTI_RTSR1_TR22_Pos = 0x16       // Position of TR22 field.
	EXTI_RTSR1_TR22_Msk = 0x400000   // Bit mask of TR22 field.
	EXTI_RTSR1_TR22     = 0x400000   // Bit TR22.
	EXTI_RTSR1_TR29_Pos = 0x1d       // Position of TR29 field.
	EXTI_RTSR1_TR29_Msk = 0x20000000 // Bit mask of TR29 field.
	EXTI_RTSR1_TR29     = 0x20000000 // Bit TR29.
	EXTI_RTSR1_TR30_Pos = 0x1e       // Position of TR30 field.
	EXTI_RTSR1_TR30_Msk = 0x40000000 // Bit mask of TR30 field.
	EXTI_RTSR1_TR30     = 0x40000000 // Bit TR30.
	EXTI_RTSR1_TR31_Pos = 0x1f       // Position of TR31 field.
	EXTI_RTSR1_TR31_Msk = 0x80000000 // Bit mask of TR31 field.
	EXTI_RTSR1_TR31     = 0x80000000 // Bit TR31.

	// FTSR1: Falling Trigger selection           register
	EXTI_FTSR1_TR0_Pos  = 0x0        // Position of TR0 field.
	EXTI_FTSR1_TR0_Msk  = 0x1        // Bit mask of TR0 field.
	EXTI_FTSR1_TR0      = 0x1        // Bit TR0.
	EXTI_FTSR1_TR1_Pos  = 0x1        // Position of TR1 field.
	EXTI_FTSR1_TR1_Msk  = 0x2        // Bit mask of TR1 field.
	EXTI_FTSR1_TR1      = 0x2        // Bit TR1.
	EXTI_FTSR1_TR2_Pos  = 0x2        // Position of TR2 field.
	EXTI_FTSR1_TR2_Msk  = 0x4        // Bit mask of TR2 field.
	EXTI_FTSR1_TR2      = 0x4        // Bit TR2.
	EXTI_FTSR1_TR3_Pos  = 0x3        // Position of TR3 field.
	EXTI_FTSR1_TR3_Msk  = 0x8        // Bit mask of TR3 field.
	EXTI_FTSR1_TR3      = 0x8        // Bit TR3.
	EXTI_FTSR1_TR4_Pos  = 0x4        // Position of TR4 field.
	EXTI_FTSR1_TR4_Msk  = 0x10       // Bit mask of TR4 field.
	EXTI_FTSR1_TR4      = 0x10       // Bit TR4.
	EXTI_FTSR1_TR5_Pos  = 0x5        // Position of TR5 field.
	EXTI_FTSR1_TR5_Msk  = 0x20       // Bit mask of TR5 field.
	EXTI_FTSR1_TR5      = 0x20       // Bit TR5.
	EXTI_FTSR1_TR6_Pos  = 0x6        // Position of TR6 field.
	EXTI_FTSR1_TR6_Msk  = 0x40       // Bit mask of TR6 field.
	EXTI_FTSR1_TR6      = 0x40       // Bit TR6.
	EXTI_FTSR1_TR7_Pos  = 0x7        // Position of TR7 field.
	EXTI_FTSR1_TR7_Msk  = 0x80       // Bit mask of TR7 field.
	EXTI_FTSR1_TR7      = 0x80       // Bit TR7.
	EXTI_FTSR1_TR8_Pos  = 0x8        // Position of TR8 field.
	EXTI_FTSR1_TR8_Msk  = 0x100      // Bit mask of TR8 field.
	EXTI_FTSR1_TR8      = 0x100      // Bit TR8.
	EXTI_FTSR1_TR9_Pos  = 0x9        // Position of TR9 field.
	EXTI_FTSR1_TR9_Msk  = 0x200      // Bit mask of TR9 field.
	EXTI_FTSR1_TR9      = 0x200      // Bit TR9.
	EXTI_FTSR1_TR10_Pos = 0xa        // Position of TR10 field.
	EXTI_FTSR1_TR10_Msk = 0x400      // Bit mask of TR10 field.
	EXTI_FTSR1_TR10     = 0x400      // Bit TR10.
	EXTI_FTSR1_TR11_Pos = 0xb        // Position of TR11 field.
	EXTI_FTSR1_TR11_Msk = 0x800      // Bit mask of TR11 field.
	EXTI_FTSR1_TR11     = 0x800      // Bit TR11.
	EXTI_FTSR1_TR12_Pos = 0xc        // Position of TR12 field.
	EXTI_FTSR1_TR12_Msk = 0x1000     // Bit mask of TR12 field.
	EXTI_FTSR1_TR12     = 0x1000     // Bit TR12.
	EXTI_FTSR1_TR13_Pos = 0xd        // Position of TR13 field.
	EXTI_FTSR1_TR13_Msk = 0x2000     // Bit mask of TR13 field.
	EXTI_FTSR1_TR13     = 0x2000     // Bit TR13.
	EXTI_FTSR1_TR14_Pos = 0xe        // Position of TR14 field.
	EXTI_FTSR1_TR14_Msk = 0x4000     // Bit mask of TR14 field.
	EXTI_FTSR1_TR14     = 0x4000     // Bit TR14.
	EXTI_FTSR1_TR15_Pos = 0xf        // Position of TR15 field.
	EXTI_FTSR1_TR15_Msk = 0x8000     // Bit mask of TR15 field.
	EXTI_FTSR1_TR15     = 0x8000     // Bit TR15.
	EXTI_FTSR1_TR16_Pos = 0x10       // Position of TR16 field.
	EXTI_FTSR1_TR16_Msk = 0x10000    // Bit mask of TR16 field.
	EXTI_FTSR1_TR16     = 0x10000    // Bit TR16.
	EXTI_FTSR1_TR17_Pos = 0x11       // Position of TR17 field.
	EXTI_FTSR1_TR17_Msk = 0x20000    // Bit mask of TR17 field.
	EXTI_FTSR1_TR17     = 0x20000    // Bit TR17.
	EXTI_FTSR1_TR18_Pos = 0x12       // Position of TR18 field.
	EXTI_FTSR1_TR18_Msk = 0x40000    // Bit mask of TR18 field.
	EXTI_FTSR1_TR18     = 0x40000    // Bit TR18.
	EXTI_FTSR1_TR19_Pos = 0x13       // Position of TR19 field.
	EXTI_FTSR1_TR19_Msk = 0x80000    // Bit mask of TR19 field.
	EXTI_FTSR1_TR19     = 0x80000    // Bit TR19.
	EXTI_FTSR1_TR20_Pos = 0x14       // Position of TR20 field.
	EXTI_FTSR1_TR20_Msk = 0x100000   // Bit mask of TR20 field.
	EXTI_FTSR1_TR20     = 0x100000   // Bit TR20.
	EXTI_FTSR1_TR21_Pos = 0x15       // Position of TR21 field.
	EXTI_FTSR1_TR21_Msk = 0x200000   // Bit mask of TR21 field.
	EXTI_FTSR1_TR21     = 0x200000   // Bit TR21.
	EXTI_FTSR1_TR22_Pos = 0x16       // Position of TR22 field.
	EXTI_FTSR1_TR22_Msk = 0x400000   // Bit mask of TR22 field.
	EXTI_FTSR1_TR22     = 0x400000   // Bit TR22.
	EXTI_FTSR1_TR29_Pos = 0x1d       // Position of TR29 field.
	EXTI_FTSR1_TR29_Msk = 0x20000000 // Bit mask of TR29 field.
	EXTI_FTSR1_TR29     = 0x20000000 // Bit TR29.
	EXTI_FTSR1_TR30_Pos = 0x1e       // Position of TR30 field.
	EXTI_FTSR1_TR30_Msk = 0x40000000 // Bit mask of TR30 field.
	EXTI_FTSR1_TR30     = 0x40000000 // Bit TR30.
	EXTI_FTSR1_TR31_Pos = 0x1f       // Position of TR31 field.
	EXTI_FTSR1_TR31_Msk = 0x80000000 // Bit mask of TR31 field.
	EXTI_FTSR1_TR31     = 0x80000000 // Bit TR31.

	// SWIER1: Software interrupt event           register
	EXTI_SWIER1_SWIER0_Pos  = 0x0        // Position of SWIER0 field.
	EXTI_SWIER1_SWIER0_Msk  = 0x1        // Bit mask of SWIER0 field.
	EXTI_SWIER1_SWIER0      = 0x1        // Bit SWIER0.
	EXTI_SWIER1_SWIER1_Pos  = 0x1        // Position of SWIER1 field.
	EXTI_SWIER1_SWIER1_Msk  = 0x2        // Bit mask of SWIER1 field.
	EXTI_SWIER1_SWIER1      = 0x2        // Bit SWIER1.
	EXTI_SWIER1_SWIER2_Pos  = 0x2        // Position of SWIER2 field.
	EXTI_SWIER1_SWIER2_Msk  = 0x4        // Bit mask of SWIER2 field.
	EXTI_SWIER1_SWIER2      = 0x4        // Bit SWIER2.
	EXTI_SWIER1_SWIER3_Pos  = 0x3        // Position of SWIER3 field.
	EXTI_SWIER1_SWIER3_Msk  = 0x8        // Bit mask of SWIER3 field.
	EXTI_SWIER1_SWIER3      = 0x8        // Bit SWIER3.
	EXTI_SWIER1_SWIER4_Pos  = 0x4        // Position of SWIER4 field.
	EXTI_SWIER1_SWIER4_Msk  = 0x10       // Bit mask of SWIER4 field.
	EXTI_SWIER1_SWIER4      = 0x10       // Bit SWIER4.
	EXTI_SWIER1_SWIER5_Pos  = 0x5        // Position of SWIER5 field.
	EXTI_SWIER1_SWIER5_Msk  = 0x20       // Bit mask of SWIER5 field.
	EXTI_SWIER1_SWIER5      = 0x20       // Bit SWIER5.
	EXTI_SWIER1_SWIER6_Pos  = 0x6        // Position of SWIER6 field.
	EXTI_SWIER1_SWIER6_Msk  = 0x40       // Bit mask of SWIER6 field.
	EXTI_SWIER1_SWIER6      = 0x40       // Bit SWIER6.
	EXTI_SWIER1_SWIER7_Pos  = 0x7        // Position of SWIER7 field.
	EXTI_SWIER1_SWIER7_Msk  = 0x80       // Bit mask of SWIER7 field.
	EXTI_SWIER1_SWIER7      = 0x80       // Bit SWIER7.
	EXTI_SWIER1_SWIER8_Pos  = 0x8        // Position of SWIER8 field.
	EXTI_SWIER1_SWIER8_Msk  = 0x100      // Bit mask of SWIER8 field.
	EXTI_SWIER1_SWIER8      = 0x100      // Bit SWIER8.
	EXTI_SWIER1_SWIER9_Pos  = 0x9        // Position of SWIER9 field.
	EXTI_SWIER1_SWIER9_Msk  = 0x200      // Bit mask of SWIER9 field.
	EXTI_SWIER1_SWIER9      = 0x200      // Bit SWIER9.
	EXTI_SWIER1_SWIER10_Pos = 0xa        // Position of SWIER10 field.
	EXTI_SWIER1_SWIER10_Msk = 0x400      // Bit mask of SWIER10 field.
	EXTI_SWIER1_SWIER10     = 0x400      // Bit SWIER10.
	EXTI_SWIER1_SWIER11_Pos = 0xb        // Position of SWIER11 field.
	EXTI_SWIER1_SWIER11_Msk = 0x800      // Bit mask of SWIER11 field.
	EXTI_SWIER1_SWIER11     = 0x800      // Bit SWIER11.
	EXTI_SWIER1_SWIER12_Pos = 0xc        // Position of SWIER12 field.
	EXTI_SWIER1_SWIER12_Msk = 0x1000     // Bit mask of SWIER12 field.
	EXTI_SWIER1_SWIER12     = 0x1000     // Bit SWIER12.
	EXTI_SWIER1_SWIER13_Pos = 0xd        // Position of SWIER13 field.
	EXTI_SWIER1_SWIER13_Msk = 0x2000     // Bit mask of SWIER13 field.
	EXTI_SWIER1_SWIER13     = 0x2000     // Bit SWIER13.
	EXTI_SWIER1_SWIER14_Pos = 0xe        // Position of SWIER14 field.
	EXTI_SWIER1_SWIER14_Msk = 0x4000     // Bit mask of SWIER14 field.
	EXTI_SWIER1_SWIER14     = 0x4000     // Bit SWIER14.
	EXTI_SWIER1_SWIER15_Pos = 0xf        // Position of SWIER15 field.
	EXTI_SWIER1_SWIER15_Msk = 0x8000     // Bit mask of SWIER15 field.
	EXTI_SWIER1_SWIER15     = 0x8000     // Bit SWIER15.
	EXTI_SWIER1_SWIER16_Pos = 0x10       // Position of SWIER16 field.
	EXTI_SWIER1_SWIER16_Msk = 0x10000    // Bit mask of SWIER16 field.
	EXTI_SWIER1_SWIER16     = 0x10000    // Bit SWIER16.
	EXTI_SWIER1_SWIER17_Pos = 0x11       // Position of SWIER17 field.
	EXTI_SWIER1_SWIER17_Msk = 0x20000    // Bit mask of SWIER17 field.
	EXTI_SWIER1_SWIER17     = 0x20000    // Bit SWIER17.
	EXTI_SWIER1_SWIER18_Pos = 0x12       // Position of SWIER18 field.
	EXTI_SWIER1_SWIER18_Msk = 0x40000    // Bit mask of SWIER18 field.
	EXTI_SWIER1_SWIER18     = 0x40000    // Bit SWIER18.
	EXTI_SWIER1_SWIER19_Pos = 0x13       // Position of SWIER19 field.
	EXTI_SWIER1_SWIER19_Msk = 0x80000    // Bit mask of SWIER19 field.
	EXTI_SWIER1_SWIER19     = 0x80000    // Bit SWIER19.
	EXTI_SWIER1_SWIER20_Pos = 0x14       // Position of SWIER20 field.
	EXTI_SWIER1_SWIER20_Msk = 0x100000   // Bit mask of SWIER20 field.
	EXTI_SWIER1_SWIER20     = 0x100000   // Bit SWIER20.
	EXTI_SWIER1_SWIER21_Pos = 0x15       // Position of SWIER21 field.
	EXTI_SWIER1_SWIER21_Msk = 0x200000   // Bit mask of SWIER21 field.
	EXTI_SWIER1_SWIER21     = 0x200000   // Bit SWIER21.
	EXTI_SWIER1_SWIER22_Pos = 0x16       // Position of SWIER22 field.
	EXTI_SWIER1_SWIER22_Msk = 0x400000   // Bit mask of SWIER22 field.
	EXTI_SWIER1_SWIER22     = 0x400000   // Bit SWIER22.
	EXTI_SWIER1_SWIER29_Pos = 0x1d       // Position of SWIER29 field.
	EXTI_SWIER1_SWIER29_Msk = 0x20000000 // Bit mask of SWIER29 field.
	EXTI_SWIER1_SWIER29     = 0x20000000 // Bit SWIER29.
	EXTI_SWIER1_SWIER30_Pos = 0x1e       // Position of SWIER30 field.
	EXTI_SWIER1_SWIER30_Msk = 0x40000000 // Bit mask of SWIER30 field.
	EXTI_SWIER1_SWIER30     = 0x40000000 // Bit SWIER30.
	EXTI_SWIER1_SWIER31_Pos = 0x1f       // Position of SWIER31 field.
	EXTI_SWIER1_SWIER31_Msk = 0x80000000 // Bit mask of SWIER31 field.
	EXTI_SWIER1_SWIER31     = 0x80000000 // Bit SWIER31.

	// PR1: Pending register
	EXTI_PR1_PR0_Pos  = 0x0        // Position of PR0 field.
	EXTI_PR1_PR0_Msk  = 0x1        // Bit mask of PR0 field.
	EXTI_PR1_PR0      = 0x1        // Bit PR0.
	EXTI_PR1_PR1_Pos  = 0x1        // Position of PR1 field.
	EXTI_PR1_PR1_Msk  = 0x2        // Bit mask of PR1 field.
	EXTI_PR1_PR1      = 0x2        // Bit PR1.
	EXTI_PR1_PR2_Pos  = 0x2        // Position of PR2 field.
	EXTI_PR1_PR2_Msk  = 0x4        // Bit mask of PR2 field.
	EXTI_PR1_PR2      = 0x4        // Bit PR2.
	EXTI_PR1_PR3_Pos  = 0x3        // Position of PR3 field.
	EXTI_PR1_PR3_Msk  = 0x8        // Bit mask of PR3 field.
	EXTI_PR1_PR3      = 0x8        // Bit PR3.
	EXTI_PR1_PR4_Pos  = 0x4        // Position of PR4 field.
	EXTI_PR1_PR4_Msk  = 0x10       // Bit mask of PR4 field.
	EXTI_PR1_PR4      = 0x10       // Bit PR4.
	EXTI_PR1_PR5_Pos  = 0x5        // Position of PR5 field.
	EXTI_PR1_PR5_Msk  = 0x20       // Bit mask of PR5 field.
	EXTI_PR1_PR5      = 0x20       // Bit PR5.
	EXTI_PR1_PR6_Pos  = 0x6        // Position of PR6 field.
	EXTI_PR1_PR6_Msk  = 0x40       // Bit mask of PR6 field.
	EXTI_PR1_PR6      = 0x40       // Bit PR6.
	EXTI_PR1_PR7_Pos  = 0x7        // Position of PR7 field.
	EXTI_PR1_PR7_Msk  = 0x80       // Bit mask of PR7 field.
	EXTI_PR1_PR7      = 0x80       // Bit PR7.
	EXTI_PR1_PR8_Pos  = 0x8        // Position of PR8 field.
	EXTI_PR1_PR8_Msk  = 0x100      // Bit mask of PR8 field.
	EXTI_PR1_PR8      = 0x100      // Bit PR8.
	EXTI_PR1_PR9_Pos  = 0x9        // Position of PR9 field.
	EXTI_PR1_PR9_Msk  = 0x200      // Bit mask of PR9 field.
	EXTI_PR1_PR9      = 0x200      // Bit PR9.
	EXTI_PR1_PR10_Pos = 0xa        // Position of PR10 field.
	EXTI_PR1_PR10_Msk = 0x400      // Bit mask of PR10 field.
	EXTI_PR1_PR10     = 0x400      // Bit PR10.
	EXTI_PR1_PR11_Pos = 0xb        // Position of PR11 field.
	EXTI_PR1_PR11_Msk = 0x800      // Bit mask of PR11 field.
	EXTI_PR1_PR11     = 0x800      // Bit PR11.
	EXTI_PR1_PR12_Pos = 0xc        // Position of PR12 field.
	EXTI_PR1_PR12_Msk = 0x1000     // Bit mask of PR12 field.
	EXTI_PR1_PR12     = 0x1000     // Bit PR12.
	EXTI_PR1_PR13_Pos = 0xd        // Position of PR13 field.
	EXTI_PR1_PR13_Msk = 0x2000     // Bit mask of PR13 field.
	EXTI_PR1_PR13     = 0x2000     // Bit PR13.
	EXTI_PR1_PR14_Pos = 0xe        // Position of PR14 field.
	EXTI_PR1_PR14_Msk = 0x4000     // Bit mask of PR14 field.
	EXTI_PR1_PR14     = 0x4000     // Bit PR14.
	EXTI_PR1_PR15_Pos = 0xf        // Position of PR15 field.
	EXTI_PR1_PR15_Msk = 0x8000     // Bit mask of PR15 field.
	EXTI_PR1_PR15     = 0x8000     // Bit PR15.
	EXTI_PR1_PR16_Pos = 0x10       // Position of PR16 field.
	EXTI_PR1_PR16_Msk = 0x10000    // Bit mask of PR16 field.
	EXTI_PR1_PR16     = 0x10000    // Bit PR16.
	EXTI_PR1_PR17_Pos = 0x11       // Position of PR17 field.
	EXTI_PR1_PR17_Msk = 0x20000    // Bit mask of PR17 field.
	EXTI_PR1_PR17     = 0x20000    // Bit PR17.
	EXTI_PR1_PR18_Pos = 0x12       // Position of PR18 field.
	EXTI_PR1_PR18_Msk = 0x40000    // Bit mask of PR18 field.
	EXTI_PR1_PR18     = 0x40000    // Bit PR18.
	EXTI_PR1_PR19_Pos = 0x13       // Position of PR19 field.
	EXTI_PR1_PR19_Msk = 0x80000    // Bit mask of PR19 field.
	EXTI_PR1_PR19     = 0x80000    // Bit PR19.
	EXTI_PR1_PR20_Pos = 0x14       // Position of PR20 field.
	EXTI_PR1_PR20_Msk = 0x100000   // Bit mask of PR20 field.
	EXTI_PR1_PR20     = 0x100000   // Bit PR20.
	EXTI_PR1_PR21_Pos = 0x15       // Position of PR21 field.
	EXTI_PR1_PR21_Msk = 0x200000   // Bit mask of PR21 field.
	EXTI_PR1_PR21     = 0x200000   // Bit PR21.
	EXTI_PR1_PR22_Pos = 0x16       // Position of PR22 field.
	EXTI_PR1_PR22_Msk = 0x400000   // Bit mask of PR22 field.
	EXTI_PR1_PR22     = 0x400000   // Bit PR22.
	EXTI_PR1_PR29_Pos = 0x1d       // Position of PR29 field.
	EXTI_PR1_PR29_Msk = 0x20000000 // Bit mask of PR29 field.
	EXTI_PR1_PR29     = 0x20000000 // Bit PR29.
	EXTI_PR1_PR30_Pos = 0x1e       // Position of PR30 field.
	EXTI_PR1_PR30_Msk = 0x40000000 // Bit mask of PR30 field.
	EXTI_PR1_PR30     = 0x40000000 // Bit PR30.
	EXTI_PR1_PR31_Pos = 0x1f       // Position of PR31 field.
	EXTI_PR1_PR31_Msk = 0x80000000 // Bit mask of PR31 field.
	EXTI_PR1_PR31     = 0x80000000 // Bit PR31.

	// IMR2: Interrupt mask register
	EXTI_IMR2_MR32_Pos = 0x0 // Position of MR32 field.
	EXTI_IMR2_MR32_Msk = 0x1 // Bit mask of MR32 field.
	EXTI_IMR2_MR32     = 0x1 // Bit MR32.
	EXTI_IMR2_MR33_Pos = 0x1 // Position of MR33 field.
	EXTI_IMR2_MR33_Msk = 0x2 // Bit mask of MR33 field.
	EXTI_IMR2_MR33     = 0x2 // Bit MR33.
	EXTI_IMR2_MR34_Pos = 0x2 // Position of MR34 field.
	EXTI_IMR2_MR34_Msk = 0x4 // Bit mask of MR34 field.
	EXTI_IMR2_MR34     = 0x4 // Bit MR34.
	EXTI_IMR2_MR35_Pos = 0x3 // Position of MR35 field.
	EXTI_IMR2_MR35_Msk = 0x8 // Bit mask of MR35 field.
	EXTI_IMR2_MR35     = 0x8 // Bit MR35.

	// EMR2: Event mask register
	EXTI_EMR2_MR32_Pos = 0x0 // Position of MR32 field.
	EXTI_EMR2_MR32_Msk = 0x1 // Bit mask of MR32 field.
	EXTI_EMR2_MR32     = 0x1 // Bit MR32.
	EXTI_EMR2_MR33_Pos = 0x1 // Position of MR33 field.
	EXTI_EMR2_MR33_Msk = 0x2 // Bit mask of MR33 field.
	EXTI_EMR2_MR33     = 0x2 // Bit MR33.
	EXTI_EMR2_MR34_Pos = 0x2 // Position of MR34 field.
	EXTI_EMR2_MR34_Msk = 0x4 // Bit mask of MR34 field.
	EXTI_EMR2_MR34     = 0x4 // Bit MR34.
	EXTI_EMR2_MR35_Pos = 0x3 // Position of MR35 field.
	EXTI_EMR2_MR35_Msk = 0x8 // Bit mask of MR35 field.
	EXTI_EMR2_MR35     = 0x8 // Bit MR35.

	// RTSR2: Rising Trigger selection           register
	EXTI_RTSR2_TR32_Pos = 0x0 // Position of TR32 field.
	EXTI_RTSR2_TR32_Msk = 0x1 // Bit mask of TR32 field.
	EXTI_RTSR2_TR32     = 0x1 // Bit TR32.
	EXTI_RTSR2_TR33_Pos = 0x1 // Position of TR33 field.
	EXTI_RTSR2_TR33_Msk = 0x2 // Bit mask of TR33 field.
	EXTI_RTSR2_TR33     = 0x2 // Bit TR33.

	// FTSR2: Falling Trigger selection           register
	EXTI_FTSR2_TR32_Pos = 0x0 // Position of TR32 field.
	EXTI_FTSR2_TR32_Msk = 0x1 // Bit mask of TR32 field.
	EXTI_FTSR2_TR32     = 0x1 // Bit TR32.
	EXTI_FTSR2_TR33_Pos = 0x1 // Position of TR33 field.
	EXTI_FTSR2_TR33_Msk = 0x2 // Bit mask of TR33 field.
	EXTI_FTSR2_TR33     = 0x2 // Bit TR33.

	// SWIER2: Software interrupt event           register
	EXTI_SWIER2_SWIER32_Pos = 0x0 // Position of SWIER32 field.
	EXTI_SWIER2_SWIER32_Msk = 0x1 // Bit mask of SWIER32 field.
	EXTI_SWIER2_SWIER32     = 0x1 // Bit SWIER32.
	EXTI_SWIER2_SWIER33_Pos = 0x1 // Position of SWIER33 field.
	EXTI_SWIER2_SWIER33_Msk = 0x2 // Bit mask of SWIER33 field.
	EXTI_SWIER2_SWIER33     = 0x2 // Bit SWIER33.

	// PR2: Pending register
	EXTI_PR2_PR32_Pos = 0x0 // Position of PR32 field.
	EXTI_PR2_PR32_Msk = 0x1 // Bit mask of PR32 field.
	EXTI_PR2_PR32     = 0x1 // Bit PR32.
	EXTI_PR2_PR33_Pos = 0x1 // Position of PR33 field.
	EXTI_PR2_PR33_Msk = 0x2 // Bit mask of PR33 field.
	EXTI_PR2_PR33     = 0x2 // Bit PR33.
)

// Bitfields for PWR: Power control
const (
	// CR: power control register
	PWR_CR_LPDS_Pos = 0x0   // Position of LPDS field.
	PWR_CR_LPDS_Msk = 0x1   // Bit mask of LPDS field.
	PWR_CR_LPDS     = 0x1   // Bit LPDS.
	PWR_CR_PDDS_Pos = 0x1   // Position of PDDS field.
	PWR_CR_PDDS_Msk = 0x2   // Bit mask of PDDS field.
	PWR_CR_PDDS     = 0x2   // Bit PDDS.
	PWR_CR_CWUF_Pos = 0x2   // Position of CWUF field.
	PWR_CR_CWUF_Msk = 0x4   // Bit mask of CWUF field.
	PWR_CR_CWUF     = 0x4   // Bit CWUF.
	PWR_CR_CSBF_Pos = 0x3   // Position of CSBF field.
	PWR_CR_CSBF_Msk = 0x8   // Bit mask of CSBF field.
	PWR_CR_CSBF     = 0x8   // Bit CSBF.
	PWR_CR_PVDE_Pos = 0x4   // Position of PVDE field.
	PWR_CR_PVDE_Msk = 0x10  // Bit mask of PVDE field.
	PWR_CR_PVDE     = 0x10  // Bit PVDE.
	PWR_CR_PLS_Pos  = 0x5   // Position of PLS field.
	PWR_CR_PLS_Msk  = 0xe0  // Bit mask of PLS field.
	PWR_CR_DBP_Pos  = 0x8   // Position of DBP field.
	PWR_CR_DBP_Msk  = 0x100 // Bit mask of DBP field.
	PWR_CR_DBP      = 0x100 // Bit DBP.

	// CSR: power control/status register
	PWR_CSR_WUF_Pos   = 0x0   // Position of WUF field.
	PWR_CSR_WUF_Msk   = 0x1   // Bit mask of WUF field.
	PWR_CSR_WUF       = 0x1   // Bit WUF.
	PWR_CSR_SBF_Pos   = 0x1   // Position of SBF field.
	PWR_CSR_SBF_Msk   = 0x2   // Bit mask of SBF field.
	PWR_CSR_SBF       = 0x2   // Bit SBF.
	PWR_CSR_PVDO_Pos  = 0x2   // Position of PVDO field.
	PWR_CSR_PVDO_Msk  = 0x4   // Bit mask of PVDO field.
	PWR_CSR_PVDO      = 0x4   // Bit PVDO.
	PWR_CSR_EWUP1_Pos = 0x8   // Position of EWUP1 field.
	PWR_CSR_EWUP1_Msk = 0x100 // Bit mask of EWUP1 field.
	PWR_CSR_EWUP1     = 0x100 // Bit EWUP1.
	PWR_CSR_EWUP2_Pos = 0x9   // Position of EWUP2 field.
	PWR_CSR_EWUP2_Msk = 0x200 // Bit mask of EWUP2 field.
	PWR_CSR_EWUP2     = 0x200 // Bit EWUP2.
)

// Bitfields for CAN: Controller area network
const (
	// MCR: master control register
	CAN_MCR_DBF_Pos   = 0x10    // Position of DBF field.
	CAN_MCR_DBF_Msk   = 0x10000 // Bit mask of DBF field.
	CAN_MCR_DBF       = 0x10000 // Bit DBF.
	CAN_MCR_RESET_Pos = 0xf     // Position of RESET field.
	CAN_MCR_RESET_Msk = 0x8000  // Bit mask of RESET field.
	CAN_MCR_RESET     = 0x8000  // Bit RESET.
	CAN_MCR_TTCM_Pos  = 0x7     // Position of TTCM field.
	CAN_MCR_TTCM_Msk  = 0x80    // Bit mask of TTCM field.
	CAN_MCR_TTCM      = 0x80    // Bit TTCM.
	CAN_MCR_ABOM_Pos  = 0x6     // Position of ABOM field.
	CAN_MCR_ABOM_Msk  = 0x40    // Bit mask of ABOM field.
	CAN_MCR_ABOM      = 0x40    // Bit ABOM.
	CAN_MCR_AWUM_Pos  = 0x5     // Position of AWUM field.
	CAN_MCR_AWUM_Msk  = 0x20    // Bit mask of AWUM field.
	CAN_MCR_AWUM      = 0x20    // Bit AWUM.
	CAN_MCR_NART_Pos  = 0x4     // Position of NART field.
	CAN_MCR_NART_Msk  = 0x10    // Bit mask of NART field.
	CAN_MCR_NART      = 0x10    // Bit NART.
	CAN_MCR_RFLM_Pos  = 0x3     // Position of RFLM field.
	CAN_MCR_RFLM_Msk  = 0x8     // Bit mask of RFLM field.
	CAN_MCR_RFLM      = 0x8     // Bit RFLM.
	CAN_MCR_TXFP_Pos  = 0x2     // Position of TXFP field.
	CAN_MCR_TXFP_Msk  = 0x4     // Bit mask of TXFP field.
	CAN_MCR_TXFP      = 0x4     // Bit TXFP.
	CAN_MCR_SLEEP_Pos = 0x1     // Position of SLEEP field.
	CAN_MCR_SLEEP_Msk = 0x2     // Bit mask of SLEEP field.
	CAN_MCR_SLEEP     = 0x2     // Bit SLEEP.
	CAN_MCR_INRQ_Pos  = 0x0     // Position of INRQ field.
	CAN_MCR_INRQ_Msk  = 0x1     // Bit mask of INRQ field.
	CAN_MCR_INRQ      = 0x1     // Bit INRQ.

	// MSR: master status register
	CAN_MSR_RX_Pos    = 0xb   // Position of RX field.
	CAN_MSR_RX_Msk    = 0x800 // Bit mask of RX field.
	CAN_MSR_RX        = 0x800 // Bit RX.
	CAN_MSR_SAMP_Pos  = 0xa   // Position of SAMP field.
	CAN_MSR_SAMP_Msk  = 0x400 // Bit mask of SAMP field.
	CAN_MSR_SAMP      = 0x400 // Bit SAMP.
	CAN_MSR_RXM_Pos   = 0x9   // Position of RXM field.
	CAN_MSR_RXM_Msk   = 0x200 // Bit mask of RXM field.
	CAN_MSR_RXM       = 0x200 // Bit RXM.
	CAN_MSR_TXM_Pos   = 0x8   // Position of TXM field.
	CAN_MSR_TXM_Msk   = 0x100 // Bit mask of TXM field.
	CAN_MSR_TXM       = 0x100 // Bit TXM.
	CAN_MSR_SLAKI_Pos = 0x4   // Position of SLAKI field.
	CAN_MSR_SLAKI_Msk = 0x10  // Bit mask of SLAKI field.
	CAN_MSR_SLAKI     = 0x10  // Bit SLAKI.
	CAN_MSR_WKUI_Pos  = 0x3   // Position of WKUI field.
	CAN_MSR_WKUI_Msk  = 0x8   // Bit mask of WKUI field.
	CAN_MSR_WKUI      = 0x8   // Bit WKUI.
	CAN_MSR_ERRI_Pos  = 0x2   // Position of ERRI field.
	CAN_MSR_ERRI_Msk  = 0x4   // Bit mask of ERRI field.
	CAN_MSR_ERRI      = 0x4   // Bit ERRI.
	CAN_MSR_SLAK_Pos  = 0x1   // Position of SLAK field.
	CAN_MSR_SLAK_Msk  = 0x2   // Bit mask of SLAK field.
	CAN_MSR_SLAK      = 0x2   // Bit SLAK.
	CAN_MSR_INAK_Pos  = 0x0   // Position of INAK field.
	CAN_MSR_INAK_Msk  = 0x1   // Bit mask of INAK field.
	CAN_MSR_INAK      = 0x1   // Bit INAK.

	// TSR: transmit status register
	CAN_TSR_LOW2_Pos  = 0x1f       // Position of LOW2 field.
	CAN_TSR_LOW2_Msk  = 0x80000000 // Bit mask of LOW2 field.
	CAN_TSR_LOW2      = 0x80000000 // Bit LOW2.
	CAN_TSR_LOW1_Pos  = 0x1e       // Position of LOW1 field.
	CAN_TSR_LOW1_Msk  = 0x40000000 // Bit mask of LOW1 field.
	CAN_TSR_LOW1      = 0x40000000 // Bit LOW1.
	CAN_TSR_LOW0_Pos  = 0x1d       // Position of LOW0 field.
	CAN_TSR_LOW0_Msk  = 0x20000000 // Bit mask of LOW0 field.
	CAN_TSR_LOW0      = 0x20000000 // Bit LOW0.
	CAN_TSR_TME2_Pos  = 0x1c       // Position of TME2 field.
	CAN_TSR_TME2_Msk  = 0x10000000 // Bit mask of TME2 field.
	CAN_TSR_TME2      = 0x10000000 // Bit TME2.
	CAN_TSR_TME1_Pos  = 0x1b       // Position of TME1 field.
	CAN_TSR_TME1_Msk  = 0x8000000  // Bit mask of TME1 field.
	CAN_TSR_TME1      = 0x8000000  // Bit TME1.
	CAN_TSR_TME0_Pos  = 0x1a       // Position of TME0 field.
	CAN_TSR_TME0_Msk  = 0x4000000  // Bit mask of TME0 field.
	CAN_TSR_TME0      = 0x4000000  // Bit TME0.
	CAN_TSR_CODE_Pos  = 0x18       // Position of CODE field.
	CAN_TSR_CODE_Msk  = 0x3000000  // Bit mask of CODE field.
	CAN_TSR_ABRQ2_Pos = 0x17       // Position of ABRQ2 field.
	CAN_TSR_ABRQ2_Msk = 0x800000   // Bit mask of ABRQ2 field.
	CAN_TSR_ABRQ2     = 0x800000   // Bit ABRQ2.
	CAN_TSR_TERR2_Pos = 0x13       // Position of TERR2 field.
	CAN_TSR_TERR2_Msk = 0x80000    // Bit mask of TERR2 field.
	CAN_TSR_TERR2     = 0x80000    // Bit TERR2.
	CAN_TSR_ALST2_Pos = 0x12       // Position of ALST2 field.
	CAN_TSR_ALST2_Msk = 0x40000    // Bit mask of ALST2 field.
	CAN_TSR_ALST2     = 0x40000    // Bit ALST2.
	CAN_TSR_TXOK2_Pos = 0x11       // Position of TXOK2 field.
	CAN_TSR_TXOK2_Msk = 0x20000    // Bit mask of TXOK2 field.
	CAN_TSR_TXOK2     = 0x20000    // Bit TXOK2.
	CAN_TSR_RQCP2_Pos = 0x10       // Position of RQCP2 field.
	CAN_TSR_RQCP2_Msk = 0x10000    // Bit mask of RQCP2 field.
	CAN_TSR_RQCP2     = 0x10000    // Bit RQCP2.
	CAN_TSR_ABRQ1_Pos = 0xf        // Position of ABRQ1 field.
	CAN_TSR_ABRQ1_Msk = 0x8000     // Bit mask of ABRQ1 field.
	CAN_TSR_ABRQ1     = 0x8000     // Bit ABRQ1.
	CAN_TSR_TERR1_Pos = 0xb        // Position of TERR1 field.
	CAN_TSR_TERR1_Msk = 0x800      // Bit mask of TERR1 field.
	CAN_TSR_TERR1     = 0x800      // Bit TERR1.
	CAN_TSR_ALST1_Pos = 0xa        // Position of ALST1 field.
	CAN_TSR_ALST1_Msk = 0x400      // Bit mask of ALST1 field.
	CAN_TSR_ALST1     = 0x400      // Bit ALST1.
	CAN_TSR_TXOK1_Pos = 0x9        // Position of TXOK1 field.
	CAN_TSR_TXOK1_Msk = 0x200      // Bit mask of TXOK1 field.
	CAN_TSR_TXOK1     = 0x200      // Bit TXOK1.
	CAN_TSR_RQCP1_Pos = 0x8        // Position of RQCP1 field.
	CAN_TSR_RQCP1_Msk = 0x100      // Bit mask of RQCP1 field.
	CAN_TSR_RQCP1     = 0x100      // Bit RQCP1.
	CAN_TSR_ABRQ0_Pos = 0x7        // Position of ABRQ0 field.
	CAN_TSR_ABRQ0_Msk = 0x80       // Bit mask of ABRQ0 field.
	CAN_TSR_ABRQ0     = 0x80       // Bit ABRQ0.
	CAN_TSR_TERR0_Pos = 0x3        // Position of TERR0 field.
	CAN_TSR_TERR0_Msk = 0x8        // Bit mask of TERR0 field.
	CAN_TSR_TERR0     = 0x8        // Bit TERR0.
	CAN_TSR_ALST0_Pos = 0x2        // Position of ALST0 field.
	CAN_TSR_ALST0_Msk = 0x4        // Bit mask of ALST0 field.
	CAN_TSR_ALST0     = 0x4        // Bit ALST0.
	CAN_TSR_TXOK0_Pos = 0x1        // Position of TXOK0 field.
	CAN_TSR_TXOK0_Msk = 0x2        // Bit mask of TXOK0 field.
	CAN_TSR_TXOK0     = 0x2        // Bit TXOK0.
	CAN_TSR_RQCP0_Pos = 0x0        // Position of RQCP0 field.
	CAN_TSR_RQCP0_Msk = 0x1        // Bit mask of RQCP0 field.
	CAN_TSR_RQCP0     = 0x1        // Bit RQCP0.

	// RF0R: receive FIFO 0 register
	CAN_RF0R_RFOM0_Pos = 0x5  // Position of RFOM0 field.
	CAN_RF0R_RFOM0_Msk = 0x20 // Bit mask of RFOM0 field.
	CAN_RF0R_RFOM0     = 0x20 // Bit RFOM0.
	CAN_RF0R_FOVR0_Pos = 0x4  // Position of FOVR0 field.
	CAN_RF0R_FOVR0_Msk = 0x10 // Bit mask of FOVR0 field.
	CAN_RF0R_FOVR0     = 0x10 // Bit FOVR0.
	CAN_RF0R_FULL0_Pos = 0x3  // Position of FULL0 field.
	CAN_RF0R_FULL0_Msk = 0x8  // Bit mask of FULL0 field.
	CAN_RF0R_FULL0     = 0x8  // Bit FULL0.
	CAN_RF0R_FMP0_Pos  = 0x0  // Position of FMP0 field.
	CAN_RF0R_FMP0_Msk  = 0x3  // Bit mask of FMP0 field.

	// RF1R: receive FIFO 1 register
	CAN_RF1R_RFOM1_Pos = 0x5  // Position of RFOM1 field.
	CAN_RF1R_RFOM1_Msk = 0x20 // Bit mask of RFOM1 field.
	CAN_RF1R_RFOM1     = 0x20 // Bit RFOM1.
	CAN_RF1R_FOVR1_Pos = 0x4  // Position of FOVR1 field.
	CAN_RF1R_FOVR1_Msk = 0x10 // Bit mask of FOVR1 field.
	CAN_RF1R_FOVR1     = 0x10 // Bit FOVR1.
	CAN_RF1R_FULL1_Pos = 0x3  // Position of FULL1 field.
	CAN_RF1R_FULL1_Msk = 0x8  // Bit mask of FULL1 field.
	CAN_RF1R_FULL1     = 0x8  // Bit FULL1.
	CAN_RF1R_FMP1_Pos  = 0x0  // Position of FMP1 field.
	CAN_RF1R_FMP1_Msk  = 0x3  // Bit mask of FMP1 field.

	// IER: interrupt enable register
	CAN_IER_SLKIE_Pos  = 0x11    // Position of SLKIE field.
	CAN_IER_SLKIE_Msk  = 0x20000 // Bit mask of SLKIE field.
	CAN_IER_SLKIE      = 0x20000 // Bit SLKIE.
	CAN_IER_WKUIE_Pos  = 0x10    // Position of WKUIE field.
	CAN_IER_WKUIE_Msk  = 0x10000 // Bit mask of WKUIE field.
	CAN_IER_WKUIE      = 0x10000 // Bit WKUIE.
	CAN_IER_ERRIE_Pos  = 0xf     // Position of ERRIE field.
	CAN_IER_ERRIE_Msk  = 0x8000  // Bit mask of ERRIE field.
	CAN_IER_ERRIE      = 0x8000  // Bit ERRIE.
	CAN_IER_LECIE_Pos  = 0xb     // Position of LECIE field.
	CAN_IER_LECIE_Msk  = 0x800   // Bit mask of LECIE field.
	CAN_IER_LECIE      = 0x800   // Bit LECIE.
	CAN_IER_BOFIE_Pos  = 0xa     // Position of BOFIE field.
	CAN_IER_BOFIE_Msk  = 0x400   // Bit mask of BOFIE field.
	CAN_IER_BOFIE      = 0x400   // Bit BOFIE.
	CAN_IER_EPVIE_Pos  = 0x9     // Position of EPVIE field.
	CAN_IER_EPVIE_Msk  = 0x200   // Bit mask of EPVIE field.
	CAN_IER_EPVIE      = 0x200   // Bit EPVIE.
	CAN_IER_EWGIE_Pos  = 0x8     // Position of EWGIE field.
	CAN_IER_EWGIE_Msk  = 0x100   // Bit mask of EWGIE field.
	CAN_IER_EWGIE      = 0x100   // Bit EWGIE.
	CAN_IER_FOVIE1_Pos = 0x6     // Position of FOVIE1 field.
	CAN_IER_FOVIE1_Msk = 0x40    // Bit mask of FOVIE1 field.
	CAN_IER_FOVIE1     = 0x40    // Bit FOVIE1.
	CAN_IER_FFIE1_Pos  = 0x5     // Position of FFIE1 field.
	CAN_IER_FFIE1_Msk  = 0x20    // Bit mask of FFIE1 field.
	CAN_IER_FFIE1      = 0x20    // Bit FFIE1.
	CAN_IER_FMPIE1_Pos = 0x4     // Position of FMPIE1 field.
	CAN_IER_FMPIE1_Msk = 0x10    // Bit mask of FMPIE1 field.
	CAN_IER_FMPIE1     = 0x10    // Bit FMPIE1.
	CAN_IER_FOVIE0_Pos = 0x3     // Position of FOVIE0 field.
	CAN_IER_FOVIE0_Msk = 0x8     // Bit mask of FOVIE0 field.
	CAN_IER_FOVIE0     = 0x8     // Bit FOVIE0.
	CAN_IER_FFIE0_Pos  = 0x2     // Position of FFIE0 field.
	CAN_IER_FFIE0_Msk  = 0x4     // Bit mask of FFIE0 field.
	CAN_IER_FFIE0      = 0x4     // Bit FFIE0.
	CAN_IER_FMPIE0_Pos = 0x1     // Position of FMPIE0 field.
	CAN_IER_FMPIE0_Msk = 0x2     // Bit mask of FMPIE0 field.
	CAN_IER_FMPIE0     = 0x2     // Bit FMPIE0.
	CAN_IER_TMEIE_Pos  = 0x0     // Position of TMEIE field.
	CAN_IER_TMEIE_Msk  = 0x1     // Bit mask of TMEIE field.
	CAN_IER_TMEIE      = 0x1     // Bit TMEIE.

	// ESR: error status register
	CAN_ESR_REC_Pos  = 0x18       // Position of REC field.
	CAN_ESR_REC_Msk  = 0xff000000 // Bit mask of REC field.
	CAN_ESR_TEC_Pos  = 0x10       // Position of TEC field.
	CAN_ESR_TEC_Msk  = 0xff0000   // Bit mask of TEC field.
	CAN_ESR_LEC_Pos  = 0x4        // Position of LEC field.
	CAN_ESR_LEC_Msk  = 0x70       // Bit mask of LEC field.
	CAN_ESR_BOFF_Pos = 0x2        // Position of BOFF field.
	CAN_ESR_BOFF_Msk = 0x4        // Bit mask of BOFF field.
	CAN_ESR_BOFF     = 0x4        // Bit BOFF.
	CAN_ESR_EPVF_Pos = 0x1        // Position of EPVF field.
	CAN_ESR_EPVF_Msk = 0x2        // Bit mask of EPVF field.
	CAN_ESR_EPVF     = 0x2        // Bit EPVF.
	CAN_ESR_EWGF_Pos = 0x0        // Position of EWGF field.
	CAN_ESR_EWGF_Msk = 0x1        // Bit mask of EWGF field.
	CAN_ESR_EWGF     = 0x1        // Bit EWGF.

	// BTR: bit timing register
	CAN_BTR_SILM_Pos = 0x1f       // Position of SILM field.
	CAN_BTR_SILM_Msk = 0x80000000 // Bit mask of SILM field.
	CAN_BTR_SILM     = 0x80000000 // Bit SILM.
	CAN_BTR_LBKM_Pos = 0x1e       // Position of LBKM field.
	CAN_BTR_LBKM_Msk = 0x40000000 // Bit mask of LBKM field.
	CAN_BTR_LBKM     = 0x40000000 // Bit LBKM.
	CAN_BTR_SJW_Pos  = 0x18       // Position of SJW field.
	CAN_BTR_SJW_Msk  = 0x3000000  // Bit mask of SJW field.
	CAN_BTR_TS2_Pos  = 0x14       // Position of TS2 field.
	CAN_BTR_TS2_Msk  = 0x700000   // Bit mask of TS2 field.
	CAN_BTR_TS1_Pos  = 0x10       // Position of TS1 field.
	CAN_BTR_TS1_Msk  = 0xf0000    // Bit mask of TS1 field.
	CAN_BTR_BRP_Pos  = 0x0        // Position of BRP field.
	CAN_BTR_BRP_Msk  = 0x3ff      // Bit mask of BRP field.

	// TI0R: TX mailbox identifier register
	CAN_TI0R_STID_Pos = 0x15       // Position of STID field.
	CAN_TI0R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_TI0R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_TI0R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_TI0R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_TI0R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_TI0R_IDE      = 0x4        // Bit IDE.
	CAN_TI0R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_TI0R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_TI0R_RTR      = 0x2        // Bit RTR.
	CAN_TI0R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_TI0R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_TI0R_TXRQ     = 0x1        // Bit TXRQ.

	// TDT0R: mailbox data length control and time stamp           register
	CAN_TDT0R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_TDT0R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_TDT0R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_TDT0R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_TDT0R_TGT      = 0x100      // Bit TGT.
	CAN_TDT0R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_TDT0R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// TDL0R: mailbox data low register
	CAN_TDL0R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_TDL0R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_TDL0R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_TDL0R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_TDL0R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_TDL0R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_TDL0R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_TDL0R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// TDH0R: mailbox data high register
	CAN_TDH0R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_TDH0R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_TDH0R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_TDH0R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_TDH0R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_TDH0R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_TDH0R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_TDH0R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// TI1R: TX mailbox identifier register
	CAN_TI1R_STID_Pos = 0x15       // Position of STID field.
	CAN_TI1R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_TI1R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_TI1R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_TI1R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_TI1R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_TI1R_IDE      = 0x4        // Bit IDE.
	CAN_TI1R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_TI1R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_TI1R_RTR      = 0x2        // Bit RTR.
	CAN_TI1R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_TI1R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_TI1R_TXRQ     = 0x1        // Bit TXRQ.

	// TDT1R: mailbox data length control and time stamp           register
	CAN_TDT1R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_TDT1R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_TDT1R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_TDT1R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_TDT1R_TGT      = 0x100      // Bit TGT.
	CAN_TDT1R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_TDT1R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// TDL1R: mailbox data low register
	CAN_TDL1R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_TDL1R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_TDL1R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_TDL1R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_TDL1R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_TDL1R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_TDL1R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_TDL1R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// TDH1R: mailbox data high register
	CAN_TDH1R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_TDH1R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_TDH1R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_TDH1R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_TDH1R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_TDH1R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_TDH1R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_TDH1R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// TI2R: TX mailbox identifier register
	CAN_TI2R_STID_Pos = 0x15       // Position of STID field.
	CAN_TI2R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_TI2R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_TI2R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_TI2R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_TI2R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_TI2R_IDE      = 0x4        // Bit IDE.
	CAN_TI2R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_TI2R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_TI2R_RTR      = 0x2        // Bit RTR.
	CAN_TI2R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_TI2R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_TI2R_TXRQ     = 0x1        // Bit TXRQ.

	// TDT2R: mailbox data length control and time stamp           register
	CAN_TDT2R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_TDT2R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_TDT2R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_TDT2R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_TDT2R_TGT      = 0x100      // Bit TGT.
	CAN_TDT2R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_TDT2R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// TDL2R: mailbox data low register
	CAN_TDL2R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_TDL2R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_TDL2R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_TDL2R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_TDL2R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_TDL2R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_TDL2R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_TDL2R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// TDH2R: mailbox data high register
	CAN_TDH2R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_TDH2R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_TDH2R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_TDH2R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_TDH2R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_TDH2R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_TDH2R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_TDH2R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// RI0R: receive FIFO mailbox identifier           register
	CAN_RI0R_STID_Pos = 0x15       // Position of STID field.
	CAN_RI0R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_RI0R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_RI0R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_RI0R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_RI0R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_RI0R_IDE      = 0x4        // Bit IDE.
	CAN_RI0R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_RI0R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_RI0R_RTR      = 0x2        // Bit RTR.

	// RDT0R: receive FIFO mailbox data length control and           time stamp register
	CAN_RDT0R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_RDT0R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_RDT0R_FMI_Pos  = 0x8        // Position of FMI field.
	CAN_RDT0R_FMI_Msk  = 0xff00     // Bit mask of FMI field.
	CAN_RDT0R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_RDT0R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// RDL0R: receive FIFO mailbox data low           register
	CAN_RDL0R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_RDL0R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_RDL0R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_RDL0R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_RDL0R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_RDL0R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_RDL0R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_RDL0R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// RDH0R: receive FIFO mailbox data high           register
	CAN_RDH0R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_RDH0R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_RDH0R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_RDH0R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_RDH0R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_RDH0R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_RDH0R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_RDH0R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// RI1R: receive FIFO mailbox identifier           register
	CAN_RI1R_STID_Pos = 0x15       // Position of STID field.
	CAN_RI1R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_RI1R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_RI1R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_RI1R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_RI1R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_RI1R_IDE      = 0x4        // Bit IDE.
	CAN_RI1R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_RI1R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_RI1R_RTR      = 0x2        // Bit RTR.

	// RDT1R: receive FIFO mailbox data length control and           time stamp register
	CAN_RDT1R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_RDT1R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_RDT1R_FMI_Pos  = 0x8        // Position of FMI field.
	CAN_RDT1R_FMI_Msk  = 0xff00     // Bit mask of FMI field.
	CAN_RDT1R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_RDT1R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// RDL1R: receive FIFO mailbox data low           register
	CAN_RDL1R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_RDL1R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_RDL1R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_RDL1R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_RDL1R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_RDL1R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_RDL1R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_RDL1R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// RDH1R: receive FIFO mailbox data high           register
	CAN_RDH1R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_RDH1R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_RDH1R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_RDH1R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_RDH1R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_RDH1R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_RDH1R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_RDH1R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// FMR: filter master register
	CAN_FMR_CAN2SB_Pos = 0x8    // Position of CAN2SB field.
	CAN_FMR_CAN2SB_Msk = 0x3f00 // Bit mask of CAN2SB field.
	CAN_FMR_FINIT_Pos  = 0x0    // Position of FINIT field.
	CAN_FMR_FINIT_Msk  = 0x1    // Bit mask of FINIT field.
	CAN_FMR_FINIT      = 0x1    // Bit FINIT.

	// FM1R: filter mode register
	CAN_FM1R_FBM0_Pos  = 0x0       // Position of FBM0 field.
	CAN_FM1R_FBM0_Msk  = 0x1       // Bit mask of FBM0 field.
	CAN_FM1R_FBM0      = 0x1       // Bit FBM0.
	CAN_FM1R_FBM1_Pos  = 0x1       // Position of FBM1 field.
	CAN_FM1R_FBM1_Msk  = 0x2       // Bit mask of FBM1 field.
	CAN_FM1R_FBM1      = 0x2       // Bit FBM1.
	CAN_FM1R_FBM2_Pos  = 0x2       // Position of FBM2 field.
	CAN_FM1R_FBM2_Msk  = 0x4       // Bit mask of FBM2 field.
	CAN_FM1R_FBM2      = 0x4       // Bit FBM2.
	CAN_FM1R_FBM3_Pos  = 0x3       // Position of FBM3 field.
	CAN_FM1R_FBM3_Msk  = 0x8       // Bit mask of FBM3 field.
	CAN_FM1R_FBM3      = 0x8       // Bit FBM3.
	CAN_FM1R_FBM4_Pos  = 0x4       // Position of FBM4 field.
	CAN_FM1R_FBM4_Msk  = 0x10      // Bit mask of FBM4 field.
	CAN_FM1R_FBM4      = 0x10      // Bit FBM4.
	CAN_FM1R_FBM5_Pos  = 0x5       // Position of FBM5 field.
	CAN_FM1R_FBM5_Msk  = 0x20      // Bit mask of FBM5 field.
	CAN_FM1R_FBM5      = 0x20      // Bit FBM5.
	CAN_FM1R_FBM6_Pos  = 0x6       // Position of FBM6 field.
	CAN_FM1R_FBM6_Msk  = 0x40      // Bit mask of FBM6 field.
	CAN_FM1R_FBM6      = 0x40      // Bit FBM6.
	CAN_FM1R_FBM7_Pos  = 0x7       // Position of FBM7 field.
	CAN_FM1R_FBM7_Msk  = 0x80      // Bit mask of FBM7 field.
	CAN_FM1R_FBM7      = 0x80      // Bit FBM7.
	CAN_FM1R_FBM8_Pos  = 0x8       // Position of FBM8 field.
	CAN_FM1R_FBM8_Msk  = 0x100     // Bit mask of FBM8 field.
	CAN_FM1R_FBM8      = 0x100     // Bit FBM8.
	CAN_FM1R_FBM9_Pos  = 0x9       // Position of FBM9 field.
	CAN_FM1R_FBM9_Msk  = 0x200     // Bit mask of FBM9 field.
	CAN_FM1R_FBM9      = 0x200     // Bit FBM9.
	CAN_FM1R_FBM10_Pos = 0xa       // Position of FBM10 field.
	CAN_FM1R_FBM10_Msk = 0x400     // Bit mask of FBM10 field.
	CAN_FM1R_FBM10     = 0x400     // Bit FBM10.
	CAN_FM1R_FBM11_Pos = 0xb       // Position of FBM11 field.
	CAN_FM1R_FBM11_Msk = 0x800     // Bit mask of FBM11 field.
	CAN_FM1R_FBM11     = 0x800     // Bit FBM11.
	CAN_FM1R_FBM12_Pos = 0xc       // Position of FBM12 field.
	CAN_FM1R_FBM12_Msk = 0x1000    // Bit mask of FBM12 field.
	CAN_FM1R_FBM12     = 0x1000    // Bit FBM12.
	CAN_FM1R_FBM13_Pos = 0xd       // Position of FBM13 field.
	CAN_FM1R_FBM13_Msk = 0x2000    // Bit mask of FBM13 field.
	CAN_FM1R_FBM13     = 0x2000    // Bit FBM13.
	CAN_FM1R_FBM14_Pos = 0xe       // Position of FBM14 field.
	CAN_FM1R_FBM14_Msk = 0x4000    // Bit mask of FBM14 field.
	CAN_FM1R_FBM14     = 0x4000    // Bit FBM14.
	CAN_FM1R_FBM15_Pos = 0xf       // Position of FBM15 field.
	CAN_FM1R_FBM15_Msk = 0x8000    // Bit mask of FBM15 field.
	CAN_FM1R_FBM15     = 0x8000    // Bit FBM15.
	CAN_FM1R_FBM16_Pos = 0x10      // Position of FBM16 field.
	CAN_FM1R_FBM16_Msk = 0x10000   // Bit mask of FBM16 field.
	CAN_FM1R_FBM16     = 0x10000   // Bit FBM16.
	CAN_FM1R_FBM17_Pos = 0x11      // Position of FBM17 field.
	CAN_FM1R_FBM17_Msk = 0x20000   // Bit mask of FBM17 field.
	CAN_FM1R_FBM17     = 0x20000   // Bit FBM17.
	CAN_FM1R_FBM18_Pos = 0x12      // Position of FBM18 field.
	CAN_FM1R_FBM18_Msk = 0x40000   // Bit mask of FBM18 field.
	CAN_FM1R_FBM18     = 0x40000   // Bit FBM18.
	CAN_FM1R_FBM19_Pos = 0x13      // Position of FBM19 field.
	CAN_FM1R_FBM19_Msk = 0x80000   // Bit mask of FBM19 field.
	CAN_FM1R_FBM19     = 0x80000   // Bit FBM19.
	CAN_FM1R_FBM20_Pos = 0x14      // Position of FBM20 field.
	CAN_FM1R_FBM20_Msk = 0x100000  // Bit mask of FBM20 field.
	CAN_FM1R_FBM20     = 0x100000  // Bit FBM20.
	CAN_FM1R_FBM21_Pos = 0x15      // Position of FBM21 field.
	CAN_FM1R_FBM21_Msk = 0x200000  // Bit mask of FBM21 field.
	CAN_FM1R_FBM21     = 0x200000  // Bit FBM21.
	CAN_FM1R_FBM22_Pos = 0x16      // Position of FBM22 field.
	CAN_FM1R_FBM22_Msk = 0x400000  // Bit mask of FBM22 field.
	CAN_FM1R_FBM22     = 0x400000  // Bit FBM22.
	CAN_FM1R_FBM23_Pos = 0x17      // Position of FBM23 field.
	CAN_FM1R_FBM23_Msk = 0x800000  // Bit mask of FBM23 field.
	CAN_FM1R_FBM23     = 0x800000  // Bit FBM23.
	CAN_FM1R_FBM24_Pos = 0x18      // Position of FBM24 field.
	CAN_FM1R_FBM24_Msk = 0x1000000 // Bit mask of FBM24 field.
	CAN_FM1R_FBM24     = 0x1000000 // Bit FBM24.
	CAN_FM1R_FBM25_Pos = 0x19      // Position of FBM25 field.
	CAN_FM1R_FBM25_Msk = 0x2000000 // Bit mask of FBM25 field.
	CAN_FM1R_FBM25     = 0x2000000 // Bit FBM25.
	CAN_FM1R_FBM26_Pos = 0x1a      // Position of FBM26 field.
	CAN_FM1R_FBM26_Msk = 0x4000000 // Bit mask of FBM26 field.
	CAN_FM1R_FBM26     = 0x4000000 // Bit FBM26.
	CAN_FM1R_FBM27_Pos = 0x1b      // Position of FBM27 field.
	CAN_FM1R_FBM27_Msk = 0x8000000 // Bit mask of FBM27 field.
	CAN_FM1R_FBM27     = 0x8000000 // Bit FBM27.

	// FS1R: filter scale register
	CAN_FS1R_FSC0_Pos  = 0x0       // Position of FSC0 field.
	CAN_FS1R_FSC0_Msk  = 0x1       // Bit mask of FSC0 field.
	CAN_FS1R_FSC0      = 0x1       // Bit FSC0.
	CAN_FS1R_FSC1_Pos  = 0x1       // Position of FSC1 field.
	CAN_FS1R_FSC1_Msk  = 0x2       // Bit mask of FSC1 field.
	CAN_FS1R_FSC1      = 0x2       // Bit FSC1.
	CAN_FS1R_FSC2_Pos  = 0x2       // Position of FSC2 field.
	CAN_FS1R_FSC2_Msk  = 0x4       // Bit mask of FSC2 field.
	CAN_FS1R_FSC2      = 0x4       // Bit FSC2.
	CAN_FS1R_FSC3_Pos  = 0x3       // Position of FSC3 field.
	CAN_FS1R_FSC3_Msk  = 0x8       // Bit mask of FSC3 field.
	CAN_FS1R_FSC3      = 0x8       // Bit FSC3.
	CAN_FS1R_FSC4_Pos  = 0x4       // Position of FSC4 field.
	CAN_FS1R_FSC4_Msk  = 0x10      // Bit mask of FSC4 field.
	CAN_FS1R_FSC4      = 0x10      // Bit FSC4.
	CAN_FS1R_FSC5_Pos  = 0x5       // Position of FSC5 field.
	CAN_FS1R_FSC5_Msk  = 0x20      // Bit mask of FSC5 field.
	CAN_FS1R_FSC5      = 0x20      // Bit FSC5.
	CAN_FS1R_FSC6_Pos  = 0x6       // Position of FSC6 field.
	CAN_FS1R_FSC6_Msk  = 0x40      // Bit mask of FSC6 field.
	CAN_FS1R_FSC6      = 0x40      // Bit FSC6.
	CAN_FS1R_FSC7_Pos  = 0x7       // Position of FSC7 field.
	CAN_FS1R_FSC7_Msk  = 0x80      // Bit mask of FSC7 field.
	CAN_FS1R_FSC7      = 0x80      // Bit FSC7.
	CAN_FS1R_FSC8_Pos  = 0x8       // Position of FSC8 field.
	CAN_FS1R_FSC8_Msk  = 0x100     // Bit mask of FSC8 field.
	CAN_FS1R_FSC8      = 0x100     // Bit FSC8.
	CAN_FS1R_FSC9_Pos  = 0x9       // Position of FSC9 field.
	CAN_FS1R_FSC9_Msk  = 0x200     // Bit mask of FSC9 field.
	CAN_FS1R_FSC9      = 0x200     // Bit FSC9.
	CAN_FS1R_FSC10_Pos = 0xa       // Position of FSC10 field.
	CAN_FS1R_FSC10_Msk = 0x400     // Bit mask of FSC10 field.
	CAN_FS1R_FSC10     = 0x400     // Bit FSC10.
	CAN_FS1R_FSC11_Pos = 0xb       // Position of FSC11 field.
	CAN_FS1R_FSC11_Msk = 0x800     // Bit mask of FSC11 field.
	CAN_FS1R_FSC11     = 0x800     // Bit FSC11.
	CAN_FS1R_FSC12_Pos = 0xc       // Position of FSC12 field.
	CAN_FS1R_FSC12_Msk = 0x1000    // Bit mask of FSC12 field.
	CAN_FS1R_FSC12     = 0x1000    // Bit FSC12.
	CAN_FS1R_FSC13_Pos = 0xd       // Position of FSC13 field.
	CAN_FS1R_FSC13_Msk = 0x2000    // Bit mask of FSC13 field.
	CAN_FS1R_FSC13     = 0x2000    // Bit FSC13.
	CAN_FS1R_FSC14_Pos = 0xe       // Position of FSC14 field.
	CAN_FS1R_FSC14_Msk = 0x4000    // Bit mask of FSC14 field.
	CAN_FS1R_FSC14     = 0x4000    // Bit FSC14.
	CAN_FS1R_FSC15_Pos = 0xf       // Position of FSC15 field.
	CAN_FS1R_FSC15_Msk = 0x8000    // Bit mask of FSC15 field.
	CAN_FS1R_FSC15     = 0x8000    // Bit FSC15.
	CAN_FS1R_FSC16_Pos = 0x10      // Position of FSC16 field.
	CAN_FS1R_FSC16_Msk = 0x10000   // Bit mask of FSC16 field.
	CAN_FS1R_FSC16     = 0x10000   // Bit FSC16.
	CAN_FS1R_FSC17_Pos = 0x11      // Position of FSC17 field.
	CAN_FS1R_FSC17_Msk = 0x20000   // Bit mask of FSC17 field.
	CAN_FS1R_FSC17     = 0x20000   // Bit FSC17.
	CAN_FS1R_FSC18_Pos = 0x12      // Position of FSC18 field.
	CAN_FS1R_FSC18_Msk = 0x40000   // Bit mask of FSC18 field.
	CAN_FS1R_FSC18     = 0x40000   // Bit FSC18.
	CAN_FS1R_FSC19_Pos = 0x13      // Position of FSC19 field.
	CAN_FS1R_FSC19_Msk = 0x80000   // Bit mask of FSC19 field.
	CAN_FS1R_FSC19     = 0x80000   // Bit FSC19.
	CAN_FS1R_FSC20_Pos = 0x14      // Position of FSC20 field.
	CAN_FS1R_FSC20_Msk = 0x100000  // Bit mask of FSC20 field.
	CAN_FS1R_FSC20     = 0x100000  // Bit FSC20.
	CAN_FS1R_FSC21_Pos = 0x15      // Position of FSC21 field.
	CAN_FS1R_FSC21_Msk = 0x200000  // Bit mask of FSC21 field.
	CAN_FS1R_FSC21     = 0x200000  // Bit FSC21.
	CAN_FS1R_FSC22_Pos = 0x16      // Position of FSC22 field.
	CAN_FS1R_FSC22_Msk = 0x400000  // Bit mask of FSC22 field.
	CAN_FS1R_FSC22     = 0x400000  // Bit FSC22.
	CAN_FS1R_FSC23_Pos = 0x17      // Position of FSC23 field.
	CAN_FS1R_FSC23_Msk = 0x800000  // Bit mask of FSC23 field.
	CAN_FS1R_FSC23     = 0x800000  // Bit FSC23.
	CAN_FS1R_FSC24_Pos = 0x18      // Position of FSC24 field.
	CAN_FS1R_FSC24_Msk = 0x1000000 // Bit mask of FSC24 field.
	CAN_FS1R_FSC24     = 0x1000000 // Bit FSC24.
	CAN_FS1R_FSC25_Pos = 0x19      // Position of FSC25 field.
	CAN_FS1R_FSC25_Msk = 0x2000000 // Bit mask of FSC25 field.
	CAN_FS1R_FSC25     = 0x2000000 // Bit FSC25.
	CAN_FS1R_FSC26_Pos = 0x1a      // Position of FSC26 field.
	CAN_FS1R_FSC26_Msk = 0x4000000 // Bit mask of FSC26 field.
	CAN_FS1R_FSC26     = 0x4000000 // Bit FSC26.
	CAN_FS1R_FSC27_Pos = 0x1b      // Position of FSC27 field.
	CAN_FS1R_FSC27_Msk = 0x8000000 // Bit mask of FSC27 field.
	CAN_FS1R_FSC27     = 0x8000000 // Bit FSC27.

	// FFA1R: filter FIFO assignment           register
	CAN_FFA1R_FFA0_Pos  = 0x0       // Position of FFA0 field.
	CAN_FFA1R_FFA0_Msk  = 0x1       // Bit mask of FFA0 field.
	CAN_FFA1R_FFA0      = 0x1       // Bit FFA0.
	CAN_FFA1R_FFA1_Pos  = 0x1       // Position of FFA1 field.
	CAN_FFA1R_FFA1_Msk  = 0x2       // Bit mask of FFA1 field.
	CAN_FFA1R_FFA1      = 0x2       // Bit FFA1.
	CAN_FFA1R_FFA2_Pos  = 0x2       // Position of FFA2 field.
	CAN_FFA1R_FFA2_Msk  = 0x4       // Bit mask of FFA2 field.
	CAN_FFA1R_FFA2      = 0x4       // Bit FFA2.
	CAN_FFA1R_FFA3_Pos  = 0x3       // Position of FFA3 field.
	CAN_FFA1R_FFA3_Msk  = 0x8       // Bit mask of FFA3 field.
	CAN_FFA1R_FFA3      = 0x8       // Bit FFA3.
	CAN_FFA1R_FFA4_Pos  = 0x4       // Position of FFA4 field.
	CAN_FFA1R_FFA4_Msk  = 0x10      // Bit mask of FFA4 field.
	CAN_FFA1R_FFA4      = 0x10      // Bit FFA4.
	CAN_FFA1R_FFA5_Pos  = 0x5       // Position of FFA5 field.
	CAN_FFA1R_FFA5_Msk  = 0x20      // Bit mask of FFA5 field.
	CAN_FFA1R_FFA5      = 0x20      // Bit FFA5.
	CAN_FFA1R_FFA6_Pos  = 0x6       // Position of FFA6 field.
	CAN_FFA1R_FFA6_Msk  = 0x40      // Bit mask of FFA6 field.
	CAN_FFA1R_FFA6      = 0x40      // Bit FFA6.
	CAN_FFA1R_FFA7_Pos  = 0x7       // Position of FFA7 field.
	CAN_FFA1R_FFA7_Msk  = 0x80      // Bit mask of FFA7 field.
	CAN_FFA1R_FFA7      = 0x80      // Bit FFA7.
	CAN_FFA1R_FFA8_Pos  = 0x8       // Position of FFA8 field.
	CAN_FFA1R_FFA8_Msk  = 0x100     // Bit mask of FFA8 field.
	CAN_FFA1R_FFA8      = 0x100     // Bit FFA8.
	CAN_FFA1R_FFA9_Pos  = 0x9       // Position of FFA9 field.
	CAN_FFA1R_FFA9_Msk  = 0x200     // Bit mask of FFA9 field.
	CAN_FFA1R_FFA9      = 0x200     // Bit FFA9.
	CAN_FFA1R_FFA10_Pos = 0xa       // Position of FFA10 field.
	CAN_FFA1R_FFA10_Msk = 0x400     // Bit mask of FFA10 field.
	CAN_FFA1R_FFA10     = 0x400     // Bit FFA10.
	CAN_FFA1R_FFA11_Pos = 0xb       // Position of FFA11 field.
	CAN_FFA1R_FFA11_Msk = 0x800     // Bit mask of FFA11 field.
	CAN_FFA1R_FFA11     = 0x800     // Bit FFA11.
	CAN_FFA1R_FFA12_Pos = 0xc       // Position of FFA12 field.
	CAN_FFA1R_FFA12_Msk = 0x1000    // Bit mask of FFA12 field.
	CAN_FFA1R_FFA12     = 0x1000    // Bit FFA12.
	CAN_FFA1R_FFA13_Pos = 0xd       // Position of FFA13 field.
	CAN_FFA1R_FFA13_Msk = 0x2000    // Bit mask of FFA13 field.
	CAN_FFA1R_FFA13     = 0x2000    // Bit FFA13.
	CAN_FFA1R_FFA14_Pos = 0xe       // Position of FFA14 field.
	CAN_FFA1R_FFA14_Msk = 0x4000    // Bit mask of FFA14 field.
	CAN_FFA1R_FFA14     = 0x4000    // Bit FFA14.
	CAN_FFA1R_FFA15_Pos = 0xf       // Position of FFA15 field.
	CAN_FFA1R_FFA15_Msk = 0x8000    // Bit mask of FFA15 field.
	CAN_FFA1R_FFA15     = 0x8000    // Bit FFA15.
	CAN_FFA1R_FFA16_Pos = 0x10      // Position of FFA16 field.
	CAN_FFA1R_FFA16_Msk = 0x10000   // Bit mask of FFA16 field.
	CAN_FFA1R_FFA16     = 0x10000   // Bit FFA16.
	CAN_FFA1R_FFA17_Pos = 0x11      // Position of FFA17 field.
	CAN_FFA1R_FFA17_Msk = 0x20000   // Bit mask of FFA17 field.
	CAN_FFA1R_FFA17     = 0x20000   // Bit FFA17.
	CAN_FFA1R_FFA18_Pos = 0x12      // Position of FFA18 field.
	CAN_FFA1R_FFA18_Msk = 0x40000   // Bit mask of FFA18 field.
	CAN_FFA1R_FFA18     = 0x40000   // Bit FFA18.
	CAN_FFA1R_FFA19_Pos = 0x13      // Position of FFA19 field.
	CAN_FFA1R_FFA19_Msk = 0x80000   // Bit mask of FFA19 field.
	CAN_FFA1R_FFA19     = 0x80000   // Bit FFA19.
	CAN_FFA1R_FFA20_Pos = 0x14      // Position of FFA20 field.
	CAN_FFA1R_FFA20_Msk = 0x100000  // Bit mask of FFA20 field.
	CAN_FFA1R_FFA20     = 0x100000  // Bit FFA20.
	CAN_FFA1R_FFA21_Pos = 0x15      // Position of FFA21 field.
	CAN_FFA1R_FFA21_Msk = 0x200000  // Bit mask of FFA21 field.
	CAN_FFA1R_FFA21     = 0x200000  // Bit FFA21.
	CAN_FFA1R_FFA22_Pos = 0x16      // Position of FFA22 field.
	CAN_FFA1R_FFA22_Msk = 0x400000  // Bit mask of FFA22 field.
	CAN_FFA1R_FFA22     = 0x400000  // Bit FFA22.
	CAN_FFA1R_FFA23_Pos = 0x17      // Position of FFA23 field.
	CAN_FFA1R_FFA23_Msk = 0x800000  // Bit mask of FFA23 field.
	CAN_FFA1R_FFA23     = 0x800000  // Bit FFA23.
	CAN_FFA1R_FFA24_Pos = 0x18      // Position of FFA24 field.
	CAN_FFA1R_FFA24_Msk = 0x1000000 // Bit mask of FFA24 field.
	CAN_FFA1R_FFA24     = 0x1000000 // Bit FFA24.
	CAN_FFA1R_FFA25_Pos = 0x19      // Position of FFA25 field.
	CAN_FFA1R_FFA25_Msk = 0x2000000 // Bit mask of FFA25 field.
	CAN_FFA1R_FFA25     = 0x2000000 // Bit FFA25.
	CAN_FFA1R_FFA26_Pos = 0x1a      // Position of FFA26 field.
	CAN_FFA1R_FFA26_Msk = 0x4000000 // Bit mask of FFA26 field.
	CAN_FFA1R_FFA26     = 0x4000000 // Bit FFA26.
	CAN_FFA1R_FFA27_Pos = 0x1b      // Position of FFA27 field.
	CAN_FFA1R_FFA27_Msk = 0x8000000 // Bit mask of FFA27 field.
	CAN_FFA1R_FFA27     = 0x8000000 // Bit FFA27.

	// FA1R: CAN filter activation register
	CAN_FA1R_FACT0_Pos  = 0x0       // Position of FACT0 field.
	CAN_FA1R_FACT0_Msk  = 0x1       // Bit mask of FACT0 field.
	CAN_FA1R_FACT0      = 0x1       // Bit FACT0.
	CAN_FA1R_FACT1_Pos  = 0x1       // Position of FACT1 field.
	CAN_FA1R_FACT1_Msk  = 0x2       // Bit mask of FACT1 field.
	CAN_FA1R_FACT1      = 0x2       // Bit FACT1.
	CAN_FA1R_FACT2_Pos  = 0x2       // Position of FACT2 field.
	CAN_FA1R_FACT2_Msk  = 0x4       // Bit mask of FACT2 field.
	CAN_FA1R_FACT2      = 0x4       // Bit FACT2.
	CAN_FA1R_FACT3_Pos  = 0x3       // Position of FACT3 field.
	CAN_FA1R_FACT3_Msk  = 0x8       // Bit mask of FACT3 field.
	CAN_FA1R_FACT3      = 0x8       // Bit FACT3.
	CAN_FA1R_FACT4_Pos  = 0x4       // Position of FACT4 field.
	CAN_FA1R_FACT4_Msk  = 0x10      // Bit mask of FACT4 field.
	CAN_FA1R_FACT4      = 0x10      // Bit FACT4.
	CAN_FA1R_FACT5_Pos  = 0x5       // Position of FACT5 field.
	CAN_FA1R_FACT5_Msk  = 0x20      // Bit mask of FACT5 field.
	CAN_FA1R_FACT5      = 0x20      // Bit FACT5.
	CAN_FA1R_FACT6_Pos  = 0x6       // Position of FACT6 field.
	CAN_FA1R_FACT6_Msk  = 0x40      // Bit mask of FACT6 field.
	CAN_FA1R_FACT6      = 0x40      // Bit FACT6.
	CAN_FA1R_FACT7_Pos  = 0x7       // Position of FACT7 field.
	CAN_FA1R_FACT7_Msk  = 0x80      // Bit mask of FACT7 field.
	CAN_FA1R_FACT7      = 0x80      // Bit FACT7.
	CAN_FA1R_FACT8_Pos  = 0x8       // Position of FACT8 field.
	CAN_FA1R_FACT8_Msk  = 0x100     // Bit mask of FACT8 field.
	CAN_FA1R_FACT8      = 0x100     // Bit FACT8.
	CAN_FA1R_FACT9_Pos  = 0x9       // Position of FACT9 field.
	CAN_FA1R_FACT9_Msk  = 0x200     // Bit mask of FACT9 field.
	CAN_FA1R_FACT9      = 0x200     // Bit FACT9.
	CAN_FA1R_FACT10_Pos = 0xa       // Position of FACT10 field.
	CAN_FA1R_FACT10_Msk = 0x400     // Bit mask of FACT10 field.
	CAN_FA1R_FACT10     = 0x400     // Bit FACT10.
	CAN_FA1R_FACT11_Pos = 0xb       // Position of FACT11 field.
	CAN_FA1R_FACT11_Msk = 0x800     // Bit mask of FACT11 field.
	CAN_FA1R_FACT11     = 0x800     // Bit FACT11.
	CAN_FA1R_FACT12_Pos = 0xc       // Position of FACT12 field.
	CAN_FA1R_FACT12_Msk = 0x1000    // Bit mask of FACT12 field.
	CAN_FA1R_FACT12     = 0x1000    // Bit FACT12.
	CAN_FA1R_FACT13_Pos = 0xd       // Position of FACT13 field.
	CAN_FA1R_FACT13_Msk = 0x2000    // Bit mask of FACT13 field.
	CAN_FA1R_FACT13     = 0x2000    // Bit FACT13.
	CAN_FA1R_FACT14_Pos = 0xe       // Position of FACT14 field.
	CAN_FA1R_FACT14_Msk = 0x4000    // Bit mask of FACT14 field.
	CAN_FA1R_FACT14     = 0x4000    // Bit FACT14.
	CAN_FA1R_FACT15_Pos = 0xf       // Position of FACT15 field.
	CAN_FA1R_FACT15_Msk = 0x8000    // Bit mask of FACT15 field.
	CAN_FA1R_FACT15     = 0x8000    // Bit FACT15.
	CAN_FA1R_FACT16_Pos = 0x10      // Position of FACT16 field.
	CAN_FA1R_FACT16_Msk = 0x10000   // Bit mask of FACT16 field.
	CAN_FA1R_FACT16     = 0x10000   // Bit FACT16.
	CAN_FA1R_FACT17_Pos = 0x11      // Position of FACT17 field.
	CAN_FA1R_FACT17_Msk = 0x20000   // Bit mask of FACT17 field.
	CAN_FA1R_FACT17     = 0x20000   // Bit FACT17.
	CAN_FA1R_FACT18_Pos = 0x12      // Position of FACT18 field.
	CAN_FA1R_FACT18_Msk = 0x40000   // Bit mask of FACT18 field.
	CAN_FA1R_FACT18     = 0x40000   // Bit FACT18.
	CAN_FA1R_FACT19_Pos = 0x13      // Position of FACT19 field.
	CAN_FA1R_FACT19_Msk = 0x80000   // Bit mask of FACT19 field.
	CAN_FA1R_FACT19     = 0x80000   // Bit FACT19.
	CAN_FA1R_FACT20_Pos = 0x14      // Position of FACT20 field.
	CAN_FA1R_FACT20_Msk = 0x100000  // Bit mask of FACT20 field.
	CAN_FA1R_FACT20     = 0x100000  // Bit FACT20.
	CAN_FA1R_FACT21_Pos = 0x15      // Position of FACT21 field.
	CAN_FA1R_FACT21_Msk = 0x200000  // Bit mask of FACT21 field.
	CAN_FA1R_FACT21     = 0x200000  // Bit FACT21.
	CAN_FA1R_FACT22_Pos = 0x16      // Position of FACT22 field.
	CAN_FA1R_FACT22_Msk = 0x400000  // Bit mask of FACT22 field.
	CAN_FA1R_FACT22     = 0x400000  // Bit FACT22.
	CAN_FA1R_FACT23_Pos = 0x17      // Position of FACT23 field.
	CAN_FA1R_FACT23_Msk = 0x800000  // Bit mask of FACT23 field.
	CAN_FA1R_FACT23     = 0x800000  // Bit FACT23.
	CAN_FA1R_FACT24_Pos = 0x18      // Position of FACT24 field.
	CAN_FA1R_FACT24_Msk = 0x1000000 // Bit mask of FACT24 field.
	CAN_FA1R_FACT24     = 0x1000000 // Bit FACT24.
	CAN_FA1R_FACT25_Pos = 0x19      // Position of FACT25 field.
	CAN_FA1R_FACT25_Msk = 0x2000000 // Bit mask of FACT25 field.
	CAN_FA1R_FACT25     = 0x2000000 // Bit FACT25.
	CAN_FA1R_FACT26_Pos = 0x1a      // Position of FACT26 field.
	CAN_FA1R_FACT26_Msk = 0x4000000 // Bit mask of FACT26 field.
	CAN_FA1R_FACT26     = 0x4000000 // Bit FACT26.
	CAN_FA1R_FACT27_Pos = 0x1b      // Position of FACT27 field.
	CAN_FA1R_FACT27_Msk = 0x8000000 // Bit mask of FACT27 field.
	CAN_FA1R_FACT27     = 0x8000000 // Bit FACT27.

	// F0R1: Filter bank 0 register 1
	CAN_F0R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F0R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F0R1_FB0      = 0x1        // Bit FB0.
	CAN_F0R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F0R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F0R1_FB1      = 0x2        // Bit FB1.
	CAN_F0R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F0R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F0R1_FB2      = 0x4        // Bit FB2.
	CAN_F0R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F0R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F0R1_FB3      = 0x8        // Bit FB3.
	CAN_F0R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F0R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F0R1_FB4      = 0x10       // Bit FB4.
	CAN_F0R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F0R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F0R1_FB5      = 0x20       // Bit FB5.
	CAN_F0R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F0R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F0R1_FB6      = 0x40       // Bit FB6.
	CAN_F0R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F0R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F0R1_FB7      = 0x80       // Bit FB7.
	CAN_F0R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F0R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F0R1_FB8      = 0x100      // Bit FB8.
	CAN_F0R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F0R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F0R1_FB9      = 0x200      // Bit FB9.
	CAN_F0R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F0R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F0R1_FB10     = 0x400      // Bit FB10.
	CAN_F0R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F0R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F0R1_FB11     = 0x800      // Bit FB11.
	CAN_F0R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F0R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F0R1_FB12     = 0x1000     // Bit FB12.
	CAN_F0R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F0R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F0R1_FB13     = 0x2000     // Bit FB13.
	CAN_F0R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F0R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F0R1_FB14     = 0x4000     // Bit FB14.
	CAN_F0R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F0R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F0R1_FB15     = 0x8000     // Bit FB15.
	CAN_F0R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F0R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F0R1_FB16     = 0x10000    // Bit FB16.
	CAN_F0R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F0R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F0R1_FB17     = 0x20000    // Bit FB17.
	CAN_F0R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F0R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F0R1_FB18     = 0x40000    // Bit FB18.
	CAN_F0R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F0R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F0R1_FB19     = 0x80000    // Bit FB19.
	CAN_F0R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F0R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F0R1_FB20     = 0x100000   // Bit FB20.
	CAN_F0R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F0R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F0R1_FB21     = 0x200000   // Bit FB21.
	CAN_F0R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F0R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F0R1_FB22     = 0x400000   // Bit FB22.
	CAN_F0R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F0R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F0R1_FB23     = 0x800000   // Bit FB23.
	CAN_F0R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F0R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F0R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F0R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F0R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F0R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F0R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F0R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F0R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F0R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F0R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F0R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F0R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F0R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F0R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F0R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F0R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F0R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F0R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F0R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F0R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F0R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F0R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F0R1_FB31     = 0x80000000 // Bit FB31.

	// F0R2: Filter bank 0 register 2
	CAN_F0R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F0R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F0R2_FB0      = 0x1        // Bit FB0.
	CAN_F0R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F0R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F0R2_FB1      = 0x2        // Bit FB1.
	CAN_F0R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F0R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F0R2_FB2      = 0x4        // Bit FB2.
	CAN_F0R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F0R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F0R2_FB3      = 0x8        // Bit FB3.
	CAN_F0R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F0R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F0R2_FB4      = 0x10       // Bit FB4.
	CAN_F0R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F0R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F0R2_FB5      = 0x20       // Bit FB5.
	CAN_F0R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F0R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F0R2_FB6      = 0x40       // Bit FB6.
	CAN_F0R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F0R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F0R2_FB7      = 0x80       // Bit FB7.
	CAN_F0R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F0R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F0R2_FB8      = 0x100      // Bit FB8.
	CAN_F0R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F0R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F0R2_FB9      = 0x200      // Bit FB9.
	CAN_F0R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F0R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F0R2_FB10     = 0x400      // Bit FB10.
	CAN_F0R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F0R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F0R2_FB11     = 0x800      // Bit FB11.
	CAN_F0R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F0R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F0R2_FB12     = 0x1000     // Bit FB12.
	CAN_F0R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F0R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F0R2_FB13     = 0x2000     // Bit FB13.
	CAN_F0R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F0R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F0R2_FB14     = 0x4000     // Bit FB14.
	CAN_F0R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F0R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F0R2_FB15     = 0x8000     // Bit FB15.
	CAN_F0R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F0R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F0R2_FB16     = 0x10000    // Bit FB16.
	CAN_F0R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F0R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F0R2_FB17     = 0x20000    // Bit FB17.
	CAN_F0R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F0R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F0R2_FB18     = 0x40000    // Bit FB18.
	CAN_F0R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F0R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F0R2_FB19     = 0x80000    // Bit FB19.
	CAN_F0R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F0R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F0R2_FB20     = 0x100000   // Bit FB20.
	CAN_F0R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F0R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F0R2_FB21     = 0x200000   // Bit FB21.
	CAN_F0R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F0R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F0R2_FB22     = 0x400000   // Bit FB22.
	CAN_F0R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F0R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F0R2_FB23     = 0x800000   // Bit FB23.
	CAN_F0R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F0R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F0R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F0R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F0R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F0R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F0R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F0R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F0R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F0R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F0R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F0R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F0R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F0R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F0R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F0R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F0R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F0R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F0R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F0R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F0R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F0R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F0R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F0R2_FB31     = 0x80000000 // Bit FB31.

	// F1R1: Filter bank 1 register 1
	CAN_F1R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F1R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F1R1_FB0      = 0x1        // Bit FB0.
	CAN_F1R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F1R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F1R1_FB1      = 0x2        // Bit FB1.
	CAN_F1R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F1R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F1R1_FB2      = 0x4        // Bit FB2.
	CAN_F1R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F1R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F1R1_FB3      = 0x8        // Bit FB3.
	CAN_F1R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F1R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F1R1_FB4      = 0x10       // Bit FB4.
	CAN_F1R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F1R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F1R1_FB5      = 0x20       // Bit FB5.
	CAN_F1R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F1R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F1R1_FB6      = 0x40       // Bit FB6.
	CAN_F1R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F1R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F1R1_FB7      = 0x80       // Bit FB7.
	CAN_F1R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F1R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F1R1_FB8      = 0x100      // Bit FB8.
	CAN_F1R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F1R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F1R1_FB9      = 0x200      // Bit FB9.
	CAN_F1R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F1R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F1R1_FB10     = 0x400      // Bit FB10.
	CAN_F1R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F1R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F1R1_FB11     = 0x800      // Bit FB11.
	CAN_F1R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F1R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F1R1_FB12     = 0x1000     // Bit FB12.
	CAN_F1R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F1R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F1R1_FB13     = 0x2000     // Bit FB13.
	CAN_F1R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F1R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F1R1_FB14     = 0x4000     // Bit FB14.
	CAN_F1R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F1R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F1R1_FB15     = 0x8000     // Bit FB15.
	CAN_F1R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F1R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F1R1_FB16     = 0x10000    // Bit FB16.
	CAN_F1R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F1R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F1R1_FB17     = 0x20000    // Bit FB17.
	CAN_F1R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F1R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F1R1_FB18     = 0x40000    // Bit FB18.
	CAN_F1R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F1R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F1R1_FB19     = 0x80000    // Bit FB19.
	CAN_F1R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F1R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F1R1_FB20     = 0x100000   // Bit FB20.
	CAN_F1R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F1R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F1R1_FB21     = 0x200000   // Bit FB21.
	CAN_F1R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F1R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F1R1_FB22     = 0x400000   // Bit FB22.
	CAN_F1R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F1R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F1R1_FB23     = 0x800000   // Bit FB23.
	CAN_F1R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F1R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F1R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F1R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F1R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F1R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F1R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F1R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F1R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F1R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F1R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F1R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F1R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F1R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F1R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F1R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F1R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F1R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F1R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F1R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F1R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F1R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F1R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F1R1_FB31     = 0x80000000 // Bit FB31.

	// F1R2: Filter bank 1 register 2
	CAN_F1R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F1R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F1R2_FB0      = 0x1        // Bit FB0.
	CAN_F1R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F1R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F1R2_FB1      = 0x2        // Bit FB1.
	CAN_F1R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F1R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F1R2_FB2      = 0x4        // Bit FB2.
	CAN_F1R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F1R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F1R2_FB3      = 0x8        // Bit FB3.
	CAN_F1R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F1R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F1R2_FB4      = 0x10       // Bit FB4.
	CAN_F1R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F1R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F1R2_FB5      = 0x20       // Bit FB5.
	CAN_F1R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F1R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F1R2_FB6      = 0x40       // Bit FB6.
	CAN_F1R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F1R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F1R2_FB7      = 0x80       // Bit FB7.
	CAN_F1R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F1R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F1R2_FB8      = 0x100      // Bit FB8.
	CAN_F1R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F1R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F1R2_FB9      = 0x200      // Bit FB9.
	CAN_F1R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F1R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F1R2_FB10     = 0x400      // Bit FB10.
	CAN_F1R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F1R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F1R2_FB11     = 0x800      // Bit FB11.
	CAN_F1R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F1R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F1R2_FB12     = 0x1000     // Bit FB12.
	CAN_F1R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F1R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F1R2_FB13     = 0x2000     // Bit FB13.
	CAN_F1R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F1R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F1R2_FB14     = 0x4000     // Bit FB14.
	CAN_F1R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F1R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F1R2_FB15     = 0x8000     // Bit FB15.
	CAN_F1R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F1R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F1R2_FB16     = 0x10000    // Bit FB16.
	CAN_F1R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F1R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F1R2_FB17     = 0x20000    // Bit FB17.
	CAN_F1R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F1R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F1R2_FB18     = 0x40000    // Bit FB18.
	CAN_F1R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F1R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F1R2_FB19     = 0x80000    // Bit FB19.
	CAN_F1R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F1R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F1R2_FB20     = 0x100000   // Bit FB20.
	CAN_F1R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F1R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F1R2_FB21     = 0x200000   // Bit FB21.
	CAN_F1R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F1R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F1R2_FB22     = 0x400000   // Bit FB22.
	CAN_F1R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F1R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F1R2_FB23     = 0x800000   // Bit FB23.
	CAN_F1R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F1R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F1R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F1R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F1R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F1R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F1R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F1R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F1R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F1R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F1R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F1R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F1R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F1R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F1R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F1R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F1R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F1R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F1R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F1R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F1R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F1R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F1R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F1R2_FB31     = 0x80000000 // Bit FB31.

	// F2R1: Filter bank 2 register 1
	CAN_F2R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F2R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F2R1_FB0      = 0x1        // Bit FB0.
	CAN_F2R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F2R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F2R1_FB1      = 0x2        // Bit FB1.
	CAN_F2R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F2R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F2R1_FB2      = 0x4        // Bit FB2.
	CAN_F2R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F2R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F2R1_FB3      = 0x8        // Bit FB3.
	CAN_F2R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F2R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F2R1_FB4      = 0x10       // Bit FB4.
	CAN_F2R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F2R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F2R1_FB5      = 0x20       // Bit FB5.
	CAN_F2R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F2R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F2R1_FB6      = 0x40       // Bit FB6.
	CAN_F2R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F2R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F2R1_FB7      = 0x80       // Bit FB7.
	CAN_F2R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F2R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F2R1_FB8      = 0x100      // Bit FB8.
	CAN_F2R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F2R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F2R1_FB9      = 0x200      // Bit FB9.
	CAN_F2R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F2R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F2R1_FB10     = 0x400      // Bit FB10.
	CAN_F2R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F2R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F2R1_FB11     = 0x800      // Bit FB11.
	CAN_F2R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F2R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F2R1_FB12     = 0x1000     // Bit FB12.
	CAN_F2R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F2R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F2R1_FB13     = 0x2000     // Bit FB13.
	CAN_F2R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F2R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F2R1_FB14     = 0x4000     // Bit FB14.
	CAN_F2R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F2R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F2R1_FB15     = 0x8000     // Bit FB15.
	CAN_F2R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F2R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F2R1_FB16     = 0x10000    // Bit FB16.
	CAN_F2R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F2R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F2R1_FB17     = 0x20000    // Bit FB17.
	CAN_F2R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F2R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F2R1_FB18     = 0x40000    // Bit FB18.
	CAN_F2R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F2R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F2R1_FB19     = 0x80000    // Bit FB19.
	CAN_F2R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F2R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F2R1_FB20     = 0x100000   // Bit FB20.
	CAN_F2R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F2R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F2R1_FB21     = 0x200000   // Bit FB21.
	CAN_F2R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F2R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F2R1_FB22     = 0x400000   // Bit FB22.
	CAN_F2R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F2R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F2R1_FB23     = 0x800000   // Bit FB23.
	CAN_F2R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F2R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F2R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F2R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F2R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F2R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F2R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F2R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F2R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F2R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F2R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F2R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F2R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F2R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F2R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F2R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F2R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F2R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F2R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F2R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F2R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F2R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F2R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F2R1_FB31     = 0x80000000 // Bit FB31.

	// F2R2: Filter bank 2 register 2
	CAN_F2R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F2R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F2R2_FB0      = 0x1        // Bit FB0.
	CAN_F2R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F2R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F2R2_FB1      = 0x2        // Bit FB1.
	CAN_F2R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F2R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F2R2_FB2      = 0x4        // Bit FB2.
	CAN_F2R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F2R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F2R2_FB3      = 0x8        // Bit FB3.
	CAN_F2R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F2R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F2R2_FB4      = 0x10       // Bit FB4.
	CAN_F2R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F2R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F2R2_FB5      = 0x20       // Bit FB5.
	CAN_F2R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F2R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F2R2_FB6      = 0x40       // Bit FB6.
	CAN_F2R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F2R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F2R2_FB7      = 0x80       // Bit FB7.
	CAN_F2R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F2R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F2R2_FB8      = 0x100      // Bit FB8.
	CAN_F2R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F2R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F2R2_FB9      = 0x200      // Bit FB9.
	CAN_F2R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F2R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F2R2_FB10     = 0x400      // Bit FB10.
	CAN_F2R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F2R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F2R2_FB11     = 0x800      // Bit FB11.
	CAN_F2R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F2R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F2R2_FB12     = 0x1000     // Bit FB12.
	CAN_F2R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F2R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F2R2_FB13     = 0x2000     // Bit FB13.
	CAN_F2R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F2R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F2R2_FB14     = 0x4000     // Bit FB14.
	CAN_F2R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F2R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F2R2_FB15     = 0x8000     // Bit FB15.
	CAN_F2R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F2R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F2R2_FB16     = 0x10000    // Bit FB16.
	CAN_F2R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F2R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F2R2_FB17     = 0x20000    // Bit FB17.
	CAN_F2R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F2R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F2R2_FB18     = 0x40000    // Bit FB18.
	CAN_F2R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F2R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F2R2_FB19     = 0x80000    // Bit FB19.
	CAN_F2R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F2R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F2R2_FB20     = 0x100000   // Bit FB20.
	CAN_F2R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F2R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F2R2_FB21     = 0x200000   // Bit FB21.
	CAN_F2R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F2R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F2R2_FB22     = 0x400000   // Bit FB22.
	CAN_F2R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F2R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F2R2_FB23     = 0x800000   // Bit FB23.
	CAN_F2R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F2R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F2R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F2R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F2R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F2R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F2R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F2R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F2R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F2R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F2R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F2R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F2R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F2R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F2R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F2R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F2R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F2R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F2R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F2R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F2R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F2R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F2R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F2R2_FB31     = 0x80000000 // Bit FB31.

	// F3R1: Filter bank 3 register 1
	CAN_F3R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F3R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F3R1_FB0      = 0x1        // Bit FB0.
	CAN_F3R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F3R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F3R1_FB1      = 0x2        // Bit FB1.
	CAN_F3R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F3R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F3R1_FB2      = 0x4        // Bit FB2.
	CAN_F3R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F3R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F3R1_FB3      = 0x8        // Bit FB3.
	CAN_F3R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F3R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F3R1_FB4      = 0x10       // Bit FB4.
	CAN_F3R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F3R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F3R1_FB5      = 0x20       // Bit FB5.
	CAN_F3R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F3R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F3R1_FB6      = 0x40       // Bit FB6.
	CAN_F3R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F3R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F3R1_FB7      = 0x80       // Bit FB7.
	CAN_F3R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F3R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F3R1_FB8      = 0x100      // Bit FB8.
	CAN_F3R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F3R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F3R1_FB9      = 0x200      // Bit FB9.
	CAN_F3R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F3R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F3R1_FB10     = 0x400      // Bit FB10.
	CAN_F3R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F3R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F3R1_FB11     = 0x800      // Bit FB11.
	CAN_F3R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F3R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F3R1_FB12     = 0x1000     // Bit FB12.
	CAN_F3R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F3R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F3R1_FB13     = 0x2000     // Bit FB13.
	CAN_F3R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F3R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F3R1_FB14     = 0x4000     // Bit FB14.
	CAN_F3R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F3R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F3R1_FB15     = 0x8000     // Bit FB15.
	CAN_F3R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F3R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F3R1_FB16     = 0x10000    // Bit FB16.
	CAN_F3R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F3R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F3R1_FB17     = 0x20000    // Bit FB17.
	CAN_F3R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F3R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F3R1_FB18     = 0x40000    // Bit FB18.
	CAN_F3R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F3R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F3R1_FB19     = 0x80000    // Bit FB19.
	CAN_F3R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F3R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F3R1_FB20     = 0x100000   // Bit FB20.
	CAN_F3R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F3R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F3R1_FB21     = 0x200000   // Bit FB21.
	CAN_F3R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F3R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F3R1_FB22     = 0x400000   // Bit FB22.
	CAN_F3R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F3R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F3R1_FB23     = 0x800000   // Bit FB23.
	CAN_F3R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F3R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F3R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F3R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F3R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F3R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F3R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F3R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F3R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F3R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F3R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F3R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F3R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F3R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F3R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F3R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F3R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F3R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F3R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F3R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F3R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F3R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F3R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F3R1_FB31     = 0x80000000 // Bit FB31.

	// F3R2: Filter bank 3 register 2
	CAN_F3R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F3R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F3R2_FB0      = 0x1        // Bit FB0.
	CAN_F3R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F3R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F3R2_FB1      = 0x2        // Bit FB1.
	CAN_F3R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F3R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F3R2_FB2      = 0x4        // Bit FB2.
	CAN_F3R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F3R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F3R2_FB3      = 0x8        // Bit FB3.
	CAN_F3R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F3R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F3R2_FB4      = 0x10       // Bit FB4.
	CAN_F3R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F3R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F3R2_FB5      = 0x20       // Bit FB5.
	CAN_F3R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F3R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F3R2_FB6      = 0x40       // Bit FB6.
	CAN_F3R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F3R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F3R2_FB7      = 0x80       // Bit FB7.
	CAN_F3R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F3R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F3R2_FB8      = 0x100      // Bit FB8.
	CAN_F3R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F3R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F3R2_FB9      = 0x200      // Bit FB9.
	CAN_F3R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F3R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F3R2_FB10     = 0x400      // Bit FB10.
	CAN_F3R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F3R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F3R2_FB11     = 0x800      // Bit FB11.
	CAN_F3R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F3R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F3R2_FB12     = 0x1000     // Bit FB12.
	CAN_F3R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F3R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F3R2_FB13     = 0x2000     // Bit FB13.
	CAN_F3R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F3R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F3R2_FB14     = 0x4000     // Bit FB14.
	CAN_F3R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F3R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F3R2_FB15     = 0x8000     // Bit FB15.
	CAN_F3R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F3R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F3R2_FB16     = 0x10000    // Bit FB16.
	CAN_F3R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F3R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F3R2_FB17     = 0x20000    // Bit FB17.
	CAN_F3R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F3R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F3R2_FB18     = 0x40000    // Bit FB18.
	CAN_F3R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F3R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F3R2_FB19     = 0x80000    // Bit FB19.
	CAN_F3R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F3R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F3R2_FB20     = 0x100000   // Bit FB20.
	CAN_F3R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F3R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F3R2_FB21     = 0x200000   // Bit FB21.
	CAN_F3R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F3R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F3R2_FB22     = 0x400000   // Bit FB22.
	CAN_F3R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F3R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F3R2_FB23     = 0x800000   // Bit FB23.
	CAN_F3R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F3R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F3R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F3R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F3R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F3R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F3R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F3R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F3R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F3R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F3R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F3R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F3R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F3R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F3R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F3R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F3R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F3R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F3R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F3R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F3R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F3R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F3R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F3R2_FB31     = 0x80000000 // Bit FB31.

	// F4R1: Filter bank 4 register 1
	CAN_F4R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F4R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F4R1_FB0      = 0x1        // Bit FB0.
	CAN_F4R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F4R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F4R1_FB1      = 0x2        // Bit FB1.
	CAN_F4R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F4R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F4R1_FB2      = 0x4        // Bit FB2.
	CAN_F4R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F4R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F4R1_FB3      = 0x8        // Bit FB3.
	CAN_F4R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F4R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F4R1_FB4      = 0x10       // Bit FB4.
	CAN_F4R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F4R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F4R1_FB5      = 0x20       // Bit FB5.
	CAN_F4R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F4R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F4R1_FB6      = 0x40       // Bit FB6.
	CAN_F4R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F4R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F4R1_FB7      = 0x80       // Bit FB7.
	CAN_F4R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F4R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F4R1_FB8      = 0x100      // Bit FB8.
	CAN_F4R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F4R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F4R1_FB9      = 0x200      // Bit FB9.
	CAN_F4R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F4R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F4R1_FB10     = 0x400      // Bit FB10.
	CAN_F4R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F4R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F4R1_FB11     = 0x800      // Bit FB11.
	CAN_F4R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F4R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F4R1_FB12     = 0x1000     // Bit FB12.
	CAN_F4R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F4R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F4R1_FB13     = 0x2000     // Bit FB13.
	CAN_F4R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F4R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F4R1_FB14     = 0x4000     // Bit FB14.
	CAN_F4R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F4R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F4R1_FB15     = 0x8000     // Bit FB15.
	CAN_F4R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F4R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F4R1_FB16     = 0x10000    // Bit FB16.
	CAN_F4R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F4R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F4R1_FB17     = 0x20000    // Bit FB17.
	CAN_F4R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F4R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F4R1_FB18     = 0x40000    // Bit FB18.
	CAN_F4R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F4R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F4R1_FB19     = 0x80000    // Bit FB19.
	CAN_F4R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F4R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F4R1_FB20     = 0x100000   // Bit FB20.
	CAN_F4R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F4R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F4R1_FB21     = 0x200000   // Bit FB21.
	CAN_F4R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F4R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F4R1_FB22     = 0x400000   // Bit FB22.
	CAN_F4R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F4R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F4R1_FB23     = 0x800000   // Bit FB23.
	CAN_F4R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F4R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F4R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F4R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F4R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F4R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F4R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F4R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F4R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F4R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F4R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F4R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F4R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F4R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F4R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F4R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F4R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F4R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F4R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F4R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F4R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F4R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F4R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F4R1_FB31     = 0x80000000 // Bit FB31.

	// F4R2: Filter bank 4 register 2
	CAN_F4R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F4R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F4R2_FB0      = 0x1        // Bit FB0.
	CAN_F4R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F4R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F4R2_FB1      = 0x2        // Bit FB1.
	CAN_F4R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F4R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F4R2_FB2      = 0x4        // Bit FB2.
	CAN_F4R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F4R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F4R2_FB3      = 0x8        // Bit FB3.
	CAN_F4R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F4R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F4R2_FB4      = 0x10       // Bit FB4.
	CAN_F4R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F4R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F4R2_FB5      = 0x20       // Bit FB5.
	CAN_F4R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F4R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F4R2_FB6      = 0x40       // Bit FB6.
	CAN_F4R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F4R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F4R2_FB7      = 0x80       // Bit FB7.
	CAN_F4R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F4R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F4R2_FB8      = 0x100      // Bit FB8.
	CAN_F4R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F4R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F4R2_FB9      = 0x200      // Bit FB9.
	CAN_F4R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F4R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F4R2_FB10     = 0x400      // Bit FB10.
	CAN_F4R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F4R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F4R2_FB11     = 0x800      // Bit FB11.
	CAN_F4R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F4R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F4R2_FB12     = 0x1000     // Bit FB12.
	CAN_F4R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F4R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F4R2_FB13     = 0x2000     // Bit FB13.
	CAN_F4R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F4R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F4R2_FB14     = 0x4000     // Bit FB14.
	CAN_F4R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F4R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F4R2_FB15     = 0x8000     // Bit FB15.
	CAN_F4R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F4R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F4R2_FB16     = 0x10000    // Bit FB16.
	CAN_F4R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F4R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F4R2_FB17     = 0x20000    // Bit FB17.
	CAN_F4R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F4R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F4R2_FB18     = 0x40000    // Bit FB18.
	CAN_F4R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F4R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F4R2_FB19     = 0x80000    // Bit FB19.
	CAN_F4R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F4R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F4R2_FB20     = 0x100000   // Bit FB20.
	CAN_F4R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F4R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F4R2_FB21     = 0x200000   // Bit FB21.
	CAN_F4R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F4R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F4R2_FB22     = 0x400000   // Bit FB22.
	CAN_F4R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F4R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F4R2_FB23     = 0x800000   // Bit FB23.
	CAN_F4R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F4R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F4R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F4R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F4R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F4R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F4R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F4R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F4R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F4R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F4R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F4R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F4R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F4R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F4R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F4R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F4R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F4R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F4R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F4R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F4R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F4R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F4R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F4R2_FB31     = 0x80000000 // Bit FB31.

	// F5R1: Filter bank 5 register 1
	CAN_F5R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F5R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F5R1_FB0      = 0x1        // Bit FB0.
	CAN_F5R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F5R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F5R1_FB1      = 0x2        // Bit FB1.
	CAN_F5R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F5R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F5R1_FB2      = 0x4        // Bit FB2.
	CAN_F5R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F5R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F5R1_FB3      = 0x8        // Bit FB3.
	CAN_F5R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F5R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F5R1_FB4      = 0x10       // Bit FB4.
	CAN_F5R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F5R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F5R1_FB5      = 0x20       // Bit FB5.
	CAN_F5R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F5R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F5R1_FB6      = 0x40       // Bit FB6.
	CAN_F5R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F5R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F5R1_FB7      = 0x80       // Bit FB7.
	CAN_F5R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F5R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F5R1_FB8      = 0x100      // Bit FB8.
	CAN_F5R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F5R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F5R1_FB9      = 0x200      // Bit FB9.
	CAN_F5R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F5R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F5R1_FB10     = 0x400      // Bit FB10.
	CAN_F5R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F5R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F5R1_FB11     = 0x800      // Bit FB11.
	CAN_F5R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F5R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F5R1_FB12     = 0x1000     // Bit FB12.
	CAN_F5R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F5R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F5R1_FB13     = 0x2000     // Bit FB13.
	CAN_F5R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F5R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F5R1_FB14     = 0x4000     // Bit FB14.
	CAN_F5R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F5R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F5R1_FB15     = 0x8000     // Bit FB15.
	CAN_F5R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F5R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F5R1_FB16     = 0x10000    // Bit FB16.
	CAN_F5R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F5R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F5R1_FB17     = 0x20000    // Bit FB17.
	CAN_F5R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F5R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F5R1_FB18     = 0x40000    // Bit FB18.
	CAN_F5R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F5R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F5R1_FB19     = 0x80000    // Bit FB19.
	CAN_F5R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F5R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F5R1_FB20     = 0x100000   // Bit FB20.
	CAN_F5R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F5R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F5R1_FB21     = 0x200000   // Bit FB21.
	CAN_F5R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F5R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F5R1_FB22     = 0x400000   // Bit FB22.
	CAN_F5R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F5R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F5R1_FB23     = 0x800000   // Bit FB23.
	CAN_F5R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F5R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F5R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F5R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F5R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F5R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F5R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F5R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F5R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F5R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F5R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F5R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F5R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F5R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F5R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F5R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F5R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F5R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F5R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F5R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F5R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F5R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F5R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F5R1_FB31     = 0x80000000 // Bit FB31.

	// F5R2: Filter bank 5 register 2
	CAN_F5R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F5R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F5R2_FB0      = 0x1        // Bit FB0.
	CAN_F5R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F5R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F5R2_FB1      = 0x2        // Bit FB1.
	CAN_F5R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F5R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F5R2_FB2      = 0x4        // Bit FB2.
	CAN_F5R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F5R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F5R2_FB3      = 0x8        // Bit FB3.
	CAN_F5R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F5R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F5R2_FB4      = 0x10       // Bit FB4.
	CAN_F5R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F5R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F5R2_FB5      = 0x20       // Bit FB5.
	CAN_F5R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F5R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F5R2_FB6      = 0x40       // Bit FB6.
	CAN_F5R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F5R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F5R2_FB7      = 0x80       // Bit FB7.
	CAN_F5R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F5R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F5R2_FB8      = 0x100      // Bit FB8.
	CAN_F5R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F5R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F5R2_FB9      = 0x200      // Bit FB9.
	CAN_F5R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F5R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F5R2_FB10     = 0x400      // Bit FB10.
	CAN_F5R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F5R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F5R2_FB11     = 0x800      // Bit FB11.
	CAN_F5R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F5R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F5R2_FB12     = 0x1000     // Bit FB12.
	CAN_F5R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F5R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F5R2_FB13     = 0x2000     // Bit FB13.
	CAN_F5R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F5R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F5R2_FB14     = 0x4000     // Bit FB14.
	CAN_F5R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F5R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F5R2_FB15     = 0x8000     // Bit FB15.
	CAN_F5R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F5R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F5R2_FB16     = 0x10000    // Bit FB16.
	CAN_F5R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F5R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F5R2_FB17     = 0x20000    // Bit FB17.
	CAN_F5R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F5R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F5R2_FB18     = 0x40000    // Bit FB18.
	CAN_F5R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F5R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F5R2_FB19     = 0x80000    // Bit FB19.
	CAN_F5R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F5R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F5R2_FB20     = 0x100000   // Bit FB20.
	CAN_F5R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F5R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F5R2_FB21     = 0x200000   // Bit FB21.
	CAN_F5R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F5R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F5R2_FB22     = 0x400000   // Bit FB22.
	CAN_F5R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F5R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F5R2_FB23     = 0x800000   // Bit FB23.
	CAN_F5R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F5R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F5R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F5R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F5R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F5R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F5R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F5R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F5R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F5R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F5R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F5R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F5R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F5R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F5R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F5R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F5R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F5R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F5R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F5R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F5R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F5R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F5R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F5R2_FB31     = 0x80000000 // Bit FB31.

	// F6R1: Filter bank 6 register 1
	CAN_F6R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F6R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F6R1_FB0      = 0x1        // Bit FB0.
	CAN_F6R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F6R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F6R1_FB1      = 0x2        // Bit FB1.
	CAN_F6R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F6R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F6R1_FB2      = 0x4        // Bit FB2.
	CAN_F6R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F6R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F6R1_FB3      = 0x8        // Bit FB3.
	CAN_F6R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F6R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F6R1_FB4      = 0x10       // Bit FB4.
	CAN_F6R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F6R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F6R1_FB5      = 0x20       // Bit FB5.
	CAN_F6R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F6R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F6R1_FB6      = 0x40       // Bit FB6.
	CAN_F6R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F6R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F6R1_FB7      = 0x80       // Bit FB7.
	CAN_F6R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F6R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F6R1_FB8      = 0x100      // Bit FB8.
	CAN_F6R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F6R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F6R1_FB9      = 0x200      // Bit FB9.
	CAN_F6R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F6R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F6R1_FB10     = 0x400      // Bit FB10.
	CAN_F6R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F6R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F6R1_FB11     = 0x800      // Bit FB11.
	CAN_F6R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F6R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F6R1_FB12     = 0x1000     // Bit FB12.
	CAN_F6R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F6R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F6R1_FB13     = 0x2000     // Bit FB13.
	CAN_F6R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F6R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F6R1_FB14     = 0x4000     // Bit FB14.
	CAN_F6R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F6R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F6R1_FB15     = 0x8000     // Bit FB15.
	CAN_F6R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F6R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F6R1_FB16     = 0x10000    // Bit FB16.
	CAN_F6R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F6R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F6R1_FB17     = 0x20000    // Bit FB17.
	CAN_F6R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F6R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F6R1_FB18     = 0x40000    // Bit FB18.
	CAN_F6R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F6R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F6R1_FB19     = 0x80000    // Bit FB19.
	CAN_F6R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F6R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F6R1_FB20     = 0x100000   // Bit FB20.
	CAN_F6R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F6R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F6R1_FB21     = 0x200000   // Bit FB21.
	CAN_F6R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F6R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F6R1_FB22     = 0x400000   // Bit FB22.
	CAN_F6R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F6R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F6R1_FB23     = 0x800000   // Bit FB23.
	CAN_F6R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F6R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F6R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F6R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F6R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F6R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F6R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F6R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F6R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F6R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F6R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F6R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F6R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F6R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F6R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F6R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F6R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F6R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F6R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F6R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F6R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F6R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F6R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F6R1_FB31     = 0x80000000 // Bit FB31.

	// F6R2: Filter bank 6 register 2
	CAN_F6R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F6R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F6R2_FB0      = 0x1        // Bit FB0.
	CAN_F6R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F6R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F6R2_FB1      = 0x2        // Bit FB1.
	CAN_F6R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F6R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F6R2_FB2      = 0x4        // Bit FB2.
	CAN_F6R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F6R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F6R2_FB3      = 0x8        // Bit FB3.
	CAN_F6R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F6R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F6R2_FB4      = 0x10       // Bit FB4.
	CAN_F6R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F6R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F6R2_FB5      = 0x20       // Bit FB5.
	CAN_F6R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F6R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F6R2_FB6      = 0x40       // Bit FB6.
	CAN_F6R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F6R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F6R2_FB7      = 0x80       // Bit FB7.
	CAN_F6R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F6R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F6R2_FB8      = 0x100      // Bit FB8.
	CAN_F6R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F6R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F6R2_FB9      = 0x200      // Bit FB9.
	CAN_F6R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F6R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F6R2_FB10     = 0x400      // Bit FB10.
	CAN_F6R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F6R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F6R2_FB11     = 0x800      // Bit FB11.
	CAN_F6R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F6R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F6R2_FB12     = 0x1000     // Bit FB12.
	CAN_F6R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F6R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F6R2_FB13     = 0x2000     // Bit FB13.
	CAN_F6R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F6R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F6R2_FB14     = 0x4000     // Bit FB14.
	CAN_F6R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F6R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F6R2_FB15     = 0x8000     // Bit FB15.
	CAN_F6R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F6R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F6R2_FB16     = 0x10000    // Bit FB16.
	CAN_F6R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F6R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F6R2_FB17     = 0x20000    // Bit FB17.
	CAN_F6R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F6R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F6R2_FB18     = 0x40000    // Bit FB18.
	CAN_F6R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F6R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F6R2_FB19     = 0x80000    // Bit FB19.
	CAN_F6R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F6R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F6R2_FB20     = 0x100000   // Bit FB20.
	CAN_F6R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F6R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F6R2_FB21     = 0x200000   // Bit FB21.
	CAN_F6R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F6R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F6R2_FB22     = 0x400000   // Bit FB22.
	CAN_F6R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F6R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F6R2_FB23     = 0x800000   // Bit FB23.
	CAN_F6R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F6R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F6R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F6R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F6R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F6R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F6R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F6R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F6R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F6R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F6R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F6R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F6R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F6R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F6R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F6R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F6R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F6R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F6R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F6R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F6R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F6R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F6R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F6R2_FB31     = 0x80000000 // Bit FB31.

	// F7R1: Filter bank 7 register 1
	CAN_F7R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F7R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F7R1_FB0      = 0x1        // Bit FB0.
	CAN_F7R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F7R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F7R1_FB1      = 0x2        // Bit FB1.
	CAN_F7R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F7R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F7R1_FB2      = 0x4        // Bit FB2.
	CAN_F7R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F7R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F7R1_FB3      = 0x8        // Bit FB3.
	CAN_F7R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F7R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F7R1_FB4      = 0x10       // Bit FB4.
	CAN_F7R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F7R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F7R1_FB5      = 0x20       // Bit FB5.
	CAN_F7R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F7R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F7R1_FB6      = 0x40       // Bit FB6.
	CAN_F7R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F7R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F7R1_FB7      = 0x80       // Bit FB7.
	CAN_F7R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F7R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F7R1_FB8      = 0x100      // Bit FB8.
	CAN_F7R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F7R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F7R1_FB9      = 0x200      // Bit FB9.
	CAN_F7R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F7R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F7R1_FB10     = 0x400      // Bit FB10.
	CAN_F7R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F7R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F7R1_FB11     = 0x800      // Bit FB11.
	CAN_F7R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F7R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F7R1_FB12     = 0x1000     // Bit FB12.
	CAN_F7R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F7R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F7R1_FB13     = 0x2000     // Bit FB13.
	CAN_F7R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F7R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F7R1_FB14     = 0x4000     // Bit FB14.
	CAN_F7R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F7R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F7R1_FB15     = 0x8000     // Bit FB15.
	CAN_F7R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F7R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F7R1_FB16     = 0x10000    // Bit FB16.
	CAN_F7R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F7R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F7R1_FB17     = 0x20000    // Bit FB17.
	CAN_F7R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F7R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F7R1_FB18     = 0x40000    // Bit FB18.
	CAN_F7R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F7R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F7R1_FB19     = 0x80000    // Bit FB19.
	CAN_F7R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F7R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F7R1_FB20     = 0x100000   // Bit FB20.
	CAN_F7R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F7R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F7R1_FB21     = 0x200000   // Bit FB21.
	CAN_F7R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F7R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F7R1_FB22     = 0x400000   // Bit FB22.
	CAN_F7R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F7R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F7R1_FB23     = 0x800000   // Bit FB23.
	CAN_F7R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F7R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F7R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F7R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F7R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F7R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F7R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F7R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F7R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F7R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F7R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F7R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F7R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F7R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F7R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F7R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F7R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F7R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F7R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F7R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F7R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F7R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F7R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F7R1_FB31     = 0x80000000 // Bit FB31.

	// F7R2: Filter bank 7 register 2
	CAN_F7R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F7R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F7R2_FB0      = 0x1        // Bit FB0.
	CAN_F7R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F7R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F7R2_FB1      = 0x2        // Bit FB1.
	CAN_F7R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F7R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F7R2_FB2      = 0x4        // Bit FB2.
	CAN_F7R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F7R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F7R2_FB3      = 0x8        // Bit FB3.
	CAN_F7R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F7R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F7R2_FB4      = 0x10       // Bit FB4.
	CAN_F7R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F7R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F7R2_FB5      = 0x20       // Bit FB5.
	CAN_F7R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F7R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F7R2_FB6      = 0x40       // Bit FB6.
	CAN_F7R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F7R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F7R2_FB7      = 0x80       // Bit FB7.
	CAN_F7R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F7R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F7R2_FB8      = 0x100      // Bit FB8.
	CAN_F7R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F7R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F7R2_FB9      = 0x200      // Bit FB9.
	CAN_F7R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F7R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F7R2_FB10     = 0x400      // Bit FB10.
	CAN_F7R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F7R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F7R2_FB11     = 0x800      // Bit FB11.
	CAN_F7R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F7R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F7R2_FB12     = 0x1000     // Bit FB12.
	CAN_F7R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F7R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F7R2_FB13     = 0x2000     // Bit FB13.
	CAN_F7R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F7R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F7R2_FB14     = 0x4000     // Bit FB14.
	CAN_F7R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F7R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F7R2_FB15     = 0x8000     // Bit FB15.
	CAN_F7R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F7R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F7R2_FB16     = 0x10000    // Bit FB16.
	CAN_F7R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F7R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F7R2_FB17     = 0x20000    // Bit FB17.
	CAN_F7R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F7R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F7R2_FB18     = 0x40000    // Bit FB18.
	CAN_F7R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F7R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F7R2_FB19     = 0x80000    // Bit FB19.
	CAN_F7R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F7R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F7R2_FB20     = 0x100000   // Bit FB20.
	CAN_F7R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F7R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F7R2_FB21     = 0x200000   // Bit FB21.
	CAN_F7R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F7R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F7R2_FB22     = 0x400000   // Bit FB22.
	CAN_F7R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F7R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F7R2_FB23     = 0x800000   // Bit FB23.
	CAN_F7R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F7R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F7R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F7R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F7R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F7R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F7R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F7R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F7R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F7R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F7R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F7R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F7R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F7R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F7R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F7R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F7R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F7R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F7R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F7R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F7R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F7R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F7R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F7R2_FB31     = 0x80000000 // Bit FB31.

	// F8R1: Filter bank 8 register 1
	CAN_F8R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F8R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F8R1_FB0      = 0x1        // Bit FB0.
	CAN_F8R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F8R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F8R1_FB1      = 0x2        // Bit FB1.
	CAN_F8R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F8R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F8R1_FB2      = 0x4        // Bit FB2.
	CAN_F8R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F8R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F8R1_FB3      = 0x8        // Bit FB3.
	CAN_F8R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F8R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F8R1_FB4      = 0x10       // Bit FB4.
	CAN_F8R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F8R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F8R1_FB5      = 0x20       // Bit FB5.
	CAN_F8R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F8R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F8R1_FB6      = 0x40       // Bit FB6.
	CAN_F8R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F8R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F8R1_FB7      = 0x80       // Bit FB7.
	CAN_F8R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F8R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F8R1_FB8      = 0x100      // Bit FB8.
	CAN_F8R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F8R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F8R1_FB9      = 0x200      // Bit FB9.
	CAN_F8R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F8R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F8R1_FB10     = 0x400      // Bit FB10.
	CAN_F8R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F8R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F8R1_FB11     = 0x800      // Bit FB11.
	CAN_F8R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F8R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F8R1_FB12     = 0x1000     // Bit FB12.
	CAN_F8R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F8R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F8R1_FB13     = 0x2000     // Bit FB13.
	CAN_F8R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F8R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F8R1_FB14     = 0x4000     // Bit FB14.
	CAN_F8R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F8R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F8R1_FB15     = 0x8000     // Bit FB15.
	CAN_F8R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F8R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F8R1_FB16     = 0x10000    // Bit FB16.
	CAN_F8R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F8R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F8R1_FB17     = 0x20000    // Bit FB17.
	CAN_F8R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F8R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F8R1_FB18     = 0x40000    // Bit FB18.
	CAN_F8R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F8R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F8R1_FB19     = 0x80000    // Bit FB19.
	CAN_F8R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F8R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F8R1_FB20     = 0x100000   // Bit FB20.
	CAN_F8R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F8R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F8R1_FB21     = 0x200000   // Bit FB21.
	CAN_F8R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F8R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F8R1_FB22     = 0x400000   // Bit FB22.
	CAN_F8R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F8R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F8R1_FB23     = 0x800000   // Bit FB23.
	CAN_F8R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F8R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F8R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F8R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F8R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F8R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F8R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F8R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F8R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F8R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F8R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F8R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F8R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F8R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F8R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F8R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F8R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F8R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F8R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F8R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F8R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F8R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F8R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F8R1_FB31     = 0x80000000 // Bit FB31.

	// F8R2: Filter bank 8 register 2
	CAN_F8R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F8R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F8R2_FB0      = 0x1        // Bit FB0.
	CAN_F8R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F8R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F8R2_FB1      = 0x2        // Bit FB1.
	CAN_F8R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F8R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F8R2_FB2      = 0x4        // Bit FB2.
	CAN_F8R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F8R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F8R2_FB3      = 0x8        // Bit FB3.
	CAN_F8R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F8R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F8R2_FB4      = 0x10       // Bit FB4.
	CAN_F8R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F8R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F8R2_FB5      = 0x20       // Bit FB5.
	CAN_F8R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F8R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F8R2_FB6      = 0x40       // Bit FB6.
	CAN_F8R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F8R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F8R2_FB7      = 0x80       // Bit FB7.
	CAN_F8R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F8R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F8R2_FB8      = 0x100      // Bit FB8.
	CAN_F8R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F8R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F8R2_FB9      = 0x200      // Bit FB9.
	CAN_F8R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F8R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F8R2_FB10     = 0x400      // Bit FB10.
	CAN_F8R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F8R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F8R2_FB11     = 0x800      // Bit FB11.
	CAN_F8R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F8R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F8R2_FB12     = 0x1000     // Bit FB12.
	CAN_F8R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F8R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F8R2_FB13     = 0x2000     // Bit FB13.
	CAN_F8R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F8R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F8R2_FB14     = 0x4000     // Bit FB14.
	CAN_F8R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F8R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F8R2_FB15     = 0x8000     // Bit FB15.
	CAN_F8R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F8R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F8R2_FB16     = 0x10000    // Bit FB16.
	CAN_F8R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F8R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F8R2_FB17     = 0x20000    // Bit FB17.
	CAN_F8R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F8R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F8R2_FB18     = 0x40000    // Bit FB18.
	CAN_F8R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F8R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F8R2_FB19     = 0x80000    // Bit FB19.
	CAN_F8R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F8R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F8R2_FB20     = 0x100000   // Bit FB20.
	CAN_F8R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F8R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F8R2_FB21     = 0x200000   // Bit FB21.
	CAN_F8R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F8R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F8R2_FB22     = 0x400000   // Bit FB22.
	CAN_F8R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F8R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F8R2_FB23     = 0x800000   // Bit FB23.
	CAN_F8R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F8R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F8R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F8R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F8R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F8R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F8R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F8R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F8R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F8R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F8R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F8R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F8R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F8R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F8R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F8R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F8R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F8R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F8R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F8R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F8R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F8R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F8R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F8R2_FB31     = 0x80000000 // Bit FB31.

	// F9R1: Filter bank 9 register 1
	CAN_F9R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F9R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F9R1_FB0      = 0x1        // Bit FB0.
	CAN_F9R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F9R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F9R1_FB1      = 0x2        // Bit FB1.
	CAN_F9R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F9R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F9R1_FB2      = 0x4        // Bit FB2.
	CAN_F9R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F9R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F9R1_FB3      = 0x8        // Bit FB3.
	CAN_F9R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F9R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F9R1_FB4      = 0x10       // Bit FB4.
	CAN_F9R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F9R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F9R1_FB5      = 0x20       // Bit FB5.
	CAN_F9R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F9R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F9R1_FB6      = 0x40       // Bit FB6.
	CAN_F9R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F9R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F9R1_FB7      = 0x80       // Bit FB7.
	CAN_F9R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F9R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F9R1_FB8      = 0x100      // Bit FB8.
	CAN_F9R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F9R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F9R1_FB9      = 0x200      // Bit FB9.
	CAN_F9R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F9R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F9R1_FB10     = 0x400      // Bit FB10.
	CAN_F9R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F9R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F9R1_FB11     = 0x800      // Bit FB11.
	CAN_F9R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F9R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F9R1_FB12     = 0x1000     // Bit FB12.
	CAN_F9R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F9R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F9R1_FB13     = 0x2000     // Bit FB13.
	CAN_F9R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F9R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F9R1_FB14     = 0x4000     // Bit FB14.
	CAN_F9R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F9R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F9R1_FB15     = 0x8000     // Bit FB15.
	CAN_F9R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F9R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F9R1_FB16     = 0x10000    // Bit FB16.
	CAN_F9R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F9R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F9R1_FB17     = 0x20000    // Bit FB17.
	CAN_F9R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F9R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F9R1_FB18     = 0x40000    // Bit FB18.
	CAN_F9R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F9R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F9R1_FB19     = 0x80000    // Bit FB19.
	CAN_F9R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F9R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F9R1_FB20     = 0x100000   // Bit FB20.
	CAN_F9R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F9R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F9R1_FB21     = 0x200000   // Bit FB21.
	CAN_F9R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F9R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F9R1_FB22     = 0x400000   // Bit FB22.
	CAN_F9R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F9R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F9R1_FB23     = 0x800000   // Bit FB23.
	CAN_F9R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F9R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F9R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F9R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F9R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F9R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F9R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F9R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F9R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F9R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F9R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F9R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F9R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F9R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F9R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F9R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F9R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F9R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F9R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F9R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F9R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F9R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F9R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F9R1_FB31     = 0x80000000 // Bit FB31.

	// F9R2: Filter bank 9 register 2
	CAN_F9R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F9R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F9R2_FB0      = 0x1        // Bit FB0.
	CAN_F9R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F9R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F9R2_FB1      = 0x2        // Bit FB1.
	CAN_F9R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F9R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F9R2_FB2      = 0x4        // Bit FB2.
	CAN_F9R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F9R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F9R2_FB3      = 0x8        // Bit FB3.
	CAN_F9R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F9R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F9R2_FB4      = 0x10       // Bit FB4.
	CAN_F9R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F9R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F9R2_FB5      = 0x20       // Bit FB5.
	CAN_F9R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F9R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F9R2_FB6      = 0x40       // Bit FB6.
	CAN_F9R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F9R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F9R2_FB7      = 0x80       // Bit FB7.
	CAN_F9R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F9R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F9R2_FB8      = 0x100      // Bit FB8.
	CAN_F9R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F9R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F9R2_FB9      = 0x200      // Bit FB9.
	CAN_F9R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F9R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F9R2_FB10     = 0x400      // Bit FB10.
	CAN_F9R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F9R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F9R2_FB11     = 0x800      // Bit FB11.
	CAN_F9R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F9R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F9R2_FB12     = 0x1000     // Bit FB12.
	CAN_F9R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F9R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F9R2_FB13     = 0x2000     // Bit FB13.
	CAN_F9R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F9R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F9R2_FB14     = 0x4000     // Bit FB14.
	CAN_F9R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F9R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F9R2_FB15     = 0x8000     // Bit FB15.
	CAN_F9R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F9R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F9R2_FB16     = 0x10000    // Bit FB16.
	CAN_F9R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F9R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F9R2_FB17     = 0x20000    // Bit FB17.
	CAN_F9R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F9R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F9R2_FB18     = 0x40000    // Bit FB18.
	CAN_F9R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F9R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F9R2_FB19     = 0x80000    // Bit FB19.
	CAN_F9R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F9R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F9R2_FB20     = 0x100000   // Bit FB20.
	CAN_F9R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F9R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F9R2_FB21     = 0x200000   // Bit FB21.
	CAN_F9R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F9R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F9R2_FB22     = 0x400000   // Bit FB22.
	CAN_F9R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F9R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F9R2_FB23     = 0x800000   // Bit FB23.
	CAN_F9R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F9R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F9R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F9R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F9R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F9R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F9R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F9R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F9R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F9R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F9R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F9R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F9R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F9R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F9R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F9R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F9R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F9R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F9R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F9R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F9R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F9R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F9R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F9R2_FB31     = 0x80000000 // Bit FB31.

	// F10R1: Filter bank 10 register 1
	CAN_F10R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F10R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F10R1_FB0      = 0x1        // Bit FB0.
	CAN_F10R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F10R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F10R1_FB1      = 0x2        // Bit FB1.
	CAN_F10R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F10R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F10R1_FB2      = 0x4        // Bit FB2.
	CAN_F10R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F10R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F10R1_FB3      = 0x8        // Bit FB3.
	CAN_F10R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F10R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F10R1_FB4      = 0x10       // Bit FB4.
	CAN_F10R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F10R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F10R1_FB5      = 0x20       // Bit FB5.
	CAN_F10R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F10R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F10R1_FB6      = 0x40       // Bit FB6.
	CAN_F10R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F10R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F10R1_FB7      = 0x80       // Bit FB7.
	CAN_F10R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F10R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F10R1_FB8      = 0x100      // Bit FB8.
	CAN_F10R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F10R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F10R1_FB9      = 0x200      // Bit FB9.
	CAN_F10R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F10R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F10R1_FB10     = 0x400      // Bit FB10.
	CAN_F10R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F10R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F10R1_FB11     = 0x800      // Bit FB11.
	CAN_F10R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F10R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F10R1_FB12     = 0x1000     // Bit FB12.
	CAN_F10R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F10R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F10R1_FB13     = 0x2000     // Bit FB13.
	CAN_F10R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F10R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F10R1_FB14     = 0x4000     // Bit FB14.
	CAN_F10R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F10R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F10R1_FB15     = 0x8000     // Bit FB15.
	CAN_F10R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F10R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F10R1_FB16     = 0x10000    // Bit FB16.
	CAN_F10R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F10R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F10R1_FB17     = 0x20000    // Bit FB17.
	CAN_F10R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F10R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F10R1_FB18     = 0x40000    // Bit FB18.
	CAN_F10R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F10R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F10R1_FB19     = 0x80000    // Bit FB19.
	CAN_F10R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F10R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F10R1_FB20     = 0x100000   // Bit FB20.
	CAN_F10R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F10R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F10R1_FB21     = 0x200000   // Bit FB21.
	CAN_F10R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F10R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F10R1_FB22     = 0x400000   // Bit FB22.
	CAN_F10R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F10R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F10R1_FB23     = 0x800000   // Bit FB23.
	CAN_F10R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F10R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F10R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F10R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F10R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F10R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F10R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F10R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F10R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F10R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F10R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F10R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F10R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F10R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F10R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F10R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F10R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F10R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F10R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F10R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F10R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F10R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F10R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F10R1_FB31     = 0x80000000 // Bit FB31.

	// F10R2: Filter bank 10 register 2
	CAN_F10R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F10R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F10R2_FB0      = 0x1        // Bit FB0.
	CAN_F10R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F10R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F10R2_FB1      = 0x2        // Bit FB1.
	CAN_F10R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F10R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F10R2_FB2      = 0x4        // Bit FB2.
	CAN_F10R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F10R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F10R2_FB3      = 0x8        // Bit FB3.
	CAN_F10R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F10R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F10R2_FB4      = 0x10       // Bit FB4.
	CAN_F10R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F10R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F10R2_FB5      = 0x20       // Bit FB5.
	CAN_F10R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F10R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F10R2_FB6      = 0x40       // Bit FB6.
	CAN_F10R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F10R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F10R2_FB7      = 0x80       // Bit FB7.
	CAN_F10R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F10R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F10R2_FB8      = 0x100      // Bit FB8.
	CAN_F10R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F10R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F10R2_FB9      = 0x200      // Bit FB9.
	CAN_F10R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F10R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F10R2_FB10     = 0x400      // Bit FB10.
	CAN_F10R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F10R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F10R2_FB11     = 0x800      // Bit FB11.
	CAN_F10R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F10R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F10R2_FB12     = 0x1000     // Bit FB12.
	CAN_F10R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F10R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F10R2_FB13     = 0x2000     // Bit FB13.
	CAN_F10R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F10R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F10R2_FB14     = 0x4000     // Bit FB14.
	CAN_F10R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F10R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F10R2_FB15     = 0x8000     // Bit FB15.
	CAN_F10R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F10R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F10R2_FB16     = 0x10000    // Bit FB16.
	CAN_F10R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F10R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F10R2_FB17     = 0x20000    // Bit FB17.
	CAN_F10R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F10R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F10R2_FB18     = 0x40000    // Bit FB18.
	CAN_F10R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F10R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F10R2_FB19     = 0x80000    // Bit FB19.
	CAN_F10R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F10R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F10R2_FB20     = 0x100000   // Bit FB20.
	CAN_F10R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F10R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F10R2_FB21     = 0x200000   // Bit FB21.
	CAN_F10R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F10R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F10R2_FB22     = 0x400000   // Bit FB22.
	CAN_F10R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F10R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F10R2_FB23     = 0x800000   // Bit FB23.
	CAN_F10R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F10R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F10R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F10R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F10R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F10R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F10R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F10R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F10R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F10R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F10R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F10R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F10R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F10R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F10R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F10R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F10R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F10R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F10R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F10R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F10R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F10R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F10R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F10R2_FB31     = 0x80000000 // Bit FB31.

	// F11R1: Filter bank 11 register 1
	CAN_F11R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F11R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F11R1_FB0      = 0x1        // Bit FB0.
	CAN_F11R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F11R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F11R1_FB1      = 0x2        // Bit FB1.
	CAN_F11R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F11R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F11R1_FB2      = 0x4        // Bit FB2.
	CAN_F11R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F11R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F11R1_FB3      = 0x8        // Bit FB3.
	CAN_F11R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F11R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F11R1_FB4      = 0x10       // Bit FB4.
	CAN_F11R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F11R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F11R1_FB5      = 0x20       // Bit FB5.
	CAN_F11R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F11R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F11R1_FB6      = 0x40       // Bit FB6.
	CAN_F11R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F11R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F11R1_FB7      = 0x80       // Bit FB7.
	CAN_F11R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F11R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F11R1_FB8      = 0x100      // Bit FB8.
	CAN_F11R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F11R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F11R1_FB9      = 0x200      // Bit FB9.
	CAN_F11R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F11R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F11R1_FB10     = 0x400      // Bit FB10.
	CAN_F11R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F11R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F11R1_FB11     = 0x800      // Bit FB11.
	CAN_F11R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F11R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F11R1_FB12     = 0x1000     // Bit FB12.
	CAN_F11R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F11R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F11R1_FB13     = 0x2000     // Bit FB13.
	CAN_F11R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F11R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F11R1_FB14     = 0x4000     // Bit FB14.
	CAN_F11R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F11R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F11R1_FB15     = 0x8000     // Bit FB15.
	CAN_F11R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F11R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F11R1_FB16     = 0x10000    // Bit FB16.
	CAN_F11R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F11R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F11R1_FB17     = 0x20000    // Bit FB17.
	CAN_F11R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F11R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F11R1_FB18     = 0x40000    // Bit FB18.
	CAN_F11R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F11R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F11R1_FB19     = 0x80000    // Bit FB19.
	CAN_F11R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F11R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F11R1_FB20     = 0x100000   // Bit FB20.
	CAN_F11R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F11R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F11R1_FB21     = 0x200000   // Bit FB21.
	CAN_F11R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F11R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F11R1_FB22     = 0x400000   // Bit FB22.
	CAN_F11R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F11R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F11R1_FB23     = 0x800000   // Bit FB23.
	CAN_F11R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F11R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F11R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F11R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F11R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F11R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F11R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F11R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F11R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F11R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F11R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F11R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F11R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F11R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F11R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F11R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F11R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F11R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F11R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F11R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F11R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F11R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F11R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F11R1_FB31     = 0x80000000 // Bit FB31.

	// F11R2: Filter bank 11 register 2
	CAN_F11R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F11R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F11R2_FB0      = 0x1        // Bit FB0.
	CAN_F11R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F11R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F11R2_FB1      = 0x2        // Bit FB1.
	CAN_F11R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F11R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F11R2_FB2      = 0x4        // Bit FB2.
	CAN_F11R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F11R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F11R2_FB3      = 0x8        // Bit FB3.
	CAN_F11R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F11R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F11R2_FB4      = 0x10       // Bit FB4.
	CAN_F11R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F11R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F11R2_FB5      = 0x20       // Bit FB5.
	CAN_F11R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F11R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F11R2_FB6      = 0x40       // Bit FB6.
	CAN_F11R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F11R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F11R2_FB7      = 0x80       // Bit FB7.
	CAN_F11R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F11R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F11R2_FB8      = 0x100      // Bit FB8.
	CAN_F11R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F11R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F11R2_FB9      = 0x200      // Bit FB9.
	CAN_F11R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F11R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F11R2_FB10     = 0x400      // Bit FB10.
	CAN_F11R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F11R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F11R2_FB11     = 0x800      // Bit FB11.
	CAN_F11R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F11R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F11R2_FB12     = 0x1000     // Bit FB12.
	CAN_F11R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F11R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F11R2_FB13     = 0x2000     // Bit FB13.
	CAN_F11R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F11R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F11R2_FB14     = 0x4000     // Bit FB14.
	CAN_F11R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F11R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F11R2_FB15     = 0x8000     // Bit FB15.
	CAN_F11R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F11R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F11R2_FB16     = 0x10000    // Bit FB16.
	CAN_F11R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F11R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F11R2_FB17     = 0x20000    // Bit FB17.
	CAN_F11R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F11R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F11R2_FB18     = 0x40000    // Bit FB18.
	CAN_F11R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F11R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F11R2_FB19     = 0x80000    // Bit FB19.
	CAN_F11R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F11R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F11R2_FB20     = 0x100000   // Bit FB20.
	CAN_F11R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F11R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F11R2_FB21     = 0x200000   // Bit FB21.
	CAN_F11R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F11R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F11R2_FB22     = 0x400000   // Bit FB22.
	CAN_F11R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F11R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F11R2_FB23     = 0x800000   // Bit FB23.
	CAN_F11R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F11R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F11R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F11R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F11R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F11R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F11R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F11R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F11R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F11R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F11R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F11R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F11R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F11R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F11R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F11R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F11R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F11R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F11R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F11R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F11R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F11R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F11R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F11R2_FB31     = 0x80000000 // Bit FB31.

	// F12R1: Filter bank 4 register 1
	CAN_F12R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F12R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F12R1_FB0      = 0x1        // Bit FB0.
	CAN_F12R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F12R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F12R1_FB1      = 0x2        // Bit FB1.
	CAN_F12R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F12R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F12R1_FB2      = 0x4        // Bit FB2.
	CAN_F12R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F12R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F12R1_FB3      = 0x8        // Bit FB3.
	CAN_F12R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F12R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F12R1_FB4      = 0x10       // Bit FB4.
	CAN_F12R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F12R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F12R1_FB5      = 0x20       // Bit FB5.
	CAN_F12R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F12R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F12R1_FB6      = 0x40       // Bit FB6.
	CAN_F12R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F12R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F12R1_FB7      = 0x80       // Bit FB7.
	CAN_F12R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F12R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F12R1_FB8      = 0x100      // Bit FB8.
	CAN_F12R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F12R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F12R1_FB9      = 0x200      // Bit FB9.
	CAN_F12R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F12R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F12R1_FB10     = 0x400      // Bit FB10.
	CAN_F12R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F12R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F12R1_FB11     = 0x800      // Bit FB11.
	CAN_F12R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F12R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F12R1_FB12     = 0x1000     // Bit FB12.
	CAN_F12R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F12R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F12R1_FB13     = 0x2000     // Bit FB13.
	CAN_F12R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F12R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F12R1_FB14     = 0x4000     // Bit FB14.
	CAN_F12R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F12R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F12R1_FB15     = 0x8000     // Bit FB15.
	CAN_F12R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F12R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F12R1_FB16     = 0x10000    // Bit FB16.
	CAN_F12R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F12R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F12R1_FB17     = 0x20000    // Bit FB17.
	CAN_F12R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F12R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F12R1_FB18     = 0x40000    // Bit FB18.
	CAN_F12R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F12R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F12R1_FB19     = 0x80000    // Bit FB19.
	CAN_F12R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F12R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F12R1_FB20     = 0x100000   // Bit FB20.
	CAN_F12R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F12R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F12R1_FB21     = 0x200000   // Bit FB21.
	CAN_F12R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F12R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F12R1_FB22     = 0x400000   // Bit FB22.
	CAN_F12R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F12R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F12R1_FB23     = 0x800000   // Bit FB23.
	CAN_F12R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F12R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F12R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F12R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F12R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F12R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F12R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F12R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F12R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F12R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F12R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F12R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F12R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F12R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F12R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F12R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F12R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F12R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F12R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F12R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F12R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F12R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F12R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F12R1_FB31     = 0x80000000 // Bit FB31.

	// F12R2: Filter bank 12 register 2
	CAN_F12R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F12R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F12R2_FB0      = 0x1        // Bit FB0.
	CAN_F12R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F12R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F12R2_FB1      = 0x2        // Bit FB1.
	CAN_F12R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F12R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F12R2_FB2      = 0x4        // Bit FB2.
	CAN_F12R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F12R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F12R2_FB3      = 0x8        // Bit FB3.
	CAN_F12R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F12R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F12R2_FB4      = 0x10       // Bit FB4.
	CAN_F12R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F12R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F12R2_FB5      = 0x20       // Bit FB5.
	CAN_F12R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F12R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F12R2_FB6      = 0x40       // Bit FB6.
	CAN_F12R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F12R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F12R2_FB7      = 0x80       // Bit FB7.
	CAN_F12R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F12R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F12R2_FB8      = 0x100      // Bit FB8.
	CAN_F12R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F12R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F12R2_FB9      = 0x200      // Bit FB9.
	CAN_F12R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F12R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F12R2_FB10     = 0x400      // Bit FB10.
	CAN_F12R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F12R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F12R2_FB11     = 0x800      // Bit FB11.
	CAN_F12R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F12R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F12R2_FB12     = 0x1000     // Bit FB12.
	CAN_F12R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F12R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F12R2_FB13     = 0x2000     // Bit FB13.
	CAN_F12R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F12R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F12R2_FB14     = 0x4000     // Bit FB14.
	CAN_F12R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F12R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F12R2_FB15     = 0x8000     // Bit FB15.
	CAN_F12R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F12R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F12R2_FB16     = 0x10000    // Bit FB16.
	CAN_F12R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F12R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F12R2_FB17     = 0x20000    // Bit FB17.
	CAN_F12R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F12R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F12R2_FB18     = 0x40000    // Bit FB18.
	CAN_F12R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F12R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F12R2_FB19     = 0x80000    // Bit FB19.
	CAN_F12R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F12R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F12R2_FB20     = 0x100000   // Bit FB20.
	CAN_F12R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F12R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F12R2_FB21     = 0x200000   // Bit FB21.
	CAN_F12R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F12R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F12R2_FB22     = 0x400000   // Bit FB22.
	CAN_F12R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F12R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F12R2_FB23     = 0x800000   // Bit FB23.
	CAN_F12R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F12R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F12R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F12R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F12R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F12R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F12R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F12R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F12R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F12R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F12R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F12R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F12R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F12R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F12R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F12R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F12R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F12R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F12R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F12R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F12R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F12R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F12R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F12R2_FB31     = 0x80000000 // Bit FB31.

	// F13R1: Filter bank 13 register 1
	CAN_F13R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F13R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F13R1_FB0      = 0x1        // Bit FB0.
	CAN_F13R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F13R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F13R1_FB1      = 0x2        // Bit FB1.
	CAN_F13R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F13R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F13R1_FB2      = 0x4        // Bit FB2.
	CAN_F13R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F13R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F13R1_FB3      = 0x8        // Bit FB3.
	CAN_F13R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F13R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F13R1_FB4      = 0x10       // Bit FB4.
	CAN_F13R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F13R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F13R1_FB5      = 0x20       // Bit FB5.
	CAN_F13R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F13R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F13R1_FB6      = 0x40       // Bit FB6.
	CAN_F13R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F13R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F13R1_FB7      = 0x80       // Bit FB7.
	CAN_F13R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F13R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F13R1_FB8      = 0x100      // Bit FB8.
	CAN_F13R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F13R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F13R1_FB9      = 0x200      // Bit FB9.
	CAN_F13R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F13R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F13R1_FB10     = 0x400      // Bit FB10.
	CAN_F13R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F13R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F13R1_FB11     = 0x800      // Bit FB11.
	CAN_F13R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F13R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F13R1_FB12     = 0x1000     // Bit FB12.
	CAN_F13R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F13R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F13R1_FB13     = 0x2000     // Bit FB13.
	CAN_F13R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F13R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F13R1_FB14     = 0x4000     // Bit FB14.
	CAN_F13R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F13R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F13R1_FB15     = 0x8000     // Bit FB15.
	CAN_F13R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F13R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F13R1_FB16     = 0x10000    // Bit FB16.
	CAN_F13R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F13R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F13R1_FB17     = 0x20000    // Bit FB17.
	CAN_F13R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F13R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F13R1_FB18     = 0x40000    // Bit FB18.
	CAN_F13R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F13R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F13R1_FB19     = 0x80000    // Bit FB19.
	CAN_F13R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F13R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F13R1_FB20     = 0x100000   // Bit FB20.
	CAN_F13R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F13R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F13R1_FB21     = 0x200000   // Bit FB21.
	CAN_F13R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F13R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F13R1_FB22     = 0x400000   // Bit FB22.
	CAN_F13R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F13R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F13R1_FB23     = 0x800000   // Bit FB23.
	CAN_F13R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F13R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F13R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F13R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F13R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F13R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F13R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F13R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F13R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F13R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F13R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F13R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F13R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F13R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F13R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F13R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F13R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F13R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F13R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F13R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F13R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F13R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F13R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F13R1_FB31     = 0x80000000 // Bit FB31.

	// F13R2: Filter bank 13 register 2
	CAN_F13R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F13R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F13R2_FB0      = 0x1        // Bit FB0.
	CAN_F13R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F13R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F13R2_FB1      = 0x2        // Bit FB1.
	CAN_F13R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F13R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F13R2_FB2      = 0x4        // Bit FB2.
	CAN_F13R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F13R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F13R2_FB3      = 0x8        // Bit FB3.
	CAN_F13R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F13R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F13R2_FB4      = 0x10       // Bit FB4.
	CAN_F13R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F13R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F13R2_FB5      = 0x20       // Bit FB5.
	CAN_F13R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F13R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F13R2_FB6      = 0x40       // Bit FB6.
	CAN_F13R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F13R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F13R2_FB7      = 0x80       // Bit FB7.
	CAN_F13R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F13R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F13R2_FB8      = 0x100      // Bit FB8.
	CAN_F13R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F13R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F13R2_FB9      = 0x200      // Bit FB9.
	CAN_F13R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F13R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F13R2_FB10     = 0x400      // Bit FB10.
	CAN_F13R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F13R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F13R2_FB11     = 0x800      // Bit FB11.
	CAN_F13R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F13R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F13R2_FB12     = 0x1000     // Bit FB12.
	CAN_F13R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F13R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F13R2_FB13     = 0x2000     // Bit FB13.
	CAN_F13R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F13R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F13R2_FB14     = 0x4000     // Bit FB14.
	CAN_F13R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F13R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F13R2_FB15     = 0x8000     // Bit FB15.
	CAN_F13R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F13R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F13R2_FB16     = 0x10000    // Bit FB16.
	CAN_F13R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F13R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F13R2_FB17     = 0x20000    // Bit FB17.
	CAN_F13R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F13R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F13R2_FB18     = 0x40000    // Bit FB18.
	CAN_F13R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F13R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F13R2_FB19     = 0x80000    // Bit FB19.
	CAN_F13R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F13R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F13R2_FB20     = 0x100000   // Bit FB20.
	CAN_F13R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F13R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F13R2_FB21     = 0x200000   // Bit FB21.
	CAN_F13R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F13R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F13R2_FB22     = 0x400000   // Bit FB22.
	CAN_F13R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F13R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F13R2_FB23     = 0x800000   // Bit FB23.
	CAN_F13R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F13R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F13R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F13R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F13R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F13R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F13R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F13R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F13R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F13R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F13R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F13R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F13R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F13R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F13R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F13R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F13R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F13R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F13R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F13R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F13R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F13R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F13R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F13R2_FB31     = 0x80000000 // Bit FB31.

	// F14R1: Filter bank 14 register 1
	CAN_F14R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F14R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F14R1_FB0      = 0x1        // Bit FB0.
	CAN_F14R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F14R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F14R1_FB1      = 0x2        // Bit FB1.
	CAN_F14R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F14R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F14R1_FB2      = 0x4        // Bit FB2.
	CAN_F14R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F14R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F14R1_FB3      = 0x8        // Bit FB3.
	CAN_F14R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F14R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F14R1_FB4      = 0x10       // Bit FB4.
	CAN_F14R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F14R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F14R1_FB5      = 0x20       // Bit FB5.
	CAN_F14R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F14R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F14R1_FB6      = 0x40       // Bit FB6.
	CAN_F14R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F14R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F14R1_FB7      = 0x80       // Bit FB7.
	CAN_F14R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F14R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F14R1_FB8      = 0x100      // Bit FB8.
	CAN_F14R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F14R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F14R1_FB9      = 0x200      // Bit FB9.
	CAN_F14R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F14R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F14R1_FB10     = 0x400      // Bit FB10.
	CAN_F14R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F14R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F14R1_FB11     = 0x800      // Bit FB11.
	CAN_F14R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F14R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F14R1_FB12     = 0x1000     // Bit FB12.
	CAN_F14R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F14R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F14R1_FB13     = 0x2000     // Bit FB13.
	CAN_F14R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F14R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F14R1_FB14     = 0x4000     // Bit FB14.
	CAN_F14R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F14R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F14R1_FB15     = 0x8000     // Bit FB15.
	CAN_F14R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F14R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F14R1_FB16     = 0x10000    // Bit FB16.
	CAN_F14R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F14R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F14R1_FB17     = 0x20000    // Bit FB17.
	CAN_F14R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F14R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F14R1_FB18     = 0x40000    // Bit FB18.
	CAN_F14R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F14R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F14R1_FB19     = 0x80000    // Bit FB19.
	CAN_F14R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F14R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F14R1_FB20     = 0x100000   // Bit FB20.
	CAN_F14R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F14R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F14R1_FB21     = 0x200000   // Bit FB21.
	CAN_F14R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F14R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F14R1_FB22     = 0x400000   // Bit FB22.
	CAN_F14R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F14R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F14R1_FB23     = 0x800000   // Bit FB23.
	CAN_F14R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F14R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F14R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F14R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F14R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F14R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F14R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F14R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F14R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F14R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F14R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F14R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F14R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F14R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F14R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F14R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F14R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F14R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F14R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F14R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F14R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F14R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F14R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F14R1_FB31     = 0x80000000 // Bit FB31.

	// F14R2: Filter bank 14 register 2
	CAN_F14R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F14R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F14R2_FB0      = 0x1        // Bit FB0.
	CAN_F14R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F14R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F14R2_FB1      = 0x2        // Bit FB1.
	CAN_F14R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F14R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F14R2_FB2      = 0x4        // Bit FB2.
	CAN_F14R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F14R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F14R2_FB3      = 0x8        // Bit FB3.
	CAN_F14R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F14R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F14R2_FB4      = 0x10       // Bit FB4.
	CAN_F14R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F14R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F14R2_FB5      = 0x20       // Bit FB5.
	CAN_F14R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F14R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F14R2_FB6      = 0x40       // Bit FB6.
	CAN_F14R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F14R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F14R2_FB7      = 0x80       // Bit FB7.
	CAN_F14R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F14R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F14R2_FB8      = 0x100      // Bit FB8.
	CAN_F14R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F14R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F14R2_FB9      = 0x200      // Bit FB9.
	CAN_F14R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F14R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F14R2_FB10     = 0x400      // Bit FB10.
	CAN_F14R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F14R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F14R2_FB11     = 0x800      // Bit FB11.
	CAN_F14R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F14R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F14R2_FB12     = 0x1000     // Bit FB12.
	CAN_F14R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F14R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F14R2_FB13     = 0x2000     // Bit FB13.
	CAN_F14R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F14R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F14R2_FB14     = 0x4000     // Bit FB14.
	CAN_F14R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F14R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F14R2_FB15     = 0x8000     // Bit FB15.
	CAN_F14R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F14R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F14R2_FB16     = 0x10000    // Bit FB16.
	CAN_F14R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F14R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F14R2_FB17     = 0x20000    // Bit FB17.
	CAN_F14R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F14R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F14R2_FB18     = 0x40000    // Bit FB18.
	CAN_F14R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F14R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F14R2_FB19     = 0x80000    // Bit FB19.
	CAN_F14R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F14R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F14R2_FB20     = 0x100000   // Bit FB20.
	CAN_F14R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F14R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F14R2_FB21     = 0x200000   // Bit FB21.
	CAN_F14R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F14R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F14R2_FB22     = 0x400000   // Bit FB22.
	CAN_F14R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F14R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F14R2_FB23     = 0x800000   // Bit FB23.
	CAN_F14R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F14R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F14R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F14R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F14R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F14R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F14R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F14R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F14R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F14R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F14R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F14R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F14R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F14R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F14R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F14R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F14R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F14R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F14R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F14R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F14R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F14R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F14R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F14R2_FB31     = 0x80000000 // Bit FB31.

	// F15R1: Filter bank 15 register 1
	CAN_F15R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F15R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F15R1_FB0      = 0x1        // Bit FB0.
	CAN_F15R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F15R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F15R1_FB1      = 0x2        // Bit FB1.
	CAN_F15R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F15R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F15R1_FB2      = 0x4        // Bit FB2.
	CAN_F15R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F15R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F15R1_FB3      = 0x8        // Bit FB3.
	CAN_F15R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F15R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F15R1_FB4      = 0x10       // Bit FB4.
	CAN_F15R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F15R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F15R1_FB5      = 0x20       // Bit FB5.
	CAN_F15R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F15R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F15R1_FB6      = 0x40       // Bit FB6.
	CAN_F15R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F15R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F15R1_FB7      = 0x80       // Bit FB7.
	CAN_F15R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F15R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F15R1_FB8      = 0x100      // Bit FB8.
	CAN_F15R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F15R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F15R1_FB9      = 0x200      // Bit FB9.
	CAN_F15R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F15R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F15R1_FB10     = 0x400      // Bit FB10.
	CAN_F15R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F15R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F15R1_FB11     = 0x800      // Bit FB11.
	CAN_F15R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F15R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F15R1_FB12     = 0x1000     // Bit FB12.
	CAN_F15R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F15R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F15R1_FB13     = 0x2000     // Bit FB13.
	CAN_F15R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F15R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F15R1_FB14     = 0x4000     // Bit FB14.
	CAN_F15R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F15R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F15R1_FB15     = 0x8000     // Bit FB15.
	CAN_F15R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F15R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F15R1_FB16     = 0x10000    // Bit FB16.
	CAN_F15R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F15R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F15R1_FB17     = 0x20000    // Bit FB17.
	CAN_F15R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F15R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F15R1_FB18     = 0x40000    // Bit FB18.
	CAN_F15R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F15R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F15R1_FB19     = 0x80000    // Bit FB19.
	CAN_F15R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F15R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F15R1_FB20     = 0x100000   // Bit FB20.
	CAN_F15R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F15R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F15R1_FB21     = 0x200000   // Bit FB21.
	CAN_F15R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F15R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F15R1_FB22     = 0x400000   // Bit FB22.
	CAN_F15R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F15R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F15R1_FB23     = 0x800000   // Bit FB23.
	CAN_F15R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F15R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F15R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F15R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F15R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F15R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F15R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F15R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F15R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F15R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F15R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F15R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F15R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F15R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F15R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F15R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F15R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F15R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F15R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F15R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F15R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F15R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F15R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F15R1_FB31     = 0x80000000 // Bit FB31.

	// F15R2: Filter bank 15 register 2
	CAN_F15R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F15R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F15R2_FB0      = 0x1        // Bit FB0.
	CAN_F15R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F15R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F15R2_FB1      = 0x2        // Bit FB1.
	CAN_F15R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F15R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F15R2_FB2      = 0x4        // Bit FB2.
	CAN_F15R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F15R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F15R2_FB3      = 0x8        // Bit FB3.
	CAN_F15R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F15R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F15R2_FB4      = 0x10       // Bit FB4.
	CAN_F15R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F15R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F15R2_FB5      = 0x20       // Bit FB5.
	CAN_F15R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F15R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F15R2_FB6      = 0x40       // Bit FB6.
	CAN_F15R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F15R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F15R2_FB7      = 0x80       // Bit FB7.
	CAN_F15R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F15R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F15R2_FB8      = 0x100      // Bit FB8.
	CAN_F15R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F15R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F15R2_FB9      = 0x200      // Bit FB9.
	CAN_F15R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F15R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F15R2_FB10     = 0x400      // Bit FB10.
	CAN_F15R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F15R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F15R2_FB11     = 0x800      // Bit FB11.
	CAN_F15R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F15R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F15R2_FB12     = 0x1000     // Bit FB12.
	CAN_F15R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F15R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F15R2_FB13     = 0x2000     // Bit FB13.
	CAN_F15R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F15R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F15R2_FB14     = 0x4000     // Bit FB14.
	CAN_F15R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F15R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F15R2_FB15     = 0x8000     // Bit FB15.
	CAN_F15R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F15R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F15R2_FB16     = 0x10000    // Bit FB16.
	CAN_F15R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F15R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F15R2_FB17     = 0x20000    // Bit FB17.
	CAN_F15R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F15R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F15R2_FB18     = 0x40000    // Bit FB18.
	CAN_F15R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F15R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F15R2_FB19     = 0x80000    // Bit FB19.
	CAN_F15R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F15R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F15R2_FB20     = 0x100000   // Bit FB20.
	CAN_F15R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F15R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F15R2_FB21     = 0x200000   // Bit FB21.
	CAN_F15R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F15R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F15R2_FB22     = 0x400000   // Bit FB22.
	CAN_F15R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F15R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F15R2_FB23     = 0x800000   // Bit FB23.
	CAN_F15R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F15R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F15R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F15R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F15R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F15R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F15R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F15R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F15R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F15R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F15R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F15R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F15R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F15R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F15R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F15R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F15R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F15R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F15R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F15R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F15R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F15R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F15R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F15R2_FB31     = 0x80000000 // Bit FB31.

	// F16R1: Filter bank 16 register 1
	CAN_F16R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F16R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F16R1_FB0      = 0x1        // Bit FB0.
	CAN_F16R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F16R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F16R1_FB1      = 0x2        // Bit FB1.
	CAN_F16R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F16R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F16R1_FB2      = 0x4        // Bit FB2.
	CAN_F16R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F16R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F16R1_FB3      = 0x8        // Bit FB3.
	CAN_F16R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F16R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F16R1_FB4      = 0x10       // Bit FB4.
	CAN_F16R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F16R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F16R1_FB5      = 0x20       // Bit FB5.
	CAN_F16R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F16R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F16R1_FB6      = 0x40       // Bit FB6.
	CAN_F16R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F16R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F16R1_FB7      = 0x80       // Bit FB7.
	CAN_F16R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F16R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F16R1_FB8      = 0x100      // Bit FB8.
	CAN_F16R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F16R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F16R1_FB9      = 0x200      // Bit FB9.
	CAN_F16R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F16R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F16R1_FB10     = 0x400      // Bit FB10.
	CAN_F16R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F16R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F16R1_FB11     = 0x800      // Bit FB11.
	CAN_F16R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F16R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F16R1_FB12     = 0x1000     // Bit FB12.
	CAN_F16R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F16R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F16R1_FB13     = 0x2000     // Bit FB13.
	CAN_F16R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F16R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F16R1_FB14     = 0x4000     // Bit FB14.
	CAN_F16R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F16R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F16R1_FB15     = 0x8000     // Bit FB15.
	CAN_F16R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F16R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F16R1_FB16     = 0x10000    // Bit FB16.
	CAN_F16R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F16R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F16R1_FB17     = 0x20000    // Bit FB17.
	CAN_F16R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F16R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F16R1_FB18     = 0x40000    // Bit FB18.
	CAN_F16R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F16R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F16R1_FB19     = 0x80000    // Bit FB19.
	CAN_F16R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F16R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F16R1_FB20     = 0x100000   // Bit FB20.
	CAN_F16R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F16R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F16R1_FB21     = 0x200000   // Bit FB21.
	CAN_F16R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F16R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F16R1_FB22     = 0x400000   // Bit FB22.
	CAN_F16R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F16R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F16R1_FB23     = 0x800000   // Bit FB23.
	CAN_F16R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F16R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F16R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F16R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F16R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F16R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F16R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F16R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F16R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F16R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F16R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F16R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F16R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F16R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F16R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F16R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F16R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F16R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F16R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F16R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F16R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F16R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F16R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F16R1_FB31     = 0x80000000 // Bit FB31.

	// F16R2: Filter bank 16 register 2
	CAN_F16R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F16R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F16R2_FB0      = 0x1        // Bit FB0.
	CAN_F16R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F16R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F16R2_FB1      = 0x2        // Bit FB1.
	CAN_F16R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F16R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F16R2_FB2      = 0x4        // Bit FB2.
	CAN_F16R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F16R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F16R2_FB3      = 0x8        // Bit FB3.
	CAN_F16R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F16R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F16R2_FB4      = 0x10       // Bit FB4.
	CAN_F16R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F16R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F16R2_FB5      = 0x20       // Bit FB5.
	CAN_F16R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F16R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F16R2_FB6      = 0x40       // Bit FB6.
	CAN_F16R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F16R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F16R2_FB7      = 0x80       // Bit FB7.
	CAN_F16R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F16R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F16R2_FB8      = 0x100      // Bit FB8.
	CAN_F16R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F16R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F16R2_FB9      = 0x200      // Bit FB9.
	CAN_F16R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F16R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F16R2_FB10     = 0x400      // Bit FB10.
	CAN_F16R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F16R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F16R2_FB11     = 0x800      // Bit FB11.
	CAN_F16R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F16R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F16R2_FB12     = 0x1000     // Bit FB12.
	CAN_F16R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F16R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F16R2_FB13     = 0x2000     // Bit FB13.
	CAN_F16R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F16R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F16R2_FB14     = 0x4000     // Bit FB14.
	CAN_F16R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F16R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F16R2_FB15     = 0x8000     // Bit FB15.
	CAN_F16R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F16R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F16R2_FB16     = 0x10000    // Bit FB16.
	CAN_F16R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F16R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F16R2_FB17     = 0x20000    // Bit FB17.
	CAN_F16R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F16R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F16R2_FB18     = 0x40000    // Bit FB18.
	CAN_F16R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F16R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F16R2_FB19     = 0x80000    // Bit FB19.
	CAN_F16R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F16R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F16R2_FB20     = 0x100000   // Bit FB20.
	CAN_F16R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F16R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F16R2_FB21     = 0x200000   // Bit FB21.
	CAN_F16R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F16R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F16R2_FB22     = 0x400000   // Bit FB22.
	CAN_F16R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F16R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F16R2_FB23     = 0x800000   // Bit FB23.
	CAN_F16R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F16R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F16R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F16R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F16R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F16R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F16R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F16R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F16R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F16R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F16R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F16R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F16R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F16R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F16R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F16R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F16R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F16R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F16R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F16R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F16R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F16R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F16R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F16R2_FB31     = 0x80000000 // Bit FB31.

	// F17R1: Filter bank 17 register 1
	CAN_F17R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F17R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F17R1_FB0      = 0x1        // Bit FB0.
	CAN_F17R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F17R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F17R1_FB1      = 0x2        // Bit FB1.
	CAN_F17R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F17R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F17R1_FB2      = 0x4        // Bit FB2.
	CAN_F17R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F17R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F17R1_FB3      = 0x8        // Bit FB3.
	CAN_F17R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F17R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F17R1_FB4      = 0x10       // Bit FB4.
	CAN_F17R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F17R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F17R1_FB5      = 0x20       // Bit FB5.
	CAN_F17R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F17R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F17R1_FB6      = 0x40       // Bit FB6.
	CAN_F17R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F17R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F17R1_FB7      = 0x80       // Bit FB7.
	CAN_F17R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F17R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F17R1_FB8      = 0x100      // Bit FB8.
	CAN_F17R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F17R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F17R1_FB9      = 0x200      // Bit FB9.
	CAN_F17R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F17R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F17R1_FB10     = 0x400      // Bit FB10.
	CAN_F17R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F17R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F17R1_FB11     = 0x800      // Bit FB11.
	CAN_F17R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F17R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F17R1_FB12     = 0x1000     // Bit FB12.
	CAN_F17R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F17R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F17R1_FB13     = 0x2000     // Bit FB13.
	CAN_F17R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F17R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F17R1_FB14     = 0x4000     // Bit FB14.
	CAN_F17R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F17R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F17R1_FB15     = 0x8000     // Bit FB15.
	CAN_F17R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F17R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F17R1_FB16     = 0x10000    // Bit FB16.
	CAN_F17R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F17R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F17R1_FB17     = 0x20000    // Bit FB17.
	CAN_F17R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F17R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F17R1_FB18     = 0x40000    // Bit FB18.
	CAN_F17R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F17R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F17R1_FB19     = 0x80000    // Bit FB19.
	CAN_F17R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F17R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F17R1_FB20     = 0x100000   // Bit FB20.
	CAN_F17R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F17R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F17R1_FB21     = 0x200000   // Bit FB21.
	CAN_F17R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F17R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F17R1_FB22     = 0x400000   // Bit FB22.
	CAN_F17R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F17R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F17R1_FB23     = 0x800000   // Bit FB23.
	CAN_F17R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F17R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F17R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F17R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F17R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F17R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F17R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F17R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F17R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F17R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F17R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F17R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F17R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F17R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F17R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F17R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F17R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F17R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F17R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F17R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F17R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F17R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F17R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F17R1_FB31     = 0x80000000 // Bit FB31.

	// F17R2: Filter bank 17 register 2
	CAN_F17R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F17R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F17R2_FB0      = 0x1        // Bit FB0.
	CAN_F17R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F17R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F17R2_FB1      = 0x2        // Bit FB1.
	CAN_F17R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F17R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F17R2_FB2      = 0x4        // Bit FB2.
	CAN_F17R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F17R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F17R2_FB3      = 0x8        // Bit FB3.
	CAN_F17R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F17R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F17R2_FB4      = 0x10       // Bit FB4.
	CAN_F17R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F17R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F17R2_FB5      = 0x20       // Bit FB5.
	CAN_F17R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F17R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F17R2_FB6      = 0x40       // Bit FB6.
	CAN_F17R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F17R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F17R2_FB7      = 0x80       // Bit FB7.
	CAN_F17R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F17R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F17R2_FB8      = 0x100      // Bit FB8.
	CAN_F17R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F17R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F17R2_FB9      = 0x200      // Bit FB9.
	CAN_F17R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F17R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F17R2_FB10     = 0x400      // Bit FB10.
	CAN_F17R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F17R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F17R2_FB11     = 0x800      // Bit FB11.
	CAN_F17R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F17R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F17R2_FB12     = 0x1000     // Bit FB12.
	CAN_F17R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F17R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F17R2_FB13     = 0x2000     // Bit FB13.
	CAN_F17R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F17R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F17R2_FB14     = 0x4000     // Bit FB14.
	CAN_F17R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F17R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F17R2_FB15     = 0x8000     // Bit FB15.
	CAN_F17R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F17R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F17R2_FB16     = 0x10000    // Bit FB16.
	CAN_F17R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F17R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F17R2_FB17     = 0x20000    // Bit FB17.
	CAN_F17R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F17R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F17R2_FB18     = 0x40000    // Bit FB18.
	CAN_F17R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F17R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F17R2_FB19     = 0x80000    // Bit FB19.
	CAN_F17R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F17R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F17R2_FB20     = 0x100000   // Bit FB20.
	CAN_F17R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F17R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F17R2_FB21     = 0x200000   // Bit FB21.
	CAN_F17R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F17R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F17R2_FB22     = 0x400000   // Bit FB22.
	CAN_F17R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F17R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F17R2_FB23     = 0x800000   // Bit FB23.
	CAN_F17R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F17R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F17R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F17R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F17R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F17R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F17R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F17R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F17R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F17R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F17R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F17R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F17R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F17R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F17R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F17R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F17R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F17R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F17R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F17R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F17R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F17R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F17R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F17R2_FB31     = 0x80000000 // Bit FB31.

	// F18R1: Filter bank 18 register 1
	CAN_F18R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F18R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F18R1_FB0      = 0x1        // Bit FB0.
	CAN_F18R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F18R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F18R1_FB1      = 0x2        // Bit FB1.
	CAN_F18R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F18R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F18R1_FB2      = 0x4        // Bit FB2.
	CAN_F18R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F18R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F18R1_FB3      = 0x8        // Bit FB3.
	CAN_F18R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F18R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F18R1_FB4      = 0x10       // Bit FB4.
	CAN_F18R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F18R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F18R1_FB5      = 0x20       // Bit FB5.
	CAN_F18R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F18R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F18R1_FB6      = 0x40       // Bit FB6.
	CAN_F18R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F18R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F18R1_FB7      = 0x80       // Bit FB7.
	CAN_F18R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F18R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F18R1_FB8      = 0x100      // Bit FB8.
	CAN_F18R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F18R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F18R1_FB9      = 0x200      // Bit FB9.
	CAN_F18R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F18R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F18R1_FB10     = 0x400      // Bit FB10.
	CAN_F18R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F18R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F18R1_FB11     = 0x800      // Bit FB11.
	CAN_F18R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F18R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F18R1_FB12     = 0x1000     // Bit FB12.
	CAN_F18R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F18R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F18R1_FB13     = 0x2000     // Bit FB13.
	CAN_F18R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F18R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F18R1_FB14     = 0x4000     // Bit FB14.
	CAN_F18R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F18R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F18R1_FB15     = 0x8000     // Bit FB15.
	CAN_F18R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F18R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F18R1_FB16     = 0x10000    // Bit FB16.
	CAN_F18R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F18R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F18R1_FB17     = 0x20000    // Bit FB17.
	CAN_F18R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F18R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F18R1_FB18     = 0x40000    // Bit FB18.
	CAN_F18R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F18R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F18R1_FB19     = 0x80000    // Bit FB19.
	CAN_F18R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F18R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F18R1_FB20     = 0x100000   // Bit FB20.
	CAN_F18R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F18R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F18R1_FB21     = 0x200000   // Bit FB21.
	CAN_F18R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F18R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F18R1_FB22     = 0x400000   // Bit FB22.
	CAN_F18R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F18R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F18R1_FB23     = 0x800000   // Bit FB23.
	CAN_F18R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F18R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F18R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F18R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F18R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F18R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F18R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F18R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F18R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F18R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F18R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F18R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F18R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F18R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F18R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F18R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F18R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F18R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F18R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F18R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F18R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F18R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F18R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F18R1_FB31     = 0x80000000 // Bit FB31.

	// F18R2: Filter bank 18 register 2
	CAN_F18R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F18R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F18R2_FB0      = 0x1        // Bit FB0.
	CAN_F18R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F18R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F18R2_FB1      = 0x2        // Bit FB1.
	CAN_F18R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F18R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F18R2_FB2      = 0x4        // Bit FB2.
	CAN_F18R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F18R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F18R2_FB3      = 0x8        // Bit FB3.
	CAN_F18R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F18R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F18R2_FB4      = 0x10       // Bit FB4.
	CAN_F18R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F18R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F18R2_FB5      = 0x20       // Bit FB5.
	CAN_F18R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F18R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F18R2_FB6      = 0x40       // Bit FB6.
	CAN_F18R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F18R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F18R2_FB7      = 0x80       // Bit FB7.
	CAN_F18R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F18R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F18R2_FB8      = 0x100      // Bit FB8.
	CAN_F18R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F18R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F18R2_FB9      = 0x200      // Bit FB9.
	CAN_F18R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F18R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F18R2_FB10     = 0x400      // Bit FB10.
	CAN_F18R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F18R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F18R2_FB11     = 0x800      // Bit FB11.
	CAN_F18R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F18R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F18R2_FB12     = 0x1000     // Bit FB12.
	CAN_F18R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F18R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F18R2_FB13     = 0x2000     // Bit FB13.
	CAN_F18R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F18R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F18R2_FB14     = 0x4000     // Bit FB14.
	CAN_F18R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F18R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F18R2_FB15     = 0x8000     // Bit FB15.
	CAN_F18R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F18R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F18R2_FB16     = 0x10000    // Bit FB16.
	CAN_F18R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F18R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F18R2_FB17     = 0x20000    // Bit FB17.
	CAN_F18R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F18R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F18R2_FB18     = 0x40000    // Bit FB18.
	CAN_F18R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F18R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F18R2_FB19     = 0x80000    // Bit FB19.
	CAN_F18R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F18R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F18R2_FB20     = 0x100000   // Bit FB20.
	CAN_F18R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F18R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F18R2_FB21     = 0x200000   // Bit FB21.
	CAN_F18R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F18R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F18R2_FB22     = 0x400000   // Bit FB22.
	CAN_F18R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F18R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F18R2_FB23     = 0x800000   // Bit FB23.
	CAN_F18R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F18R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F18R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F18R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F18R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F18R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F18R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F18R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F18R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F18R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F18R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F18R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F18R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F18R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F18R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F18R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F18R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F18R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F18R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F18R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F18R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F18R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F18R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F18R2_FB31     = 0x80000000 // Bit FB31.

	// F19R1: Filter bank 19 register 1
	CAN_F19R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F19R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F19R1_FB0      = 0x1        // Bit FB0.
	CAN_F19R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F19R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F19R1_FB1      = 0x2        // Bit FB1.
	CAN_F19R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F19R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F19R1_FB2      = 0x4        // Bit FB2.
	CAN_F19R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F19R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F19R1_FB3      = 0x8        // Bit FB3.
	CAN_F19R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F19R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F19R1_FB4      = 0x10       // Bit FB4.
	CAN_F19R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F19R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F19R1_FB5      = 0x20       // Bit FB5.
	CAN_F19R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F19R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F19R1_FB6      = 0x40       // Bit FB6.
	CAN_F19R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F19R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F19R1_FB7      = 0x80       // Bit FB7.
	CAN_F19R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F19R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F19R1_FB8      = 0x100      // Bit FB8.
	CAN_F19R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F19R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F19R1_FB9      = 0x200      // Bit FB9.
	CAN_F19R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F19R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F19R1_FB10     = 0x400      // Bit FB10.
	CAN_F19R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F19R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F19R1_FB11     = 0x800      // Bit FB11.
	CAN_F19R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F19R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F19R1_FB12     = 0x1000     // Bit FB12.
	CAN_F19R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F19R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F19R1_FB13     = 0x2000     // Bit FB13.
	CAN_F19R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F19R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F19R1_FB14     = 0x4000     // Bit FB14.
	CAN_F19R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F19R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F19R1_FB15     = 0x8000     // Bit FB15.
	CAN_F19R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F19R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F19R1_FB16     = 0x10000    // Bit FB16.
	CAN_F19R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F19R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F19R1_FB17     = 0x20000    // Bit FB17.
	CAN_F19R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F19R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F19R1_FB18     = 0x40000    // Bit FB18.
	CAN_F19R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F19R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F19R1_FB19     = 0x80000    // Bit FB19.
	CAN_F19R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F19R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F19R1_FB20     = 0x100000   // Bit FB20.
	CAN_F19R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F19R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F19R1_FB21     = 0x200000   // Bit FB21.
	CAN_F19R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F19R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F19R1_FB22     = 0x400000   // Bit FB22.
	CAN_F19R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F19R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F19R1_FB23     = 0x800000   // Bit FB23.
	CAN_F19R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F19R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F19R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F19R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F19R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F19R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F19R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F19R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F19R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F19R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F19R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F19R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F19R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F19R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F19R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F19R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F19R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F19R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F19R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F19R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F19R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F19R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F19R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F19R1_FB31     = 0x80000000 // Bit FB31.

	// F19R2: Filter bank 19 register 2
	CAN_F19R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F19R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F19R2_FB0      = 0x1        // Bit FB0.
	CAN_F19R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F19R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F19R2_FB1      = 0x2        // Bit FB1.
	CAN_F19R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F19R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F19R2_FB2      = 0x4        // Bit FB2.
	CAN_F19R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F19R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F19R2_FB3      = 0x8        // Bit FB3.
	CAN_F19R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F19R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F19R2_FB4      = 0x10       // Bit FB4.
	CAN_F19R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F19R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F19R2_FB5      = 0x20       // Bit FB5.
	CAN_F19R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F19R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F19R2_FB6      = 0x40       // Bit FB6.
	CAN_F19R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F19R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F19R2_FB7      = 0x80       // Bit FB7.
	CAN_F19R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F19R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F19R2_FB8      = 0x100      // Bit FB8.
	CAN_F19R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F19R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F19R2_FB9      = 0x200      // Bit FB9.
	CAN_F19R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F19R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F19R2_FB10     = 0x400      // Bit FB10.
	CAN_F19R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F19R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F19R2_FB11     = 0x800      // Bit FB11.
	CAN_F19R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F19R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F19R2_FB12     = 0x1000     // Bit FB12.
	CAN_F19R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F19R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F19R2_FB13     = 0x2000     // Bit FB13.
	CAN_F19R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F19R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F19R2_FB14     = 0x4000     // Bit FB14.
	CAN_F19R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F19R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F19R2_FB15     = 0x8000     // Bit FB15.
	CAN_F19R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F19R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F19R2_FB16     = 0x10000    // Bit FB16.
	CAN_F19R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F19R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F19R2_FB17     = 0x20000    // Bit FB17.
	CAN_F19R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F19R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F19R2_FB18     = 0x40000    // Bit FB18.
	CAN_F19R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F19R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F19R2_FB19     = 0x80000    // Bit FB19.
	CAN_F19R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F19R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F19R2_FB20     = 0x100000   // Bit FB20.
	CAN_F19R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F19R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F19R2_FB21     = 0x200000   // Bit FB21.
	CAN_F19R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F19R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F19R2_FB22     = 0x400000   // Bit FB22.
	CAN_F19R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F19R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F19R2_FB23     = 0x800000   // Bit FB23.
	CAN_F19R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F19R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F19R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F19R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F19R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F19R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F19R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F19R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F19R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F19R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F19R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F19R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F19R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F19R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F19R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F19R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F19R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F19R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F19R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F19R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F19R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F19R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F19R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F19R2_FB31     = 0x80000000 // Bit FB31.

	// F20R1: Filter bank 20 register 1
	CAN_F20R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F20R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F20R1_FB0      = 0x1        // Bit FB0.
	CAN_F20R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F20R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F20R1_FB1      = 0x2        // Bit FB1.
	CAN_F20R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F20R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F20R1_FB2      = 0x4        // Bit FB2.
	CAN_F20R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F20R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F20R1_FB3      = 0x8        // Bit FB3.
	CAN_F20R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F20R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F20R1_FB4      = 0x10       // Bit FB4.
	CAN_F20R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F20R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F20R1_FB5      = 0x20       // Bit FB5.
	CAN_F20R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F20R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F20R1_FB6      = 0x40       // Bit FB6.
	CAN_F20R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F20R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F20R1_FB7      = 0x80       // Bit FB7.
	CAN_F20R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F20R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F20R1_FB8      = 0x100      // Bit FB8.
	CAN_F20R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F20R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F20R1_FB9      = 0x200      // Bit FB9.
	CAN_F20R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F20R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F20R1_FB10     = 0x400      // Bit FB10.
	CAN_F20R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F20R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F20R1_FB11     = 0x800      // Bit FB11.
	CAN_F20R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F20R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F20R1_FB12     = 0x1000     // Bit FB12.
	CAN_F20R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F20R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F20R1_FB13     = 0x2000     // Bit FB13.
	CAN_F20R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F20R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F20R1_FB14     = 0x4000     // Bit FB14.
	CAN_F20R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F20R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F20R1_FB15     = 0x8000     // Bit FB15.
	CAN_F20R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F20R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F20R1_FB16     = 0x10000    // Bit FB16.
	CAN_F20R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F20R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F20R1_FB17     = 0x20000    // Bit FB17.
	CAN_F20R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F20R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F20R1_FB18     = 0x40000    // Bit FB18.
	CAN_F20R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F20R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F20R1_FB19     = 0x80000    // Bit FB19.
	CAN_F20R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F20R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F20R1_FB20     = 0x100000   // Bit FB20.
	CAN_F20R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F20R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F20R1_FB21     = 0x200000   // Bit FB21.
	CAN_F20R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F20R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F20R1_FB22     = 0x400000   // Bit FB22.
	CAN_F20R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F20R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F20R1_FB23     = 0x800000   // Bit FB23.
	CAN_F20R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F20R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F20R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F20R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F20R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F20R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F20R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F20R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F20R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F20R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F20R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F20R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F20R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F20R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F20R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F20R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F20R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F20R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F20R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F20R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F20R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F20R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F20R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F20R1_FB31     = 0x80000000 // Bit FB31.

	// F20R2: Filter bank 20 register 2
	CAN_F20R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F20R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F20R2_FB0      = 0x1        // Bit FB0.
	CAN_F20R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F20R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F20R2_FB1      = 0x2        // Bit FB1.
	CAN_F20R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F20R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F20R2_FB2      = 0x4        // Bit FB2.
	CAN_F20R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F20R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F20R2_FB3      = 0x8        // Bit FB3.
	CAN_F20R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F20R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F20R2_FB4      = 0x10       // Bit FB4.
	CAN_F20R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F20R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F20R2_FB5      = 0x20       // Bit FB5.
	CAN_F20R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F20R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F20R2_FB6      = 0x40       // Bit FB6.
	CAN_F20R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F20R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F20R2_FB7      = 0x80       // Bit FB7.
	CAN_F20R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F20R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F20R2_FB8      = 0x100      // Bit FB8.
	CAN_F20R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F20R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F20R2_FB9      = 0x200      // Bit FB9.
	CAN_F20R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F20R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F20R2_FB10     = 0x400      // Bit FB10.
	CAN_F20R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F20R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F20R2_FB11     = 0x800      // Bit FB11.
	CAN_F20R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F20R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F20R2_FB12     = 0x1000     // Bit FB12.
	CAN_F20R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F20R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F20R2_FB13     = 0x2000     // Bit FB13.
	CAN_F20R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F20R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F20R2_FB14     = 0x4000     // Bit FB14.
	CAN_F20R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F20R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F20R2_FB15     = 0x8000     // Bit FB15.
	CAN_F20R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F20R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F20R2_FB16     = 0x10000    // Bit FB16.
	CAN_F20R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F20R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F20R2_FB17     = 0x20000    // Bit FB17.
	CAN_F20R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F20R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F20R2_FB18     = 0x40000    // Bit FB18.
	CAN_F20R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F20R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F20R2_FB19     = 0x80000    // Bit FB19.
	CAN_F20R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F20R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F20R2_FB20     = 0x100000   // Bit FB20.
	CAN_F20R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F20R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F20R2_FB21     = 0x200000   // Bit FB21.
	CAN_F20R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F20R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F20R2_FB22     = 0x400000   // Bit FB22.
	CAN_F20R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F20R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F20R2_FB23     = 0x800000   // Bit FB23.
	CAN_F20R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F20R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F20R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F20R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F20R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F20R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F20R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F20R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F20R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F20R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F20R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F20R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F20R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F20R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F20R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F20R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F20R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F20R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F20R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F20R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F20R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F20R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F20R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F20R2_FB31     = 0x80000000 // Bit FB31.

	// F21R1: Filter bank 21 register 1
	CAN_F21R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F21R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F21R1_FB0      = 0x1        // Bit FB0.
	CAN_F21R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F21R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F21R1_FB1      = 0x2        // Bit FB1.
	CAN_F21R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F21R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F21R1_FB2      = 0x4        // Bit FB2.
	CAN_F21R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F21R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F21R1_FB3      = 0x8        // Bit FB3.
	CAN_F21R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F21R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F21R1_FB4      = 0x10       // Bit FB4.
	CAN_F21R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F21R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F21R1_FB5      = 0x20       // Bit FB5.
	CAN_F21R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F21R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F21R1_FB6      = 0x40       // Bit FB6.
	CAN_F21R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F21R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F21R1_FB7      = 0x80       // Bit FB7.
	CAN_F21R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F21R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F21R1_FB8      = 0x100      // Bit FB8.
	CAN_F21R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F21R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F21R1_FB9      = 0x200      // Bit FB9.
	CAN_F21R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F21R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F21R1_FB10     = 0x400      // Bit FB10.
	CAN_F21R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F21R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F21R1_FB11     = 0x800      // Bit FB11.
	CAN_F21R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F21R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F21R1_FB12     = 0x1000     // Bit FB12.
	CAN_F21R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F21R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F21R1_FB13     = 0x2000     // Bit FB13.
	CAN_F21R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F21R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F21R1_FB14     = 0x4000     // Bit FB14.
	CAN_F21R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F21R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F21R1_FB15     = 0x8000     // Bit FB15.
	CAN_F21R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F21R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F21R1_FB16     = 0x10000    // Bit FB16.
	CAN_F21R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F21R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F21R1_FB17     = 0x20000    // Bit FB17.
	CAN_F21R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F21R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F21R1_FB18     = 0x40000    // Bit FB18.
	CAN_F21R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F21R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F21R1_FB19     = 0x80000    // Bit FB19.
	CAN_F21R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F21R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F21R1_FB20     = 0x100000   // Bit FB20.
	CAN_F21R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F21R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F21R1_FB21     = 0x200000   // Bit FB21.
	CAN_F21R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F21R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F21R1_FB22     = 0x400000   // Bit FB22.
	CAN_F21R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F21R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F21R1_FB23     = 0x800000   // Bit FB23.
	CAN_F21R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F21R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F21R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F21R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F21R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F21R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F21R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F21R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F21R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F21R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F21R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F21R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F21R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F21R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F21R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F21R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F21R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F21R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F21R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F21R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F21R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F21R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F21R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F21R1_FB31     = 0x80000000 // Bit FB31.

	// F21R2: Filter bank 21 register 2
	CAN_F21R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F21R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F21R2_FB0      = 0x1        // Bit FB0.
	CAN_F21R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F21R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F21R2_FB1      = 0x2        // Bit FB1.
	CAN_F21R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F21R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F21R2_FB2      = 0x4        // Bit FB2.
	CAN_F21R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F21R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F21R2_FB3      = 0x8        // Bit FB3.
	CAN_F21R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F21R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F21R2_FB4      = 0x10       // Bit FB4.
	CAN_F21R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F21R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F21R2_FB5      = 0x20       // Bit FB5.
	CAN_F21R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F21R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F21R2_FB6      = 0x40       // Bit FB6.
	CAN_F21R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F21R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F21R2_FB7      = 0x80       // Bit FB7.
	CAN_F21R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F21R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F21R2_FB8      = 0x100      // Bit FB8.
	CAN_F21R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F21R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F21R2_FB9      = 0x200      // Bit FB9.
	CAN_F21R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F21R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F21R2_FB10     = 0x400      // Bit FB10.
	CAN_F21R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F21R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F21R2_FB11     = 0x800      // Bit FB11.
	CAN_F21R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F21R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F21R2_FB12     = 0x1000     // Bit FB12.
	CAN_F21R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F21R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F21R2_FB13     = 0x2000     // Bit FB13.
	CAN_F21R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F21R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F21R2_FB14     = 0x4000     // Bit FB14.
	CAN_F21R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F21R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F21R2_FB15     = 0x8000     // Bit FB15.
	CAN_F21R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F21R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F21R2_FB16     = 0x10000    // Bit FB16.
	CAN_F21R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F21R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F21R2_FB17     = 0x20000    // Bit FB17.
	CAN_F21R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F21R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F21R2_FB18     = 0x40000    // Bit FB18.
	CAN_F21R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F21R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F21R2_FB19     = 0x80000    // Bit FB19.
	CAN_F21R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F21R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F21R2_FB20     = 0x100000   // Bit FB20.
	CAN_F21R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F21R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F21R2_FB21     = 0x200000   // Bit FB21.
	CAN_F21R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F21R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F21R2_FB22     = 0x400000   // Bit FB22.
	CAN_F21R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F21R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F21R2_FB23     = 0x800000   // Bit FB23.
	CAN_F21R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F21R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F21R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F21R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F21R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F21R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F21R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F21R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F21R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F21R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F21R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F21R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F21R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F21R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F21R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F21R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F21R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F21R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F21R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F21R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F21R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F21R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F21R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F21R2_FB31     = 0x80000000 // Bit FB31.

	// F22R1: Filter bank 22 register 1
	CAN_F22R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F22R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F22R1_FB0      = 0x1        // Bit FB0.
	CAN_F22R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F22R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F22R1_FB1      = 0x2        // Bit FB1.
	CAN_F22R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F22R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F22R1_FB2      = 0x4        // Bit FB2.
	CAN_F22R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F22R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F22R1_FB3      = 0x8        // Bit FB3.
	CAN_F22R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F22R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F22R1_FB4      = 0x10       // Bit FB4.
	CAN_F22R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F22R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F22R1_FB5      = 0x20       // Bit FB5.
	CAN_F22R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F22R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F22R1_FB6      = 0x40       // Bit FB6.
	CAN_F22R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F22R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F22R1_FB7      = 0x80       // Bit FB7.
	CAN_F22R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F22R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F22R1_FB8      = 0x100      // Bit FB8.
	CAN_F22R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F22R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F22R1_FB9      = 0x200      // Bit FB9.
	CAN_F22R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F22R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F22R1_FB10     = 0x400      // Bit FB10.
	CAN_F22R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F22R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F22R1_FB11     = 0x800      // Bit FB11.
	CAN_F22R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F22R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F22R1_FB12     = 0x1000     // Bit FB12.
	CAN_F22R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F22R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F22R1_FB13     = 0x2000     // Bit FB13.
	CAN_F22R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F22R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F22R1_FB14     = 0x4000     // Bit FB14.
	CAN_F22R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F22R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F22R1_FB15     = 0x8000     // Bit FB15.
	CAN_F22R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F22R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F22R1_FB16     = 0x10000    // Bit FB16.
	CAN_F22R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F22R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F22R1_FB17     = 0x20000    // Bit FB17.
	CAN_F22R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F22R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F22R1_FB18     = 0x40000    // Bit FB18.
	CAN_F22R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F22R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F22R1_FB19     = 0x80000    // Bit FB19.
	CAN_F22R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F22R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F22R1_FB20     = 0x100000   // Bit FB20.
	CAN_F22R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F22R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F22R1_FB21     = 0x200000   // Bit FB21.
	CAN_F22R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F22R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F22R1_FB22     = 0x400000   // Bit FB22.
	CAN_F22R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F22R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F22R1_FB23     = 0x800000   // Bit FB23.
	CAN_F22R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F22R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F22R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F22R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F22R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F22R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F22R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F22R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F22R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F22R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F22R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F22R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F22R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F22R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F22R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F22R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F22R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F22R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F22R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F22R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F22R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F22R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F22R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F22R1_FB31     = 0x80000000 // Bit FB31.

	// F22R2: Filter bank 22 register 2
	CAN_F22R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F22R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F22R2_FB0      = 0x1        // Bit FB0.
	CAN_F22R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F22R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F22R2_FB1      = 0x2        // Bit FB1.
	CAN_F22R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F22R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F22R2_FB2      = 0x4        // Bit FB2.
	CAN_F22R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F22R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F22R2_FB3      = 0x8        // Bit FB3.
	CAN_F22R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F22R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F22R2_FB4      = 0x10       // Bit FB4.
	CAN_F22R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F22R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F22R2_FB5      = 0x20       // Bit FB5.
	CAN_F22R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F22R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F22R2_FB6      = 0x40       // Bit FB6.
	CAN_F22R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F22R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F22R2_FB7      = 0x80       // Bit FB7.
	CAN_F22R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F22R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F22R2_FB8      = 0x100      // Bit FB8.
	CAN_F22R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F22R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F22R2_FB9      = 0x200      // Bit FB9.
	CAN_F22R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F22R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F22R2_FB10     = 0x400      // Bit FB10.
	CAN_F22R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F22R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F22R2_FB11     = 0x800      // Bit FB11.
	CAN_F22R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F22R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F22R2_FB12     = 0x1000     // Bit FB12.
	CAN_F22R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F22R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F22R2_FB13     = 0x2000     // Bit FB13.
	CAN_F22R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F22R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F22R2_FB14     = 0x4000     // Bit FB14.
	CAN_F22R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F22R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F22R2_FB15     = 0x8000     // Bit FB15.
	CAN_F22R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F22R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F22R2_FB16     = 0x10000    // Bit FB16.
	CAN_F22R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F22R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F22R2_FB17     = 0x20000    // Bit FB17.
	CAN_F22R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F22R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F22R2_FB18     = 0x40000    // Bit FB18.
	CAN_F22R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F22R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F22R2_FB19     = 0x80000    // Bit FB19.
	CAN_F22R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F22R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F22R2_FB20     = 0x100000   // Bit FB20.
	CAN_F22R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F22R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F22R2_FB21     = 0x200000   // Bit FB21.
	CAN_F22R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F22R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F22R2_FB22     = 0x400000   // Bit FB22.
	CAN_F22R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F22R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F22R2_FB23     = 0x800000   // Bit FB23.
	CAN_F22R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F22R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F22R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F22R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F22R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F22R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F22R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F22R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F22R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F22R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F22R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F22R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F22R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F22R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F22R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F22R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F22R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F22R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F22R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F22R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F22R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F22R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F22R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F22R2_FB31     = 0x80000000 // Bit FB31.

	// F23R1: Filter bank 23 register 1
	CAN_F23R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F23R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F23R1_FB0      = 0x1        // Bit FB0.
	CAN_F23R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F23R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F23R1_FB1      = 0x2        // Bit FB1.
	CAN_F23R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F23R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F23R1_FB2      = 0x4        // Bit FB2.
	CAN_F23R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F23R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F23R1_FB3      = 0x8        // Bit FB3.
	CAN_F23R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F23R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F23R1_FB4      = 0x10       // Bit FB4.
	CAN_F23R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F23R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F23R1_FB5      = 0x20       // Bit FB5.
	CAN_F23R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F23R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F23R1_FB6      = 0x40       // Bit FB6.
	CAN_F23R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F23R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F23R1_FB7      = 0x80       // Bit FB7.
	CAN_F23R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F23R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F23R1_FB8      = 0x100      // Bit FB8.
	CAN_F23R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F23R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F23R1_FB9      = 0x200      // Bit FB9.
	CAN_F23R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F23R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F23R1_FB10     = 0x400      // Bit FB10.
	CAN_F23R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F23R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F23R1_FB11     = 0x800      // Bit FB11.
	CAN_F23R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F23R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F23R1_FB12     = 0x1000     // Bit FB12.
	CAN_F23R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F23R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F23R1_FB13     = 0x2000     // Bit FB13.
	CAN_F23R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F23R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F23R1_FB14     = 0x4000     // Bit FB14.
	CAN_F23R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F23R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F23R1_FB15     = 0x8000     // Bit FB15.
	CAN_F23R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F23R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F23R1_FB16     = 0x10000    // Bit FB16.
	CAN_F23R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F23R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F23R1_FB17     = 0x20000    // Bit FB17.
	CAN_F23R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F23R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F23R1_FB18     = 0x40000    // Bit FB18.
	CAN_F23R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F23R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F23R1_FB19     = 0x80000    // Bit FB19.
	CAN_F23R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F23R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F23R1_FB20     = 0x100000   // Bit FB20.
	CAN_F23R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F23R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F23R1_FB21     = 0x200000   // Bit FB21.
	CAN_F23R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F23R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F23R1_FB22     = 0x400000   // Bit FB22.
	CAN_F23R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F23R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F23R1_FB23     = 0x800000   // Bit FB23.
	CAN_F23R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F23R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F23R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F23R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F23R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F23R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F23R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F23R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F23R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F23R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F23R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F23R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F23R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F23R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F23R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F23R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F23R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F23R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F23R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F23R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F23R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F23R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F23R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F23R1_FB31     = 0x80000000 // Bit FB31.

	// F23R2: Filter bank 23 register 2
	CAN_F23R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F23R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F23R2_FB0      = 0x1        // Bit FB0.
	CAN_F23R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F23R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F23R2_FB1      = 0x2        // Bit FB1.
	CAN_F23R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F23R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F23R2_FB2      = 0x4        // Bit FB2.
	CAN_F23R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F23R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F23R2_FB3      = 0x8        // Bit FB3.
	CAN_F23R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F23R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F23R2_FB4      = 0x10       // Bit FB4.
	CAN_F23R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F23R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F23R2_FB5      = 0x20       // Bit FB5.
	CAN_F23R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F23R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F23R2_FB6      = 0x40       // Bit FB6.
	CAN_F23R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F23R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F23R2_FB7      = 0x80       // Bit FB7.
	CAN_F23R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F23R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F23R2_FB8      = 0x100      // Bit FB8.
	CAN_F23R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F23R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F23R2_FB9      = 0x200      // Bit FB9.
	CAN_F23R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F23R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F23R2_FB10     = 0x400      // Bit FB10.
	CAN_F23R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F23R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F23R2_FB11     = 0x800      // Bit FB11.
	CAN_F23R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F23R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F23R2_FB12     = 0x1000     // Bit FB12.
	CAN_F23R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F23R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F23R2_FB13     = 0x2000     // Bit FB13.
	CAN_F23R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F23R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F23R2_FB14     = 0x4000     // Bit FB14.
	CAN_F23R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F23R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F23R2_FB15     = 0x8000     // Bit FB15.
	CAN_F23R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F23R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F23R2_FB16     = 0x10000    // Bit FB16.
	CAN_F23R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F23R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F23R2_FB17     = 0x20000    // Bit FB17.
	CAN_F23R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F23R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F23R2_FB18     = 0x40000    // Bit FB18.
	CAN_F23R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F23R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F23R2_FB19     = 0x80000    // Bit FB19.
	CAN_F23R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F23R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F23R2_FB20     = 0x100000   // Bit FB20.
	CAN_F23R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F23R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F23R2_FB21     = 0x200000   // Bit FB21.
	CAN_F23R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F23R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F23R2_FB22     = 0x400000   // Bit FB22.
	CAN_F23R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F23R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F23R2_FB23     = 0x800000   // Bit FB23.
	CAN_F23R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F23R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F23R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F23R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F23R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F23R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F23R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F23R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F23R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F23R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F23R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F23R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F23R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F23R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F23R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F23R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F23R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F23R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F23R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F23R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F23R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F23R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F23R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F23R2_FB31     = 0x80000000 // Bit FB31.

	// F24R1: Filter bank 24 register 1
	CAN_F24R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F24R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F24R1_FB0      = 0x1        // Bit FB0.
	CAN_F24R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F24R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F24R1_FB1      = 0x2        // Bit FB1.
	CAN_F24R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F24R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F24R1_FB2      = 0x4        // Bit FB2.
	CAN_F24R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F24R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F24R1_FB3      = 0x8        // Bit FB3.
	CAN_F24R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F24R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F24R1_FB4      = 0x10       // Bit FB4.
	CAN_F24R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F24R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F24R1_FB5      = 0x20       // Bit FB5.
	CAN_F24R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F24R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F24R1_FB6      = 0x40       // Bit FB6.
	CAN_F24R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F24R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F24R1_FB7      = 0x80       // Bit FB7.
	CAN_F24R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F24R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F24R1_FB8      = 0x100      // Bit FB8.
	CAN_F24R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F24R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F24R1_FB9      = 0x200      // Bit FB9.
	CAN_F24R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F24R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F24R1_FB10     = 0x400      // Bit FB10.
	CAN_F24R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F24R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F24R1_FB11     = 0x800      // Bit FB11.
	CAN_F24R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F24R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F24R1_FB12     = 0x1000     // Bit FB12.
	CAN_F24R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F24R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F24R1_FB13     = 0x2000     // Bit FB13.
	CAN_F24R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F24R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F24R1_FB14     = 0x4000     // Bit FB14.
	CAN_F24R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F24R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F24R1_FB15     = 0x8000     // Bit FB15.
	CAN_F24R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F24R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F24R1_FB16     = 0x10000    // Bit FB16.
	CAN_F24R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F24R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F24R1_FB17     = 0x20000    // Bit FB17.
	CAN_F24R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F24R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F24R1_FB18     = 0x40000    // Bit FB18.
	CAN_F24R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F24R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F24R1_FB19     = 0x80000    // Bit FB19.
	CAN_F24R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F24R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F24R1_FB20     = 0x100000   // Bit FB20.
	CAN_F24R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F24R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F24R1_FB21     = 0x200000   // Bit FB21.
	CAN_F24R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F24R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F24R1_FB22     = 0x400000   // Bit FB22.
	CAN_F24R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F24R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F24R1_FB23     = 0x800000   // Bit FB23.
	CAN_F24R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F24R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F24R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F24R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F24R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F24R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F24R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F24R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F24R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F24R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F24R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F24R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F24R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F24R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F24R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F24R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F24R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F24R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F24R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F24R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F24R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F24R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F24R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F24R1_FB31     = 0x80000000 // Bit FB31.

	// F24R2: Filter bank 24 register 2
	CAN_F24R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F24R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F24R2_FB0      = 0x1        // Bit FB0.
	CAN_F24R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F24R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F24R2_FB1      = 0x2        // Bit FB1.
	CAN_F24R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F24R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F24R2_FB2      = 0x4        // Bit FB2.
	CAN_F24R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F24R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F24R2_FB3      = 0x8        // Bit FB3.
	CAN_F24R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F24R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F24R2_FB4      = 0x10       // Bit FB4.
	CAN_F24R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F24R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F24R2_FB5      = 0x20       // Bit FB5.
	CAN_F24R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F24R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F24R2_FB6      = 0x40       // Bit FB6.
	CAN_F24R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F24R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F24R2_FB7      = 0x80       // Bit FB7.
	CAN_F24R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F24R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F24R2_FB8      = 0x100      // Bit FB8.
	CAN_F24R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F24R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F24R2_FB9      = 0x200      // Bit FB9.
	CAN_F24R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F24R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F24R2_FB10     = 0x400      // Bit FB10.
	CAN_F24R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F24R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F24R2_FB11     = 0x800      // Bit FB11.
	CAN_F24R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F24R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F24R2_FB12     = 0x1000     // Bit FB12.
	CAN_F24R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F24R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F24R2_FB13     = 0x2000     // Bit FB13.
	CAN_F24R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F24R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F24R2_FB14     = 0x4000     // Bit FB14.
	CAN_F24R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F24R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F24R2_FB15     = 0x8000     // Bit FB15.
	CAN_F24R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F24R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F24R2_FB16     = 0x10000    // Bit FB16.
	CAN_F24R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F24R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F24R2_FB17     = 0x20000    // Bit FB17.
	CAN_F24R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F24R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F24R2_FB18     = 0x40000    // Bit FB18.
	CAN_F24R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F24R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F24R2_FB19     = 0x80000    // Bit FB19.
	CAN_F24R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F24R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F24R2_FB20     = 0x100000   // Bit FB20.
	CAN_F24R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F24R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F24R2_FB21     = 0x200000   // Bit FB21.
	CAN_F24R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F24R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F24R2_FB22     = 0x400000   // Bit FB22.
	CAN_F24R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F24R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F24R2_FB23     = 0x800000   // Bit FB23.
	CAN_F24R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F24R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F24R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F24R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F24R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F24R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F24R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F24R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F24R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F24R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F24R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F24R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F24R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F24R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F24R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F24R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F24R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F24R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F24R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F24R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F24R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F24R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F24R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F24R2_FB31     = 0x80000000 // Bit FB31.

	// F25R1: Filter bank 25 register 1
	CAN_F25R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F25R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F25R1_FB0      = 0x1        // Bit FB0.
	CAN_F25R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F25R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F25R1_FB1      = 0x2        // Bit FB1.
	CAN_F25R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F25R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F25R1_FB2      = 0x4        // Bit FB2.
	CAN_F25R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F25R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F25R1_FB3      = 0x8        // Bit FB3.
	CAN_F25R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F25R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F25R1_FB4      = 0x10       // Bit FB4.
	CAN_F25R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F25R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F25R1_FB5      = 0x20       // Bit FB5.
	CAN_F25R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F25R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F25R1_FB6      = 0x40       // Bit FB6.
	CAN_F25R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F25R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F25R1_FB7      = 0x80       // Bit FB7.
	CAN_F25R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F25R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F25R1_FB8      = 0x100      // Bit FB8.
	CAN_F25R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F25R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F25R1_FB9      = 0x200      // Bit FB9.
	CAN_F25R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F25R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F25R1_FB10     = 0x400      // Bit FB10.
	CAN_F25R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F25R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F25R1_FB11     = 0x800      // Bit FB11.
	CAN_F25R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F25R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F25R1_FB12     = 0x1000     // Bit FB12.
	CAN_F25R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F25R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F25R1_FB13     = 0x2000     // Bit FB13.
	CAN_F25R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F25R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F25R1_FB14     = 0x4000     // Bit FB14.
	CAN_F25R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F25R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F25R1_FB15     = 0x8000     // Bit FB15.
	CAN_F25R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F25R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F25R1_FB16     = 0x10000    // Bit FB16.
	CAN_F25R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F25R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F25R1_FB17     = 0x20000    // Bit FB17.
	CAN_F25R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F25R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F25R1_FB18     = 0x40000    // Bit FB18.
	CAN_F25R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F25R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F25R1_FB19     = 0x80000    // Bit FB19.
	CAN_F25R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F25R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F25R1_FB20     = 0x100000   // Bit FB20.
	CAN_F25R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F25R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F25R1_FB21     = 0x200000   // Bit FB21.
	CAN_F25R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F25R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F25R1_FB22     = 0x400000   // Bit FB22.
	CAN_F25R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F25R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F25R1_FB23     = 0x800000   // Bit FB23.
	CAN_F25R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F25R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F25R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F25R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F25R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F25R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F25R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F25R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F25R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F25R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F25R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F25R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F25R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F25R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F25R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F25R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F25R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F25R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F25R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F25R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F25R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F25R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F25R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F25R1_FB31     = 0x80000000 // Bit FB31.

	// F25R2: Filter bank 25 register 2
	CAN_F25R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F25R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F25R2_FB0      = 0x1        // Bit FB0.
	CAN_F25R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F25R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F25R2_FB1      = 0x2        // Bit FB1.
	CAN_F25R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F25R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F25R2_FB2      = 0x4        // Bit FB2.
	CAN_F25R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F25R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F25R2_FB3      = 0x8        // Bit FB3.
	CAN_F25R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F25R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F25R2_FB4      = 0x10       // Bit FB4.
	CAN_F25R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F25R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F25R2_FB5      = 0x20       // Bit FB5.
	CAN_F25R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F25R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F25R2_FB6      = 0x40       // Bit FB6.
	CAN_F25R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F25R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F25R2_FB7      = 0x80       // Bit FB7.
	CAN_F25R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F25R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F25R2_FB8      = 0x100      // Bit FB8.
	CAN_F25R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F25R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F25R2_FB9      = 0x200      // Bit FB9.
	CAN_F25R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F25R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F25R2_FB10     = 0x400      // Bit FB10.
	CAN_F25R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F25R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F25R2_FB11     = 0x800      // Bit FB11.
	CAN_F25R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F25R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F25R2_FB12     = 0x1000     // Bit FB12.
	CAN_F25R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F25R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F25R2_FB13     = 0x2000     // Bit FB13.
	CAN_F25R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F25R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F25R2_FB14     = 0x4000     // Bit FB14.
	CAN_F25R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F25R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F25R2_FB15     = 0x8000     // Bit FB15.
	CAN_F25R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F25R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F25R2_FB16     = 0x10000    // Bit FB16.
	CAN_F25R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F25R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F25R2_FB17     = 0x20000    // Bit FB17.
	CAN_F25R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F25R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F25R2_FB18     = 0x40000    // Bit FB18.
	CAN_F25R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F25R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F25R2_FB19     = 0x80000    // Bit FB19.
	CAN_F25R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F25R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F25R2_FB20     = 0x100000   // Bit FB20.
	CAN_F25R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F25R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F25R2_FB21     = 0x200000   // Bit FB21.
	CAN_F25R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F25R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F25R2_FB22     = 0x400000   // Bit FB22.
	CAN_F25R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F25R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F25R2_FB23     = 0x800000   // Bit FB23.
	CAN_F25R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F25R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F25R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F25R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F25R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F25R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F25R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F25R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F25R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F25R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F25R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F25R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F25R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F25R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F25R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F25R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F25R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F25R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F25R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F25R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F25R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F25R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F25R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F25R2_FB31     = 0x80000000 // Bit FB31.

	// F26R1: Filter bank 26 register 1
	CAN_F26R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F26R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F26R1_FB0      = 0x1        // Bit FB0.
	CAN_F26R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F26R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F26R1_FB1      = 0x2        // Bit FB1.
	CAN_F26R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F26R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F26R1_FB2      = 0x4        // Bit FB2.
	CAN_F26R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F26R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F26R1_FB3      = 0x8        // Bit FB3.
	CAN_F26R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F26R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F26R1_FB4      = 0x10       // Bit FB4.
	CAN_F26R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F26R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F26R1_FB5      = 0x20       // Bit FB5.
	CAN_F26R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F26R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F26R1_FB6      = 0x40       // Bit FB6.
	CAN_F26R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F26R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F26R1_FB7      = 0x80       // Bit FB7.
	CAN_F26R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F26R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F26R1_FB8      = 0x100      // Bit FB8.
	CAN_F26R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F26R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F26R1_FB9      = 0x200      // Bit FB9.
	CAN_F26R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F26R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F26R1_FB10     = 0x400      // Bit FB10.
	CAN_F26R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F26R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F26R1_FB11     = 0x800      // Bit FB11.
	CAN_F26R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F26R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F26R1_FB12     = 0x1000     // Bit FB12.
	CAN_F26R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F26R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F26R1_FB13     = 0x2000     // Bit FB13.
	CAN_F26R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F26R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F26R1_FB14     = 0x4000     // Bit FB14.
	CAN_F26R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F26R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F26R1_FB15     = 0x8000     // Bit FB15.
	CAN_F26R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F26R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F26R1_FB16     = 0x10000    // Bit FB16.
	CAN_F26R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F26R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F26R1_FB17     = 0x20000    // Bit FB17.
	CAN_F26R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F26R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F26R1_FB18     = 0x40000    // Bit FB18.
	CAN_F26R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F26R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F26R1_FB19     = 0x80000    // Bit FB19.
	CAN_F26R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F26R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F26R1_FB20     = 0x100000   // Bit FB20.
	CAN_F26R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F26R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F26R1_FB21     = 0x200000   // Bit FB21.
	CAN_F26R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F26R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F26R1_FB22     = 0x400000   // Bit FB22.
	CAN_F26R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F26R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F26R1_FB23     = 0x800000   // Bit FB23.
	CAN_F26R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F26R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F26R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F26R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F26R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F26R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F26R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F26R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F26R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F26R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F26R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F26R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F26R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F26R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F26R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F26R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F26R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F26R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F26R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F26R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F26R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F26R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F26R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F26R1_FB31     = 0x80000000 // Bit FB31.

	// F26R2: Filter bank 26 register 2
	CAN_F26R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F26R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F26R2_FB0      = 0x1        // Bit FB0.
	CAN_F26R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F26R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F26R2_FB1      = 0x2        // Bit FB1.
	CAN_F26R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F26R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F26R2_FB2      = 0x4        // Bit FB2.
	CAN_F26R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F26R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F26R2_FB3      = 0x8        // Bit FB3.
	CAN_F26R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F26R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F26R2_FB4      = 0x10       // Bit FB4.
	CAN_F26R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F26R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F26R2_FB5      = 0x20       // Bit FB5.
	CAN_F26R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F26R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F26R2_FB6      = 0x40       // Bit FB6.
	CAN_F26R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F26R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F26R2_FB7      = 0x80       // Bit FB7.
	CAN_F26R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F26R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F26R2_FB8      = 0x100      // Bit FB8.
	CAN_F26R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F26R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F26R2_FB9      = 0x200      // Bit FB9.
	CAN_F26R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F26R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F26R2_FB10     = 0x400      // Bit FB10.
	CAN_F26R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F26R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F26R2_FB11     = 0x800      // Bit FB11.
	CAN_F26R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F26R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F26R2_FB12     = 0x1000     // Bit FB12.
	CAN_F26R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F26R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F26R2_FB13     = 0x2000     // Bit FB13.
	CAN_F26R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F26R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F26R2_FB14     = 0x4000     // Bit FB14.
	CAN_F26R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F26R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F26R2_FB15     = 0x8000     // Bit FB15.
	CAN_F26R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F26R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F26R2_FB16     = 0x10000    // Bit FB16.
	CAN_F26R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F26R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F26R2_FB17     = 0x20000    // Bit FB17.
	CAN_F26R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F26R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F26R2_FB18     = 0x40000    // Bit FB18.
	CAN_F26R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F26R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F26R2_FB19     = 0x80000    // Bit FB19.
	CAN_F26R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F26R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F26R2_FB20     = 0x100000   // Bit FB20.
	CAN_F26R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F26R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F26R2_FB21     = 0x200000   // Bit FB21.
	CAN_F26R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F26R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F26R2_FB22     = 0x400000   // Bit FB22.
	CAN_F26R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F26R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F26R2_FB23     = 0x800000   // Bit FB23.
	CAN_F26R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F26R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F26R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F26R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F26R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F26R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F26R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F26R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F26R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F26R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F26R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F26R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F26R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F26R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F26R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F26R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F26R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F26R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F26R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F26R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F26R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F26R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F26R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F26R2_FB31     = 0x80000000 // Bit FB31.

	// F27R1: Filter bank 27 register 1
	CAN_F27R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F27R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F27R1_FB0      = 0x1        // Bit FB0.
	CAN_F27R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F27R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F27R1_FB1      = 0x2        // Bit FB1.
	CAN_F27R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F27R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F27R1_FB2      = 0x4        // Bit FB2.
	CAN_F27R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F27R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F27R1_FB3      = 0x8        // Bit FB3.
	CAN_F27R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F27R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F27R1_FB4      = 0x10       // Bit FB4.
	CAN_F27R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F27R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F27R1_FB5      = 0x20       // Bit FB5.
	CAN_F27R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F27R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F27R1_FB6      = 0x40       // Bit FB6.
	CAN_F27R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F27R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F27R1_FB7      = 0x80       // Bit FB7.
	CAN_F27R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F27R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F27R1_FB8      = 0x100      // Bit FB8.
	CAN_F27R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F27R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F27R1_FB9      = 0x200      // Bit FB9.
	CAN_F27R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F27R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F27R1_FB10     = 0x400      // Bit FB10.
	CAN_F27R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F27R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F27R1_FB11     = 0x800      // Bit FB11.
	CAN_F27R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F27R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F27R1_FB12     = 0x1000     // Bit FB12.
	CAN_F27R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F27R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F27R1_FB13     = 0x2000     // Bit FB13.
	CAN_F27R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F27R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F27R1_FB14     = 0x4000     // Bit FB14.
	CAN_F27R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F27R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F27R1_FB15     = 0x8000     // Bit FB15.
	CAN_F27R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F27R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F27R1_FB16     = 0x10000    // Bit FB16.
	CAN_F27R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F27R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F27R1_FB17     = 0x20000    // Bit FB17.
	CAN_F27R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F27R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F27R1_FB18     = 0x40000    // Bit FB18.
	CAN_F27R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F27R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F27R1_FB19     = 0x80000    // Bit FB19.
	CAN_F27R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F27R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F27R1_FB20     = 0x100000   // Bit FB20.
	CAN_F27R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F27R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F27R1_FB21     = 0x200000   // Bit FB21.
	CAN_F27R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F27R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F27R1_FB22     = 0x400000   // Bit FB22.
	CAN_F27R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F27R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F27R1_FB23     = 0x800000   // Bit FB23.
	CAN_F27R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F27R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F27R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F27R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F27R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F27R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F27R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F27R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F27R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F27R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F27R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F27R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F27R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F27R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F27R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F27R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F27R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F27R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F27R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F27R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F27R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F27R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F27R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F27R1_FB31     = 0x80000000 // Bit FB31.

	// F27R2: Filter bank 27 register 2
	CAN_F27R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F27R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F27R2_FB0      = 0x1        // Bit FB0.
	CAN_F27R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F27R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F27R2_FB1      = 0x2        // Bit FB1.
	CAN_F27R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F27R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F27R2_FB2      = 0x4        // Bit FB2.
	CAN_F27R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F27R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F27R2_FB3      = 0x8        // Bit FB3.
	CAN_F27R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F27R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F27R2_FB4      = 0x10       // Bit FB4.
	CAN_F27R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F27R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F27R2_FB5      = 0x20       // Bit FB5.
	CAN_F27R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F27R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F27R2_FB6      = 0x40       // Bit FB6.
	CAN_F27R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F27R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F27R2_FB7      = 0x80       // Bit FB7.
	CAN_F27R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F27R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F27R2_FB8      = 0x100      // Bit FB8.
	CAN_F27R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F27R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F27R2_FB9      = 0x200      // Bit FB9.
	CAN_F27R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F27R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F27R2_FB10     = 0x400      // Bit FB10.
	CAN_F27R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F27R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F27R2_FB11     = 0x800      // Bit FB11.
	CAN_F27R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F27R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F27R2_FB12     = 0x1000     // Bit FB12.
	CAN_F27R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F27R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F27R2_FB13     = 0x2000     // Bit FB13.
	CAN_F27R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F27R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F27R2_FB14     = 0x4000     // Bit FB14.
	CAN_F27R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F27R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F27R2_FB15     = 0x8000     // Bit FB15.
	CAN_F27R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F27R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F27R2_FB16     = 0x10000    // Bit FB16.
	CAN_F27R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F27R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F27R2_FB17     = 0x20000    // Bit FB17.
	CAN_F27R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F27R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F27R2_FB18     = 0x40000    // Bit FB18.
	CAN_F27R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F27R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F27R2_FB19     = 0x80000    // Bit FB19.
	CAN_F27R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F27R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F27R2_FB20     = 0x100000   // Bit FB20.
	CAN_F27R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F27R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F27R2_FB21     = 0x200000   // Bit FB21.
	CAN_F27R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F27R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F27R2_FB22     = 0x400000   // Bit FB22.
	CAN_F27R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F27R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F27R2_FB23     = 0x800000   // Bit FB23.
	CAN_F27R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F27R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F27R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F27R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F27R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F27R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F27R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F27R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F27R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F27R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F27R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F27R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F27R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F27R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F27R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F27R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F27R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F27R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F27R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F27R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F27R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F27R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F27R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F27R2_FB31     = 0x80000000 // Bit FB31.
)

// Bitfields for USB_FS: Universal serial bus full-speed device interface
const (
	// USB_EP0R: endpoint 0 register
	USB_FS_USB_EP0R_EA_Pos      = 0x0    // Position of EA field.
	USB_FS_USB_EP0R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_FS_USB_EP0R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_FS_USB_EP0R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_FS_USB_EP0R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_FS_USB_EP0R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_FS_USB_EP0R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_FS_USB_EP0R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_FS_USB_EP0R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_FS_USB_EP0R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_FS_USB_EP0R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_FS_USB_EP0R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_FS_USB_EP0R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_FS_USB_EP0R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_FS_USB_EP0R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_FS_USB_EP0R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_FS_USB_EP0R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_FS_USB_EP0R_SETUP       = 0x800  // Bit SETUP.
	USB_FS_USB_EP0R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_FS_USB_EP0R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_FS_USB_EP0R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_FS_USB_EP0R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_FS_USB_EP0R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_FS_USB_EP0R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_FS_USB_EP0R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_FS_USB_EP0R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP1R: endpoint 1 register
	USB_FS_USB_EP1R_EA_Pos      = 0x0    // Position of EA field.
	USB_FS_USB_EP1R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_FS_USB_EP1R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_FS_USB_EP1R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_FS_USB_EP1R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_FS_USB_EP1R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_FS_USB_EP1R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_FS_USB_EP1R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_FS_USB_EP1R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_FS_USB_EP1R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_FS_USB_EP1R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_FS_USB_EP1R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_FS_USB_EP1R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_FS_USB_EP1R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_FS_USB_EP1R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_FS_USB_EP1R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_FS_USB_EP1R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_FS_USB_EP1R_SETUP       = 0x800  // Bit SETUP.
	USB_FS_USB_EP1R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_FS_USB_EP1R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_FS_USB_EP1R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_FS_USB_EP1R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_FS_USB_EP1R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_FS_USB_EP1R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_FS_USB_EP1R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_FS_USB_EP1R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP2R: endpoint 2 register
	USB_FS_USB_EP2R_EA_Pos      = 0x0    // Position of EA field.
	USB_FS_USB_EP2R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_FS_USB_EP2R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_FS_USB_EP2R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_FS_USB_EP2R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_FS_USB_EP2R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_FS_USB_EP2R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_FS_USB_EP2R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_FS_USB_EP2R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_FS_USB_EP2R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_FS_USB_EP2R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_FS_USB_EP2R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_FS_USB_EP2R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_FS_USB_EP2R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_FS_USB_EP2R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_FS_USB_EP2R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_FS_USB_EP2R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_FS_USB_EP2R_SETUP       = 0x800  // Bit SETUP.
	USB_FS_USB_EP2R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_FS_USB_EP2R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_FS_USB_EP2R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_FS_USB_EP2R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_FS_USB_EP2R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_FS_USB_EP2R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_FS_USB_EP2R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_FS_USB_EP2R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP3R: endpoint 3 register
	USB_FS_USB_EP3R_EA_Pos      = 0x0    // Position of EA field.
	USB_FS_USB_EP3R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_FS_USB_EP3R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_FS_USB_EP3R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_FS_USB_EP3R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_FS_USB_EP3R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_FS_USB_EP3R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_FS_USB_EP3R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_FS_USB_EP3R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_FS_USB_EP3R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_FS_USB_EP3R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_FS_USB_EP3R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_FS_USB_EP3R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_FS_USB_EP3R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_FS_USB_EP3R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_FS_USB_EP3R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_FS_USB_EP3R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_FS_USB_EP3R_SETUP       = 0x800  // Bit SETUP.
	USB_FS_USB_EP3R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_FS_USB_EP3R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_FS_USB_EP3R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_FS_USB_EP3R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_FS_USB_EP3R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_FS_USB_EP3R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_FS_USB_EP3R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_FS_USB_EP3R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP4R: endpoint 4 register
	USB_FS_USB_EP4R_EA_Pos      = 0x0    // Position of EA field.
	USB_FS_USB_EP4R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_FS_USB_EP4R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_FS_USB_EP4R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_FS_USB_EP4R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_FS_USB_EP4R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_FS_USB_EP4R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_FS_USB_EP4R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_FS_USB_EP4R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_FS_USB_EP4R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_FS_USB_EP4R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_FS_USB_EP4R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_FS_USB_EP4R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_FS_USB_EP4R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_FS_USB_EP4R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_FS_USB_EP4R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_FS_USB_EP4R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_FS_USB_EP4R_SETUP       = 0x800  // Bit SETUP.
	USB_FS_USB_EP4R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_FS_USB_EP4R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_FS_USB_EP4R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_FS_USB_EP4R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_FS_USB_EP4R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_FS_USB_EP4R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_FS_USB_EP4R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_FS_USB_EP4R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP5R: endpoint 5 register
	USB_FS_USB_EP5R_EA_Pos      = 0x0    // Position of EA field.
	USB_FS_USB_EP5R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_FS_USB_EP5R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_FS_USB_EP5R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_FS_USB_EP5R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_FS_USB_EP5R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_FS_USB_EP5R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_FS_USB_EP5R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_FS_USB_EP5R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_FS_USB_EP5R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_FS_USB_EP5R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_FS_USB_EP5R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_FS_USB_EP5R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_FS_USB_EP5R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_FS_USB_EP5R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_FS_USB_EP5R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_FS_USB_EP5R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_FS_USB_EP5R_SETUP       = 0x800  // Bit SETUP.
	USB_FS_USB_EP5R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_FS_USB_EP5R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_FS_USB_EP5R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_FS_USB_EP5R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_FS_USB_EP5R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_FS_USB_EP5R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_FS_USB_EP5R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_FS_USB_EP5R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP6R: endpoint 6 register
	USB_FS_USB_EP6R_EA_Pos      = 0x0    // Position of EA field.
	USB_FS_USB_EP6R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_FS_USB_EP6R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_FS_USB_EP6R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_FS_USB_EP6R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_FS_USB_EP6R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_FS_USB_EP6R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_FS_USB_EP6R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_FS_USB_EP6R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_FS_USB_EP6R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_FS_USB_EP6R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_FS_USB_EP6R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_FS_USB_EP6R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_FS_USB_EP6R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_FS_USB_EP6R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_FS_USB_EP6R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_FS_USB_EP6R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_FS_USB_EP6R_SETUP       = 0x800  // Bit SETUP.
	USB_FS_USB_EP6R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_FS_USB_EP6R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_FS_USB_EP6R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_FS_USB_EP6R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_FS_USB_EP6R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_FS_USB_EP6R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_FS_USB_EP6R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_FS_USB_EP6R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_EP7R: endpoint 7 register
	USB_FS_USB_EP7R_EA_Pos      = 0x0    // Position of EA field.
	USB_FS_USB_EP7R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_FS_USB_EP7R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_FS_USB_EP7R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_FS_USB_EP7R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_FS_USB_EP7R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_FS_USB_EP7R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_FS_USB_EP7R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_FS_USB_EP7R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_FS_USB_EP7R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_FS_USB_EP7R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_FS_USB_EP7R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_FS_USB_EP7R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_FS_USB_EP7R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_FS_USB_EP7R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_FS_USB_EP7R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_FS_USB_EP7R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_FS_USB_EP7R_SETUP       = 0x800  // Bit SETUP.
	USB_FS_USB_EP7R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_FS_USB_EP7R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_FS_USB_EP7R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_FS_USB_EP7R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_FS_USB_EP7R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_FS_USB_EP7R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_FS_USB_EP7R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_FS_USB_EP7R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// USB_CNTR: control register
	USB_FS_USB_CNTR_FRES_Pos    = 0x0    // Position of FRES field.
	USB_FS_USB_CNTR_FRES_Msk    = 0x1    // Bit mask of FRES field.
	USB_FS_USB_CNTR_FRES        = 0x1    // Bit FRES.
	USB_FS_USB_CNTR_PDWN_Pos    = 0x1    // Position of PDWN field.
	USB_FS_USB_CNTR_PDWN_Msk    = 0x2    // Bit mask of PDWN field.
	USB_FS_USB_CNTR_PDWN        = 0x2    // Bit PDWN.
	USB_FS_USB_CNTR_LPMODE_Pos  = 0x2    // Position of LPMODE field.
	USB_FS_USB_CNTR_LPMODE_Msk  = 0x4    // Bit mask of LPMODE field.
	USB_FS_USB_CNTR_LPMODE      = 0x4    // Bit LPMODE.
	USB_FS_USB_CNTR_FSUSP_Pos   = 0x3    // Position of FSUSP field.
	USB_FS_USB_CNTR_FSUSP_Msk   = 0x8    // Bit mask of FSUSP field.
	USB_FS_USB_CNTR_FSUSP       = 0x8    // Bit FSUSP.
	USB_FS_USB_CNTR_RESUME_Pos  = 0x4    // Position of RESUME field.
	USB_FS_USB_CNTR_RESUME_Msk  = 0x10   // Bit mask of RESUME field.
	USB_FS_USB_CNTR_RESUME      = 0x10   // Bit RESUME.
	USB_FS_USB_CNTR_ESOFM_Pos   = 0x8    // Position of ESOFM field.
	USB_FS_USB_CNTR_ESOFM_Msk   = 0x100  // Bit mask of ESOFM field.
	USB_FS_USB_CNTR_ESOFM       = 0x100  // Bit ESOFM.
	USB_FS_USB_CNTR_SOFM_Pos    = 0x9    // Position of SOFM field.
	USB_FS_USB_CNTR_SOFM_Msk    = 0x200  // Bit mask of SOFM field.
	USB_FS_USB_CNTR_SOFM        = 0x200  // Bit SOFM.
	USB_FS_USB_CNTR_RESETM_Pos  = 0xa    // Position of RESETM field.
	USB_FS_USB_CNTR_RESETM_Msk  = 0x400  // Bit mask of RESETM field.
	USB_FS_USB_CNTR_RESETM      = 0x400  // Bit RESETM.
	USB_FS_USB_CNTR_SUSPM_Pos   = 0xb    // Position of SUSPM field.
	USB_FS_USB_CNTR_SUSPM_Msk   = 0x800  // Bit mask of SUSPM field.
	USB_FS_USB_CNTR_SUSPM       = 0x800  // Bit SUSPM.
	USB_FS_USB_CNTR_WKUPM_Pos   = 0xc    // Position of WKUPM field.
	USB_FS_USB_CNTR_WKUPM_Msk   = 0x1000 // Bit mask of WKUPM field.
	USB_FS_USB_CNTR_WKUPM       = 0x1000 // Bit WKUPM.
	USB_FS_USB_CNTR_ERRM_Pos    = 0xd    // Position of ERRM field.
	USB_FS_USB_CNTR_ERRM_Msk    = 0x2000 // Bit mask of ERRM field.
	USB_FS_USB_CNTR_ERRM        = 0x2000 // Bit ERRM.
	USB_FS_USB_CNTR_PMAOVRM_Pos = 0xe    // Position of PMAOVRM field.
	USB_FS_USB_CNTR_PMAOVRM_Msk = 0x4000 // Bit mask of PMAOVRM field.
	USB_FS_USB_CNTR_PMAOVRM     = 0x4000 // Bit PMAOVRM.
	USB_FS_USB_CNTR_CTRM_Pos    = 0xf    // Position of CTRM field.
	USB_FS_USB_CNTR_CTRM_Msk    = 0x8000 // Bit mask of CTRM field.
	USB_FS_USB_CNTR_CTRM        = 0x8000 // Bit CTRM.

	// ISTR: interrupt status register
	USB_FS_ISTR_EP_ID_Pos  = 0x0    // Position of EP_ID field.
	USB_FS_ISTR_EP_ID_Msk  = 0xf    // Bit mask of EP_ID field.
	USB_FS_ISTR_DIR_Pos    = 0x4    // Position of DIR field.
	USB_FS_ISTR_DIR_Msk    = 0x10   // Bit mask of DIR field.
	USB_FS_ISTR_DIR        = 0x10   // Bit DIR.
	USB_FS_ISTR_ESOF_Pos   = 0x8    // Position of ESOF field.
	USB_FS_ISTR_ESOF_Msk   = 0x100  // Bit mask of ESOF field.
	USB_FS_ISTR_ESOF       = 0x100  // Bit ESOF.
	USB_FS_ISTR_SOF_Pos    = 0x9    // Position of SOF field.
	USB_FS_ISTR_SOF_Msk    = 0x200  // Bit mask of SOF field.
	USB_FS_ISTR_SOF        = 0x200  // Bit SOF.
	USB_FS_ISTR_RESET_Pos  = 0xa    // Position of RESET field.
	USB_FS_ISTR_RESET_Msk  = 0x400  // Bit mask of RESET field.
	USB_FS_ISTR_RESET      = 0x400  // Bit RESET.
	USB_FS_ISTR_SUSP_Pos   = 0xb    // Position of SUSP field.
	USB_FS_ISTR_SUSP_Msk   = 0x800  // Bit mask of SUSP field.
	USB_FS_ISTR_SUSP       = 0x800  // Bit SUSP.
	USB_FS_ISTR_WKUP_Pos   = 0xc    // Position of WKUP field.
	USB_FS_ISTR_WKUP_Msk   = 0x1000 // Bit mask of WKUP field.
	USB_FS_ISTR_WKUP       = 0x1000 // Bit WKUP.
	USB_FS_ISTR_ERR_Pos    = 0xd    // Position of ERR field.
	USB_FS_ISTR_ERR_Msk    = 0x2000 // Bit mask of ERR field.
	USB_FS_ISTR_ERR        = 0x2000 // Bit ERR.
	USB_FS_ISTR_PMAOVR_Pos = 0xe    // Position of PMAOVR field.
	USB_FS_ISTR_PMAOVR_Msk = 0x4000 // Bit mask of PMAOVR field.
	USB_FS_ISTR_PMAOVR     = 0x4000 // Bit PMAOVR.
	USB_FS_ISTR_CTR_Pos    = 0xf    // Position of CTR field.
	USB_FS_ISTR_CTR_Msk    = 0x8000 // Bit mask of CTR field.
	USB_FS_ISTR_CTR        = 0x8000 // Bit CTR.

	// FNR: frame number register
	USB_FS_FNR_FN_Pos   = 0x0    // Position of FN field.
	USB_FS_FNR_FN_Msk   = 0x7ff  // Bit mask of FN field.
	USB_FS_FNR_LSOF_Pos = 0xb    // Position of LSOF field.
	USB_FS_FNR_LSOF_Msk = 0x1800 // Bit mask of LSOF field.
	USB_FS_FNR_LCK_Pos  = 0xd    // Position of LCK field.
	USB_FS_FNR_LCK_Msk  = 0x2000 // Bit mask of LCK field.
	USB_FS_FNR_LCK      = 0x2000 // Bit LCK.
	USB_FS_FNR_RXDM_Pos = 0xe    // Position of RXDM field.
	USB_FS_FNR_RXDM_Msk = 0x4000 // Bit mask of RXDM field.
	USB_FS_FNR_RXDM     = 0x4000 // Bit RXDM.
	USB_FS_FNR_RXDP_Pos = 0xf    // Position of RXDP field.
	USB_FS_FNR_RXDP_Msk = 0x8000 // Bit mask of RXDP field.
	USB_FS_FNR_RXDP     = 0x8000 // Bit RXDP.

	// DADDR: device address
	USB_FS_DADDR_ADD_Pos  = 0x0  // Position of ADD field.
	USB_FS_DADDR_ADD_Msk  = 0x1  // Bit mask of ADD field.
	USB_FS_DADDR_ADD      = 0x1  // Bit ADD.
	USB_FS_DADDR_ADD1_Pos = 0x1  // Position of ADD1 field.
	USB_FS_DADDR_ADD1_Msk = 0x2  // Bit mask of ADD1 field.
	USB_FS_DADDR_ADD1     = 0x2  // Bit ADD1.
	USB_FS_DADDR_ADD2_Pos = 0x2  // Position of ADD2 field.
	USB_FS_DADDR_ADD2_Msk = 0x4  // Bit mask of ADD2 field.
	USB_FS_DADDR_ADD2     = 0x4  // Bit ADD2.
	USB_FS_DADDR_ADD3_Pos = 0x3  // Position of ADD3 field.
	USB_FS_DADDR_ADD3_Msk = 0x8  // Bit mask of ADD3 field.
	USB_FS_DADDR_ADD3     = 0x8  // Bit ADD3.
	USB_FS_DADDR_ADD4_Pos = 0x4  // Position of ADD4 field.
	USB_FS_DADDR_ADD4_Msk = 0x10 // Bit mask of ADD4 field.
	USB_FS_DADDR_ADD4     = 0x10 // Bit ADD4.
	USB_FS_DADDR_ADD5_Pos = 0x5  // Position of ADD5 field.
	USB_FS_DADDR_ADD5_Msk = 0x20 // Bit mask of ADD5 field.
	USB_FS_DADDR_ADD5     = 0x20 // Bit ADD5.
	USB_FS_DADDR_ADD6_Pos = 0x6  // Position of ADD6 field.
	USB_FS_DADDR_ADD6_Msk = 0x40 // Bit mask of ADD6 field.
	USB_FS_DADDR_ADD6     = 0x40 // Bit ADD6.
	USB_FS_DADDR_EF_Pos   = 0x7  // Position of EF field.
	USB_FS_DADDR_EF_Msk   = 0x80 // Bit mask of EF field.
	USB_FS_DADDR_EF       = 0x80 // Bit EF.

	// BTABLE: Buffer table address
	USB_FS_BTABLE_BTABLE_Pos = 0x3    // Position of BTABLE field.
	USB_FS_BTABLE_BTABLE_Msk = 0xfff8 // Bit mask of BTABLE field.
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	I2C_CR1_PE_Pos        = 0x0      // Position of PE field.
	I2C_CR1_PE_Msk        = 0x1      // Bit mask of PE field.
	I2C_CR1_PE            = 0x1      // Bit PE.
	I2C_CR1_TXIE_Pos      = 0x1      // Position of TXIE field.
	I2C_CR1_TXIE_Msk      = 0x2      // Bit mask of TXIE field.
	I2C_CR1_TXIE          = 0x2      // Bit TXIE.
	I2C_CR1_RXIE_Pos      = 0x2      // Position of RXIE field.
	I2C_CR1_RXIE_Msk      = 0x4      // Bit mask of RXIE field.
	I2C_CR1_RXIE          = 0x4      // Bit RXIE.
	I2C_CR1_ADDRIE_Pos    = 0x3      // Position of ADDRIE field.
	I2C_CR1_ADDRIE_Msk    = 0x8      // Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE        = 0x8      // Bit ADDRIE.
	I2C_CR1_NACKIE_Pos    = 0x4      // Position of NACKIE field.
	I2C_CR1_NACKIE_Msk    = 0x10     // Bit mask of NACKIE field.
	I2C_CR1_NACKIE        = 0x10     // Bit NACKIE.
	I2C_CR1_STOPIE_Pos    = 0x5      // Position of STOPIE field.
	I2C_CR1_STOPIE_Msk    = 0x20     // Bit mask of STOPIE field.
	I2C_CR1_STOPIE        = 0x20     // Bit STOPIE.
	I2C_CR1_TCIE_Pos      = 0x6      // Position of TCIE field.
	I2C_CR1_TCIE_Msk      = 0x40     // Bit mask of TCIE field.
	I2C_CR1_TCIE          = 0x40     // Bit TCIE.
	I2C_CR1_ERRIE_Pos     = 0x7      // Position of ERRIE field.
	I2C_CR1_ERRIE_Msk     = 0x80     // Bit mask of ERRIE field.
	I2C_CR1_ERRIE         = 0x80     // Bit ERRIE.
	I2C_CR1_DNF_Pos       = 0x8      // Position of DNF field.
	I2C_CR1_DNF_Msk       = 0xf00    // Bit mask of DNF field.
	I2C_CR1_ANFOFF_Pos    = 0xc      // Position of ANFOFF field.
	I2C_CR1_ANFOFF_Msk    = 0x1000   // Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF        = 0x1000   // Bit ANFOFF.
	I2C_CR1_SWRST_Pos     = 0xd      // Position of SWRST field.
	I2C_CR1_SWRST_Msk     = 0x2000   // Bit mask of SWRST field.
	I2C_CR1_SWRST         = 0x2000   // Bit SWRST.
	I2C_CR1_TXDMAEN_Pos   = 0xe      // Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk   = 0x4000   // Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN       = 0x4000   // Bit TXDMAEN.
	I2C_CR1_RXDMAEN_Pos   = 0xf      // Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk   = 0x8000   // Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN       = 0x8000   // Bit RXDMAEN.
	I2C_CR1_SBC_Pos       = 0x10     // Position of SBC field.
	I2C_CR1_SBC_Msk       = 0x10000  // Bit mask of SBC field.
	I2C_CR1_SBC           = 0x10000  // Bit SBC.
	I2C_CR1_NOSTRETCH_Pos = 0x11     // Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000  // Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH     = 0x20000  // Bit NOSTRETCH.
	I2C_CR1_WUPEN_Pos     = 0x12     // Position of WUPEN field.
	I2C_CR1_WUPEN_Msk     = 0x40000  // Bit mask of WUPEN field.
	I2C_CR1_WUPEN         = 0x40000  // Bit WUPEN.
	I2C_CR1_GCEN_Pos      = 0x13     // Position of GCEN field.
	I2C_CR1_GCEN_Msk      = 0x80000  // Bit mask of GCEN field.
	I2C_CR1_GCEN          = 0x80000  // Bit GCEN.
	I2C_CR1_SMBHEN_Pos    = 0x14     // Position of SMBHEN field.
	I2C_CR1_SMBHEN_Msk    = 0x100000 // Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN        = 0x100000 // Bit SMBHEN.
	I2C_CR1_SMBDEN_Pos    = 0x15     // Position of SMBDEN field.
	I2C_CR1_SMBDEN_Msk    = 0x200000 // Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN        = 0x200000 // Bit SMBDEN.
	I2C_CR1_ALERTEN_Pos   = 0x16     // Position of ALERTEN field.
	I2C_CR1_ALERTEN_Msk   = 0x400000 // Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN       = 0x400000 // Bit ALERTEN.
	I2C_CR1_PECEN_Pos     = 0x17     // Position of PECEN field.
	I2C_CR1_PECEN_Msk     = 0x800000 // Bit mask of PECEN field.
	I2C_CR1_PECEN         = 0x800000 // Bit PECEN.

	// CR2: Control register 2
	I2C_CR2_PECBYTE_Pos = 0x1a      // Position of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000 // Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE     = 0x4000000 // Bit PECBYTE.
	I2C_CR2_AUTOEND_Pos = 0x19      // Position of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000 // Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND     = 0x2000000 // Bit AUTOEND.
	I2C_CR2_RELOAD_Pos  = 0x18      // Position of RELOAD field.
	I2C_CR2_RELOAD_Msk  = 0x1000000 // Bit mask of RELOAD field.
	I2C_CR2_RELOAD      = 0x1000000 // Bit RELOAD.
	I2C_CR2_NBYTES_Pos  = 0x10      // Position of NBYTES field.
	I2C_CR2_NBYTES_Msk  = 0xff0000  // Bit mask of NBYTES field.
	I2C_CR2_NACK_Pos    = 0xf       // Position of NACK field.
	I2C_CR2_NACK_Msk    = 0x8000    // Bit mask of NACK field.
	I2C_CR2_NACK        = 0x8000    // Bit NACK.
	I2C_CR2_STOP_Pos    = 0xe       // Position of STOP field.
	I2C_CR2_STOP_Msk    = 0x4000    // Bit mask of STOP field.
	I2C_CR2_STOP        = 0x4000    // Bit STOP.
	I2C_CR2_START_Pos   = 0xd       // Position of START field.
	I2C_CR2_START_Msk   = 0x2000    // Bit mask of START field.
	I2C_CR2_START       = 0x2000    // Bit START.
	I2C_CR2_HEAD10R_Pos = 0xc       // Position of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000    // Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R     = 0x1000    // Bit HEAD10R.
	I2C_CR2_ADD10_Pos   = 0xb       // Position of ADD10 field.
	I2C_CR2_ADD10_Msk   = 0x800     // Bit mask of ADD10 field.
	I2C_CR2_ADD10       = 0x800     // Bit ADD10.
	I2C_CR2_RD_WRN_Pos  = 0xa       // Position of RD_WRN field.
	I2C_CR2_RD_WRN_Msk  = 0x400     // Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN      = 0x400     // Bit RD_WRN.
	I2C_CR2_SADD8_Pos   = 0x8       // Position of SADD8 field.
	I2C_CR2_SADD8_Msk   = 0x300     // Bit mask of SADD8 field.
	I2C_CR2_SADD1_Pos   = 0x1       // Position of SADD1 field.
	I2C_CR2_SADD1_Msk   = 0xfe      // Bit mask of SADD1 field.
	I2C_CR2_SADD0_Pos   = 0x0       // Position of SADD0 field.
	I2C_CR2_SADD0_Msk   = 0x1       // Bit mask of SADD0 field.
	I2C_CR2_SADD0       = 0x1       // Bit SADD0.

	// OAR1: Own address register 1
	I2C_OAR1_OA1_0_Pos   = 0x0    // Position of OA1_0 field.
	I2C_OAR1_OA1_0_Msk   = 0x1    // Bit mask of OA1_0 field.
	I2C_OAR1_OA1_0       = 0x1    // Bit OA1_0.
	I2C_OAR1_OA1_1_Pos   = 0x1    // Position of OA1_1 field.
	I2C_OAR1_OA1_1_Msk   = 0xfe   // Bit mask of OA1_1 field.
	I2C_OAR1_OA1_8_Pos   = 0x8    // Position of OA1_8 field.
	I2C_OAR1_OA1_8_Msk   = 0x300  // Bit mask of OA1_8 field.
	I2C_OAR1_OA1MODE_Pos = 0xa    // Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400  // Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE     = 0x400  // Bit OA1MODE.
	I2C_OAR1_OA1EN_Pos   = 0xf    // Position of OA1EN field.
	I2C_OAR1_OA1EN_Msk   = 0x8000 // Bit mask of OA1EN field.
	I2C_OAR1_OA1EN       = 0x8000 // Bit OA1EN.

	// OAR2: Own address register 2
	I2C_OAR2_OA2_Pos    = 0x1    // Position of OA2 field.
	I2C_OAR2_OA2_Msk    = 0xfe   // Bit mask of OA2 field.
	I2C_OAR2_OA2MSK_Pos = 0x8    // Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700  // Bit mask of OA2MSK field.
	I2C_OAR2_OA2EN_Pos  = 0xf    // Position of OA2EN field.
	I2C_OAR2_OA2EN_Msk  = 0x8000 // Bit mask of OA2EN field.
	I2C_OAR2_OA2EN      = 0x8000 // Bit OA2EN.

	// TIMINGR: Timing register
	I2C_TIMINGR_SCLL_Pos   = 0x0        // Position of SCLL field.
	I2C_TIMINGR_SCLL_Msk   = 0xff       // Bit mask of SCLL field.
	I2C_TIMINGR_SCLH_Pos   = 0x8        // Position of SCLH field.
	I2C_TIMINGR_SCLH_Msk   = 0xff00     // Bit mask of SCLH field.
	I2C_TIMINGR_SDADEL_Pos = 0x10       // Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000    // Bit mask of SDADEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14       // Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000   // Bit mask of SCLDEL field.
	I2C_TIMINGR_PRESC_Pos  = 0x1c       // Position of PRESC field.
	I2C_TIMINGR_PRESC_Msk  = 0xf0000000 // Bit mask of PRESC field.

	// TIMEOUTR: Status register 1
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0        // Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff      // Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIDLE_Pos    = 0xc        // Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk    = 0x1000     // Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE        = 0x1000     // Bit TIDLE.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf        // Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000     // Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN     = 0x8000     // Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10       // Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000  // Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TEXTEN_Pos   = 0x1f       // Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk   = 0x80000000 // Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN       = 0x80000000 // Bit TEXTEN.

	// ISR: Interrupt and Status register
	I2C_ISR_ADDCODE_Pos = 0x11     // Position of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000 // Bit mask of ADDCODE field.
	I2C_ISR_DIR_Pos     = 0x10     // Position of DIR field.
	I2C_ISR_DIR_Msk     = 0x10000  // Bit mask of DIR field.
	I2C_ISR_DIR         = 0x10000  // Bit DIR.
	I2C_ISR_BUSY_Pos    = 0xf      // Position of BUSY field.
	I2C_ISR_BUSY_Msk    = 0x8000   // Bit mask of BUSY field.
	I2C_ISR_BUSY        = 0x8000   // Bit BUSY.
	I2C_ISR_ALERT_Pos   = 0xd      // Position of ALERT field.
	I2C_ISR_ALERT_Msk   = 0x2000   // Bit mask of ALERT field.
	I2C_ISR_ALERT       = 0x2000   // Bit ALERT.
	I2C_ISR_TIMEOUT_Pos = 0xc      // Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000   // Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT     = 0x1000   // Bit TIMEOUT.
	I2C_ISR_PECERR_Pos  = 0xb      // Position of PECERR field.
	I2C_ISR_PECERR_Msk  = 0x800    // Bit mask of PECERR field.
	I2C_ISR_PECERR      = 0x800    // Bit PECERR.
	I2C_ISR_OVR_Pos     = 0xa      // Position of OVR field.
	I2C_ISR_OVR_Msk     = 0x400    // Bit mask of OVR field.
	I2C_ISR_OVR         = 0x400    // Bit OVR.
	I2C_ISR_ARLO_Pos    = 0x9      // Position of ARLO field.
	I2C_ISR_ARLO_Msk    = 0x200    // Bit mask of ARLO field.
	I2C_ISR_ARLO        = 0x200    // Bit ARLO.
	I2C_ISR_BERR_Pos    = 0x8      // Position of BERR field.
	I2C_ISR_BERR_Msk    = 0x100    // Bit mask of BERR field.
	I2C_ISR_BERR        = 0x100    // Bit BERR.
	I2C_ISR_TCR_Pos     = 0x7      // Position of TCR field.
	I2C_ISR_TCR_Msk     = 0x80     // Bit mask of TCR field.
	I2C_ISR_TCR         = 0x80     // Bit TCR.
	I2C_ISR_TC_Pos      = 0x6      // Position of TC field.
	I2C_ISR_TC_Msk      = 0x40     // Bit mask of TC field.
	I2C_ISR_TC          = 0x40     // Bit TC.
	I2C_ISR_STOPF_Pos   = 0x5      // Position of STOPF field.
	I2C_ISR_STOPF_Msk   = 0x20     // Bit mask of STOPF field.
	I2C_ISR_STOPF       = 0x20     // Bit STOPF.
	I2C_ISR_NACKF_Pos   = 0x4      // Position of NACKF field.
	I2C_ISR_NACKF_Msk   = 0x10     // Bit mask of NACKF field.
	I2C_ISR_NACKF       = 0x10     // Bit NACKF.
	I2C_ISR_ADDR_Pos    = 0x3      // Position of ADDR field.
	I2C_ISR_ADDR_Msk    = 0x8      // Bit mask of ADDR field.
	I2C_ISR_ADDR        = 0x8      // Bit ADDR.
	I2C_ISR_RXNE_Pos    = 0x2      // Position of RXNE field.
	I2C_ISR_RXNE_Msk    = 0x4      // Bit mask of RXNE field.
	I2C_ISR_RXNE        = 0x4      // Bit RXNE.
	I2C_ISR_TXIS_Pos    = 0x1      // Position of TXIS field.
	I2C_ISR_TXIS_Msk    = 0x2      // Bit mask of TXIS field.
	I2C_ISR_TXIS        = 0x2      // Bit TXIS.
	I2C_ISR_TXE_Pos     = 0x0      // Position of TXE field.
	I2C_ISR_TXE_Msk     = 0x1      // Bit mask of TXE field.
	I2C_ISR_TXE         = 0x1      // Bit TXE.

	// ICR: Interrupt clear register
	I2C_ICR_ALERTCF_Pos  = 0xd    // Position of ALERTCF field.
	I2C_ICR_ALERTCF_Msk  = 0x2000 // Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF      = 0x2000 // Bit ALERTCF.
	I2C_ICR_TIMOUTCF_Pos = 0xc    // Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000 // Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF     = 0x1000 // Bit TIMOUTCF.
	I2C_ICR_PECCF_Pos    = 0xb    // Position of PECCF field.
	I2C_ICR_PECCF_Msk    = 0x800  // Bit mask of PECCF field.
	I2C_ICR_PECCF        = 0x800  // Bit PECCF.
	I2C_ICR_OVRCF_Pos    = 0xa    // Position of OVRCF field.
	I2C_ICR_OVRCF_Msk    = 0x400  // Bit mask of OVRCF field.
	I2C_ICR_OVRCF        = 0x400  // Bit OVRCF.
	I2C_ICR_ARLOCF_Pos   = 0x9    // Position of ARLOCF field.
	I2C_ICR_ARLOCF_Msk   = 0x200  // Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF       = 0x200  // Bit ARLOCF.
	I2C_ICR_BERRCF_Pos   = 0x8    // Position of BERRCF field.
	I2C_ICR_BERRCF_Msk   = 0x100  // Bit mask of BERRCF field.
	I2C_ICR_BERRCF       = 0x100  // Bit BERRCF.
	I2C_ICR_STOPCF_Pos   = 0x5    // Position of STOPCF field.
	I2C_ICR_STOPCF_Msk   = 0x20   // Bit mask of STOPCF field.
	I2C_ICR_STOPCF       = 0x20   // Bit STOPCF.
	I2C_ICR_NACKCF_Pos   = 0x4    // Position of NACKCF field.
	I2C_ICR_NACKCF_Msk   = 0x10   // Bit mask of NACKCF field.
	I2C_ICR_NACKCF       = 0x10   // Bit NACKCF.
	I2C_ICR_ADDRCF_Pos   = 0x3    // Position of ADDRCF field.
	I2C_ICR_ADDRCF_Msk   = 0x8    // Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF       = 0x8    // Bit ADDRCF.

	// PECR: PEC register
	I2C_PECR_PEC_Pos = 0x0  // Position of PEC field.
	I2C_PECR_PEC_Msk = 0xff // Bit mask of PEC field.

	// RXDR: Receive data register
	I2C_RXDR_RXDATA_Pos = 0x0  // Position of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff // Bit mask of RXDATA field.

	// TXDR: Transmit data register
	I2C_TXDR_TXDATA_Pos = 0x0  // Position of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff // Bit mask of TXDATA field.
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	IWDG_KR_KEY_Pos = 0x0    // Position of KEY field.
	IWDG_KR_KEY_Msk = 0xffff // Bit mask of KEY field.

	// PR: Prescaler register
	IWDG_PR_PR_Pos = 0x0 // Position of PR field.
	IWDG_PR_PR_Msk = 0x7 // Bit mask of PR field.

	// RLR: Reload register
	IWDG_RLR_RL_Pos = 0x0   // Position of RL field.
	IWDG_RLR_RL_Msk = 0xfff // Bit mask of RL field.

	// SR: Status register
	IWDG_SR_PVU_Pos = 0x0 // Position of PVU field.
	IWDG_SR_PVU_Msk = 0x1 // Bit mask of PVU field.
	IWDG_SR_PVU     = 0x1 // Bit PVU.
	IWDG_SR_RVU_Pos = 0x1 // Position of RVU field.
	IWDG_SR_RVU_Msk = 0x2 // Bit mask of RVU field.
	IWDG_SR_RVU     = 0x2 // Bit RVU.
	IWDG_SR_WVU_Pos = 0x2 // Position of WVU field.
	IWDG_SR_WVU_Msk = 0x4 // Bit mask of WVU field.
	IWDG_SR_WVU     = 0x4 // Bit WVU.

	// WINR: Window register
	IWDG_WINR_WIN_Pos = 0x0   // Position of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff // Bit mask of WIN field.
)

// Bitfields for WWDG: Window watchdog
const (
	// CR: Control register
	WWDG_CR_T_Pos    = 0x0  // Position of T field.
	WWDG_CR_T_Msk    = 0x7f // Bit mask of T field.
	WWDG_CR_WDGA_Pos = 0x7  // Position of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80 // Bit mask of WDGA field.
	WWDG_CR_WDGA     = 0x80 // Bit WDGA.

	// CFR: Configuration register
	WWDG_CFR_EWI_Pos   = 0x9   // Position of EWI field.
	WWDG_CFR_EWI_Msk   = 0x200 // Bit mask of EWI field.
	WWDG_CFR_EWI       = 0x200 // Bit EWI.
	WWDG_CFR_WDGTB_Pos = 0x7   // Position of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180 // Bit mask of WDGTB field.
	WWDG_CFR_W_Pos     = 0x0   // Position of W field.
	WWDG_CFR_W_Msk     = 0x7f  // Bit mask of W field.

	// SR: Status register
	WWDG_SR_EWIF_Pos = 0x0 // Position of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1 // Bit mask of EWIF field.
	WWDG_SR_EWIF     = 0x1 // Bit EWIF.
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	RTC_TR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TR_PM      = 0x400000 // Bit PM.
	RTC_TR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TR_SU_Msk  = 0xf      // Bit mask of SU field.

	// DR: date register
	RTC_DR_YT_Pos  = 0x14     // Position of YT field.
	RTC_DR_YT_Msk  = 0xf00000 // Bit mask of YT field.
	RTC_DR_YU_Pos  = 0x10     // Position of YU field.
	RTC_DR_YU_Msk  = 0xf0000  // Bit mask of YU field.
	RTC_DR_WDU_Pos = 0xd      // Position of WDU field.
	RTC_DR_WDU_Msk = 0xe000   // Bit mask of WDU field.
	RTC_DR_MT_Pos  = 0xc      // Position of MT field.
	RTC_DR_MT_Msk  = 0x1000   // Bit mask of MT field.
	RTC_DR_MT      = 0x1000   // Bit MT.
	RTC_DR_MU_Pos  = 0x8      // Position of MU field.
	RTC_DR_MU_Msk  = 0xf00    // Bit mask of MU field.
	RTC_DR_DT_Pos  = 0x4      // Position of DT field.
	RTC_DR_DT_Msk  = 0x30     // Bit mask of DT field.
	RTC_DR_DU_Pos  = 0x0      // Position of DU field.
	RTC_DR_DU_Msk  = 0xf      // Bit mask of DU field.

	// CR: control register
	RTC_CR_WCKSEL_Pos  = 0x0      // Position of WCKSEL field.
	RTC_CR_WCKSEL_Msk  = 0x7      // Bit mask of WCKSEL field.
	RTC_CR_TSEDGE_Pos  = 0x3      // Position of TSEDGE field.
	RTC_CR_TSEDGE_Msk  = 0x8      // Bit mask of TSEDGE field.
	RTC_CR_TSEDGE      = 0x8      // Bit TSEDGE.
	RTC_CR_REFCKON_Pos = 0x4      // Position of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10     // Bit mask of REFCKON field.
	RTC_CR_REFCKON     = 0x10     // Bit REFCKON.
	RTC_CR_BYPSHAD_Pos = 0x5      // Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20     // Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD     = 0x20     // Bit BYPSHAD.
	RTC_CR_FMT_Pos     = 0x6      // Position of FMT field.
	RTC_CR_FMT_Msk     = 0x40     // Bit mask of FMT field.
	RTC_CR_FMT         = 0x40     // Bit FMT.
	RTC_CR_ALRAE_Pos   = 0x8      // Position of ALRAE field.
	RTC_CR_ALRAE_Msk   = 0x100    // Bit mask of ALRAE field.
	RTC_CR_ALRAE       = 0x100    // Bit ALRAE.
	RTC_CR_ALRBE_Pos   = 0x9      // Position of ALRBE field.
	RTC_CR_ALRBE_Msk   = 0x200    // Bit mask of ALRBE field.
	RTC_CR_ALRBE       = 0x200    // Bit ALRBE.
	RTC_CR_WUTE_Pos    = 0xa      // Position of WUTE field.
	RTC_CR_WUTE_Msk    = 0x400    // Bit mask of WUTE field.
	RTC_CR_WUTE        = 0x400    // Bit WUTE.
	RTC_CR_TSE_Pos     = 0xb      // Position of TSE field.
	RTC_CR_TSE_Msk     = 0x800    // Bit mask of TSE field.
	RTC_CR_TSE         = 0x800    // Bit TSE.
	RTC_CR_ALRAIE_Pos  = 0xc      // Position of ALRAIE field.
	RTC_CR_ALRAIE_Msk  = 0x1000   // Bit mask of ALRAIE field.
	RTC_CR_ALRAIE      = 0x1000   // Bit ALRAIE.
	RTC_CR_ALRBIE_Pos  = 0xd      // Position of ALRBIE field.
	RTC_CR_ALRBIE_Msk  = 0x2000   // Bit mask of ALRBIE field.
	RTC_CR_ALRBIE      = 0x2000   // Bit ALRBIE.
	RTC_CR_WUTIE_Pos   = 0xe      // Position of WUTIE field.
	RTC_CR_WUTIE_Msk   = 0x4000   // Bit mask of WUTIE field.
	RTC_CR_WUTIE       = 0x4000   // Bit WUTIE.
	RTC_CR_TSIE_Pos    = 0xf      // Position of TSIE field.
	RTC_CR_TSIE_Msk    = 0x8000   // Bit mask of TSIE field.
	RTC_CR_TSIE        = 0x8000   // Bit TSIE.
	RTC_CR_ADD1H_Pos   = 0x10     // Position of ADD1H field.
	RTC_CR_ADD1H_Msk   = 0x10000  // Bit mask of ADD1H field.
	RTC_CR_ADD1H       = 0x10000  // Bit ADD1H.
	RTC_CR_SUB1H_Pos   = 0x11     // Position of SUB1H field.
	RTC_CR_SUB1H_Msk   = 0x20000  // Bit mask of SUB1H field.
	RTC_CR_SUB1H       = 0x20000  // Bit SUB1H.
	RTC_CR_BKP_Pos     = 0x12     // Position of BKP field.
	RTC_CR_BKP_Msk     = 0x40000  // Bit mask of BKP field.
	RTC_CR_BKP         = 0x40000  // Bit BKP.
	RTC_CR_COSEL_Pos   = 0x13     // Position of COSEL field.
	RTC_CR_COSEL_Msk   = 0x80000  // Bit mask of COSEL field.
	RTC_CR_COSEL       = 0x80000  // Bit COSEL.
	RTC_CR_POL_Pos     = 0x14     // Position of POL field.
	RTC_CR_POL_Msk     = 0x100000 // Bit mask of POL field.
	RTC_CR_POL         = 0x100000 // Bit POL.
	RTC_CR_OSEL_Pos    = 0x15     // Position of OSEL field.
	RTC_CR_OSEL_Msk    = 0x600000 // Bit mask of OSEL field.
	RTC_CR_COE_Pos     = 0x17     // Position of COE field.
	RTC_CR_COE_Msk     = 0x800000 // Bit mask of COE field.
	RTC_CR_COE         = 0x800000 // Bit COE.

	// ISR: initialization and status           register
	RTC_ISR_ALRAWF_Pos  = 0x0     // Position of ALRAWF field.
	RTC_ISR_ALRAWF_Msk  = 0x1     // Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF      = 0x1     // Bit ALRAWF.
	RTC_ISR_ALRBWF_Pos  = 0x1     // Position of ALRBWF field.
	RTC_ISR_ALRBWF_Msk  = 0x2     // Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF      = 0x2     // Bit ALRBWF.
	RTC_ISR_WUTWF_Pos   = 0x2     // Position of WUTWF field.
	RTC_ISR_WUTWF_Msk   = 0x4     // Bit mask of WUTWF field.
	RTC_ISR_WUTWF       = 0x4     // Bit WUTWF.
	RTC_ISR_SHPF_Pos    = 0x3     // Position of SHPF field.
	RTC_ISR_SHPF_Msk    = 0x8     // Bit mask of SHPF field.
	RTC_ISR_SHPF        = 0x8     // Bit SHPF.
	RTC_ISR_INITS_Pos   = 0x4     // Position of INITS field.
	RTC_ISR_INITS_Msk   = 0x10    // Bit mask of INITS field.
	RTC_ISR_INITS       = 0x10    // Bit INITS.
	RTC_ISR_RSF_Pos     = 0x5     // Position of RSF field.
	RTC_ISR_RSF_Msk     = 0x20    // Bit mask of RSF field.
	RTC_ISR_RSF         = 0x20    // Bit RSF.
	RTC_ISR_INITF_Pos   = 0x6     // Position of INITF field.
	RTC_ISR_INITF_Msk   = 0x40    // Bit mask of INITF field.
	RTC_ISR_INITF       = 0x40    // Bit INITF.
	RTC_ISR_INIT_Pos    = 0x7     // Position of INIT field.
	RTC_ISR_INIT_Msk    = 0x80    // Bit mask of INIT field.
	RTC_ISR_INIT        = 0x80    // Bit INIT.
	RTC_ISR_ALRAF_Pos   = 0x8     // Position of ALRAF field.
	RTC_ISR_ALRAF_Msk   = 0x100   // Bit mask of ALRAF field.
	RTC_ISR_ALRAF       = 0x100   // Bit ALRAF.
	RTC_ISR_ALRBF_Pos   = 0x9     // Position of ALRBF field.
	RTC_ISR_ALRBF_Msk   = 0x200   // Bit mask of ALRBF field.
	RTC_ISR_ALRBF       = 0x200   // Bit ALRBF.
	RTC_ISR_WUTF_Pos    = 0xa     // Position of WUTF field.
	RTC_ISR_WUTF_Msk    = 0x400   // Bit mask of WUTF field.
	RTC_ISR_WUTF        = 0x400   // Bit WUTF.
	RTC_ISR_TSF_Pos     = 0xb     // Position of TSF field.
	RTC_ISR_TSF_Msk     = 0x800   // Bit mask of TSF field.
	RTC_ISR_TSF         = 0x800   // Bit TSF.
	RTC_ISR_TSOVF_Pos   = 0xc     // Position of TSOVF field.
	RTC_ISR_TSOVF_Msk   = 0x1000  // Bit mask of TSOVF field.
	RTC_ISR_TSOVF       = 0x1000  // Bit TSOVF.
	RTC_ISR_TAMP1F_Pos  = 0xd     // Position of TAMP1F field.
	RTC_ISR_TAMP1F_Msk  = 0x2000  // Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F      = 0x2000  // Bit TAMP1F.
	RTC_ISR_TAMP2F_Pos  = 0xe     // Position of TAMP2F field.
	RTC_ISR_TAMP2F_Msk  = 0x4000  // Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F      = 0x4000  // Bit TAMP2F.
	RTC_ISR_TAMP3F_Pos  = 0xf     // Position of TAMP3F field.
	RTC_ISR_TAMP3F_Msk  = 0x8000  // Bit mask of TAMP3F field.
	RTC_ISR_TAMP3F      = 0x8000  // Bit TAMP3F.
	RTC_ISR_RECALPF_Pos = 0x10    // Position of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000 // Bit mask of RECALPF field.
	RTC_ISR_RECALPF     = 0x10000 // Bit RECALPF.

	// PRER: prescaler register
	RTC_PRER_PREDIV_A_Pos = 0x10     // Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000 // Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_S_Pos = 0x0      // Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff   // Bit mask of PREDIV_S field.

	// WUTR: wakeup timer register
	RTC_WUTR_WUT_Pos = 0x0    // Position of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff // Bit mask of WUT field.

	// ALRMAR: alarm A register
	RTC_ALRMAR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMAR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMAR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMAR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMAR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMAR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMAR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMAR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMAR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMAR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMAR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMAR_PM        = 0x400000   // Bit PM.
	RTC_ALRMAR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMAR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMAR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMAR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMAR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMAR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMAR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMAR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMAR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMAR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMAR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMAR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMAR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMAR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMAR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMAR_SU_Msk    = 0xf        // Bit mask of SU field.

	// ALRMBR: alarm B register
	RTC_ALRMBR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMBR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMBR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMBR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMBR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMBR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMBR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMBR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMBR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMBR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMBR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMBR_PM        = 0x400000   // Bit PM.
	RTC_ALRMBR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMBR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMBR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMBR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMBR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMBR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMBR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMBR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMBR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMBR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMBR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMBR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMBR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMBR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMBR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMBR_SU_Msk    = 0xf        // Bit mask of SU field.

	// WPR: write protection register
	RTC_WPR_KEY_Pos = 0x0  // Position of KEY field.
	RTC_WPR_KEY_Msk = 0xff // Bit mask of KEY field.

	// SSR: sub second register
	RTC_SSR_SS_Pos = 0x0    // Position of SS field.
	RTC_SSR_SS_Msk = 0xffff // Bit mask of SS field.

	// SHIFTR: shift control register
	RTC_SHIFTR_ADD1S_Pos = 0x1f       // Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000 // Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S     = 0x80000000 // Bit ADD1S.
	RTC_SHIFTR_SUBFS_Pos = 0x0        // Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff     // Bit mask of SUBFS field.

	// TSTR: time stamp time register
	RTC_TSTR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TSTR_SU_Msk  = 0xf      // Bit mask of SU field.
	RTC_TSTR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TSTR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TSTR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TSTR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TSTR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TSTR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TSTR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TSTR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TSTR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TSTR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TSTR_PM      = 0x400000 // Bit PM.

	// TSDR: time stamp date register
	RTC_TSDR_WDU_Pos = 0xd    // Position of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000 // Bit mask of WDU field.
	RTC_TSDR_MT_Pos  = 0xc    // Position of MT field.
	RTC_TSDR_MT_Msk  = 0x1000 // Bit mask of MT field.
	RTC_TSDR_MT      = 0x1000 // Bit MT.
	RTC_TSDR_MU_Pos  = 0x8    // Position of MU field.
	RTC_TSDR_MU_Msk  = 0xf00  // Bit mask of MU field.
	RTC_TSDR_DT_Pos  = 0x4    // Position of DT field.
	RTC_TSDR_DT_Msk  = 0x30   // Bit mask of DT field.
	RTC_TSDR_DU_Pos  = 0x0    // Position of DU field.
	RTC_TSDR_DU_Msk  = 0xf    // Bit mask of DU field.

	// TSSSR: timestamp sub second register
	RTC_TSSSR_SS_Pos = 0x0    // Position of SS field.
	RTC_TSSSR_SS_Msk = 0xffff // Bit mask of SS field.

	// CALR: calibration register
	RTC_CALR_CALP_Pos   = 0xf    // Position of CALP field.
	RTC_CALR_CALP_Msk   = 0x8000 // Bit mask of CALP field.
	RTC_CALR_CALP       = 0x8000 // Bit CALP.
	RTC_CALR_CALW8_Pos  = 0xe    // Position of CALW8 field.
	RTC_CALR_CALW8_Msk  = 0x4000 // Bit mask of CALW8 field.
	RTC_CALR_CALW8      = 0x4000 // Bit CALW8.
	RTC_CALR_CALW16_Pos = 0xd    // Position of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000 // Bit mask of CALW16 field.
	RTC_CALR_CALW16     = 0x2000 // Bit CALW16.
	RTC_CALR_CALM_Pos   = 0x0    // Position of CALM field.
	RTC_CALR_CALM_Msk   = 0x1ff  // Bit mask of CALM field.

	// TAFCR: tamper and alternate function configuration           register
	RTC_TAFCR_TAMP1E_Pos    = 0x0      // Position of TAMP1E field.
	RTC_TAFCR_TAMP1E_Msk    = 0x1      // Bit mask of TAMP1E field.
	RTC_TAFCR_TAMP1E        = 0x1      // Bit TAMP1E.
	RTC_TAFCR_TAMP1TRG_Pos  = 0x1      // Position of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Msk  = 0x2      // Bit mask of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG      = 0x2      // Bit TAMP1TRG.
	RTC_TAFCR_TAMPIE_Pos    = 0x2      // Position of TAMPIE field.
	RTC_TAFCR_TAMPIE_Msk    = 0x4      // Bit mask of TAMPIE field.
	RTC_TAFCR_TAMPIE        = 0x4      // Bit TAMPIE.
	RTC_TAFCR_TAMP2E_Pos    = 0x3      // Position of TAMP2E field.
	RTC_TAFCR_TAMP2E_Msk    = 0x8      // Bit mask of TAMP2E field.
	RTC_TAFCR_TAMP2E        = 0x8      // Bit TAMP2E.
	RTC_TAFCR_TAMP2TRG_Pos  = 0x4      // Position of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Msk  = 0x10     // Bit mask of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG      = 0x10     // Bit TAMP2TRG.
	RTC_TAFCR_TAMP3E_Pos    = 0x5      // Position of TAMP3E field.
	RTC_TAFCR_TAMP3E_Msk    = 0x20     // Bit mask of TAMP3E field.
	RTC_TAFCR_TAMP3E        = 0x20     // Bit TAMP3E.
	RTC_TAFCR_TAMP3TRG_Pos  = 0x6      // Position of TAMP3TRG field.
	RTC_TAFCR_TAMP3TRG_Msk  = 0x40     // Bit mask of TAMP3TRG field.
	RTC_TAFCR_TAMP3TRG      = 0x40     // Bit TAMP3TRG.
	RTC_TAFCR_TAMPTS_Pos    = 0x7      // Position of TAMPTS field.
	RTC_TAFCR_TAMPTS_Msk    = 0x80     // Bit mask of TAMPTS field.
	RTC_TAFCR_TAMPTS        = 0x80     // Bit TAMPTS.
	RTC_TAFCR_TAMPFREQ_Pos  = 0x8      // Position of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Msk  = 0x700    // Bit mask of TAMPFREQ field.
	RTC_TAFCR_TAMPFLT_Pos   = 0xb      // Position of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Msk   = 0x1800   // Bit mask of TAMPFLT field.
	RTC_TAFCR_TAMPPRCH_Pos  = 0xd      // Position of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Msk  = 0x6000   // Bit mask of TAMPPRCH field.
	RTC_TAFCR_TAMPPUDIS_Pos = 0xf      // Position of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Msk = 0x8000   // Bit mask of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS     = 0x8000   // Bit TAMPPUDIS.
	RTC_TAFCR_PC13VALUE_Pos = 0x12     // Position of PC13VALUE field.
	RTC_TAFCR_PC13VALUE_Msk = 0x40000  // Bit mask of PC13VALUE field.
	RTC_TAFCR_PC13VALUE     = 0x40000  // Bit PC13VALUE.
	RTC_TAFCR_PC13MODE_Pos  = 0x13     // Position of PC13MODE field.
	RTC_TAFCR_PC13MODE_Msk  = 0x80000  // Bit mask of PC13MODE field.
	RTC_TAFCR_PC13MODE      = 0x80000  // Bit PC13MODE.
	RTC_TAFCR_PC14VALUE_Pos = 0x14     // Position of PC14VALUE field.
	RTC_TAFCR_PC14VALUE_Msk = 0x100000 // Bit mask of PC14VALUE field.
	RTC_TAFCR_PC14VALUE     = 0x100000 // Bit PC14VALUE.
	RTC_TAFCR_PC14MODE_Pos  = 0x15     // Position of PC14MODE field.
	RTC_TAFCR_PC14MODE_Msk  = 0x200000 // Bit mask of PC14MODE field.
	RTC_TAFCR_PC14MODE      = 0x200000 // Bit PC14MODE.
	RTC_TAFCR_PC15VALUE_Pos = 0x16     // Position of PC15VALUE field.
	RTC_TAFCR_PC15VALUE_Msk = 0x400000 // Bit mask of PC15VALUE field.
	RTC_TAFCR_PC15VALUE     = 0x400000 // Bit PC15VALUE.
	RTC_TAFCR_PC15MODE_Pos  = 0x17     // Position of PC15MODE field.
	RTC_TAFCR_PC15MODE_Msk  = 0x800000 // Bit mask of PC15MODE field.
	RTC_TAFCR_PC15MODE      = 0x800000 // Bit PC15MODE.

	// ALRMASSR: alarm A sub second register
	RTC_ALRMASSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMASSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMASSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// ALRMBSSR: alarm B sub second register
	RTC_ALRMBSSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMBSSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMBSSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// BKP0R: backup register
	RTC_BKP0R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP0R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP1R: backup register
	RTC_BKP1R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP1R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP2R: backup register
	RTC_BKP2R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP2R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP3R: backup register
	RTC_BKP3R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP3R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP4R: backup register
	RTC_BKP4R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP4R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP5R: backup register
	RTC_BKP5R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP5R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP6R: backup register
	RTC_BKP6R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP6R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP7R: backup register
	RTC_BKP7R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP7R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP8R: backup register
	RTC_BKP8R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP8R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP9R: backup register
	RTC_BKP9R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP9R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP10R: backup register
	RTC_BKP10R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP10R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP11R: backup register
	RTC_BKP11R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP11R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP12R: backup register
	RTC_BKP12R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP12R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP13R: backup register
	RTC_BKP13R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP13R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP14R: backup register
	RTC_BKP14R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP14R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP15R: backup register
	RTC_BKP15R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP15R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP16R: backup register
	RTC_BKP16R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP16R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP17R: backup register
	RTC_BKP17R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP17R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP18R: backup register
	RTC_BKP18R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP18R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP19R: backup register
	RTC_BKP19R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP19R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP20R: backup register
	RTC_BKP20R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP20R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP21R: backup register
	RTC_BKP21R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP21R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP22R: backup register
	RTC_BKP22R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP22R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP23R: backup register
	RTC_BKP23R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP23R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP24R: backup register
	RTC_BKP24R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP24R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP25R: backup register
	RTC_BKP25R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP25R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP26R: backup register
	RTC_BKP26R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP26R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP27R: backup register
	RTC_BKP27R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP27R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP28R: backup register
	RTC_BKP28R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP28R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP29R: backup register
	RTC_BKP29R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP29R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP30R: backup register
	RTC_BKP30R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP30R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP31R: backup register
	RTC_BKP31R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP31R_BKP_Msk = 0xffffffff // Bit mask of BKP field.
)

// Bitfields for DAC: Digital-to-analog converter
const (
	// CR: control register
	DAC_CR_DMAUDRIE2_Pos = 0x1d       // Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000 // Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2     = 0x20000000 // Bit DMAUDRIE2.
	DAC_CR_DMAEN2_Pos    = 0x1c       // Position of DMAEN2 field.
	DAC_CR_DMAEN2_Msk    = 0x10000000 // Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2        = 0x10000000 // Bit DMAEN2.
	DAC_CR_MAMP2_Pos     = 0x18       // Position of MAMP2 field.
	DAC_CR_MAMP2_Msk     = 0xf000000  // Bit mask of MAMP2 field.
	DAC_CR_WAVE2_Pos     = 0x16       // Position of WAVE2 field.
	DAC_CR_WAVE2_Msk     = 0xc00000   // Bit mask of WAVE2 field.
	DAC_CR_TSEL2_Pos     = 0x13       // Position of TSEL2 field.
	DAC_CR_TSEL2_Msk     = 0x380000   // Bit mask of TSEL2 field.
	DAC_CR_TEN2_Pos      = 0x12       // Position of TEN2 field.
	DAC_CR_TEN2_Msk      = 0x40000    // Bit mask of TEN2 field.
	DAC_CR_TEN2          = 0x40000    // Bit TEN2.
	DAC_CR_BOFF2_Pos     = 0x11       // Position of BOFF2 field.
	DAC_CR_BOFF2_Msk     = 0x20000    // Bit mask of BOFF2 field.
	DAC_CR_BOFF2         = 0x20000    // Bit BOFF2.
	DAC_CR_EN2_Pos       = 0x10       // Position of EN2 field.
	DAC_CR_EN2_Msk       = 0x10000    // Bit mask of EN2 field.
	DAC_CR_EN2           = 0x10000    // Bit EN2.
	DAC_CR_DMAUDRIE1_Pos = 0xd        // Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000     // Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1     = 0x2000     // Bit DMAUDRIE1.
	DAC_CR_DMAEN1_Pos    = 0xc        // Position of DMAEN1 field.
	DAC_CR_DMAEN1_Msk    = 0x1000     // Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1        = 0x1000     // Bit DMAEN1.
	DAC_CR_MAMP1_Pos     = 0x8        // Position of MAMP1 field.
	DAC_CR_MAMP1_Msk     = 0xf00      // Bit mask of MAMP1 field.
	DAC_CR_WAVE1_Pos     = 0x6        // Position of WAVE1 field.
	DAC_CR_WAVE1_Msk     = 0xc0       // Bit mask of WAVE1 field.
	DAC_CR_TSEL1_Pos     = 0x3        // Position of TSEL1 field.
	DAC_CR_TSEL1_Msk     = 0x38       // Bit mask of TSEL1 field.
	DAC_CR_TEN1_Pos      = 0x2        // Position of TEN1 field.
	DAC_CR_TEN1_Msk      = 0x4        // Bit mask of TEN1 field.
	DAC_CR_TEN1          = 0x4        // Bit TEN1.
	DAC_CR_BOFF1_Pos     = 0x1        // Position of BOFF1 field.
	DAC_CR_BOFF1_Msk     = 0x2        // Bit mask of BOFF1 field.
	DAC_CR_BOFF1         = 0x2        // Bit BOFF1.
	DAC_CR_EN1_Pos       = 0x0        // Position of EN1 field.
	DAC_CR_EN1_Msk       = 0x1        // Bit mask of EN1 field.
	DAC_CR_EN1           = 0x1        // Bit EN1.

	// SWTRIGR: software trigger register
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1 // Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2 // Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2     = 0x2 // Bit SWTRIG2.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0 // Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1 // Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1     = 0x1 // Bit SWTRIG1.

	// DHR12R1: channel1 12-bit right-aligned data holding           register
	DAC_DHR12R1_DACC1DHR_Pos = 0x0   // Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff // Bit mask of DACC1DHR field.

	// DHR12L1: channel1 12-bit left aligned data holding           register
	DAC_DHR12L1_DACC1DHR_Pos = 0x4    // Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0 // Bit mask of DACC1DHR field.

	// DHR8R1: channel1 8-bit right aligned data holding           register
	DAC_DHR8R1_DACC1DHR_Pos = 0x0  // Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff // Bit mask of DACC1DHR field.

	// DHR12R2: channel2 12-bit right aligned data holding           register
	DAC_DHR12R2_DACC2DHR_Pos = 0x0   // Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff // Bit mask of DACC2DHR field.

	// DHR12L2: channel2 12-bit left aligned data holding           register
	DAC_DHR12L2_DACC2DHR_Pos = 0x4    // Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0 // Bit mask of DACC2DHR field.

	// DHR8R2: channel2 8-bit right-aligned data holding           register
	DAC_DHR8R2_DACC2DHR_Pos = 0x0  // Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff // Bit mask of DACC2DHR field.

	// DHR12RD: Dual DAC 12-bit right-aligned data holding           register
	DAC_DHR12RD_DACC2DHR_Pos = 0x10      // Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000 // Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0       // Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff     // Bit mask of DACC1DHR field.

	// DHR12LD: DUAL DAC 12-bit left aligned data holding           register
	DAC_DHR12LD_DACC2DHR_Pos = 0x14       // Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000 // Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4        // Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0     // Bit mask of DACC1DHR field.

	// DHR8RD: DUAL DAC 8-bit right aligned data holding           register
	DAC_DHR8RD_DACC2DHR_Pos = 0x8    // Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00 // Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0    // Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff   // Bit mask of DACC1DHR field.

	// DOR1: channel1 data output register
	DAC_DOR1_DACC1DOR_Pos = 0x0   // Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff // Bit mask of DACC1DOR field.

	// DOR2: channel2 data output register
	DAC_DOR2_DACC2DOR_Pos = 0x0   // Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff // Bit mask of DACC2DOR field.

	// SR: status register
	DAC_SR_DMAUDR2_Pos = 0x1d       // Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000 // Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2     = 0x20000000 // Bit DMAUDR2.
	DAC_SR_DMAUDR1_Pos = 0xd        // Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000     // Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1     = 0x2000     // Bit DMAUDR1.
)

// Bitfields for DBGMCU: Debug support
const (
	// IDCODE: MCU Device ID Code Register
	DBGMCU_IDCODE_DEV_ID_Pos = 0x0        // Position of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Msk = 0xfff      // Bit mask of DEV_ID field.
	DBGMCU_IDCODE_REV_ID_Pos = 0x10       // Position of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000 // Bit mask of REV_ID field.

	// CR: Debug MCU Configuration           Register
	DBGMCU_CR_DBG_SLEEP_Pos   = 0x0  // Position of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Msk   = 0x1  // Bit mask of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP       = 0x1  // Bit DBG_SLEEP.
	DBGMCU_CR_DBG_STOP_Pos    = 0x1  // Position of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Msk    = 0x2  // Bit mask of DBG_STOP field.
	DBGMCU_CR_DBG_STOP        = 0x2  // Bit DBG_STOP.
	DBGMCU_CR_DBG_STANDBY_Pos = 0x2  // Position of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Msk = 0x4  // Bit mask of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY     = 0x4  // Bit DBG_STANDBY.
	DBGMCU_CR_TRACE_IOEN_Pos  = 0x5  // Position of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN_Msk  = 0x20 // Bit mask of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN      = 0x20 // Bit TRACE_IOEN.
	DBGMCU_CR_TRACE_MODE_Pos  = 0x6  // Position of TRACE_MODE field.
	DBGMCU_CR_TRACE_MODE_Msk  = 0xc0 // Bit mask of TRACE_MODE field.

	// APB1FZ: APB Low Freeze Register
	DBGMCU_APB1FZ_DBG_TIM2_STOP_Pos      = 0x0       // Position of DBG_TIM2_STOP field.
	DBGMCU_APB1FZ_DBG_TIM2_STOP_Msk      = 0x1       // Bit mask of DBG_TIM2_STOP field.
	DBGMCU_APB1FZ_DBG_TIM2_STOP          = 0x1       // Bit DBG_TIM2_STOP.
	DBGMCU_APB1FZ_DBG_TIM3_STOP_Pos      = 0x1       // Position of DBG_TIM3_STOP field.
	DBGMCU_APB1FZ_DBG_TIM3_STOP_Msk      = 0x2       // Bit mask of DBG_TIM3_STOP field.
	DBGMCU_APB1FZ_DBG_TIM3_STOP          = 0x2       // Bit DBG_TIM3_STOP.
	DBGMCU_APB1FZ_DBG_TIM4_STOP_Pos      = 0x2       // Position of DBG_TIM4_STOP field.
	DBGMCU_APB1FZ_DBG_TIM4_STOP_Msk      = 0x4       // Bit mask of DBG_TIM4_STOP field.
	DBGMCU_APB1FZ_DBG_TIM4_STOP          = 0x4       // Bit DBG_TIM4_STOP.
	DBGMCU_APB1FZ_DBG_TIM5_STOP_Pos      = 0x3       // Position of DBG_TIM5_STOP field.
	DBGMCU_APB1FZ_DBG_TIM5_STOP_Msk      = 0x8       // Bit mask of DBG_TIM5_STOP field.
	DBGMCU_APB1FZ_DBG_TIM5_STOP          = 0x8       // Bit DBG_TIM5_STOP.
	DBGMCU_APB1FZ_DBG_TIM6_STOP_Pos      = 0x4       // Position of DBG_TIM6_STOP field.
	DBGMCU_APB1FZ_DBG_TIM6_STOP_Msk      = 0x10      // Bit mask of DBG_TIM6_STOP field.
	DBGMCU_APB1FZ_DBG_TIM6_STOP          = 0x10      // Bit DBG_TIM6_STOP.
	DBGMCU_APB1FZ_DBG_TIM7_STOP_Pos      = 0x5       // Position of DBG_TIM7_STOP field.
	DBGMCU_APB1FZ_DBG_TIM7_STOP_Msk      = 0x20      // Bit mask of DBG_TIM7_STOP field.
	DBGMCU_APB1FZ_DBG_TIM7_STOP          = 0x20      // Bit DBG_TIM7_STOP.
	DBGMCU_APB1FZ_DBG_TIM12_STOP_Pos     = 0x6       // Position of DBG_TIM12_STOP field.
	DBGMCU_APB1FZ_DBG_TIM12_STOP_Msk     = 0x40      // Bit mask of DBG_TIM12_STOP field.
	DBGMCU_APB1FZ_DBG_TIM12_STOP         = 0x40      // Bit DBG_TIM12_STOP.
	DBGMCU_APB1FZ_DBG_TIM13_STOP_Pos     = 0x7       // Position of DBG_TIM13_STOP field.
	DBGMCU_APB1FZ_DBG_TIM13_STOP_Msk     = 0x80      // Bit mask of DBG_TIM13_STOP field.
	DBGMCU_APB1FZ_DBG_TIM13_STOP         = 0x80      // Bit DBG_TIM13_STOP.
	DBGMCU_APB1FZ_DBG_TIMER14_STOP_Pos   = 0x8       // Position of DBG_TIMER14_STOP field.
	DBGMCU_APB1FZ_DBG_TIMER14_STOP_Msk   = 0x100     // Bit mask of DBG_TIMER14_STOP field.
	DBGMCU_APB1FZ_DBG_TIMER14_STOP       = 0x100     // Bit DBG_TIMER14_STOP.
	DBGMCU_APB1FZ_DBG_TIM18_STOP_Pos     = 0x9       // Position of DBG_TIM18_STOP field.
	DBGMCU_APB1FZ_DBG_TIM18_STOP_Msk     = 0x200     // Bit mask of DBG_TIM18_STOP field.
	DBGMCU_APB1FZ_DBG_TIM18_STOP         = 0x200     // Bit DBG_TIM18_STOP.
	DBGMCU_APB1FZ_DBG_RTC_STOP_Pos       = 0xa       // Position of DBG_RTC_STOP field.
	DBGMCU_APB1FZ_DBG_RTC_STOP_Msk       = 0x400     // Bit mask of DBG_RTC_STOP field.
	DBGMCU_APB1FZ_DBG_RTC_STOP           = 0x400     // Bit DBG_RTC_STOP.
	DBGMCU_APB1FZ_DBG_WWDG_STOP_Pos      = 0xb       // Position of DBG_WWDG_STOP field.
	DBGMCU_APB1FZ_DBG_WWDG_STOP_Msk      = 0x800     // Bit mask of DBG_WWDG_STOP field.
	DBGMCU_APB1FZ_DBG_WWDG_STOP          = 0x800     // Bit DBG_WWDG_STOP.
	DBGMCU_APB1FZ_DBG_IWDG_STOP_Pos      = 0xc       // Position of DBG_IWDG_STOP field.
	DBGMCU_APB1FZ_DBG_IWDG_STOP_Msk      = 0x1000    // Bit mask of DBG_IWDG_STOP field.
	DBGMCU_APB1FZ_DBG_IWDG_STOP          = 0x1000    // Bit DBG_IWDG_STOP.
	DBGMCU_APB1FZ_I2C1_SMBUS_TIMEOUT_Pos = 0x15      // Position of I2C1_SMBUS_TIMEOUT field.
	DBGMCU_APB1FZ_I2C1_SMBUS_TIMEOUT_Msk = 0x200000  // Bit mask of I2C1_SMBUS_TIMEOUT field.
	DBGMCU_APB1FZ_I2C1_SMBUS_TIMEOUT     = 0x200000  // Bit I2C1_SMBUS_TIMEOUT.
	DBGMCU_APB1FZ_I2C2_SMBUS_TIMEOUT_Pos = 0x16      // Position of I2C2_SMBUS_TIMEOUT field.
	DBGMCU_APB1FZ_I2C2_SMBUS_TIMEOUT_Msk = 0x400000  // Bit mask of I2C2_SMBUS_TIMEOUT field.
	DBGMCU_APB1FZ_I2C2_SMBUS_TIMEOUT     = 0x400000  // Bit I2C2_SMBUS_TIMEOUT.
	DBGMCU_APB1FZ_DBG_CAN_STOP_Pos       = 0x19      // Position of DBG_CAN_STOP field.
	DBGMCU_APB1FZ_DBG_CAN_STOP_Msk       = 0x2000000 // Bit mask of DBG_CAN_STOP field.
	DBGMCU_APB1FZ_DBG_CAN_STOP           = 0x2000000 // Bit DBG_CAN_STOP.

	// APB2FZ: APB High Freeze Register
	DBGMCU_APB2FZ_DBG_TIM15_STOP_Pos = 0x2  // Position of DBG_TIM15_STOP field.
	DBGMCU_APB2FZ_DBG_TIM15_STOP_Msk = 0x4  // Bit mask of DBG_TIM15_STOP field.
	DBGMCU_APB2FZ_DBG_TIM15_STOP     = 0x4  // Bit DBG_TIM15_STOP.
	DBGMCU_APB2FZ_DBG_TIM16_STOP_Pos = 0x3  // Position of DBG_TIM16_STOP field.
	DBGMCU_APB2FZ_DBG_TIM16_STOP_Msk = 0x8  // Bit mask of DBG_TIM16_STOP field.
	DBGMCU_APB2FZ_DBG_TIM16_STOP     = 0x8  // Bit DBG_TIM16_STOP.
	DBGMCU_APB2FZ_DBG_TIM17_STO_Pos  = 0x4  // Position of DBG_TIM17_STO field.
	DBGMCU_APB2FZ_DBG_TIM17_STO_Msk  = 0x10 // Bit mask of DBG_TIM17_STO field.
	DBGMCU_APB2FZ_DBG_TIM17_STO      = 0x10 // Bit DBG_TIM17_STO.
	DBGMCU_APB2FZ_DBG_TIM19_STOP_Pos = 0x5  // Position of DBG_TIM19_STOP field.
	DBGMCU_APB2FZ_DBG_TIM19_STOP_Msk = 0x20 // Bit mask of DBG_TIM19_STOP field.
	DBGMCU_APB2FZ_DBG_TIM19_STOP     = 0x20 // Bit DBG_TIM19_STOP.
)

// Bitfields for ADC1: Analog-to-Digital Converter
const (
	// ISR: interrupt and status register
	ADC_ISR_JQOVF_Pos = 0xa   // Position of JQOVF field.
	ADC_ISR_JQOVF_Msk = 0x400 // Bit mask of JQOVF field.
	ADC_ISR_JQOVF     = 0x400 // Bit JQOVF.
	ADC_ISR_AWD3_Pos  = 0x9   // Position of AWD3 field.
	ADC_ISR_AWD3_Msk  = 0x200 // Bit mask of AWD3 field.
	ADC_ISR_AWD3      = 0x200 // Bit AWD3.
	ADC_ISR_AWD2_Pos  = 0x8   // Position of AWD2 field.
	ADC_ISR_AWD2_Msk  = 0x100 // Bit mask of AWD2 field.
	ADC_ISR_AWD2      = 0x100 // Bit AWD2.
	ADC_ISR_AWD1_Pos  = 0x7   // Position of AWD1 field.
	ADC_ISR_AWD1_Msk  = 0x80  // Bit mask of AWD1 field.
	ADC_ISR_AWD1      = 0x80  // Bit AWD1.
	ADC_ISR_JEOS_Pos  = 0x6   // Position of JEOS field.
	ADC_ISR_JEOS_Msk  = 0x40  // Bit mask of JEOS field.
	ADC_ISR_JEOS      = 0x40  // Bit JEOS.
	ADC_ISR_JEOC_Pos  = 0x5   // Position of JEOC field.
	ADC_ISR_JEOC_Msk  = 0x20  // Bit mask of JEOC field.
	ADC_ISR_JEOC      = 0x20  // Bit JEOC.
	ADC_ISR_OVR_Pos   = 0x4   // Position of OVR field.
	ADC_ISR_OVR_Msk   = 0x10  // Bit mask of OVR field.
	ADC_ISR_OVR       = 0x10  // Bit OVR.
	ADC_ISR_EOS_Pos   = 0x3   // Position of EOS field.
	ADC_ISR_EOS_Msk   = 0x8   // Bit mask of EOS field.
	ADC_ISR_EOS       = 0x8   // Bit EOS.
	ADC_ISR_EOC_Pos   = 0x2   // Position of EOC field.
	ADC_ISR_EOC_Msk   = 0x4   // Bit mask of EOC field.
	ADC_ISR_EOC       = 0x4   // Bit EOC.
	ADC_ISR_EOSMP_Pos = 0x1   // Position of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2   // Bit mask of EOSMP field.
	ADC_ISR_EOSMP     = 0x2   // Bit EOSMP.
	ADC_ISR_ADRDY_Pos = 0x0   // Position of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1   // Bit mask of ADRDY field.
	ADC_ISR_ADRDY     = 0x1   // Bit ADRDY.

	// IER: interrupt enable register
	ADC_IER_JQOVFIE_Pos = 0xa   // Position of JQOVFIE field.
	ADC_IER_JQOVFIE_Msk = 0x400 // Bit mask of JQOVFIE field.
	ADC_IER_JQOVFIE     = 0x400 // Bit JQOVFIE.
	ADC_IER_AWD3IE_Pos  = 0x9   // Position of AWD3IE field.
	ADC_IER_AWD3IE_Msk  = 0x200 // Bit mask of AWD3IE field.
	ADC_IER_AWD3IE      = 0x200 // Bit AWD3IE.
	ADC_IER_AWD2IE_Pos  = 0x8   // Position of AWD2IE field.
	ADC_IER_AWD2IE_Msk  = 0x100 // Bit mask of AWD2IE field.
	ADC_IER_AWD2IE      = 0x100 // Bit AWD2IE.
	ADC_IER_AWD1IE_Pos  = 0x7   // Position of AWD1IE field.
	ADC_IER_AWD1IE_Msk  = 0x80  // Bit mask of AWD1IE field.
	ADC_IER_AWD1IE      = 0x80  // Bit AWD1IE.
	ADC_IER_JEOSIE_Pos  = 0x6   // Position of JEOSIE field.
	ADC_IER_JEOSIE_Msk  = 0x40  // Bit mask of JEOSIE field.
	ADC_IER_JEOSIE      = 0x40  // Bit JEOSIE.
	ADC_IER_JEOCIE_Pos  = 0x5   // Position of JEOCIE field.
	ADC_IER_JEOCIE_Msk  = 0x20  // Bit mask of JEOCIE field.
	ADC_IER_JEOCIE      = 0x20  // Bit JEOCIE.
	ADC_IER_OVRIE_Pos   = 0x4   // Position of OVRIE field.
	ADC_IER_OVRIE_Msk   = 0x10  // Bit mask of OVRIE field.
	ADC_IER_OVRIE       = 0x10  // Bit OVRIE.
	ADC_IER_EOSIE_Pos   = 0x3   // Position of EOSIE field.
	ADC_IER_EOSIE_Msk   = 0x8   // Bit mask of EOSIE field.
	ADC_IER_EOSIE       = 0x8   // Bit EOSIE.
	ADC_IER_EOCIE_Pos   = 0x2   // Position of EOCIE field.
	ADC_IER_EOCIE_Msk   = 0x4   // Bit mask of EOCIE field.
	ADC_IER_EOCIE       = 0x4   // Bit EOCIE.
	ADC_IER_EOSMPIE_Pos = 0x1   // Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2   // Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE     = 0x2   // Bit EOSMPIE.
	ADC_IER_ADRDYIE_Pos = 0x0   // Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1   // Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE     = 0x1   // Bit ADRDYIE.

	// CR: control register
	ADC_CR_ADCAL_Pos    = 0x1f       // Position of ADCAL field.
	ADC_CR_ADCAL_Msk    = 0x80000000 // Bit mask of ADCAL field.
	ADC_CR_ADCAL        = 0x80000000 // Bit ADCAL.
	ADC_CR_ADCALDIF_Pos = 0x1e       // Position of ADCALDIF field.
	ADC_CR_ADCALDIF_Msk = 0x40000000 // Bit mask of ADCALDIF field.
	ADC_CR_ADCALDIF     = 0x40000000 // Bit ADCALDIF.
	ADC_CR_DEEPPWD_Pos  = 0x1d       // Position of DEEPPWD field.
	ADC_CR_DEEPPWD_Msk  = 0x20000000 // Bit mask of DEEPPWD field.
	ADC_CR_DEEPPWD      = 0x20000000 // Bit DEEPPWD.
	ADC_CR_ADVREGEN_Pos = 0x1c       // Position of ADVREGEN field.
	ADC_CR_ADVREGEN_Msk = 0x10000000 // Bit mask of ADVREGEN field.
	ADC_CR_ADVREGEN     = 0x10000000 // Bit ADVREGEN.
	ADC_CR_JADSTP_Pos   = 0x5        // Position of JADSTP field.
	ADC_CR_JADSTP_Msk   = 0x20       // Bit mask of JADSTP field.
	ADC_CR_JADSTP       = 0x20       // Bit JADSTP.
	ADC_CR_ADSTP_Pos    = 0x4        // Position of ADSTP field.
	ADC_CR_ADSTP_Msk    = 0x10       // Bit mask of ADSTP field.
	ADC_CR_ADSTP        = 0x10       // Bit ADSTP.
	ADC_CR_JADSTART_Pos = 0x3        // Position of JADSTART field.
	ADC_CR_JADSTART_Msk = 0x8        // Bit mask of JADSTART field.
	ADC_CR_JADSTART     = 0x8        // Bit JADSTART.
	ADC_CR_ADSTART_Pos  = 0x2        // Position of ADSTART field.
	ADC_CR_ADSTART_Msk  = 0x4        // Bit mask of ADSTART field.
	ADC_CR_ADSTART      = 0x4        // Bit ADSTART.
	ADC_CR_ADDIS_Pos    = 0x1        // Position of ADDIS field.
	ADC_CR_ADDIS_Msk    = 0x2        // Bit mask of ADDIS field.
	ADC_CR_ADDIS        = 0x2        // Bit ADDIS.
	ADC_CR_ADEN_Pos     = 0x0        // Position of ADEN field.
	ADC_CR_ADEN_Msk     = 0x1        // Bit mask of ADEN field.
	ADC_CR_ADEN         = 0x1        // Bit ADEN.

	// CFGR: configuration register
	ADC_CFGR_AWDCH1CH_Pos = 0x1a       // Position of AWDCH1CH field.
	ADC_CFGR_AWDCH1CH_Msk = 0x7c000000 // Bit mask of AWDCH1CH field.
	ADC_CFGR_JAUTO_Pos    = 0x19       // Position of JAUTO field.
	ADC_CFGR_JAUTO_Msk    = 0x2000000  // Bit mask of JAUTO field.
	ADC_CFGR_JAUTO        = 0x2000000  // Bit JAUTO.
	ADC_CFGR_JAWD1EN_Pos  = 0x18       // Position of JAWD1EN field.
	ADC_CFGR_JAWD1EN_Msk  = 0x1000000  // Bit mask of JAWD1EN field.
	ADC_CFGR_JAWD1EN      = 0x1000000  // Bit JAWD1EN.
	ADC_CFGR_AWD1EN_Pos   = 0x17       // Position of AWD1EN field.
	ADC_CFGR_AWD1EN_Msk   = 0x800000   // Bit mask of AWD1EN field.
	ADC_CFGR_AWD1EN       = 0x800000   // Bit AWD1EN.
	ADC_CFGR_AWD1SGL_Pos  = 0x16       // Position of AWD1SGL field.
	ADC_CFGR_AWD1SGL_Msk  = 0x400000   // Bit mask of AWD1SGL field.
	ADC_CFGR_AWD1SGL      = 0x400000   // Bit AWD1SGL.
	ADC_CFGR_JQM_Pos      = 0x15       // Position of JQM field.
	ADC_CFGR_JQM_Msk      = 0x200000   // Bit mask of JQM field.
	ADC_CFGR_JQM          = 0x200000   // Bit JQM.
	ADC_CFGR_JDISCEN_Pos  = 0x14       // Position of JDISCEN field.
	ADC_CFGR_JDISCEN_Msk  = 0x100000   // Bit mask of JDISCEN field.
	ADC_CFGR_JDISCEN      = 0x100000   // Bit JDISCEN.
	ADC_CFGR_DISCNUM_Pos  = 0x11       // Position of DISCNUM field.
	ADC_CFGR_DISCNUM_Msk  = 0xe0000    // Bit mask of DISCNUM field.
	ADC_CFGR_DISCEN_Pos   = 0x10       // Position of DISCEN field.
	ADC_CFGR_DISCEN_Msk   = 0x10000    // Bit mask of DISCEN field.
	ADC_CFGR_DISCEN       = 0x10000    // Bit DISCEN.
	ADC_CFGR_AUTOFF_Pos   = 0xf        // Position of AUTOFF field.
	ADC_CFGR_AUTOFF_Msk   = 0x8000     // Bit mask of AUTOFF field.
	ADC_CFGR_AUTOFF       = 0x8000     // Bit AUTOFF.
	ADC_CFGR_AUTDLY_Pos   = 0xe        // Position of AUTDLY field.
	ADC_CFGR_AUTDLY_Msk   = 0x4000     // Bit mask of AUTDLY field.
	ADC_CFGR_AUTDLY       = 0x4000     // Bit AUTDLY.
	ADC_CFGR_CONT_Pos     = 0xd        // Position of CONT field.
	ADC_CFGR_CONT_Msk     = 0x2000     // Bit mask of CONT field.
	ADC_CFGR_CONT         = 0x2000     // Bit CONT.
	ADC_CFGR_OVRMOD_Pos   = 0xc        // Position of OVRMOD field.
	ADC_CFGR_OVRMOD_Msk   = 0x1000     // Bit mask of OVRMOD field.
	ADC_CFGR_OVRMOD       = 0x1000     // Bit OVRMOD.
	ADC_CFGR_EXTEN_Pos    = 0xa        // Position of EXTEN field.
	ADC_CFGR_EXTEN_Msk    = 0xc00      // Bit mask of EXTEN field.
	ADC_CFGR_EXTSEL_Pos   = 0x6        // Position of EXTSEL field.
	ADC_CFGR_EXTSEL_Msk   = 0x3c0      // Bit mask of EXTSEL field.
	ADC_CFGR_ALIGN_Pos    = 0x5        // Position of ALIGN field.
	ADC_CFGR_ALIGN_Msk    = 0x20       // Bit mask of ALIGN field.
	ADC_CFGR_ALIGN        = 0x20       // Bit ALIGN.
	ADC_CFGR_RES_Pos      = 0x3        // Position of RES field.
	ADC_CFGR_RES_Msk      = 0x18       // Bit mask of RES field.
	ADC_CFGR_DMACFG_Pos   = 0x1        // Position of DMACFG field.
	ADC_CFGR_DMACFG_Msk   = 0x2        // Bit mask of DMACFG field.
	ADC_CFGR_DMACFG       = 0x2        // Bit DMACFG.
	ADC_CFGR_DMAEN_Pos    = 0x0        // Position of DMAEN field.
	ADC_CFGR_DMAEN_Msk    = 0x1        // Bit mask of DMAEN field.
	ADC_CFGR_DMAEN        = 0x1        // Bit DMAEN.

	// SMPR1: sample time register 1
	ADC_SMPR1_SMP9_Pos = 0x1b       // Position of SMP9 field.
	ADC_SMPR1_SMP9_Msk = 0x38000000 // Bit mask of SMP9 field.
	ADC_SMPR1_SMP8_Pos = 0x18       // Position of SMP8 field.
	ADC_SMPR1_SMP8_Msk = 0x7000000  // Bit mask of SMP8 field.
	ADC_SMPR1_SMP7_Pos = 0x15       // Position of SMP7 field.
	ADC_SMPR1_SMP7_Msk = 0xe00000   // Bit mask of SMP7 field.
	ADC_SMPR1_SMP6_Pos = 0x12       // Position of SMP6 field.
	ADC_SMPR1_SMP6_Msk = 0x1c0000   // Bit mask of SMP6 field.
	ADC_SMPR1_SMP5_Pos = 0xf        // Position of SMP5 field.
	ADC_SMPR1_SMP5_Msk = 0x38000    // Bit mask of SMP5 field.
	ADC_SMPR1_SMP4_Pos = 0xc        // Position of SMP4 field.
	ADC_SMPR1_SMP4_Msk = 0x7000     // Bit mask of SMP4 field.
	ADC_SMPR1_SMP3_Pos = 0x9        // Position of SMP3 field.
	ADC_SMPR1_SMP3_Msk = 0xe00      // Bit mask of SMP3 field.
	ADC_SMPR1_SMP2_Pos = 0x6        // Position of SMP2 field.
	ADC_SMPR1_SMP2_Msk = 0x1c0      // Bit mask of SMP2 field.
	ADC_SMPR1_SMP1_Pos = 0x3        // Position of SMP1 field.
	ADC_SMPR1_SMP1_Msk = 0x38       // Bit mask of SMP1 field.

	// SMPR2: sample time register 2
	ADC_SMPR2_SMP18_Pos = 0x18      // Position of SMP18 field.
	ADC_SMPR2_SMP18_Msk = 0x7000000 // Bit mask of SMP18 field.
	ADC_SMPR2_SMP17_Pos = 0x15      // Position of SMP17 field.
	ADC_SMPR2_SMP17_Msk = 0xe00000  // Bit mask of SMP17 field.
	ADC_SMPR2_SMP16_Pos = 0x12      // Position of SMP16 field.
	ADC_SMPR2_SMP16_Msk = 0x1c0000  // Bit mask of SMP16 field.
	ADC_SMPR2_SMP15_Pos = 0xf       // Position of SMP15 field.
	ADC_SMPR2_SMP15_Msk = 0x38000   // Bit mask of SMP15 field.
	ADC_SMPR2_SMP14_Pos = 0xc       // Position of SMP14 field.
	ADC_SMPR2_SMP14_Msk = 0x7000    // Bit mask of SMP14 field.
	ADC_SMPR2_SMP13_Pos = 0x9       // Position of SMP13 field.
	ADC_SMPR2_SMP13_Msk = 0xe00     // Bit mask of SMP13 field.
	ADC_SMPR2_SMP12_Pos = 0x6       // Position of SMP12 field.
	ADC_SMPR2_SMP12_Msk = 0x1c0     // Bit mask of SMP12 field.
	ADC_SMPR2_SMP11_Pos = 0x3       // Position of SMP11 field.
	ADC_SMPR2_SMP11_Msk = 0x38      // Bit mask of SMP11 field.
	ADC_SMPR2_SMP10_Pos = 0x0       // Position of SMP10 field.
	ADC_SMPR2_SMP10_Msk = 0x7       // Bit mask of SMP10 field.

	// TR1: watchdog threshold register 1
	ADC_TR1_HT1_Pos = 0x10      // Position of HT1 field.
	ADC_TR1_HT1_Msk = 0xfff0000 // Bit mask of HT1 field.
	ADC_TR1_LT1_Pos = 0x0       // Position of LT1 field.
	ADC_TR1_LT1_Msk = 0xfff     // Bit mask of LT1 field.

	// TR2: watchdog threshold register
	ADC_TR2_HT2_Pos = 0x10     // Position of HT2 field.
	ADC_TR2_HT2_Msk = 0xff0000 // Bit mask of HT2 field.
	ADC_TR2_LT2_Pos = 0x0      // Position of LT2 field.
	ADC_TR2_LT2_Msk = 0xff     // Bit mask of LT2 field.

	// TR3: watchdog threshold register 3
	ADC_TR3_HT3_Pos = 0x10     // Position of HT3 field.
	ADC_TR3_HT3_Msk = 0xff0000 // Bit mask of HT3 field.
	ADC_TR3_LT3_Pos = 0x0      // Position of LT3 field.
	ADC_TR3_LT3_Msk = 0xff     // Bit mask of LT3 field.

	// SQR1: regular sequence register 1
	ADC_SQR1_SQ4_Pos = 0x18       // Position of SQ4 field.
	ADC_SQR1_SQ4_Msk = 0x1f000000 // Bit mask of SQ4 field.
	ADC_SQR1_SQ3_Pos = 0x12       // Position of SQ3 field.
	ADC_SQR1_SQ3_Msk = 0x7c0000   // Bit mask of SQ3 field.
	ADC_SQR1_SQ2_Pos = 0xc        // Position of SQ2 field.
	ADC_SQR1_SQ2_Msk = 0x1f000    // Bit mask of SQ2 field.
	ADC_SQR1_SQ1_Pos = 0x6        // Position of SQ1 field.
	ADC_SQR1_SQ1_Msk = 0x7c0      // Bit mask of SQ1 field.
	ADC_SQR1_L3_Pos  = 0x0        // Position of L3 field.
	ADC_SQR1_L3_Msk  = 0xf        // Bit mask of L3 field.

	// SQR2: regular sequence register 2
	ADC_SQR2_SQ9_Pos = 0x18       // Position of SQ9 field.
	ADC_SQR2_SQ9_Msk = 0x1f000000 // Bit mask of SQ9 field.
	ADC_SQR2_SQ8_Pos = 0x12       // Position of SQ8 field.
	ADC_SQR2_SQ8_Msk = 0x7c0000   // Bit mask of SQ8 field.
	ADC_SQR2_SQ7_Pos = 0xc        // Position of SQ7 field.
	ADC_SQR2_SQ7_Msk = 0x1f000    // Bit mask of SQ7 field.
	ADC_SQR2_SQ6_Pos = 0x6        // Position of SQ6 field.
	ADC_SQR2_SQ6_Msk = 0x7c0      // Bit mask of SQ6 field.
	ADC_SQR2_SQ5_Pos = 0x0        // Position of SQ5 field.
	ADC_SQR2_SQ5_Msk = 0x1f       // Bit mask of SQ5 field.

	// SQR3: regular sequence register 3
	ADC_SQR3_SQ14_Pos = 0x18       // Position of SQ14 field.
	ADC_SQR3_SQ14_Msk = 0x1f000000 // Bit mask of SQ14 field.
	ADC_SQR3_SQ13_Pos = 0x12       // Position of SQ13 field.
	ADC_SQR3_SQ13_Msk = 0x7c0000   // Bit mask of SQ13 field.
	ADC_SQR3_SQ12_Pos = 0xc        // Position of SQ12 field.
	ADC_SQR3_SQ12_Msk = 0x1f000    // Bit mask of SQ12 field.
	ADC_SQR3_SQ11_Pos = 0x6        // Position of SQ11 field.
	ADC_SQR3_SQ11_Msk = 0x7c0      // Bit mask of SQ11 field.
	ADC_SQR3_SQ10_Pos = 0x0        // Position of SQ10 field.
	ADC_SQR3_SQ10_Msk = 0x1f       // Bit mask of SQ10 field.

	// SQR4: regular sequence register 4
	ADC_SQR4_SQ16_Pos = 0x6   // Position of SQ16 field.
	ADC_SQR4_SQ16_Msk = 0x7c0 // Bit mask of SQ16 field.
	ADC_SQR4_SQ15_Pos = 0x0   // Position of SQ15 field.
	ADC_SQR4_SQ15_Msk = 0x1f  // Bit mask of SQ15 field.

	// DR: regular Data Register
	ADC_DR_REGULARDATA_Pos = 0x0    // Position of REGULARDATA field.
	ADC_DR_REGULARDATA_Msk = 0xffff // Bit mask of REGULARDATA field.

	// JSQR: injected sequence register
	ADC_JSQR_JSQ4_Pos    = 0x1a       // Position of JSQ4 field.
	ADC_JSQR_JSQ4_Msk    = 0x7c000000 // Bit mask of JSQ4 field.
	ADC_JSQR_JSQ3_Pos    = 0x14       // Position of JSQ3 field.
	ADC_JSQR_JSQ3_Msk    = 0x1f00000  // Bit mask of JSQ3 field.
	ADC_JSQR_JSQ2_Pos    = 0xe        // Position of JSQ2 field.
	ADC_JSQR_JSQ2_Msk    = 0x7c000    // Bit mask of JSQ2 field.
	ADC_JSQR_JSQ1_Pos    = 0x8        // Position of JSQ1 field.
	ADC_JSQR_JSQ1_Msk    = 0x1f00     // Bit mask of JSQ1 field.
	ADC_JSQR_JEXTEN_Pos  = 0x6        // Position of JEXTEN field.
	ADC_JSQR_JEXTEN_Msk  = 0xc0       // Bit mask of JEXTEN field.
	ADC_JSQR_JEXTSEL_Pos = 0x2        // Position of JEXTSEL field.
	ADC_JSQR_JEXTSEL_Msk = 0x3c       // Bit mask of JEXTSEL field.
	ADC_JSQR_JL_Pos      = 0x0        // Position of JL field.
	ADC_JSQR_JL_Msk      = 0x3        // Bit mask of JL field.

	// OFR1: offset register 1
	ADC_OFR1_OFFSET1_EN_Pos = 0x1f       // Position of OFFSET1_EN field.
	ADC_OFR1_OFFSET1_EN_Msk = 0x80000000 // Bit mask of OFFSET1_EN field.
	ADC_OFR1_OFFSET1_EN     = 0x80000000 // Bit OFFSET1_EN.
	ADC_OFR1_OFFSET1_CH_Pos = 0x1a       // Position of OFFSET1_CH field.
	ADC_OFR1_OFFSET1_CH_Msk = 0x7c000000 // Bit mask of OFFSET1_CH field.
	ADC_OFR1_OFFSET1_Pos    = 0x0        // Position of OFFSET1 field.
	ADC_OFR1_OFFSET1_Msk    = 0xfff      // Bit mask of OFFSET1 field.

	// OFR2: offset register 2
	ADC_OFR2_OFFSET2_EN_Pos = 0x1f       // Position of OFFSET2_EN field.
	ADC_OFR2_OFFSET2_EN_Msk = 0x80000000 // Bit mask of OFFSET2_EN field.
	ADC_OFR2_OFFSET2_EN     = 0x80000000 // Bit OFFSET2_EN.
	ADC_OFR2_OFFSET2_CH_Pos = 0x1a       // Position of OFFSET2_CH field.
	ADC_OFR2_OFFSET2_CH_Msk = 0x7c000000 // Bit mask of OFFSET2_CH field.
	ADC_OFR2_OFFSET2_Pos    = 0x0        // Position of OFFSET2 field.
	ADC_OFR2_OFFSET2_Msk    = 0xfff      // Bit mask of OFFSET2 field.

	// OFR3: offset register 3
	ADC_OFR3_OFFSET3_EN_Pos = 0x1f       // Position of OFFSET3_EN field.
	ADC_OFR3_OFFSET3_EN_Msk = 0x80000000 // Bit mask of OFFSET3_EN field.
	ADC_OFR3_OFFSET3_EN     = 0x80000000 // Bit OFFSET3_EN.
	ADC_OFR3_OFFSET3_CH_Pos = 0x1a       // Position of OFFSET3_CH field.
	ADC_OFR3_OFFSET3_CH_Msk = 0x7c000000 // Bit mask of OFFSET3_CH field.
	ADC_OFR3_OFFSET3_Pos    = 0x0        // Position of OFFSET3 field.
	ADC_OFR3_OFFSET3_Msk    = 0xfff      // Bit mask of OFFSET3 field.

	// OFR4: offset register 4
	ADC_OFR4_OFFSET4_EN_Pos = 0x1f       // Position of OFFSET4_EN field.
	ADC_OFR4_OFFSET4_EN_Msk = 0x80000000 // Bit mask of OFFSET4_EN field.
	ADC_OFR4_OFFSET4_EN     = 0x80000000 // Bit OFFSET4_EN.
	ADC_OFR4_OFFSET4_CH_Pos = 0x1a       // Position of OFFSET4_CH field.
	ADC_OFR4_OFFSET4_CH_Msk = 0x7c000000 // Bit mask of OFFSET4_CH field.
	ADC_OFR4_OFFSET4_Pos    = 0x0        // Position of OFFSET4 field.
	ADC_OFR4_OFFSET4_Msk    = 0xfff      // Bit mask of OFFSET4 field.

	// JDR1: injected data register 1
	ADC_JDR1_JDATA1_Pos = 0x0    // Position of JDATA1 field.
	ADC_JDR1_JDATA1_Msk = 0xffff // Bit mask of JDATA1 field.

	// JDR2: injected data register 2
	ADC_JDR2_JDATA2_Pos = 0x0    // Position of JDATA2 field.
	ADC_JDR2_JDATA2_Msk = 0xffff // Bit mask of JDATA2 field.

	// JDR3: injected data register 3
	ADC_JDR3_JDATA3_Pos = 0x0    // Position of JDATA3 field.
	ADC_JDR3_JDATA3_Msk = 0xffff // Bit mask of JDATA3 field.

	// JDR4: injected data register 4
	ADC_JDR4_JDATA4_Pos = 0x0    // Position of JDATA4 field.
	ADC_JDR4_JDATA4_Msk = 0xffff // Bit mask of JDATA4 field.

	// AWD2CR: Analog Watchdog 2 Configuration           Register
	ADC_AWD2CR_AWD2CH_Pos = 0x1     // Position of AWD2CH field.
	ADC_AWD2CR_AWD2CH_Msk = 0x7fffe // Bit mask of AWD2CH field.

	// AWD3CR: Analog Watchdog 3 Configuration           Register
	ADC_AWD3CR_AWD3CH_Pos = 0x1     // Position of AWD3CH field.
	ADC_AWD3CR_AWD3CH_Msk = 0x7fffe // Bit mask of AWD3CH field.

	// DIFSEL: Differential Mode Selection Register           2
	ADC_DIFSEL_DIFSEL_1_15_Pos  = 0x1     // Position of DIFSEL_1_15 field.
	ADC_DIFSEL_DIFSEL_1_15_Msk  = 0xfffe  // Bit mask of DIFSEL_1_15 field.
	ADC_DIFSEL_DIFSEL_16_18_Pos = 0x10    // Position of DIFSEL_16_18 field.
	ADC_DIFSEL_DIFSEL_16_18_Msk = 0x70000 // Bit mask of DIFSEL_16_18 field.

	// CALFACT: Calibration Factors
	ADC_CALFACT_CALFACT_D_Pos = 0x10     // Position of CALFACT_D field.
	ADC_CALFACT_CALFACT_D_Msk = 0x7f0000 // Bit mask of CALFACT_D field.
	ADC_CALFACT_CALFACT_S_Pos = 0x0      // Position of CALFACT_S field.
	ADC_CALFACT_CALFACT_S_Msk = 0x7f     // Bit mask of CALFACT_S field.
)

// Bitfields for SYSCFG_COMP_OPAMP: System configuration controller _Comparator and Operational amplifier
const (
	// SYSCFG_CFGR1: configuration register 1
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_MEM_MODE_Pos          = 0x0        // Position of MEM_MODE field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_MEM_MODE_Msk          = 0x3        // Bit mask of MEM_MODE field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_USB_IT_RMP_Pos        = 0x5        // Position of USB_IT_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_USB_IT_RMP_Msk        = 0x20       // Bit mask of USB_IT_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_USB_IT_RMP            = 0x20       // Bit USB_IT_RMP.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM1_ITR_RMP_Pos      = 0x6        // Position of TIM1_ITR_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM1_ITR_RMP_Msk      = 0x40       // Bit mask of TIM1_ITR_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM1_ITR_RMP          = 0x40       // Bit TIM1_ITR_RMP.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_DAC_TRIG_RMP_Pos      = 0x7        // Position of DAC_TRIG_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_DAC_TRIG_RMP_Msk      = 0x80       // Bit mask of DAC_TRIG_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_DAC_TRIG_RMP          = 0x80       // Bit DAC_TRIG_RMP.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_ADC24_DMA_RMP_Pos     = 0x8        // Position of ADC24_DMA_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_ADC24_DMA_RMP_Msk     = 0x100      // Bit mask of ADC24_DMA_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_ADC24_DMA_RMP         = 0x100      // Bit ADC24_DMA_RMP.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM16_DMA_RMP_Pos     = 0xb        // Position of TIM16_DMA_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM16_DMA_RMP_Msk     = 0x800      // Bit mask of TIM16_DMA_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM16_DMA_RMP         = 0x800      // Bit TIM16_DMA_RMP.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM17_DMA_RMP_Pos     = 0xc        // Position of TIM17_DMA_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM17_DMA_RMP_Msk     = 0x1000     // Bit mask of TIM17_DMA_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM17_DMA_RMP         = 0x1000     // Bit TIM17_DMA_RMP.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM6_DAC1_DMA_RMP_Pos = 0xd        // Position of TIM6_DAC1_DMA_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM6_DAC1_DMA_RMP_Msk = 0x2000     // Bit mask of TIM6_DAC1_DMA_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM6_DAC1_DMA_RMP     = 0x2000     // Bit TIM6_DAC1_DMA_RMP.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM7_DAC2_DMA_RMP_Pos = 0xe        // Position of TIM7_DAC2_DMA_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM7_DAC2_DMA_RMP_Msk = 0x4000     // Bit mask of TIM7_DAC2_DMA_RMP field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_TIM7_DAC2_DMA_RMP     = 0x4000     // Bit TIM7_DAC2_DMA_RMP.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C_PB6_FM_Pos        = 0x10       // Position of I2C_PB6_FM field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C_PB6_FM_Msk        = 0x10000    // Bit mask of I2C_PB6_FM field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C_PB6_FM            = 0x10000    // Bit I2C_PB6_FM.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C_PB7_FM_Pos        = 0x11       // Position of I2C_PB7_FM field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C_PB7_FM_Msk        = 0x20000    // Bit mask of I2C_PB7_FM field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C_PB7_FM            = 0x20000    // Bit I2C_PB7_FM.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C_PB8_FM_Pos        = 0x12       // Position of I2C_PB8_FM field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C_PB8_FM_Msk        = 0x40000    // Bit mask of I2C_PB8_FM field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C_PB8_FM            = 0x40000    // Bit I2C_PB8_FM.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C_PB9_FM_Pos        = 0x13       // Position of I2C_PB9_FM field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C_PB9_FM_Msk        = 0x80000    // Bit mask of I2C_PB9_FM field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C_PB9_FM            = 0x80000    // Bit I2C_PB9_FM.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C1_FM_Pos           = 0x14       // Position of I2C1_FM field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C1_FM_Msk           = 0x100000   // Bit mask of I2C1_FM field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C1_FM               = 0x100000   // Bit I2C1_FM.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C2_FM_Pos           = 0x15       // Position of I2C2_FM field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C2_FM_Msk           = 0x200000   // Bit mask of I2C2_FM field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_I2C2_FM               = 0x200000   // Bit I2C2_FM.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_ENCODER_MODE_Pos      = 0x16       // Position of ENCODER_MODE field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_ENCODER_MODE_Msk      = 0xc00000   // Bit mask of ENCODER_MODE field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_FPU_IT_Pos            = 0x1a       // Position of FPU_IT field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR1_FPU_IT_Msk            = 0xfc000000 // Bit mask of FPU_IT field.

	// SYSCFG_RCR: CCM SRAM protection register
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE0_WP_Pos = 0x0  // Position of PAGE0_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE0_WP_Msk = 0x1  // Bit mask of PAGE0_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE0_WP     = 0x1  // Bit PAGE0_WP.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE1_WP_Pos = 0x1  // Position of PAGE1_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE1_WP_Msk = 0x2  // Bit mask of PAGE1_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE1_WP     = 0x2  // Bit PAGE1_WP.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE2_WP_Pos = 0x2  // Position of PAGE2_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE2_WP_Msk = 0x4  // Bit mask of PAGE2_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE2_WP     = 0x4  // Bit PAGE2_WP.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE3_WP_Pos = 0x3  // Position of PAGE3_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE3_WP_Msk = 0x8  // Bit mask of PAGE3_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE3_WP     = 0x8  // Bit PAGE3_WP.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE4_WP_Pos = 0x4  // Position of PAGE4_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE4_WP_Msk = 0x10 // Bit mask of PAGE4_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE4_WP     = 0x10 // Bit PAGE4_WP.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE5_WP_Pos = 0x5  // Position of PAGE5_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE5_WP_Msk = 0x20 // Bit mask of PAGE5_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE5_WP     = 0x20 // Bit PAGE5_WP.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE6_WP_Pos = 0x6  // Position of PAGE6_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE6_WP_Msk = 0x40 // Bit mask of PAGE6_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE6_WP     = 0x40 // Bit PAGE6_WP.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE7_WP_Pos = 0x7  // Position of PAGE7_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE7_WP_Msk = 0x80 // Bit mask of PAGE7_WP field.
	SYSCFG_COMP_OPAMP_SYSCFG_RCR_PAGE7_WP     = 0x80 // Bit PAGE7_WP.

	// SYSCFG_EXTICR1: external interrupt configuration register           1
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR1_EXTI3_Pos = 0xc    // Position of EXTI3 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR1_EXTI3_Msk = 0xf000 // Bit mask of EXTI3 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR1_EXTI2_Pos = 0x8    // Position of EXTI2 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR1_EXTI2_Msk = 0xf00  // Bit mask of EXTI2 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR1_EXTI1_Pos = 0x4    // Position of EXTI1 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR1_EXTI1_Msk = 0xf0   // Bit mask of EXTI1 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR1_EXTI0_Pos = 0x0    // Position of EXTI0 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR1_EXTI0_Msk = 0xf    // Bit mask of EXTI0 field.

	// SYSCFG_EXTICR2: external interrupt configuration register           2
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR2_EXTI7_Pos = 0xc    // Position of EXTI7 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR2_EXTI7_Msk = 0xf000 // Bit mask of EXTI7 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR2_EXTI6_Pos = 0x8    // Position of EXTI6 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR2_EXTI6_Msk = 0xf00  // Bit mask of EXTI6 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR2_EXTI5_Pos = 0x4    // Position of EXTI5 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR2_EXTI5_Msk = 0xf0   // Bit mask of EXTI5 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR2_EXTI4_Pos = 0x0    // Position of EXTI4 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR2_EXTI4_Msk = 0xf    // Bit mask of EXTI4 field.

	// SYSCFG_EXTICR3: external interrupt configuration register           3
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR3_EXTI11_Pos = 0xc    // Position of EXTI11 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR3_EXTI11_Msk = 0xf000 // Bit mask of EXTI11 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR3_EXTI10_Pos = 0x8    // Position of EXTI10 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR3_EXTI10_Msk = 0xf00  // Bit mask of EXTI10 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR3_EXTI9_Pos  = 0x4    // Position of EXTI9 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR3_EXTI9_Msk  = 0xf0   // Bit mask of EXTI9 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR3_EXTI8_Pos  = 0x0    // Position of EXTI8 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR3_EXTI8_Msk  = 0xf    // Bit mask of EXTI8 field.

	// SYSCFG_EXTICR4: external interrupt configuration register           4
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR4_EXTI15_Pos = 0xc    // Position of EXTI15 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR4_EXTI15_Msk = 0xf000 // Bit mask of EXTI15 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR4_EXTI14_Pos = 0x8    // Position of EXTI14 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR4_EXTI14_Msk = 0xf00  // Bit mask of EXTI14 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR4_EXTI13_Pos = 0x4    // Position of EXTI13 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR4_EXTI13_Msk = 0xf0   // Bit mask of EXTI13 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR4_EXTI12_Pos = 0x0    // Position of EXTI12 field.
	SYSCFG_COMP_OPAMP_SYSCFG_EXTICR4_EXTI12_Msk = 0xf    // Bit mask of EXTI12 field.

	// SYSCFG_CFGR2: configuration register 2
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_LOCUP_LOCK_Pos       = 0x0   // Position of LOCUP_LOCK field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_LOCUP_LOCK_Msk       = 0x1   // Bit mask of LOCUP_LOCK field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_LOCUP_LOCK           = 0x1   // Bit LOCUP_LOCK.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_SRAM_PARITY_LOCK_Pos = 0x1   // Position of SRAM_PARITY_LOCK field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_SRAM_PARITY_LOCK_Msk = 0x2   // Bit mask of SRAM_PARITY_LOCK field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_SRAM_PARITY_LOCK     = 0x2   // Bit SRAM_PARITY_LOCK.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_PVD_LOCK_Pos         = 0x2   // Position of PVD_LOCK field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_PVD_LOCK_Msk         = 0x4   // Bit mask of PVD_LOCK field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_PVD_LOCK             = 0x4   // Bit PVD_LOCK.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_BYP_ADD_PAR_Pos      = 0x4   // Position of BYP_ADD_PAR field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_BYP_ADD_PAR_Msk      = 0x10  // Bit mask of BYP_ADD_PAR field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_BYP_ADD_PAR          = 0x10  // Bit BYP_ADD_PAR.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_SRAM_PEF_Pos         = 0x8   // Position of SRAM_PEF field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_SRAM_PEF_Msk         = 0x100 // Bit mask of SRAM_PEF field.
	SYSCFG_COMP_OPAMP_SYSCFG_CFGR2_SRAM_PEF             = 0x100 // Bit SRAM_PEF.

	// COMP1_CSR: control and status register
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1EN_Pos        = 0x0        // Position of COMP1EN field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1EN_Msk        = 0x1        // Bit mask of COMP1EN field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1EN            = 0x1        // Bit COMP1EN.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1_INP_DAC_Pos  = 0x1        // Position of COMP1_INP_DAC field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1_INP_DAC_Msk  = 0x2        // Bit mask of COMP1_INP_DAC field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1_INP_DAC      = 0x2        // Bit COMP1_INP_DAC.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1MODE_Pos      = 0x2        // Position of COMP1MODE field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1MODE_Msk      = 0xc        // Bit mask of COMP1MODE field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1INSEL_Pos     = 0x4        // Position of COMP1INSEL field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1INSEL_Msk     = 0x70       // Bit mask of COMP1INSEL field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1_OUT_SEL_Pos  = 0xa        // Position of COMP1_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1_OUT_SEL_Msk  = 0x3c00     // Bit mask of COMP1_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1POL_Pos       = 0xf        // Position of COMP1POL field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1POL_Msk       = 0x8000     // Bit mask of COMP1POL field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1POL           = 0x8000     // Bit COMP1POL.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1HYST_Pos      = 0x10       // Position of COMP1HYST field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1HYST_Msk      = 0x30000    // Bit mask of COMP1HYST field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1_BLANKING_Pos = 0x12       // Position of COMP1_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1_BLANKING_Msk = 0x1c0000   // Bit mask of COMP1_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1OUT_Pos       = 0x1e       // Position of COMP1OUT field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1OUT_Msk       = 0x40000000 // Bit mask of COMP1OUT field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1OUT           = 0x40000000 // Bit COMP1OUT.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1LOCK_Pos      = 0x1f       // Position of COMP1LOCK field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1LOCK_Msk      = 0x80000000 // Bit mask of COMP1LOCK field.
	SYSCFG_COMP_OPAMP_COMP1_CSR_COMP1LOCK          = 0x80000000 // Bit COMP1LOCK.

	// COMP2_CSR: control and status register
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2EN_Pos        = 0x0        // Position of COMP2EN field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2EN_Msk        = 0x1        // Bit mask of COMP2EN field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2EN            = 0x1        // Bit COMP2EN.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2MODE_Pos      = 0x2        // Position of COMP2MODE field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2MODE_Msk      = 0xc        // Bit mask of COMP2MODE field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2INSEL_Pos     = 0x4        // Position of COMP2INSEL field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2INSEL_Msk     = 0x70       // Bit mask of COMP2INSEL field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2INPSEL_Pos    = 0x7        // Position of COMP2INPSEL field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2INPSEL_Msk    = 0x80       // Bit mask of COMP2INPSEL field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2INPSEL        = 0x80       // Bit COMP2INPSEL.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2INMSEL_Pos    = 0x9        // Position of COMP2INMSEL field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2INMSEL_Msk    = 0x200      // Bit mask of COMP2INMSEL field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2INMSEL        = 0x200      // Bit COMP2INMSEL.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2_OUT_SEL_Pos  = 0xa        // Position of COMP2_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2_OUT_SEL_Msk  = 0x3c00     // Bit mask of COMP2_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2POL_Pos       = 0xf        // Position of COMP2POL field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2POL_Msk       = 0x8000     // Bit mask of COMP2POL field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2POL           = 0x8000     // Bit COMP2POL.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2HYST_Pos      = 0x10       // Position of COMP2HYST field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2HYST_Msk      = 0x30000    // Bit mask of COMP2HYST field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2_BLANKING_Pos = 0x12       // Position of COMP2_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2_BLANKING_Msk = 0x1c0000   // Bit mask of COMP2_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2LOCK_Pos      = 0x1f       // Position of COMP2LOCK field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2LOCK_Msk      = 0x80000000 // Bit mask of COMP2LOCK field.
	SYSCFG_COMP_OPAMP_COMP2_CSR_COMP2LOCK          = 0x80000000 // Bit COMP2LOCK.

	// COMP3_CSR: control and status register
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3EN_Pos        = 0x0        // Position of COMP3EN field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3EN_Msk        = 0x1        // Bit mask of COMP3EN field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3EN            = 0x1        // Bit COMP3EN.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3MODE_Pos      = 0x2        // Position of COMP3MODE field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3MODE_Msk      = 0xc        // Bit mask of COMP3MODE field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3INSEL_Pos     = 0x4        // Position of COMP3INSEL field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3INSEL_Msk     = 0x70       // Bit mask of COMP3INSEL field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3INPSEL_Pos    = 0x7        // Position of COMP3INPSEL field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3INPSEL_Msk    = 0x80       // Bit mask of COMP3INPSEL field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3INPSEL        = 0x80       // Bit COMP3INPSEL.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3_OUT_SEL_Pos  = 0xa        // Position of COMP3_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3_OUT_SEL_Msk  = 0x3c00     // Bit mask of COMP3_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3POL_Pos       = 0xf        // Position of COMP3POL field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3POL_Msk       = 0x8000     // Bit mask of COMP3POL field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3POL           = 0x8000     // Bit COMP3POL.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3HYST_Pos      = 0x10       // Position of COMP3HYST field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3HYST_Msk      = 0x30000    // Bit mask of COMP3HYST field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3_BLANKING_Pos = 0x12       // Position of COMP3_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3_BLANKING_Msk = 0x1c0000   // Bit mask of COMP3_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3OUT_Pos       = 0x1e       // Position of COMP3OUT field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3OUT_Msk       = 0x40000000 // Bit mask of COMP3OUT field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3OUT           = 0x40000000 // Bit COMP3OUT.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3LOCK_Pos      = 0x1f       // Position of COMP3LOCK field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3LOCK_Msk      = 0x80000000 // Bit mask of COMP3LOCK field.
	SYSCFG_COMP_OPAMP_COMP3_CSR_COMP3LOCK          = 0x80000000 // Bit COMP3LOCK.

	// COMP4_CSR: control and status register
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4EN_Pos        = 0x0        // Position of COMP4EN field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4EN_Msk        = 0x1        // Bit mask of COMP4EN field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4EN            = 0x1        // Bit COMP4EN.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4MODE_Pos      = 0x2        // Position of COMP4MODE field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4MODE_Msk      = 0xc        // Bit mask of COMP4MODE field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4INSEL_Pos     = 0x4        // Position of COMP4INSEL field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4INSEL_Msk     = 0x70       // Bit mask of COMP4INSEL field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4INPSEL_Pos    = 0x7        // Position of COMP4INPSEL field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4INPSEL_Msk    = 0x80       // Bit mask of COMP4INPSEL field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4INPSEL        = 0x80       // Bit COMP4INPSEL.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COM4WINMODE_Pos    = 0x9        // Position of COM4WINMODE field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COM4WINMODE_Msk    = 0x200      // Bit mask of COM4WINMODE field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COM4WINMODE        = 0x200      // Bit COM4WINMODE.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4_OUT_SEL_Pos  = 0xa        // Position of COMP4_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4_OUT_SEL_Msk  = 0x3c00     // Bit mask of COMP4_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4POL_Pos       = 0xf        // Position of COMP4POL field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4POL_Msk       = 0x8000     // Bit mask of COMP4POL field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4POL           = 0x8000     // Bit COMP4POL.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4HYST_Pos      = 0x10       // Position of COMP4HYST field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4HYST_Msk      = 0x30000    // Bit mask of COMP4HYST field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4_BLANKING_Pos = 0x12       // Position of COMP4_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4_BLANKING_Msk = 0x1c0000   // Bit mask of COMP4_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4OUT_Pos       = 0x1e       // Position of COMP4OUT field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4OUT_Msk       = 0x40000000 // Bit mask of COMP4OUT field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4OUT           = 0x40000000 // Bit COMP4OUT.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4LOCK_Pos      = 0x1f       // Position of COMP4LOCK field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4LOCK_Msk      = 0x80000000 // Bit mask of COMP4LOCK field.
	SYSCFG_COMP_OPAMP_COMP4_CSR_COMP4LOCK          = 0x80000000 // Bit COMP4LOCK.

	// COMP5_CSR: control and status register
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5EN_Pos        = 0x0        // Position of COMP5EN field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5EN_Msk        = 0x1        // Bit mask of COMP5EN field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5EN            = 0x1        // Bit COMP5EN.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5MODE_Pos      = 0x2        // Position of COMP5MODE field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5MODE_Msk      = 0xc        // Bit mask of COMP5MODE field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5INSEL_Pos     = 0x4        // Position of COMP5INSEL field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5INSEL_Msk     = 0x70       // Bit mask of COMP5INSEL field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5INPSEL_Pos    = 0x7        // Position of COMP5INPSEL field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5INPSEL_Msk    = 0x80       // Bit mask of COMP5INPSEL field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5INPSEL        = 0x80       // Bit COMP5INPSEL.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5_OUT_SEL_Pos  = 0xa        // Position of COMP5_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5_OUT_SEL_Msk  = 0x3c00     // Bit mask of COMP5_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5POL_Pos       = 0xf        // Position of COMP5POL field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5POL_Msk       = 0x8000     // Bit mask of COMP5POL field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5POL           = 0x8000     // Bit COMP5POL.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5HYST_Pos      = 0x10       // Position of COMP5HYST field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5HYST_Msk      = 0x30000    // Bit mask of COMP5HYST field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5_BLANKING_Pos = 0x12       // Position of COMP5_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5_BLANKING_Msk = 0x1c0000   // Bit mask of COMP5_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5OUT_Pos       = 0x1e       // Position of COMP5OUT field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5OUT_Msk       = 0x40000000 // Bit mask of COMP5OUT field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5OUT           = 0x40000000 // Bit COMP5OUT.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5LOCK_Pos      = 0x1f       // Position of COMP5LOCK field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5LOCK_Msk      = 0x80000000 // Bit mask of COMP5LOCK field.
	SYSCFG_COMP_OPAMP_COMP5_CSR_COMP5LOCK          = 0x80000000 // Bit COMP5LOCK.

	// COMP6_CSR: control and status register
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6EN_Pos        = 0x0        // Position of COMP6EN field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6EN_Msk        = 0x1        // Bit mask of COMP6EN field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6EN            = 0x1        // Bit COMP6EN.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6MODE_Pos      = 0x2        // Position of COMP6MODE field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6MODE_Msk      = 0xc        // Bit mask of COMP6MODE field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6INSEL_Pos     = 0x4        // Position of COMP6INSEL field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6INSEL_Msk     = 0x70       // Bit mask of COMP6INSEL field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6INPSEL_Pos    = 0x7        // Position of COMP6INPSEL field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6INPSEL_Msk    = 0x80       // Bit mask of COMP6INPSEL field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6INPSEL        = 0x80       // Bit COMP6INPSEL.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COM6WINMODE_Pos    = 0x9        // Position of COM6WINMODE field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COM6WINMODE_Msk    = 0x200      // Bit mask of COM6WINMODE field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COM6WINMODE        = 0x200      // Bit COM6WINMODE.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6_OUT_SEL_Pos  = 0xa        // Position of COMP6_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6_OUT_SEL_Msk  = 0x3c00     // Bit mask of COMP6_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6POL_Pos       = 0xf        // Position of COMP6POL field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6POL_Msk       = 0x8000     // Bit mask of COMP6POL field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6POL           = 0x8000     // Bit COMP6POL.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6HYST_Pos      = 0x10       // Position of COMP6HYST field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6HYST_Msk      = 0x30000    // Bit mask of COMP6HYST field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6_BLANKING_Pos = 0x12       // Position of COMP6_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6_BLANKING_Msk = 0x1c0000   // Bit mask of COMP6_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6OUT_Pos       = 0x1e       // Position of COMP6OUT field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6OUT_Msk       = 0x40000000 // Bit mask of COMP6OUT field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6OUT           = 0x40000000 // Bit COMP6OUT.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6LOCK_Pos      = 0x1f       // Position of COMP6LOCK field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6LOCK_Msk      = 0x80000000 // Bit mask of COMP6LOCK field.
	SYSCFG_COMP_OPAMP_COMP6_CSR_COMP6LOCK          = 0x80000000 // Bit COMP6LOCK.

	// COMP7_CSR: control and status register
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7EN_Pos        = 0x0        // Position of COMP7EN field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7EN_Msk        = 0x1        // Bit mask of COMP7EN field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7EN            = 0x1        // Bit COMP7EN.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7MODE_Pos      = 0x2        // Position of COMP7MODE field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7MODE_Msk      = 0xc        // Bit mask of COMP7MODE field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7INSEL_Pos     = 0x4        // Position of COMP7INSEL field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7INSEL_Msk     = 0x70       // Bit mask of COMP7INSEL field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7INPSEL_Pos    = 0x7        // Position of COMP7INPSEL field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7INPSEL_Msk    = 0x80       // Bit mask of COMP7INPSEL field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7INPSEL        = 0x80       // Bit COMP7INPSEL.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7_OUT_SEL_Pos  = 0xa        // Position of COMP7_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7_OUT_SEL_Msk  = 0x3c00     // Bit mask of COMP7_OUT_SEL field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7POL_Pos       = 0xf        // Position of COMP7POL field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7POL_Msk       = 0x8000     // Bit mask of COMP7POL field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7POL           = 0x8000     // Bit COMP7POL.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7HYST_Pos      = 0x10       // Position of COMP7HYST field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7HYST_Msk      = 0x30000    // Bit mask of COMP7HYST field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7_BLANKING_Pos = 0x12       // Position of COMP7_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7_BLANKING_Msk = 0x1c0000   // Bit mask of COMP7_BLANKING field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7OUT_Pos       = 0x1e       // Position of COMP7OUT field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7OUT_Msk       = 0x40000000 // Bit mask of COMP7OUT field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7OUT           = 0x40000000 // Bit COMP7OUT.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7LOCK_Pos      = 0x1f       // Position of COMP7LOCK field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7LOCK_Msk      = 0x80000000 // Bit mask of COMP7LOCK field.
	SYSCFG_COMP_OPAMP_COMP7_CSR_COMP7LOCK          = 0x80000000 // Bit COMP7LOCK.

	// OPAMP1_CSR: control register
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_OPAMP1_EN_Pos   = 0x0        // Position of OPAMP1_EN field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_OPAMP1_EN_Msk   = 0x1        // Bit mask of OPAMP1_EN field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_OPAMP1_EN       = 0x1        // Bit OPAMP1_EN.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_FORCE_VP_Pos    = 0x1        // Position of FORCE_VP field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_FORCE_VP_Msk    = 0x2        // Bit mask of FORCE_VP field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_FORCE_VP        = 0x2        // Bit FORCE_VP.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_VP_SEL_Pos      = 0x2        // Position of VP_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_VP_SEL_Msk      = 0xc        // Bit mask of VP_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_VM_SEL_Pos      = 0x5        // Position of VM_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_VM_SEL_Msk      = 0x60       // Bit mask of VM_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_TCM_EN_Pos      = 0x7        // Position of TCM_EN field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_TCM_EN_Msk      = 0x80       // Bit mask of TCM_EN field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_TCM_EN          = 0x80       // Bit TCM_EN.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_VMS_SEL_Pos     = 0x8        // Position of VMS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_VMS_SEL_Msk     = 0x100      // Bit mask of VMS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_VMS_SEL         = 0x100      // Bit VMS_SEL.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_VPS_SEL_Pos     = 0x9        // Position of VPS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_VPS_SEL_Msk     = 0x600      // Bit mask of VPS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_CALON_Pos       = 0xb        // Position of CALON field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_CALON_Msk       = 0x800      // Bit mask of CALON field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_CALON           = 0x800      // Bit CALON.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_CALSEL_Pos      = 0xc        // Position of CALSEL field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_CALSEL_Msk      = 0x3000     // Bit mask of CALSEL field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_PGA_GAIN_Pos    = 0xe        // Position of PGA_GAIN field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_PGA_GAIN_Msk    = 0x3c000    // Bit mask of PGA_GAIN field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_USER_TRIM_Pos   = 0x12       // Position of USER_TRIM field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_USER_TRIM_Msk   = 0x40000    // Bit mask of USER_TRIM field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_USER_TRIM       = 0x40000    // Bit USER_TRIM.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_TRIMOFFSETP_Pos = 0x13       // Position of TRIMOFFSETP field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_TRIMOFFSETP_Msk = 0xf80000   // Bit mask of TRIMOFFSETP field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_TRIMOFFSETN_Pos = 0x18       // Position of TRIMOFFSETN field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_TRIMOFFSETN_Msk = 0x1f000000 // Bit mask of TRIMOFFSETN field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_TSTREF_Pos      = 0x1d       // Position of TSTREF field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_TSTREF_Msk      = 0x20000000 // Bit mask of TSTREF field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_TSTREF          = 0x20000000 // Bit TSTREF.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_OUTCAL_Pos      = 0x1e       // Position of OUTCAL field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_OUTCAL_Msk      = 0x40000000 // Bit mask of OUTCAL field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_OUTCAL          = 0x40000000 // Bit OUTCAL.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_LOCK_Pos        = 0x1f       // Position of LOCK field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_LOCK_Msk        = 0x80000000 // Bit mask of LOCK field.
	SYSCFG_COMP_OPAMP_OPAMP1_CSR_LOCK            = 0x80000000 // Bit LOCK.

	// OPAMP2_CSR: control register
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_OPAMP2EN_Pos    = 0x0        // Position of OPAMP2EN field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_OPAMP2EN_Msk    = 0x1        // Bit mask of OPAMP2EN field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_OPAMP2EN        = 0x1        // Bit OPAMP2EN.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_FORCE_VP_Pos    = 0x1        // Position of FORCE_VP field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_FORCE_VP_Msk    = 0x2        // Bit mask of FORCE_VP field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_FORCE_VP        = 0x2        // Bit FORCE_VP.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_VP_SEL_Pos      = 0x2        // Position of VP_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_VP_SEL_Msk      = 0xc        // Bit mask of VP_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_VM_SEL_Pos      = 0x5        // Position of VM_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_VM_SEL_Msk      = 0x60       // Bit mask of VM_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_TCM_EN_Pos      = 0x7        // Position of TCM_EN field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_TCM_EN_Msk      = 0x80       // Bit mask of TCM_EN field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_TCM_EN          = 0x80       // Bit TCM_EN.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_VMS_SEL_Pos     = 0x8        // Position of VMS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_VMS_SEL_Msk     = 0x100      // Bit mask of VMS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_VMS_SEL         = 0x100      // Bit VMS_SEL.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_VPS_SEL_Pos     = 0x9        // Position of VPS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_VPS_SEL_Msk     = 0x600      // Bit mask of VPS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_CALON_Pos       = 0xb        // Position of CALON field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_CALON_Msk       = 0x800      // Bit mask of CALON field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_CALON           = 0x800      // Bit CALON.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_CAL_SEL_Pos     = 0xc        // Position of CAL_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_CAL_SEL_Msk     = 0x3000     // Bit mask of CAL_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_PGA_GAIN_Pos    = 0xe        // Position of PGA_GAIN field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_PGA_GAIN_Msk    = 0x3c000    // Bit mask of PGA_GAIN field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_USER_TRIM_Pos   = 0x12       // Position of USER_TRIM field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_USER_TRIM_Msk   = 0x40000    // Bit mask of USER_TRIM field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_USER_TRIM       = 0x40000    // Bit USER_TRIM.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_TRIMOFFSETP_Pos = 0x13       // Position of TRIMOFFSETP field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_TRIMOFFSETP_Msk = 0xf80000   // Bit mask of TRIMOFFSETP field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_TRIMOFFSETN_Pos = 0x18       // Position of TRIMOFFSETN field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_TRIMOFFSETN_Msk = 0x1f000000 // Bit mask of TRIMOFFSETN field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_TSTREF_Pos      = 0x1d       // Position of TSTREF field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_TSTREF_Msk      = 0x20000000 // Bit mask of TSTREF field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_TSTREF          = 0x20000000 // Bit TSTREF.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_OUTCAL_Pos      = 0x1e       // Position of OUTCAL field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_OUTCAL_Msk      = 0x40000000 // Bit mask of OUTCAL field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_OUTCAL          = 0x40000000 // Bit OUTCAL.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_LOCK_Pos        = 0x1f       // Position of LOCK field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_LOCK_Msk        = 0x80000000 // Bit mask of LOCK field.
	SYSCFG_COMP_OPAMP_OPAMP2_CSR_LOCK            = 0x80000000 // Bit LOCK.

	// OPAMP3_CSR: control register
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_OPAMP3EN_Pos    = 0x0        // Position of OPAMP3EN field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_OPAMP3EN_Msk    = 0x1        // Bit mask of OPAMP3EN field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_OPAMP3EN        = 0x1        // Bit OPAMP3EN.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_FORCE_VP_Pos    = 0x1        // Position of FORCE_VP field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_FORCE_VP_Msk    = 0x2        // Bit mask of FORCE_VP field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_FORCE_VP        = 0x2        // Bit FORCE_VP.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_VP_SEL_Pos      = 0x2        // Position of VP_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_VP_SEL_Msk      = 0xc        // Bit mask of VP_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_VM_SEL_Pos      = 0x5        // Position of VM_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_VM_SEL_Msk      = 0x60       // Bit mask of VM_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_TCM_EN_Pos      = 0x7        // Position of TCM_EN field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_TCM_EN_Msk      = 0x80       // Bit mask of TCM_EN field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_TCM_EN          = 0x80       // Bit TCM_EN.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_VMS_SEL_Pos     = 0x8        // Position of VMS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_VMS_SEL_Msk     = 0x100      // Bit mask of VMS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_VMS_SEL         = 0x100      // Bit VMS_SEL.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_VPS_SEL_Pos     = 0x9        // Position of VPS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_VPS_SEL_Msk     = 0x600      // Bit mask of VPS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_CALON_Pos       = 0xb        // Position of CALON field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_CALON_Msk       = 0x800      // Bit mask of CALON field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_CALON           = 0x800      // Bit CALON.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_CALSEL_Pos      = 0xc        // Position of CALSEL field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_CALSEL_Msk      = 0x3000     // Bit mask of CALSEL field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_PGA_GAIN_Pos    = 0xe        // Position of PGA_GAIN field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_PGA_GAIN_Msk    = 0x3c000    // Bit mask of PGA_GAIN field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_USER_TRIM_Pos   = 0x12       // Position of USER_TRIM field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_USER_TRIM_Msk   = 0x40000    // Bit mask of USER_TRIM field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_USER_TRIM       = 0x40000    // Bit USER_TRIM.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_TRIMOFFSETP_Pos = 0x13       // Position of TRIMOFFSETP field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_TRIMOFFSETP_Msk = 0xf80000   // Bit mask of TRIMOFFSETP field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_TRIMOFFSETN_Pos = 0x18       // Position of TRIMOFFSETN field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_TRIMOFFSETN_Msk = 0x1f000000 // Bit mask of TRIMOFFSETN field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_TSTREF_Pos      = 0x1d       // Position of TSTREF field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_TSTREF_Msk      = 0x20000000 // Bit mask of TSTREF field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_TSTREF          = 0x20000000 // Bit TSTREF.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_OUTCAL_Pos      = 0x1e       // Position of OUTCAL field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_OUTCAL_Msk      = 0x40000000 // Bit mask of OUTCAL field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_OUTCAL          = 0x40000000 // Bit OUTCAL.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_LOCK_Pos        = 0x1f       // Position of LOCK field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_LOCK_Msk        = 0x80000000 // Bit mask of LOCK field.
	SYSCFG_COMP_OPAMP_OPAMP3_CSR_LOCK            = 0x80000000 // Bit LOCK.

	// OPAMP4_CSR: control register
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_OPAMP4EN_Pos    = 0x0        // Position of OPAMP4EN field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_OPAMP4EN_Msk    = 0x1        // Bit mask of OPAMP4EN field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_OPAMP4EN        = 0x1        // Bit OPAMP4EN.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_FORCE_VP_Pos    = 0x1        // Position of FORCE_VP field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_FORCE_VP_Msk    = 0x2        // Bit mask of FORCE_VP field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_FORCE_VP        = 0x2        // Bit FORCE_VP.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_VP_SEL_Pos      = 0x2        // Position of VP_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_VP_SEL_Msk      = 0xc        // Bit mask of VP_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_VM_SEL_Pos      = 0x5        // Position of VM_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_VM_SEL_Msk      = 0x60       // Bit mask of VM_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_TCM_EN_Pos      = 0x7        // Position of TCM_EN field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_TCM_EN_Msk      = 0x80       // Bit mask of TCM_EN field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_TCM_EN          = 0x80       // Bit TCM_EN.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_VMS_SEL_Pos     = 0x8        // Position of VMS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_VMS_SEL_Msk     = 0x100      // Bit mask of VMS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_VMS_SEL         = 0x100      // Bit VMS_SEL.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_VPS_SEL_Pos     = 0x9        // Position of VPS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_VPS_SEL_Msk     = 0x600      // Bit mask of VPS_SEL field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_CALON_Pos       = 0xb        // Position of CALON field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_CALON_Msk       = 0x800      // Bit mask of CALON field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_CALON           = 0x800      // Bit CALON.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_CALSEL_Pos      = 0xc        // Position of CALSEL field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_CALSEL_Msk      = 0x3000     // Bit mask of CALSEL field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_PGA_GAIN_Pos    = 0xe        // Position of PGA_GAIN field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_PGA_GAIN_Msk    = 0x3c000    // Bit mask of PGA_GAIN field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_USER_TRIM_Pos   = 0x12       // Position of USER_TRIM field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_USER_TRIM_Msk   = 0x40000    // Bit mask of USER_TRIM field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_USER_TRIM       = 0x40000    // Bit USER_TRIM.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_TRIMOFFSETP_Pos = 0x13       // Position of TRIMOFFSETP field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_TRIMOFFSETP_Msk = 0xf80000   // Bit mask of TRIMOFFSETP field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_TRIMOFFSETN_Pos = 0x18       // Position of TRIMOFFSETN field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_TRIMOFFSETN_Msk = 0x1f000000 // Bit mask of TRIMOFFSETN field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_TSTREF_Pos      = 0x1d       // Position of TSTREF field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_TSTREF_Msk      = 0x20000000 // Bit mask of TSTREF field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_TSTREF          = 0x20000000 // Bit TSTREF.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_OUTCAL_Pos      = 0x1e       // Position of OUTCAL field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_OUTCAL_Msk      = 0x40000000 // Bit mask of OUTCAL field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_OUTCAL          = 0x40000000 // Bit OUTCAL.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_LOCK_Pos        = 0x1f       // Position of LOCK field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_LOCK_Msk        = 0x80000000 // Bit mask of LOCK field.
	SYSCFG_COMP_OPAMP_OPAMP4_CSR_LOCK            = 0x80000000 // Bit LOCK.
)

// Bitfields for FMC: Flexible memory controller
const (
	// BCR1: SRAM/NOR-Flash chip-select control register           1
	FMC_BCR1_CCLKEN_Pos    = 0x14     // Position of CCLKEN field.
	FMC_BCR1_CCLKEN_Msk    = 0x100000 // Bit mask of CCLKEN field.
	FMC_BCR1_CCLKEN        = 0x100000 // Bit CCLKEN.
	FMC_BCR1_CBURSTRW_Pos  = 0x13     // Position of CBURSTRW field.
	FMC_BCR1_CBURSTRW_Msk  = 0x80000  // Bit mask of CBURSTRW field.
	FMC_BCR1_CBURSTRW      = 0x80000  // Bit CBURSTRW.
	FMC_BCR1_ASYNCWAIT_Pos = 0xf      // Position of ASYNCWAIT field.
	FMC_BCR1_ASYNCWAIT_Msk = 0x8000   // Bit mask of ASYNCWAIT field.
	FMC_BCR1_ASYNCWAIT     = 0x8000   // Bit ASYNCWAIT.
	FMC_BCR1_EXTMOD_Pos    = 0xe      // Position of EXTMOD field.
	FMC_BCR1_EXTMOD_Msk    = 0x4000   // Bit mask of EXTMOD field.
	FMC_BCR1_EXTMOD        = 0x4000   // Bit EXTMOD.
	FMC_BCR1_WAITEN_Pos    = 0xd      // Position of WAITEN field.
	FMC_BCR1_WAITEN_Msk    = 0x2000   // Bit mask of WAITEN field.
	FMC_BCR1_WAITEN        = 0x2000   // Bit WAITEN.
	FMC_BCR1_WREN_Pos      = 0xc      // Position of WREN field.
	FMC_BCR1_WREN_Msk      = 0x1000   // Bit mask of WREN field.
	FMC_BCR1_WREN          = 0x1000   // Bit WREN.
	FMC_BCR1_WAITCFG_Pos   = 0xb      // Position of WAITCFG field.
	FMC_BCR1_WAITCFG_Msk   = 0x800    // Bit mask of WAITCFG field.
	FMC_BCR1_WAITCFG       = 0x800    // Bit WAITCFG.
	FMC_BCR1_WAITPOL_Pos   = 0x9      // Position of WAITPOL field.
	FMC_BCR1_WAITPOL_Msk   = 0x200    // Bit mask of WAITPOL field.
	FMC_BCR1_WAITPOL       = 0x200    // Bit WAITPOL.
	FMC_BCR1_BURSTEN_Pos   = 0x8      // Position of BURSTEN field.
	FMC_BCR1_BURSTEN_Msk   = 0x100    // Bit mask of BURSTEN field.
	FMC_BCR1_BURSTEN       = 0x100    // Bit BURSTEN.
	FMC_BCR1_FACCEN_Pos    = 0x6      // Position of FACCEN field.
	FMC_BCR1_FACCEN_Msk    = 0x40     // Bit mask of FACCEN field.
	FMC_BCR1_FACCEN        = 0x40     // Bit FACCEN.
	FMC_BCR1_MWID_Pos      = 0x4      // Position of MWID field.
	FMC_BCR1_MWID_Msk      = 0x30     // Bit mask of MWID field.
	FMC_BCR1_MTYP_Pos      = 0x2      // Position of MTYP field.
	FMC_BCR1_MTYP_Msk      = 0xc      // Bit mask of MTYP field.
	FMC_BCR1_MUXEN_Pos     = 0x1      // Position of MUXEN field.
	FMC_BCR1_MUXEN_Msk     = 0x2      // Bit mask of MUXEN field.
	FMC_BCR1_MUXEN         = 0x2      // Bit MUXEN.
	FMC_BCR1_MBKEN_Pos     = 0x0      // Position of MBKEN field.
	FMC_BCR1_MBKEN_Msk     = 0x1      // Bit mask of MBKEN field.
	FMC_BCR1_MBKEN         = 0x1      // Bit MBKEN.

	// BTR1: SRAM/NOR-Flash chip-select timing register           1
	FMC_BTR1_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FMC_BTR1_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FMC_BTR1_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FMC_BTR1_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FMC_BTR1_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FMC_BTR1_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FMC_BTR1_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FMC_BTR1_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FMC_BTR1_DATAST_Pos  = 0x8        // Position of DATAST field.
	FMC_BTR1_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FMC_BTR1_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FMC_BTR1_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FMC_BTR1_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FMC_BTR1_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BCR2: SRAM/NOR-Flash chip-select control register           2
	FMC_BCR2_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FMC_BCR2_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FMC_BCR2_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FMC_BCR2_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FMC_BCR2_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FMC_BCR2_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FMC_BCR2_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FMC_BCR2_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FMC_BCR2_EXTMOD        = 0x4000  // Bit EXTMOD.
	FMC_BCR2_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FMC_BCR2_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FMC_BCR2_WAITEN        = 0x2000  // Bit WAITEN.
	FMC_BCR2_WREN_Pos      = 0xc     // Position of WREN field.
	FMC_BCR2_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FMC_BCR2_WREN          = 0x1000  // Bit WREN.
	FMC_BCR2_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FMC_BCR2_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FMC_BCR2_WAITCFG       = 0x800   // Bit WAITCFG.
	FMC_BCR2_WRAPMOD_Pos   = 0xa     // Position of WRAPMOD field.
	FMC_BCR2_WRAPMOD_Msk   = 0x400   // Bit mask of WRAPMOD field.
	FMC_BCR2_WRAPMOD       = 0x400   // Bit WRAPMOD.
	FMC_BCR2_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FMC_BCR2_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FMC_BCR2_WAITPOL       = 0x200   // Bit WAITPOL.
	FMC_BCR2_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FMC_BCR2_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FMC_BCR2_BURSTEN       = 0x100   // Bit BURSTEN.
	FMC_BCR2_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FMC_BCR2_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FMC_BCR2_FACCEN        = 0x40    // Bit FACCEN.
	FMC_BCR2_MWID_Pos      = 0x4     // Position of MWID field.
	FMC_BCR2_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FMC_BCR2_MTYP_Pos      = 0x2     // Position of MTYP field.
	FMC_BCR2_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FMC_BCR2_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FMC_BCR2_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FMC_BCR2_MUXEN         = 0x2     // Bit MUXEN.
	FMC_BCR2_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FMC_BCR2_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FMC_BCR2_MBKEN         = 0x1     // Bit MBKEN.

	// BTR2: SRAM/NOR-Flash chip-select timing register           2
	FMC_BTR2_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FMC_BTR2_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FMC_BTR2_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FMC_BTR2_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FMC_BTR2_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FMC_BTR2_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FMC_BTR2_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FMC_BTR2_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FMC_BTR2_DATAST_Pos  = 0x8        // Position of DATAST field.
	FMC_BTR2_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FMC_BTR2_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FMC_BTR2_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FMC_BTR2_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FMC_BTR2_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BCR3: SRAM/NOR-Flash chip-select control register           3
	FMC_BCR3_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FMC_BCR3_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FMC_BCR3_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FMC_BCR3_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FMC_BCR3_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FMC_BCR3_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FMC_BCR3_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FMC_BCR3_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FMC_BCR3_EXTMOD        = 0x4000  // Bit EXTMOD.
	FMC_BCR3_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FMC_BCR3_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FMC_BCR3_WAITEN        = 0x2000  // Bit WAITEN.
	FMC_BCR3_WREN_Pos      = 0xc     // Position of WREN field.
	FMC_BCR3_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FMC_BCR3_WREN          = 0x1000  // Bit WREN.
	FMC_BCR3_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FMC_BCR3_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FMC_BCR3_WAITCFG       = 0x800   // Bit WAITCFG.
	FMC_BCR3_WRAPMOD_Pos   = 0xa     // Position of WRAPMOD field.
	FMC_BCR3_WRAPMOD_Msk   = 0x400   // Bit mask of WRAPMOD field.
	FMC_BCR3_WRAPMOD       = 0x400   // Bit WRAPMOD.
	FMC_BCR3_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FMC_BCR3_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FMC_BCR3_WAITPOL       = 0x200   // Bit WAITPOL.
	FMC_BCR3_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FMC_BCR3_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FMC_BCR3_BURSTEN       = 0x100   // Bit BURSTEN.
	FMC_BCR3_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FMC_BCR3_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FMC_BCR3_FACCEN        = 0x40    // Bit FACCEN.
	FMC_BCR3_MWID_Pos      = 0x4     // Position of MWID field.
	FMC_BCR3_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FMC_BCR3_MTYP_Pos      = 0x2     // Position of MTYP field.
	FMC_BCR3_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FMC_BCR3_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FMC_BCR3_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FMC_BCR3_MUXEN         = 0x2     // Bit MUXEN.
	FMC_BCR3_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FMC_BCR3_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FMC_BCR3_MBKEN         = 0x1     // Bit MBKEN.

	// BTR3: SRAM/NOR-Flash chip-select timing register           3
	FMC_BTR3_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FMC_BTR3_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FMC_BTR3_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FMC_BTR3_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FMC_BTR3_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FMC_BTR3_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FMC_BTR3_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FMC_BTR3_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FMC_BTR3_DATAST_Pos  = 0x8        // Position of DATAST field.
	FMC_BTR3_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FMC_BTR3_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FMC_BTR3_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FMC_BTR3_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FMC_BTR3_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BCR4: SRAM/NOR-Flash chip-select control register           4
	FMC_BCR4_CBURSTRW_Pos  = 0x13    // Position of CBURSTRW field.
	FMC_BCR4_CBURSTRW_Msk  = 0x80000 // Bit mask of CBURSTRW field.
	FMC_BCR4_CBURSTRW      = 0x80000 // Bit CBURSTRW.
	FMC_BCR4_ASYNCWAIT_Pos = 0xf     // Position of ASYNCWAIT field.
	FMC_BCR4_ASYNCWAIT_Msk = 0x8000  // Bit mask of ASYNCWAIT field.
	FMC_BCR4_ASYNCWAIT     = 0x8000  // Bit ASYNCWAIT.
	FMC_BCR4_EXTMOD_Pos    = 0xe     // Position of EXTMOD field.
	FMC_BCR4_EXTMOD_Msk    = 0x4000  // Bit mask of EXTMOD field.
	FMC_BCR4_EXTMOD        = 0x4000  // Bit EXTMOD.
	FMC_BCR4_WAITEN_Pos    = 0xd     // Position of WAITEN field.
	FMC_BCR4_WAITEN_Msk    = 0x2000  // Bit mask of WAITEN field.
	FMC_BCR4_WAITEN        = 0x2000  // Bit WAITEN.
	FMC_BCR4_WREN_Pos      = 0xc     // Position of WREN field.
	FMC_BCR4_WREN_Msk      = 0x1000  // Bit mask of WREN field.
	FMC_BCR4_WREN          = 0x1000  // Bit WREN.
	FMC_BCR4_WAITCFG_Pos   = 0xb     // Position of WAITCFG field.
	FMC_BCR4_WAITCFG_Msk   = 0x800   // Bit mask of WAITCFG field.
	FMC_BCR4_WAITCFG       = 0x800   // Bit WAITCFG.
	FMC_BCR4_WRAPMOD_Pos   = 0xa     // Position of WRAPMOD field.
	FMC_BCR4_WRAPMOD_Msk   = 0x400   // Bit mask of WRAPMOD field.
	FMC_BCR4_WRAPMOD       = 0x400   // Bit WRAPMOD.
	FMC_BCR4_WAITPOL_Pos   = 0x9     // Position of WAITPOL field.
	FMC_BCR4_WAITPOL_Msk   = 0x200   // Bit mask of WAITPOL field.
	FMC_BCR4_WAITPOL       = 0x200   // Bit WAITPOL.
	FMC_BCR4_BURSTEN_Pos   = 0x8     // Position of BURSTEN field.
	FMC_BCR4_BURSTEN_Msk   = 0x100   // Bit mask of BURSTEN field.
	FMC_BCR4_BURSTEN       = 0x100   // Bit BURSTEN.
	FMC_BCR4_FACCEN_Pos    = 0x6     // Position of FACCEN field.
	FMC_BCR4_FACCEN_Msk    = 0x40    // Bit mask of FACCEN field.
	FMC_BCR4_FACCEN        = 0x40    // Bit FACCEN.
	FMC_BCR4_MWID_Pos      = 0x4     // Position of MWID field.
	FMC_BCR4_MWID_Msk      = 0x30    // Bit mask of MWID field.
	FMC_BCR4_MTYP_Pos      = 0x2     // Position of MTYP field.
	FMC_BCR4_MTYP_Msk      = 0xc     // Bit mask of MTYP field.
	FMC_BCR4_MUXEN_Pos     = 0x1     // Position of MUXEN field.
	FMC_BCR4_MUXEN_Msk     = 0x2     // Bit mask of MUXEN field.
	FMC_BCR4_MUXEN         = 0x2     // Bit MUXEN.
	FMC_BCR4_MBKEN_Pos     = 0x0     // Position of MBKEN field.
	FMC_BCR4_MBKEN_Msk     = 0x1     // Bit mask of MBKEN field.
	FMC_BCR4_MBKEN         = 0x1     // Bit MBKEN.

	// BTR4: SRAM/NOR-Flash chip-select timing register           4
	FMC_BTR4_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FMC_BTR4_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FMC_BTR4_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FMC_BTR4_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FMC_BTR4_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FMC_BTR4_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FMC_BTR4_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FMC_BTR4_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FMC_BTR4_DATAST_Pos  = 0x8        // Position of DATAST field.
	FMC_BTR4_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FMC_BTR4_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FMC_BTR4_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FMC_BTR4_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FMC_BTR4_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// PCR2: PC Card/NAND Flash control register           2
	FMC_PCR2_ECCPS_Pos   = 0x11    // Position of ECCPS field.
	FMC_PCR2_ECCPS_Msk   = 0xe0000 // Bit mask of ECCPS field.
	FMC_PCR2_TAR_Pos     = 0xd     // Position of TAR field.
	FMC_PCR2_TAR_Msk     = 0x1e000 // Bit mask of TAR field.
	FMC_PCR2_TCLR_Pos    = 0x9     // Position of TCLR field.
	FMC_PCR2_TCLR_Msk    = 0x1e00  // Bit mask of TCLR field.
	FMC_PCR2_ECCEN_Pos   = 0x6     // Position of ECCEN field.
	FMC_PCR2_ECCEN_Msk   = 0x40    // Bit mask of ECCEN field.
	FMC_PCR2_ECCEN       = 0x40    // Bit ECCEN.
	FMC_PCR2_PWID_Pos    = 0x4     // Position of PWID field.
	FMC_PCR2_PWID_Msk    = 0x30    // Bit mask of PWID field.
	FMC_PCR2_PTYP_Pos    = 0x3     // Position of PTYP field.
	FMC_PCR2_PTYP_Msk    = 0x8     // Bit mask of PTYP field.
	FMC_PCR2_PTYP        = 0x8     // Bit PTYP.
	FMC_PCR2_PBKEN_Pos   = 0x2     // Position of PBKEN field.
	FMC_PCR2_PBKEN_Msk   = 0x4     // Bit mask of PBKEN field.
	FMC_PCR2_PBKEN       = 0x4     // Bit PBKEN.
	FMC_PCR2_PWAITEN_Pos = 0x1     // Position of PWAITEN field.
	FMC_PCR2_PWAITEN_Msk = 0x2     // Bit mask of PWAITEN field.
	FMC_PCR2_PWAITEN     = 0x2     // Bit PWAITEN.

	// SR2: FIFO status and interrupt register           2
	FMC_SR2_FEMPT_Pos = 0x6  // Position of FEMPT field.
	FMC_SR2_FEMPT_Msk = 0x40 // Bit mask of FEMPT field.
	FMC_SR2_FEMPT     = 0x40 // Bit FEMPT.
	FMC_SR2_IFEN_Pos  = 0x5  // Position of IFEN field.
	FMC_SR2_IFEN_Msk  = 0x20 // Bit mask of IFEN field.
	FMC_SR2_IFEN      = 0x20 // Bit IFEN.
	FMC_SR2_ILEN_Pos  = 0x4  // Position of ILEN field.
	FMC_SR2_ILEN_Msk  = 0x10 // Bit mask of ILEN field.
	FMC_SR2_ILEN      = 0x10 // Bit ILEN.
	FMC_SR2_IREN_Pos  = 0x3  // Position of IREN field.
	FMC_SR2_IREN_Msk  = 0x8  // Bit mask of IREN field.
	FMC_SR2_IREN      = 0x8  // Bit IREN.
	FMC_SR2_IFS_Pos   = 0x2  // Position of IFS field.
	FMC_SR2_IFS_Msk   = 0x4  // Bit mask of IFS field.
	FMC_SR2_IFS       = 0x4  // Bit IFS.
	FMC_SR2_ILS_Pos   = 0x1  // Position of ILS field.
	FMC_SR2_ILS_Msk   = 0x2  // Bit mask of ILS field.
	FMC_SR2_ILS       = 0x2  // Bit ILS.
	FMC_SR2_IRS_Pos   = 0x0  // Position of IRS field.
	FMC_SR2_IRS_Msk   = 0x1  // Bit mask of IRS field.
	FMC_SR2_IRS       = 0x1  // Bit IRS.

	// PMEM2: Common memory space timing register           2
	FMC_PMEM2_MEMHIZx_Pos  = 0x18       // Position of MEMHIZx field.
	FMC_PMEM2_MEMHIZx_Msk  = 0xff000000 // Bit mask of MEMHIZx field.
	FMC_PMEM2_MEMHOLDx_Pos = 0x10       // Position of MEMHOLDx field.
	FMC_PMEM2_MEMHOLDx_Msk = 0xff0000   // Bit mask of MEMHOLDx field.
	FMC_PMEM2_MEMWAITx_Pos = 0x8        // Position of MEMWAITx field.
	FMC_PMEM2_MEMWAITx_Msk = 0xff00     // Bit mask of MEMWAITx field.
	FMC_PMEM2_MEMSETx_Pos  = 0x0        // Position of MEMSETx field.
	FMC_PMEM2_MEMSETx_Msk  = 0xff       // Bit mask of MEMSETx field.

	// PATT2: Attribute memory space timing register           2
	FMC_PATT2_ATTHIZx_Pos  = 0x18       // Position of ATTHIZx field.
	FMC_PATT2_ATTHIZx_Msk  = 0xff000000 // Bit mask of ATTHIZx field.
	FMC_PATT2_ATTHOLDx_Pos = 0x10       // Position of ATTHOLDx field.
	FMC_PATT2_ATTHOLDx_Msk = 0xff0000   // Bit mask of ATTHOLDx field.
	FMC_PATT2_ATTWAITx_Pos = 0x8        // Position of ATTWAITx field.
	FMC_PATT2_ATTWAITx_Msk = 0xff00     // Bit mask of ATTWAITx field.
	FMC_PATT2_ATTSETx_Pos  = 0x0        // Position of ATTSETx field.
	FMC_PATT2_ATTSETx_Msk  = 0xff       // Bit mask of ATTSETx field.

	// ECCR2: ECC result register 2
	FMC_ECCR2_ECCx_Pos = 0x0        // Position of ECCx field.
	FMC_ECCR2_ECCx_Msk = 0xffffffff // Bit mask of ECCx field.

	// PCR3: PC Card/NAND Flash control register           3
	FMC_PCR3_ECCPS_Pos   = 0x11    // Position of ECCPS field.
	FMC_PCR3_ECCPS_Msk   = 0xe0000 // Bit mask of ECCPS field.
	FMC_PCR3_TAR_Pos     = 0xd     // Position of TAR field.
	FMC_PCR3_TAR_Msk     = 0x1e000 // Bit mask of TAR field.
	FMC_PCR3_TCLR_Pos    = 0x9     // Position of TCLR field.
	FMC_PCR3_TCLR_Msk    = 0x1e00  // Bit mask of TCLR field.
	FMC_PCR3_ECCEN_Pos   = 0x6     // Position of ECCEN field.
	FMC_PCR3_ECCEN_Msk   = 0x40    // Bit mask of ECCEN field.
	FMC_PCR3_ECCEN       = 0x40    // Bit ECCEN.
	FMC_PCR3_PWID_Pos    = 0x4     // Position of PWID field.
	FMC_PCR3_PWID_Msk    = 0x30    // Bit mask of PWID field.
	FMC_PCR3_PTYP_Pos    = 0x3     // Position of PTYP field.
	FMC_PCR3_PTYP_Msk    = 0x8     // Bit mask of PTYP field.
	FMC_PCR3_PTYP        = 0x8     // Bit PTYP.
	FMC_PCR3_PBKEN_Pos   = 0x2     // Position of PBKEN field.
	FMC_PCR3_PBKEN_Msk   = 0x4     // Bit mask of PBKEN field.
	FMC_PCR3_PBKEN       = 0x4     // Bit PBKEN.
	FMC_PCR3_PWAITEN_Pos = 0x1     // Position of PWAITEN field.
	FMC_PCR3_PWAITEN_Msk = 0x2     // Bit mask of PWAITEN field.
	FMC_PCR3_PWAITEN     = 0x2     // Bit PWAITEN.

	// SR3: FIFO status and interrupt register           3
	FMC_SR3_FEMPT_Pos = 0x6  // Position of FEMPT field.
	FMC_SR3_FEMPT_Msk = 0x40 // Bit mask of FEMPT field.
	FMC_SR3_FEMPT     = 0x40 // Bit FEMPT.
	FMC_SR3_IFEN_Pos  = 0x5  // Position of IFEN field.
	FMC_SR3_IFEN_Msk  = 0x20 // Bit mask of IFEN field.
	FMC_SR3_IFEN      = 0x20 // Bit IFEN.
	FMC_SR3_ILEN_Pos  = 0x4  // Position of ILEN field.
	FMC_SR3_ILEN_Msk  = 0x10 // Bit mask of ILEN field.
	FMC_SR3_ILEN      = 0x10 // Bit ILEN.
	FMC_SR3_IREN_Pos  = 0x3  // Position of IREN field.
	FMC_SR3_IREN_Msk  = 0x8  // Bit mask of IREN field.
	FMC_SR3_IREN      = 0x8  // Bit IREN.
	FMC_SR3_IFS_Pos   = 0x2  // Position of IFS field.
	FMC_SR3_IFS_Msk   = 0x4  // Bit mask of IFS field.
	FMC_SR3_IFS       = 0x4  // Bit IFS.
	FMC_SR3_ILS_Pos   = 0x1  // Position of ILS field.
	FMC_SR3_ILS_Msk   = 0x2  // Bit mask of ILS field.
	FMC_SR3_ILS       = 0x2  // Bit ILS.
	FMC_SR3_IRS_Pos   = 0x0  // Position of IRS field.
	FMC_SR3_IRS_Msk   = 0x1  // Bit mask of IRS field.
	FMC_SR3_IRS       = 0x1  // Bit IRS.

	// PMEM3: Common memory space timing register           3
	FMC_PMEM3_MEMHIZx_Pos  = 0x18       // Position of MEMHIZx field.
	FMC_PMEM3_MEMHIZx_Msk  = 0xff000000 // Bit mask of MEMHIZx field.
	FMC_PMEM3_MEMHOLDx_Pos = 0x10       // Position of MEMHOLDx field.
	FMC_PMEM3_MEMHOLDx_Msk = 0xff0000   // Bit mask of MEMHOLDx field.
	FMC_PMEM3_MEMWAITx_Pos = 0x8        // Position of MEMWAITx field.
	FMC_PMEM3_MEMWAITx_Msk = 0xff00     // Bit mask of MEMWAITx field.
	FMC_PMEM3_MEMSETx_Pos  = 0x0        // Position of MEMSETx field.
	FMC_PMEM3_MEMSETx_Msk  = 0xff       // Bit mask of MEMSETx field.

	// PATT3: Attribute memory space timing register           3
	FMC_PATT3_ATTHIZx_Pos  = 0x18       // Position of ATTHIZx field.
	FMC_PATT3_ATTHIZx_Msk  = 0xff000000 // Bit mask of ATTHIZx field.
	FMC_PATT3_ATTHOLDx_Pos = 0x10       // Position of ATTHOLDx field.
	FMC_PATT3_ATTHOLDx_Msk = 0xff0000   // Bit mask of ATTHOLDx field.
	FMC_PATT3_ATTWAITx_Pos = 0x8        // Position of ATTWAITx field.
	FMC_PATT3_ATTWAITx_Msk = 0xff00     // Bit mask of ATTWAITx field.
	FMC_PATT3_ATTSETx_Pos  = 0x0        // Position of ATTSETx field.
	FMC_PATT3_ATTSETx_Msk  = 0xff       // Bit mask of ATTSETx field.

	// ECCR3: ECC result register 3
	FMC_ECCR3_ECCx_Pos = 0x0        // Position of ECCx field.
	FMC_ECCR3_ECCx_Msk = 0xffffffff // Bit mask of ECCx field.

	// PCR4: PC Card/NAND Flash control register           4
	FMC_PCR4_ECCPS_Pos   = 0x11    // Position of ECCPS field.
	FMC_PCR4_ECCPS_Msk   = 0xe0000 // Bit mask of ECCPS field.
	FMC_PCR4_TAR_Pos     = 0xd     // Position of TAR field.
	FMC_PCR4_TAR_Msk     = 0x1e000 // Bit mask of TAR field.
	FMC_PCR4_TCLR_Pos    = 0x9     // Position of TCLR field.
	FMC_PCR4_TCLR_Msk    = 0x1e00  // Bit mask of TCLR field.
	FMC_PCR4_ECCEN_Pos   = 0x6     // Position of ECCEN field.
	FMC_PCR4_ECCEN_Msk   = 0x40    // Bit mask of ECCEN field.
	FMC_PCR4_ECCEN       = 0x40    // Bit ECCEN.
	FMC_PCR4_PWID_Pos    = 0x4     // Position of PWID field.
	FMC_PCR4_PWID_Msk    = 0x30    // Bit mask of PWID field.
	FMC_PCR4_PTYP_Pos    = 0x3     // Position of PTYP field.
	FMC_PCR4_PTYP_Msk    = 0x8     // Bit mask of PTYP field.
	FMC_PCR4_PTYP        = 0x8     // Bit PTYP.
	FMC_PCR4_PBKEN_Pos   = 0x2     // Position of PBKEN field.
	FMC_PCR4_PBKEN_Msk   = 0x4     // Bit mask of PBKEN field.
	FMC_PCR4_PBKEN       = 0x4     // Bit PBKEN.
	FMC_PCR4_PWAITEN_Pos = 0x1     // Position of PWAITEN field.
	FMC_PCR4_PWAITEN_Msk = 0x2     // Bit mask of PWAITEN field.
	FMC_PCR4_PWAITEN     = 0x2     // Bit PWAITEN.

	// SR4: FIFO status and interrupt register           4
	FMC_SR4_FEMPT_Pos = 0x6  // Position of FEMPT field.
	FMC_SR4_FEMPT_Msk = 0x40 // Bit mask of FEMPT field.
	FMC_SR4_FEMPT     = 0x40 // Bit FEMPT.
	FMC_SR4_IFEN_Pos  = 0x5  // Position of IFEN field.
	FMC_SR4_IFEN_Msk  = 0x20 // Bit mask of IFEN field.
	FMC_SR4_IFEN      = 0x20 // Bit IFEN.
	FMC_SR4_ILEN_Pos  = 0x4  // Position of ILEN field.
	FMC_SR4_ILEN_Msk  = 0x10 // Bit mask of ILEN field.
	FMC_SR4_ILEN      = 0x10 // Bit ILEN.
	FMC_SR4_IREN_Pos  = 0x3  // Position of IREN field.
	FMC_SR4_IREN_Msk  = 0x8  // Bit mask of IREN field.
	FMC_SR4_IREN      = 0x8  // Bit IREN.
	FMC_SR4_IFS_Pos   = 0x2  // Position of IFS field.
	FMC_SR4_IFS_Msk   = 0x4  // Bit mask of IFS field.
	FMC_SR4_IFS       = 0x4  // Bit IFS.
	FMC_SR4_ILS_Pos   = 0x1  // Position of ILS field.
	FMC_SR4_ILS_Msk   = 0x2  // Bit mask of ILS field.
	FMC_SR4_ILS       = 0x2  // Bit ILS.
	FMC_SR4_IRS_Pos   = 0x0  // Position of IRS field.
	FMC_SR4_IRS_Msk   = 0x1  // Bit mask of IRS field.
	FMC_SR4_IRS       = 0x1  // Bit IRS.

	// PMEM4: Common memory space timing register           4
	FMC_PMEM4_MEMHIZx_Pos  = 0x18       // Position of MEMHIZx field.
	FMC_PMEM4_MEMHIZx_Msk  = 0xff000000 // Bit mask of MEMHIZx field.
	FMC_PMEM4_MEMHOLDx_Pos = 0x10       // Position of MEMHOLDx field.
	FMC_PMEM4_MEMHOLDx_Msk = 0xff0000   // Bit mask of MEMHOLDx field.
	FMC_PMEM4_MEMWAITx_Pos = 0x8        // Position of MEMWAITx field.
	FMC_PMEM4_MEMWAITx_Msk = 0xff00     // Bit mask of MEMWAITx field.
	FMC_PMEM4_MEMSETx_Pos  = 0x0        // Position of MEMSETx field.
	FMC_PMEM4_MEMSETx_Msk  = 0xff       // Bit mask of MEMSETx field.

	// PATT4: Attribute memory space timing register           4
	FMC_PATT4_ATTHIZx_Pos  = 0x18       // Position of ATTHIZx field.
	FMC_PATT4_ATTHIZx_Msk  = 0xff000000 // Bit mask of ATTHIZx field.
	FMC_PATT4_ATTHOLDx_Pos = 0x10       // Position of ATTHOLDx field.
	FMC_PATT4_ATTHOLDx_Msk = 0xff0000   // Bit mask of ATTHOLDx field.
	FMC_PATT4_ATTWAITx_Pos = 0x8        // Position of ATTWAITx field.
	FMC_PATT4_ATTWAITx_Msk = 0xff00     // Bit mask of ATTWAITx field.
	FMC_PATT4_ATTSETx_Pos  = 0x0        // Position of ATTSETx field.
	FMC_PATT4_ATTSETx_Msk  = 0xff       // Bit mask of ATTSETx field.

	// PIO4: I/O space timing register 4
	FMC_PIO4_IOHIZx_Pos  = 0x18       // Position of IOHIZx field.
	FMC_PIO4_IOHIZx_Msk  = 0xff000000 // Bit mask of IOHIZx field.
	FMC_PIO4_IOHOLDx_Pos = 0x10       // Position of IOHOLDx field.
	FMC_PIO4_IOHOLDx_Msk = 0xff0000   // Bit mask of IOHOLDx field.
	FMC_PIO4_IOWAITx_Pos = 0x8        // Position of IOWAITx field.
	FMC_PIO4_IOWAITx_Msk = 0xff00     // Bit mask of IOWAITx field.
	FMC_PIO4_IOSETx_Pos  = 0x0        // Position of IOSETx field.
	FMC_PIO4_IOSETx_Msk  = 0xff       // Bit mask of IOSETx field.

	// BWTR1: SRAM/NOR-Flash write timing registers           1
	FMC_BWTR1_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FMC_BWTR1_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FMC_BWTR1_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FMC_BWTR1_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FMC_BWTR1_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FMC_BWTR1_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FMC_BWTR1_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FMC_BWTR1_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FMC_BWTR1_DATAST_Pos  = 0x8        // Position of DATAST field.
	FMC_BWTR1_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FMC_BWTR1_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FMC_BWTR1_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FMC_BWTR1_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FMC_BWTR1_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BWTR2: SRAM/NOR-Flash write timing registers           2
	FMC_BWTR2_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FMC_BWTR2_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FMC_BWTR2_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FMC_BWTR2_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FMC_BWTR2_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FMC_BWTR2_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FMC_BWTR2_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FMC_BWTR2_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FMC_BWTR2_DATAST_Pos  = 0x8        // Position of DATAST field.
	FMC_BWTR2_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FMC_BWTR2_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FMC_BWTR2_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FMC_BWTR2_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FMC_BWTR2_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BWTR3: SRAM/NOR-Flash write timing registers           3
	FMC_BWTR3_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FMC_BWTR3_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FMC_BWTR3_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FMC_BWTR3_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FMC_BWTR3_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FMC_BWTR3_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FMC_BWTR3_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FMC_BWTR3_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FMC_BWTR3_DATAST_Pos  = 0x8        // Position of DATAST field.
	FMC_BWTR3_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FMC_BWTR3_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FMC_BWTR3_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FMC_BWTR3_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FMC_BWTR3_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.

	// BWTR4: SRAM/NOR-Flash write timing registers           4
	FMC_BWTR4_ACCMOD_Pos  = 0x1c       // Position of ACCMOD field.
	FMC_BWTR4_ACCMOD_Msk  = 0x30000000 // Bit mask of ACCMOD field.
	FMC_BWTR4_DATLAT_Pos  = 0x18       // Position of DATLAT field.
	FMC_BWTR4_DATLAT_Msk  = 0xf000000  // Bit mask of DATLAT field.
	FMC_BWTR4_CLKDIV_Pos  = 0x14       // Position of CLKDIV field.
	FMC_BWTR4_CLKDIV_Msk  = 0xf00000   // Bit mask of CLKDIV field.
	FMC_BWTR4_BUSTURN_Pos = 0x10       // Position of BUSTURN field.
	FMC_BWTR4_BUSTURN_Msk = 0xf0000    // Bit mask of BUSTURN field.
	FMC_BWTR4_DATAST_Pos  = 0x8        // Position of DATAST field.
	FMC_BWTR4_DATAST_Msk  = 0xff00     // Bit mask of DATAST field.
	FMC_BWTR4_ADDHLD_Pos  = 0x4        // Position of ADDHLD field.
	FMC_BWTR4_ADDHLD_Msk  = 0xf0       // Bit mask of ADDHLD field.
	FMC_BWTR4_ADDSET_Pos  = 0x0        // Position of ADDSET field.
	FMC_BWTR4_ADDSET_Msk  = 0xf        // Bit mask of ADDSET field.
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	NVIC_ISER0_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ISER1: Interrupt Set-Enable Register
	NVIC_ISER1_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ISER2: Interrupt Set-Enable Register
	NVIC_ISER2_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER2_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ICER0: Interrupt Clear-Enable           Register
	NVIC_ICER0_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ICER1: Interrupt Clear-Enable           Register
	NVIC_ICER1_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ICER2: Interrupt Clear-Enable           Register
	NVIC_ICER2_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER2_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ISPR0: Interrupt Set-Pending Register
	NVIC_ISPR0_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ISPR1: Interrupt Set-Pending Register
	NVIC_ISPR1_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ISPR2: Interrupt Set-Pending Register
	NVIC_ISPR2_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR2_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ICPR0: Interrupt Clear-Pending           Register
	NVIC_ICPR0_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// ICPR1: Interrupt Clear-Pending           Register
	NVIC_ICPR1_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// ICPR2: Interrupt Clear-Pending           Register
	NVIC_ICPR2_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR2_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// IABR0: Interrupt Active Bit Register
	NVIC_IABR0_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IABR1: Interrupt Active Bit Register
	NVIC_IABR1_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IABR2: Interrupt Active Bit Register
	NVIC_IABR2_ACTIVE_Pos = 0x0        // Position of ACTIVE field.
	NVIC_IABR2_ACTIVE_Msk = 0xffffffff // Bit mask of ACTIVE field.

	// IPR0: Interrupt Priority Register
	NVIC_IPR0_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR1: Interrupt Priority Register
	NVIC_IPR1_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR2: Interrupt Priority Register
	NVIC_IPR2_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR3: Interrupt Priority Register
	NVIC_IPR3_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR4: Interrupt Priority Register
	NVIC_IPR4_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR5: Interrupt Priority Register
	NVIC_IPR5_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR6: Interrupt Priority Register
	NVIC_IPR6_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR7: Interrupt Priority Register
	NVIC_IPR7_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR8: Interrupt Priority Register
	NVIC_IPR8_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR9: Interrupt Priority Register
	NVIC_IPR9_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR10: Interrupt Priority Register
	NVIC_IPR10_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR11: Interrupt Priority Register
	NVIC_IPR11_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR12: Interrupt Priority Register
	NVIC_IPR12_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR13: Interrupt Priority Register
	NVIC_IPR13_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR14: Interrupt Priority Register
	NVIC_IPR14_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR14_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR14_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR14_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR14_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR14_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR14_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR14_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR15: Interrupt Priority Register
	NVIC_IPR15_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR15_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR15_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR15_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR15_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR15_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR15_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR15_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR16: Interrupt Priority Register
	NVIC_IPR16_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR16_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR16_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR16_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR16_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR16_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR16_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR16_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR17: Interrupt Priority Register
	NVIC_IPR17_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR17_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR17_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR17_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR17_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR17_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR17_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR17_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR18: Interrupt Priority Register
	NVIC_IPR18_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR18_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR18_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR18_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR18_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR18_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR18_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR18_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR19: Interrupt Priority Register
	NVIC_IPR19_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR19_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR19_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR19_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR19_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR19_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR19_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR19_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.

	// IPR20: Interrupt Priority Register
	NVIC_IPR20_IPR_N0_Pos = 0x0        // Position of IPR_N0 field.
	NVIC_IPR20_IPR_N0_Msk = 0xff       // Bit mask of IPR_N0 field.
	NVIC_IPR20_IPR_N1_Pos = 0x8        // Position of IPR_N1 field.
	NVIC_IPR20_IPR_N1_Msk = 0xff00     // Bit mask of IPR_N1 field.
	NVIC_IPR20_IPR_N2_Pos = 0x10       // Position of IPR_N2 field.
	NVIC_IPR20_IPR_N2_Msk = 0xff0000   // Bit mask of IPR_N2 field.
	NVIC_IPR20_IPR_N3_Pos = 0x18       // Position of IPR_N3 field.
	NVIC_IPR20_IPR_N3_Msk = 0xff000000 // Bit mask of IPR_N3 field.
)

// Bitfields for FPU: Floting point unit
const (
	// FPCCR: Floating-point context control           register
	FPU_FPCCR_LSPACT_Pos = 0x0        // Position of LSPACT field.
	FPU_FPCCR_LSPACT_Msk = 0x1        // Bit mask of LSPACT field.
	FPU_FPCCR_LSPACT     = 0x1        // Bit LSPACT.
	FPU_FPCCR_USER_Pos   = 0x1        // Position of USER field.
	FPU_FPCCR_USER_Msk   = 0x2        // Bit mask of USER field.
	FPU_FPCCR_USER       = 0x2        // Bit USER.
	FPU_FPCCR_THREAD_Pos = 0x3        // Position of THREAD field.
	FPU_FPCCR_THREAD_Msk = 0x8        // Bit mask of THREAD field.
	FPU_FPCCR_THREAD     = 0x8        // Bit THREAD.
	FPU_FPCCR_HFRDY_Pos  = 0x4        // Position of HFRDY field.
	FPU_FPCCR_HFRDY_Msk  = 0x10       // Bit mask of HFRDY field.
	FPU_FPCCR_HFRDY      = 0x10       // Bit HFRDY.
	FPU_FPCCR_MMRDY_Pos  = 0x5        // Position of MMRDY field.
	FPU_FPCCR_MMRDY_Msk  = 0x20       // Bit mask of MMRDY field.
	FPU_FPCCR_MMRDY      = 0x20       // Bit MMRDY.
	FPU_FPCCR_BFRDY_Pos  = 0x6        // Position of BFRDY field.
	FPU_FPCCR_BFRDY_Msk  = 0x40       // Bit mask of BFRDY field.
	FPU_FPCCR_BFRDY      = 0x40       // Bit BFRDY.
	FPU_FPCCR_MONRDY_Pos = 0x8        // Position of MONRDY field.
	FPU_FPCCR_MONRDY_Msk = 0x100      // Bit mask of MONRDY field.
	FPU_FPCCR_MONRDY     = 0x100      // Bit MONRDY.
	FPU_FPCCR_LSPEN_Pos  = 0x1e       // Position of LSPEN field.
	FPU_FPCCR_LSPEN_Msk  = 0x40000000 // Bit mask of LSPEN field.
	FPU_FPCCR_LSPEN      = 0x40000000 // Bit LSPEN.
	FPU_FPCCR_ASPEN_Pos  = 0x1f       // Position of ASPEN field.
	FPU_FPCCR_ASPEN_Msk  = 0x80000000 // Bit mask of ASPEN field.
	FPU_FPCCR_ASPEN      = 0x80000000 // Bit ASPEN.

	// FPCAR: Floating-point context address           register
	FPU_FPCAR_ADDRESS_Pos = 0x3        // Position of ADDRESS field.
	FPU_FPCAR_ADDRESS_Msk = 0xfffffff8 // Bit mask of ADDRESS field.

	// FPSCR: Floating-point status control           register
	FPU_FPSCR_IOC_Pos   = 0x0        // Position of IOC field.
	FPU_FPSCR_IOC_Msk   = 0x1        // Bit mask of IOC field.
	FPU_FPSCR_IOC       = 0x1        // Bit IOC.
	FPU_FPSCR_DZC_Pos   = 0x1        // Position of DZC field.
	FPU_FPSCR_DZC_Msk   = 0x2        // Bit mask of DZC field.
	FPU_FPSCR_DZC       = 0x2        // Bit DZC.
	FPU_FPSCR_OFC_Pos   = 0x2        // Position of OFC field.
	FPU_FPSCR_OFC_Msk   = 0x4        // Bit mask of OFC field.
	FPU_FPSCR_OFC       = 0x4        // Bit OFC.
	FPU_FPSCR_UFC_Pos   = 0x3        // Position of UFC field.
	FPU_FPSCR_UFC_Msk   = 0x8        // Bit mask of UFC field.
	FPU_FPSCR_UFC       = 0x8        // Bit UFC.
	FPU_FPSCR_IXC_Pos   = 0x4        // Position of IXC field.
	FPU_FPSCR_IXC_Msk   = 0x10       // Bit mask of IXC field.
	FPU_FPSCR_IXC       = 0x10       // Bit IXC.
	FPU_FPSCR_IDC_Pos   = 0x7        // Position of IDC field.
	FPU_FPSCR_IDC_Msk   = 0x80       // Bit mask of IDC field.
	FPU_FPSCR_IDC       = 0x80       // Bit IDC.
	FPU_FPSCR_RMode_Pos = 0x16       // Position of RMode field.
	FPU_FPSCR_RMode_Msk = 0xc00000   // Bit mask of RMode field.
	FPU_FPSCR_FZ_Pos    = 0x18       // Position of FZ field.
	FPU_FPSCR_FZ_Msk    = 0x1000000  // Bit mask of FZ field.
	FPU_FPSCR_FZ        = 0x1000000  // Bit FZ.
	FPU_FPSCR_DN_Pos    = 0x19       // Position of DN field.
	FPU_FPSCR_DN_Msk    = 0x2000000  // Bit mask of DN field.
	FPU_FPSCR_DN        = 0x2000000  // Bit DN.
	FPU_FPSCR_AHP_Pos   = 0x1a       // Position of AHP field.
	FPU_FPSCR_AHP_Msk   = 0x4000000  // Bit mask of AHP field.
	FPU_FPSCR_AHP       = 0x4000000  // Bit AHP.
	FPU_FPSCR_V_Pos     = 0x1c       // Position of V field.
	FPU_FPSCR_V_Msk     = 0x10000000 // Bit mask of V field.
	FPU_FPSCR_V         = 0x10000000 // Bit V.
	FPU_FPSCR_C_Pos     = 0x1d       // Position of C field.
	FPU_FPSCR_C_Msk     = 0x20000000 // Bit mask of C field.
	FPU_FPSCR_C         = 0x20000000 // Bit C.
	FPU_FPSCR_Z_Pos     = 0x1e       // Position of Z field.
	FPU_FPSCR_Z_Msk     = 0x40000000 // Bit mask of Z field.
	FPU_FPSCR_Z         = 0x40000000 // Bit Z.
	FPU_FPSCR_N_Pos     = 0x1f       // Position of N field.
	FPU_FPSCR_N_Msk     = 0x80000000 // Bit mask of N field.
	FPU_FPSCR_N         = 0x80000000 // Bit N.
)

// Bitfields for MPU: Memory protection unit
const (
	// MPU_TYPER: MPU type register
	MPU_MPU_TYPER_SEPARATE_Pos = 0x0      // Position of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE_Msk = 0x1      // Bit mask of SEPARATE field.
	MPU_MPU_TYPER_SEPARATE     = 0x1      // Bit SEPARATE.
	MPU_MPU_TYPER_DREGION_Pos  = 0x8      // Position of DREGION field.
	MPU_MPU_TYPER_DREGION_Msk  = 0xff00   // Bit mask of DREGION field.
	MPU_MPU_TYPER_IREGION_Pos  = 0x10     // Position of IREGION field.
	MPU_MPU_TYPER_IREGION_Msk  = 0xff0000 // Bit mask of IREGION field.

	// MPU_CTRL: MPU control register
	MPU_MPU_CTRL_ENABLE_Pos     = 0x0 // Position of ENABLE field.
	MPU_MPU_CTRL_ENABLE_Msk     = 0x1 // Bit mask of ENABLE field.
	MPU_MPU_CTRL_ENABLE         = 0x1 // Bit ENABLE.
	MPU_MPU_CTRL_HFNMIENA_Pos   = 0x1 // Position of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA_Msk   = 0x2 // Bit mask of HFNMIENA field.
	MPU_MPU_CTRL_HFNMIENA       = 0x2 // Bit HFNMIENA.
	MPU_MPU_CTRL_PRIVDEFENA_Pos = 0x2 // Position of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA_Msk = 0x4 // Bit mask of PRIVDEFENA field.
	MPU_MPU_CTRL_PRIVDEFENA     = 0x4 // Bit PRIVDEFENA.

	// MPU_RNR: MPU region number register
	MPU_MPU_RNR_REGION_Pos = 0x0  // Position of REGION field.
	MPU_MPU_RNR_REGION_Msk = 0xff // Bit mask of REGION field.

	// MPU_RBAR: MPU region base address           register
	MPU_MPU_RBAR_REGION_Pos = 0x0        // Position of REGION field.
	MPU_MPU_RBAR_REGION_Msk = 0xf        // Bit mask of REGION field.
	MPU_MPU_RBAR_VALID_Pos  = 0x4        // Position of VALID field.
	MPU_MPU_RBAR_VALID_Msk  = 0x10       // Bit mask of VALID field.
	MPU_MPU_RBAR_VALID      = 0x10       // Bit VALID.
	MPU_MPU_RBAR_ADDR_Pos   = 0x5        // Position of ADDR field.
	MPU_MPU_RBAR_ADDR_Msk   = 0xffffffe0 // Bit mask of ADDR field.

	// MPU_RASR: MPU region attribute and size           register
	MPU_MPU_RASR_ENABLE_Pos = 0x0        // Position of ENABLE field.
	MPU_MPU_RASR_ENABLE_Msk = 0x1        // Bit mask of ENABLE field.
	MPU_MPU_RASR_ENABLE     = 0x1        // Bit ENABLE.
	MPU_MPU_RASR_SIZE_Pos   = 0x1        // Position of SIZE field.
	MPU_MPU_RASR_SIZE_Msk   = 0x3e       // Bit mask of SIZE field.
	MPU_MPU_RASR_SRD_Pos    = 0x8        // Position of SRD field.
	MPU_MPU_RASR_SRD_Msk    = 0xff00     // Bit mask of SRD field.
	MPU_MPU_RASR_B_Pos      = 0x10       // Position of B field.
	MPU_MPU_RASR_B_Msk      = 0x10000    // Bit mask of B field.
	MPU_MPU_RASR_B          = 0x10000    // Bit B.
	MPU_MPU_RASR_C_Pos      = 0x11       // Position of C field.
	MPU_MPU_RASR_C_Msk      = 0x20000    // Bit mask of C field.
	MPU_MPU_RASR_C          = 0x20000    // Bit C.
	MPU_MPU_RASR_S_Pos      = 0x12       // Position of S field.
	MPU_MPU_RASR_S_Msk      = 0x40000    // Bit mask of S field.
	MPU_MPU_RASR_S          = 0x40000    // Bit S.
	MPU_MPU_RASR_TEX_Pos    = 0x13       // Position of TEX field.
	MPU_MPU_RASR_TEX_Msk    = 0x380000   // Bit mask of TEX field.
	MPU_MPU_RASR_AP_Pos     = 0x18       // Position of AP field.
	MPU_MPU_RASR_AP_Msk     = 0x7000000  // Bit mask of AP field.
	MPU_MPU_RASR_XN_Pos     = 0x1c       // Position of XN field.
	MPU_MPU_RASR_XN_Msk     = 0x10000000 // Bit mask of XN field.
	MPU_MPU_RASR_XN         = 0x10000000 // Bit XN.
)

// Bitfields for STK: SysTick timer
const (
	// CTRL: SysTick control and status           register
	STK_CTRL_ENABLE_Pos    = 0x0     // Position of ENABLE field.
	STK_CTRL_ENABLE_Msk    = 0x1     // Bit mask of ENABLE field.
	STK_CTRL_ENABLE        = 0x1     // Bit ENABLE.
	STK_CTRL_TICKINT_Pos   = 0x1     // Position of TICKINT field.
	STK_CTRL_TICKINT_Msk   = 0x2     // Bit mask of TICKINT field.
	STK_CTRL_TICKINT       = 0x2     // Bit TICKINT.
	STK_CTRL_CLKSOURCE_Pos = 0x2     // Position of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Msk = 0x4     // Bit mask of CLKSOURCE field.
	STK_CTRL_CLKSOURCE     = 0x4     // Bit CLKSOURCE.
	STK_CTRL_COUNTFLAG_Pos = 0x10    // Position of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Msk = 0x10000 // Bit mask of COUNTFLAG field.
	STK_CTRL_COUNTFLAG     = 0x10000 // Bit COUNTFLAG.

	// LOAD: SysTick reload value register
	STK_LOAD_RELOAD_Pos = 0x0      // Position of RELOAD field.
	STK_LOAD_RELOAD_Msk = 0xffffff // Bit mask of RELOAD field.

	// VAL: SysTick current value register
	STK_VAL_CURRENT_Pos = 0x0      // Position of CURRENT field.
	STK_VAL_CURRENT_Msk = 0xffffff // Bit mask of CURRENT field.

	// CALIB: SysTick calibration value           register
	STK_CALIB_TENMS_Pos = 0x0        // Position of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff   // Bit mask of TENMS field.
	STK_CALIB_SKEW_Pos  = 0x1e       // Position of SKEW field.
	STK_CALIB_SKEW_Msk  = 0x40000000 // Bit mask of SKEW field.
	STK_CALIB_SKEW      = 0x40000000 // Bit SKEW.
	STK_CALIB_NOREF_Pos = 0x1f       // Position of NOREF field.
	STK_CALIB_NOREF_Msk = 0x80000000 // Bit mask of NOREF field.
	STK_CALIB_NOREF     = 0x80000000 // Bit NOREF.
)

// Bitfields for SCB: System control block
const (
	// CPUID: CPUID base register
	SCB_CPUID_Revision_Pos    = 0x0        // Position of Revision field.
	SCB_CPUID_Revision_Msk    = 0xf        // Bit mask of Revision field.
	SCB_CPUID_PartNo_Pos      = 0x4        // Position of PartNo field.
	SCB_CPUID_PartNo_Msk      = 0xfff0     // Bit mask of PartNo field.
	SCB_CPUID_Constant_Pos    = 0x10       // Position of Constant field.
	SCB_CPUID_Constant_Msk    = 0xf0000    // Bit mask of Constant field.
	SCB_CPUID_Variant_Pos     = 0x14       // Position of Variant field.
	SCB_CPUID_Variant_Msk     = 0xf00000   // Bit mask of Variant field.
	SCB_CPUID_Implementer_Pos = 0x18       // Position of Implementer field.
	SCB_CPUID_Implementer_Msk = 0xff000000 // Bit mask of Implementer field.

	// ICSR: Interrupt control and state           register
	SCB_ICSR_VECTACTIVE_Pos  = 0x0        // Position of VECTACTIVE field.
	SCB_ICSR_VECTACTIVE_Msk  = 0x1ff      // Bit mask of VECTACTIVE field.
	SCB_ICSR_RETTOBASE_Pos   = 0xb        // Position of RETTOBASE field.
	SCB_ICSR_RETTOBASE_Msk   = 0x800      // Bit mask of RETTOBASE field.
	SCB_ICSR_RETTOBASE       = 0x800      // Bit RETTOBASE.
	SCB_ICSR_VECTPENDING_Pos = 0xc        // Position of VECTPENDING field.
	SCB_ICSR_VECTPENDING_Msk = 0x7f000    // Bit mask of VECTPENDING field.
	SCB_ICSR_ISRPENDING_Pos  = 0x16       // Position of ISRPENDING field.
	SCB_ICSR_ISRPENDING_Msk  = 0x400000   // Bit mask of ISRPENDING field.
	SCB_ICSR_ISRPENDING      = 0x400000   // Bit ISRPENDING.
	SCB_ICSR_PENDSTCLR_Pos   = 0x19       // Position of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR_Msk   = 0x2000000  // Bit mask of PENDSTCLR field.
	SCB_ICSR_PENDSTCLR       = 0x2000000  // Bit PENDSTCLR.
	SCB_ICSR_PENDSTSET_Pos   = 0x1a       // Position of PENDSTSET field.
	SCB_ICSR_PENDSTSET_Msk   = 0x4000000  // Bit mask of PENDSTSET field.
	SCB_ICSR_PENDSTSET       = 0x4000000  // Bit PENDSTSET.
	SCB_ICSR_PENDSVCLR_Pos   = 0x1b       // Position of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR_Msk   = 0x8000000  // Bit mask of PENDSVCLR field.
	SCB_ICSR_PENDSVCLR       = 0x8000000  // Bit PENDSVCLR.
	SCB_ICSR_PENDSVSET_Pos   = 0x1c       // Position of PENDSVSET field.
	SCB_ICSR_PENDSVSET_Msk   = 0x10000000 // Bit mask of PENDSVSET field.
	SCB_ICSR_PENDSVSET       = 0x10000000 // Bit PENDSVSET.
	SCB_ICSR_NMIPENDSET_Pos  = 0x1f       // Position of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET_Msk  = 0x80000000 // Bit mask of NMIPENDSET field.
	SCB_ICSR_NMIPENDSET      = 0x80000000 // Bit NMIPENDSET.

	// VTOR: Vector table offset register
	SCB_VTOR_TBLOFF_Pos = 0x9        // Position of TBLOFF field.
	SCB_VTOR_TBLOFF_Msk = 0x3ffffe00 // Bit mask of TBLOFF field.

	// AIRCR: Application interrupt and reset control           register
	SCB_AIRCR_VECTRESET_Pos     = 0x0        // Position of VECTRESET field.
	SCB_AIRCR_VECTRESET_Msk     = 0x1        // Bit mask of VECTRESET field.
	SCB_AIRCR_VECTRESET         = 0x1        // Bit VECTRESET.
	SCB_AIRCR_VECTCLRACTIVE_Pos = 0x1        // Position of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE_Msk = 0x2        // Bit mask of VECTCLRACTIVE field.
	SCB_AIRCR_VECTCLRACTIVE     = 0x2        // Bit VECTCLRACTIVE.
	SCB_AIRCR_SYSRESETREQ_Pos   = 0x2        // Position of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ_Msk   = 0x4        // Bit mask of SYSRESETREQ field.
	SCB_AIRCR_SYSRESETREQ       = 0x4        // Bit SYSRESETREQ.
	SCB_AIRCR_PRIGROUP_Pos      = 0x8        // Position of PRIGROUP field.
	SCB_AIRCR_PRIGROUP_Msk      = 0x700      // Bit mask of PRIGROUP field.
	SCB_AIRCR_ENDIANESS_Pos     = 0xf        // Position of ENDIANESS field.
	SCB_AIRCR_ENDIANESS_Msk     = 0x8000     // Bit mask of ENDIANESS field.
	SCB_AIRCR_ENDIANESS         = 0x8000     // Bit ENDIANESS.
	SCB_AIRCR_VECTKEYSTAT_Pos   = 0x10       // Position of VECTKEYSTAT field.
	SCB_AIRCR_VECTKEYSTAT_Msk   = 0xffff0000 // Bit mask of VECTKEYSTAT field.

	// SCR: System control register
	SCB_SCR_SLEEPONEXIT_Pos = 0x1  // Position of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT_Msk = 0x2  // Bit mask of SLEEPONEXIT field.
	SCB_SCR_SLEEPONEXIT     = 0x2  // Bit SLEEPONEXIT.
	SCB_SCR_SLEEPDEEP_Pos   = 0x2  // Position of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP_Msk   = 0x4  // Bit mask of SLEEPDEEP field.
	SCB_SCR_SLEEPDEEP       = 0x4  // Bit SLEEPDEEP.
	SCB_SCR_SEVEONPEND_Pos  = 0x4  // Position of SEVEONPEND field.
	SCB_SCR_SEVEONPEND_Msk  = 0x10 // Bit mask of SEVEONPEND field.
	SCB_SCR_SEVEONPEND      = 0x10 // Bit SEVEONPEND.

	// CCR: Configuration and control           register
	SCB_CCR_NONBASETHRDENA_Pos = 0x0   // Position of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA_Msk = 0x1   // Bit mask of NONBASETHRDENA field.
	SCB_CCR_NONBASETHRDENA     = 0x1   // Bit NONBASETHRDENA.
	SCB_CCR_USERSETMPEND_Pos   = 0x1   // Position of USERSETMPEND field.
	SCB_CCR_USERSETMPEND_Msk   = 0x2   // Bit mask of USERSETMPEND field.
	SCB_CCR_USERSETMPEND       = 0x2   // Bit USERSETMPEND.
	SCB_CCR_UNALIGN__TRP_Pos   = 0x3   // Position of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP_Msk   = 0x8   // Bit mask of UNALIGN__TRP field.
	SCB_CCR_UNALIGN__TRP       = 0x8   // Bit UNALIGN__TRP.
	SCB_CCR_DIV_0_TRP_Pos      = 0x4   // Position of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP_Msk      = 0x10  // Bit mask of DIV_0_TRP field.
	SCB_CCR_DIV_0_TRP          = 0x10  // Bit DIV_0_TRP.
	SCB_CCR_BFHFNMIGN_Pos      = 0x8   // Position of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN_Msk      = 0x100 // Bit mask of BFHFNMIGN field.
	SCB_CCR_BFHFNMIGN          = 0x100 // Bit BFHFNMIGN.
	SCB_CCR_STKALIGN_Pos       = 0x9   // Position of STKALIGN field.
	SCB_CCR_STKALIGN_Msk       = 0x200 // Bit mask of STKALIGN field.
	SCB_CCR_STKALIGN           = 0x200 // Bit STKALIGN.

	// SHPR1: System handler priority           registers
	SCB_SHPR1_PRI_4_Pos = 0x0      // Position of PRI_4 field.
	SCB_SHPR1_PRI_4_Msk = 0xff     // Bit mask of PRI_4 field.
	SCB_SHPR1_PRI_5_Pos = 0x8      // Position of PRI_5 field.
	SCB_SHPR1_PRI_5_Msk = 0xff00   // Bit mask of PRI_5 field.
	SCB_SHPR1_PRI_6_Pos = 0x10     // Position of PRI_6 field.
	SCB_SHPR1_PRI_6_Msk = 0xff0000 // Bit mask of PRI_6 field.

	// SHPR2: System handler priority           registers
	SCB_SHPR2_PRI_11_Pos = 0x18       // Position of PRI_11 field.
	SCB_SHPR2_PRI_11_Msk = 0xff000000 // Bit mask of PRI_11 field.

	// SHPR3: System handler priority           registers
	SCB_SHPR3_PRI_14_Pos = 0x10       // Position of PRI_14 field.
	SCB_SHPR3_PRI_14_Msk = 0xff0000   // Bit mask of PRI_14 field.
	SCB_SHPR3_PRI_15_Pos = 0x18       // Position of PRI_15 field.
	SCB_SHPR3_PRI_15_Msk = 0xff000000 // Bit mask of PRI_15 field.

	// SHCRS: System handler control and state           register
	SCB_SHCRS_MEMFAULTACT_Pos    = 0x0     // Position of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT_Msk    = 0x1     // Bit mask of MEMFAULTACT field.
	SCB_SHCRS_MEMFAULTACT        = 0x1     // Bit MEMFAULTACT.
	SCB_SHCRS_BUSFAULTACT_Pos    = 0x1     // Position of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT_Msk    = 0x2     // Bit mask of BUSFAULTACT field.
	SCB_SHCRS_BUSFAULTACT        = 0x2     // Bit BUSFAULTACT.
	SCB_SHCRS_USGFAULTACT_Pos    = 0x3     // Position of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT_Msk    = 0x8     // Bit mask of USGFAULTACT field.
	SCB_SHCRS_USGFAULTACT        = 0x8     // Bit USGFAULTACT.
	SCB_SHCRS_SVCALLACT_Pos      = 0x7     // Position of SVCALLACT field.
	SCB_SHCRS_SVCALLACT_Msk      = 0x80    // Bit mask of SVCALLACT field.
	SCB_SHCRS_SVCALLACT          = 0x80    // Bit SVCALLACT.
	SCB_SHCRS_MONITORACT_Pos     = 0x8     // Position of MONITORACT field.
	SCB_SHCRS_MONITORACT_Msk     = 0x100   // Bit mask of MONITORACT field.
	SCB_SHCRS_MONITORACT         = 0x100   // Bit MONITORACT.
	SCB_SHCRS_PENDSVACT_Pos      = 0xa     // Position of PENDSVACT field.
	SCB_SHCRS_PENDSVACT_Msk      = 0x400   // Bit mask of PENDSVACT field.
	SCB_SHCRS_PENDSVACT          = 0x400   // Bit PENDSVACT.
	SCB_SHCRS_SYSTICKACT_Pos     = 0xb     // Position of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT_Msk     = 0x800   // Bit mask of SYSTICKACT field.
	SCB_SHCRS_SYSTICKACT         = 0x800   // Bit SYSTICKACT.
	SCB_SHCRS_USGFAULTPENDED_Pos = 0xc     // Position of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED_Msk = 0x1000  // Bit mask of USGFAULTPENDED field.
	SCB_SHCRS_USGFAULTPENDED     = 0x1000  // Bit USGFAULTPENDED.
	SCB_SHCRS_MEMFAULTPENDED_Pos = 0xd     // Position of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED_Msk = 0x2000  // Bit mask of MEMFAULTPENDED field.
	SCB_SHCRS_MEMFAULTPENDED     = 0x2000  // Bit MEMFAULTPENDED.
	SCB_SHCRS_BUSFAULTPENDED_Pos = 0xe     // Position of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED_Msk = 0x4000  // Bit mask of BUSFAULTPENDED field.
	SCB_SHCRS_BUSFAULTPENDED     = 0x4000  // Bit BUSFAULTPENDED.
	SCB_SHCRS_SVCALLPENDED_Pos   = 0xf     // Position of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED_Msk   = 0x8000  // Bit mask of SVCALLPENDED field.
	SCB_SHCRS_SVCALLPENDED       = 0x8000  // Bit SVCALLPENDED.
	SCB_SHCRS_MEMFAULTENA_Pos    = 0x10    // Position of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA_Msk    = 0x10000 // Bit mask of MEMFAULTENA field.
	SCB_SHCRS_MEMFAULTENA        = 0x10000 // Bit MEMFAULTENA.
	SCB_SHCRS_BUSFAULTENA_Pos    = 0x11    // Position of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA_Msk    = 0x20000 // Bit mask of BUSFAULTENA field.
	SCB_SHCRS_BUSFAULTENA        = 0x20000 // Bit BUSFAULTENA.
	SCB_SHCRS_USGFAULTENA_Pos    = 0x12    // Position of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA_Msk    = 0x40000 // Bit mask of USGFAULTENA field.
	SCB_SHCRS_USGFAULTENA        = 0x40000 // Bit USGFAULTENA.

	// CFSR_UFSR_BFSR_MMFSR: Configurable fault status           register
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Pos    = 0x1       // Position of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL_Msk    = 0x2       // Bit mask of IACCVIOL field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IACCVIOL        = 0x2       // Bit IACCVIOL.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Pos   = 0x3       // Position of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR_Msk   = 0x8       // Bit mask of MUNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MUNSTKERR       = 0x8       // Bit MUNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Pos     = 0x4       // Position of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR_Msk     = 0x10      // Bit mask of MSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MSTKERR         = 0x10      // Bit MSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Pos     = 0x5       // Position of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR_Msk     = 0x20      // Bit mask of MLSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MLSPERR         = 0x20      // Bit MLSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Pos   = 0x7       // Position of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID_Msk   = 0x80      // Bit mask of MMARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_MMARVALID       = 0x80      // Bit MMARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Pos     = 0x8       // Position of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR_Msk     = 0x100     // Bit mask of IBUSERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IBUSERR         = 0x100     // Bit IBUSERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Pos   = 0x9       // Position of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR_Msk   = 0x200     // Bit mask of PRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_PRECISERR       = 0x200     // Bit PRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Pos = 0xa       // Position of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR_Msk = 0x400     // Bit mask of IMPRECISERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_IMPRECISERR     = 0x400     // Bit IMPRECISERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Pos    = 0xb       // Position of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR_Msk    = 0x800     // Bit mask of UNSTKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNSTKERR        = 0x800     // Bit UNSTKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Pos      = 0xc       // Position of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR_Msk      = 0x1000    // Bit mask of STKERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_STKERR          = 0x1000    // Bit STKERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Pos      = 0xd       // Position of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR_Msk      = 0x2000    // Bit mask of LSPERR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_LSPERR          = 0x2000    // Bit LSPERR.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Pos   = 0xf       // Position of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID_Msk   = 0x8000    // Bit mask of BFARVALID field.
	SCB_CFSR_UFSR_BFSR_MMFSR_BFARVALID       = 0x8000    // Bit BFARVALID.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Pos  = 0x10      // Position of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR_Msk  = 0x10000   // Bit mask of UNDEFINSTR field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNDEFINSTR      = 0x10000   // Bit UNDEFINSTR.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Pos    = 0x11      // Position of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE_Msk    = 0x20000   // Bit mask of INVSTATE field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVSTATE        = 0x20000   // Bit INVSTATE.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Pos       = 0x12      // Position of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC_Msk       = 0x40000   // Bit mask of INVPC field.
	SCB_CFSR_UFSR_BFSR_MMFSR_INVPC           = 0x40000   // Bit INVPC.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Pos        = 0x13      // Position of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP_Msk        = 0x80000   // Bit mask of NOCP field.
	SCB_CFSR_UFSR_BFSR_MMFSR_NOCP            = 0x80000   // Bit NOCP.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Pos   = 0x18      // Position of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED_Msk   = 0x1000000 // Bit mask of UNALIGNED field.
	SCB_CFSR_UFSR_BFSR_MMFSR_UNALIGNED       = 0x1000000 // Bit UNALIGNED.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Pos   = 0x19      // Position of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO_Msk   = 0x2000000 // Bit mask of DIVBYZERO field.
	SCB_CFSR_UFSR_BFSR_MMFSR_DIVBYZERO       = 0x2000000 // Bit DIVBYZERO.

	// HFSR: Hard fault status register
	SCB_HFSR_VECTTBL_Pos  = 0x1        // Position of VECTTBL field.
	SCB_HFSR_VECTTBL_Msk  = 0x2        // Bit mask of VECTTBL field.
	SCB_HFSR_VECTTBL      = 0x2        // Bit VECTTBL.
	SCB_HFSR_FORCED_Pos   = 0x1e       // Position of FORCED field.
	SCB_HFSR_FORCED_Msk   = 0x40000000 // Bit mask of FORCED field.
	SCB_HFSR_FORCED       = 0x40000000 // Bit FORCED.
	SCB_HFSR_DEBUG_VT_Pos = 0x1f       // Position of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT_Msk = 0x80000000 // Bit mask of DEBUG_VT field.
	SCB_HFSR_DEBUG_VT     = 0x80000000 // Bit DEBUG_VT.

	// MMFAR: Memory management fault address           register
	SCB_MMFAR_MMFAR_Pos = 0x0        // Position of MMFAR field.
	SCB_MMFAR_MMFAR_Msk = 0xffffffff // Bit mask of MMFAR field.

	// BFAR: Bus fault address register
	SCB_BFAR_BFAR_Pos = 0x0        // Position of BFAR field.
	SCB_BFAR_BFAR_Msk = 0xffffffff // Bit mask of BFAR field.

	// AFSR: Auxiliary fault status           register
	SCB_AFSR_IMPDEF_Pos = 0x0        // Position of IMPDEF field.
	SCB_AFSR_IMPDEF_Msk = 0xffffffff // Bit mask of IMPDEF field.
)
