/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;

class GTKGraphicsUtils
extends SynthGraphicsUtils {
    GTKGraphicsUtils() {
    }

    @Override
    public void paintText(SynthContext context, Graphics g, String text, int x, int y, int mnemonicIndex) {
        if (text == null || text.length() <= 0) {
            return;
        }
        if (context.getRegion() == Region.INTERNAL_FRAME_TITLE_PANE) {
            return;
        }
        int componentState = context.getComponentState();
        if ((componentState & 8) == 8) {
            Color orgColor = g.getColor();
            g.setColor(context.getStyle().getColor(context, GTKColorType.WHITE));
            super.paintText(context, g, text, ++x, ++y, mnemonicIndex);
            g.setColor(orgColor);
            super.paintText(context, g, text, --x, --y, mnemonicIndex);
        } else {
            String themeName = GTKLookAndFeel.getGtkThemeName();
            if (themeName != null && themeName.startsWith("blueprint") && GTKGraphicsUtils.shouldShadowText(context.getRegion(), componentState)) {
                g.setColor(Color.BLACK);
                super.paintText(context, g, text, x + 1, y + 1, mnemonicIndex);
                g.setColor(Color.WHITE);
            }
            super.paintText(context, g, text, x, y, mnemonicIndex);
        }
    }

    @Override
    public void paintText(SynthContext context, Graphics g, String text, Rectangle bounds, int mnemonicIndex) {
        JComponent source;
        if (text == null || text.length() <= 0) {
            return;
        }
        Region id = context.getRegion();
        if (!(id != Region.RADIO_BUTTON && id != Region.CHECK_BOX && id != Region.TABBED_PANE_TAB || (context.getComponentState() & 0x100) == 0 || (source = context.getComponent()) instanceof AbstractButton && !((AbstractButton)source).isFocusPainted())) {
            int synthState = context.getComponentState();
            GTKStyle style = (GTKStyle)context.getStyle();
            int focusSize = style.getClassSpecificIntValue(context, "focus-line-width", 1);
            int focusPad = style.getClassSpecificIntValue(context, "focus-padding", 1);
            int totalFocus = focusSize + focusPad;
            int x = bounds.x - totalFocus;
            int y = bounds.y - totalFocus;
            int w = bounds.width + 2 * totalFocus;
            int h = bounds.height + 2 * totalFocus;
            Color color = g.getColor();
            GTKPainter.INSTANCE.paintFocus(context, g, id, synthState, "checkbutton", x, y, w, h);
            g.setColor(color);
        }
        super.paintText(context, g, text, bounds, mnemonicIndex);
    }

    private static boolean shouldShadowText(Region id, int state) {
        int gtkState = GTKLookAndFeel.synthStateToGTKState(id, state);
        return gtkState == 2 && (id == Region.MENU || id == Region.MENU_ITEM || id == Region.CHECK_BOX_MENU_ITEM || id == Region.RADIO_BUTTON_MENU_ITEM);
    }
}

