/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public abstract class AsynchronousFileChannel
implements AsynchronousChannel {
    private static final FileAttribute<?>[] NO_ATTRIBUTES = new FileAttribute[0];

    protected AsynchronousFileChannel() {
    }

    public static AsynchronousFileChannel open(Path file, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IOException {
        FileSystemProvider provider = file.getFileSystem().provider();
        return provider.newAsynchronousFileChannel(file, options, executor, attrs);
    }

    public static AsynchronousFileChannel open(Path file, OpenOption ... options) throws IOException {
        HashSet set = new HashSet(options.length);
        Collections.addAll(set, options);
        return AsynchronousFileChannel.open(file, set, null, NO_ATTRIBUTES);
    }

    public abstract long size() throws IOException;

    public abstract AsynchronousFileChannel truncate(long var1) throws IOException;

    public abstract void force(boolean var1) throws IOException;

    public abstract <A> void lock(long var1, long var3, boolean var5, A var6, CompletionHandler<FileLock, ? super A> var7);

    public final <A> void lock(A attachment, CompletionHandler<FileLock, ? super A> handler) {
        this.lock(0L, Long.MAX_VALUE, false, attachment, handler);
    }

    public abstract Future<FileLock> lock(long var1, long var3, boolean var5);

    public final Future<FileLock> lock() {
        return this.lock(0L, Long.MAX_VALUE, false);
    }

    public abstract FileLock tryLock(long var1, long var3, boolean var5) throws IOException;

    public final FileLock tryLock() throws IOException {
        return this.tryLock(0L, Long.MAX_VALUE, false);
    }

    public abstract <A> void read(ByteBuffer var1, long var2, A var4, CompletionHandler<Integer, ? super A> var5);

    public abstract Future<Integer> read(ByteBuffer var1, long var2);

    public abstract <A> void write(ByteBuffer var1, long var2, A var4, CompletionHandler<Integer, ? super A> var5);

    public abstract Future<Integer> write(ByteBuffer var1, long var2);
}

