/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.islandoftex.arara.Arara;
import org.islandoftex.arara.configuration.AraraSpec;
import org.islandoftex.arara.configuration.ConfigurationUtils;
import org.islandoftex.arara.filehandling.FileHandlingUtils;
import org.islandoftex.arara.localization.Language;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.islandoftex.arara.ruleset.Conditional;
import org.islandoftex.arara.utils.CommonUtils;
import org.islandoftex.arara.utils.DisplayUtils;
import org.islandoftex.arara.utils.ExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u0010 \u001a\u00020\u0017H\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\bH\u0002J\b\u0010\"\u001a\u00020\u0017H\u0002J\u000e\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004J\u0006\u0010%\u001a\u00020\u0004J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0014\u0010'\u001a\u00020\u00172\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040)J\u000e\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,J\u0016\u0010-\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\u000e\u0010.\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\bJ\u000e\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020\u0017J\u0006\u00103\u001a\u00020\u0017J\u000e\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020\u00172\u0006\u00108\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\tR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00069"}, d2={"Lorg/islandoftex/arara/utils/DisplayUtils;", "", "()V", "applicationPath", "", "getApplicationPath", "()Ljava/lang/String;", "isDryRunMode", "", "()Z", "isVerboseMode", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "longestMatch", "", "messages", "Lorg/islandoftex/arara/localization/LanguageController;", "shortenedLongestMatch", "width", "getWidth", "()I", "addNewLine", "", "buildDryRunEntry", "name", "task", "buildLongEntry", "buildLongError", "buildLongResult", "value", "buildShortEntry", "buildShortError", "buildShortResult", "displayDetailsLine", "displayOutputSeparator", "message", "displaySeparator", "getResult", "printAuthors", "authors", "", "printConditional", "conditional", "Lorg/islandoftex/arara/ruleset/Conditional;", "printEntry", "printEntryResult", "printException", "exception", "Lorg/islandoftex/arara/model/AraraException;", "printFileInformation", "printLogo", "printTime", "seconds", "", "wrapText", "text", "application"})
public final class DisplayUtils {
    private static final LanguageController messages;
    private static final Logger logger;
    private static final int longestMatch;
    private static final int shortenedLongestMatch = 10;
    public static final DisplayUtils INSTANCE;

    private final int getWidth() {
        return ((Number)Arara.INSTANCE.getConfig().get(AraraSpec.Application.INSTANCE.getWidth())).intValue();
    }

    private final boolean isDryRunMode() {
        return (Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getDryrun());
    }

    private final boolean isVerboseMode() {
        return (Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getVerbose());
    }

    private final String getApplicationPath() {
        String string;
        try {
            string = ((Object)ConfigurationUtils.INSTANCE.getApplicationPath()).toString();
        }
        catch (AraraException ae) {
            string = "[unknown application path]";
        }
        return string;
    }

    private final void buildShortEntry(String name, String task) {
        int result2 = longestMatch >= this.getWidth() ? 10 : longestMatch;
        int space = this.getWidth() - result2 - 1;
        String line = ExtensionsKt.abbreviate$default('(' + name + ") " + task + ' ', space - "... ".length(), null, 2, null);
        String string = StringsKt.padEnd(line, space, '.') + " ";
        boolean bl = false;
        System.out.print((Object)string);
    }

    private final void buildShortResult(boolean value2) {
        int result2 = longestMatch;
        String string = StringsKt.padStart$default(this.getResult(value2), result2, '\u0000', 2, null);
        boolean bl = false;
        System.out.println((Object)string);
    }

    public final void printEntryResult(boolean value2) {
        Arara.INSTANCE.getConfig().set(AraraSpec.UserInteraction.INSTANCE.getDisplayLine(), Boolean.valueOf(false));
        Arara.INSTANCE.getConfig().set(AraraSpec.UserInteraction.INSTANCE.getDisplayResult(), Boolean.valueOf(true));
        Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getStatus(), Integer.valueOf(value2 ? 0 : 1));
        logger.info(messages.getMessage((Enum)Messages.LOG_INFO_TASK_RESULT) + " " + this.getResult(value2));
        if (!this.isDryRunMode()) {
            if (!this.isVerboseMode()) {
                this.buildShortResult(value2);
            } else {
                this.buildLongResult(value2);
            }
        }
    }

    private final void buildLongResult(boolean value2) {
        int width = this.getWidth();
        String string = "\n" + StringsKt.padStart(" " + this.getResult(value2), width, '-');
        boolean bl = false;
        System.out.println((Object)string);
    }

    public final void printEntry(@NotNull String name, @NotNull String task) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(task, "task");
        logger.info(messages.getMessage((Enum)Messages.LOG_INFO_INTERPRET_TASK, task, name));
        Arara.INSTANCE.getConfig().set(AraraSpec.UserInteraction.INSTANCE.getDisplayLine(), Boolean.valueOf(true));
        Arara.INSTANCE.getConfig().set(AraraSpec.UserInteraction.INSTANCE.getDisplayResult(), Boolean.valueOf(false));
        if (!this.isDryRunMode()) {
            if (!this.isVerboseMode()) {
                this.buildShortEntry(name, task);
            } else {
                this.buildLongEntry(name, task);
            }
        } else {
            this.buildDryRunEntry(name, task);
        }
    }

    private final void buildLongEntry(String name, String task) {
        if (((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.UserInteraction.INSTANCE.getDisplayRolling())).booleanValue()) {
            this.addNewLine();
        } else {
            Arara.INSTANCE.getConfig().set(AraraSpec.UserInteraction.INSTANCE.getDisplayRolling(), Boolean.valueOf(true));
        }
        String string = this.displaySeparator();
        boolean bl = false;
        System.out.println((Object)string);
        string = ExtensionsKt.abbreviate$default('(' + name + ") " + task, this.getWidth(), null, 2, null);
        bl = false;
        System.out.println((Object)string);
        string = this.displaySeparator();
        bl = false;
        System.out.println((Object)string);
    }

    private final void buildDryRunEntry(String name, String task) {
        if (((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.UserInteraction.INSTANCE.getDisplayRolling())).booleanValue()) {
            this.addNewLine();
        } else {
            Arara.INSTANCE.getConfig().set(AraraSpec.UserInteraction.INSTANCE.getDisplayRolling(), Boolean.valueOf(true));
        }
        String string = ExtensionsKt.abbreviate$default("[DR] (" + name + ") " + task, this.getWidth(), null, 2, null);
        boolean bl = false;
        System.out.println((Object)string);
        string = this.displaySeparator();
        bl = false;
        System.out.println((Object)string);
    }

    public final void printException(@NotNull AraraException exception) {
        String string;
        Intrinsics.checkParameterIsNotNull(exception, "exception");
        Arara.INSTANCE.getConfig().set(AraraSpec.UserInteraction.INSTANCE.getDisplayException(), Boolean.valueOf(true));
        Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getStatus(), Integer.valueOf(2));
        boolean display = (Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.UserInteraction.INSTANCE.getDisplayLine());
        if (((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.UserInteraction.INSTANCE.getDisplayResult())).booleanValue()) {
            this.addNewLine();
        }
        if (display && !this.isDryRunMode()) {
            if (!this.isVerboseMode()) {
                this.buildShortError();
            } else {
                this.buildLongError();
            }
            this.addNewLine();
        }
        if ((string = exception.hasException() ? exception.getMessage() + " " + messages.getMessage((Enum)Messages.INFO_DISPLAY_EXCEPTION_MORE_DETAILS) : exception.getMessage()) == null) {
            string = "EXCEPTION PROVIDES NO MESSAGE";
        }
        String text2 = string;
        logger.error(text2);
        this.wrapText(text2);
        if (exception.hasException()) {
            this.addNewLine();
            this.displayDetailsLine();
            Exception exception2 = exception.getException();
            if (exception2 == null) {
                Intrinsics.throwNpe();
            }
            String string2 = exception2.getMessage();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String details = string2;
            logger.error(details);
            this.wrapText(details);
        }
    }

    private final String getResult(boolean value2) {
        return value2 ? messages.getMessage((Enum)Messages.INFO_LABEL_ON_SUCCESS) : messages.getMessage((Enum)Messages.INFO_LABEL_ON_FAILURE);
    }

    private final void buildShortError() {
        int result2 = longestMatch;
        String string = StringsKt.padStart$default(messages.getMessage((Enum)Messages.INFO_LABEL_ON_ERROR), result2, '\u0000', 2, null);
        boolean bl = false;
        System.out.println((Object)string);
    }

    private final void buildLongError() {
        String string = StringsKt.padStart(" " + messages.getMessage((Enum)Messages.INFO_LABEL_ON_ERROR), this.getWidth(), '-');
        boolean bl = false;
        System.out.println((Object)string);
    }

    public final void wrapText(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull(text2, "text");
        String string = ExtensionsKt.wrap(text2, this.getWidth());
        boolean bl = false;
        System.out.println((Object)string);
    }

    public final void printAuthors(@NotNull List<String> authors) {
        Intrinsics.checkParameterIsNotNull(authors, "authors");
        String line = authors.size() == 1 ? messages.getMessage((Enum)Messages.INFO_LABEL_AUTHOR) : messages.getMessage((Enum)Messages.INFO_LABEL_AUTHORS);
        String text2 = authors.isEmpty() ? messages.getMessage((Enum)Messages.INFO_LABEL_NO_AUTHORS) : CollectionsKt.joinToString$default(authors, ", ", null, null, 0, null, printAuthors.text.1.INSTANCE, 30, null);
        this.wrapText(line + ' ' + text2);
    }

    public final void printConditional(@NotNull Conditional conditional) {
        Intrinsics.checkParameterIsNotNull(conditional, "conditional");
        if (conditional.getType() != Conditional.ConditionalType.NONE) {
            this.wrapText(messages.getMessage((Enum)Messages.INFO_LABEL_CONDITIONAL) + " (" + (Object)((Object)conditional.getType()) + ") " + conditional.getCondition());
        }
    }

    public final void printFileInformation() {
        File file2 = (File)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getReference());
        String version = (String)Arara.INSTANCE.getConfig().get(AraraSpec.Application.INSTANCE.getVersion());
        Enum enum_ = Messages.INFO_DISPLAY_FILE_INFORMATION;
        Object[] objectArray = new Object[3];
        String string = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        objectArray[0] = string;
        objectArray[1] = CommonUtils.INSTANCE.byteSizeToString(file2.length());
        objectArray[2] = FileHandlingUtils.INSTANCE.getLastModifiedInformation(file2);
        String line = messages.getMessage(enum_, objectArray);
        logger.info(messages.getMessage((Enum)Messages.LOG_INFO_WELCOME_MESSAGE, version));
        logger.info(this.displaySeparator());
        logger.debug("::: arara @ " + this.getApplicationPath());
        String string2 = "::: Java %s, %s";
        Object[] objectArray2 = new Object[]{CommonUtils.INSTANCE.getSystemProperty("java.version", "[unknown version]"), CommonUtils.INSTANCE.getSystemProperty("java.vendor", "[unknown vendor]")};
        Logger logger = DisplayUtils.logger;
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
        String string4 = string3;
        logger.debug(string4);
        string2 = "::: %s";
        objectArray2 = new Object[]{CommonUtils.INSTANCE.getSystemProperty("java.home", "[unknown location]")};
        logger = DisplayUtils.logger;
        bl = false;
        String string5 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull(string5, "java.lang.String.format(this, *args)");
        string4 = string5;
        logger.debug(string4);
        string2 = "::: %s, %s, %s";
        objectArray2 = new Object[]{CommonUtils.INSTANCE.getSystemProperty("os.name", "[unknown OS name]"), CommonUtils.INSTANCE.getSystemProperty("os.arch", "[unknown OS arch]"), CommonUtils.INSTANCE.getSystemProperty("os.version", "[unknown OS version]")};
        logger = DisplayUtils.logger;
        bl = false;
        String string6 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull(string6, "java.lang.String.format(this, *args)");
        string4 = string6;
        logger.debug(string4);
        string2 = "::: user.home @ %s";
        objectArray2 = new Object[]{CommonUtils.INSTANCE.getSystemProperty("user.home", "[unknown user's home directory]")};
        logger = DisplayUtils.logger;
        bl = false;
        String string7 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull(string7, "java.lang.String.format(this, *args)");
        string4 = string7;
        logger.debug(string4);
        string2 = "::: CF @ %s";
        objectArray2 = new Object[]{Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getConfigurationName())};
        logger = DisplayUtils.logger;
        bl = false;
        String string8 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull(string8, "java.lang.String.format(this, *args)");
        string4 = string8;
        logger.debug(string4);
        DisplayUtils.logger.debug(this.displaySeparator());
        DisplayUtils.logger.info(line);
        this.wrapText(line);
        this.addNewLine();
    }

    public final void printTime(double seconds) {
        Language language = (Language)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getLanguage());
        if (((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.UserInteraction.INSTANCE.getDisplayTime())).booleanValue()) {
            Object[] objectArray;
            if (((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.UserInteraction.INSTANCE.getDisplayLine())).booleanValue() || ((Boolean)Arara.INSTANCE.getConfig().get(AraraSpec.UserInteraction.INSTANCE.getDisplayException())).booleanValue()) {
                this.addNewLine();
            }
            String string = "%1.2f";
            Locale locale = language.getLocale();
            Object[] objectArray2 = new Object[]{seconds};
            int n = 0;
            Object[] objectArray3 = objectArray = new Object[1];
            Enum enum_ = Messages.INFO_DISPLAY_EXECUTION_TIME;
            LanguageController languageController = messages;
            boolean bl = false;
            String string2 = String.format(locale, string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(locale, this, *args)");
            String string3 = string2;
            objectArray[n] = string3;
            String text2 = languageController.getMessage(enum_, objectArray3);
            logger.info(text2);
            this.wrapText(text2);
        }
    }

    public final void printLogo() {
        String string = "  __ _ _ __ __ _ _ __ __ _\n / _` | '__/ _` | '__/ _` |\n| (_| | | | (_| | | | (_| |\n \\__,_|_|  \\__,_|_|  \\__,_|";
        boolean bl = false;
        System.out.println((Object)string);
        this.addNewLine();
    }

    private final void addNewLine() {
        boolean bl = false;
        System.out.println();
    }

    private final void displayDetailsLine() {
        String line = messages.getMessage((Enum)Messages.INFO_LABEL_ON_DETAILS) + " ";
        String string = StringsKt.padEnd(ExtensionsKt.abbreviate$default(line, this.getWidth(), null, 2, null), this.getWidth(), '-');
        boolean bl = false;
        System.out.println((Object)string);
    }

    @NotNull
    public final String displayOutputSeparator(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        return ExtensionsKt.center(' ' + message + ' ', this.getWidth(), '-');
    }

    @NotNull
    public final String displaySeparator() {
        return StringsKt.repeat("-", this.getWidth());
    }

    private DisplayUtils() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapTo$iv$iv;
        DisplayUtils displayUtils;
        INSTANCE = displayUtils = new DisplayUtils();
        messages = LanguageController.INSTANCE;
        logger = LoggerFactory.getLogger(DisplayUtils.class);
        Iterable $this$map$iv = CollectionsKt.listOf(messages.getMessage((Enum)Messages.INFO_LABEL_ON_SUCCESS), messages.getMessage((Enum)Messages.INFO_LABEL_ON_FAILURE), messages.getMessage((Enum)Messages.INFO_LABEL_ON_ERROR));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = it.length();
            collection.add(n);
        }
        Object t = CollectionsKt.max((List)destination$iv$iv);
        if (t == null) {
            Intrinsics.throwNpe();
        }
        longestMatch = ((Number)t).intValue();
    }
}

