/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import java.lang.reflect.Method;
import org.mvel2.DataConversion;
import org.mvel2.compiler.AccessorNode;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.impl.refl.nodes.GetterAccessor;
import org.mvel2.util.ParseTools;

public class MethodAccessorNH
implements AccessorNode {
    private AccessorNode nextNode;
    private Method method;
    private Class[] parameterTypes;
    private ExecutableStatement[] parms;
    private int length;
    private boolean coercionNeeded = false;
    private PropertyHandler nullHandler;

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (!this.coercionNeeded) {
            try {
                Object v = this.method.invoke(ctx, this.executeAll(elCtx, vars));
                if (v == null) {
                    this.nullHandler.getProperty(this.method.getName(), ctx, vars);
                }
                if (this.nextNode != null) {
                    return this.nextNode.getValue(v, elCtx, vars);
                }
                return v;
            }
            catch (IllegalArgumentException e) {
                Method o;
                if (ctx != null && this.method.getDeclaringClass() != ctx.getClass() && (o = ParseTools.getBestCandidate(this.parameterTypes, this.method.getName(), ctx.getClass(), ctx.getClass().getMethods(), true)) != null) {
                    return this.executeOverrideTarget(o, ctx, elCtx, vars);
                }
                this.coercionNeeded = true;
                return this.getValue(ctx, elCtx, vars);
            }
            catch (Exception e) {
                throw new RuntimeException("cannot invoke method", e);
            }
        }
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.method.invoke(ctx, this.executeAndCoerce(this.parameterTypes, elCtx, vars)), elCtx, vars);
            }
            return this.method.invoke(ctx, this.executeAndCoerce(this.parameterTypes, elCtx, vars));
        }
        catch (Exception e) {
            throw new RuntimeException("cannot invoke method", e);
        }
    }

    private Object executeOverrideTarget(Method o, Object ctx, Object elCtx, VariableResolverFactory vars) {
        try {
            Object v = o.invoke(ctx, this.executeAll(elCtx, vars));
            if (v == null) {
                v = this.nullHandler.getProperty(o.getName(), ctx, vars);
            }
            if (this.nextNode != null) {
                return this.nextNode.getValue(v, elCtx, vars);
            }
            return v;
        }
        catch (Exception e2) {
            throw new RuntimeException("unable to invoke method", e2);
        }
    }

    private Object[] executeAll(Object ctx, VariableResolverFactory vars) {
        if (this.length == 0) {
            return GetterAccessor.EMPTY;
        }
        Object[] vals = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            vals[i] = this.parms[i].getValue(ctx, vars);
        }
        return vals;
    }

    private Object[] executeAndCoerce(Class[] target, Object elCtx, VariableResolverFactory vars) {
        Object[] values2 = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            values2[i] = DataConversion.convert(this.parms[i].getValue(elCtx, vars), target[i]);
        }
        return values2;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        this.parameterTypes = this.method.getParameterTypes();
        this.length = this.parameterTypes.length;
    }

    public ExecutableStatement[] getParms() {
        return this.parms;
    }

    public void setParms(ExecutableStatement[] parms) {
        this.parms = parms;
    }

    public MethodAccessorNH() {
    }

    public MethodAccessorNH(Method method, ExecutableStatement[] parms, PropertyHandler handler) {
        this.method = method;
        this.parameterTypes = this.method.getParameterTypes();
        this.length = this.parameterTypes.length;
        this.parms = parms;
        this.nullHandler = handler;
    }

    @Override
    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    @Override
    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }

    @Override
    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value2) {
        return this.nextNode.setValue(ctx, elCtx, variableFactory, value2);
    }

    @Override
    public Class getKnownEgressType() {
        return this.method.getReturnType();
    }
}

