/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.sh.command.file;

import java.io.File;
import org.mvel2.sh.Command;
import org.mvel2.sh.CommandException;
import org.mvel2.sh.ShellSession;

public class ChangeWorkingDir
implements Command {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(ShellSession session, String[] args2) {
        File cwd = new File(session.getEnv().get("$CWD"));
        if (args2.length == 0 || ".".equals(args2[0])) {
            return null;
        }
        if ("..".equals(args2[0])) {
            if (cwd.getParentFile() == null) throw new CommandException("already at top-level directory");
            cwd = cwd.getParentFile();
        } else if (args2[0].charAt(0) == '/' ? !(cwd = new File(args2[0])).exists() : !(cwd = new File(cwd.getAbsolutePath() + "/" + args2[0])).exists()) {
            throw new CommandException("no such directory: " + args2[0]);
        }
        session.getEnv().put("$CWD", cwd.getAbsolutePath());
        return null;
    }

    @Override
    public String getDescription() {
        return "changes the working directory";
    }

    @Override
    public String getHelp() {
        return "no help yet";
    }
}

