/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves.rewrite;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.catalina.valves.rewrite.Resolver;
import org.apache.catalina.valves.rewrite.RewriteMap;
import org.apache.catalina.valves.rewrite.Substitution;

public class RewriteCond {
    protected String testString = null;
    protected String condPattern = null;
    protected String flagsString = null;
    protected boolean positive = true;
    protected Substitution test = null;
    protected Condition condition = null;
    public boolean nocase = false;
    public boolean ornext = false;

    public String getCondPattern() {
        return this.condPattern;
    }

    public void setCondPattern(String string) {
        this.condPattern = string;
    }

    public String getTestString() {
        return this.testString;
    }

    public void setTestString(String string) {
        this.testString = string;
    }

    public final String getFlagsString() {
        return this.flagsString;
    }

    public final void setFlagsString(String string) {
        this.flagsString = string;
    }

    public void parse(Map<String, RewriteMap> map) {
        this.test = new Substitution();
        this.test.setSub(this.testString);
        this.test.parse(map);
        if (this.condPattern.startsWith("!")) {
            this.positive = false;
            this.condPattern = this.condPattern.substring(1);
        }
        if (this.condPattern.startsWith("<")) {
            LexicalCondition lexicalCondition = new LexicalCondition();
            lexicalCondition.type = -1;
            lexicalCondition.condition = this.condPattern.substring(1);
            this.condition = lexicalCondition;
        } else if (this.condPattern.startsWith(">")) {
            LexicalCondition lexicalCondition = new LexicalCondition();
            lexicalCondition.type = 1;
            lexicalCondition.condition = this.condPattern.substring(1);
            this.condition = lexicalCondition;
        } else if (this.condPattern.startsWith("=")) {
            LexicalCondition lexicalCondition = new LexicalCondition();
            lexicalCondition.type = 0;
            lexicalCondition.condition = this.condPattern.substring(1);
            this.condition = lexicalCondition;
        } else if (this.condPattern.equals("-d")) {
            ResourceCondition resourceCondition = new ResourceCondition();
            resourceCondition.type = 0;
            this.condition = resourceCondition;
        } else if (this.condPattern.equals("-f")) {
            ResourceCondition resourceCondition = new ResourceCondition();
            resourceCondition.type = 1;
            this.condition = resourceCondition;
        } else if (this.condPattern.equals("-s")) {
            ResourceCondition resourceCondition = new ResourceCondition();
            resourceCondition.type = 2;
            this.condition = resourceCondition;
        } else {
            PatternCondition patternCondition = new PatternCondition();
            int n = 0;
            if (this.isNocase()) {
                n |= 2;
            }
            patternCondition.pattern = Pattern.compile(this.condPattern, n);
            this.condition = patternCondition;
        }
    }

    public Matcher getMatcher() {
        if (this.condition instanceof PatternCondition) {
            return ((PatternCondition)this.condition).getMatcher();
        }
        return null;
    }

    public String toString() {
        return "RewriteCond " + this.testString + " " + this.condPattern + (this.flagsString != null ? " " + this.flagsString : "");
    }

    public boolean evaluate(Matcher matcher, Matcher matcher2, Resolver resolver) {
        String string = this.test.evaluate(matcher, matcher2, resolver);
        if (this.positive) {
            return this.condition.evaluate(string, resolver);
        }
        return !this.condition.evaluate(string, resolver);
    }

    public boolean isNocase() {
        return this.nocase;
    }

    public void setNocase(boolean bl) {
        this.nocase = bl;
    }

    public boolean isOrnext() {
        return this.ornext;
    }

    public void setOrnext(boolean bl) {
        this.ornext = bl;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public void setPositive(boolean bl) {
        this.positive = bl;
    }

    public static class ResourceCondition
    extends Condition {
        public int type = 0;

        @Override
        public boolean evaluate(String string, Resolver resolver) {
            return resolver.resolveResource(this.type, string);
        }
    }

    public static class LexicalCondition
    extends Condition {
        public int type = 0;
        public String condition;

        @Override
        public boolean evaluate(String string, Resolver resolver) {
            int n = string.compareTo(this.condition);
            switch (this.type) {
                case -1: {
                    return n < 0;
                }
                case 0: {
                    return n == 0;
                }
                case 1: {
                    return n > 0;
                }
            }
            return false;
        }
    }

    public static class PatternCondition
    extends Condition {
        public Pattern pattern;
        private ThreadLocal<Matcher> matcher = new ThreadLocal();

        @Override
        public boolean evaluate(String string, Resolver resolver) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                this.matcher.set(matcher);
                return true;
            }
            return false;
        }

        public Matcher getMatcher() {
            return this.matcher.get();
        }
    }

    public static abstract class Condition {
        public abstract boolean evaluate(String var1, Resolver var2);
    }
}

