/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.apache.tomcat.util.modeler.FeatureInfo;
import org.apache.tomcat.util.modeler.ParameterInfo;

public class OperationInfo
extends FeatureInfo {
    static final long serialVersionUID = 4418342922072614875L;
    protected String impact = "UNKNOWN";
    protected String role = "operation";
    protected final ReadWriteLock parametersLock = new ReentrantReadWriteLock();
    protected ParameterInfo[] parameters = new ParameterInfo[0];

    public String getImpact() {
        return this.impact;
    }

    public void setImpact(String string) {
        this.impact = string == null ? null : string.toUpperCase(Locale.ENGLISH);
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String string) {
        this.role = string;
    }

    public String getReturnType() {
        if (this.type == null) {
            this.type = "void";
        }
        return this.type;
    }

    public void setReturnType(String string) {
        this.type = string;
    }

    public ParameterInfo[] getSignature() {
        Lock lock = this.parametersLock.readLock();
        lock.lock();
        try {
            ParameterInfo[] parameterInfoArray = this.parameters;
            return parameterInfoArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParameter(ParameterInfo parameterInfo) {
        Lock lock = this.parametersLock.writeLock();
        lock.lock();
        try {
            ParameterInfo[] parameterInfoArray = new ParameterInfo[this.parameters.length + 1];
            System.arraycopy(this.parameters, 0, parameterInfoArray, 0, this.parameters.length);
            parameterInfoArray[this.parameters.length] = parameterInfo;
            this.parameters = parameterInfoArray;
            this.info = null;
        }
        finally {
            lock.unlock();
        }
    }

    MBeanOperationInfo createOperationInfo() {
        if (this.info == null) {
            int n = 3;
            if ("ACTION".equals(this.getImpact())) {
                n = 1;
            } else if ("ACTION_INFO".equals(this.getImpact())) {
                n = 2;
            } else if ("INFO".equals(this.getImpact())) {
                n = 0;
            }
            this.info = new MBeanOperationInfo(this.getName(), this.getDescription(), this.getMBeanParameterInfo(), this.getReturnType(), n);
        }
        return (MBeanOperationInfo)this.info;
    }

    protected MBeanParameterInfo[] getMBeanParameterInfo() {
        ParameterInfo[] parameterInfoArray = this.getSignature();
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[parameterInfoArray.length];
        for (int i = 0; i < parameterInfoArray.length; ++i) {
            mBeanParameterInfoArray[i] = parameterInfoArray[i].createParameterInfo();
        }
        return mBeanParameterInfoArray;
    }
}

