/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.tomcat.util.modeler.BaseModelMBean;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class GroupMBean
extends BaseModelMBean {
    private static final StringManager sm = StringManager.getManager(GroupMBean.class);
    protected final Registry registry = MBeanUtils.createRegistry();
    protected final ManagedBean managed = this.registry.findManagedBean("Group");

    public String[] getRoles() {
        Group group = (Group)this.resource;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Role> iterator = group.getRoles();
        while (iterator.hasNext()) {
            Role role = null;
            try {
                role = iterator.next();
                ObjectName objectName = MBeanUtils.createObjectName(this.managed.getDomain(), role);
                arrayList.add(objectName.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(sm.getString("userMBean.createError.role", new Object[]{role}));
                illegalArgumentException.initCause(malformedObjectNameException);
                throw illegalArgumentException;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getUsers() {
        Group group = (Group)this.resource;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<User> iterator = group.getUsers();
        while (iterator.hasNext()) {
            User user = null;
            try {
                user = iterator.next();
                ObjectName objectName = MBeanUtils.createObjectName(this.managed.getDomain(), user);
                arrayList.add(objectName.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(sm.getString("userMBean.createError.user", new Object[]{user}));
                illegalArgumentException.initCause(malformedObjectNameException);
                throw illegalArgumentException;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public void addRole(String string) {
        Group group = (Group)this.resource;
        if (group == null) {
            return;
        }
        Role role = group.getUserDatabase().findRole(string);
        if (role == null) {
            throw new IllegalArgumentException(sm.getString("userMBean.invalidRole", new Object[]{string}));
        }
        group.addRole(role);
    }

    public void removeRole(String string) {
        Group group = (Group)this.resource;
        if (group == null) {
            return;
        }
        Role role = group.getUserDatabase().findRole(string);
        if (role == null) {
            throw new IllegalArgumentException(sm.getString("userMBean.invalidRole", new Object[]{string}));
        }
        group.removeRole(role);
    }
}

