/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.security.ImageIO;

public class PngIOMetadata {
    private static final String copyleft = "Generated by http://plantuml.com";

    public static void writeWithMetadata(RenderedImage image, OutputStream os, String metadata, int dpi, String debugData) throws IOException {
        PngIOMetadata.writeInternal(image, os, metadata, dpi, debugData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInternal(RenderedImage image, OutputStream os, String metadata, int dpi, String debugData) throws IOException {
        ImageWriter writer = javax.imageio.ImageIO.getImageWritersByFormatName("png").next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata meta = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
        if (dpi != 96) {
            PngIOMetadata.addDpi(meta, dpi);
        }
        if (debugData != null) {
            PngIOMetadata.addText(meta, "debug", debugData);
        }
        PngIOMetadata.addText(meta, "copyleft", copyleft);
        PngIOMetadata.addiText(meta, "plantuml", metadata);
        Log.debug("PngIOMetadata pngMetadata=" + meta);
        IIOImage iioImage = new IIOImage(image, null, meta);
        Log.debug("PngIOMetadata iioImage=" + iioImage);
        ImageWriter imagewriter = PngIOMetadata.getImageWriter();
        Log.debug("PngIOMetadata imagewriter=" + imagewriter);
        ImageWriter imageWriter = imagewriter;
        synchronized (imageWriter) {
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(os);
            imagewriter.setOutput(imageOutputStream);
            try {
                imagewriter.write(null, iioImage, null);
            }
            finally {
                imageOutputStream.flush();
                imageOutputStream.close();
                imagewriter.reset();
                imagewriter.dispose();
            }
        }
    }

    private static void addDpi(IIOMetadata meta, double dpi) throws IIOInvalidTreeException {
        IIOMetadataNode dimension = new IIOMetadataNode("Dimension");
        IIOMetadataNode horizontalPixelSize = new IIOMetadataNode("HorizontalPixelSize");
        double value = dpi / 0.0254 / 1000.0;
        horizontalPixelSize.setAttribute("value", Double.toString(value));
        dimension.appendChild(horizontalPixelSize);
        IIOMetadataNode verticalPixelSize = new IIOMetadataNode("VerticalPixelSize");
        verticalPixelSize.setAttribute("value", Double.toString(value));
        dimension.appendChild(verticalPixelSize);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dimension);
        meta.mergeTree("javax_imageio_1.0", root);
    }

    private static void addiText(IIOMetadata meta, String key, String value) throws IIOInvalidTreeException {
        IIOMetadataNode text = new IIOMetadataNode("iTXt");
        IIOMetadataNode entry = new IIOMetadataNode("iTXtEntry");
        entry.setAttribute("keyword", key);
        entry.setAttribute("compressionFlag", "true");
        entry.setAttribute("compressionMethod", "0");
        entry.setAttribute("languageTag", "");
        entry.setAttribute("translatedKeyword", "");
        entry.setAttribute("text", value);
        text.appendChild(entry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
        root.appendChild(text);
        meta.mergeTree("javax_imageio_png_1.0", root);
    }

    private static void addText(IIOMetadata meta, String key, String value) throws IIOInvalidTreeException {
        IIOMetadataNode text = new IIOMetadataNode("tEXt");
        IIOMetadataNode entry = new IIOMetadataNode("tEXtEntry");
        entry.setAttribute("keyword", key);
        entry.setAttribute("value", value);
        text.appendChild(entry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
        root.appendChild(text);
        meta.mergeTree("javax_imageio_png_1.0", root);
    }

    private static ImageWriter getImageWriter() {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix("png");
        Iterator<ImageWriter> it = ImageIO.getImageWritersBySuffix("png");
        while (it.hasNext()) {
            ImageWriter imagewriter = iterator.next();
            Log.debug("PngIOMetadata countImageWriter = " + it.next());
            if (!imagewriter.getClass().getName().equals("com.sun.imageio.plugins.png.PNGImageWriter")) continue;
            Log.debug("PngIOMetadata Found sun PNGImageWriter");
            return imagewriter;
        }
        Log.debug("Using first one");
        return ImageIO.getImageWritersBySuffix("png").next();
    }
}

