/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.sequencediagram.Englober;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalNewpage;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeLine;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.Page;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class DrawableSet {
    private final Map<Participant, LivingParticipantBox> participants = new LinkedHashMap<Participant, LivingParticipantBox>();
    private final Map<Event, GraphicalElement> events = new HashMap<Event, GraphicalElement>();
    private final Map<Participant, ParticipantEnglober> participantEnglobers2 = new LinkedHashMap<Participant, ParticipantEnglober>();
    private final List<Event> eventsList = new ArrayList<Event>();
    private final Rose skin;
    private final ISkinParam skinParam;
    private Dimension2D dimension;
    private double topStartingY;
    private static final int MARGIN_FOR_ENGLOBERS = 4;
    private static final int MARGIN_FOR_ENGLOBERS1 = 2;

    DrawableSet(Rose skin, ISkinParam skinParam) {
        if (skin == null) {
            throw new IllegalArgumentException();
        }
        if (skinParam == null) {
            throw new IllegalArgumentException();
        }
        this.skin = skin;
        this.skinParam = skinParam;
    }

    public ParticipantBox getVeryfirst() {
        return this.participants.values().iterator().next().getParticipantBox();
    }

    public final Rose getSkin() {
        return this.skin;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public Collection<Event> getAllEvents() {
        return Collections.unmodifiableCollection(this.eventsList);
    }

    public Set<Participant> getAllParticipants() {
        return Collections.unmodifiableSet(this.participants.keySet());
    }

    public Collection<LivingParticipantBox> getAllLivingParticipantBox() {
        return Collections.unmodifiableCollection(this.participants.values());
    }

    public Collection<GraphicalElement> getAllGraphicalElements() {
        ArrayList<GraphicalElement> result = new ArrayList<GraphicalElement>();
        for (Event ev : this.eventsList) {
            result.add(this.events.get(ev));
        }
        return Collections.unmodifiableCollection(result);
    }

    public LivingParticipantBox getLivingParticipantBox(Participant p) {
        return this.participants.get(p);
    }

    public GraphicalElement getEvent(Event ev) {
        return this.events.get(ev);
    }

    public double getHeadHeight(StringBounder stringBounder) {
        double r = 0.0;
        for (Participant p : this.participants.keySet()) {
            double y = this.getHeadAndEngloberHeight(p, stringBounder);
            r = Math.max(r, y);
        }
        return r;
    }

    public double getHeadAndEngloberHeight(Participant p, StringBounder stringBounder) {
        LivingParticipantBox box = this.participants.get(p);
        double height = box.getParticipantBox().getHeadHeight(stringBounder);
        Englober englober = this.getParticipantEnglober(p, stringBounder);
        if (englober == null) {
            return height;
        }
        Component comp = this.skin.createComponent(englober.getUsedStyles(), ComponentType.ENGLOBER, null, this.skinParam, englober.getParticipantEnglober().getTitle());
        double heightEnglober = comp.getPreferredHeight(stringBounder);
        return height + heightEnglober;
    }

    public List<Englober> getExistingParticipantEnglober(StringBounder stringBounder) {
        ArrayList<Englober> result = new ArrayList<Englober>();
        Englober pending = null;
        for (Map.Entry<Participant, ParticipantEnglober> ent : this.participantEnglobers2.entrySet()) {
            ParticipantEnglober englober = ent.getValue();
            if (englober == null) {
                pending = null;
                continue;
            }
            assert (englober != null);
            if (pending != null && englober == pending.getParticipantEnglober()) {
                pending.add(ent.getKey());
                continue;
            }
            pending = Englober.createPuma(englober, ent.getKey(), this.getSkinParam(), this.skin, stringBounder, this.skinParam.getCurrentStyleBuilder());
            result.add(pending);
        }
        return Collections.unmodifiableList(result);
    }

    public double getOffsetForEnglobers(StringBounder stringBounder) {
        double result = 0.0;
        for (Englober englober : this.getExistingParticipantEnglober(stringBounder)) {
            Component comp = this.skin.createComponent(null, ComponentType.ENGLOBER, null, this.skinParam, englober.getParticipantEnglober().getTitle());
            double height = comp.getPreferredHeight(stringBounder);
            if (!(height > result)) continue;
            result = height;
        }
        return result;
    }

    public double getTailHeight(StringBounder stringBounder, boolean showTail) {
        double marginForEnglobers;
        double d = marginForEnglobers = this.getExistingParticipantEnglober(stringBounder).size() > 0 ? 4.0 : 0.0;
        if (!showTail) {
            return 1.0 + marginForEnglobers;
        }
        double r = 0.0;
        for (LivingParticipantBox livingParticipantBox : this.participants.values()) {
            double y = livingParticipantBox.getParticipantBox().getTailHeight(stringBounder);
            r = Math.max(r, y);
        }
        return r + marginForEnglobers;
    }

    public void addParticipant(Participant p, ParticipantEnglober participantEnglober) {
        this.participants.put(p, null);
        this.participantEnglobers2.put(p, participantEnglober);
    }

    public void setLivingParticipantBox(Participant p, LivingParticipantBox box) {
        if (!this.participants.containsKey(p)) {
            throw new IllegalArgumentException();
        }
        this.participants.put(p, box);
    }

    public void addEvent(Event event, GraphicalElement object) {
        if (!this.events.keySet().contains(event)) {
            this.eventsList.add(event);
        }
        this.events.put(event, object);
    }

    public void addEvent(Newpage newpage, GraphicalNewpage object, Event justBefore) {
        int idx = this.eventsList.indexOf(justBefore);
        if (idx == -1) {
            throw new IllegalArgumentException();
        }
        this.eventsList.add(idx, newpage);
        this.events.put(newpage, object);
        assert (this.events.size() == this.eventsList.size());
    }

    void setDimension(Dimension2D dim) {
        if (this.dimension != null) {
            throw new IllegalStateException();
        }
        this.dimension = dim;
    }

    public Dimension2D getDimension() {
        return this.dimension;
    }

    TextBlock asTextBlock(final double delta, final double width, final Page page, final boolean showTail) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                DrawableSet.this.drawU22(ug, delta, width, page, showTail);
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double height = page.getHeight();
                return new Dimension2DDouble(width, height);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                throw new UnsupportedOperationException();
            }
        };
    }

    void drawU22(UGraphic ug, double delta, double width, Page page, boolean showTail) {
        double height = page.getHeight();
        UGraphic ugTranslated = this.clipAndTranslate2(delta, width, page, ug);
        SimpleContext2D context = new SimpleContext2D(true);
        this.drawEnglobers(ug, height - 2.0, context);
        this.drawPlaygroundU(ugTranslated, context);
        this.drawLineU22(ug, showTail, page);
        this.drawHeadTailU(ug, page, showTail ? height - this.getTailHeight(ug.getStringBounder(), true) : 0.0);
        this.drawPlaygroundU(ugTranslated, new SimpleContext2D(false));
    }

    private UGraphic clipAndTranslate2(double delta, double width, Page p, UGraphic ug) {
        ug = ug.apply(new UClip(0.0, p.getBodyRelativePosition(), width, p.getBodyHeight() + 1.0));
        ug = ug.apply(this.getTranslate4(delta));
        return ug;
    }

    private UTranslate getTranslate4(double delta) {
        if (delta > 0.0) {
            return UTranslate.dy(-delta);
        }
        return new UTranslate();
    }

    private void drawLineU22(UGraphic ug, boolean showTail, Page page) {
        boolean isTxt = ug instanceof UGraphicTxt;
        for (LivingParticipantBox box : this.getAllLivingParticipantBox()) {
            double create = box.getCreate();
            double startMin = page.getBodyRelativePosition() - box.magicMargin(ug.getStringBounder());
            double endMax = startMin + page.getBodyHeight() + 2.0 * box.magicMargin(ug.getStringBounder());
            double start = startMin;
            if (create > 0.0) {
                if (create > page.getNewpage2()) continue;
                if (create >= page.getNewpage1() && create < page.getNewpage2()) {
                    start = isTxt ? (double)((int)create) : (start += create - page.getNewpage1() + 2.0 * box.magicMargin(ug.getStringBounder()));
                }
            }
            double myDelta = page.getNewpage1() - page.getHeaderHeight();
            box.drawLineU22(ug, start, endMax, showTail, myDelta);
        }
    }

    private void drawHeadTailU(UGraphic ug, Page page, double positionTail) {
        for (Map.Entry<Participant, LivingParticipantBox> ent : this.participants.entrySet()) {
            Url url;
            Participant p = ent.getKey();
            LivingParticipantBox box = ent.getValue();
            double create = box.getCreate();
            boolean showHead = true;
            if (create > 0.0) {
                if (create > page.getNewpage2()) continue;
                if (create >= page.getNewpage1() && create < page.getNewpage2()) {
                    showHead = false;
                }
            }
            if ((url = p.getUrl()) != null) {
                ug.startUrl(url);
            }
            box.getParticipantBox().drawHeadTailU(ug, this.topStartingY, showHead, positionTail);
            if (url == null) continue;
            ug.closeUrl();
        }
    }

    private double getMaxX() {
        return this.dimension.getWidth();
    }

    private double getMaxY() {
        return this.dimension.getHeight();
    }

    private void drawPlaygroundU(UGraphic ug, Context2D context) {
        for (Participant p : this.getAllParticipants()) {
            this.drawLifeLineU(ug, p);
        }
        for (GraphicalElement element : this.getAllGraphicalElements()) {
            element.drawU(ug, this.getMaxX(), context);
        }
    }

    private void drawEnglobers(UGraphic ug, double height, Context2D context) {
        for (Englober englober : this.getExistingParticipantEnglober(ug.getStringBounder())) {
            Dimension2DDouble dim;
            double x1 = this.getX1(englober);
            double x2 = this.getX2(ug.getStringBounder(), englober);
            Component comp = this.getEngloberComponent(englober);
            double width = x2 - x1;
            double preferedWidth = this.getEngloberPreferedWidth(ug.getStringBounder(), englober);
            if (preferedWidth > width) {
                dim = new Dimension2DDouble(preferedWidth, height);
                comp.drawU(ug.apply(new UTranslate(x1 -= (preferedWidth - width) / 2.0, 1.0)), new Area(dim), context);
                continue;
            }
            dim = new Dimension2DDouble(width, height);
            comp.drawU(ug.apply(new UTranslate(x1, 1.0)), new Area(dim), context);
        }
    }

    public double getEngloberPreferedWidth(StringBounder stringBounder, Englober englober) {
        return this.getEngloberComponent(englober).getPreferredWidth(stringBounder);
    }

    private Component getEngloberComponent(Englober englober) {
        ParticipantEnglober participantEnglober = englober.getParticipantEnglober();
        ISkinParam s = participantEnglober.getBoxColor() == null ? this.skinParam : new SkinParamBackcolored(this.skinParam, participantEnglober.getBoxColor());
        return this.skin.createComponent(englober.getUsedStyles(), ComponentType.ENGLOBER, null, s, participantEnglober.getTitle());
    }

    public double getX1(Englober englober) {
        Participant first = englober.getFirst2TOBEPRIVATE();
        ParticipantBox firstBox = this.participants.get(first).getParticipantBox();
        return firstBox.getStartingX() + 1.0;
    }

    public double getX2(StringBounder stringBounder, Englober englober) {
        Participant last = englober.getLast2TOBEPRIVATE();
        ParticipantBox lastBox = this.participants.get(last).getParticipantBox();
        return lastBox.getMaxX(stringBounder) - 1.0;
    }

    private void drawLifeLineU(UGraphic ug, Participant p) {
        LifeLine line = this.getLivingParticipantBox(p).getLifeLine();
        line.finish(this.getMaxY());
        line.drawU(ug, this.getSkin(), this.skinParam);
    }

    private Englober getParticipantEnglober(Participant p, StringBounder stringBounder) {
        for (Englober pe : this.getExistingParticipantEnglober(stringBounder)) {
            if (!pe.contains(p)) continue;
            return pe;
        }
        return null;
    }

    public void setTopStartingY(double topStartingY) {
        this.topStartingY = topStartingY;
    }

    Participant getFirst(Collection<Participant> someParticipants) {
        ArrayList<Participant> list = new ArrayList<Participant>(this.participants.keySet());
        int min = -1;
        for (Participant p : someParticipants) {
            int n = list.indexOf(p);
            assert (n != -1);
            if (min != -1 && min <= n) continue;
            min = n;
        }
        return (Participant)list.get(min);
    }

    Participant getLast(Collection<Participant> someParticipants) {
        ArrayList<Participant> list = new ArrayList<Participant>(this.participants.keySet());
        int max = -1;
        for (Participant p : someParticipants) {
            int n = list.indexOf(p);
            assert (n != -1);
            if (max != -1 && max >= n) continue;
            max = n;
        }
        return (Participant)list.get(max);
    }

    public double getArrowThickness() {
        UStroke result = this.skinParam.getThickness(LineParam.sequenceArrow, null);
        if (result == null) {
            return 1.0;
        }
        return result.getThickness();
    }
}

