/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PlayerFrame {
    private final TextBlock title;

    public PlayerFrame(TextBlock title) {
        this.title = title;
    }

    public void drawFrameTitle(UGraphic ug) {
        this.title.drawU(ug);
        Dimension2D dimTitle = this.title.calculateDimension(ug.getStringBounder());
        ug = ug.apply(HColorUtils.BLACK).apply(new UStroke(1.0));
        double widthTmp = dimTitle.getWidth() + 1.0;
        double height = this.title.calculateDimension(ug.getStringBounder()).getHeight() + 1.0;
        this.drawLine(ug, -5.0, height, widthTmp, height, widthTmp + 10.0, 0.0);
    }

    private void drawLine(UGraphic ug, double ... coord) {
        for (int i = 0; i < coord.length - 2; i += 2) {
            double x1 = coord[i];
            double y1 = coord[i + 1];
            double x2 = coord[i + 2];
            double y2 = coord[i + 3];
            ug.apply(new UTranslate(x1, y1)).draw(new ULine(x2 - x1, y2 - y1));
        }
    }
}

