/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.smtp;

import gnu.inet.smtp.Parameter;
import gnu.inet.smtp.ParameterList;
import gnu.inet.smtp.SMTPConnection;
import gnu.inet.util.BASE64;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.net.ssl.TrustManager;

public class SMTPTransport
extends Transport {
    protected SMTPConnection connection;
    protected String localHostName = this.getProperty("localhost");
    private List extensions = null;
    private List authenticationMechanisms = null;

    public SMTPTransport(Session session, URLName urlName) {
        super(session, urlName);
        if (this.localHostName == null) {
            try {
                this.localHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.localHostName = "localhost";
            }
        }
    }

    protected boolean protocolConnect(String host, int port, String username, String password) throws MessagingException {
        if (this.connection != null) {
            return true;
        }
        if (host == null) {
            host = this.getProperty("host");
        }
        if (port < 0) {
            port = this.getIntProperty("port");
        }
        if (username == null) {
            username = this.getProperty("user");
        }
        if (host == null) {
            host = "localhost";
        }
        try {
            int connectionTimeout = this.getIntProperty("connectiontimeout");
            int timeout = this.getIntProperty("timeout");
            if (this.session.getDebug()) {
                SMTPConnection.logger.setLevel(SMTPConnection.SMTP_TRACE);
            }
            boolean tls = "stmps".equals(this.url.getProtocol());
            TrustManager tm = null;
            if (tls) {
                tm = this.getTrustManager();
            }
            this.connection = new SMTPConnection(host, port, connectionTimeout, timeout, tls, tm);
            if (this.propertyIsFalse("ehlo")) {
                if (!this.connection.helo(this.localHostName)) {
                    throw new MessagingException("HELO failed: " + this.connection.getLastResponse());
                }
            } else {
                this.extensions = this.connection.ehlo(this.localHostName);
                if (this.extensions == null) {
                    if (!this.connection.helo(this.localHostName)) {
                        throw new MessagingException("HELO failed: " + this.connection.getLastResponse());
                    }
                } else {
                    if (!tls && this.extensions.contains("STARTTLS") && !this.propertyIsFalse("tls") && (tls = (tm = this.getTrustManager()) == null ? this.connection.starttls() : this.connection.starttls(tm))) {
                        this.extensions = this.connection.ehlo(this.localHostName);
                    }
                    if (!tls && "required".equals(this.getProperty("tls"))) {
                        throw new MessagingException("TLS not available");
                    }
                    for (String extension : this.extensions) {
                        if (!extension.startsWith("AUTH ")) continue;
                        String m = extension.substring(5);
                        this.authenticationMechanisms = Collections.list(new StringTokenizer(m));
                    }
                }
            }
            String auth = this.getProperty("auth");
            boolean authRequired = "required".equals(auth);
            if (this.authenticationMechanisms == null || this.authenticationMechanisms.isEmpty()) {
                return !authRequired;
            }
            if (authRequired || this.propertyIsTrue("auth")) {
                if (username == null || password == null) {
                    PasswordAuthentication pa = this.session.getPasswordAuthentication(this.url);
                    if (pa == null) {
                        InetAddress addr = InetAddress.getByName(host);
                        pa = this.session.requestPasswordAuthentication(addr, port, this.url.getProtocol(), null, null);
                    }
                    if (pa != null) {
                        username = pa.getUserName();
                        password = pa.getPassword();
                    }
                }
                if (username != null && password != null) {
                    String authPrefs = this.getProperty("auth.mechanisms");
                    Iterator i = null;
                    if (authPrefs == null) {
                        i = this.authenticationMechanisms.iterator();
                    } else {
                        ArrayList<Object> authPrefList = Collections.list(new StringTokenizer(authPrefs, ","));
                        i = authPrefList.iterator();
                    }
                    while (i.hasNext()) {
                        String mechanism = (String)i.next();
                        if (!this.authenticationMechanisms.contains(mechanism) || !this.connection.authenticate(mechanism, username, password)) continue;
                        return true;
                    }
                } else if (this.session.getDebug()) {
                    this.debugWarning("server requested AUTH, but authentication principal and credentials are not available");
                }
                return false;
            }
            if (this.session.getDebug()) {
                this.debugWarning("server requested AUTH, but authentication is not enabled");
            }
            return !authRequired;
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    private TrustManager getTrustManager() throws MessagingException {
        String tmt = this.getProperty("trustmanager");
        if (tmt != null) {
            try {
                Class<?> t = Class.forName(tmt);
                return (TrustManager)t.newInstance();
            }
            catch (Exception e) {
                throw new MessagingException(e.getMessage(), e);
            }
        }
        return null;
    }

    private void debugWarning(String warning) {
        System.err.println(this.url.getProtocol() + ": WARNING: " + warning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGreeting() throws MessagingException {
        if (!this.isConnected()) {
            throw new MessagingException("not connected");
        }
        SMTPConnection sMTPConnection = this.connection;
        synchronized (sMTPConnection) {
            return this.connection.getGreeting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message message, Address[] addresses) throws MessagingException, SendFailedException {
        if (!this.isConnected()) {
            throw new MessagingException("not connected");
        }
        if (!(message instanceof MimeMessage)) {
            throw new SendFailedException("only MimeMessages are supported");
        }
        MimeMessage mimeMessage = (MimeMessage)message;
        int len = addresses.length;
        ArrayList<Address> sent = new ArrayList<Address>(len);
        ArrayList<Address> unsent = new ArrayList<Address>(len);
        ArrayList<Address> invalid = new ArrayList<Address>(len);
        int deliveryStatus = 2;
        ParameterList params = null;
        SMTPConnection sMTPConnection = this.connection;
        synchronized (sMTPConnection) {
            try {
                String mtrk;
                Address[] from2;
                InternetAddress[] from1;
                String from0 = this.getProperty("from");
                InternetAddress from = null;
                if (from0 != null && (from1 = InternetAddress.parse((String)from0)) != null && from1.length > 0) {
                    from = from1[0];
                }
                if (from == null && (from2 = mimeMessage.getFrom()) != null && from2.length > 0 && from2[0] instanceof InternetAddress) {
                    from = (InternetAddress)from2[0];
                }
                if (from == null) {
                    from = InternetAddress.getLocalAddress((Session)this.session);
                }
                String reversePath = from.getAddress();
                String dsnRet = this.getProperty("dsn.ret");
                if (dsnRet != null && this.extensions != null && this.extensions.contains("DSN")) {
                    String FULL = "FULL";
                    String HDRS = "HDRS";
                    String value = null;
                    if (FULL.equalsIgnoreCase(dsnRet)) {
                        value = FULL;
                    } else if (HDRS.equalsIgnoreCase(dsnRet)) {
                        value = HDRS;
                    }
                    if (value != null) {
                        if (params == null) {
                            params = new ParameterList();
                        }
                        params.add(new Parameter("RET", value));
                    }
                }
                if ("true".equals(mtrk = this.getProperty("mtrk")) && this.extensions != null && this.extensions.contains("MTRK")) {
                    int mtrkTimeout = 0;
                    String mt = this.getProperty("mtrk.timeout");
                    if (mt != null) {
                        mtrkTimeout = Integer.parseInt(mt);
                    }
                    try {
                        Random r = new Random();
                        byte[] a = new byte[256];
                        r.nextBytes(a);
                        MessageDigest md = MessageDigest.getInstance("SHA-1");
                        md.update(a);
                        byte[] b = md.digest();
                        byte[] certifier = BASE64.encode((byte[])b);
                        if (params == null) {
                            params = new ParameterList();
                        }
                        Object value = new String(certifier, "US-ASCII");
                        if (mtrkTimeout > 0) {
                            value = (String)value + ":" + mtrkTimeout;
                        }
                        params.add(new Parameter("MTRK", (String)value));
                        Object envid = mimeMessage.getMessageID();
                        if (envid != null) {
                            int ai = ((String)envid).indexOf(64);
                            if (ai != -1) {
                                envid = ((String)envid).substring(0, ai);
                            }
                        } else {
                            envid = "";
                        }
                        envid = (String)envid + Long.toHexString(System.currentTimeMillis());
                        envid = (String)envid + "@";
                        String lha = InetAddress.getLocalHost().getHostAddress();
                        if (((String)envid).length() + lha.length() > 100) {
                            b = lha.getBytes("UTF-8");
                            md.reset();
                            md.update(b);
                            b = md.digest();
                            b = BASE64.encode((byte[])b);
                            lha = new String(b, "US-ASCII");
                        }
                        envid = (String)envid + lha;
                        params.add(new Parameter("ENVID", (String)envid));
                    }
                    catch (NoSuchAlgorithmException e) {
                        MessagingException e2 = new MessagingException(e.getMessage());
                        e2.initCause((Throwable)e);
                        throw e2;
                    }
                    catch (UnsupportedEncodingException e) {
                        MessagingException e2 = new MessagingException(e.getMessage());
                        e2.initCause((Throwable)e);
                        throw e2;
                    }
                }
                if (!this.connection.mailFrom(reversePath, params)) {
                    throw new SendFailedException(this.connection.getLastResponse());
                }
                params = null;
                String dsnNotify = this.getProperty("dsn.notify");
                if (dsnNotify != null && this.extensions != null && this.extensions.contains("DSN")) {
                    String NEVER = "NEVER";
                    String SUCCESS = "SUCCESS";
                    String FAILURE = "FAILURE";
                    String DELAY = "DELAY";
                    String value = null;
                    if (NEVER.equalsIgnoreCase(dsnNotify)) {
                        value = NEVER;
                    } else {
                        StringBuffer buf = new StringBuffer();
                        StringTokenizer st = new StringTokenizer(dsnNotify, " ,");
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            if (SUCCESS.equalsIgnoreCase(token)) {
                                if (buf.length() > 0) {
                                    buf.append(',');
                                }
                                buf.append(SUCCESS);
                                continue;
                            }
                            if (FAILURE.equalsIgnoreCase(token)) {
                                if (buf.length() > 0) {
                                    buf.append(',');
                                }
                                buf.append(FAILURE);
                                continue;
                            }
                            if (!DELAY.equalsIgnoreCase(token)) continue;
                            if (buf.length() > 0) {
                                buf.append(',');
                            }
                            buf.append(DELAY);
                        }
                        if (buf.length() > 0) {
                            value = buf.toString();
                        }
                    }
                    if (value != null) {
                        params = new ParameterList();
                        params.add(new Parameter("NOTIFY", value));
                    }
                }
                for (int i = 0; i < addresses.length; ++i) {
                    Address address = addresses[i];
                    if (address instanceof InternetAddress) {
                        String forwardPath = ((InternetAddress)address).getAddress();
                        if (this.connection.rcptTo(forwardPath, params)) {
                            sent.add(address);
                            continue;
                        }
                        invalid.add(address);
                        continue;
                    }
                    invalid.add(address);
                }
            }
            catch (IOException e) {
                try {
                    this.connection.rset();
                }
                catch (IOException from) {
                    // empty catch block
                }
                throw new SendFailedException(e.getMessage());
            }
            if (sent.size() > 0) {
                try {
                    OutputStream dataStream = this.connection.data();
                    if (dataStream == null) {
                        String msg = this.connection.getLastResponse();
                        throw new MessagingException(msg);
                    }
                    mimeMessage.writeTo(dataStream);
                    dataStream.flush();
                    if (!this.connection.finishData()) {
                        unsent.addAll(sent);
                        sent.clear();
                        deliveryStatus = 2;
                    } else {
                        deliveryStatus = invalid.isEmpty() ? 1 : 3;
                    }
                }
                catch (IOException e) {
                    try {
                        if (this.connection.finishData()) {
                            this.connection.rset();
                        }
                    }
                    catch (IOException msg) {
                        // empty catch block
                    }
                    throw new SendFailedException(e.getMessage());
                }
            }
        }
        Address[] a_sent = new Address[sent.size()];
        sent.toArray(a_sent);
        Address[] a_unsent = new Address[unsent.size()];
        unsent.toArray(a_unsent);
        Address[] a_invalid = new Address[invalid.size()];
        invalid.toArray(a_invalid);
        this.notifyTransportListeners(deliveryStatus, a_sent, a_unsent, a_invalid, (Message)mimeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MessagingException {
        if (this.isConnected()) {
            SMTPConnection sMTPConnection = this.connection;
            synchronized (sMTPConnection) {
                try {
                    this.connection.quit();
                }
                catch (IOException e) {
                    throw new MessagingException(e.getMessage(), (Exception)e);
                }
                finally {
                    this.connection = null;
                }
            }
        }
        super.close();
    }

    private int getIntProperty(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    private boolean propertyIsFalse(String key) {
        return "false".equals(this.getProperty(key));
    }

    private boolean propertyIsTrue(String key) {
        return "true".equals(this.getProperty(key));
    }

    private String getProperty(String key) {
        String value = this.session.getProperty("mail." + this.url.getProtocol() + "." + key);
        if (value == null) {
            value = this.session.getProperty("mail." + key);
        }
        return value;
    }
}

