/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.algorithms.implementations;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithmSpi;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Base64;

public class SignatureDSA
extends SignatureAlgorithmSpi {
    public static final String URI = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private static final Logger LOG = LoggerFactory.getLogger(SignatureDSA.class);
    private Signature signatureAlgorithm;
    private int size;

    @Override
    protected String engineGetURI() {
        return URI;
    }

    public SignatureDSA() throws XMLSignatureException {
        String string = JCEMapper.translateURItoJCEID(this.engineGetURI());
        LOG.debug("Created SignatureDSA using {}", string);
        String string2 = JCEMapper.getProviderId();
        try {
            this.signatureAlgorithm = string2 == null ? Signature.getInstance(string) : Signature.getInstance(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[]{string, noSuchAlgorithmException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            Object[] objectArray = new Object[]{string, noSuchProviderException.getLocalizedMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", objectArray);
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.setParameter(algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException(invalidAlgorithmParameterException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws XMLSignatureException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Called DSA.verify() on " + Base64.getMimeEncoder().encodeToString(byArray));
            }
            byte[] byArray2 = JavaUtils.convertDsaXMLDSIGtoASN1(byArray, this.size / 8);
            return this.signatureAlgorithm.verify(byArray2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException(iOException);
        }
    }

    @Override
    protected void engineInitVerify(Key key) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            String string = null;
            if (key != null) {
                string = key.getClass().getName();
            }
            String string2 = PublicKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            this.signatureAlgorithm.initVerify((PublicKey)key);
        }
        catch (InvalidKeyException invalidKeyException) {
            Signature signature = this.signatureAlgorithm;
            try {
                this.signatureAlgorithm = Signature.getInstance(this.signatureAlgorithm.getAlgorithm());
            }
            catch (Exception exception) {
                LOG.debug("Exception when reinstantiating Signature: {}", exception);
                this.signatureAlgorithm = signature;
            }
            throw new XMLSignatureException(invalidKeyException);
        }
        this.size = ((DSAKey)((Object)key)).getParams().getQ().bitLength();
    }

    @Override
    protected byte[] engineSign() throws XMLSignatureException {
        try {
            byte[] byArray = this.signatureAlgorithm.sign();
            return JavaUtils.convertDsaASN1toXMLDSIG(byArray, this.size / 8);
        }
        catch (IOException iOException) {
            throw new XMLSignatureException(iOException);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineInitSign(Key key, SecureRandom secureRandom) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            String string = null;
            if (key != null) {
                string = key.getClass().getName();
            }
            String string2 = PrivateKey.class.getName();
            Object[] objectArray = new Object[]{string, string2};
            throw new XMLSignatureException("algorithms.WrongKeyForThisOperation", objectArray);
        }
        try {
            if (secureRandom == null) {
                this.signatureAlgorithm.initSign((PrivateKey)key);
            } else {
                this.signatureAlgorithm.initSign((PrivateKey)key, secureRandom);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        this.size = ((DSAKey)((Object)key)).getParams().getQ().bitLength();
    }

    @Override
    protected void engineInitSign(Key key) throws XMLSignatureException {
        this.engineInitSign(key, (SecureRandom)null);
    }

    @Override
    protected void engineUpdate(byte[] byArray) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(byArray);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineUpdate(byte by) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(by);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws XMLSignatureException {
        try {
            this.signatureAlgorithm.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    @Override
    protected String engineGetJCEAlgorithmString() {
        return this.signatureAlgorithm.getAlgorithm();
    }

    @Override
    protected String engineGetJCEProviderName() {
        return this.signatureAlgorithm.getProvider().getName();
    }

    @Override
    protected void engineSetHMACOutputLength(int n) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.HMACOutputLengthOnlyForHMAC");
    }

    @Override
    protected void engineInitSign(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        throw new XMLSignatureException("algorithms.CannotUseAlgorithmParameterSpecOnDSA");
    }

    public static class SHA256
    extends SignatureDSA {
        @Override
        public String engineGetURI() {
            return "http://www.w3.org/2009/xmldsig11#dsa-sha256";
        }
    }
}

