/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLWriter;

public class FixedHTMLWriter
extends HTMLWriter {
    private final MutableAttributeSet convAttr = new SimpleAttributeSet();

    public FixedHTMLWriter(Writer writer, HTMLDocument doc) {
        this(writer, doc, 0, doc.getLength());
    }

    public FixedHTMLWriter(Writer writer, HTMLDocument doc, int pos, int len) {
        super(writer, doc, pos, len);
    }

    private static void convertToHTML(AttributeSet from, MutableAttributeSet to) {
        if (from == null) {
            return;
        }
        Enumeration<?> keys = from.getAttributeNames();
        String value = "";
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (key instanceof CSS.Attribute) {
                if (value.length() > 0) {
                    value = value + "; ";
                }
                value = value + key + ": " + from.getAttribute(key);
                continue;
            }
            to.addAttribute(key, from.getAttribute(key));
        }
        if (value.length() > 0) {
            to.addAttribute(HTML.Attribute.STYLE, value);
        }
    }

    @Override
    protected void writeAttributes(AttributeSet attr) throws IOException {
        Element elem;
        if (attr instanceof Element && ((elem = (Element)((Object)attr)).isLeaf() || elem.getName().equalsIgnoreCase("p-implied"))) {
            super.writeAttributes(attr);
            return;
        }
        this.convAttr.removeAttributes(this.convAttr);
        FixedHTMLWriter.convertToHTML(attr, this.convAttr);
        Enumeration<?> names = this.convAttr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            if (name instanceof HTML.Tag || name instanceof StyleConstants || name == HTML.Attribute.ENDTAG) continue;
            this.write(" " + name + "=\"" + this.convAttr.getAttribute(name) + "\"");
        }
    }
}

