/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.JsIterables;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.BooleanLiteralSet;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import com.google.javascript.rhino.jstype.TemplateTypeReplacer;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

final class AstFactory {
    private static final Splitter DOT_SPLITTER = Splitter.on(".");
    @Nullable
    private final JSTypeRegistry registry;
    private final JSType unknownType;
    private final Supplier<JSType> argumentsTypeSupplier;

    private AstFactory() {
        this.registry = null;
        this.unknownType = null;
        this.argumentsTypeSupplier = () -> null;
    }

    private AstFactory(JSTypeRegistry registry) {
        this.registry = registry;
        this.unknownType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        this.argumentsTypeSupplier = Suppliers.memoize(() -> {
            JSType globalType = registry.getGlobalType("Arguments");
            if (globalType != null) {
                return globalType;
            }
            return this.unknownType;
        });
    }

    static AstFactory createFactoryWithoutTypes() {
        return new AstFactory();
    }

    static AstFactory createFactoryWithTypes(JSTypeRegistry registry) {
        return new AstFactory(registry);
    }

    boolean isAddingTypes() {
        return this.registry != null;
    }

    Node exprResult(Node expr) {
        return IR.exprResult(expr).srcref(expr);
    }

    Node createEmpty() {
        return IR.empty();
    }

    Node createBlock(Node ... statements) {
        return IR.block(statements);
    }

    Node createIf(Node cond, Node then) {
        return IR.ifNode(cond, then);
    }

    Node createIf(Node cond, Node then, Node elseNode) {
        return IR.ifNode(cond, then, elseNode);
    }

    Node createFor(Node init, Node cond, Node incr, Node body) {
        return IR.forNode(init, cond, incr, body);
    }

    Node createBreak() {
        return IR.breakNode();
    }

    Node createReturn(Node value) {
        return IR.returnNode(value);
    }

    Node createYield(JSType jsType, Node value) {
        Node result = IR.yield(value);
        if (this.isAddingTypes()) {
            result.setJSType(Preconditions.checkNotNull(jsType));
        }
        return result;
    }

    Node createAwait(JSType jsType, Node value) {
        Node result = IR.await(value);
        if (this.isAddingTypes()) {
            result.setJSType(Preconditions.checkNotNull(jsType));
        }
        return result;
    }

    Node createString(String value) {
        Node result = IR.string(value);
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(JSTypeNative.STRING_TYPE));
        }
        return result;
    }

    Node createNumber(double value) {
        Node result = IR.number(value);
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(JSTypeNative.NUMBER_TYPE));
        }
        return result;
    }

    Node createBoolean(boolean value) {
        Node result;
        Node node = result = value ? IR.trueNode() : IR.falseNode();
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
        }
        return result;
    }

    Node createNull() {
        Node result = IR.nullNode();
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(JSTypeNative.NULL_TYPE));
        }
        return result;
    }

    Node createVoid(Node child) {
        Node result = IR.voidNode(child);
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(JSTypeNative.VOID_TYPE));
        }
        return result;
    }

    public Node createUndefinedValue() {
        return this.createVoid(this.createNumber(0.0));
    }

    Node createCastToUnknown(Node child, JSDocInfo jsdoc) {
        Node result = IR.cast(child, jsdoc);
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
        }
        return result;
    }

    Node createNot(Node child) {
        Node result = IR.not(child);
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
        }
        return result;
    }

    Node createThis(JSType thisType) {
        Node result = IR.thisNode();
        if (this.isAddingTypes()) {
            result.setJSType(Preconditions.checkNotNull(thisType));
        }
        return result;
    }

    Node createSuper(JSType superType) {
        Node result = IR.superNode();
        if (this.isAddingTypes()) {
            result.setJSType(Preconditions.checkNotNull(superType));
        }
        return result;
    }

    Node createThisForFunction(Node functionNode) {
        Node result = IR.thisNode();
        if (this.isAddingTypes()) {
            result.setJSType(this.getTypeOfThisForFunctionNode(functionNode));
        }
        return result;
    }

    Node createSuperForFunction(Node functionNode) {
        Node result = IR.superNode();
        if (this.isAddingTypes()) {
            result.setJSType(this.getTypeOfSuperForFunctionNode(functionNode));
        }
        return result;
    }

    @Nullable
    private JSType getTypeOfThisForFunctionNode(Node functionNode) {
        if (this.isAddingTypes()) {
            FunctionType functionType = this.getFunctionType(functionNode);
            return Preconditions.checkNotNull(functionType.getTypeOfThis(), functionType);
        }
        return null;
    }

    @Nullable
    private JSType getTypeOfSuperForFunctionNode(Node functionNode) {
        if (this.isAddingTypes()) {
            ObjectType thisType = this.getTypeOfThisForFunctionNode(functionNode).assertObjectType();
            return Preconditions.checkNotNull(thisType.getSuperClassConstructor().getInstanceType(), thisType);
        }
        return null;
    }

    private FunctionType getFunctionType(Node functionNode) {
        Preconditions.checkState(functionNode.isFunction(), "not a function: %s", (Object)functionNode);
        JSType typeBeforeCast = functionNode.getJSTypeBeforeCast();
        FunctionType functionType = typeBeforeCast != null ? typeBeforeCast.assertFunctionType() : functionNode.getJSTypeRequired().assertFunctionType();
        return functionType;
    }

    Node createThisAliasReferenceForFunction(String aliasName, Node functionNode) {
        Node result = IR.name(aliasName);
        if (this.isAddingTypes()) {
            result.setJSType(this.getTypeOfThisForFunctionNode(functionNode));
        }
        return result;
    }

    Node createThisAliasDeclarationForFunction(String aliasName, Node functionNode) {
        return this.createSingleConstNameDeclaration(aliasName, this.createThis(this.getTypeOfThisForFunctionNode(functionNode)));
    }

    Node createSingleLetNameDeclaration(String variableName) {
        return IR.let(this.createName(variableName, JSTypeNative.VOID_TYPE));
    }

    Node createSingleVarNameDeclaration(String variableName) {
        return IR.var(this.createName(variableName, JSTypeNative.VOID_TYPE));
    }

    Node createSingleVarNameDeclaration(String variableName, Node value) {
        return IR.var(this.createName(variableName, value.getJSType()), value);
    }

    Node createSingleConstNameDeclaration(String variableName, Node value) {
        return IR.constNode(this.createName(variableName, value.getJSType()), value);
    }

    Node createArgumentsReference() {
        Node result = IR.name("arguments");
        if (this.isAddingTypes()) {
            result.setJSType(this.argumentsTypeSupplier.get());
        }
        return result;
    }

    Node createArgumentsAliasDeclaration(String aliasName) {
        return this.createSingleConstNameDeclaration(aliasName, this.createArgumentsReference());
    }

    Node createName(String name, JSType type) {
        Node result = IR.name(name);
        if (this.isAddingTypes()) {
            result.setJSType(Preconditions.checkNotNull(type));
        }
        return result;
    }

    Node createName(String name, JSTypeNative nativeType) {
        Node result = IR.name(name);
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(nativeType));
        }
        return result;
    }

    Node createNameWithUnknownType(String name) {
        return this.createName(name, this.unknownType);
    }

    Node createName(Scope scope, String name) {
        Node result = IR.name(name);
        if (this.isAddingTypes()) {
            result.setJSType(this.getVarNameType(scope, name));
        }
        return result;
    }

    Node createQName(Scope scope, String qname) {
        return this.createQName(scope, DOT_SPLITTER.split(qname));
    }

    Node createQName(TypedScope globalTypedScope, String qname) {
        Preconditions.checkArgument(globalTypedScope == null || globalTypedScope.isGlobal(), globalTypedScope);
        List<String> nameParts = DOT_SPLITTER.splitToList(qname);
        Preconditions.checkState(!nameParts.isEmpty());
        String receiverPart = nameParts.get(0);
        Node receiver = IR.name(receiverPart);
        if (this.isAddingTypes()) {
            TypedVar var = Preconditions.checkNotNull(globalTypedScope.getVar(receiverPart), receiverPart);
            receiver.setJSType(Preconditions.checkNotNull(var.getType(), var));
        }
        List<String> otherParts = nameParts.subList(1, nameParts.size());
        return this.createGetProps(receiver, otherParts);
    }

    Node createQName(Scope scope, Iterable<String> names) {
        String baseName = Preconditions.checkNotNull(Iterables.getFirst(names, null));
        Iterable<String> propertyNames = Iterables.skip(names, 1);
        return this.createQName(scope, baseName, propertyNames);
    }

    Node createQName(Scope scope, String baseName, String ... propertyNames) {
        Preconditions.checkNotNull(baseName);
        return this.createQName(scope, baseName, Arrays.asList(propertyNames));
    }

    Node createQName(Scope scope, String baseName, Iterable<String> propertyNames) {
        Node baseNameNode = this.createName(scope, baseName);
        return this.createGetProps(baseNameNode, propertyNames);
    }

    Node createGetProp(Node receiver, String propertyName) {
        Node result = IR.getprop(receiver, this.createString(propertyName));
        if (this.isAddingTypes()) {
            result.setJSType(this.getJsTypeForProperty(receiver, propertyName));
        }
        return result;
    }

    Node createGetProps(Node receiver, Iterable<String> propertyNames) {
        Node result = receiver;
        for (String propertyName : propertyNames) {
            result = this.createGetProp(result, propertyName);
        }
        return result;
    }

    Node createGetProps(Node receiver, String firstPropName, String ... otherPropNames) {
        Node result = this.createGetProp(receiver, firstPropName);
        for (String propertyName : otherPropNames) {
            result = this.createGetProp(result, propertyName);
        }
        return result;
    }

    Node createGetElem(Node receiver, Node key) {
        Node result = IR.getelem(receiver, key);
        if (this.isAddingTypes()) {
            result.setJSType(this.unknownType);
        }
        return result;
    }

    Node createDelProp(Node target) {
        Node result = IR.delprop(target);
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
        }
        return result;
    }

    Node createStringKey(String key, Node value) {
        Node result = IR.stringKey(key, value);
        if (this.isAddingTypes()) {
            result.setJSType(value.getJSType());
        }
        return result;
    }

    Node createComputedProperty(Node key, Node value) {
        Node result = IR.computedProp(key, value);
        if (this.isAddingTypes()) {
            result.setJSType(value.getJSType());
        }
        return result;
    }

    Node createGetterDef(String name, Node value) {
        JSType returnType = value.getJSType();
        Node functionNode = this.createZeroArgFunction("", IR.block(this.createReturn(value)), returnType);
        Node getterNode = Node.newString(Token.GETTER_DEF, name);
        getterNode.addChildToFront(functionNode);
        return getterNode;
    }

    Node createIn(Node left, Node right) {
        Node result = IR.in(left, right);
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
        }
        return result;
    }

    Node createComma(Node left, Node right) {
        Node result = IR.comma(left, right);
        if (this.isAddingTypes()) {
            result.setJSType(right.getJSType());
        }
        return result;
    }

    Node createCommas(Node first, Node second, Node ... rest) {
        Node result = this.createComma(first, second);
        for (Node next : rest) {
            result = this.createComma(result, next);
        }
        return result;
    }

    Node createAnd(Node left, Node right) {
        Node result = IR.and(left, right);
        if (this.isAddingTypes()) {
            JSType leftType = Preconditions.checkNotNull(left.getJSType(), left);
            JSType rightType = Preconditions.checkNotNull(right.getJSType(), right);
            BooleanLiteralSet possibleLhsBooleanValues = leftType.getPossibleToBooleanOutcomes();
            switch (possibleLhsBooleanValues) {
                case TRUE: {
                    result.setJSType(rightType);
                    break;
                }
                case FALSE: {
                    result.setJSType(leftType);
                    break;
                }
                case BOTH: {
                    result.setJSType(leftType.getLeastSupertype(rightType));
                    break;
                }
                default: {
                    Preconditions.checkState(possibleLhsBooleanValues == BooleanLiteralSet.EMPTY, "unexpected enum value: %s", (Object)possibleLhsBooleanValues);
                    result.setJSType(this.getNativeType(JSTypeNative.NO_TYPE));
                }
            }
        }
        return result;
    }

    Node createOr(Node left, Node right) {
        Node result = IR.or(left, right);
        if (this.isAddingTypes()) {
            JSType leftType = Preconditions.checkNotNull(left.getJSType(), left);
            JSType rightType = Preconditions.checkNotNull(right.getJSType(), right);
            BooleanLiteralSet possibleLhsBooleanValues = leftType.getPossibleToBooleanOutcomes();
            switch (possibleLhsBooleanValues) {
                case TRUE: {
                    result.setJSType(leftType);
                    break;
                }
                case FALSE: {
                    result.setJSType(rightType);
                    break;
                }
                case BOTH: {
                    result.setJSType(leftType.getLeastSupertype(rightType));
                    break;
                }
                default: {
                    Preconditions.checkState(possibleLhsBooleanValues == BooleanLiteralSet.EMPTY, "unexpected enum value: %s", (Object)possibleLhsBooleanValues);
                    result.setJSType(this.getNativeType(JSTypeNative.NO_TYPE));
                }
            }
        }
        return result;
    }

    Node createCall(Node callee, Node ... args) {
        Node result = NodeUtil.newCallNode(callee, args);
        if (this.isAddingTypes()) {
            FunctionType calleeType = JSType.toMaybeFunctionType(callee.getJSType());
            JSType returnType = calleeType != null ? calleeType.getReturnType() : this.unknownType;
            result.setJSType(returnType);
        }
        return result;
    }

    Node createObjectDotAssignCall(Scope scope, JSType returnType, Node ... args) {
        Node objAssign = this.createQName(scope, "Object", "assign");
        Node result = this.createCall(objAssign, args);
        if (this.isAddingTypes()) {
            FunctionType objAssignType = this.registry.createFunctionTypeWithVarArgs(returnType, this.registry.getNativeType(JSTypeNative.OBJECT_TYPE), this.registry.createUnionType(JSTypeNative.OBJECT_TYPE, JSTypeNative.NULL_TYPE));
            objAssign.setJSType(objAssignType);
            result.setJSType(returnType);
        }
        return result;
    }

    Node createNewNode(Node target, Node ... args) {
        Node result = IR.newNode(target, args);
        if (this.isAddingTypes()) {
            JSType instanceType = target.getJSType();
            instanceType = instanceType.isFunctionType() ? instanceType.toMaybeFunctionType().getInstanceType() : this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            result.setJSType(instanceType);
        }
        return result;
    }

    Node createObjectGetPrototypeOfCall(Node argObjectNode) {
        Node objectName = this.createName("Object", JSTypeNative.OBJECT_FUNCTION_TYPE);
        Node objectGetPrototypeOf = this.createGetProp(objectName, "getPrototypeOf");
        Node result = this.createCall(objectGetPrototypeOf, argObjectNode);
        if (this.isAddingTypes()) {
            ObjectType typeOfArgObject = argObjectNode.getJSTypeRequired().assertObjectType();
            ObjectType returnedType = this.getPrototypeObjectType(typeOfArgObject);
            result.setJSType(returnedType);
            objectGetPrototypeOf.setJSType(this.registry.createFunctionType((JSType)returnedType, this.getNativeType(JSTypeNative.OBJECT_TYPE)));
        }
        return result;
    }

    ObjectType getPrototypeObjectType(ObjectType objectType) {
        Preconditions.checkNotNull(objectType);
        if (objectType.isUnknownType()) {
            return objectType;
        }
        return Preconditions.checkNotNull(objectType.getImplicitPrototype(), "null prototype: %s", (Object)objectType);
    }

    Node createConstructorCall(@Nullable JSType classType, Node callee, Node ... args) {
        Node result = NodeUtil.newCallNode(callee, args);
        if (this.isAddingTypes()) {
            Preconditions.checkNotNull(classType);
            FunctionType constructorType = Preconditions.checkNotNull(classType.toMaybeFunctionType());
            ObjectType instanceType = Preconditions.checkNotNull(constructorType.getInstanceType());
            result.setJSType(instanceType);
        }
        return result;
    }

    Node createAssignStatement(Node lhs, Node rhs) {
        return this.exprResult(this.createAssign(lhs, rhs));
    }

    Node createAssign(Node lhs, Node rhs) {
        Node result = IR.assign(lhs, rhs);
        if (this.isAddingTypes()) {
            result.setJSType(rhs.getJSType());
        }
        return result;
    }

    Node createAssign(String lhsName, Node rhs) {
        return this.createAssign(this.createName(lhsName, rhs.getJSType()), rhs);
    }

    Node createObjectLit(Node ... elements) {
        Node result = IR.objectlit(elements);
        if (this.isAddingTypes()) {
            result.setJSType(this.registry.createAnonymousObjectType(null));
        }
        return result;
    }

    Node createObjectLit(@Nullable JSType jsType, Node ... elements) {
        Node result = IR.objectlit(elements);
        if (this.isAddingTypes()) {
            result.setJSType(Preconditions.checkNotNull(jsType));
        }
        return result;
    }

    Node createEmptyFunction(JSType type) {
        Node result = NodeUtil.emptyFunction();
        if (this.isAddingTypes()) {
            Preconditions.checkNotNull(type);
            Preconditions.checkArgument(type.isFunctionType(), type);
            result.setJSType(Preconditions.checkNotNull(type));
        }
        return result;
    }

    Node createEmptyGeneratorFunction(JSType type) {
        Node result = NodeUtil.emptyFunction();
        result.setIsGeneratorFunction(true);
        if (this.isAddingTypes()) {
            Preconditions.checkNotNull(type);
            Preconditions.checkArgument(type.isFunctionType(), type);
            result.setJSType(Preconditions.checkNotNull(type));
        }
        return result;
    }

    Node createFunction(String name, Node paramList, Node body, JSType type) {
        Node nameNode = this.createName(name, type);
        Node result = IR.function(nameNode, paramList, body);
        if (this.isAddingTypes()) {
            Preconditions.checkArgument(type.isFunctionType(), type);
            result.setJSType(type);
        }
        return result;
    }

    Node createZeroArgFunction(String name, Node body, @Nullable JSType returnType) {
        FunctionType functionType = this.isAddingTypes() ? this.registry.createFunctionType(returnType, new JSType[0]).toMaybeFunctionType() : null;
        return this.createFunction(name, IR.paramList(new Node[0]), body, functionType);
    }

    Node createZeroArgGeneratorFunction(String name, Node body, @Nullable JSType returnType) {
        Node result = this.createZeroArgFunction(name, body, returnType);
        result.setIsGeneratorFunction(true);
        return result;
    }

    Node createZeroArgArrowFunctionForExpression(Node expression) {
        Node result = IR.arrowFunction(IR.name(""), IR.paramList(new Node[0]), expression);
        if (this.isAddingTypes()) {
            FunctionType functionType = FunctionType.builder(this.registry).withReturnType(expression.getJSTypeRequired()).withParameters().buildAndResolve();
            result.setJSType(functionType);
        }
        return result;
    }

    Node createMemberFunctionDef(String name, Node function) {
        Preconditions.checkArgument(function.getFirstChild().getString().isEmpty(), function);
        Node result = IR.memberFunctionDef(name, function);
        if (this.isAddingTypes()) {
            result.setJSType(function.getJSType());
        }
        return result;
    }

    Node createSheq(Node expr1, Node expr2) {
        Node result = IR.sheq(expr1, expr2);
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
        }
        return result;
    }

    Node createEq(Node expr1, Node expr2) {
        Node result = IR.eq(expr1, expr2);
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
        }
        return result;
    }

    Node createNe(Node expr1, Node expr2) {
        Node result = IR.ne(expr1, expr2);
        if (this.isAddingTypes()) {
            result.setJSType(this.getNativeType(JSTypeNative.BOOLEAN_TYPE));
        }
        return result;
    }

    Node createHook(Node condition, Node expr1, Node expr2) {
        Node result = IR.hook(condition, expr1, expr2);
        if (this.isAddingTypes()) {
            result.setJSType(this.registry.createUnionType(expr1.getJSType(), expr2.getJSType()));
        }
        return result;
    }

    Node createArraylit(Node ... elements) {
        return this.createArraylit(Arrays.asList(elements));
    }

    Node createArraylit(Iterable<Node> elements) {
        Node result = IR.arraylit(elements);
        if (this.isAddingTypes()) {
            result.setJSType(this.registry.createTemplatizedType(this.registry.getNativeObjectType(JSTypeNative.ARRAY_TYPE), this.getNativeType(JSTypeNative.UNKNOWN_TYPE)));
        }
        return result;
    }

    Node createJSCompMakeIteratorCall(Node iterable, Scope scope) {
        String function = "makeIterator";
        Node makeIteratorName = this.createQName(scope, "$jscomp", function);
        if (this.isAddingTypes() && !makeIteratorName.getJSType().isUnknownType()) {
            JSType iterableType = iterable.getJSType().getTemplateTypeMap().getResolvedTemplateType(this.registry.getIterableTemplate());
            JSType makeIteratorType = makeIteratorName.getJSType();
            makeIteratorName.setJSType(this.replaceTemplate(makeIteratorType, ImmutableList.of(iterableType)));
        }
        return this.createCall(makeIteratorName, iterable);
    }

    Node createJscompArrayFromIteratorCall(Node iterator, Scope scope) {
        Node makeIteratorName = this.createQName(scope, "$jscomp", "arrayFromIterator");
        if (this.isAddingTypes() && !makeIteratorName.getJSType().isUnknownType()) {
            JSType iterableType = iterator.getJSType().getTemplateTypeMap().getResolvedTemplateType(this.registry.getIteratorValueTemplate());
            JSType makeIteratorType = makeIteratorName.getJSType();
            makeIteratorName.setJSType(this.replaceTemplate(makeIteratorType, ImmutableList.of(iterableType)));
        }
        return this.createCall(makeIteratorName, iterator);
    }

    Node createJSCompMakeAsyncIteratorCall(Node iterable, Scope scope) {
        Node makeIteratorAsyncName = this.createQName(scope, "$jscomp", "makeAsyncIterator");
        if (this.isAddingTypes() && !makeIteratorAsyncName.getJSType().isUnknownType()) {
            JSType asyncIterableType = JsIterables.maybeBoxIterableOrAsyncIterable(iterable.getJSType(), this.registry).orElse(this.unknownType);
            JSType makeAsyncIteratorType = makeIteratorAsyncName.getJSType();
            makeIteratorAsyncName.setJSType(this.replaceTemplate(makeAsyncIteratorType, ImmutableList.of(asyncIterableType)));
        }
        return this.createCall(makeIteratorAsyncName, iterable);
    }

    private JSType replaceTemplate(JSType templatedType, ImmutableList<JSType> templateTypes) {
        TemplateTypeMap typeMap = this.registry.getEmptyTemplateTypeMap().copyWithExtension(templatedType.getTemplateTypeMap().getTemplateKeys(), templateTypes);
        TemplateTypeReplacer replacer = TemplateTypeReplacer.forPartialReplacement(this.registry, typeMap);
        return templatedType.visit(replacer);
    }

    Node createAsyncGeneratorWrapperReference(JSType originalFunctionType, Scope scope) {
        Node ctor = this.createQName(scope, "$jscomp", "AsyncGeneratorWrapper");
        if (this.isAddingTypes() && !ctor.getJSType().isUnknownType()) {
            JSType yieldedType = originalFunctionType.toMaybeFunctionType().getReturnType().getTemplateTypeMap().getResolvedTemplateType(this.registry.getAsyncIterableTemplate());
            ctor.setJSType(this.replaceTemplate(ctor.getJSType(), ImmutableList.of(yieldedType)));
        }
        return ctor;
    }

    Node createEmptyAsyncGeneratorWrapperArgument(JSType asyncGeneratorWrapperType) {
        FunctionType generatorType = null;
        if (this.isAddingTypes()) {
            if (asyncGeneratorWrapperType.isUnknownType()) {
                generatorType = this.registry.createFunctionType(this.replaceTemplate(this.getNativeType(JSTypeNative.GENERATOR_TYPE), ImmutableList.of(this.unknownType)), new JSType[0]);
            } else {
                JSType innerFunctionReturnType = Iterables.getOnlyElement(asyncGeneratorWrapperType.toMaybeFunctionType().getParameters()).getJSType();
                generatorType = this.registry.createFunctionType(innerFunctionReturnType, new JSType[0]);
            }
        }
        return this.createEmptyGeneratorFunction(generatorType);
    }

    Node createJscompAsyncExecutePromiseGeneratorFunctionCall(Scope scope, Node generatorFunction) {
        Node jscompDotAsyncExecutePromiseGeneratorFunction = this.createQName(scope, "$jscomp", "asyncExecutePromiseGeneratorFunction");
        return this.createCall(jscompDotAsyncExecutePromiseGeneratorFunction, generatorFunction);
    }

    private JSType getNativeType(JSTypeNative nativeType) {
        Preconditions.checkNotNull(this.registry, "registry is null");
        return Preconditions.checkNotNull(this.registry.getNativeType(nativeType), "native type not found: %s", (Object)nativeType);
    }

    private JSType getVarNameType(Scope scope, String name) {
        Node nameDefinitionNode;
        Var var = (Var)scope.getVar(name);
        JSType type = null;
        if (var != null && (nameDefinitionNode = var.getNode()) != null) {
            type = nameDefinitionNode.getJSType();
        }
        if (type == null) {
            type = this.unknownType;
        }
        return type;
    }

    private JSType getJsTypeForProperty(Node receiver, String propertyName) {
        JSType getpropType = null;
        JSType receiverJSType = receiver.getJSType();
        if (receiverJSType != null && (getpropType = receiverJSType.findPropertyType(propertyName)) == null) {
            ObjectType receiverObjectType = ObjectType.cast(receiverJSType.autobox());
            JSType jSType = getpropType = receiverObjectType == null ? this.unknownType : receiverObjectType.getPropertyType(propertyName);
        }
        if (getpropType == null) {
            getpropType = this.unknownType;
        }
        if (getpropType.isUnknownType() && propertyName.equals("global") && receiver.matchesName("$jscomp")) {
            getpropType = this.getNativeType(JSTypeNative.GLOBAL_THIS);
        }
        return getpropType;
    }
}

