/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.math.BigInteger;

class PeepholeFoldConstants
extends AbstractPeepholeOptimization {
    static final DiagnosticType INVALID_GETELEM_INDEX_ERROR = DiagnosticType.warning("JSC_INVALID_GETELEM_INDEX_ERROR", "Array index not integer: {0}");
    static final DiagnosticType FRACTIONAL_BITWISE_OPERAND = DiagnosticType.warning("JSC_FRACTIONAL_BITWISE_OPERAND", "Fractional bitwise operand: {0}");
    private static final double MAX_FOLD_NUMBER = Math.pow(2.0, 53.0);
    private final boolean late;
    private final boolean shouldUseTypes;

    PeepholeFoldConstants(boolean late, boolean shouldUseTypes) {
        this.late = late;
        this.shouldUseTypes = shouldUseTypes;
    }

    @Override
    Node optimizeSubtree(Node subtree) {
        switch (subtree.getToken()) {
            case OPTCHAIN_CALL: 
            case CALL: {
                return this.tryFoldCall(subtree);
            }
            case NEW: {
                return this.tryFoldCtorCall(subtree);
            }
            case TYPEOF: {
                return this.tryFoldTypeof(subtree);
            }
            case ARRAYLIT: 
            case OBJECTLIT: {
                return this.tryFlattenArrayOrObjectLit(subtree);
            }
            case NOT: 
            case POS: 
            case NEG: 
            case BITNOT: {
                this.tryReduceOperandsForOp(subtree);
                return this.tryFoldUnaryOperator(subtree);
            }
            case VOID: {
                return this.tryReduceVoid(subtree);
            }
        }
        this.tryReduceOperandsForOp(subtree);
        return this.tryFoldBinaryOperator(subtree);
    }

    private Node tryFoldBinaryOperator(Node subtree) {
        Node left = subtree.getFirstChild();
        if (left == null) {
            return subtree;
        }
        Node right = left.getNext();
        if (right == null) {
            return subtree;
        }
        switch (subtree.getToken()) {
            case OPTCHAIN_GETPROP: 
            case GETPROP: {
                return this.tryFoldGetProp(subtree, left, right);
            }
            case GETELEM: 
            case OPTCHAIN_GETELEM: {
                return this.tryFoldGetElem(subtree, left, right);
            }
            case INSTANCEOF: {
                return this.tryFoldInstanceof(subtree, left, right);
            }
            case AND: 
            case OR: {
                return this.tryFoldAndOr(subtree, left, right);
            }
            case COALESCE: {
                return this.tryFoldCoalesce(subtree, left, right);
            }
            case LSH: 
            case RSH: 
            case URSH: {
                return this.tryFoldShift(subtree, left, right);
            }
            case ASSIGN: {
                return this.tryFoldAssign(subtree, left, right);
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_ADD: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: 
            case ASSIGN_EXPONENT: {
                return this.tryUnfoldAssignOp(subtree, left, right);
            }
            case ADD: {
                return this.tryFoldAdd(subtree, left, right);
            }
            case SUB: 
            case DIV: 
            case MOD: 
            case EXPONENT: {
                return this.tryFoldArithmeticOp(subtree, left, right);
            }
            case MUL: 
            case BITAND: 
            case BITOR: 
            case BITXOR: {
                Node result = this.tryFoldArithmeticOp(subtree, left, right);
                if (result != subtree) {
                    return result;
                }
                return this.tryFoldLeftChildOp(subtree, left, right);
            }
            case LT: 
            case GT: 
            case LE: 
            case GE: 
            case EQ: 
            case NE: 
            case SHEQ: 
            case SHNE: {
                return this.tryFoldComparison(subtree, left, right);
            }
        }
        return subtree;
    }

    private Node tryReduceVoid(Node n) {
        Node child = n.getFirstChild();
        if (!(child.isNumber() && child.getDouble() == 0.0 || this.mayHaveSideEffects(n))) {
            n.replaceChild(child, IR.number(0.0));
            this.reportChangeToEnclosingScope(n);
        }
        return n;
    }

    private void tryReduceOperandsForOp(Node n) {
        switch (n.getToken()) {
            case ADD: {
                Node left = n.getFirstChild();
                Node right = n.getLastChild();
                if (NodeUtil.mayBeString(left, this.shouldUseTypes) || NodeUtil.mayBeString(right, this.shouldUseTypes)) break;
                this.tryConvertOperandsToNumber(n);
                break;
            }
            case ASSIGN_BITOR: 
            case ASSIGN_BITXOR: 
            case ASSIGN_BITAND: 
            case ASSIGN_LSH: 
            case ASSIGN_RSH: 
            case ASSIGN_URSH: 
            case ASSIGN_SUB: 
            case ASSIGN_MUL: 
            case ASSIGN_DIV: 
            case ASSIGN_MOD: {
                this.tryConvertToNumber(n.getLastChild());
                break;
            }
            case POS: 
            case NEG: 
            case BITNOT: 
            case LSH: 
            case RSH: 
            case URSH: 
            case SUB: 
            case DIV: 
            case MOD: 
            case EXPONENT: 
            case MUL: 
            case BITAND: 
            case BITOR: 
            case BITXOR: {
                this.tryConvertOperandsToNumber(n);
                break;
            }
        }
    }

    private void tryConvertOperandsToNumber(Node n) {
        Node c = n.getFirstChild();
        while (c != null) {
            Node next = c.getNext();
            this.tryConvertToNumber(c);
            c = next;
        }
    }

    private void tryConvertToNumber(Node n) {
        switch (n.getToken()) {
            case NUMBER: {
                return;
            }
            case AND: 
            case OR: 
            case COALESCE: 
            case COMMA: {
                this.tryConvertToNumber(n.getLastChild());
                return;
            }
            case HOOK: {
                this.tryConvertToNumber(n.getSecondChild());
                this.tryConvertToNumber(n.getLastChild());
                return;
            }
            case NAME: {
                if (NodeUtil.isUndefined(n)) break;
                return;
            }
        }
        Double result = this.getSideEffectFreeNumberValue(n);
        if (result == null) {
            return;
        }
        double value = result;
        Node replacement = NodeUtil.numberNode(value, n);
        if (replacement.isEquivalentTo(n)) {
            return;
        }
        n.replaceWith(replacement);
        this.reportChangeToEnclosingScope(replacement);
    }

    private Node tryFoldTypeof(Node originalTypeofNode) {
        Preconditions.checkArgument(originalTypeofNode.isTypeOf());
        Node argumentNode = originalTypeofNode.getFirstChild();
        if (argumentNode == null || !NodeUtil.isLiteralValue(argumentNode, true)) {
            return originalTypeofNode;
        }
        String typeNameString = null;
        switch (argumentNode.getToken()) {
            case FUNCTION: {
                typeNameString = "function";
                break;
            }
            case STRING: {
                typeNameString = "string";
                break;
            }
            case NUMBER: {
                typeNameString = "number";
                break;
            }
            case TRUE: 
            case FALSE: {
                typeNameString = "boolean";
                break;
            }
            case ARRAYLIT: 
            case OBJECTLIT: 
            case NULL: {
                typeNameString = "object";
                break;
            }
            case VOID: {
                typeNameString = "undefined";
                break;
            }
            case NAME: {
                if (!"undefined".equals(argumentNode.getString())) break;
                typeNameString = "undefined";
                break;
            }
        }
        if (typeNameString != null) {
            Node newNode = IR.string(typeNameString);
            this.reportChangeToEnclosingScope(originalTypeofNode);
            originalTypeofNode.replaceWith(newNode);
            this.markFunctionsDeleted(originalTypeofNode);
            return newNode;
        }
        return originalTypeofNode;
    }

    private Node tryFoldUnaryOperator(Node n) {
        Preconditions.checkState(n.hasOneChild(), n);
        Node left = n.getFirstChild();
        Node parent = n.getParent();
        if (left == null) {
            return n;
        }
        TernaryValue leftVal = this.getSideEffectFreeBooleanValue(left);
        if (leftVal == TernaryValue.UNKNOWN) {
            return n;
        }
        switch (n.getToken()) {
            case NOT: {
                double numValue;
                if (this.late && left.isNumber() && ((numValue = left.getDouble()) == 0.0 || numValue == 1.0)) {
                    return n;
                }
                Node replacementNode = NodeUtil.booleanNode(!leftVal.toBoolean(true));
                parent.replaceChild(n, replacementNode);
                this.reportChangeToEnclosingScope(parent);
                return replacementNode;
            }
            case POS: {
                if (NodeUtil.isNumericResult(left)) {
                    parent.replaceChild(n, left.detach());
                    this.reportChangeToEnclosingScope(parent);
                    return left;
                }
                return n;
            }
            case NEG: {
                if (left.isName()) {
                    if (left.getString().equals("Infinity")) {
                        return n;
                    }
                    if (left.getString().equals("NaN")) {
                        n.removeChild(left);
                        parent.replaceChild(n, left);
                        this.reportChangeToEnclosingScope(parent);
                        return left;
                    }
                }
                if (left.isNumber()) {
                    double negNum = -left.getDouble();
                    Node negNumNode = IR.number(negNum);
                    parent.replaceChild(n, negNumNode);
                    this.reportChangeToEnclosingScope(parent);
                    return negNumNode;
                }
                return n;
            }
            case BITNOT: {
                if (left.isNumber()) {
                    double val = left.getDouble();
                    if (Math.floor(val) == val) {
                        int intVal = this.jsConvertDoubleToBits(val);
                        Node notIntValNode = IR.number(~intVal);
                        parent.replaceChild(n, notIntValNode);
                        this.reportChangeToEnclosingScope(parent);
                        return notIntValNode;
                    }
                    this.report(FRACTIONAL_BITWISE_OPERAND, left);
                    return n;
                }
                if (left.isBigInt()) {
                    BigInteger val = left.getBigInt();
                    Node notValNode = IR.bigint(val.not());
                    parent.replaceChild(n, notValNode);
                    this.reportChangeToEnclosingScope(parent);
                    return notValNode;
                }
                return n;
            }
        }
        return n;
    }

    private int jsConvertDoubleToBits(double d) {
        return (int)((long)Math.floor(d) & 0xFFFFFFFFFFFFFFFFL);
    }

    private Node tryFoldInstanceof(Node n, Node left, Node right) {
        Preconditions.checkArgument(n.isInstanceOf());
        if (NodeUtil.isLiteralValue(left, true) && !this.mayHaveSideEffects(right)) {
            Node replacementNode = null;
            if (NodeUtil.isImmutableValue(left)) {
                replacementNode = IR.falseNode();
            } else if (right.isName() && "Object".equals(right.getString())) {
                replacementNode = IR.trueNode();
            }
            if (replacementNode != null) {
                n.replaceWith(replacementNode);
                this.reportChangeToEnclosingScope(replacementNode);
                this.markFunctionsDeleted(n);
                return replacementNode;
            }
        }
        return n;
    }

    private Node tryFoldAssign(Node n, Node left, Node right) {
        Node newRight;
        Preconditions.checkArgument(n.isAssign());
        if (!this.late) {
            return n;
        }
        if (!right.hasChildren() || right.getSecondChild() != right.getLastChild()) {
            return n;
        }
        if (this.mayHaveSideEffects(left)) {
            return n;
        }
        if (this.areNodesEqualForInlining(left, right.getFirstChild())) {
            newRight = right.getLastChild();
        } else if (NodeUtil.isCommutative(right.getToken()) && this.areNodesEqualForInlining(left, right.getLastChild())) {
            newRight = right.getFirstChild();
        } else {
            return n;
        }
        Token newType = null;
        switch (right.getToken()) {
            case ADD: {
                newType = Token.ASSIGN_ADD;
                break;
            }
            case BITAND: {
                newType = Token.ASSIGN_BITAND;
                break;
            }
            case BITOR: {
                newType = Token.ASSIGN_BITOR;
                break;
            }
            case BITXOR: {
                newType = Token.ASSIGN_BITXOR;
                break;
            }
            case DIV: {
                newType = Token.ASSIGN_DIV;
                break;
            }
            case LSH: {
                newType = Token.ASSIGN_LSH;
                break;
            }
            case MOD: {
                newType = Token.ASSIGN_MOD;
                break;
            }
            case MUL: {
                newType = Token.ASSIGN_MUL;
                break;
            }
            case RSH: {
                newType = Token.ASSIGN_RSH;
                break;
            }
            case SUB: {
                newType = Token.ASSIGN_SUB;
                break;
            }
            case URSH: {
                newType = Token.ASSIGN_URSH;
                break;
            }
            case EXPONENT: {
                newType = Token.ASSIGN_EXPONENT;
                break;
            }
            default: {
                return n;
            }
        }
        Node newNode = new Node(newType, left.detach(), newRight.detach());
        n.replaceWith(newNode);
        this.reportChangeToEnclosingScope(newNode);
        return newNode;
    }

    private Node tryUnfoldAssignOp(Node n, Node left, Node right) {
        if (this.late) {
            return n;
        }
        if (!n.hasChildren() || n.getSecondChild() != n.getLastChild()) {
            return n;
        }
        if (this.mayHaveSideEffects(left)) {
            return n;
        }
        Token op = NodeUtil.getOpFromAssignmentOp(n);
        Node replacement = IR.assign(left.detach(), new Node(op, left.cloneTree(), right.detach()).srcref(n));
        n.replaceWith(replacement);
        this.reportChangeToEnclosingScope(replacement);
        return replacement;
    }

    private Node tryFoldAndOr(Node n, Node left, Node right) {
        Node parent = n.getParent();
        Node result = null;
        Node dropped = null;
        Token type = n.getToken();
        TernaryValue leftVal = NodeUtil.getBooleanValue(left);
        if (leftVal != TernaryValue.UNKNOWN) {
            boolean lval = leftVal.toBoolean(true);
            if (lval && type == Token.OR || !lval && type == Token.AND) {
                result = left;
                dropped = right;
            } else if (!this.mayHaveSideEffects(left)) {
                result = right;
                dropped = left;
            } else {
                n.detachChildren();
                result = IR.comma(left, right);
                dropped = null;
            }
        } else if (parent.getToken() == type && n == parent.getFirstChild()) {
            TernaryValue rightValue = NodeUtil.getBooleanValue(right);
            if (!this.mayHaveSideEffects(right) && (rightValue == TernaryValue.FALSE && type == Token.OR || rightValue == TernaryValue.TRUE && type == Token.AND)) {
                result = left;
                dropped = right;
            }
        }
        if (result != null) {
            n.detachChildren();
            parent.replaceChild(n, result);
            this.reportChangeToEnclosingScope(result);
            if (dropped != null) {
                this.markFunctionsDeleted(dropped);
            }
            return result;
        }
        return n;
    }

    private Node tryFoldCoalesce(Node n, Node left, Node right) {
        Node parent = n.getParent();
        Node result = null;
        Node dropped = null;
        TernaryValue leftVal = NodeUtil.getBooleanValue(left);
        if (leftVal != TernaryValue.UNKNOWN) {
            if (NodeUtil.isNullOrUndefined(left)) {
                result = right;
                dropped = left;
            } else if (!this.mayHaveSideEffects(left)) {
                result = left;
                dropped = right;
            } else {
                n.detachChildren();
                result = IR.comma(left, right);
                dropped = null;
            }
        }
        if (result != null) {
            n.detachChildren();
            parent.replaceChild(n, result);
            this.reportChangeToEnclosingScope(result);
            if (dropped != null) {
                this.markFunctionsDeleted(dropped);
            }
            return result;
        }
        return n;
    }

    private Node tryFoldAdjacentLiteralLeaves(Node n, Node left, Node right) {
        Node leftParent = n;
        Node rightParent = n;
        while (left.isAdd()) {
            leftParent = left;
            left = left.getSecondChild();
        }
        while (right.isAdd()) {
            rightParent = right;
            right = right.getFirstChild();
        }
        if (leftParent.isAdd() && left.isString() && rightParent.isAdd() && NodeUtil.isLiteralValue(right, false)) {
            boolean foldIsTypeSafe;
            Node rightGrandparent = rightParent.getParent();
            Node rr = right.getNext();
            boolean bl = foldIsTypeSafe = rr != null && NodeUtil.isStringResult(rr) || rr != null && right.isString() && rightGrandparent != null && rightGrandparent.isAdd() && NodeUtil.isStringResult(rightGrandparent.getSecondChild()) || rr == null;
            if (foldIsTypeSafe) {
                String result = left.getString() + NodeUtil.getStringValue(right);
                if (rightParent.getSecondChild().equals(right)) {
                    left.replaceWith(IR.string(result));
                    this.replace(rightParent, rightParent.getFirstChild().cloneTree(true));
                } else {
                    left.replaceWith(IR.string(result));
                    this.replace(rightParent, rightParent.getSecondChild().cloneTree(true));
                }
            }
        }
        return n;
    }

    private Node tryFoldAddConstantString(Node n, Node left, Node right) {
        if (left.isString() || right.isString() || left.isArrayLit() || right.isArrayLit()) {
            String leftString = this.getSideEffectFreeStringValue(left);
            String rightString = this.getSideEffectFreeStringValue(right);
            if (leftString != null && rightString != null) {
                Node newStringNode = IR.string(leftString + rightString);
                n.replaceWith(newStringNode);
                this.reportChangeToEnclosingScope(newStringNode);
                return newStringNode;
            }
        }
        return n;
    }

    private Node tryFoldArithmeticOp(Node n, Node left, Node right) {
        Node result = this.performArithmeticOp(n.getToken(), left, right);
        if (result != null) {
            result.useSourceInfoIfMissingFromForTree(n);
            this.reportChangeToEnclosingScope(n);
            n.replaceWith(result);
            return result;
        }
        return n;
    }

    private Node performArithmeticOp(Token opType, Node left, Node right) {
        double result;
        if (opType == Token.ADD && (NodeUtil.mayBeString(left, this.shouldUseTypes) || NodeUtil.mayBeString(right, this.shouldUseTypes))) {
            return null;
        }
        if (this.isBigInt(left) && this.isBigInt(right)) {
            return this.performBigIntArithmeticOp(opType, left, right);
        }
        Double lValObj = this.getSideEffectFreeNumberValue(left);
        Double rValObj = this.getSideEffectFreeNumberValue(right);
        if (lValObj == null && rValObj == null || !this.isNumeric(left) || !this.isNumeric(right)) {
            return null;
        }
        switch (opType) {
            case ADD: {
                if (lValObj != null && rValObj != null) {
                    return this.maybeReplaceBinaryOpWithNumericResult(lValObj + rValObj, lValObj, rValObj);
                }
                if (lValObj != null && lValObj == 0.0) {
                    return right.cloneTree(true);
                }
                if (rValObj != null && rValObj == 0.0) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case SUB: {
                if (lValObj != null && rValObj != null) {
                    return this.maybeReplaceBinaryOpWithNumericResult(lValObj - rValObj, lValObj, rValObj);
                }
                if (lValObj != null && lValObj == 0.0) {
                    return IR.neg(right.cloneTree(true));
                }
                if (rValObj != null && rValObj == 0.0) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case MUL: {
                if (lValObj != null && rValObj != null) {
                    return this.maybeReplaceBinaryOpWithNumericResult(lValObj * rValObj, lValObj, rValObj);
                }
                if (lValObj != null) {
                    if (lValObj == 1.0) {
                        return right.cloneTree(true);
                    }
                } else if (rValObj == 1.0) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case DIV: {
                if (lValObj != null && rValObj != null) {
                    if (rValObj == 0.0) {
                        return null;
                    }
                    return this.maybeReplaceBinaryOpWithNumericResult(lValObj / rValObj, lValObj, rValObj);
                }
                if (rValObj != null && rValObj == 1.0) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case EXPONENT: {
                if (lValObj != null && rValObj != null) {
                    return this.maybeReplaceBinaryOpWithNumericResult(Math.pow(lValObj, rValObj), lValObj, rValObj);
                }
                return null;
            }
        }
        if (lValObj == null || rValObj == null) {
            return null;
        }
        double lval = lValObj;
        double rval = rValObj;
        switch (opType) {
            case BITAND: {
                result = NodeUtil.toInt32(lval) & NodeUtil.toInt32(rval);
                break;
            }
            case BITOR: {
                result = NodeUtil.toInt32(lval) | NodeUtil.toInt32(rval);
                break;
            }
            case BITXOR: {
                result = NodeUtil.toInt32(lval) ^ NodeUtil.toInt32(rval);
                break;
            }
            case MOD: {
                if (rval == 0.0) {
                    return null;
                }
                result = lval % rval;
                break;
            }
            default: {
                throw new Error("Unexpected arithmetic operator: " + (Object)((Object)opType));
            }
        }
        return this.maybeReplaceBinaryOpWithNumericResult(result, lval, rval);
    }

    private Node performBigIntArithmeticOp(Token opType, Node left, Node right) {
        BigInteger lVal = this.getSideEffectFreeBigIntValue(left);
        BigInteger rVal = this.getSideEffectFreeBigIntValue(right);
        if (lVal != null && rVal != null) {
            switch (opType) {
                case ADD: {
                    return IR.bigint(lVal.add(rVal));
                }
                case SUB: {
                    return IR.bigint(lVal.subtract(rVal));
                }
                case MUL: {
                    return IR.bigint(lVal.multiply(rVal));
                }
                case DIV: {
                    if (!rVal.equals(BigInteger.ZERO)) {
                        return IR.bigint(lVal.divide(rVal));
                    }
                    return null;
                }
                case EXPONENT: {
                    try {
                        return IR.bigint(lVal.pow(rVal.intValueExact()));
                    }
                    catch (ArithmeticException exception) {
                        return null;
                    }
                }
                case MOD: {
                    return IR.bigint(lVal.mod(rVal));
                }
                case BITAND: {
                    return IR.bigint(lVal.and(rVal));
                }
                case BITOR: {
                    return IR.bigint(lVal.or(rVal));
                }
                case BITXOR: {
                    return IR.bigint(lVal.xor(rVal));
                }
            }
            return null;
        }
        switch (opType) {
            case ADD: {
                if (lVal != null && lVal.equals(BigInteger.ZERO)) {
                    return right.cloneTree(true);
                }
                if (rVal != null && rVal.equals(BigInteger.ZERO)) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case SUB: {
                if (lVal != null && lVal.equals(BigInteger.ZERO)) {
                    return IR.neg(right.cloneTree(true));
                }
                if (rVal != null && rVal.equals(BigInteger.ZERO)) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case MUL: {
                if (lVal != null && lVal.equals(BigInteger.ONE)) {
                    return right.cloneTree(true);
                }
                if (rVal != null && rVal.equals(BigInteger.ONE)) {
                    return left.cloneTree(true);
                }
                return null;
            }
            case DIV: {
                if (rVal != null && rVal.equals(BigInteger.ONE)) {
                    return left.cloneTree(true);
                }
                return null;
            }
        }
        return null;
    }

    private boolean isNumeric(Node n) {
        return NodeUtil.isNumericResult(n) || this.shouldUseTypes && n.getJSType() != null && n.getJSType().isNumberValueType();
    }

    private boolean isBigInt(Node n) {
        return NodeUtil.isBigIntResult(n) || this.shouldUseTypes && n.getJSType() != null && n.getJSType().isBigIntValueType();
    }

    private Node maybeReplaceBinaryOpWithNumericResult(double result, double lval, double rval) {
        if (String.valueOf(result).length() <= String.valueOf(lval).length() + String.valueOf(rval).length() + 1 && Math.abs(result) <= MAX_FOLD_NUMBER || Double.isNaN(result) || result == Double.POSITIVE_INFINITY || result == Double.NEGATIVE_INFINITY) {
            return NodeUtil.numberNode(result, null);
        }
        return null;
    }

    private Node tryFoldLeftChildOp(Node n, Node left, Node right) {
        Token opType = n.getToken();
        Preconditions.checkState(NodeUtil.isAssociative(opType) && NodeUtil.isCommutative(opType) || n.isAdd());
        Preconditions.checkState(!n.isAdd() || !NodeUtil.mayBeString(n, this.shouldUseTypes));
        Double rightValObj = this.getSideEffectFreeNumberValue(right);
        BigInteger rightBigInt = this.getSideEffectFreeBigIntValue(right);
        if ((rightValObj != null || rightBigInt != null) && left.getToken() == opType) {
            Preconditions.checkState(left.hasTwoChildren());
            Node ll = left.getFirstChild();
            Node lr = ll.getNext();
            Node valueToCombine = ll;
            Node replacement = this.performArithmeticOp(opType, valueToCombine, right);
            if (replacement == null) {
                valueToCombine = lr;
                replacement = this.performArithmeticOp(opType, valueToCombine, right);
            }
            if (replacement != null) {
                left.removeChild(valueToCombine);
                n.replaceChild(left, left.removeFirstChild());
                replacement.useSourceInfoIfMissingFromForTree(right);
                n.replaceChild(right, replacement);
                this.reportChangeToEnclosingScope(n);
            }
        }
        return n;
    }

    private Node tryFoldAdd(Node node, Node left, Node right) {
        Preconditions.checkArgument(node.isAdd());
        if (NodeUtil.mayBeString(node, this.shouldUseTypes)) {
            if (NodeUtil.isLiteralValue(left, false) && NodeUtil.isLiteralValue(right, false)) {
                return this.tryFoldAddConstantString(node, left, right);
            }
            if (left.isString() && left.getString().isEmpty() && this.isStringTyped(right)) {
                return this.replace(node, right.cloneTree(true));
            }
            if (right.isString() && right.getString().isEmpty() && this.isStringTyped(left)) {
                return this.replace(node, left.cloneTree(true));
            }
            return this.tryFoldAdjacentLiteralLeaves(node, left, right);
        }
        Node result = this.tryFoldArithmeticOp(node, left, right);
        if (result != node) {
            return result;
        }
        return this.tryFoldLeftChildOp(node, left, right);
    }

    private Node replace(Node oldNode, Node newNode) {
        oldNode.replaceWith(newNode);
        this.reportChangeToEnclosingScope(newNode);
        return newNode;
    }

    private boolean isStringTyped(Node n) {
        return NodeUtil.isStringResult(n) || this.shouldUseTypes && n.getJSType() != null && n.getJSType().isStringValueType();
    }

    private Node tryFoldShift(Node n, Node left, Node right) {
        if (left.isNumber() && right.isNumber()) {
            double result;
            double lval = left.getDouble();
            double rval = right.getDouble();
            if (!(rval >= 0.0) || !(rval < 32.0)) {
                return n;
            }
            int rvalInt = (int)rval;
            if ((double)rvalInt != rval) {
                this.report(FRACTIONAL_BITWISE_OPERAND, right);
                return n;
            }
            if (Math.floor(lval) != lval) {
                this.report(FRACTIONAL_BITWISE_OPERAND, left);
                return n;
            }
            int bits = this.jsConvertDoubleToBits(lval);
            switch (n.getToken()) {
                case LSH: {
                    result = bits << rvalInt;
                    break;
                }
                case RSH: {
                    result = bits >> rvalInt;
                    break;
                }
                case URSH: {
                    result = 0xFFFFFFFFL & (long)(bits >>> rvalInt);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown shift operator: " + (Object)((Object)n.getToken())));
                }
            }
            Node newNumber = IR.number(result);
            this.reportChangeToEnclosingScope(n);
            n.replaceWith(newNumber);
            return newNumber;
        }
        return n;
    }

    private Node tryFoldComparison(Node n, Node left, Node right) {
        TernaryValue result = PeepholeFoldConstants.evaluateComparison(this, n.getToken(), left, right);
        if (result == TernaryValue.UNKNOWN) {
            return n;
        }
        Node newNode = NodeUtil.booleanNode(result.toBoolean(true));
        this.reportChangeToEnclosingScope(n);
        n.replaceWith(newNode);
        this.markFunctionsDeleted(n);
        return newNode;
    }

    private static TernaryValue tryAbstractRelationalComparison(AbstractPeepholeOptimization peepholeOptimization, Node left, Node right, boolean willNegate) {
        NodeUtil.ValueType leftValueType = NodeUtil.getKnownValueType(left);
        NodeUtil.ValueType rightValueType = NodeUtil.getKnownValueType(right);
        if (leftValueType == NodeUtil.ValueType.STRING && rightValueType == NodeUtil.ValueType.STRING) {
            String lvStr = peepholeOptimization.getSideEffectFreeStringValue(left);
            String rvStr = peepholeOptimization.getSideEffectFreeStringValue(right);
            if (lvStr != null && rvStr != null) {
                if (lvStr.indexOf(11) != -1 || rvStr.indexOf(11) != -1) {
                    return TernaryValue.UNKNOWN;
                }
                return TernaryValue.forBoolean(lvStr.compareTo(rvStr) < 0);
            }
            if (left.isTypeOf() && right.isTypeOf() && left.getFirstChild().isName() && right.getFirstChild().isName() && left.getFirstChild().getString().equals(right.getFirstChild().getString())) {
                return TernaryValue.FALSE;
            }
        }
        BigInteger lvBig = peepholeOptimization.getSideEffectFreeBigIntValue(left);
        BigInteger rvBig = peepholeOptimization.getSideEffectFreeBigIntValue(right);
        if (lvBig != null && rvBig != null) {
            return TernaryValue.forBoolean(lvBig.compareTo(rvBig) < 0);
        }
        Double lvNum = peepholeOptimization.getSideEffectFreeNumberValue(left);
        Double rvNum = peepholeOptimization.getSideEffectFreeNumberValue(right);
        if (lvNum != null && rvNum != null) {
            if (Double.isNaN(lvNum) || Double.isNaN(rvNum)) {
                return TernaryValue.forBoolean(willNegate);
            }
            return TernaryValue.forBoolean(lvNum < rvNum);
        }
        if (lvBig != null && rvNum != null) {
            return PeepholeFoldConstants.compareBigIntAndNumber(lvBig, rvNum, false, willNegate);
        }
        if (lvNum != null && rvBig != null) {
            return PeepholeFoldConstants.compareBigIntAndNumber(rvBig, lvNum, true, willNegate);
        }
        if (!willNegate && left.isName() && right.isName() && left.getString().equals(right.getString())) {
            return TernaryValue.FALSE;
        }
        return TernaryValue.UNKNOWN;
    }

    private static TernaryValue compareBigIntAndNumber(BigInteger bigint, double number, boolean invert, boolean willNegate) {
        if (Double.isNaN(number)) {
            return TernaryValue.forBoolean(willNegate);
        }
        if (number == Double.POSITIVE_INFINITY) {
            return invert ? TernaryValue.FALSE : TernaryValue.TRUE;
        }
        if (number == Double.NEGATIVE_INFINITY) {
            return invert ? TernaryValue.TRUE : TernaryValue.FALSE;
        }
        BigInteger numberAsBigInt = BigInteger.valueOf((long)number);
        int comparison = invert ? numberAsBigInt.compareTo(bigint) : bigint.compareTo(numberAsBigInt);
        switch (comparison) {
            case -1: {
                return TernaryValue.TRUE;
            }
            case 1: {
                return TernaryValue.FALSE;
            }
            case 0: {
                double remainder = (invert ? -number : number) % 1.0;
                return TernaryValue.forBoolean(remainder > 0.0);
            }
        }
        throw new AssertionError((Object)("compareTo returned an unexpected value: " + comparison));
    }

    private static TernaryValue tryAbstractEqualityComparison(AbstractPeepholeOptimization peepholeOptimization, Node left, Node right) {
        NodeUtil.ValueType leftValueType = NodeUtil.getKnownValueType(left);
        NodeUtil.ValueType rightValueType = NodeUtil.getKnownValueType(right);
        if (leftValueType != NodeUtil.ValueType.UNDETERMINED && rightValueType != NodeUtil.ValueType.UNDETERMINED) {
            if (leftValueType == rightValueType) {
                return PeepholeFoldConstants.tryStrictEqualityComparison(peepholeOptimization, left, right);
            }
            if (leftValueType == NodeUtil.ValueType.NULL && rightValueType == NodeUtil.ValueType.VOID || leftValueType == NodeUtil.ValueType.VOID && rightValueType == NodeUtil.ValueType.NULL) {
                return TernaryValue.TRUE;
            }
            if (leftValueType == NodeUtil.ValueType.NUMBER && rightValueType == NodeUtil.ValueType.STRING || rightValueType == NodeUtil.ValueType.BOOLEAN) {
                Double rv = peepholeOptimization.getSideEffectFreeNumberValue(right);
                return rv == null ? TernaryValue.UNKNOWN : PeepholeFoldConstants.tryAbstractEqualityComparison(peepholeOptimization, left, IR.number(rv));
            }
            if (leftValueType == NodeUtil.ValueType.STRING && rightValueType == NodeUtil.ValueType.NUMBER || leftValueType == NodeUtil.ValueType.BOOLEAN) {
                Double lv = peepholeOptimization.getSideEffectFreeNumberValue(left);
                return lv == null ? TernaryValue.UNKNOWN : PeepholeFoldConstants.tryAbstractEqualityComparison(peepholeOptimization, IR.number(lv), right);
            }
            if (leftValueType == NodeUtil.ValueType.BIGINT || rightValueType == NodeUtil.ValueType.BIGINT) {
                BigInteger lv = peepholeOptimization.getSideEffectFreeBigIntValue(left);
                BigInteger rv = peepholeOptimization.getSideEffectFreeBigIntValue(right);
                if (lv != null && rv != null) {
                    return TernaryValue.forBoolean(lv.equals(rv));
                }
            }
            if ((leftValueType == NodeUtil.ValueType.STRING || leftValueType == NodeUtil.ValueType.NUMBER) && rightValueType == NodeUtil.ValueType.OBJECT) {
                return TernaryValue.UNKNOWN;
            }
            if (leftValueType == NodeUtil.ValueType.OBJECT && (rightValueType == NodeUtil.ValueType.STRING || rightValueType == NodeUtil.ValueType.NUMBER)) {
                return TernaryValue.UNKNOWN;
            }
            return TernaryValue.FALSE;
        }
        return TernaryValue.UNKNOWN;
    }

    private static TernaryValue tryStrictEqualityComparison(AbstractPeepholeOptimization peepholeOptimization, Node left, Node right) {
        NodeUtil.ValueType leftValueType = NodeUtil.getKnownValueType(left);
        NodeUtil.ValueType rightValueType = NodeUtil.getKnownValueType(right);
        if (leftValueType != NodeUtil.ValueType.UNDETERMINED && rightValueType != NodeUtil.ValueType.UNDETERMINED) {
            if (leftValueType != rightValueType) {
                return TernaryValue.FALSE;
            }
            switch (leftValueType) {
                case VOID: 
                case NULL: {
                    return TernaryValue.TRUE;
                }
                case NUMBER: {
                    if (NodeUtil.isNaN(left)) {
                        return TernaryValue.FALSE;
                    }
                    if (NodeUtil.isNaN(right)) {
                        return TernaryValue.FALSE;
                    }
                    Double lv = peepholeOptimization.getSideEffectFreeNumberValue(left);
                    Double rv = peepholeOptimization.getSideEffectFreeNumberValue(right);
                    if (lv == null || rv == null) break;
                    return TernaryValue.forBoolean(lv.doubleValue() == rv.doubleValue());
                }
                case STRING: {
                    String lv = peepholeOptimization.getSideEffectFreeStringValue(left);
                    String rv = peepholeOptimization.getSideEffectFreeStringValue(right);
                    if (lv != null && rv != null) {
                        if (lv.indexOf(11) != -1 || rv.indexOf(11) != -1) {
                            return TernaryValue.UNKNOWN;
                        }
                        return lv.equals(rv) ? TernaryValue.TRUE : TernaryValue.FALSE;
                    }
                    if (!left.isTypeOf() || !right.isTypeOf() || !left.getFirstChild().isName() || !right.getFirstChild().isName() || !left.getFirstChild().getString().equals(right.getFirstChild().getString())) break;
                    return TernaryValue.TRUE;
                }
                case BOOLEAN: {
                    TernaryValue lv = peepholeOptimization.getSideEffectFreeBooleanValue(left);
                    TernaryValue rv = peepholeOptimization.getSideEffectFreeBooleanValue(right);
                    return lv.and(rv).or(lv.not().and(rv.not()));
                }
                case BIGINT: {
                    BigInteger lv = peepholeOptimization.getSideEffectFreeBigIntValue(left);
                    BigInteger rv = peepholeOptimization.getSideEffectFreeBigIntValue(right);
                    return TernaryValue.forBoolean(lv.equals(rv));
                }
                default: {
                    return TernaryValue.UNKNOWN;
                }
            }
        }
        if (NodeUtil.isNaN(left) || NodeUtil.isNaN(right)) {
            return TernaryValue.FALSE;
        }
        return TernaryValue.UNKNOWN;
    }

    static TernaryValue evaluateComparison(AbstractPeepholeOptimization peepholeOptimization, Token op, Node left, Node right) {
        if (peepholeOptimization.mayHaveSideEffects(left) || peepholeOptimization.mayHaveSideEffects(right)) {
            return TernaryValue.UNKNOWN;
        }
        switch (op) {
            case EQ: {
                return PeepholeFoldConstants.tryAbstractEqualityComparison(peepholeOptimization, left, right);
            }
            case NE: {
                return PeepholeFoldConstants.tryAbstractEqualityComparison(peepholeOptimization, left, right).not();
            }
            case SHEQ: {
                return PeepholeFoldConstants.tryStrictEqualityComparison(peepholeOptimization, left, right);
            }
            case SHNE: {
                return PeepholeFoldConstants.tryStrictEqualityComparison(peepholeOptimization, left, right).not();
            }
            case LT: {
                return PeepholeFoldConstants.tryAbstractRelationalComparison(peepholeOptimization, left, right, false);
            }
            case GT: {
                return PeepholeFoldConstants.tryAbstractRelationalComparison(peepholeOptimization, right, left, false);
            }
            case LE: {
                return PeepholeFoldConstants.tryAbstractRelationalComparison(peepholeOptimization, right, left, true).not();
            }
            case GE: {
                return PeepholeFoldConstants.tryAbstractRelationalComparison(peepholeOptimization, left, right, true).not();
            }
        }
        throw new IllegalStateException("Unexpected operator for comparison");
    }

    private Node tryFoldCtorCall(Node n) {
        Preconditions.checkArgument(n.isNew());
        if (PeepholeFoldConstants.inForcedStringContext(n)) {
            return this.tryFoldInForcedStringContext(n);
        }
        return n;
    }

    private Node tryFoldCall(Node n) {
        Node srcObj;
        Preconditions.checkArgument(n.isCall() || n.isOptChainCall());
        if (NodeUtil.isObjectDefinePropertiesDefinition(n) && (srcObj = n.getLastChild()).isObjectLit() && !srcObj.hasChildren()) {
            Node parent = n.getParent();
            Node destObj = n.getSecondChild().detach();
            parent.replaceChild(n, destObj);
            this.reportChangeToEnclosingScope(parent);
        }
        return n;
    }

    private static boolean inForcedStringContext(Node n) {
        if (n.getParent().isGetElem() && n.getParent().getLastChild() == n) {
            return true;
        }
        return n.getParent().isAdd();
    }

    private Node tryFoldInForcedStringContext(Node n) {
        Preconditions.checkArgument(n.isNew());
        Node objectType = n.getFirstChild();
        if (!objectType.isName()) {
            return n;
        }
        if (objectType.getString().equals("String")) {
            Node value = objectType.getNext();
            String stringValue = null;
            stringValue = value == null ? "" : this.getSideEffectFreeStringValue(value);
            if (stringValue == null) {
                return n;
            }
            Node parent = n.getParent();
            Node newString = IR.string(stringValue);
            parent.replaceChild(n, newString);
            newString.useSourceInfoIfMissingFrom(parent);
            this.reportChangeToEnclosingScope(parent);
            return newString;
        }
        return n;
    }

    private Node tryFoldGetElem(Node n, Node left, Node right) {
        Preconditions.checkArgument(n.isGetElem() || n.isOptChainGetElem());
        if (left.isObjectLit()) {
            return this.tryFoldObjectPropAccess(n, left, right);
        }
        if (left.isArrayLit()) {
            return this.tryFoldArrayAccess(n, left, right);
        }
        if (left.isString()) {
            return this.tryFoldStringArrayAccess(n, left, right);
        }
        return n;
    }

    private Node tryFoldGetProp(Node n, Node left, Node right) {
        Preconditions.checkArgument(n.isGetProp() || n.isOptChainGetProp());
        if (left.isObjectLit()) {
            return this.tryFoldObjectPropAccess(n, left, right);
        }
        if (right.isString() && right.getString().equals("length")) {
            int knownLength = -1;
            switch (left.getToken()) {
                case ARRAYLIT: {
                    if (this.mayHaveSideEffects(left)) {
                        return n;
                    }
                    knownLength = left.getChildCount();
                    break;
                }
                case STRING: {
                    knownLength = left.getString().length();
                    break;
                }
                default: {
                    return n;
                }
            }
            Preconditions.checkState(knownLength != -1);
            Node lengthNode = IR.number(knownLength);
            this.reportChangeToEnclosingScope(n);
            n.replaceWith(lengthNode);
            return lengthNode;
        }
        return n;
    }

    private Node tryFoldArrayAccess(Node n, Node left, Node right) {
        if (NodeUtil.isLValue(n)) {
            return n;
        }
        if (!right.isNumber()) {
            return n;
        }
        double index = right.getDouble();
        int intIndex = (int)index;
        if ((double)intIndex != index) {
            this.report(INVALID_GETELEM_INDEX_ERROR, right);
            return n;
        }
        Node current = intIndex >= 0 ? left.getFirstChild() : null;
        Node elem = null;
        int i = 0;
        while (current != null) {
            if (current.isSpread()) {
                return n;
            }
            if (i != intIndex) {
                if (this.mayHaveSideEffects(current)) {
                    return n;
                }
            } else {
                elem = current;
            }
            current = current.getNext();
            ++i;
        }
        if (elem == null) {
            elem = NodeUtil.newUndefinedNode(left);
        } else if (elem.isEmpty()) {
            elem = NodeUtil.newUndefinedNode(elem);
        } else {
            left.removeChild(elem);
        }
        n.replaceWith(elem);
        this.reportChangeToEnclosingScope(elem);
        return elem;
    }

    private Node tryFlattenArrayOrObjectLit(Node parentLit) {
        for (Node child = parentLit.getFirstChild(); child != null; child = child.getNext()) {
            Node spread = child;
            if (!spread.isSpread()) continue;
            Node innerLit = spread.getOnlyChild();
            if (!parentLit.getToken().equals((Object)innerLit.getToken())) continue;
            parentLit.addChildrenAfter(innerLit.removeChildren(), spread);
            spread.detach();
            this.reportChangeToEnclosingScope(parentLit);
        }
        return parentLit;
    }

    private Node tryFoldStringArrayAccess(Node n, Node left, Node right) {
        if (NodeUtil.isLValue(n)) {
            return n;
        }
        if (!right.isNumber()) {
            return n;
        }
        double index = right.getDouble();
        int intIndex = (int)index;
        if ((double)intIndex != index) {
            this.report(INVALID_GETELEM_INDEX_ERROR, right);
            return n;
        }
        Preconditions.checkState(left.isString());
        String value = left.getString();
        if (intIndex < 0 || intIndex >= value.length()) {
            Node undefined = NodeUtil.newUndefinedNode(left);
            n.replaceWith(undefined);
            this.reportChangeToEnclosingScope(undefined);
            return undefined;
        }
        char c = '\u0000';
        for (int i = 0; i <= intIndex; ++i) {
            c = value.charAt(i);
            if (c >= ' ' && c <= 127) continue;
            return n;
        }
        Node elem = IR.string(Character.toString(c));
        n.replaceWith(elem);
        this.reportChangeToEnclosingScope(elem);
        return elem;
    }

    private Node tryFoldObjectPropAccess(Node n, Node left, Node right) {
        Preconditions.checkArgument(NodeUtil.isNormalOrOptChainGet(n));
        if (!left.isObjectLit() || !right.isString()) {
            return n;
        }
        if (NodeUtil.isLValue(n)) {
            Preconditions.checkState(!NodeUtil.isOptChainNode(n));
            return n;
        }
        Node key = null;
        Node value = null;
        block6: for (Node c = left.getFirstChild(); c != null; c = c.getNext()) {
            switch (c.getToken()) {
                case SETTER_DEF: {
                    continue block6;
                }
                case OBJECT_SPREAD: {
                    key = null;
                    value = null;
                    continue block6;
                }
                case COMPUTED_PROP: {
                    Node prop = c.getFirstChild();
                    if (!prop.isString()) {
                        return n;
                    }
                    if (!prop.getString().equals(right.getString())) continue block6;
                    key = c;
                    value = c.getSecondChild();
                    continue block6;
                }
                case GETTER_DEF: 
                case STRING_KEY: 
                case MEMBER_FUNCTION_DEF: {
                    if (!c.getString().equals(right.getString())) continue block6;
                    key = c;
                    value = key.getFirstChild();
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (value == null) {
            return n;
        }
        if (NodeUtil.referencesSuper(value)) {
            return n;
        }
        Node tempValue = IR.nullNode();
        value.replaceWith(tempValue);
        boolean hasSideEffectBesidesValue = this.mayHaveSideEffects(left);
        tempValue.replaceWith(value);
        if (hasSideEffectBesidesValue) {
            return n;
        }
        boolean keyIsGetter = NodeUtil.isGetOrSetKey(key);
        boolean nIsInvoked = NodeUtil.isInvocationTarget(n);
        if ((keyIsGetter || nIsInvoked) && (!value.isFunction() || NodeUtil.referencesOwnReceiver(value))) {
            return n;
        }
        value.detach();
        Node parent = n.getParent();
        if (NodeUtil.isOptChainNode(parent)) {
            Node endOfCurrentChain = NodeUtil.getEndOfOptChainSegment(parent);
            NodeUtil.convertToNonOptionalChainSegment(endOfCurrentChain);
        }
        if (keyIsGetter) {
            value = IR.call(value, new Node[0]);
            value.putBooleanProp(Node.FREE_CALL, true);
        } else if (nIsInvoked) {
            n.getParent().putBooleanProp(Node.FREE_CALL, true);
        }
        n.replaceWith(value);
        this.reportChangeToEnclosingScope(value);
        this.markFunctionsDeleted(n);
        return n;
    }
}

