/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.ModuleImportResolver;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerBehaviorExtractor;
import com.google.javascript.jscomp.PolymerClassDefinition;
import com.google.javascript.jscomp.PolymerExportPolicy;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.PolymerPassStaticUtils;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

final class PolymerClassRewriter {
    private static final String VIRTUAL_FILE = "<PolymerClassRewriter.java>";
    private final AbstractCompiler compiler;
    private final int polymerVersion;
    private final PolymerExportPolicy polymerExportPolicy;
    private final boolean propertyRenamingEnabled;
    @VisibleForTesting
    static final String POLYMER_ELEMENT_PROP_CONFIG = "PolymerElementProperties";
    static final DiagnosticType IMPLICIT_GLOBAL_CONFLICT = DiagnosticType.error("JSC_POLYMER_IMPLICIT_GLOBAL_CONFLICT", "Implicit global name for Polymer element conflicts with existing var {0}. Either give the element a lhs or rename {0}. (Or move to class-based Polymer 2 elements)");
    static final DiagnosticType POLYMER_ELEMENT_CONFLICT = DiagnosticType.error("JSC_POLYMER_ELEMENT_CONFLICT", "Cannot generate correct types for Polymer call due to PolymerElement definition at {0}:{2}:{1}.\nRename the local PolymerElement to avoid shadowing the PolymerElement externs.");
    private final Node polymerElementExterns;
    boolean propertySinkExternInjected = false;

    PolymerClassRewriter(AbstractCompiler compiler, Node polymerElementExterns, int polymerVersion, PolymerExportPolicy polymerExportPolicy, boolean propertyRenamingEnabled) {
        this.compiler = compiler;
        this.polymerElementExterns = polymerElementExterns;
        this.polymerVersion = polymerVersion;
        this.polymerExportPolicy = polymerExportPolicy;
        this.propertyRenamingEnabled = propertyRenamingEnabled;
    }

    static boolean isIIFE(Node n) {
        return n.isCall() && n.getFirstChild().isFunction();
    }

    static boolean isFunctionArgInGoogLoadModule(Node n) {
        if (!n.isFunction()) {
            return false;
        }
        Node parent = n.getParent();
        return parent != null && NodeUtil.isBundledGoogModuleCall(parent);
    }

    private void insertGeneratedDeclarationCodeToGlobalScope(Node enclosingNode, Node declarationCode) {
        switch (enclosingNode.getToken()) {
            case MODULE_BODY: {
                Node insertionPoint = this.getNodeForInsertion(enclosingNode.getParent());
                insertionPoint.addChildToFront(declarationCode);
                this.compiler.reportChangeToChangeScope(NodeUtil.getEnclosingScript(insertionPoint));
                break;
            }
            case SCRIPT: {
                enclosingNode.addChildToFront(declarationCode);
                this.compiler.reportChangeToChangeScope(NodeUtil.getEnclosingScript(enclosingNode));
                break;
            }
            case CALL: {
                Preconditions.checkState(PolymerClassRewriter.isIIFE(enclosingNode));
                Node enclosingNodeForIIFE = NodeUtil.getEnclosingNode(enclosingNode.getParent(), node -> node.isScript() || node.isModuleBody());
                if (enclosingNodeForIIFE.isScript()) {
                    enclosingNodeForIIFE.addChildToFront(declarationCode);
                    this.compiler.reportChangeToChangeScope(NodeUtil.getEnclosingScript(enclosingNodeForIIFE));
                    break;
                }
                Preconditions.checkState(enclosingNodeForIIFE.isModuleBody());
                Node insertionPoint = this.getNodeForInsertion(enclosingNodeForIIFE.getParent());
                insertionPoint.addChildToFront(declarationCode);
                this.compiler.reportChangeToChangeScope(NodeUtil.getEnclosingScript(insertionPoint));
                break;
            }
            case FUNCTION: {
                Preconditions.checkState(PolymerClassRewriter.isFunctionArgInGoogLoadModule(enclosingNode));
                Node enclosingScript = NodeUtil.getEnclosingScript(enclosingNode);
                Node insertionPoint = this.getNodeForInsertion(enclosingScript);
                insertionPoint.addChildToFront(declarationCode);
                this.compiler.reportChangeToChangeScope(insertionPoint);
                break;
            }
            default: {
                throw new RuntimeException("Enclosing node for Polymer is incorrect");
            }
        }
    }

    private Node getNodeForInsertion(Node enclosingScript) {
        if (NodeUtil.isFromTypeSummary(enclosingScript)) {
            return this.polymerElementExterns.isScript() ? this.polymerElementExterns : this.polymerElementExterns.getParent();
        }
        return this.compiler.getNodeForCodeInsertion(null);
    }

    private void insertGeneratedPropsAndBehaviorCode(Node enclosingNode, Node statements) {
        switch (enclosingNode.getToken()) {
            case MODULE_BODY: {
                if (enclosingNode.getParent().getBooleanProp(Node.GOOG_MODULE)) {
                    Node insertionPoint = PolymerClassRewriter.getInsertionPointForGoogModule(enclosingNode);
                    enclosingNode.addChildrenAfter(statements, insertionPoint);
                    break;
                }
                enclosingNode.addChildrenToFront(statements);
                break;
            }
            case SCRIPT: {
                enclosingNode.addChildrenToFront(statements);
                this.compiler.reportChangeToChangeScope(NodeUtil.getEnclosingScript(enclosingNode));
                break;
            }
            case CALL: {
                Preconditions.checkState(PolymerClassRewriter.isIIFE(enclosingNode));
                Node functionNode = enclosingNode.getFirstChild();
                Node functionBlock = functionNode.getLastChild();
                functionBlock.addChildrenToFront(statements);
                break;
            }
            case FUNCTION: {
                Preconditions.checkState(PolymerClassRewriter.isFunctionArgInGoogLoadModule(enclosingNode));
                Node functionBlock = enclosingNode.getLastChild();
                Node insertionPoint = PolymerClassRewriter.getInsertionPointForGoogModule(functionBlock);
                if (insertionPoint == null) break;
                functionBlock.addChildrenAfter(statements, insertionPoint);
                break;
            }
        }
    }

    void rewritePolymerCall(PolymerClassDefinition cls, NodeTraversal traversal) {
        Node props;
        Node scriptNode;
        FeatureSet oldFeatures;
        FeatureSet newFeatures;
        Var polymerElement;
        Node callParent = cls.definition.getParent();
        Node exprRoot = callParent.isExprResult() ? callParent : callParent.getParent();
        Preconditions.checkState(NodeUtil.isStatementParent(exprRoot.getParent()), exprRoot.getParent());
        Node objLit = Preconditions.checkNotNull(cls.descriptor);
        JSDocInfoBuilder objLitDoc = new JSDocInfoBuilder(true);
        JSTypeExpression jsTypeExpression = new JSTypeExpression(IR.string(cls.target.getQualifiedName() + ".prototype").srcref(exprRoot), exprRoot.getSourceFileName());
        objLitDoc.recordLends(jsTypeExpression);
        objLit.setJSDocInfo(objLitDoc.build());
        this.addTypesToFunctions(objLit, cls.target.getQualifiedName(), cls.defType);
        PolymerPassStaticUtils.switchDollarSignPropsToBrackets(objLit, this.compiler);
        PolymerPassStaticUtils.quoteListenerAndHostAttributeKeys(objLit, this.compiler);
        for (PolymerPass.MemberDefinition prop : cls.props) {
            if (!prop.value.isObjectLit()) continue;
            PolymerPassStaticUtils.switchDollarSignPropsToBrackets(prop.value, this.compiler);
        }
        Node propsAndBehaviorBlock = IR.block();
        JSDocInfoBuilder constructorDoc = this.getConstructorDoc(cls);
        Node ctorKey = cls.constructor.value.getParent();
        if (ctorKey != null) {
            ctorKey.removeProp(Node.JSDOC_INFO_PROP);
        }
        if (!traversal.inGlobalScope() && (polymerElement = (Var)traversal.getScope().getVar("PolymerElement")) != null && !((Scope)polymerElement.getScope()).isGlobal()) {
            Node nameNode = polymerElement.getNameNode();
            this.compiler.report(JSError.make(cls.constructor.value, POLYMER_ELEMENT_CONFLICT, nameNode.getSourceFileName(), Integer.toString(nameNode.getLineno()), Integer.toString(nameNode.getCharno())));
        }
        Node declarationCode = this.generateDeclarationCode(exprRoot, cls, constructorDoc, traversal);
        String basePath = cls.target.getQualifiedName() + ".prototype.";
        this.appendBehaviorPropertiesToBlock(cls, propsAndBehaviorBlock, basePath, false);
        this.appendPropertiesToBlock(cls.props, propsAndBehaviorBlock, basePath, false);
        this.appendBehaviorMembersToBlock(cls, propsAndBehaviorBlock);
        ImmutableList<PolymerPass.MemberDefinition> readOnlyPropsAll = this.parseReadOnlyProperties(cls, propsAndBehaviorBlock);
        ImmutableList<PolymerPass.MemberDefinition> attributeReflectedPropsAll = PolymerClassRewriter.parseAttributeReflectedProperties(cls);
        this.createExportsAndExterns(cls, readOnlyPropsAll, attributeReflectedPropsAll);
        this.removePropertyDocs(objLit, cls.defType);
        Node propsAndBehaviorCode = propsAndBehaviorBlock.removeChildren();
        Node parent = exprRoot.getParent();
        if (!traversal.inGlobalScope() && cls.hasGeneratedLhs && !cls.target.isGetProp()) {
            Node enclosingNode = NodeUtil.getEnclosingNode(parent, node -> node.isScript() || node.isModuleBody() || PolymerClassRewriter.isIIFE(node) || PolymerClassRewriter.isFunctionArgInGoogLoadModule(node));
            this.insertGeneratedDeclarationCodeToGlobalScope(enclosingNode, declarationCode);
            if (propsAndBehaviorCode != null) {
                this.insertGeneratedPropsAndBehaviorCode(enclosingNode, propsAndBehaviorCode);
            }
        } else {
            Node beforeRoot = exprRoot.getPrevious();
            if (beforeRoot == null) {
                if (propsAndBehaviorCode != null) {
                    parent.addChildrenToFront(propsAndBehaviorCode);
                }
                parent.addChildToFront(declarationCode);
            } else {
                if (propsAndBehaviorCode != null) {
                    parent.addChildrenAfter(propsAndBehaviorCode, beforeRoot);
                }
                parent.addChildAfter(declarationCode, beforeRoot);
            }
            this.compiler.reportChangeToEnclosingScope(parent);
        }
        if (propsAndBehaviorCode != null) {
            this.compiler.reportChangeToEnclosingScope(propsAndBehaviorCode);
        }
        if (cls.features != null && !(newFeatures = (oldFeatures = (FeatureSet)(scriptNode = NodeUtil.getEnclosingScript(parent)).getProp(Node.FEATURE_SET)).union(cls.features)).equals(oldFeatures)) {
            scriptNode.putProp(Node.FEATURE_SET, newFeatures);
            this.compiler.reportChangeToChangeScope(scriptNode);
        }
        if (NodeUtil.isNameDeclaration(exprRoot)) {
            Node assignExpr = PolymerClassRewriter.varToAssign(exprRoot);
            parent.replaceChild(exprRoot, assignExpr);
            this.compiler.reportChangeToEnclosingScope(assignExpr);
        }
        if (this.polymerVersion > 1 && this.propertyRenamingEnabled && cls.descriptor != null && (props = NodeUtil.getFirstPropMatchingKey(cls.descriptor, "properties")) != null && props.isObjectLit()) {
            this.addPropertiesConfigObjectReflection(cls, props);
        }
    }

    void rewritePolymerClassDeclaration(Node clazz, NodeTraversal traversal, PolymerClassDefinition cls) {
        if (cls.descriptor != null) {
            this.addTypesToFunctions(cls.descriptor, cls.target.getQualifiedName(), cls.defType);
        }
        PolymerPassStaticUtils.switchDollarSignPropsToBrackets(NodeUtil.getClassMembers(clazz), this.compiler);
        for (PolymerPass.MemberDefinition prop : cls.props) {
            if (!prop.value.isObjectLit()) continue;
            PolymerPassStaticUtils.switchDollarSignPropsToBrackets(prop.value, this.compiler);
        }
        Node block = IR.block();
        this.appendBehaviorPropertiesToBlock(cls, block, cls.target.getQualifiedName() + ".prototype.", false);
        this.appendPropertiesToBlock(cls.props, block, cls.target.getQualifiedName() + ".prototype.", false);
        ImmutableList<PolymerPass.MemberDefinition> readOnlyProps = this.parseReadOnlyProperties(cls, block);
        ImmutableList<PolymerPass.MemberDefinition> attributeReflectedProps = PolymerClassRewriter.parseAttributeReflectedProperties(cls);
        this.createExportsAndExterns(cls, readOnlyProps, attributeReflectedProps);
        if (this.polymerExportPolicy == PolymerExportPolicy.EXPORT_ALL || !readOnlyProps.isEmpty() || !attributeReflectedProps.isEmpty()) {
            Node jsDocInfoNode = NodeUtil.getBestJSDocInfoNode(clazz);
            JSDocInfoBuilder classInfo = JSDocInfoBuilder.maybeCopyFrom(jsDocInfoNode.getJSDocInfo());
            String interfaceName = cls.getInterfaceName(this.compiler.getUniqueNameIdSupplier());
            JSTypeExpression interfaceType = new JSTypeExpression(new Node(Token.BANG, IR.string(interfaceName)).srcrefTree(jsDocInfoNode), VIRTUAL_FILE);
            classInfo.recordImplementedInterface(interfaceType);
            jsDocInfoNode.setJSDocInfo(classInfo.build());
        }
        Node insertAfterReference = NodeUtil.getEnclosingStatement(clazz);
        if (block.hasChildren()) {
            this.removePropertyDocs(cls.descriptor, cls.defType);
            Node newInsertAfterReference = block.getLastChild();
            insertAfterReference.getParent().addChildrenAfter(block.removeChildren(), insertAfterReference);
            this.compiler.reportChangeToEnclosingScope(insertAfterReference);
            insertAfterReference = newInsertAfterReference;
        }
        PolymerClassRewriter.addReturnTypeIfMissing(cls, "is", new JSTypeExpression(IR.string("string"), VIRTUAL_FILE));
        Node type = new Node(Token.BANG);
        Node array = IR.string("Array");
        type.addChildToBack(array);
        Node arrayTemplateType = new Node(Token.BLOCK, IR.string("string"));
        array.addChildToBack(arrayTemplateType);
        PolymerClassRewriter.addReturnTypeIfMissing(cls, "observers", new JSTypeExpression(type, VIRTUAL_FILE));
        PolymerClassRewriter.addReturnTypeIfMissing(cls, "properties", new JSTypeExpression(IR.string(POLYMER_ELEMENT_PROP_CONFIG), VIRTUAL_FILE));
        if (this.propertyRenamingEnabled && cls.descriptor != null) {
            this.convertSimpleObserverStringsToReferences(cls);
            ArrayList<Node> propertySinks = new ArrayList<Node>();
            if (this.polymerExportPolicy != PolymerExportPolicy.EXPORT_ALL) {
                propertySinks.addAll(this.addComputedPropertiesReflectionCalls(cls));
                propertySinks.addAll(this.addComplexObserverReflectionCalls(cls));
            }
            if (!propertySinks.isEmpty()) {
                if (!this.propertySinkExternInjected && traversal.getScope().getVar("JSCOMPILER_PRESERVE") == null) {
                    CheckSideEffects.addExtern(this.compiler);
                    this.propertySinkExternInjected = true;
                }
                for (Node propertyRef : propertySinks) {
                    Node name = IR.name("JSCOMPILER_PRESERVE").srcref(propertyRef);
                    name.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                    Node protectorCall = IR.call(name, propertyRef).srcref(propertyRef);
                    protectorCall.putBooleanProp(Node.FREE_CALL, true);
                    protectorCall = IR.exprResult(protectorCall).useSourceInfoFrom(propertyRef);
                    insertAfterReference.getParent().addChildAfter(protectorCall, insertAfterReference);
                    insertAfterReference = protectorCall;
                }
                this.compiler.reportChangeToEnclosingScope(insertAfterReference);
            }
            this.addPropertiesConfigObjectReflection(cls, cls.descriptor);
        }
    }

    private static void addReturnTypeIfMissing(PolymerClassDefinition cls, String getterPropName, JSTypeExpression jsType) {
        JSDocInfo info;
        Node classMembers = NodeUtil.getClassMembers(cls.definition);
        Node getter = NodeUtil.getFirstGetterMatchingKey(classMembers, getterPropName);
        if (!(getter == null || (info = NodeUtil.getBestJSDocInfo(getter)) != null && info.hasReturnType())) {
            JSDocInfoBuilder builder = JSDocInfoBuilder.maybeCopyFrom(info);
            builder.recordReturnType(jsType);
            jsType.getRoot().useSourceInfoIfMissingFromForTree(getter);
            getter.setJSDocInfo(builder.build());
        }
    }

    private void addPropertiesConfigObjectReflection(PolymerClassDefinition cls, Node propertiesLiteral) {
        Preconditions.checkNotNull(propertiesLiteral);
        Preconditions.checkState(propertiesLiteral.isObjectLit());
        Node parent = propertiesLiteral.getParent();
        Node objReflectCall = IR.call(NodeUtil.newQName(this.compiler, "$jscomp.reflectObject"), cls.target.cloneTree(), propertiesLiteral.detach()).useSourceInfoIfMissingFromForTree(propertiesLiteral);
        parent.addChildToFront(objReflectCall);
        this.compiler.reportChangeToEnclosingScope(parent);
    }

    private void addTypesToFunctions(Node objLit, String thisType, PolymerClassDefinition.DefinitionType defType) {
        Preconditions.checkState(objLit.isObjectLit());
        for (Node keyNode : objLit.children()) {
            Node value = keyNode.getLastChild();
            if (value == null || !value.isFunction()) continue;
            JSDocInfoBuilder fnDoc = JSDocInfoBuilder.maybeCopyFrom(keyNode.getJSDocInfo());
            fnDoc.recordThisType(new JSTypeExpression(new Node(Token.BANG, IR.string(thisType)).srcrefTree(keyNode), VIRTUAL_FILE));
            keyNode.setJSDocInfo(fnDoc.build());
        }
        for (PolymerPass.MemberDefinition property : PolymerPassStaticUtils.extractProperties(objLit, defType, this.compiler, null)) {
            Node defaultValue;
            if (!property.value.isObjectLit() || (defaultValue = NodeUtil.getFirstPropMatchingKey(property.value, "value")) == null || !defaultValue.isFunction()) continue;
            Node defaultValueKey = defaultValue.getParent();
            JSDocInfoBuilder fnDoc = JSDocInfoBuilder.maybeCopyFrom(defaultValueKey.getJSDocInfo());
            fnDoc.recordThisType(new JSTypeExpression(new Node(Token.BANG, IR.string(thisType)).srcrefTree(defaultValueKey), VIRTUAL_FILE));
            fnDoc.recordReturnType(PolymerPassStaticUtils.getTypeFromProperty(property, this.compiler));
            defaultValueKey.setJSDocInfo(fnDoc.build());
        }
    }

    private ImmutableList<PolymerPass.MemberDefinition> parseReadOnlyProperties(PolymerClassDefinition cls, Node block) {
        String qualifiedPath = cls.target.getQualifiedName() + ".prototype.";
        ImmutableList.Builder readOnlyProps = ImmutableList.builder();
        for (PolymerPass.MemberDefinition memberDefinition : cls.props) {
            Node readOnlyValue;
            if (!memberDefinition.value.isObjectLit() || (readOnlyValue = NodeUtil.getFirstPropMatchingKey(memberDefinition.value, "readOnly")) == null || !readOnlyValue.isTrue()) continue;
            Node setter = this.makeReadOnlySetter(memberDefinition, qualifiedPath);
            setter.useSourceInfoIfMissingFromForTree(memberDefinition.name);
            block.addChildToBack(setter);
            readOnlyProps.add(memberDefinition);
        }
        if (cls.behaviorProps != null) {
            for (Map.Entry entry : cls.behaviorProps.entrySet()) {
                Node readOnlyValue;
                PolymerPass.MemberDefinition prop = (PolymerPass.MemberDefinition)entry.getKey();
                if (!prop.value.isObjectLit() || (readOnlyValue = NodeUtil.getFirstPropMatchingKey(prop.value, "readOnly")) == null || !readOnlyValue.isTrue()) continue;
                Node setter = this.makeReadOnlySetter(prop, qualifiedPath);
                setter.useSourceInfoIfMissingFromForTree(prop.name);
                block.addChildToBack(setter);
                readOnlyProps.add(prop);
            }
        }
        return readOnlyProps.build();
    }

    private static ImmutableList<PolymerPass.MemberDefinition> parseAttributeReflectedProperties(PolymerClassDefinition cls) {
        ImmutableList.Builder attrReflectedProps = ImmutableList.builder();
        for (PolymerPass.MemberDefinition memberDefinition : cls.props) {
            Node reflectedValue;
            if (!memberDefinition.value.isObjectLit() || (reflectedValue = NodeUtil.getFirstPropMatchingKey(memberDefinition.value, "reflectToAttribute")) == null || !reflectedValue.isTrue()) continue;
            attrReflectedProps.add(memberDefinition);
        }
        if (cls.behaviorProps != null) {
            for (Map.Entry entry : cls.behaviorProps.entrySet()) {
                Node reflectedValue;
                PolymerPass.MemberDefinition prop = (PolymerPass.MemberDefinition)entry.getKey();
                if (!prop.value.isObjectLit() || (reflectedValue = NodeUtil.getFirstPropMatchingKey(prop.value, "reflectToAttribute")) == null || !reflectedValue.isTrue()) continue;
                attrReflectedProps.add(prop);
            }
        }
        return attrReflectedProps.build();
    }

    private JSDocInfoBuilder getConstructorDoc(PolymerClassDefinition cls) {
        JSDocInfoBuilder constructorDoc = JSDocInfoBuilder.maybeCopyFrom(cls.constructor.info);
        constructorDoc.recordConstructor();
        JSTypeExpression baseType = new JSTypeExpression(new Node(Token.BANG, IR.string(PolymerPassStaticUtils.getPolymerElementType(cls))).srcrefTree(cls.definition), VIRTUAL_FILE);
        constructorDoc.recordBaseType(baseType);
        String interfaceName = cls.getInterfaceName(this.compiler.getUniqueNameIdSupplier());
        JSTypeExpression interfaceType = new JSTypeExpression(new Node(Token.BANG, IR.string(interfaceName)).srcrefTree(cls.definition), VIRTUAL_FILE);
        constructorDoc.recordImplementedInterface(interfaceType);
        return constructorDoc;
    }

    private Node generateDeclarationCode(Node exprRoot, PolymerClassDefinition cls, JSDocInfoBuilder constructorDoc, NodeTraversal traversal) {
        if (cls.target.isGetProp()) {
            Node assign = IR.assign(cls.target.cloneTree(), cls.constructor.value.cloneTree());
            NodeUtil.markNewScopesChanged(assign, this.compiler);
            assign.setJSDocInfo(constructorDoc.build());
            Node exprResult = IR.exprResult(assign);
            exprResult.useSourceInfoIfMissingFromForTree(cls.target);
            return exprResult;
        }
        Node var = IR.var(cls.target.cloneTree(), cls.constructor.value.cloneTree());
        NodeUtil.markNewScopesChanged(var, this.compiler);
        var.useSourceInfoIfMissingFromForTree(exprRoot);
        var.setJSDocInfo(constructorDoc.build());
        String name = cls.target.getString();
        Var existingVar = (Var)traversal.getScope().getSlot(name);
        if (existingVar != null && cls.hasGeneratedLhs) {
            this.compiler.report(JSError.make(cls.constructor.value, IMPLICIT_GLOBAL_CONFLICT, name));
        }
        return var;
    }

    private JSDocInfo replaceJSDocAndAddNewVars(PolymerPass.MemberDefinition prop, JSTypeExpression propType, Node block) {
        JSDocInfoBuilder infoBuilder = JSDocInfoBuilder.maybeCopyFrom(prop.info);
        infoBuilder.recordType(propType);
        JSDocInfo origInfo = infoBuilder.build();
        ImmutableSet<String> propertyNames = propType.getRecordPropertyNames();
        this.createVarsInExternsBlock(block, propertyNames, propType, prop);
        JSTypeExpression unknown = new JSTypeExpression(new Node(Token.QMARK), propType.getSourceName());
        JSDocInfoBuilder newInfoBuilder = JSDocInfoBuilder.maybeCopyFromWithNewType(origInfo, unknown);
        return newInfoBuilder.build();
    }

    private Node getPropertyNode(PolymerPass.MemberDefinition prop, String basePath) {
        if (prop.name.isQuotedString()) {
            return null;
        }
        Node propertyNode = IR.exprResult(NodeUtil.newQName(this.compiler, basePath + prop.name.getString()));
        propertyNode.useSourceInfoIfMissingFromForTree(prop.name);
        return propertyNode;
    }

    private void appendBehaviorPropertiesToBlock(PolymerClassDefinition cls, Node block, String basePath, boolean isExternsBlock) {
        if (cls.behaviors == null || cls.behaviors.isEmpty() || cls.behaviorProps == null) {
            return;
        }
        for (Map.Entry<PolymerPass.MemberDefinition, PolymerBehaviorExtractor.BehaviorDefinition> itr : cls.behaviorProps.entrySet()) {
            JSTypeExpression propType;
            PolymerBehaviorExtractor.BehaviorDefinition behavior = itr.getValue();
            PolymerPass.MemberDefinition prop = itr.getKey();
            Node propertyNode = this.getPropertyNode(prop, basePath);
            if (propertyNode == null || (propType = PolymerPassStaticUtils.getTypeFromProperty(prop, this.compiler)) == null) continue;
            JSDocInfo info = null;
            if (isExternsBlock) {
                info = this.replaceJSDocAndAddNewVars(prop, propType, block);
            } else {
                JSDocInfoBuilder infoBuilder = this.getJSDocInfoBuilderForBehavior(behavior, prop);
                infoBuilder.recordType(propType);
                info = infoBuilder.build();
            }
            propertyNode.getFirstChild().setJSDocInfo(info);
            block.addChildToBack(propertyNode);
        }
    }

    private void appendPropertiesToBlock(List<PolymerPass.MemberDefinition> props, Node block, String basePath, boolean isExternsBlock) {
        for (PolymerPass.MemberDefinition prop : props) {
            JSTypeExpression propType;
            Node propertyNode = this.getPropertyNode(prop, basePath);
            if (propertyNode == null || (propType = PolymerPassStaticUtils.getTypeFromProperty(prop, this.compiler)) == null) continue;
            JSDocInfo info = null;
            if (isExternsBlock) {
                info = this.replaceJSDocAndAddNewVars(prop, propType, block);
            } else {
                JSDocInfoBuilder infoBuilder = JSDocInfoBuilder.maybeCopyFrom(prop.info);
                infoBuilder.recordType(propType);
                info = infoBuilder.build();
            }
            propertyNode.getFirstChild().setJSDocInfo(info);
            block.addChildToBack(propertyNode);
        }
    }

    private void createVarsInExternsBlock(Node block, ImmutableSet<String> propertyNames, JSTypeExpression propType, PolymerPass.MemberDefinition prop) {
        for (String propName : propertyNames) {
            String varName = "PolymerDummyVar" + this.compiler.getUniqueNameIdSupplier().get();
            Node n = Node.newString(Token.NAME, varName);
            Node var = new Node(Token.VAR);
            var.addChildToBack(n);
            JSTypeExpression newType = PolymerClassRewriter.createNewTypeExpressionForExtern(propName, propType.getSourceName(), prop);
            JSDocInfoBuilder oldInfoBuilder = JSDocInfoBuilder.maybeCopyFrom(prop.info);
            JSDocInfo info = oldInfoBuilder.build();
            JSDocInfoBuilder newInfo = JSDocInfoBuilder.copyFromWithNewType(info, newType);
            var.setJSDocInfo(newInfo.build());
            block.addChildToBack(var);
        }
    }

    private static JSTypeExpression createNewTypeExpressionForExtern(String propName, String sourceName, PolymerPass.MemberDefinition prop) {
        Node leftCurly = new Node(Token.LC);
        Node leftBracket = new Node(Token.LB);
        Node colon = new Node(Token.COLON);
        Node propertyName = Node.newString(propName);
        propertyName.setToken(Token.STRING_KEY);
        Node unknown = new Node(Token.QMARK);
        colon.addChildToBack(propertyName);
        colon.addChildToBack(unknown);
        leftBracket.addChildToBack(colon);
        leftCurly.addChildToBack(leftBracket);
        leftCurly.useSourceInfoIfMissingFromForTree(prop.name);
        return new JSTypeExpression(leftCurly, sourceName);
    }

    private void removePropertyDocs(Node objLit, PolymerClassDefinition.DefinitionType defType) {
        for (PolymerPass.MemberDefinition prop : PolymerPassStaticUtils.extractProperties(objLit, defType, this.compiler, null)) {
            prop.name.removeProp(Node.JSDOC_INFO_PROP);
        }
    }

    private Map<String, Var> accumulateModuleLocalVars(PolymerBehaviorExtractor.BehaviorDefinition behavior) {
        LinkedHashMap<String, Var> moduleLocalNames = new LinkedHashMap<String, Var>();
        ArrayList<Var> orderedNames = new ArrayList<Var>();
        SyntacticScopeCreator scopeCreator = new SyntacticScopeCreator(this.compiler);
        Scope globalScope = Scope.createGlobalScope(behavior.behaviorModule.getParent());
        NodeUtil.getAllVarsDeclaredInModule(behavior.behaviorModule, moduleLocalNames, orderedNames, this.compiler, scopeCreator, globalScope);
        return moduleLocalNames;
    }

    private JSDocInfoBuilder getJSDocInfoBuilderForBehavior(PolymerBehaviorExtractor.BehaviorDefinition behavior, PolymerPass.MemberDefinition behaviorFunctionOrProp) {
        JSDocInfoBuilder info;
        if (!behavior.isGlobalDeclaration && behaviorFunctionOrProp.info != null && behaviorFunctionOrProp.info.containsTypeDeclaration()) {
            if (behavior.behaviorModule != null) {
                Map<String, Var> moduleLocalNames = this.accumulateModuleLocalVars(behavior);
                info = JSDocInfoBuilder.maybeCopyFromAndReplaceNames(behaviorFunctionOrProp.info, moduleLocalNames.keySet());
            } else {
                info = JSDocInfoBuilder.maybeCopyFrom(behaviorFunctionOrProp.info);
            }
        } else {
            info = JSDocInfoBuilder.maybeCopyFrom(behaviorFunctionOrProp.info);
        }
        return info;
    }

    private void appendBehaviorMembersToBlock(PolymerClassDefinition cls, Node block) {
        String qualifiedPath = cls.target.getQualifiedName() + ".prototype.";
        HashMap<String, Node> nameToExprResult = new HashMap<String, Node>();
        for (PolymerBehaviorExtractor.BehaviorDefinition behavior : cls.behaviors) {
            for (PolymerPass.MemberDefinition behaviorFunction : behavior.functionsToCopy) {
                String fnName = behaviorFunction.name.getString();
                if (NodeUtil.getFirstPropMatchingKey(cls.descriptor, fnName) != null) continue;
                if (nameToExprResult.containsKey(fnName)) {
                    block.removeChild((Node)nameToExprResult.get(fnName));
                }
                Node fnValue = behaviorFunction.value.cloneTree();
                NodeUtil.markNewScopesChanged(fnValue, this.compiler);
                Node exprResult = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, qualifiedPath + fnName), fnValue));
                exprResult.useSourceInfoIfMissingFromForTree(behaviorFunction.name);
                JSDocInfoBuilder info = this.getJSDocInfoBuilderForBehavior(behavior, behaviorFunction);
                info.addSuppression("unusedPrivateMembers");
                if (behaviorFunction.info != null && behaviorFunction.info.getVisibility() == JSDocInfo.Visibility.PROTECTED) {
                    info.overwriteVisibility(JSDocInfo.Visibility.PUBLIC);
                }
                if (!behavior.isGlobalDeclaration) {
                    Node body = NodeUtil.getFunctionBody(fnValue);
                    if (fnValue.isArrowFunction() && !NodeUtil.getFunctionBody(fnValue).isBlock()) {
                        body.replaceWith(NodeUtil.newUndefinedNode(body));
                    } else {
                        body.removeChildren();
                    }
                    int paramIndex = 0;
                    for (Node param : NodeUtil.getFunctionParameters(fnValue).children()) {
                        PolymerClassRewriter.makeParamSafe(param, paramIndex++);
                    }
                }
                exprResult.getFirstChild().setJSDocInfo(info.build());
                block.addChildToBack(exprResult);
                nameToExprResult.put(fnName, exprResult);
            }
            for (PolymerPass.MemberDefinition behaviorProp : behavior.nonPropertyMembersToCopy) {
                String propName = behaviorProp.name.getString();
                if (nameToExprResult.containsKey(propName)) {
                    block.removeChild((Node)nameToExprResult.get(propName));
                }
                Node exprResult = IR.exprResult(NodeUtil.newQName(this.compiler, qualifiedPath + propName));
                exprResult.useSourceInfoFromForTree(behaviorProp.name);
                JSDocInfoBuilder info = this.getJSDocInfoBuilderForBehavior(behavior, behaviorProp);
                if (behaviorProp.name.isGetterDef()) {
                    info = new JSDocInfoBuilder(true);
                    if (behaviorProp.info != null && behaviorProp.info.getReturnType() != null) {
                        info.recordType(behaviorProp.info.getReturnType());
                    }
                }
                exprResult.getFirstChild().setJSDocInfo(info.build());
                block.addChildToBack(exprResult);
                nameToExprResult.put(propName, exprResult);
            }
        }
    }

    private static void makeParamSafe(Node param, int index) {
        if (param.isRest()) {
            param = param.getOnlyChild();
        } else if (param.isDefaultValue()) {
            Node value = param.getSecondChild();
            value.replaceWith(NodeUtil.newUndefinedNode(param));
            param = param.getFirstChild();
        }
        if (param.isDestructuringPattern()) {
            param.replaceWith(IR.name("param$polymer$" + index).srcref(param));
        }
    }

    private Node makeReadOnlySetter(PolymerPass.MemberDefinition prop, String qualifiedPath) {
        String propName = prop.name.getString();
        String setterName = "_set" + propName.substring(0, 1).toUpperCase(Locale.ROOT) + propName.substring(1);
        Node fnNode = IR.function(IR.name(""), IR.paramList(IR.name(propName)), IR.block());
        this.compiler.reportChangeToChangeScope(fnNode);
        Node exprResNode = IR.exprResult(IR.assign(NodeUtil.newQName(this.compiler, qualifiedPath + setterName), fnNode));
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        info.recordOverride();
        JSTypeExpression propType = PolymerPassStaticUtils.getTypeFromProperty(prop, this.compiler);
        info.recordParameter(propName, propType);
        exprResNode.getFirstChild().setJSDocInfo(info.build());
        return exprResNode;
    }

    private void createExportsAndExterns(PolymerClassDefinition cls, List<PolymerPass.MemberDefinition> readOnlyProps, List<PolymerPass.MemberDefinition> attributeReflectedProps) {
        Node block = IR.block();
        String interfaceName = cls.getInterfaceName(this.compiler.getUniqueNameIdSupplier());
        Node fnNode = NodeUtil.emptyFunction();
        this.compiler.reportChangeToChangeScope(fnNode);
        Node varNode = IR.var(NodeUtil.newQName(this.compiler, interfaceName), fnNode);
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        info.recordInterface();
        varNode.setJSDocInfo(info.build());
        block.addChildToBack(varNode);
        String interfaceBasePath = interfaceName + ".prototype.";
        if (this.polymerExportPolicy == PolymerExportPolicy.EXPORT_ALL) {
            this.appendBehaviorPropertiesToBlock(cls, block, interfaceBasePath, true);
            this.appendPropertiesToBlock(cls.props, block, interfaceBasePath, true);
            LinkedHashMap<String, PolymerPass.MemberDefinition> uniqueMethods = new LinkedHashMap<String, PolymerPass.MemberDefinition>();
            if (cls.behaviors != null) {
                for (PolymerBehaviorExtractor.BehaviorDefinition behavior : cls.behaviors) {
                    for (PolymerPass.MemberDefinition method : behavior.functionsToCopy) {
                        uniqueMethods.put(method.name.getString(), method);
                    }
                }
            }
            for (PolymerPass.MemberDefinition method : cls.methods) {
                uniqueMethods.put(method.name.getString(), method);
            }
            for (PolymerPass.MemberDefinition method : uniqueMethods.values()) {
                this.addMethodToObjectExternsUsingExportAnnotation(cls, method);
            }
        } else if (this.polymerVersion == 1) {
            this.appendBehaviorPropertiesToBlock(cls, block, interfaceBasePath, true);
            this.appendPropertiesToBlock(cls.props, block, interfaceBasePath, true);
        } else {
            ArrayList<PolymerPass.MemberDefinition> interfaceProperties = new ArrayList<PolymerPass.MemberDefinition>();
            interfaceProperties.addAll(readOnlyProps);
            if (attributeReflectedProps != null) {
                interfaceProperties.addAll(attributeReflectedProps);
            }
            this.appendPropertiesToBlock(interfaceProperties, block, interfaceBasePath, true);
        }
        for (PolymerPass.MemberDefinition prop : readOnlyProps) {
            String propName = prop.name.getString();
            String setterName = "_set" + propName.substring(0, 1).toUpperCase(Locale.ROOT) + propName.substring(1);
            Node setterExprNode = IR.exprResult(NodeUtil.newQName(this.compiler, interfaceBasePath + setterName));
            JSDocInfoBuilder setterInfo = new JSDocInfoBuilder(true);
            JSTypeExpression propType = PolymerPassStaticUtils.getTypeFromProperty(prop, this.compiler);
            JSTypeExpression unknown = new JSTypeExpression(new Node(Token.QMARK), propType.getSourceName());
            setterInfo.recordParameter(propName, unknown);
            setterExprNode.getFirstChild().setJSDocInfo(setterInfo.build());
            block.addChildToBack(setterExprNode);
        }
        block.useSourceInfoIfMissingFromForTree(this.polymerElementExterns);
        Node scopeRoot = this.polymerElementExterns;
        if (!scopeRoot.isScript()) {
            scopeRoot = scopeRoot.getParent();
        }
        Node stmts = block.removeChildren();
        scopeRoot.addChildrenToBack(stmts);
        this.compiler.reportChangeToEnclosingScope(stmts);
    }

    private void addMethodToObjectExternsUsingExportAnnotation(PolymerClassDefinition cls, PolymerPass.MemberDefinition method) {
        Node getprop = NodeUtil.newQName(this.compiler, cls.target.getQualifiedName() + ".prototype." + method.name.getString());
        JSDocInfoBuilder info = new JSDocInfoBuilder(true);
        if (method.info != null) {
            info.recordVisibility(method.info.getVisibility());
        }
        info.recordExport();
        getprop.setJSDocInfo(info.build());
        Node expression = IR.exprResult(getprop).useSourceInfoIfMissingFromForTree(method.name);
        Node insertAfter = cls.definition;
        while (!NodeUtil.isStatementBlock(insertAfter.getParent())) {
            insertAfter = insertAfter.getParent();
        }
        insertAfter.getParent().addChildAfter(expression, insertAfter);
        this.compiler.reportChangeToEnclosingScope(expression);
    }

    private static Node varToAssign(Node var) {
        Node assign = IR.assign(var.getFirstChild().cloneNode(), var.getFirstChild().removeFirstChild());
        return IR.exprResult(assign).useSourceInfoIfMissingFromForTree(var);
    }

    private void convertSimpleObserverStringsToReferences(PolymerClassDefinition cls) {
        for (PolymerPass.MemberDefinition prop : cls.props) {
            Node observer;
            if (!prop.value.isObjectLit() || (observer = NodeUtil.getFirstPropMatchingKey(prop.value, "observer")) == null || !observer.isString()) continue;
            Node observerDirectReference = IR.getprop(cls.target.cloneTree(), "prototype", observer.getString()).useSourceInfoFrom(observer);
            observer.replaceWith(observerDirectReference);
            this.compiler.reportChangeToEnclosingScope(observerDirectReference);
        }
    }

    private List<Node> addComputedPropertiesReflectionCalls(PolymerClassDefinition cls) {
        ArrayList<Node> propertySinkStatements = new ArrayList<Node>();
        for (PolymerPass.MemberDefinition prop : cls.props) {
            Node computed;
            if (!prop.value.isObjectLit() || (computed = NodeUtil.getFirstPropMatchingKey(prop.value, "computed")) == null || !computed.isString()) continue;
            propertySinkStatements.addAll(this.replaceMethodStringWithReflectedCalls(cls.target, computed));
        }
        return propertySinkStatements;
    }

    private List<Node> addComplexObserverReflectionCalls(PolymerClassDefinition cls) {
        ArrayList<Node> propertySinkStatements = new ArrayList<Node>();
        Node classMembers = NodeUtil.getClassMembers(cls.definition);
        Node getter = NodeUtil.getFirstGetterMatchingKey(classMembers, "observers");
        if (getter != null) {
            Node complexObservers = null;
            for (Node child : NodeUtil.getFunctionBody(getter.getFirstChild()).children()) {
                if (!child.isReturn() || !child.hasChildren() || !child.getFirstChild().isArrayLit()) continue;
                complexObservers = child.getFirstChild();
                break;
            }
            if (complexObservers != null) {
                for (Node complexObserver : complexObservers.children()) {
                    if (!complexObserver.isString()) continue;
                    propertySinkStatements.addAll(this.replaceMethodStringWithReflectedCalls(cls.target, complexObserver));
                }
            }
        }
        return propertySinkStatements;
    }

    private List<Node> replaceMethodStringWithReflectedCalls(Node className, Node methodSignature) {
        Node reflectedMethodName;
        Preconditions.checkArgument(methodSignature.isString());
        ArrayList<Node> propertySinkStatements = new ArrayList<Node>();
        String methodSignatureString = methodSignature.getString().trim();
        int openParenIndex = methodSignatureString.indexOf(40);
        if (methodSignatureString.charAt(methodSignatureString.length() - 1) != ')' || openParenIndex < 1) {
            this.compiler.report(JSError.make(methodSignature, PolymerPassErrors.POLYMER_UNPARSABLE_STRING, new String[0]));
            return propertySinkStatements;
        }
        JSDocInfoBuilder classTypeDoc = new JSDocInfoBuilder(false);
        JSTypeExpression classType = new JSTypeExpression(new Node(Token.BANG, IR.string(className.getQualifiedName())).srcrefTree(methodSignature), className.getSourceFileName());
        classTypeDoc.recordType(classType);
        Node classTypeExpression = IR.cast(IR.objectlit(new Node[0]), classTypeDoc.build());
        String methodName = methodSignatureString.substring(0, openParenIndex).trim();
        propertySinkStatements.add(IR.getprop(className.cloneTree(), "prototype", methodName).useSourceInfoFromForTree(methodSignature));
        Node reflectedSignature = reflectedMethodName = IR.call(IR.getprop(IR.name("$jscomp"), IR.string("reflectProperty")), IR.string(methodName), classTypeExpression.cloneTree());
        String nextParamDelimeter = "(";
        if (openParenIndex < methodSignatureString.length() - 2) {
            String methodParamsString = methodSignatureString.substring(openParenIndex + 1, methodSignatureString.length() - 1).trim();
            List<String> methodParams = this.parseMethodParams(methodParamsString, methodSignature);
            for (String methodParam : methodParams) {
                Node reflectedTypeReference = classTypeExpression;
                if (methodParam.length() == 0) continue;
                if (PolymerClassRewriter.isParamLiteral(methodParam)) {
                    Node term = IR.string(methodParam);
                    reflectedSignature = IR.add(IR.add(reflectedSignature, IR.string(nextParamDelimeter)), term);
                } else {
                    List<String> paramParts = Splitter.on('.').splitToList(methodParam);
                    String nextPropertyTermDelimiter = nextParamDelimeter;
                    for (int i = 0; i < paramParts.size(); ++i) {
                        if (i > 0 && i == paramParts.size() - 1 && (paramParts.get(i).equals("*") || paramParts.get(i).equals("splices"))) {
                            reflectedSignature = IR.add(reflectedSignature, IR.string(nextPropertyTermDelimiter + paramParts.get(i)));
                        } else {
                            if (i == 0) {
                                propertySinkStatements.add(IR.getprop(className.cloneTree(), IR.string("prototype"), IR.string(paramParts.get(i))).useSourceInfoFromForTree(methodSignature));
                            }
                            Node reflectedParamPart = IR.call(IR.getprop(IR.name("$jscomp"), IR.string("reflectProperty")), IR.string(paramParts.get(i)), reflectedTypeReference.cloneTree());
                            reflectedSignature = IR.add(IR.add(reflectedSignature, IR.string(nextPropertyTermDelimiter)), reflectedParamPart);
                            reflectedTypeReference = IR.getprop(reflectedTypeReference.cloneTree(), paramParts.get(i), new String[0]);
                        }
                        nextPropertyTermDelimiter = ".";
                    }
                }
                nextParamDelimeter = ",";
            }
            reflectedSignature = methodParams.isEmpty() ? IR.add(reflectedSignature, IR.string("()")) : IR.add(reflectedSignature, IR.string(")"));
        } else {
            reflectedSignature = IR.add(reflectedSignature, IR.string("()"));
        }
        methodSignature.replaceWith(reflectedSignature.useSourceInfoFromForTree(methodSignature));
        this.compiler.reportChangeToEnclosingScope(reflectedSignature);
        return propertySinkStatements;
    }

    private List<String> parseMethodParams(String methodParameters, Node methodSignature) {
        ArrayList<String> parsedParameters = new ArrayList<String>();
        int nextDelimeter = 44;
        String currentTerm = "";
        for (int i = 0; i < methodParameters.length(); ++i) {
            if (methodParameters.charAt(i) == nextDelimeter) {
                if (nextDelimeter == 44) {
                    parsedParameters.add(currentTerm.trim());
                    currentTerm = "";
                    continue;
                }
                currentTerm = currentTerm + (char)nextDelimeter;
                nextDelimeter = 44;
                continue;
            }
            currentTerm = currentTerm + methodParameters.charAt(i);
            if (methodParameters.charAt(i) != '\"' && methodParameters.charAt(i) != '\'') continue;
            nextDelimeter = methodParameters.charAt(i);
        }
        if (nextDelimeter != 44) {
            this.compiler.report(JSError.make(methodSignature, PolymerPassErrors.POLYMER_UNPARSABLE_STRING, new String[0]));
            return parsedParameters;
        }
        if (currentTerm.length() > 0) {
            parsedParameters.add(currentTerm.trim());
        }
        return parsedParameters;
    }

    private static boolean isParamLiteral(String param) {
        try {
            Double.parseDouble(param);
            return true;
        }
        catch (NumberFormatException e) {
            return param.length() > 1 && (param.charAt(0) == '\"' || param.charAt(0) == '\'') && param.charAt(0) == param.charAt(param.length() - 1);
        }
    }

    private static Node getInsertionPointForGoogModule(Node moduleBody) {
        Node insertionPoint = moduleBody.getFirstChild();
        Node next = insertionPoint.getNext();
        while (PolymerClassRewriter.isGoogRequireExpr(next) || NodeUtil.isGoogModuleDeclareLegacyNamespaceCall(next) || NodeUtil.isGoogSetTestOnlyCall(next)) {
            insertionPoint = next;
            next = next.getNext();
        }
        return insertionPoint;
    }

    private static boolean isGoogRequireExpr(Node statement) {
        if (NodeUtil.isExprCall(statement) && ModuleImportResolver.isGoogModuleDependencyCall(statement.getOnlyChild())) {
            return true;
        }
        if (!NodeUtil.isNameDeclaration(statement)) {
            return false;
        }
        Node rhs = statement.getFirstChild().isName() ? statement.getFirstFirstChild() : statement.getFirstChild().getSecondChild();
        return ModuleImportResolver.isGoogModuleDependencyCall(rhs);
    }
}

