/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.debugging.sourcemap.proto.Mapping;
import com.google.javascript.jscomp.Region;
import javax.annotation.Nullable;

public interface SourceExcerptProvider {
    public String getSourceLine(String var1, int var2);

    @Nullable
    public Region getSourceLines(String var1, int var2, int var3);

    @Nullable
    public Region getSourceRegion(String var1, int var2);

    public Mapping.OriginalMapping getSourceMapping(String var1, int var2, int var3);

    public static interface ExcerptFormatter {
        public String formatLine(String var1, int var2);

        public String formatRegion(@Nullable Region var1);
    }

    public static enum SourceExcerpt {
        LINE{

            @Override
            public String get(SourceExcerptProvider source, String sourceName, int lineNumber, int unused, ExcerptFormatter formatter) {
                return formatter.formatLine(source.getSourceLine(sourceName, lineNumber), lineNumber);
            }
        }
        ,
        FULL{

            @Override
            public String get(SourceExcerptProvider source, String sourceName, int startLineNumber, int length, ExcerptFormatter formatter) {
                return formatter.formatRegion(source.getSourceLines(sourceName, startLineNumber, length));
            }
        }
        ,
        REGION{

            @Override
            public String get(SourceExcerptProvider source, String sourceName, int lineNumber, int length, ExcerptFormatter formatter) {
                return formatter.formatRegion(source.getSourceRegion(sourceName, lineNumber));
            }
        };


        public String get(SourceExcerptProvider source, String sourceName, int lineNumber, ExcerptFormatter formatter) {
            return this.get(source, sourceName, lineNumber, -1, formatter);
        }

        public abstract String get(SourceExcerptProvider var1, String var2, int var3, int var4, ExcerptFormatter var5);
    }
}

