/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.DoNotCall;
import com.google.javascript.jscomp.disambiguate.FlatType;
import com.google.javascript.jscomp.graph.StandardUnionFind;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

final class PropertyClustering {
    private final String name;
    @Nullable
    private LinkedHashMap<Node, FlatType> useSites = new LinkedHashMap();
    @Nullable
    private StandardUnionFind<FlatType> clusters = new StandardUnionFind();
    @Nullable
    private FlatType externsClusterElem;

    PropertyClustering(String name) {
        this.name = Preconditions.checkNotNull(name);
    }

    String getName() {
        return this.name;
    }

    LinkedHashMap<Node, FlatType> getUseSites() {
        return Preconditions.checkNotNull(this.useSites);
    }

    StandardUnionFind<FlatType> getClusters() {
        return Preconditions.checkNotNull(this.clusters);
    }

    @Nullable
    FlatType getExternsClusterRep() {
        Preconditions.checkState(!this.isInvalidated());
        return this.externsClusterElem == null ? null : this.clusters.find(this.externsClusterElem);
    }

    boolean isInvalidated() {
        return this.clusters == null;
    }

    void invalidate() {
        this.clusters = null;
        this.externsClusterElem = null;
        this.useSites = null;
    }

    void registerExternType(FlatType extern) {
        Preconditions.checkState(!this.isInvalidated());
        if (this.externsClusterElem == null) {
            this.externsClusterElem = extern;
        }
        this.clusters.union(this.externsClusterElem, extern);
    }

    @DoNotCall
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).toString();
    }
}

