/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.exif;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateCameraDate;
import org.fibs.geotag.data.UpdateCityName;
import org.fibs.geotag.data.UpdateCountryName;
import org.fibs.geotag.data.UpdateGPSAltitude;
import org.fibs.geotag.data.UpdateGPSDateTime;
import org.fibs.geotag.data.UpdateGPSImgDirection;
import org.fibs.geotag.data.UpdateGPSLatitude;
import org.fibs.geotag.data.UpdateGPSLongitude;
import org.fibs.geotag.data.UpdateLocationName;
import org.fibs.geotag.data.UpdateProvinceName;
import org.fibs.geotag.data.UpdateUserComment;
import org.fibs.geotag.exif.ExifReader;
import org.fibs.geotag.util.Units;

public class MetadataExtractorReader
implements ExifReader {
    private double rationalsToDegrees(Rational[] rationals) {
        double degrees = 0.0;
        if (rationals[0].getDenominator() != 0) {
            degrees += rationals[0].doubleValue();
        }
        if (rationals[1].getDenominator() != 0) {
            degrees += rationals[1].doubleValue() / 60.0;
        }
        if (rationals[2].getDenominator() != 0) {
            degrees += rationals[2].doubleValue() / 3600.0;
        }
        return degrees;
    }

    @Override
    public ImageInfo readExifData(File file, ImageInfo reuseImageInfo) {
        ImageInfo imageInfo = reuseImageInfo;
        if (imageInfo == null && (imageInfo = ImageInfo.getImageInfo(file.getPath())) == null) {
            imageInfo = new ImageInfo(file);
        }
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(file);
            Iterator directories = metadata.getDirectoryIterator();
            while (directories.hasNext()) {
                Directory directory = (Directory)directories.next();
                if (directory.getName().equals("Exif")) {
                    this.readExifDirectory(file, imageInfo, directory);
                    continue;
                }
                if (directory.getName().equals("GPS")) {
                    this.readGpsDirectory(imageInfo, directory);
                    continue;
                }
                if (!directory.getName().equals("Iptc")) continue;
                this.readIptcDirectory(imageInfo, directory);
            }
            return imageInfo;
        }
        catch (JpegProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void readIptcDirectory(ImageInfo imageInfo, Directory directory) {
        String location;
        try {
            location = directory.getString(602);
            new UpdateCityName(imageInfo, location, ImageInfo.DATA_SOURCE.IMAGE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String country = directory.getString(613);
            new UpdateCountryName(imageInfo, country, ImageInfo.DATA_SOURCE.IMAGE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String province = directory.getString(607);
            new UpdateProvinceName(imageInfo, province, ImageInfo.DATA_SOURCE.IMAGE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (directory.containsTag(539)) {
                location = directory.getString(539);
                new UpdateLocationName(imageInfo, location, ImageInfo.DATA_SOURCE.IMAGE);
            } else if (directory.containsTag(604)) {
                location = directory.getString(604);
                new UpdateLocationName(imageInfo, location, ImageInfo.DATA_SOURCE.IMAGE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readGpsDirectory(ImageInfo imageInfo, Directory directory) {
        Rational[] rationals;
        int ref;
        Rational rational;
        try {
            if (directory.containsTag(6)) {
                rational = directory.getRational(6);
                double altitude = rational.doubleValue();
                ref = directory.getInt(5);
                if (ref == 1) {
                    altitude = -altitude;
                }
                new UpdateGPSAltitude(imageInfo, Double.toString(altitude), ImageInfo.DATA_SOURCE.IMAGE, Units.ALTITUDE.METRES);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (directory.containsTag(17)) {
                rational = directory.getRational(17);
                double direction = rational.doubleValue();
                new UpdateGPSImgDirection(imageInfo, Double.toString(direction), ImageInfo.DATA_SOURCE.IMAGE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (directory.containsTag(2)) {
                rationals = directory.getRationalArray(2);
                double latitude = this.rationalsToDegrees(rationals);
                ref = (char)directory.getByteArray(1)[0];
                if (ref == 83) {
                    latitude = -latitude;
                }
                new UpdateGPSLatitude(imageInfo, Double.toString(latitude), ImageInfo.DATA_SOURCE.IMAGE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (directory.containsTag(4)) {
                rationals = directory.getRationalArray(4);
                double longitude = this.rationalsToDegrees(rationals);
                ref = (char)directory.getByteArray(3)[0];
                if (ref == 87) {
                    longitude = -longitude;
                }
                new UpdateGPSLongitude(imageInfo, Double.toString(longitude), ImageInfo.DATA_SOURCE.IMAGE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String time = null;
        try {
            if (directory.containsTag(7)) {
                Rational[] rationals2 = directory.getRationalArray(7);
                int hours = rationals2[0].intValue();
                int minutes = rationals2[1].intValue();
                int seconds = rationals2[2].intValue();
                time = String.format("%02d:%02d:%02d", hours, minutes, seconds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String date = null;
        try {
            if (directory.containsTag(29)) {
                date = directory.getString(29);
                date = date.replace('-', ':');
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (date != null && time != null) {
            new UpdateGPSDateTime(imageInfo, String.valueOf(date) + ' ' + time);
        }
    }

    private void readExifDirectory(File file, ImageInfo imageInfo, Directory directory) {
        String cameraDate = directory.getString(36867);
        if (cameraDate == null) {
            cameraDate = directory.getString(36868);
        }
        if (cameraDate == null) {
            cameraDate = directory.getString(306);
        }
        if (cameraDate == null) {
            long lastModified = file.lastModified();
            SimpleDateFormat dateFormat = new SimpleDateFormat(ImageInfo.getDateFormatPattern());
            Date date = new Date(lastModified);
            cameraDate = dateFormat.format(date);
        }
        new UpdateCameraDate(imageInfo, cameraDate);
        imageInfo.setGpsDateTime();
        try {
            if (directory.containsTag(274)) {
                int orientation = directory.getInt(274);
                imageInfo.setOrientation(Integer.toString(orientation));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (directory.containsTag(40962)) {
                int width = directory.getInt(40962);
                imageInfo.setWidth(width);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (directory.containsTag(40963)) {
                int height = directory.getInt(40963);
                imageInfo.setHeight(height);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (directory.containsTag(37510)) {
                String comment = directory.getDescription(37510);
                new UpdateUserComment(imageInfo, comment, ImageInfo.DATA_SOURCE.IMAGE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

