/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.usage;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.tree.OWLLinkedObjectTree;
import org.protege.editor.owl.ui.usage.UsageByEntityTreeModel;
import org.protege.editor.owl.ui.usage.UsagePreferences;
import org.protege.editor.owl.ui.view.ChangeListenerMediator;
import org.protege.editor.owl.ui.view.Copyable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class UsageTree
extends OWLLinkedObjectTree
implements Copyable {
    private OWLEditorKit owlEditorKit;
    private OWLEntity entity;
    private final ChangeListenerMediator changeListenerMediator = new ChangeListenerMediator();

    public UsageTree(OWLEditorKit owlEditorKit) {
        super(owlEditorKit);
        this.owlEditorKit = owlEditorKit;
        this.setCellRenderer(new UsageTreeCellRenderer(owlEditorKit));
        this.getSelectionModel().addTreeSelectionListener(e -> this.changeListenerMediator.fireStateChanged(this));
    }

    @Override
    public boolean canCopy() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths == null) {
            return false;
        }
        return Arrays.stream(selectionPaths).map(TreePath::getLastPathComponent).filter(node -> node instanceof UsageByEntityTreeModel.UsageTreeNode).findFirst().isPresent();
    }

    @Override
    public List<OWLObject> getObjectsToCopy() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(selectionPaths).map(TreePath::getLastPathComponent).filter(node -> node instanceof UsageByEntityTreeModel.UsageTreeNode).map(node -> ((UsageByEntityTreeModel.UsageTreeNode)node).getAxiom()).collect(Collectors.toList());
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeListenerMediator.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListenerMediator.removeChangeListener(changeListener);
    }

    public void setOWLEntity(OWLEntity entity) {
        this.entity = entity;
        UsagePreferences p = UsagePreferences.getInstance();
        UsageByEntityTreeModel model = new UsageByEntityTreeModel(this.owlEditorKit);
        model.addFilters(p.getActiveFilters());
        model.setOWLEntity(entity);
        this.setModel(model);
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
            if (i > 100) break;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        g.setColor(Color.LIGHT_GRAY);
        for (int i = 0; i < this.getRowCount(); ++i) {
            Rectangle rowBounds = this.getRowBounds(i);
            if (!g.getClipBounds().intersects(rowBounds) || this.getPathForRow(i).getPathCount() != 2) continue;
            g.drawLine(0, rowBounds.y, this.getWidth(), rowBounds.y);
        }
        g.setColor(oldColor);
    }

    private class UsageTreeCellRenderer
    extends OWLCellRenderer {
        public UsageTreeCellRenderer(OWLEditorKit owlEditorKit) {
            super(owlEditorKit);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            this.setFocusedEntity(UsageTree.this.entity);
            JComponent c = (JComponent)super.getTreeCellRendererComponent(tree, node.getUserObject(), sel, expanded, leaf, row, hasFocus);
            if (node.getUserObject() instanceof OWLAxiom) {
                if (node.getParent().getIndex(node) == node.getParent().getChildCount() - 1) {
                    c.setBorder(BorderFactory.createMatteBorder(1, 20, 20, 0, tree.getBackground()));
                } else {
                    c.setBorder(BorderFactory.createMatteBorder(1, 20, 0, 0, tree.getBackground()));
                }
            } else {
                c.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
            }
            this.setHighlightKeywords(true);
            return c;
        }
    }
}

