/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import javax.websocket.CloseReason;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.AsyncChannelWrapper;
import org.apache.tomcat.websocket.ReadBufferOverflowException;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.WsFrameBase;
import org.apache.tomcat.websocket.WsIOException;
import org.apache.tomcat.websocket.WsSession;

public class WsFrameClient
extends WsFrameBase {
    private final Log log = LogFactory.getLog(WsFrameClient.class);
    private static final StringManager sm = StringManager.getManager(WsFrameClient.class);
    private final AsyncChannelWrapper channel;
    private final CompletionHandler<Integer, Void> handler;
    private volatile ByteBuffer response;

    public WsFrameClient(ByteBuffer byteBuffer, AsyncChannelWrapper asyncChannelWrapper, WsSession wsSession, Transformation transformation) {
        super(wsSession, transformation);
        this.response = byteBuffer;
        this.channel = asyncChannelWrapper;
        this.handler = new WsFrameClientCompletionHandler();
    }

    void startInputProcessing() {
        try {
            this.processSocketRead();
        }
        catch (IOException iOException) {
            this.close(iOException);
        }
    }

    private void processSocketRead() throws IOException {
        while (this.response.hasRemaining()) {
            int n = this.response.remaining();
            int n2 = Math.min(n, this.inputBuffer.length - this.writePos);
            this.response.get(this.inputBuffer, this.writePos, n2);
            this.writePos += n2;
            this.processInputBuffer();
        }
        this.response.clear();
        if (this.isOpen()) {
            this.channel.read(this.response, null, this.handler);
        }
    }

    private final void close(Throwable throwable) {
        CloseReason closeReason = throwable instanceof WsIOException ? ((WsIOException)throwable).getCloseReason() : new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, throwable.getMessage());
        this.wsSession.doClose(closeReason, closeReason, true);
    }

    @Override
    protected boolean isMasked() {
        return false;
    }

    @Override
    protected Log getLog() {
        return this.log;
    }

    private class WsFrameClientCompletionHandler
    implements CompletionHandler<Integer, Void> {
        private WsFrameClientCompletionHandler() {
        }

        @Override
        public void completed(Integer n, Void void_) {
            block4: {
                if (n == -1) {
                    if (WsFrameClient.this.isOpen()) {
                        WsFrameClient.this.close(new EOFException());
                    }
                    return;
                }
                WsFrameClient.this.response.flip();
                try {
                    WsFrameClient.this.processSocketRead();
                }
                catch (IOException iOException) {
                    if (!WsFrameClient.this.isOpen()) break block4;
                    WsFrameClient.this.log.debug((Object)sm.getString("wsFrameClient.ioe", new Object[]{iOException}));
                    WsFrameClient.this.close(iOException);
                }
            }
        }

        @Override
        public void failed(Throwable throwable, Void void_) {
            if (WsFrameClient.this.log.isDebugEnabled()) {
                WsFrameClient.this.log.debug((Object)sm.getString("wsFrame.readFailed"), throwable);
            }
            if (throwable instanceof ReadBufferOverflowException) {
                WsFrameClient.this.response = ByteBuffer.allocate(((ReadBufferOverflowException)throwable).getMinBufferSize());
                WsFrameClient.this.response.flip();
                try {
                    WsFrameClient.this.processSocketRead();
                }
                catch (IOException iOException) {
                    WsFrameClient.this.close(iOException);
                }
            } else {
                WsFrameClient.this.close(throwable);
            }
        }
    }
}

