/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DestructuringGlobalNameExtractor;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.jstype.JSType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CollapseProperties
implements CompilerPass {
    static final DiagnosticType PARTIAL_NAMESPACE_WARNING = DiagnosticType.warning("JSC_PARTIAL_NAMESPACE", "Partial alias created for namespace {0}, possibly due to await/yield transpilation.\nThis may prevent optimization of anything nested under this namespace.\nSee https://github.com/google/closure-compiler/wiki/FAQ#i-got-an-incomplete-alias-created-for-namespace-error--what-do-i-do for more details.");
    static final DiagnosticType NAMESPACE_REDEFINED_WARNING = DiagnosticType.warning("JSC_NAMESPACE_REDEFINED", "namespace {0} should not be redefined");
    static final DiagnosticType RECEIVER_AFFECTED_BY_COLLAPSE = DiagnosticType.warning("JSC_RECEIVER_AFFECTED_BY_COLLAPSE", "Receiver reference in function {0} changes meaning when namespace is collapsed.\n Consider annotating @nocollapse; however, other properties on the receiver may still be collapsed.");
    private final AbstractCompiler compiler;
    private final CompilerOptions.PropertyCollapseLevel propertyCollapseLevel;
    private Map<String, GlobalNamespace.Name> nameMap;
    private final HashSet<String> dynamicallyImportedModules = new HashSet();

    CollapseProperties(AbstractCompiler compiler, CompilerOptions.PropertyCollapseLevel propertyCollapseLevel) {
        this.compiler = compiler;
        this.propertyCollapseLevel = propertyCollapseLevel;
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.propertyCollapseLevel == CompilerOptions.PropertyCollapseLevel.MODULE_EXPORT) {
            this.gatherDynamicallyImportedModules();
        }
        GlobalNamespace namespace = new GlobalNamespace(this.compiler, root);
        this.nameMap = namespace.getNameIndex();
        List<GlobalNamespace.Name> globalNames = namespace.getNameForest();
        Set<GlobalNamespace.Name> escaped = this.checkNamespaces();
        for (GlobalNamespace.Name name : globalNames) {
            this.flattenReferencesToCollapsibleDescendantNames(name, name.getBaseName(), escaped);
        }
        for (GlobalNamespace.Name name : globalNames) {
            this.collapseDeclarationOfNameAndDescendants(name, name.getBaseName(), escaped);
        }
        new Normalize.PropagateConstantAnnotationsOverVars(this.compiler, false).process(externs, root);
    }

    private boolean canCollapse(GlobalNamespace.Name name) {
        if (!name.canCollapse()) {
            return false;
        }
        return this.propertyCollapseLevel != CompilerOptions.PropertyCollapseLevel.MODULE_EXPORT || name.isModuleExport() && !this.dynamicallyImportedModules.contains(name.getBaseName());
    }

    private boolean canEliminate(GlobalNamespace.Name name) {
        if (!name.canEliminate()) {
            return false;
        }
        return name.props == null || name.props.isEmpty() || this.propertyCollapseLevel != CompilerOptions.PropertyCollapseLevel.MODULE_EXPORT;
    }

    private Set<GlobalNamespace.Name> checkNamespaces() {
        ImmutableSet.Builder escaped = ImmutableSet.builder();
        block0: for (GlobalNamespace.Name name : this.nameMap.values()) {
            if (!name.isNamespaceObjectLit() || name.getAliasingGets() == 0 && name.getLocalSets() + name.getGlobalSets() <= 1 && name.getDeleteProps() == 0) continue;
            boolean initialized = name.getDeclaration() != null;
            for (GlobalNamespace.Ref ref : name.getRefs()) {
                if (ref == name.getDeclaration()) continue;
                if (ref.type == GlobalNamespace.Ref.Type.DELETE_PROP) {
                    if (!initialized) continue;
                    this.warnAboutNamespaceRedefinition(name, ref);
                    continue;
                }
                if (ref.type == GlobalNamespace.Ref.Type.SET_FROM_GLOBAL || ref.type == GlobalNamespace.Ref.Type.SET_FROM_LOCAL) {
                    if (initialized && !CollapseProperties.isSafeNamespaceReinit(ref)) {
                        this.warnAboutNamespaceRedefinition(name, ref);
                    }
                    initialized = true;
                    continue;
                }
                if (ref.type != GlobalNamespace.Ref.Type.ALIASING_GET) continue;
                this.warnAboutNamespaceAliasing(name, ref);
                escaped.add(name);
                continue block0;
            }
        }
        return escaped.build();
    }

    static boolean isSafeNamespaceReinit(GlobalNamespace.Ref ref) {
        Node valParent = CollapseProperties.getValueParent(ref);
        Node val = valParent.getLastChild();
        if (val != null && val.isOr()) {
            Node maybeName = val.getFirstChild();
            if (ref.getNode().matchesQualifiedName(maybeName)) {
                return true;
            }
        }
        return false;
    }

    private static Node getValueParent(GlobalNamespace.Ref ref) {
        Node n = ref.getNode().getParent();
        return n != null && NodeUtil.isNameDeclaration(n) ? ref.getNode() : ref.getNode().getParent();
    }

    private void warnAboutNamespaceAliasing(GlobalNamespace.Name nameObj, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make(ref.getNode(), PARTIAL_NAMESPACE_WARNING, nameObj.getFullName()));
    }

    private void warnAboutNamespaceRedefinition(GlobalNamespace.Name nameObj, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make(ref.getNode(), NAMESPACE_REDEFINED_WARNING, nameObj.getFullName()));
    }

    private void flattenReferencesToCollapsibleDescendantNames(GlobalNamespace.Name n, String alias, Set<GlobalNamespace.Name> escaped) {
        if (n.props == null || n.isCollapsingExplicitlyDenied() || escaped.contains(n)) {
            return;
        }
        for (GlobalNamespace.Name p : n.props) {
            boolean isAllowedToCollapse;
            String propAlias = this.appendPropForAlias(alias, p.getBaseName());
            boolean bl = isAllowedToCollapse = this.propertyCollapseLevel != CompilerOptions.PropertyCollapseLevel.MODULE_EXPORT || p.isModuleExport();
            if (isAllowedToCollapse && p.canCollapse()) {
                this.flattenReferencesTo(p, propAlias);
            } else if (isAllowedToCollapse && p.isSimpleStubDeclaration() && !p.isCollapsingExplicitlyDenied()) {
                this.flattenSimpleStubDeclaration(p, propAlias);
            }
            this.flattenReferencesToCollapsibleDescendantNames(p, propAlias, escaped);
        }
    }

    private void flattenSimpleStubDeclaration(GlobalNamespace.Name name, String alias) {
        GlobalNamespace.Ref ref = Iterables.getOnlyElement(name.getRefs());
        Node nameNode = NodeUtil.newName(this.compiler, alias, ref.getNode(), name.getFullName());
        Node varNode = IR.var(nameNode).useSourceInfoIfMissingFrom(nameNode);
        Preconditions.checkState(ref.getNode().getParent().isExprResult());
        Node parent = ref.getNode().getParent();
        Node grandparent = parent.getParent();
        grandparent.replaceChild(parent, varNode);
        this.compiler.reportChangeToEnclosingScope(varNode);
    }

    private void flattenReferencesTo(GlobalNamespace.Name n, String alias) {
        String originalName = n.getFullName();
        for (GlobalNamespace.Ref r : n.getRefs()) {
            if (r == n.getDeclaration()) continue;
            Node rParent = r.getNode().getParent();
            if (!NodeUtil.mayBeObjectLitKey(r.getNode()) && (r.getTwin() == null || r.isSet())) {
                this.flattenNameRef(alias, r.getNode(), rParent, originalName);
                continue;
            }
            if (!r.getNode().isStringKey() || !r.getNode().getParent().isObjectPattern()) continue;
            Node newNode = IR.name(alias).srcref(r.getNode());
            NodeUtil.copyNameAnnotations(r.getNode(), newNode);
            DestructuringGlobalNameExtractor.reassignDestructringLvalue(r.getNode(), newNode, null, r, this.compiler);
        }
        if (n.props != null) {
            for (GlobalNamespace.Name p : n.props) {
                this.flattenPrefixes(alias, p, 1);
            }
        }
    }

    private void flattenPrefixes(String alias, GlobalNamespace.Name n, int depth) {
        String originalName = n.getFullName();
        GlobalNamespace.Ref decl = n.getDeclaration();
        if (decl != null && decl.getNode() != null && decl.getNode().isGetProp()) {
            this.flattenNameRefAtDepth(alias, decl.getNode(), depth, originalName);
        }
        for (GlobalNamespace.Ref r : n.getRefs()) {
            if (r == decl || r.getTwin() != null && !r.isSet()) continue;
            this.flattenNameRefAtDepth(alias, r.getNode(), depth, originalName);
        }
        if (n.props != null) {
            for (GlobalNamespace.Name p : n.props) {
                this.flattenPrefixes(alias, p, depth + 1);
            }
        }
    }

    private void flattenNameRefAtDepth(String alias, Node n, int depth, String originalName) {
        Token nType = n.getToken();
        boolean isQName = nType == Token.NAME || nType == Token.GETPROP;
        boolean isObjKey = NodeUtil.mayBeObjectLitKey(n);
        Preconditions.checkState(isObjKey || isQName);
        if (isQName) {
            for (int i = 1; i < depth && n.hasChildren(); ++i) {
                n = n.getFirstChild();
            }
            if (n.isGetProp() && n.getFirstChild().isGetProp()) {
                this.flattenNameRef(alias, n.getFirstChild(), n, originalName);
            }
        }
    }

    private void flattenNameRef(String alias, Node n, Node parent, String originalName) {
        JSType type;
        Preconditions.checkArgument(n.isGetProp(), "Expected GETPROP, found %s. Node: %s", (Object)n.getToken(), (Object)n);
        Node ref = NodeUtil.newName(this.compiler, alias, n, originalName);
        NodeUtil.copyNameAnnotations(n.getLastChild(), ref);
        if (parent.isCall() && n == parent.getFirstChild()) {
            parent.putBooleanProp(Node.FREE_CALL, true);
        }
        if ((type = n.getJSType()) != null) {
            ref.setJSType(type);
        }
        parent.replaceChild(n, ref);
        this.compiler.reportChangeToEnclosingScope(ref);
    }

    private void collapseDeclarationOfNameAndDescendants(GlobalNamespace.Name n, String alias, Set<GlobalNamespace.Name> escaped) {
        boolean canCollapseChildNames;
        boolean bl = canCollapseChildNames = n.canCollapseUnannotatedChildNames() && !escaped.contains(n);
        if (this.canCollapse(n)) {
            this.updateGlobalNameDeclaration(n, alias, canCollapseChildNames);
        }
        if (n.props == null || escaped.contains(n)) {
            return;
        }
        for (GlobalNamespace.Name p : n.props) {
            this.collapseDeclarationOfNameAndDescendants(p, this.appendPropForAlias(alias, p.getBaseName()), escaped);
        }
    }

    private void updateTwinnedDeclaration(String alias, GlobalNamespace.Name refName, GlobalNamespace.Ref ref) {
        Preconditions.checkNotNull(ref.getTwin());
        if (!ref.getNode().isGetProp()) {
            return;
        }
        Node rvalue = ref.getNode().getNext();
        Node parent = ref.getNode().getParent();
        Node grandparent = parent.getParent();
        if (rvalue != null && rvalue.isFunction()) {
            this.checkForReceiverAffectedByCollapse(rvalue, refName.getJSDocInfo(), refName);
        }
        Node nameNode = NodeUtil.newName(this.compiler, alias, grandparent.getFirstChild(), refName.getFullName());
        NodeUtil.copyNameAnnotations(ref.getNode().getLastChild(), nameNode);
        Node current = grandparent;
        Node currentParent = grandparent.getParent();
        while (!currentParent.isScript() && !currentParent.isBlock()) {
            current = currentParent;
            currentParent = currentParent.getParent();
        }
        Node stubVar = IR.var(nameNode.cloneTree()).useSourceInfoIfMissingFrom(nameNode);
        currentParent.addChildBefore(stubVar, current);
        parent.replaceChild(ref.getNode(), nameNode);
        this.compiler.reportChangeToEnclosingScope(nameNode);
    }

    private void updateGlobalNameDeclaration(GlobalNamespace.Name n, String alias, boolean canCollapseChildNames) {
        GlobalNamespace.Ref decl = n.getDeclaration();
        if (decl == null) {
            return;
        }
        switch (decl.getNode().getParent().getToken()) {
            case ASSIGN: {
                this.updateGlobalNameDeclarationAtAssignNode(n, alias, canCollapseChildNames);
                break;
            }
            case VAR: 
            case LET: 
            case CONST: {
                this.updateGlobalNameDeclarationAtVariableNode(n, canCollapseChildNames);
                break;
            }
            case FUNCTION: {
                this.updateGlobalNameDeclarationAtFunctionNode(n, canCollapseChildNames);
                break;
            }
            case CLASS: {
                this.updateGlobalNameDeclarationAtClassNode(n, canCollapseChildNames);
                break;
            }
            case CLASS_MEMBERS: {
                this.updateGlobalNameDeclarationAtStaticMemberNode(n, alias, canCollapseChildNames);
                break;
            }
        }
    }

    private void updateGlobalNameDeclarationAtAssignNode(GlobalNamespace.Name n, String alias, boolean canCollapseChildNames) {
        GlobalNamespace.Ref ref = n.getDeclaration();
        Node rvalue = ref.getNode().getNext();
        if (ref.getTwin() != null) {
            this.updateTwinnedDeclaration(alias, ref.name, ref);
            return;
        }
        Node varNode = new Node(Token.VAR);
        Node varParent = ref.getNode().getAncestor(3);
        Node grandparent = ref.getNode().getAncestor(2);
        boolean isObjLit = rvalue.isObjectLit();
        boolean insertedVarNode = false;
        if (isObjLit && this.canEliminate(n)) {
            varParent.replaceChild(grandparent, varNode);
            n.updateRefNode(ref, null);
            insertedVarNode = true;
            this.compiler.reportChangeToEnclosingScope(varNode);
        } else if (!n.isSimpleName()) {
            if (rvalue.isFunction()) {
                this.checkForReceiverAffectedByCollapse(rvalue, n.getJSDocInfo(), n);
            }
            this.compiler.reportChangeToEnclosingScope(rvalue);
            ref.getNode().getParent().removeChild(rvalue);
            Node nameNode = NodeUtil.newName(this.compiler, alias, ref.getNode().getAncestor(2), n.getFullName());
            JSDocInfo info = NodeUtil.getBestJSDocInfo(ref.getNode().getParent());
            if (ref.getNode().getLastChild().getBooleanProp(Node.IS_CONSTANT_NAME) || info != null && info.isConstant()) {
                nameNode.putBooleanProp(Node.IS_CONSTANT_NAME, true);
            }
            if (info != null) {
                varNode.setJSDocInfo(info);
            }
            varNode.addChildToBack(nameNode);
            nameNode.addChildToFront(rvalue);
            varParent.replaceChild(grandparent, varNode);
            n.updateRefNode(ref, nameNode);
            insertedVarNode = true;
            this.compiler.reportChangeToEnclosingScope(varNode);
        }
        if (canCollapseChildNames) {
            if (isObjLit) {
                this.declareVariablesForObjLitValues(n, alias, rvalue, varNode, varNode.getPrevious(), varParent);
            }
            this.addStubsForUndeclaredProperties(n, alias, varParent, varNode);
        }
        if (insertedVarNode && !varNode.hasChildren()) {
            varParent.removeChild(varNode);
        }
    }

    private void checkForReceiverAffectedByCollapse(Node function, JSDocInfo docInfo, GlobalNamespace.Name name) {
        Preconditions.checkState(function.isFunction());
        if (docInfo != null) {
            if (docInfo.isConstructorOrInterface()) {
                return;
            }
            if (docInfo.hasThisType()) {
                return;
            }
        }
        if (NodeUtil.referencesOwnReceiver(function)) {
            this.compiler.report(JSError.make(function, RECEIVER_AFFECTED_BY_COLLAPSE, name.getFullName()));
        }
    }

    private void updateGlobalNameDeclarationAtVariableNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
        if (!canCollapseChildNames) {
            return;
        }
        GlobalNamespace.Ref ref = n.getDeclaration();
        String name = ref.getNode().getString();
        Node rvalue = ref.getNode().getFirstChild();
        Node variableNode = ref.getNode().getParent();
        Node grandparent = variableNode.getParent();
        boolean isObjLit = rvalue.isObjectLit();
        if (isObjLit) {
            this.declareVariablesForObjLitValues(n, name, rvalue, variableNode, variableNode.getPrevious(), grandparent);
        }
        this.addStubsForUndeclaredProperties(n, name, grandparent, variableNode);
        if (isObjLit && this.canEliminate(n)) {
            variableNode.removeChild(ref.getNode());
            this.compiler.reportChangeToEnclosingScope(variableNode);
            if (!variableNode.hasChildren()) {
                grandparent.removeChild(variableNode);
            }
            n.updateRefNode(ref, null);
        }
    }

    private void updateGlobalNameDeclarationAtFunctionNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
        if (!canCollapseChildNames || !this.canCollapse(n)) {
            return;
        }
        GlobalNamespace.Ref ref = n.getDeclaration();
        String fnName = ref.getNode().getString();
        this.addStubsForUndeclaredProperties(n, fnName, ref.getNode().getAncestor(2), ref.getNode().getParent());
    }

    private void updateGlobalNameDeclarationAtClassNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
        if (!canCollapseChildNames || !this.canCollapse(n)) {
            return;
        }
        GlobalNamespace.Ref ref = n.getDeclaration();
        String className = ref.getNode().getString();
        this.addStubsForUndeclaredProperties(n, className, ref.getNode().getAncestor(2), ref.getNode().getParent());
    }

    private void updateGlobalNameDeclarationAtStaticMemberNode(GlobalNamespace.Name n, String alias, boolean canCollapseChildNames) {
        GlobalNamespace.Ref declaration = n.getDeclaration();
        Node classNode = declaration.getNode().getGrandparent();
        Preconditions.checkState(classNode.isClass(), classNode);
        Node enclosingStatement = NodeUtil.getEnclosingStatement(classNode);
        if (canCollapseChildNames) {
            this.addStubsForUndeclaredProperties(n, alias, enclosingStatement.getParent(), classNode);
        }
        Node memberFn = declaration.getNode().detach();
        Node fnNode = memberFn.getOnlyChild().detach();
        this.checkForReceiverAffectedByCollapse(fnNode, memberFn.getJSDocInfo(), n);
        Node varDecl = IR.var(NodeUtil.newName(this.compiler, alias, memberFn), fnNode).srcref(memberFn);
        enclosingStatement.getParent().addChildBefore(varDecl, enclosingStatement);
        this.compiler.reportChangeToEnclosingScope(varDecl);
        n.updateRefNode(declaration, varDecl.getFirstChild());
    }

    private void declareVariablesForObjLitValues(GlobalNamespace.Name objlitName, String alias, Node objlit, Node varNode, Node nameToAddAfter, Node varParent) {
        int arbitraryNameCounter = 0;
        boolean discardKeys = !objlitName.shouldKeepKeys();
        Node key = objlit.getFirstChild();
        while (key != null) {
            Node nextKey;
            block15: {
                Node value = key.getFirstChild();
                nextKey = key.getNext();
                switch (key.getToken()) {
                    case GETTER_DEF: 
                    case SETTER_DEF: 
                    case COMPUTED_PROP: 
                    case OBJECT_SPREAD: {
                        break block15;
                    }
                    case STRING_KEY: 
                    case MEMBER_FUNCTION_DEF: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected child of OBJECTLIT: " + key.toStringTree());
                    }
                }
                boolean isJsIdentifier = !key.isNumber() && TokenStream.isJSIdentifier(key.getString());
                String propName = isJsIdentifier ? key.getString() : String.valueOf(++arbitraryNameCounter);
                String qName = objlitName.getFullName() + '.' + propName;
                GlobalNamespace.Name p = this.nameMap.get(qName);
                if (p == null || this.canCollapse(p)) {
                    String propAlias = this.appendPropForAlias(alias, propName);
                    Node refNode = null;
                    if (discardKeys) {
                        objlit.removeChild(key);
                        value.detach();
                    } else {
                        refNode = IR.name(propAlias);
                        if (key.getBooleanProp(Node.IS_CONSTANT_NAME)) {
                            refNode.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                        }
                        key.replaceChild(value, refNode);
                        this.compiler.reportChangeToEnclosingScope(refNode);
                    }
                    Node nameNode = IR.name(propAlias);
                    nameNode.addChildToFront(value);
                    if (key.getBooleanProp(Node.IS_CONSTANT_NAME)) {
                        nameNode.putBooleanProp(Node.IS_CONSTANT_NAME, true);
                    }
                    Node newVar = IR.var(nameNode).useSourceInfoIfMissingFromForTree(key);
                    if (nameToAddAfter != null) {
                        varParent.addChildAfter(newVar, nameToAddAfter);
                    } else {
                        varParent.addChildBefore(newVar, varNode);
                    }
                    this.compiler.reportChangeToEnclosingScope(newVar);
                    nameToAddAfter = newVar;
                    if (isJsIdentifier && p != null) {
                        if (!discardKeys) {
                            p.addAliasingGetClonedFromDeclaration(refNode);
                        }
                        p.updateRefNode(p.getDeclaration(), nameNode);
                        if (value.isFunction()) {
                            this.checkForReceiverAffectedByCollapse(value, key.getJSDocInfo(), p);
                        }
                    }
                }
            }
            key = nextKey;
        }
    }

    private void addStubsForUndeclaredProperties(GlobalNamespace.Name n, String alias, Node parent, Node addAfter) {
        Preconditions.checkState(n.canCollapseUnannotatedChildNames(), n);
        Preconditions.checkArgument(NodeUtil.isStatementBlock(parent), parent);
        Preconditions.checkNotNull(addAfter);
        if (n.props == null) {
            return;
        }
        for (GlobalNamespace.Name p : n.props) {
            if (!p.needsToBeStubbed()) continue;
            String propAlias = this.appendPropForAlias(alias, p.getBaseName());
            Node nameNode = IR.name(propAlias);
            Node newVar = IR.var(nameNode).useSourceInfoIfMissingFromForTree(addAfter);
            parent.addChildAfter(newVar, addAfter);
            addAfter = newVar;
            this.compiler.reportChangeToEnclosingScope(newVar);
            if (!p.getFirstRef().getNode().getLastChild().getBooleanProp(Node.IS_CONSTANT_NAME)) continue;
            nameNode.putBooleanProp(Node.IS_CONSTANT_NAME, true);
            this.compiler.reportChangeToEnclosingScope(nameNode);
        }
    }

    private String appendPropForAlias(String root, String prop) {
        if (prop.indexOf(36) != -1) {
            prop = prop.replace("$", "$0");
        }
        String result = root + '$' + prop;
        int id = 1;
        while (this.nameMap.containsKey(result)) {
            result = root + '$' + prop + '$' + id;
            ++id;
        }
        return result;
    }

    private void gatherDynamicallyImportedModules() {
        for (CompilerInput input : this.compiler.getInputsInOrder()) {
            this.dynamicallyImportedModules.addAll(input.getDynamicRequires());
        }
    }
}

