/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.AggressiveInlineAliases;
import com.google.javascript.jscomp.AliasStrings;
import com.google.javascript.jscomp.AngularPass;
import com.google.javascript.jscomp.AstValidator;
import com.google.javascript.jscomp.CheckAccessControls;
import com.google.javascript.jscomp.CheckClosureImports;
import com.google.javascript.jscomp.CheckConformance;
import com.google.javascript.jscomp.CheckConstPrivateProperties;
import com.google.javascript.jscomp.CheckDebuggerStatement;
import com.google.javascript.jscomp.CheckGlobalNames;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckMissingAndExtraRequires;
import com.google.javascript.jscomp.CheckMissingRequires;
import com.google.javascript.jscomp.CheckMissingReturn;
import com.google.javascript.jscomp.CheckProvides;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuper;
import com.google.javascript.jscomp.CheckSuspiciousCode;
import com.google.javascript.jscomp.CheckTypeImportCodeReferences;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.CheckUnusedPrivateProperties;
import com.google.javascript.jscomp.ChromePass;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosureCodeRemoval;
import com.google.javascript.jscomp.ClosureOptimizePrimitives;
import com.google.javascript.jscomp.ClosureRewriteClass;
import com.google.javascript.jscomp.ClosureRewriteModule;
import com.google.javascript.jscomp.CoalesceVariableNames;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CollapseAnonymousFunctions;
import com.google.javascript.jscomp.CollapseProperties;
import com.google.javascript.jscomp.CollapseVariableDeclarations;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ConstCheck;
import com.google.javascript.jscomp.ConstParamCheck;
import com.google.javascript.jscomp.ConvertToDottedProperties;
import com.google.javascript.jscomp.CreateSyntheticBlocks;
import com.google.javascript.jscomp.CrossChunkCodeMotion;
import com.google.javascript.jscomp.CrossChunkMethodMotion;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DartSuperAccessorsPass;
import com.google.javascript.jscomp.DeadAssignmentsElimination;
import com.google.javascript.jscomp.DeadPropertyAssignmentElimination;
import com.google.javascript.jscomp.DeclaredGlobalExternsOnWindow;
import com.google.javascript.jscomp.Denormalize;
import com.google.javascript.jscomp.DevirtualizeMethods;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorPass;
import com.google.javascript.jscomp.Es6CheckModule;
import com.google.javascript.jscomp.Es6RewriteScriptsToModules;
import com.google.javascript.jscomp.Es6ToEs3ClassSideInheritance;
import com.google.javascript.jscomp.ExploitAssigns;
import com.google.javascript.jscomp.ExportTestFunctions;
import com.google.javascript.jscomp.ExternExportsPass;
import com.google.javascript.jscomp.ExtractPrototypeMemberDeclarations;
import com.google.javascript.jscomp.FlowSensitiveInlineVariables;
import com.google.javascript.jscomp.FunctionRewriter;
import com.google.javascript.jscomp.GatherExternProperties;
import com.google.javascript.jscomp.GatherGetterAndSetterProperties;
import com.google.javascript.jscomp.GatherModuleMetadata;
import com.google.javascript.jscomp.GatherRawExports;
import com.google.javascript.jscomp.GenerateExports;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.GoogleJsMessageIdGenerator;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.ImplicitNullabilityCheck;
import com.google.javascript.jscomp.InferConsts;
import com.google.javascript.jscomp.InferJSDocInfo;
import com.google.javascript.jscomp.InjectRuntimeLibraries;
import com.google.javascript.jscomp.InlineAliases;
import com.google.javascript.jscomp.InlineFunctions;
import com.google.javascript.jscomp.InlineObjectLiterals;
import com.google.javascript.jscomp.InlineProperties;
import com.google.javascript.jscomp.InlineSimpleMethods;
import com.google.javascript.jscomp.InlineVariables;
import com.google.javascript.jscomp.IsolatePolyfills;
import com.google.javascript.jscomp.J2clAssertRemovalPass;
import com.google.javascript.jscomp.J2clChecksPass;
import com.google.javascript.jscomp.J2clClinitPrunerPass;
import com.google.javascript.jscomp.J2clConstantHoisterPass;
import com.google.javascript.jscomp.J2clEqualitySameRewriterPass;
import com.google.javascript.jscomp.J2clPass;
import com.google.javascript.jscomp.J2clPropertyInlinerPass;
import com.google.javascript.jscomp.J2clSourceFileChecker;
import com.google.javascript.jscomp.J2clStringValueOfRewriterPass;
import com.google.javascript.jscomp.J2clUtilGetDefineRewriterPass;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.MarkUntranspilableFeaturesAsRemoved;
import com.google.javascript.jscomp.MinimizeExitPoints;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.jscomp.OptimizeArgumentsArray;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.OptimizeParameters;
import com.google.javascript.jscomp.OptimizeReturns;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PeepholeCollectPropertyAssignments;
import com.google.javascript.jscomp.PeepholeFoldConstants;
import com.google.javascript.jscomp.PeepholeMinimizeConditions;
import com.google.javascript.jscomp.PeepholeOptimizationsPass;
import com.google.javascript.jscomp.PeepholeRemoveDeadCode;
import com.google.javascript.jscomp.PeepholeReorderConstantExpression;
import com.google.javascript.jscomp.PeepholeReplaceKnownMethods;
import com.google.javascript.jscomp.PeepholeSubstituteAlternateSyntax;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.jscomp.ProcessClosureProvidesAndRequires;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.ProcessTweaks;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.PureFunctionIdentifier;
import com.google.javascript.jscomp.RemoveTypes;
import com.google.javascript.jscomp.RemoveUnusedCode;
import com.google.javascript.jscomp.RemoveWeakSources;
import com.google.javascript.jscomp.RenameLabels;
import com.google.javascript.jscomp.RenameProperties;
import com.google.javascript.jscomp.RenameVars;
import com.google.javascript.jscomp.ReplaceCssNames;
import com.google.javascript.jscomp.ReplaceIdGenerators;
import com.google.javascript.jscomp.ReplaceMessages;
import com.google.javascript.jscomp.ReplaceMessagesForChrome;
import com.google.javascript.jscomp.ReplaceStrings;
import com.google.javascript.jscomp.RescopeGlobalSymbols;
import com.google.javascript.jscomp.RewriteGlobalDeclarationsForTryCatchWrapping;
import com.google.javascript.jscomp.RewriteGoogJsImports;
import com.google.javascript.jscomp.RuntimeTypeCheck;
import com.google.javascript.jscomp.ScopedAliases;
import com.google.javascript.jscomp.StatementFusion;
import com.google.javascript.jscomp.StrictModeCheck;
import com.google.javascript.jscomp.StripCode;
import com.google.javascript.jscomp.SubstituteEs6Syntax;
import com.google.javascript.jscomp.SyncCompilerFeatures;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeInferencePass;
import com.google.javascript.jscomp.TypedScope;
import com.google.javascript.jscomp.UnreachableCodeElimination;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.WhitespaceWrapGoogModules;
import com.google.javascript.jscomp.disambiguate.AmbiguateProperties;
import com.google.javascript.jscomp.disambiguate.DisambiguateProperties;
import com.google.javascript.jscomp.disambiguate.DisambiguateProperties2;
import com.google.javascript.jscomp.ijs.ConvertToTypedInterface;
import com.google.javascript.jscomp.instrumentation.CoverageInstrumentationPass;
import com.google.javascript.jscomp.lint.CheckArrayWithGoogObject;
import com.google.javascript.jscomp.lint.CheckConstantCaseNames;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckEs6ModuleFileStructure;
import com.google.javascript.jscomp.lint.CheckEs6Modules;
import com.google.javascript.jscomp.lint.CheckExtraRequires;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckMissingSemicolon;
import com.google.javascript.jscomp.lint.CheckNoMutatedEs6Exports;
import com.google.javascript.jscomp.lint.CheckNullabilityModifiers;
import com.google.javascript.jscomp.lint.CheckNullableReturn;
import com.google.javascript.jscomp.lint.CheckPrimitiveAsObject;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckProvidesSorted;
import com.google.javascript.jscomp.lint.CheckRequiresSorted;
import com.google.javascript.jscomp.lint.CheckUnusedLabels;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import com.google.javascript.jscomp.modules.ModuleMapCreator;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class DefaultPassConfig
extends PassConfig {
    private static final String COMPILED_CONSTANT_NAME = "COMPILED";
    private static final String CLOSURE_LOCALE_CONSTANT_NAME = "goog.LOCALE";
    static final DiagnosticType CANNOT_USE_PROTOTYPE_AND_VAR = DiagnosticType.error("JSC_CANNOT_USE_PROTOTYPE_AND_VAR", "Rename prototypes and inline variables cannot be used together.");
    private static final Pattern GLOBAL_SYMBOL_NAMESPACE_PATTERN = Pattern.compile("^[a-zA-Z0-9$_]+$");
    private transient GlobalNamespace namespaceForChecks = null;
    private final transient PreprocessorSymbolTable.CachedInstanceFactory preprocessorSymbolTableFactory = new PreprocessorSymbolTable.CachedInstanceFactory();
    private transient ClosureRewriteModule.GlobalRewriteState moduleRewriteState = null;
    private final PassFactory syncCompilerFeatures = PassFactory.builder().setName("syncCompilerFeatures").setInternalFactory(SyncCompilerFeatures::new).setFeatureSet(FeatureSet.all()).build();
    private final PassFactory checkSideEffects = PassFactory.builderForHotSwap().setName("checkSideEffects").setInternalFactory(compiler -> new CheckSideEffects((AbstractCompiler)compiler, this.options.checkSuspiciousCode, this.options.shouldProtectHiddenSideEffects())).setFeatureSetForChecks().build();
    private final PassFactory stripSideEffectProtection = PassFactory.builder().setName("stripSideEffectProtection").setInternalFactory(CheckSideEffects.StripProtection::new).setFeatureSet(FeatureSet.latest()).build();
    private final PassFactory suspiciousCode = PassFactory.builderForHotSwap().setName("suspiciousCode").setInternalFactory(compiler -> {
        ArrayList<NodeTraversal.Callback> sharedCallbacks = new ArrayList<NodeTraversal.Callback>();
        if (this.options.checkSuspiciousCode) {
            sharedCallbacks.add(new CheckSuspiciousCode());
            sharedCallbacks.add(new CheckDuplicateCase((AbstractCompiler)compiler));
        }
        if (this.options.enables(DiagnosticGroups.GLOBAL_THIS)) {
            sharedCallbacks.add(new CheckGlobalThis((AbstractCompiler)compiler));
        }
        if (this.options.enables(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT)) {
            sharedCallbacks.add(new CheckDebuggerStatement((AbstractCompiler)compiler));
        }
        return DefaultPassConfig.combineChecks(compiler, sharedCallbacks);
    }).setFeatureSetForChecks().build();
    private final PassFactory extraRequires = PassFactory.builderForHotSwap().setName("checkExtraRequires").setFeatureSetForChecks().setInternalFactory(CheckExtraRequires::new).build();
    private final PassFactory missingAndExtraRequires = PassFactory.builderForHotSwap().setName("checkMissingAndExtraRequires").setFeatureSetForChecks().setInternalFactory(CheckMissingAndExtraRequires::new).build();
    private final PassFactory checkMissingRequires = PassFactory.builder().setName("checkMissingRequires").setInternalFactory(compiler -> new CheckMissingRequires((AbstractCompiler)compiler, compiler.getModuleMetadataMap())).setFeatureSetForChecks().build();
    private final PassFactory checkProvides = PassFactory.builderForHotSwap().setName("checkProvides").setFeatureSetForChecks().setInternalFactory(CheckProvides::new).build();
    private static final DiagnosticType GENERATE_EXPORTS_ERROR = DiagnosticType.error("JSC_GENERATE_EXPORTS_ERROR", "Exports can only be generated if export symbol/property functions are set.");
    private final PassFactory checkJsDocAndEs6Modules = PassFactory.builderForHotSwap().setName("checkJsDocAndEs6Modules").setFeatureSetForChecks().setInternalFactory(compiler -> DefaultPassConfig.combineChecks(compiler, ImmutableList.of(new CheckJSDoc((AbstractCompiler)compiler), new Es6CheckModule((AbstractCompiler)compiler)))).build();
    private final PassFactory generateExports = PassFactory.builder().setName("generateExports").setInternalFactory(compiler -> {
        CodingConvention convention = compiler.getCodingConvention();
        if (convention.getExportSymbolFunction() != null && convention.getExportPropertyFunction() != null) {
            final GenerateExports pass = new GenerateExports((AbstractCompiler)compiler, this.options.exportLocalPropertyDefinitions, convention.getExportSymbolFunction(), convention.getExportPropertyFunction());
            return new CompilerPass((AbstractCompiler)compiler){
                final /* synthetic */ AbstractCompiler val$compiler;
                {
                    this.val$compiler = abstractCompiler;
                }

                @Override
                public void process(Node externs, Node root) {
                    pass.process(externs, root);
                    this.val$compiler.addExportedNames(pass.getExportedVariableNames());
                }
            };
        }
        return new ErrorPass((AbstractCompiler)compiler, GENERATE_EXPORTS_ERROR);
    }).setFeatureSetForChecks().build();
    private final PassFactory generateIjs = PassFactory.builder().setName("generateIjs").setInternalFactory(ConvertToTypedInterface::new).setFeatureSetForChecks().build();
    private final PassFactory exportTestFunctions = PassFactory.builder().setName("exportTestFunctions").setInternalFactory(compiler -> {
        CodingConvention convention = compiler.getCodingConvention();
        if (convention.getExportSymbolFunction() != null) {
            return new ExportTestFunctions((AbstractCompiler)compiler, convention.getExportSymbolFunction(), convention.getExportPropertyFunction());
        }
        return new ErrorPass((AbstractCompiler)compiler, GENERATE_EXPORTS_ERROR);
    }).setFeatureSetForChecks().build();
    private final PassFactory gatherRawExports = PassFactory.builder().setName("gatherRawExports").setInternalFactory(compiler -> {
        final GatherRawExports pass = new GatherRawExports((AbstractCompiler)compiler);
        return new CompilerPass((AbstractCompiler)compiler){
            final /* synthetic */ AbstractCompiler val$compiler;
            {
                this.val$compiler = abstractCompiler;
            }

            @Override
            public void process(Node externs, Node root) {
                pass.process(externs, root);
                this.val$compiler.addExportedNames(pass.getExportedVariableNames());
            }
        };
    }).setFeatureSet(FeatureSet.latest()).build();
    private final PassFactory closurePrimitives = PassFactory.builderForHotSwap().setName("closurePrimitives").setInternalFactory(compiler -> {
        this.preprocessorSymbolTableFactory.maybeInitialize((AbstractCompiler)compiler);
        final ProcessClosurePrimitives pass = new ProcessClosurePrimitives((AbstractCompiler)compiler, this.preprocessorSymbolTableFactory.getInstanceOrNull());
        return new HotSwapCompilerPass((AbstractCompiler)compiler){
            final /* synthetic */ AbstractCompiler val$compiler;
            {
                this.val$compiler = abstractCompiler;
            }

            @Override
            public void process(Node externs, Node root) {
                pass.process(externs, root);
                this.val$compiler.addExportedNames(pass.getExportedVariableNames());
            }

            @Override
            public void hotSwapScript(Node scriptRoot, Node originalRoot) {
                pass.hotSwapScript(scriptRoot, originalRoot);
            }
        };
    }).setFeatureSetForChecks().build();
    private final PassFactory closureProvidesRequires = PassFactory.builderForHotSwap().setName("closureProvidesRequires").setInternalFactory(compiler -> {
        this.preprocessorSymbolTableFactory.maybeInitialize((AbstractCompiler)compiler);
        TypedScope globalTypedScope = compiler.getOptions().allowsHotswapReplaceScript() ? null : this.getTopScope();
        return new ProcessClosureProvidesAndRequires((AbstractCompiler)compiler, this.preprocessorSymbolTableFactory.getInstanceOrNull(), this.options.brokenClosureRequiresLevel, this.options.shouldPreservesGoogProvidesAndRequires(), globalTypedScope);
    }).setFeatureSetForChecks().build();
    private final PassFactory angularPass = PassFactory.builderForHotSwap().setName("angularPass").setInternalFactory(AngularPass::new).setFeatureSetForChecks().build();
    private final PassFactory replaceMessages = PassFactory.builder().setName("replaceMessages").setInternalFactory(compiler -> new ReplaceMessages((AbstractCompiler)compiler, this.options.messageBundle, true, JsMessage.Style.CLOSURE, false)).setFeatureSetForOptimizations().build();
    private final PassFactory replaceMessagesForChrome = PassFactory.builder().setName("replaceMessages").setInternalFactory(compiler -> new ReplaceMessagesForChrome((AbstractCompiler)compiler, new GoogleJsMessageIdGenerator(this.options.tcProjectId), true, JsMessage.Style.CLOSURE)).setFeatureSetForOptimizations().build();
    private final PassFactory closureGoogScopeAliasesForIjs = PassFactory.builderForHotSwap().setName("closureGoogScopeAliasesForIjs").setInternalFactory(compiler -> ScopedAliases.builder(compiler).build()).setFeatureSetForChecks().build();
    private final PassFactory closureGoogScopeAliases = PassFactory.builderForHotSwap().setName("closureGoogScopeAliases").setInternalFactory(compiler -> {
        this.preprocessorSymbolTableFactory.maybeInitialize((AbstractCompiler)compiler);
        return ScopedAliases.builder(compiler).setPreprocessorSymbolTable(this.preprocessorSymbolTableFactory.getInstanceOrNull()).setAliasTransformationHandler(this.options.getAliasTransformationHandler()).setModuleMetadataMap(compiler.getModuleMetadataMap()).setInvalidModuleGetHandling(ScopedAliases.InvalidModuleGetHandling.DELETE).build();
    }).setFeatureSetForChecks().build();
    private final PassFactory injectRuntimeLibraries = PassFactory.builder().setName("InjectRuntimeLibraries").setInternalFactory(InjectRuntimeLibraries::new).setFeatureSetForChecks().build();
    private final PassFactory markUntranspilableFeaturesAsRemoved = PassFactory.builder().setName("markUntranspilableFeaturesAsRemoved").setInternalFactory(compiler -> new MarkUntranspilableFeaturesAsRemoved((AbstractCompiler)compiler, this.options.getOutputFeatureSet())).setFeatureSetForChecks().build();
    private final PassFactory convertStaticInheritance = PassFactory.builder().setName("Es6StaticInheritance").setInternalFactory(Es6ToEs3ClassSideInheritance::new).setFeatureSetForOptimizations().build();
    private final PassFactory inlineTypeAliases = PassFactory.builder().setName("inlineTypeAliases").setInternalFactory(InlineAliases::new).setFeatureSetForOptimizations().build();
    private final PassFactory aggressiveInlineAliases = PassFactory.builder().setName("aggressiveInlineAliases").setInternalFactory(AggressiveInlineAliases::new).setFeatureSetForOptimizations().build();
    private final PassFactory removeWeakSources = PassFactory.builder().setName("removeWeakSources").setInternalFactory(RemoveWeakSources::new).setFeatureSet(FeatureSet.latest()).build();
    private final PassFactory declaredGlobalExternsOnWindow = PassFactory.builder().setName("declaredGlobalExternsOnWindow").setInternalFactory(DeclaredGlobalExternsOnWindow::new).setFeatureSetForChecks().build();
    private final PassFactory checkTypeImportCodeReferences = PassFactory.builder().setName("checkTypeImportCodeReferences").setInternalFactory(CheckTypeImportCodeReferences::new).setFeatureSetForChecks().build();
    private final PassFactory closureRewriteClass = PassFactory.builderForHotSwap().setName("closureRewriteClass").setInternalFactory(ClosureRewriteClass::new).setFeatureSetForChecks().build();
    private final PassFactory closureCheckModule = PassFactory.builderForHotSwap().setName("closureCheckModule").setInternalFactory(compiler -> new ClosureCheckModule((AbstractCompiler)compiler, compiler.getModuleMetadataMap())).setFeatureSetForChecks().build();
    private final PassFactory closureRewriteModule = PassFactory.builderForHotSwap().setName("closureRewriteModule").setInternalFactory(compiler -> {
        this.preprocessorSymbolTableFactory.maybeInitialize((AbstractCompiler)compiler);
        this.maybeInitializeModuleRewriteState();
        TypedScope globalTypedScope = compiler.getOptions().allowsHotswapReplaceScript() ? null : this.getTopScope();
        return new ClosureRewriteModule((AbstractCompiler)compiler, this.preprocessorSymbolTableFactory.getInstanceOrNull(), this.moduleRewriteState, globalTypedScope);
    }).setFeatureSetForChecks().build();
    private final PassFactory checkClosureImports = PassFactory.builderForHotSwap().setName("checkGoogRequires").setInternalFactory(compiler -> new CheckClosureImports((AbstractCompiler)compiler, compiler.getModuleMetadataMap())).setFeatureSetForChecks().build();
    private final PassFactory rewriteGoogJsImports = PassFactory.builderForHotSwap().setName("rewriteGoogJsImports").setInternalFactory(compiler -> new RewriteGoogJsImports((AbstractCompiler)compiler, RewriteGoogJsImports.Mode.LINT_AND_REWRITE, compiler.getModuleMap())).setFeatureSetForChecks().build();
    private final PassFactory closureReplaceGetCssName = PassFactory.builder().setName("closureReplaceGetCssName").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node jsRoot) {
            HashMap<String, Integer> newCssNames = null;
            if (DefaultPassConfig.this.options.gatherCssNames) {
                newCssNames = new HashMap<String, Integer>();
            }
            ReplaceCssNames pass = new ReplaceCssNames(this.val$compiler, newCssNames, DefaultPassConfig.this.options.cssRenamingSkiplist);
            pass.process(externs, jsRoot);
            this.val$compiler.setCssNames(newCssNames);
        }
    }).setFeatureSetForChecks().build();
    private final PassFactory createSyntheticBlocks = PassFactory.builder().setName("createSyntheticBlocks").setInternalFactory(compiler -> new CreateSyntheticBlocks((AbstractCompiler)compiler, this.options.syntheticBlockStartMarker, this.options.syntheticBlockEndMarker)).setFeatureSetForChecks().build();
    private final PassFactory earlyPeepholeOptimizations = PassFactory.builder().setName("earlyPeepholeOptimizations").setInternalFactory(compiler -> {
        boolean useTypesForOptimization = compiler.getOptions().useTypesForLocalOptimization;
        ArrayList<AbstractPeepholeOptimization> peepholeOptimizations = new ArrayList<AbstractPeepholeOptimization>();
        peepholeOptimizations.add(new PeepholeRemoveDeadCode());
        if (compiler.getOptions().j2clPassMode.shouldAddJ2clPasses()) {
            peepholeOptimizations.add(new J2clEqualitySameRewriterPass(useTypesForOptimization));
        }
        return new PeepholeOptimizationsPass((AbstractCompiler)compiler, "earlyPeepholeOptimizations", (List<AbstractPeepholeOptimization>)peepholeOptimizations);
    }).setFeatureSetForOptimizations().build();
    private final PassFactory earlyInlineVariables = PassFactory.builder().setName("earlyInlineVariables").setInternalFactory(compiler -> {
        InlineVariables.Mode mode;
        if (this.options.inlineVariables) {
            mode = InlineVariables.Mode.ALL;
        } else if (this.options.inlineLocalVariables) {
            mode = InlineVariables.Mode.LOCALS_ONLY;
        } else {
            throw new IllegalStateException("No variable inlining option set.");
        }
        return new InlineVariables((AbstractCompiler)compiler, mode, true);
    }).setFeatureSetForOptimizations().build();
    private final PassFactory peepholeOptimizations = PassFactory.builder().setName("peepholeOptimizations").setRunInFixedPointLoop(true).setInternalFactory(compiler -> DefaultPassConfig.createPeepholeOptimizationsPass(compiler, "peepholeOptimizations")).setFeatureSetForOptimizations().build();
    private final PassFactory peepholeOptimizationsOnce = PassFactory.builder().setName("peepholeOptimizations").setInternalFactory(compiler -> DefaultPassConfig.createPeepholeOptimizationsPass(compiler, "peepholeOptimizations")).setFeatureSetForOptimizations().build();
    private final PassFactory latePeepholeOptimizations = PassFactory.builder().setName("latePeepholeOptimizations").setInternalFactory(compiler -> {
        boolean late = true;
        boolean useTypesForOptimization = this.options.useTypesForLocalOptimization;
        return new PeepholeOptimizationsPass((AbstractCompiler)compiler, "latePeepholeOptimizations", new StatementFusion(), new PeepholeRemoveDeadCode(), new PeepholeMinimizeConditions(true), new PeepholeSubstituteAlternateSyntax(true), new PeepholeReplaceKnownMethods(true, useTypesForOptimization), new PeepholeFoldConstants(true, useTypesForOptimization), new PeepholeReorderConstantExpression());
    }).setFeatureSetForOptimizations().build();
    private final PassFactory checkVars = PassFactory.builderForHotSwap().setName("checkVars").setInternalFactory(VarCheck::new).setFeatureSetForChecks().build();
    private final PassFactory inferConsts = PassFactory.builder().setName("inferConsts").setInternalFactory(InferConsts::new).setFeatureSetForChecks().build();
    private final PassFactory checkRegExp = PassFactory.builder().setName("checkRegExp").setInternalFactory(compiler -> {
        final CheckRegExp pass = new CheckRegExp((AbstractCompiler)compiler);
        return new CompilerPass((AbstractCompiler)compiler){
            final /* synthetic */ AbstractCompiler val$compiler;
            {
                this.val$compiler = abstractCompiler;
            }

            @Override
            public void process(Node externs, Node root) {
                pass.process(externs, root);
                this.val$compiler.setHasRegExpGlobalReferences(pass.isGlobalRegExpPropertiesUsed());
            }
        };
    }).setFeatureSetForChecks().build();
    private final PassFactory checkVariableReferencesForTranspileOnly = PassFactory.builderForHotSwap().setName("checkVariableReferences").setInternalFactory(compiler -> new VariableReferenceCheck((AbstractCompiler)compiler, true)).setFeatureSetForChecks().build();
    private final PassFactory checkVariableReferences = PassFactory.builderForHotSwap().setName("checkVariableReferences").setInternalFactory(VariableReferenceCheck::new).setFeatureSetForChecks().build();
    private final PassFactory checkSuper = PassFactory.builderForHotSwap().setName("checkSuper").setInternalFactory(CheckSuper::new).setFeatureSetForChecks().build();
    private final PassFactory clearTypedScopeCreatorPass = PassFactory.builder().setName("clearTypedScopeCreatorPass").setInternalFactory(compiler -> new ClearTypedScopeCreator()).setFeatureSetForChecks().build();
    private final PassFactory clearTopTypedScopePass = PassFactory.builder().setName("clearTopTypedScopePass").setInternalFactory(compiler -> new ClearTopTypedScope()).setFeatureSetForChecks().build();
    final PassFactory inferTypes = PassFactory.builderForHotSwap().setName("inferTypes").setInternalFactory(compiler -> new HotSwapCompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node unused, Node srcRoot) {
            Node globalRoot = srcRoot.getParent();
            this.val$compiler.setTypeCheckingHasRun(true);
            DefaultPassConfig.this.topScope = this.createInference().inferAllScopes(globalRoot);
        }

        @Override
        public void hotSwapScript(Node scriptRoot, Node originalRoot) {
            this.createInference().reuseTopScope(DefaultPassConfig.this.getTopScope()).inferAllScopes(scriptRoot);
        }

        private TypeInferencePass createInference() {
            return new TypeInferencePass(this.val$compiler, this.val$compiler.getReverseAbstractInterpreter(), DefaultPassConfig.this.getTypedScopeCreator(this.val$compiler));
        }
    }).setFeatureSetForChecks().build();
    private final PassFactory inferJsDocInfo = PassFactory.builderForHotSwap().setName("inferJsDocInfo").setInternalFactory(compiler -> new HotSwapCompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node root) {
            Preconditions.checkNotNull(DefaultPassConfig.this.topScope);
            Preconditions.checkNotNull(DefaultPassConfig.this.getTypedScopeCreator());
            new InferJSDocInfo(this.val$compiler).process(externs, root);
        }

        @Override
        public void hotSwapScript(Node scriptRoot, Node originalRoot) {
            new InferJSDocInfo(this.val$compiler).hotSwapScript(scriptRoot, originalRoot);
        }
    }).setFeatureSetForChecks().build();
    private final PassFactory checkTypes = PassFactory.builderForHotSwap().setName("checkTypes").setInternalFactory(compiler -> new HotSwapCompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node root) {
            Preconditions.checkNotNull(DefaultPassConfig.this.topScope);
            Preconditions.checkNotNull(DefaultPassConfig.this.getTypedScopeCreator());
            TypeCheck check = DefaultPassConfig.this.makeTypeCheck(this.val$compiler);
            check.process(externs, root);
            this.val$compiler.getErrorManager().setTypedPercent(check.getTypedPercent());
        }

        @Override
        public void hotSwapScript(Node scriptRoot, Node originalRoot) {
            DefaultPassConfig.this.makeTypeCheck(this.val$compiler).check(scriptRoot, false);
        }
    }).setFeatureSetForChecks().build();
    private final PassFactory checkControlFlow = PassFactory.builderForHotSwap().setName("checkControlFlow").setInternalFactory(compiler -> {
        ArrayList<NodeTraversal.Callback> callbacks = new ArrayList<NodeTraversal.Callback>();
        if (!this.options.disables(DiagnosticGroups.CHECK_USELESS_CODE)) {
            callbacks.add(new CheckUnreachableCode((AbstractCompiler)compiler));
        }
        if (!this.options.disables(DiagnosticGroups.MISSING_RETURN)) {
            callbacks.add(new CheckMissingReturn((AbstractCompiler)compiler));
        }
        return DefaultPassConfig.combineChecks(compiler, callbacks);
    }).setFeatureSetForChecks().build();
    private final PassFactory checkAccessControls = PassFactory.builderForHotSwap().setName("checkAccessControls").setInternalFactory(compiler -> new CheckAccessControls((AbstractCompiler)compiler, this.options.enforceAccessControlCodingConventions)).setFeatureSetForChecks().build();
    private final PassFactory lintChecks = PassFactory.builderForHotSwap().setName("lintChecks").setInternalFactory(compiler -> {
        ImmutableCollection.Builder callbacks = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(new CheckConstantCaseNames((AbstractCompiler)compiler))).add(new CheckEmptyStatements((AbstractCompiler)compiler))).add(new CheckEnums((AbstractCompiler)compiler))).add(new CheckEs6ModuleFileStructure((AbstractCompiler)compiler))).add(new CheckEs6Modules((AbstractCompiler)compiler))).add(new CheckNoMutatedEs6Exports((AbstractCompiler)compiler))).add(new CheckInterfaces((AbstractCompiler)compiler))).add(new CheckJSDocStyle((AbstractCompiler)compiler))).add(new CheckMissingSemicolon((AbstractCompiler)compiler))).add(new CheckNullabilityModifiers((AbstractCompiler)compiler))).add(new CheckPrimitiveAsObject((AbstractCompiler)compiler))).add(new CheckPrototypeProperties((AbstractCompiler)compiler))).add(new CheckUnusedLabels((AbstractCompiler)compiler))).add(new CheckUselessBlocks((AbstractCompiler)compiler));
        return DefaultPassConfig.combineChecks(compiler, (List<NodeTraversal.Callback>)((Object)((ImmutableList.Builder)callbacks).build()));
    }).setFeatureSetForChecks().build();
    private final PassFactory analyzerChecks = PassFactory.builderForHotSwap().setName("analyzerChecks").setInternalFactory(compiler -> {
        ImmutableList.Builder callbacks = ImmutableList.builder();
        if (this.options.enables(DiagnosticGroups.ANALYZER_CHECKS_INTERNAL)) {
            ((ImmutableList.Builder)((ImmutableList.Builder)callbacks.add(new CheckNullableReturn((AbstractCompiler)compiler))).add(new CheckArrayWithGoogObject((AbstractCompiler)compiler))).add(new ImplicitNullabilityCheck((AbstractCompiler)compiler));
        }
        if (this.options.enables(DiagnosticGroups.UNUSED_PRIVATE_PROPERTY)) {
            callbacks.add(new CheckUnusedPrivateProperties((AbstractCompiler)compiler));
        }
        if (this.options.enables(DiagnosticGroups.MISSING_CONST_PROPERTY)) {
            callbacks.add(new CheckConstPrivateProperties((AbstractCompiler)compiler));
        }
        return DefaultPassConfig.combineChecks(compiler, (List<NodeTraversal.Callback>)((Object)callbacks.build()));
    }).setFeatureSetForChecks().build();
    private final PassFactory checkRequiresAndProvidesSorted = PassFactory.builderForHotSwap().setName("checkRequiresAndProvidesSorted").setInternalFactory(compiler -> DefaultPassConfig.combineChecks(compiler, ImmutableList.of(new CheckProvidesSorted(CheckProvidesSorted.Mode.COLLECT_AND_REPORT), new CheckRequiresSorted(CheckRequiresSorted.Mode.COLLECT_AND_REPORT)))).setFeatureSetForChecks().build();
    private final PassFactory checkGlobalNames = PassFactory.builder().setName("checkGlobalNames").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node jsRoot) {
            DefaultPassConfig.this.namespaceForChecks = new GlobalNamespace(this.val$compiler, externs, jsRoot);
            new CheckGlobalNames(this.val$compiler, DefaultPassConfig.this.options.checkGlobalNamesLevel).injectNamespace(DefaultPassConfig.this.namespaceForChecks).process(externs, jsRoot);
        }
    }).setFeatureSetForChecks().build();
    private final PassFactory checkStrictMode = PassFactory.builder().setName("checkStrictMode").setInternalFactory(StrictModeCheck::new).setFeatureSetForChecks().build();
    private final PassFactory processTweaks = PassFactory.builder().setName("processTweaks").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node jsRoot) {
            new ProcessTweaks(this.val$compiler, DefaultPassConfig.this.options.getTweakProcessing().shouldStrip(), DefaultPassConfig.this.options.getTweakReplacements()).process(externs, jsRoot);
        }
    }).setFeatureSetForChecks().build();
    private final PassFactory processDefines = PassFactory.builder().setName("processDefines").setInternalFactory(compiler -> new ProcessDefines.Builder((AbstractCompiler)compiler).putReplacements(compiler.getDefaultDefineValues()).putReplacements(DefaultPassConfig.getAdditionalReplacements(this.options)).putReplacements(this.options.getDefineReplacements()).checksOnly(this.options.checksOnly).injectNamespace(() -> this.namespaceForChecks).build()).setFeatureSetForChecks().build();
    private final PassFactory stripCode = PassFactory.builder().setName("stripCode").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node jsRoot) {
            CompilerOptions options = this.val$compiler.getOptions();
            StripCode pass = new StripCode(this.val$compiler, options.stripTypes, options.stripNameSuffixes, options.stripTypePrefixes, options.stripNamePrefixes);
            if (options.getTweakProcessing().shouldStrip()) {
                pass.enableTweakStripping();
            }
            pass.process(externs, jsRoot);
        }
    }).setFeatureSetForOptimizations().build();
    final PassFactory garbageCollectChecks = PassFactory.builderForHotSwap().setName("garbageCollectChecks").setInternalFactory(compiler -> new HotSwapCompilerPass(){

        @Override
        public void process(Node externs, Node jsRoot) {
            DefaultPassConfig.this.namespaceForChecks = null;
        }

        @Override
        public void hotSwapScript(Node scriptRoot, Node originalRoot) {
            this.process(null, null);
        }
    }).setFeatureSet(FeatureSet.latest()).build();
    private final PassFactory checkConsts = PassFactory.builder().setName("checkConsts").setInternalFactory(compiler -> new ConstCheck((AbstractCompiler)compiler, compiler.getModuleMetadataMap())).setFeatureSetForChecks().build();
    private final PassFactory checkConstParams = PassFactory.builder().setName("checkConstParams").setInternalFactory(ConstParamCheck::new).setFeatureSetForChecks().build();
    private final PassFactory runtimeTypeCheck = PassFactory.builder().setName("runtimeTypeCheck").setInternalFactory(compiler -> new RuntimeTypeCheck((AbstractCompiler)compiler, this.options.runtimeTypeCheckLogFunction)).setFeatureSet(FeatureSet.ES5).build();
    private final PassFactory replaceIdGenerators = PassFactory.builder().setName("replaceIdGenerators").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node root) {
            ReplaceIdGenerators pass = new ReplaceIdGenerators(this.val$compiler, DefaultPassConfig.this.options.idGenerators, DefaultPassConfig.this.options.generatePseudoNames, DefaultPassConfig.this.options.idGeneratorsMapSerialized, DefaultPassConfig.this.options.xidHashFunction);
            pass.process(externs, root);
            this.val$compiler.setIdGeneratorMap(pass.getSerializedIdMappings());
        }
    }).setFeatureSetForChecks().build();
    private final PassFactory replaceStrings = PassFactory.builder().setName("replaceStrings").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node root) {
            ReplaceStrings pass = new ReplaceStrings(this.val$compiler, DefaultPassConfig.this.options.replaceStringsPlaceholderToken, DefaultPassConfig.this.options.replaceStringsFunctionDescriptions, DefaultPassConfig.this.options.replaceStringsReservedStrings, DefaultPassConfig.this.options.replaceStringsInputMap);
            pass.process(externs, root);
            this.val$compiler.setStringMap(pass.getStringMap());
        }
    }).setFeatureSetForOptimizations().build();
    private final PassFactory optimizeArgumentsArray = PassFactory.builder().setName("optimizeArgumentsArray").setInternalFactory(OptimizeArgumentsArray::new).setFeatureSetForOptimizations().build();
    private final PassFactory closureCodeRemoval = PassFactory.builder().setName("closureCodeRemoval").setInternalFactory(compiler -> new ClosureCodeRemoval((AbstractCompiler)compiler, this.options.removeAbstractMethods, this.options.removeClosureAsserts)).setFeatureSetForOptimizations().build();
    private final PassFactory closureOptimizePrimitives = PassFactory.builder().setName("closureOptimizePrimitives").setInternalFactory(compiler -> new ClosureOptimizePrimitives((AbstractCompiler)compiler, compiler.getOptions().propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED, compiler.getOptions().getOutputFeatureSet().contains(FeatureSet.ES6))).setFeatureSetForOptimizations().build();
    private final PassFactory rescopeGlobalSymbols = PassFactory.builder().setName("rescopeGlobalSymbols").setInternalFactory(compiler -> new RescopeGlobalSymbols((AbstractCompiler)compiler, this.options.renamePrefixNamespace, this.options.renamePrefixNamespaceAssumeCrossChunkNames)).setFeatureSetForOptimizations().build();
    private final PassFactory collapseProperties = PassFactory.builder().setName("collapseProperties").setInternalFactory(compiler -> new CollapseProperties((AbstractCompiler)compiler, this.options.getPropertyCollapseLevel())).setFeatureSetForOptimizations().build();
    private final PassFactory collapseObjectLiterals = PassFactory.builder().setName("collapseObjectLiterals").setRunInFixedPointLoop(true).setInternalFactory(compiler -> new InlineObjectLiterals((AbstractCompiler)compiler, compiler.getUniqueNameIdSupplier())).setFeatureSetForOptimizations().build();
    private final PassFactory disambiguateProperties = PassFactory.builder().setName("disambiguateProperties").setInternalFactory(compiler -> new DisambiguateProperties((AbstractCompiler)compiler, this.options.propertyInvalidationErrors)).setFeatureSetForOptimizations().build();
    private final PassFactory disambiguateProperties2 = PassFactory.builder().setName("disambiguateProperties").setInternalFactory(compiler -> new DisambiguateProperties2((AbstractCompiler)compiler, ImmutableMap.copyOf(this.options.propertyInvalidationErrors))).setFeatureSetForOptimizations().build();
    private final PassFactory devirtualizeMethods = PassFactory.builder().setName("devirtualizeMethods").setInternalFactory(compiler -> OptimizeCalls.builder().setCompiler((AbstractCompiler)compiler).setConsiderExterns(false).addPass(new DevirtualizeMethods((AbstractCompiler)compiler)).build()).setFeatureSetForOptimizations().build();
    private final PassFactory optimizeCalls = PassFactory.builder().setName("optimizeCalls").setRunInFixedPointLoop(true).setInternalFactory(compiler -> OptimizeCalls.builder().setCompiler((AbstractCompiler)compiler).setConsiderExterns(false).addPass(new OptimizeReturns((AbstractCompiler)compiler)).addPass(new OptimizeParameters((AbstractCompiler)compiler)).build()).setFeatureSetForOptimizations().build();
    private final PassFactory markPureFunctions = PassFactory.builder().setName("markPureFunctions").setInternalFactory(PureFunctionIdentifier.Driver::new).setFeatureSetForOptimizations().build();
    private final PassFactory inlineVariables = PassFactory.builder().setName("inlineVariables").setRunInFixedPointLoop(true).setInternalFactory(compiler -> {
        InlineVariables.Mode mode;
        if (this.options.inlineVariables) {
            mode = InlineVariables.Mode.ALL;
        } else if (this.options.inlineLocalVariables) {
            mode = InlineVariables.Mode.LOCALS_ONLY;
        } else {
            throw new IllegalStateException("No variable inlining option set.");
        }
        return new InlineVariables((AbstractCompiler)compiler, mode, true);
    }).setFeatureSetForOptimizations().build();
    private final PassFactory inlineConstants = PassFactory.builder().setName("inlineConstants").setRunInFixedPointLoop(true).setInternalFactory(compiler -> new InlineVariables((AbstractCompiler)compiler, InlineVariables.Mode.CONSTANTS_ONLY, true)).setFeatureSetForOptimizations().build();
    private final PassFactory removeUnreachableCode = PassFactory.builder().setName("removeUnreachableCode").setRunInFixedPointLoop(true).setInternalFactory(UnreachableCodeElimination::new).setFeatureSetForOptimizations().build();
    private final PassFactory inlineSimpleMethods = PassFactory.builder().setName("inlineSimpleMethods").setRunInFixedPointLoop(true).setInternalFactory(InlineSimpleMethods::new).setFeatureSetForOptimizations().build();
    private final PassFactory deadAssignmentsElimination = PassFactory.builder().setName("deadAssignmentsElimination").setRunInFixedPointLoop(true).setInternalFactory(DeadAssignmentsElimination::new).setFeatureSetForOptimizations().build();
    private final PassFactory deadPropertyAssignmentElimination = PassFactory.builder().setName("deadPropertyAssignmentElimination").setRunInFixedPointLoop(true).setInternalFactory(DeadPropertyAssignmentElimination::new).setFeatureSetForOptimizations().build();
    private final PassFactory inlineFunctions = PassFactory.builder().setName("inlineFunctions").setRunInFixedPointLoop(true).setInternalFactory(compiler -> new InlineFunctions((AbstractCompiler)compiler, compiler.getUniqueNameIdSupplier(), this.options.getInlineFunctionsLevel(), this.options.assumeStrictThis() || this.options.expectStrictModeInput(), this.options.assumeClosuresOnlyCaptureReferences, this.options.maxFunctionSizeAfterInlining)).setFeatureSetForOptimizations().build();
    private final PassFactory inlineProperties = PassFactory.builder().setName("inlineProperties").setRunInFixedPointLoop(true).setInternalFactory(InlineProperties::new).setFeatureSetForOptimizations().build();
    private final PassFactory isolatePolyfills = PassFactory.builder().setName("IsolatePolyfills").setInternalFactory(IsolatePolyfills::new).setFeatureSetForOptimizations().build();
    private final PassFactory removeUnusedCode = PassFactory.builder().setName("removeUnusedCode").setRunInFixedPointLoop(true).setInternalFactory(compiler -> new RemoveUnusedCode.Builder((AbstractCompiler)compiler).removeLocalVars(this.options.removeUnusedLocalVars).removeGlobals(this.options.removeUnusedVars).preserveFunctionExpressionNames(false).removeUnusedPrototypeProperties(this.options.removeUnusedPrototypeProperties).removeUnusedThisProperties(this.options.isRemoveUnusedClassProperties()).removeUnusedObjectDefinePropertiesDefinitions(this.options.isRemoveUnusedClassProperties()).removeUnusedPolyfills(this.options.forceLibraryInjection.isEmpty()).assumeGettersArePure(this.options.getAssumeGettersArePure()).build()).setFeatureSetForOptimizations().build();
    private final PassFactory removeUnusedCodeOnce = this.removeUnusedCode.toBuilder().setRunInFixedPointLoop(false).build();
    private final PassFactory crossModuleCodeMotion = PassFactory.builder().setName("crossChunkCodeMotion").setRunInFixedPointLoop(true).setInternalFactory(compiler -> new CrossChunkCodeMotion((AbstractCompiler)compiler, compiler.getModuleGraph(), this.options.parentChunkCanSeeSymbolsDeclaredInChildren)).setFeatureSetForOptimizations().build();
    private final PassFactory crossModuleMethodMotion = PassFactory.builder().setName("crossChunkMethodMotion").setRunInFixedPointLoop(true).setInternalFactory(compiler -> new CrossChunkMethodMotion((AbstractCompiler)compiler, compiler.getCrossModuleIdGenerator(), false, this.options.crossChunkCodeMotionNoStubMethods)).setFeatureSetForOptimizations().build();
    private final PassFactory flowSensitiveInlineVariables = PassFactory.builder().setName("flowSensitiveInlineVariables").setInternalFactory(FlowSensitiveInlineVariables::new).setFeatureSetForOptimizations().build();
    private final PassFactory coalesceVariableNames = PassFactory.builder().setName("coalesceVariableNames").setInternalFactory(compiler -> new CoalesceVariableNames((AbstractCompiler)compiler, this.options.generatePseudoNames)).setFeatureSetForOptimizations().build();
    private final PassFactory exploitAssign = PassFactory.builder().setName("exploitAssign").setInternalFactory(compiler -> new PeepholeOptimizationsPass((AbstractCompiler)compiler, "exploitAssign", new ExploitAssigns())).setFeatureSetForOptimizations().build();
    private final PassFactory collapseVariableDeclarations = PassFactory.builder().setName("collapseVariableDeclarations").setInternalFactory(CollapseVariableDeclarations::new).setFeatureSetForOptimizations().build();
    private final PassFactory extractPrototypeMemberDeclarations = PassFactory.builder().setName("extractPrototypeMemberDeclarations").setInternalFactory(compiler -> {
        ExtractPrototypeMemberDeclarations.Pattern pattern;
        switch (this.options.extractPrototypeMemberDeclarations) {
            case USE_GLOBAL_TEMP: {
                pattern = ExtractPrototypeMemberDeclarations.Pattern.USE_GLOBAL_TEMP;
                break;
            }
            case USE_IIFE: {
                pattern = ExtractPrototypeMemberDeclarations.Pattern.USE_IIFE;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
        return new ExtractPrototypeMemberDeclarations((AbstractCompiler)compiler, pattern);
    }).setFeatureSetForOptimizations().build();
    private final PassFactory rewriteFunctionExpressions = PassFactory.builder().setName("rewriteFunctionExpressions").setInternalFactory(FunctionRewriter::new).setFeatureSetForOptimizations().build();
    private final PassFactory collapseAnonymousFunctions = PassFactory.builder().setName("collapseAnonymousFunctions").setInternalFactory(CollapseAnonymousFunctions::new).setFeatureSetForOptimizations().build();
    private final PassFactory rewriteGlobalDeclarationsForTryCatchWrapping = PassFactory.builder().setName("rewriteGlobalDeclarationsForTryCatchWrapping").setInternalFactory(RewriteGlobalDeclarationsForTryCatchWrapping::new).setFeatureSetForOptimizations().build();
    private final PassFactory aliasStrings = PassFactory.builder().setName("aliasStrings").setInternalFactory(compiler -> new AliasStrings((AbstractCompiler)compiler, compiler.getModuleGraph(), this.options.aliasAllStrings ? null : this.options.aliasableStrings, this.options.aliasStringsBlacklist, this.options.outputJsStringUsage)).setFeatureSetForOptimizations().build();
    private final PassFactory ambiguateProperties = PassFactory.builder().setName("ambiguateProperties").setInternalFactory(compiler -> new AmbiguateProperties((AbstractCompiler)compiler, this.options.getPropertyReservedNamingFirstChars(), this.options.getPropertyReservedNamingNonFirstChars(), compiler.getExternProperties())).setFeatureSetForOptimizations().build();
    private final PassFactory markUnnormalized = PassFactory.builder().setName("markUnnormalized").setInternalFactory(compiler -> new CompilerPass((AbstractCompiler)compiler){
        final /* synthetic */ AbstractCompiler val$compiler;
        {
            this.val$compiler = abstractCompiler;
        }

        @Override
        public void process(Node externs, Node root) {
            this.val$compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.RAW);
        }
    }).setFeatureSetForOptimizations().build();
    private final PassFactory normalize = PassFactory.builder().setName("normalize").setInternalFactory(compiler -> new Normalize((AbstractCompiler)compiler, false)).setFeatureSetForOptimizations().build();
    private final PassFactory externExports = PassFactory.builder().setName("externExports").setInternalFactory(ExternExportsPass::new).setFeatureSetForOptimizations().build();
    private final PassFactory denormalize = PassFactory.builder().setName("denormalize").setInternalFactory(Denormalize::new).setFeatureSetForOptimizations().build();
    private final PassFactory invertContextualRenaming = PassFactory.builder().setName("invertContextualRenaming").setInternalFactory(MakeDeclaredNamesUnique::getContextualRenameInverter).setFeatureSetForOptimizations().build();
    private final PassFactory renameProperties = PassFactory.builder().setName("renameProperties").setInternalFactory(compiler -> {
        Preconditions.checkState(this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED);
        VariableMap prevPropertyMap = this.options.inputPropertyMap;
        return new CompilerPass((AbstractCompiler)compiler, prevPropertyMap){
            final /* synthetic */ AbstractCompiler val$compiler;
            final /* synthetic */ VariableMap val$prevPropertyMap;
            {
                this.val$compiler = abstractCompiler;
                this.val$prevPropertyMap = variableMap;
            }

            @Override
            public void process(Node externs, Node root) {
                RenameProperties rprop = new RenameProperties(this.val$compiler, DefaultPassConfig.this.options.generatePseudoNames, this.val$prevPropertyMap, DefaultPassConfig.this.options.getPropertyReservedNamingFirstChars(), DefaultPassConfig.this.options.getPropertyReservedNamingNonFirstChars(), DefaultPassConfig.this.options.nameGenerator);
                rprop.process(externs, root);
                this.val$compiler.setPropertyMap(rprop.getPropertyMap());
            }
        };
    }).setFeatureSetForOptimizations().build();
    private final PassFactory renameVars = PassFactory.builder().setName("renameVars").setInternalFactory(compiler -> {
        VariableMap prevVariableMap = this.options.inputVariableMap;
        return new CompilerPass((AbstractCompiler)compiler, prevVariableMap){
            final /* synthetic */ AbstractCompiler val$compiler;
            final /* synthetic */ VariableMap val$prevVariableMap;
            {
                this.val$compiler = abstractCompiler;
                this.val$prevVariableMap = variableMap;
            }

            @Override
            public void process(Node externs, Node root) {
                this.val$compiler.setVariableMap(DefaultPassConfig.this.runVariableRenaming(this.val$compiler, this.val$prevVariableMap, externs, root));
            }
        };
    }).setFeatureSetForOptimizations().build();
    private final PassFactory renameLabels = PassFactory.builder().setName("renameLabels").setInternalFactory(RenameLabels::new).setFeatureSetForOptimizations().build();
    private final PassFactory convertToDottedProperties = PassFactory.builder().setName("convertToDottedProperties").setInternalFactory(ConvertToDottedProperties::new).setFeatureSetForOptimizations().build();
    private final PassFactory checkAstValidity = PassFactory.builder().setName("checkAstValidity").setInternalFactory(AstValidator::new).setFeatureSetForChecks().build();
    private final PassFactory varCheckValidity = PassFactory.builder().setName("varCheckValidity").setInternalFactory(compiler -> new VarCheck((AbstractCompiler)compiler, true)).setFeatureSetForChecks().build();
    private final PassFactory instrumentForCodeCoverage = PassFactory.builder().setName("instrumentForCodeCoverage").setInternalFactory(compiler -> new CoverageInstrumentationPass((AbstractCompiler)compiler, CoverageInstrumentationPass.CoverageReach.CONDITIONAL, this.options.getInstrumentForCoverageOption(), this.options.getProductionInstrumentationArrayName())).setFeatureSetForOptimizations().build();
    private final PassFactory gatherExternProperties = PassFactory.builder().setName("gatherExternProperties").setInternalFactory(GatherExternProperties::new).setFeatureSetForChecks().build();
    private final PassFactory polymerPass = PassFactory.builderForHotSwap().setName("polymerPass").setInternalFactory(compiler -> new PolymerPass((AbstractCompiler)compiler, compiler.getOptions().polymerVersion, compiler.getOptions().polymerExportPolicy, compiler.getOptions().propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED)).setFeatureSetForChecks().build();
    private final PassFactory chromePass = PassFactory.builder().setName("chromePass").setInternalFactory(ChromePass::new).setFeatureSetForChecks().build();
    private final PassFactory dartSuperAccessorsPass = PassFactory.builderForHotSwap().setName("dartSuperAccessorsPass").setInternalFactory(DartSuperAccessorsPass::new).setFeatureSetForChecks().build();
    private final PassFactory j2clConstantHoisterPass = PassFactory.builder().setName("j2clConstantHoisterPass").setRunInFixedPointLoop(true).setInternalFactory(J2clConstantHoisterPass::new).setFeatureSetForOptimizations().build();
    private final PassFactory j2clClinitPass = PassFactory.builder().setName("j2clClinitPass").setRunInFixedPointLoop(true).setInternalFactory(compiler -> {
        List<Node> changedScopeNodes = compiler.getChangedScopeNodesForPass("j2clClinitPass");
        return new J2clClinitPrunerPass((AbstractCompiler)compiler, changedScopeNodes);
    }).setFeatureSetForOptimizations().build();
    private final PassFactory j2clPropertyInlinerPass = PassFactory.builder().setName("j2clES6Pass").setInternalFactory(J2clPropertyInlinerPass::new).setFeatureSetForOptimizations().build();
    private final PassFactory j2clPass = PassFactory.builder().setName("j2clPass").setInternalFactory(J2clPass::new).setFeatureSetForChecks().build();
    private final PassFactory j2clUtilGetDefineRewriterPass = PassFactory.builder().setName("j2clUtilGetDefineRewriterPass").setInternalFactory(J2clUtilGetDefineRewriterPass::new).setFeatureSetForOptimizations().build();
    private final PassFactory j2clAssertRemovalPass = PassFactory.builder().setName("j2clAssertRemovalPass").setInternalFactory(J2clAssertRemovalPass::new).setFeatureSetForOptimizations().build();
    private final PassFactory j2clSourceFileChecker = PassFactory.builder().setName("j2clSourceFileChecker").setInternalFactory(J2clSourceFileChecker::new).setFeatureSetForChecks().build();
    private final PassFactory j2clChecksPass = PassFactory.builder().setName("j2clChecksPass").setInternalFactory(J2clChecksPass::new).setFeatureSetForChecks().build();
    private final PassFactory checkConformance = PassFactory.builder().setName("checkConformance").setInternalFactory(compiler -> new CheckConformance((AbstractCompiler)compiler, ImmutableList.copyOf(this.options.getConformanceConfigs()))).setFeatureSetForChecks().build();
    private final PassFactory removeTypes = PassFactory.builder().setName("removeTypes").setInternalFactory(RemoveTypes::new).setFeatureSetForOptimizations().build();
    private final PassFactory optimizeToEs6 = PassFactory.builder().setName("optimizeToEs6").setInternalFactory(SubstituteEs6Syntax::new).setFeatureSetForOptimizations().build();
    private final PassFactory whitespaceWrapGoogModules = PassFactory.builderForHotSwap().setName("whitespaceWrapGoogModules").setInternalFactory(WhitespaceWrapGoogModules::new).setFeatureSetForChecks().build();
    private final PassFactory rewriteCommonJsModules = PassFactory.builder().setName("rewriteCommonJsModules").setInternalFactory(ProcessCommonJSModules::new).setFeatureSetForChecks().build();
    private final PassFactory rewriteScriptsToEs6Modules = PassFactory.builder().setName("rewriteScriptsToEs6Modules").setInternalFactory(Es6RewriteScriptsToModules::new).setFeatureSetForChecks().build();
    private final PassFactory gatherModuleMetadataPass = PassFactory.builderForHotSwap().setName("gatherModuleMetadata").setInternalFactory(compiler -> {
        compiler.getSynthesizedExternsInput();
        return new GatherModuleMetadata((AbstractCompiler)compiler, this.options.processCommonJSModules, this.options.moduleResolutionMode);
    }).setFeatureSetForChecks().build();
    private final PassFactory createModuleMapPass = PassFactory.builderForHotSwap().setName("createModuleMap").setInternalFactory(compiler -> new ModuleMapCreator((AbstractCompiler)compiler, compiler.getModuleMetadataMap())).setFeatureSet(FeatureSet.all()).build();
    private final PassFactory gatherGettersAndSetters = PassFactory.builder().setName("gatherGettersAndSetters").setInternalFactory(GatherGetterAndSetterProperties::new).setFeatureSetForChecks().build();
    private final PassFactory addSyntheticScript = PassFactory.builder().setName("ADD_SYNTHETIC_SCRIPT").setFeatureSet(FeatureSet.all()).setInternalFactory(compiler -> (externs, js) -> compiler.initializeSyntheticCodeInput()).build();
    private final PassFactory removeSyntheticScript = PassFactory.builder().setName("REMOVE_SYNTHETIC_SCRIPT").setFeatureSet(FeatureSet.all()).setInternalFactory(compiler -> (externs, js) -> compiler.removeSyntheticCodeInput()).build();
    private final PassFactory mergeSyntheticScript = PassFactory.builder().setName("MERGE_SYNTHETIC_SCRIPT").setFeatureSet(FeatureSet.all()).setInternalFactory(compiler -> (externs, js) -> compiler.mergeSyntheticCodeInput()).build();

    public DefaultPassConfig(CompilerOptions options) {
        super(options);
    }

    GlobalNamespace getGlobalNamespace() {
        return this.namespaceForChecks;
    }

    @Nullable
    PreprocessorSymbolTable getPreprocessorSymbolTable() {
        return this.preprocessorSymbolTableFactory.getInstanceOrNull();
    }

    void maybeInitializeModuleRewriteState() {
        if (this.options.allowsHotswapReplaceScript() && this.moduleRewriteState == null) {
            this.moduleRewriteState = new ClosureRewriteModule.GlobalRewriteState();
        }
    }

    @Override
    protected List<PassFactory> getTranspileOnlyPasses() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        passes.add(this.markUntranspilableFeaturesAsRemoved);
        passes.add(this.checkVariableReferencesForTranspileOnly);
        passes.add(this.gatherModuleMetadataPass);
        passes.add(this.createModuleMapPass);
        if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            passes.add(this.rewriteGoogJsImports);
            switch (this.options.getEs6ModuleTranspilation()) {
                case COMPILE: {
                    TranspilationPasses.addEs6ModulePass(passes, this.preprocessorSymbolTableFactory);
                    break;
                }
                case TO_COMMON_JS_LIKE_MODULES: {
                    TranspilationPasses.addEs6ModuleToCjsPass(passes);
                    break;
                }
                case RELATIVIZE_IMPORT_PATHS: {
                    TranspilationPasses.addEs6RewriteImportPathPass(passes);
                    break;
                }
            }
        }
        passes.add(this.checkSuper);
        if (this.options.dartPass && this.options.needsTranspilationFrom(FeatureSet.ES6)) {
            passes.add(this.dartSuperAccessorsPass);
        }
        TranspilationPasses.addTranspilationRuntimeLibraries(passes, this.options);
        TranspilationPasses.addPostCheckTranspilationPasses(passes, this.options);
        if (this.options.needsTranspilationFrom(FeatureSet.ES6) && this.options.getRewritePolyfills()) {
            if (this.options.getIsolatePolyfills()) {
                throw new IllegalStateException("Polyfill isolation cannot be used in transpileOnly mode");
            }
            TranspilationPasses.addRewritePolyfillPass(passes);
        }
        passes.add(this.injectRuntimeLibraries);
        DefaultPassConfig.assertAllOneTimePasses(passes);
        this.assertValidOrderForChecks(passes);
        return passes;
    }

    @Override
    protected List<PassFactory> getWhitespaceOnlyPasses() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.processCommonJSModules) {
            passes.add(this.rewriteCommonJsModules);
        } else if (this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            passes.add(this.rewriteScriptsToEs6Modules);
        }
        if (this.options.wrapGoogModulesForWhitespaceOnly) {
            passes.add(this.whitespaceWrapGoogModules);
        }
        return passes;
    }

    private void addModuleRewritingPasses(List<PassFactory> checks, CompilerOptions options) {
        if (options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            checks.add(this.rewriteGoogJsImports);
            TranspilationPasses.addEs6ModulePass(checks, this.preprocessorSymbolTableFactory);
        }
        if (options.closurePass) {
            checks.add(this.closureRewriteModule);
        }
    }

    @Override
    protected List<PassFactory> getChecks() {
        ArrayList<PassFactory> checks = new ArrayList<PassFactory>();
        checks.add(this.syncCompilerFeatures);
        if (this.options.shouldGenerateTypedExterns()) {
            checks.add(this.addSyntheticScript);
            checks.add(this.closureGoogScopeAliasesForIjs);
            checks.add(this.closureRewriteClass);
            checks.add(this.generateIjs);
            checks.add(this.whitespaceWrapGoogModules);
            checks.add(this.removeSyntheticScript);
            return checks;
        }
        checks.add(this.addSyntheticScript);
        if (!this.options.checksOnly) {
            checks.add(this.markUntranspilableFeaturesAsRemoved);
        }
        checks.add(this.gatherGettersAndSetters);
        checks.add(PassFactory.createEmptyPass("beforeStandardChecks"));
        if (!this.options.processCommonJSModules && this.options.getLanguageIn().toFeatureSet().has(FeatureSet.Feature.MODULES)) {
            checks.add(this.rewriteScriptsToEs6Modules);
        }
        checks.add(this.gatherModuleMetadataPass);
        checks.add(this.createModuleMapPass);
        if (this.options.processCommonJSModules) {
            checks.add(this.rewriteCommonJsModules);
        }
        if (this.options.isChromePassEnabled()) {
            checks.add(this.chromePass);
        }
        checks.add(this.checkJsDocAndEs6Modules);
        checks.add(this.checkTypeImportCodeReferences);
        if (this.options.enables(DiagnosticGroups.LINT_CHECKS)) {
            checks.add(this.lintChecks);
        }
        if (this.options.closurePass && this.options.enables(DiagnosticGroups.LINT_CHECKS)) {
            checks.add(this.checkRequiresAndProvidesSorted);
        }
        if (this.options.enables(DiagnosticGroups.EXTRA_REQUIRE)) {
            checks.add(this.extraRequires);
        }
        if (this.options.enables(DiagnosticGroups.MISSING_REQUIRE) || this.options.enables(DiagnosticGroups.STRICT_MISSING_REQUIRE)) {
            checks.add(this.missingAndExtraRequires);
        }
        if (this.options.enables(DiagnosticGroups.STRICTER_MISSING_REQUIRE)) {
            checks.add(this.checkMissingRequires);
        }
        checks.add(this.checkVariableReferences);
        checks.add(this.declaredGlobalExternsOnWindow);
        if (!this.options.processCommonJSModules) {
            checks.add(this.checkVars);
        }
        if (this.options.closurePass) {
            checks.add(this.checkClosureImports);
        }
        checks.add(this.checkStrictMode);
        if (this.options.closurePass) {
            checks.add(this.closureCheckModule);
        }
        checks.add(this.checkSuper);
        if (this.options.closurePass) {
            checks.add(this.closureRewriteClass);
        }
        checks.add(this.checkSideEffects);
        if (this.options.enables(DiagnosticGroups.MISSING_PROVIDE)) {
            checks.add(this.checkProvides);
        }
        if (this.options.angularPass) {
            checks.add(this.angularPass);
        }
        if (this.options.closurePass) {
            checks.add(this.closureGoogScopeAliases);
        }
        if (this.options.shouldRewriteModulesBeforeTypechecking()) {
            this.addModuleRewritingPasses(checks, this.options);
        }
        if (this.options.closurePass) {
            checks.add(this.closurePrimitives);
            if (this.options.shouldRewriteModulesBeforeTypechecking()) {
                checks.add(this.closureProvidesRequires);
            }
        }
        if (this.options.polymerVersion != null) {
            checks.add(this.polymerPass);
        }
        if (this.options.syntheticBlockStartMarker != null) {
            checks.add(this.createSyntheticBlocks);
        }
        if (this.options.processCommonJSModules) {
            checks.add(this.checkVars);
        }
        if (this.options.inferConsts) {
            checks.add(this.inferConsts);
        }
        if (this.options.computeFunctionSideEffects) {
            checks.add(this.checkRegExp);
        }
        if (this.options.dartPass && !this.options.getOutputFeatureSet().contains(FeatureSet.ES6)) {
            checks.add(this.dartSuperAccessorsPass);
        }
        checks.add(PassFactory.createEmptyPass("beforePreTypeCheckTranspilation"));
        TranspilationPasses.addTranspilationRuntimeLibraries(checks, this.options);
        if ((this.options.rewritePolyfills || this.options.getIsolatePolyfills()) && !this.options.checksOnly) {
            TranspilationPasses.addRewritePolyfillPass(checks);
        }
        checks.add(this.injectRuntimeLibraries);
        checks.add(PassFactory.createEmptyPass("beforeTypeChecking"));
        if (this.options.checkTypes || this.options.inferTypes) {
            checks.add(this.inferTypes);
            if (this.options.checkTypes) {
                checks.add(this.checkTypes);
            } else {
                checks.add(this.inferJsDocInfo);
            }
        }
        if (!this.options.preservesDetailedSourceInfo() && !this.options.allowsHotswapReplaceScript()) {
            checks.add(this.clearTypedScopeCreatorPass);
        }
        if (this.options.shouldRewriteModulesAfterTypechecking()) {
            this.addModuleRewritingPasses(checks, this.options);
            if (this.options.closurePass) {
                checks.add(this.closureProvidesRequires);
            }
        }
        if (!this.options.preservesDetailedSourceInfo() && !this.options.allowsHotswapReplaceScript()) {
            checks.add(this.clearTopTypedScopePass);
        }
        if (this.options.checkSuspiciousCode || this.options.enables(DiagnosticGroups.GLOBAL_THIS) || this.options.enables(DiagnosticGroups.DEBUGGER_STATEMENT_PRESENT)) {
            checks.add(this.suspiciousCode);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            checks.add(this.j2clSourceFileChecker);
        }
        if (!this.options.disables(DiagnosticGroups.CHECK_USELESS_CODE) || !this.options.disables(DiagnosticGroups.MISSING_RETURN)) {
            checks.add(this.checkControlFlow);
        }
        if (this.options.isTypecheckingEnabled() && (!this.options.disables(DiagnosticGroups.ACCESS_CONTROLS) || this.options.enables(DiagnosticGroups.CONSTANT_PROPERTY))) {
            checks.add(this.checkAccessControls);
        }
        checks.add(this.checkConsts);
        if (this.options.enables(DiagnosticGroups.ANALYZER_CHECKS) && this.options.isTypecheckingEnabled()) {
            checks.add(this.analyzerChecks);
        }
        if (this.options.checkGlobalNamesLevel.isOn()) {
            checks.add(this.checkGlobalNames);
        }
        if (!this.options.getConformanceConfigs().isEmpty()) {
            checks.add(this.checkConformance);
        }
        if (this.options.closurePass && !this.options.shouldPreserveGoogLibraryPrimitives()) {
            checks.add(this.closureReplaceGetCssName);
        }
        if (this.options.getTweakProcessing().isOn()) {
            checks.add(this.processTweaks);
        }
        if (this.options.checksOnly) {
            checks.add(this.processDefines);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            checks.add(this.j2clChecksPass);
        }
        if (this.options.shouldRunTypeSummaryChecksLate()) {
            checks.add(this.generateIjs);
        }
        if (this.options.generateExports) {
            checks.add(this.generateExports);
        }
        checks.add(PassFactory.createEmptyPass("afterStandardChecks"));
        if (this.options.checksOnly) {
            checks.add(this.removeSyntheticScript);
        } else if (!this.options.checksOnly) {
            checks.add(this.mergeSyntheticScript);
            if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
                checks.add(this.j2clPass);
            }
            if (this.options.exportTestFunctions) {
                checks.add(this.exportTestFunctions);
            }
            TranspilationPasses.addPostCheckTranspilationPasses(checks, this.options);
        }
        DefaultPassConfig.assertAllOneTimePasses(checks);
        this.assertValidOrderForChecks(checks);
        checks.add(PassFactory.createEmptyPass("beforeSerialization"));
        return checks;
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.skipNonTranspilationPasses) {
            return passes;
        }
        passes.add(this.removeWeakSources);
        if (!this.options.allowsHotswapReplaceScript()) {
            passes.add(this.inlineTypeAliases);
        }
        passes.add(this.garbageCollectChecks);
        if (this.options.replaceMessagesWithChromeI18n) {
            passes.add(this.replaceMessagesForChrome);
        } else if (this.options.messageBundle != null) {
            passes.add(this.replaceMessages);
        }
        passes.add(this.processDefines);
        if (!(!this.options.getTweakProcessing().shouldStrip() && this.options.stripTypes.isEmpty() && this.options.stripNameSuffixes.isEmpty() && this.options.stripTypePrefixes.isEmpty() && this.options.stripNamePrefixes.isEmpty())) {
            passes.add(this.stripCode);
        }
        passes.add(this.normalize);
        if (this.options.isExternExportsEnabled() || this.options.externExportsPath != null) {
            passes.add(this.externExports);
        }
        passes.add(this.gatherExternProperties);
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            passes.add(this.j2clUtilGetDefineRewriterPass);
        }
        if (this.options.getInstrumentForCoverageOption() != CompilerOptions.InstrumentOption.NONE) {
            passes.add(this.instrumentForCodeCoverage);
        }
        if (this.options.runtimeTypeCheck) {
            passes.add(this.runtimeTypeCheck);
        }
        passes.add(PassFactory.createEmptyPass("beforeStandardOptimizations"));
        if (this.options.replaceIdGenerators) {
            passes.add(this.replaceIdGenerators);
        }
        if (this.options.optimizeArgumentsArray) {
            passes.add(this.optimizeArgumentsArray);
        }
        if (this.options.closurePass && (this.options.removeAbstractMethods || this.options.removeClosureAsserts)) {
            passes.add(this.closureCodeRemoval);
        }
        if (this.options.removeJ2clAsserts) {
            passes.add(this.j2clAssertRemovalPass);
        }
        DefaultPassConfig.assertAllOneTimePasses(passes);
        if (this.options.getPropertyCollapseLevel() == CompilerOptions.PropertyCollapseLevel.ALL) {
            if (this.options.needsTranspilationFrom(FeatureSet.ES6)) {
                passes.add(this.convertStaticInheritance);
            }
            passes.add(this.aggressiveInlineAliases);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses() && this.options.getPropertyCollapseLevel() == CompilerOptions.PropertyCollapseLevel.ALL) {
            passes.add(this.j2clPropertyInlinerPass);
        }
        if (this.options.getPropertyCollapseLevel() != CompilerOptions.PropertyCollapseLevel.NONE) {
            passes.add(this.collapseProperties);
        }
        if (this.options.inferConsts) {
            passes.add(this.inferConsts);
        }
        passes.add(this.checkConstParams);
        if (this.options.smartNameRemoval) {
            if (this.options.foldConstants && (this.options.inlineVariables || this.options.inlineLocalVariables)) {
                passes.add(this.earlyInlineVariables);
                passes.add(this.earlyPeepholeOptimizations);
            }
            passes.add(this.removeUnusedCodeOnce);
        }
        if (this.options.shouldDisambiguateProperties() && this.options.isTypecheckingEnabled()) {
            if (this.options.shouldUseGraphBasedDisambiguator()) {
                passes.add(this.disambiguateProperties2);
            } else {
                passes.add(this.disambiguateProperties);
            }
        }
        if (this.options.computeFunctionSideEffects) {
            passes.add(this.markPureFunctions);
        }
        if (this.options.smartNameRemoval) {
            passes.addAll(this.getCodeRemovingPasses());
        }
        if (this.options.closurePass) {
            passes.add(this.closureOptimizePrimitives);
        }
        if (!this.options.replaceStringsFunctionDescriptions.isEmpty()) {
            passes.add(this.replaceStrings);
        }
        if (this.options.shouldRunCrossChunkCodeMotion()) {
            passes.add(this.crossModuleCodeMotion);
        }
        if (this.options.devirtualizeMethods) {
            passes.add(this.devirtualizeMethods);
        }
        if (this.options.customPasses != null) {
            passes.add(this.getCustomPasses(CustomPassExecutionTime.BEFORE_OPTIMIZATION_LOOP));
        }
        passes.add(PassFactory.createEmptyPass("beforeMainOptimizations"));
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.add(this.flowSensitiveInlineVariables);
        }
        passes.addAll(this.getMainOptimizationLoop());
        passes.add(PassFactory.createEmptyPass("afterMainOptimizations"));
        passes.add(PassFactory.createEmptyPass("beforeModuleMotion"));
        if (this.options.shouldRunCrossChunkCodeMotion()) {
            passes.add(this.crossModuleCodeMotion);
        }
        if (this.options.shouldRunCrossChunkMethodMotion()) {
            passes.add(this.crossModuleMethodMotion);
        }
        passes.add(PassFactory.createEmptyPass("afterModuleMotion"));
        if (this.options.customPasses != null) {
            passes.add(this.getCustomPasses(CustomPassExecutionTime.AFTER_OPTIMIZATION_LOOP));
        }
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.add(this.flowSensitiveInlineVariables);
            if (this.shouldRunRemoveUnusedCode()) {
                passes.add(this.removeUnusedCodeOnce);
            }
        }
        if (this.options.getIsolatePolyfills()) {
            passes.add(this.isolatePolyfills);
        }
        if (this.options.collapseAnonymousFunctions) {
            passes.add(this.collapseAnonymousFunctions);
        }
        if (this.options.rewriteGlobalDeclarationsForTryCatchWrapping || this.options.renamePrefixNamespace != null) {
            passes.add(this.rewriteGlobalDeclarationsForTryCatchWrapping);
        }
        if (this.options.extractPrototypeMemberDeclarations != CompilerOptions.ExtractPrototypeMemberDeclarationsMode.OFF) {
            passes.add(this.extractPrototypeMemberDeclarations);
        }
        if (this.options.shouldAmbiguateProperties() && this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED && this.options.isTypecheckingEnabled()) {
            passes.add(this.ambiguateProperties);
        }
        if (!this.options.shouldUnsafelyPreserveTypesForDebugging()) {
            passes.add(this.removeTypes);
        }
        if (this.options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED) {
            passes.add(this.renameProperties);
        }
        if (this.options.reserveRawExports) {
            passes.add(this.gatherRawExports);
        }
        if (this.options.convertToDottedProperties) {
            passes.add(this.convertToDottedProperties);
        }
        if (this.options.rewriteFunctionExpressions) {
            passes.add(this.rewriteFunctionExpressions);
        }
        if (!this.options.aliasableStrings.isEmpty() || this.options.aliasAllStrings) {
            passes.add(this.aliasStrings);
        }
        if (this.options.coalesceVariableNames) {
            passes.add(this.coalesceVariableNames);
            if (this.options.foldConstants) {
                passes.add(this.peepholeOptimizationsOnce);
            }
        }
        passes.add(this.markUnnormalized);
        if (this.options.collapseVariableDeclarations) {
            passes.add(this.exploitAssign);
            passes.add(this.collapseVariableDeclarations);
        }
        passes.add(this.denormalize);
        if (this.options.variableRenaming != VariableRenamingPolicy.ALL) {
            passes.add(this.invertContextualRenaming);
        }
        if (this.options.variableRenaming != VariableRenamingPolicy.OFF) {
            passes.add(this.renameVars);
        }
        if (this.options.labelRenaming) {
            passes.add(this.renameLabels);
        }
        if (this.options.foldConstants) {
            passes.add(this.latePeepholeOptimizations);
        }
        if (this.options.shouldProtectHiddenSideEffects()) {
            passes.add(this.stripSideEffectProtection);
        }
        if (this.options.renamePrefixNamespace != null) {
            if (!GLOBAL_SYMBOL_NAMESPACE_PATTERN.matcher(this.options.renamePrefixNamespace).matches()) {
                throw new IllegalArgumentException("Illegal character in renamePrefixNamespace name: " + this.options.renamePrefixNamespace);
            }
            passes.add(this.rescopeGlobalSymbols);
        }
        passes.add(this.checkAstValidity);
        passes.add(this.varCheckValidity);
        if (this.options.getOutputFeatureSet().contains(FeatureSet.ES6)) {
            passes.add(this.optimizeToEs6);
        }
        this.assertValidOrderForOptimizations(passes);
        return passes;
    }

    private List<PassFactory> getMainOptimizationLoop() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.inlineGetters) {
            passes.add(this.inlineSimpleMethods);
        }
        passes.addAll(this.getCodeRemovingPasses());
        if (this.options.getInlineFunctionsLevel() != CompilerOptions.Reach.NONE) {
            passes.add(this.inlineFunctions);
        }
        if (this.options.shouldInlineProperties() && this.options.isTypecheckingEnabled()) {
            passes.add(this.inlineProperties);
        }
        if ((this.options.removeUnusedVars || this.options.removeUnusedLocalVars) && this.options.deadAssignmentElimination) {
            passes.add(this.deadAssignmentsElimination);
            if (this.options.polymerVersion == null) {
                passes.add(this.deadPropertyAssignmentElimination);
            }
        }
        if (this.options.optimizeCalls) {
            passes.add(this.optimizeCalls);
        }
        if (this.options.j2clPassMode.shouldAddJ2clPasses()) {
            passes.add(this.j2clConstantHoisterPass);
            passes.add(this.j2clClinitPass);
        }
        DefaultPassConfig.assertAllLoopablePasses(passes);
        return passes;
    }

    private List<PassFactory> getCodeRemovingPasses() {
        ArrayList<PassFactory> passes = new ArrayList<PassFactory>();
        if (this.options.collapseObjectLiterals) {
            passes.add(this.collapseObjectLiterals);
        }
        if (this.options.inlineVariables || this.options.inlineLocalVariables) {
            passes.add(this.inlineVariables);
        } else if (this.options.inlineConstantVars) {
            passes.add(this.inlineConstants);
        }
        if (this.options.foldConstants) {
            passes.add(this.peepholeOptimizations);
        }
        if (this.options.removeDeadCode) {
            passes.add(this.removeUnreachableCode);
        }
        if (this.shouldRunRemoveUnusedCode()) {
            passes.add(this.removeUnusedCode);
        }
        DefaultPassConfig.assertAllLoopablePasses(passes);
        return passes;
    }

    private boolean shouldRunRemoveUnusedCode() {
        return this.options.removeUnusedVars || this.options.removeUnusedLocalVars || this.options.removeUnusedPrototypeProperties || this.options.isRemoveUnusedClassProperties() || this.options.rewritePolyfills;
    }

    private static void assertAllOneTimePasses(List<PassFactory> passes) {
        for (PassFactory pass : passes) {
            Preconditions.checkState(!pass.isRunInFixedPointLoop());
        }
    }

    private static void assertAllLoopablePasses(List<PassFactory> passes) {
        for (PassFactory pass : passes) {
            Preconditions.checkState(pass.isRunInFixedPointLoop());
        }
    }

    private void assertPassOrder(List<PassFactory> passList, PassFactory pass1, PassFactory pass2, String msg) {
        int pass1Index = passList.indexOf(pass1);
        int pass2Index = passList.indexOf(pass2);
        if (pass1Index != -1 && pass2Index != -1) {
            Preconditions.checkState(pass1Index < pass2Index, msg);
        }
    }

    private void assertValidOrderForChecks(List<PassFactory> checks) {
        this.assertPassOrder(checks, this.declaredGlobalExternsOnWindow, this.checkVars, "declaredGlobalExternsOnWindow must happen before VarCheck, which adds synthetic externs");
        this.assertPassOrder(checks, this.chromePass, this.checkJsDocAndEs6Modules, "The ChromePass must run before after JsDoc and Es6 module checking.");
        this.assertPassOrder(checks, this.closureRewriteModule, this.processDefines, "Must rewrite goog.module before processing @define's, so that @defines in modules work.");
        this.assertPassOrder(checks, this.closurePrimitives, this.polymerPass, "The Polymer pass must run after goog.provide processing.");
        this.assertPassOrder(checks, this.chromePass, this.polymerPass, "The Polymer pass must run after ChromePass processing.");
        this.assertPassOrder(checks, this.polymerPass, this.suspiciousCode, "The Polymer pass must run before suspiciousCode processing.");
        this.assertPassOrder(checks, this.dartSuperAccessorsPass, TranspilationPasses.es6ConvertSuper, "The Dart super accessors pass must run before ES6->ES3 super lowering.");
        this.assertPassOrder(checks, this.addSyntheticScript, this.gatherModuleMetadataPass, "Cannot add a synthetic script node after module metadata creation.");
        this.assertPassOrder(checks, this.closureRewriteModule, this.removeSyntheticScript, "Synthetic script node should be removed only after module rewriting.");
        if (checks.contains(this.closureGoogScopeAliases)) {
            Preconditions.checkState(checks.contains(this.checkVariableReferences), "goog.scope processing requires variable checking");
        }
        this.assertPassOrder(checks, this.checkVariableReferences, this.closureGoogScopeAliases, "Variable checking must happen before goog.scope processing.");
        this.assertPassOrder(checks, this.gatherModuleMetadataPass, this.closureCheckModule, "Need to gather module metadata before checking closure modules.");
        this.assertPassOrder(checks, this.gatherModuleMetadataPass, this.createModuleMapPass, "Need to gather module metadata before scanning modules.");
        this.assertPassOrder(checks, this.createModuleMapPass, this.rewriteCommonJsModules, "Need to gather module information before rewriting CommonJS modules.");
        this.assertPassOrder(checks, this.rewriteScriptsToEs6Modules, this.gatherModuleMetadataPass, "Need to gather module information after rewriting scripts to modules.");
        this.assertPassOrder(checks, this.gatherModuleMetadataPass, this.checkMissingRequires, "Need to gather module information before checking for missing requires.");
        this.assertPassOrder(checks, this.j2clPass, TranspilationPasses.rewriteGenerators, "J2CL normalization should be done before generator re-writing.");
    }

    private void assertValidOrderForOptimizations(List<PassFactory> optimizations) {
        this.assertPassOrder(optimizations, this.processDefines, this.j2clUtilGetDefineRewriterPass, "J2CL define re-writing should be done after processDefines since it relies on collectDefines which has side effects.");
        this.assertPassOrder(optimizations, this.removeUnusedCode, this.isolatePolyfills, "Polyfill isolation should be done after RemovedUnusedCode. Otherwise unused polyfill removal will not find any polyfill usages and will delete all polyfills.");
    }

    private static CompilerPass createPeepholeOptimizationsPass(AbstractCompiler compiler, String passName) {
        boolean late = false;
        boolean useTypesForOptimization = compiler.getOptions().useTypesForLocalOptimization;
        ArrayList<AbstractPeepholeOptimization> optimizations = new ArrayList<AbstractPeepholeOptimization>();
        optimizations.add(new MinimizeExitPoints());
        optimizations.add(new PeepholeMinimizeConditions(false));
        optimizations.add(new PeepholeSubstituteAlternateSyntax(false));
        optimizations.add(new PeepholeReplaceKnownMethods(false, useTypesForOptimization));
        optimizations.add(new PeepholeRemoveDeadCode());
        if (compiler.getOptions().j2clPassMode.shouldAddJ2clPasses()) {
            optimizations.add(new J2clEqualitySameRewriterPass(useTypesForOptimization));
            optimizations.add(new J2clStringValueOfRewriterPass());
        }
        optimizations.add(new PeepholeFoldConstants(false, useTypesForOptimization));
        optimizations.add(new PeepholeCollectPropertyAssignments());
        return new PeepholeOptimizationsPass(compiler, passName, optimizations);
    }

    private static HotSwapCompilerPass combineChecks(AbstractCompiler compiler, List<NodeTraversal.Callback> callbacks) {
        Preconditions.checkArgument(!callbacks.isEmpty());
        return new CombinedCompilerPass(compiler, callbacks);
    }

    private VariableMap runVariableRenaming(AbstractCompiler compiler, VariableMap prevVariableMap, Node externs, Node root) {
        char[] reservedChars = null;
        HashSet<String> reservedNames = new HashSet<String>();
        if (this.options.renamePrefixNamespace != null) {
            reservedNames.add(this.options.renamePrefixNamespace);
        }
        reservedNames.addAll(compiler.getExportedNames());
        reservedNames.addAll(ParserRunner.getReservedVars());
        RenameVars rn = new RenameVars(compiler, this.options.renamePrefix, this.options.variableRenaming == VariableRenamingPolicy.LOCAL, false, this.options.generatePseudoNames, this.options.preferStableNames, prevVariableMap, reservedChars, reservedNames, this.options.nameGenerator);
        rn.process(externs, root);
        return rn.getVariableMap();
    }

    private PassFactory getCustomPasses(CustomPassExecutionTime executionTime) {
        return PassFactory.builder().setName("runCustomPasses").setInternalFactory(compiler -> DefaultPassConfig.runInSerial(this.options.customPasses.get(executionTime))).setFeatureSetForOptimizations().build();
    }

    private static CompilerPass runInSerial(final Collection<CompilerPass> passes) {
        return new CompilerPass(){

            @Override
            public void process(Node externs, Node root) {
                for (CompilerPass pass : passes) {
                    pass.process(externs, root);
                }
            }
        };
    }

    @VisibleForTesting
    static Map<String, Node> getAdditionalReplacements(CompilerOptions options) {
        HashMap<String, Node> additionalReplacements = new HashMap<String, Node>();
        if (options.markAsCompiled || options.closurePass) {
            additionalReplacements.put(COMPILED_CONSTANT_NAME, IR.trueNode());
        }
        if (options.closurePass && options.locale != null) {
            additionalReplacements.put(CLOSURE_LOCALE_CONSTANT_NAME, IR.string(options.locale));
        }
        return additionalReplacements;
    }

    class ClearTopTypedScope
    implements CompilerPass {
        ClearTopTypedScope() {
        }

        @Override
        public void process(Node externs, Node root) {
            DefaultPassConfig.this.clearTopTypedScope();
        }
    }

    class ClearTypedScopeCreator
    implements CompilerPass {
        ClearTypedScopeCreator() {
        }

        @Override
        public void process(Node externs, Node root) {
            DefaultPassConfig.this.clearTypedScopeCreator();
        }
    }
}

