/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

final class PolymerPassFindExterns
implements NodeTraversal.Callback {
    private static final String POLYMER_ELEMENT_NAME = "PolymerElement";
    private Node polymerElementExterns;
    private final ImmutableList.Builder<Node> polymerElementProps = ImmutableList.builder();

    PolymerPassFindExterns() {
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        return !n.isScript() || !NodeUtil.isFromTypeSummary(n);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (PolymerPassFindExterns.isPolymerElementExterns(n)) {
            this.polymerElementExterns = n;
        } else if (PolymerPassFindExterns.isPolymerElementPropExpr(n)) {
            this.polymerElementProps.add((Object)n);
        }
    }

    ImmutableList<Node> getPolymerElementProps() {
        return this.polymerElementProps.build();
    }

    Node getPolymerElementExterns() {
        return this.polymerElementExterns;
    }

    private static boolean isPolymerElementExterns(Node value) {
        return NodeUtil.isNameDeclaration(value) && value.getFirstChild().matchesQualifiedName(POLYMER_ELEMENT_NAME);
    }

    private static boolean isPolymerElementPropExpr(Node value) {
        return value != null && value.isExprResult() && value.getFirstFirstChild() != null && value.getFirstFirstChild().isGetProp() && value.getFirstFirstChild().isQualifiedName() && NodeUtil.getRootOfQualifiedName(value.getFirstFirstChild()).matchesQualifiedName(POLYMER_ELEMENT_NAME);
    }
}

