/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.disambiguate;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.DoNotCall;
import com.google.javascript.jscomp.colors.Color;
import java.util.BitSet;

final class ColorGraphNode {
    private final Color color;
    private final int id;
    private final BitSet subtypeIds = new BitSet();

    static ColorGraphNode create(Color single, int id) {
        Preconditions.checkNotNull(single);
        Preconditions.checkArgument(id >= 0);
        return new ColorGraphNode(single, id);
    }

    @VisibleForTesting
    static ColorGraphNode createForTesting(int id) {
        Preconditions.checkArgument(id < 0);
        return new ColorGraphNode(null, id);
    }

    private ColorGraphNode(Color single, int id) {
        this.id = id;
        this.color = single;
    }

    Color getColor() {
        return Preconditions.checkNotNull(this.color);
    }

    int getId() {
        return this.id;
    }

    BitSet getSubtypeIds() {
        return this.subtypeIds;
    }

    @DoNotCall
    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("color", this.color).toString();
    }
}

