/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.refactoring.Matchers;
import com.google.javascript.refactoring.NodeMetadata;
import com.google.javascript.rhino.Node;

public class RefactoringUtils {
    private RefactoringUtils() {
    }

    public static boolean isInClosurizedFile(Node node, NodeMetadata metadata) {
        Node script = NodeUtil.getEnclosingScript(node);
        if (script == null) {
            return false;
        }
        for (Node child = script.getFirstChild(); child != null; child = child.getNext()) {
            if (NodeUtil.isExprCall(child)) {
                Node firstChild = child.getFirstChild();
                if (!Matchers.googRequire().matches(firstChild, metadata) && !Matchers.googModuleOrProvide().matches(firstChild, metadata)) continue;
                return true;
            }
            if (!child.isVar() || !child.getBooleanProp(Node.IS_NAMESPACE)) continue;
            return true;
        }
        return false;
    }
}

